<p align="center">
  <img src="https://cdn-icons-png.flaticon.com/512/6295/6295417.png" width="100" alt="project-logo">
</p>
<p align="center">
    <h1 align="center">CHATGPT-APP-REACT-NATIVE-TYPESCRIPT</h1>
</p>
<p align="center">
    <em>React Native Messaging Excellence!</em>
</p>
<p align="center">
	<img src="https://img.shields.io/github/license/Yuberley/ChatGPT-App-React-Native-TypeScript?style=flat-square&logo=opensourceinitiative&logoColor=white&&color=00aaaa" alt="license">
	<img src="https://img.shields.io/github/last-commit/Yuberley/ChatGPT-App-React-Native-TypeScript?style=flat-square&logo=git&logoColor=white&&color=00aaaa" alt="last-commit">
	<img src="https://img.shields.io/github/languages/top/Yuberley/ChatGPT-App-React-Native-TypeScript?style=flat-square&&color=00aaaa" alt="repo-top-language">
	<img src="https://img.shields.io/github/languages/count/Yuberley/ChatGPT-App-React-Native-TypeScript?style=flat-square&&color=00aaaa" alt="repo-language-count">
<p>
<p align="center">
		<em>Developed with the software and tools below.</em>
</p>
<p align="center">
	<img src="https://img.shields.io/badge/JavaScript-F7DF1E.svg?style=flat-square&logo=JavaScript&logoColor=black" alt="JavaScript">
	<img src="https://img.shields.io/badge/Nodemon-76D04B.svg?style=flat-square&logo=Nodemon&logoColor=white" alt="Nodemon">
	<img src="https://img.shields.io/badge/React-61DAFB.svg?style=flat-square&logo=React&logoColor=black" alt="React">
	<img src="https://img.shields.io/badge/OpenAI-412991.svg?style=flat-square&logo=OpenAI&logoColor=white" alt="OpenAI">
	<img src="https://img.shields.io/badge/TypeScript-3178C6.svg?style=flat-square&logo=TypeScript&logoColor=white" alt="TypeScript">
	<img src="https://img.shields.io/badge/Expo-000020.svg?style=flat-square&logo=Expo&logoColor=white" alt="Expo">
	<img src="https://img.shields.io/badge/JSON-000000.svg?style=flat-square&logo=JSON&logoColor=white" alt="JSON">
	<img src="https://img.shields.io/badge/Express-000000.svg?style=flat-square&logo=Express&logoColor=white" alt="Express">
</p>

<!-- TABLE OF CONTENTS -->
<details>
  <summary>Table of Contents</summary>

- [📍 Overview](#-overview)
- [📦 Features](#-features)
- [📂 Repository Structure](#-repository-structure)
- [🧩 Modules](#-modules)
- [🚀 Getting Started](#-getting-started)
  - [⚙️ Install](#️-install)
  - [► Using ChatGPT-App-React-Native-TypeScript](#-using-ChatGPT-App-React-Native-TypeScript)
  - [🧪 Tests](#-tests)
- [🛠 Project Roadmap](#-project-roadmap)
- [🔰 Contributing](#-contributing)
- [📄 License](#-license)
- [👏 Acknowledgments](#-acknowledgments)
</details>
<hr>

## 📍 Overview

The ChatGPT-App-React-Native-TypeScript project is a mobile application built with React Native and TypeScript. It facilitates real-time chat interactions with an AI-powered chatbot. Users can input messages, receive responses generated by a machine learning model, and view chat history in a user-friendly interface. The project enhances user engagement through dynamic message handling, efficient data fetching, and seamless navigation. Key components include message input, display management, data context, and server integration, all contributing to a robust chat experience.

---

## 📦 Features

|    |   Feature         | Description |
|----|-------------------|---------------------------------------------------------------|
| ⚙️  | **Architecture**  | This project is built using React Native and TypeScript, following a structured architecture that includes components, screens, hooks, and server files to handle chat interactions. It leverages Expo for cross-platform development, ensuring a seamless user experience. |
| 🔩 | **Code Quality**  | The codebase maintains a good level of quality with well-organized components, clear naming conventions, and consistent code style. TypeScript is used for type safety and improved code readability, enhancing overall maintainability. |
| 📄 | **Documentation** | The project includes detailed README files and comments within the codebase, aiding developers in understanding the architecture and implementation details. However, additional documentation on code structure and design decisions would be beneficial. |
| 🔌 | **Integrations**  | Key integrations include OpenAI for message generation, Express for backend server setup, and various React Native libraries for UI components and navigation. External dependencies like react-native-screens and react-uuid enhance functionality and user experience. |
| 🧩 | **Modularity**    | The codebase exhibits modularity through separate components, hooks, and screens, promoting code reusability. Data context management and global constants contribute to a cohesive architecture that can easily accommodate future enhancements or feature additions. |
| 🧪 | **Testing**       | Testing frameworks and tools are not explicitly mentioned in the project details. Incorporating unit tests using tools like Jest and React Testing Library could improve code reliability and facilitate future development. |
| ⚡️  | **Performance**   | The efficiency of the application is supported by real-time chat functionalities, server-side processing, and optimized data fetching. Resource usage is well managed, but performance testing under varying loads could provide further insights into scalability. |
| 🛡️ | **Security**      | Security measures like environment variable configuration for sensitive data (e.g., API keys) and server-side message processing enhance data protection. However, additional security practices such as input validation and encryption could further fortify the application. |
| 📦 | **Dependencies**  | Key dependencies include React Native, TypeScript, Expo, Express, OpenAI, and various React Native libraries for UI components. Configuration files like package.json and tsconfig.json manage dependencies and project settings effectively. |

---

## 📂 Repository Structure

```sh
└── ChatGPT-App-React-Native-TypeScript/
    ├── App.tsx
    ├── LICENSE
    ├── README.md
    ├── app.json
    ├── assets
    │   ├── adaptive-icon.png
    │   ├── favicon.png
    │   ├── icon.png
    │   └── splash.png
    ├── components
    │   ├── InputMessage.tsx
    │   ├── Layout.tsx
    │   ├── ListMessage.tsx
    │   └── Message.tsx
    ├── constants
    │   └── constants.ts
    ├── context
    │   └── DataProvider.tsx
    ├── data
    │   └── messages.ts
    ├── helpers
    │   └── getMessage.ts
    ├── hooks
    │   └── useFetchMessage.ts
    ├── others
    │   └── screen.png
    ├── package-lock.json
    ├── package.json
    ├── screens
    │   ├── HomeScreen.tsx
    │   └── Infomation.tsx
    ├── server
    │   ├── .gitignore
    │   ├── config.js
    │   ├── index.js
    │   ├── package-lock.json
    │   └── package.json
    ├── tsconfig.json
    └── types
        └── types.d.ts
```

---

## 🧩 Modules

<details closed><summary>.</summary>

| File                                                                                                               | Summary                                                                                                                                                                                                      |
| ---                                                                                                                | ---                                                                                                                                                                                                          |
| [App.tsx](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/blob/master/App.tsx)                     | Implements a basic navigation structure for ChatGPT AI app using React Native, facilitating user interaction and information access.                                                                         |
| [app.json](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/blob/master/app.json)                   | Configure app details like name, icons, and splash screen for ChatGPT-App across different platforms using the Expo configuration file, app.json.                                                            |
| [package-lock.json](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/blob/master/package-lock.json) | Implements real-time chat functionalities in a React Native app using TypeScript, enhancing user engagement within the parent repository's architecture.                                                     |
| [package.json](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/blob/master/package.json)           | Manage dependencies and project configurations for a React Native ChatGPT app utilizing Expo. Facilitate app functionality, navigation, and data handling through specified versions and package inclusions. |
| [tsconfig.json](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/blob/master/tsconfig.json)         | Configures TypeScript strict mode for the Expo project in tsconfig.json, ensuring robust type checking and better code reliability within the React Native app.                                              |

</details>

<details closed><summary>types</summary>

| File                                                                                                       | Summary                                                                                                                      |
| ---                                                                                                        | ---                                                                                                                          |
| [types.d.ts](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/blob/master/types/types.d.ts) | Defines the structure for message objects in the ChatGPT app, including user details, message content, and usage statistics. |

</details>

<details closed><summary>context</summary>

| File                                                                                                                     | Summary                                                                             |
| ---                                                                                                                      | ---                                                                                 |
| [DataProvider.tsx](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/blob/master/context/DataProvider.tsx) | Manages data context for React components, initializing and updating message input. |

</details>

<details closed><summary>constants</summary>

| File                                                                                                               | Summary                                                                          |
| ---                                                                                                                | ---                                                                              |
| [constants.ts](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/blob/master/constants/constants.ts) | Global constant `API_URL` for backend server connection in the React Native app. |

</details>

<details closed><summary>server</summary>

| File                                                                                                                      | Summary                                                                                                                                                                                 |
| ---                                                                                                                       | ---                                                                                                                                                                                     |
| [index.js](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/blob/master/server/index.js)                   | A server file leveraging Express and OpenAI APIs to handle chat interactions, including message generation based on user input.                                                         |
| [config.js](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/blob/master/server/config.js)                 | Configures environment variables for the OpenAI API key and organization within the ChatGPT-App-React-Native-TypeScript repository structure.                                           |
| [package-lock.json](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/blob/master/server/package-lock.json) | Implements real-time chat functionality using React Native Gifted Chat library in the ChatGPT mobile app, enabling users to communicate seamlessly within the application architecture. |
| [package.json](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/blob/master/server/package.json)           | Express server setup for ChatGPT React Native app with nodemon auto-restart, CORS support, body parsing, and OpenAI integration.                                                        |

</details>

<details closed><summary>screens</summary>

| File                                                                                                                 | Summary                                                                                                                                                 |
| ---                                                                                                                  | ---                                                                                                                                                     |
| [Infomation.tsx](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/blob/master/screens/Infomation.tsx) | Displays an Infomation screen layout using React Native, presenting centered text within a container.                                                   |
| [HomeScreen.tsx](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/blob/master/screens/HomeScreen.tsx) | Compose the HomeScreen component; integrates ListMessage and InputMessage within a Layout, key to the ChatGPT-App-React-Native-TypeScript architecture. |

</details>

<details closed><summary>components</summary>

| File                                                                                                                        | Summary                                                                                                                                                     |
| ---                                                                                                                         | ---                                                                                                                                                         |
| [InputMessage.tsx](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/blob/master/components/InputMessage.tsx) | Component enabling user input and message sending in ChatGPT app. Dynamically updates message state and triggers message sending with user-defined content. |
| [Layout.tsx](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/blob/master/components/Layout.tsx)             | Layout component for ChatGPT app providing a styled container with status bar setup, maintaining consistent UI across screens.                              |
| [Message.tsx](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/blob/master/components/Message.tsx)           | Generates styled chat message components for React Native app, includes user avatar, name, text, and clipboard functionality.                               |
| [ListMessage.tsx](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/blob/master/components/ListMessage.tsx)   | Manages message display with real-time updates and user input integration in the React Native app. Handles data fetching, rendering, and refreshing.        |

</details>

<details closed><summary>hooks</summary>

| File                                                                                                                       | Summary                                                                                                                                                                                          |
| ---                                                                                                                        | ---                                                                                                                                                                                              |
| [useFetchMessage.ts](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/blob/master/hooks/useFetchMessage.ts) | Handles fetching messages based on user input, managing loading state efficiently using React hooks. Establishes a stateful data structure to track message data and loading status dynamically. |

</details>

<details closed><summary>helpers</summary>

| File                                                                                                               | Summary                                                                                                                                                |
| ---                                                                                                                | ---                                                                                                                                                    |
| [getMessage.ts](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/blob/master/helpers/getMessage.ts) | Handles fetching chat messages from an API using given user input, leveraging machine learning model for text generation based on parameters provided. |

</details>

---

## 🚀 Getting Started

***Requirements***

Ensure you have the following dependencies installed on your system:

* **TypeScript**: `version x.y.z`

### ⚙️ Install

1. Clone the ChatGPT-App-React-Native-TypeScript repository:

```sh
git clone https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript
```

2. Change to the project directory:

```sh
cd ChatGPT-App-React-Native-TypeScript
```

3. Install the dependencies:

```sh
npm install
```

### ► Using `ChatGPT-App-React-Native-TypeScript`

Use the following command to run ChatGPT-App-React-Native-TypeScript:

```sh
npm run build && node dist/main.js
```

### 🧪 Tests

Use the following command to run tests:

```sh
npm test
```

---

## 🛠 Project Roadmap

- [X] `► INSERT-TASK-1`
- [ ] `► INSERT-TASK-2`
- [ ] `► ...`

---

## 🔰 Contributing

Contributions are welcome! Here are several ways you can contribute:

- **[Report Issues](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/issues)**: Submit bugs found or log feature requests for the `ChatGPT-App-React-Native-TypeScript` project.
- **[Submit Pull Requests](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/blob/main/CONTRIBUTING.md)**: Review open PRs, and submit your own PRs.
- **[Join the Discussions](https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript/discussions)**: Share your insights, provide feedback, or ask questions.

<details closed>
<summary>Contributing Guidelines</summary>

1. **Fork the Repository**: Start by forking the project repository to your github account.
2. **Clone Locally**: Clone the forked repository to your local machine using a git client.
   ```sh
   git clone https://github.com/Yuberley/ChatGPT-App-React-Native-TypeScript
   ```
3. **Create a New Branch**: Always work on a new branch, giving it a descriptive name.
   ```sh
   git checkout -b new-feature-x
   ```
4. **Make Your Changes**: Develop and test your changes locally.
5. **Commit Your Changes**: Commit with a clear message describing your updates.
   ```sh
   git commit -m 'Implemented new feature x.'
   ```
6. **Push to github**: Push the changes to your forked repository.
   ```sh
   git push origin new-feature-x
   ```
7. **Submit a Pull Request**: Create a PR against the original project repository. Clearly describe the changes and their motivations.
8. **Review**: Once your PR is reviewed and approved, it will be merged into the main branch. Congratulations on your contribution!
</details>

<details closed>
<summary>Contributor Graph</summary>
<br>
<p align="center">
   <a href="https://github.com{/Yuberley/ChatGPT-App-React-Native-TypeScript/}graphs/contributors">
      <img src="https://contrib.rocks/image?repo=Yuberley/ChatGPT-App-React-Native-TypeScript">
   </a>
</p>
</details>

---

## 📄 License

This project is protected under the [SELECT-A-LICENSE](https://choosealicense.com/licenses) License. For more details, refer to the [LICENSE](https://choosealicense.com/licenses/) file.

---

## 👏 Acknowledgments

- List any resources, contributors, inspiration, etc. here.

[**Return**](#-overview)

---
