<p align="left">
  <img src="https://raw.githubusercontent.com/PKief/vscode-material-icon-theme/ec559a9f6bfd399b82bb44393651661b08aaf7ba/icons/folder-markdown-open.svg" width="20%" alt="README-AI-logo">
</p>
<p align="left">
    <h1 align="left">README-AI</h1>
</p>
<p align="left">
    <em>Where Documentation Meets Innovation!</em>
</p>
<p align="left">
	<img src="https://img.shields.io/github/license/eli64s/readme-ai?style=flat&logo=opensourceinitiative&logoColor=white&color=60A5FA" alt="license">
	<img src="https://img.shields.io/github/last-commit/eli64s/readme-ai?style=flat&logo=git&logoColor=white&color=60A5FA" alt="last-commit">
	<img src="https://img.shields.io/github/languages/top/eli64s/readme-ai?style=flat&color=60A5FA" alt="repo-top-language">
	<img src="https://img.shields.io/github/languages/count/eli64s/readme-ai?style=flat&color=60A5FA" alt="repo-language-count">
</p>
<p align="left">
		<em>Built with the tools and technologies:</em>
</p>
<p align="left">
	<img src="https://img.shields.io/badge/precommit-FAB040.svg?style=flat&logo=pre-commit&logoColor=black" alt="precommit">
	<img src="https://img.shields.io/badge/Ruff-FCC21B.svg?style=flat&logo=Ruff&logoColor=black" alt="Ruff">
	<img src="https://img.shields.io/badge/GNU%20Bash-4EAA25.svg?style=flat&logo=GNU-Bash&logoColor=white" alt="GNU%20Bash">
	<img src="https://img.shields.io/badge/Pytest-0A9EDC.svg?style=flat&logo=Pytest&logoColor=white" alt="Pytest">
	<img src="https://img.shields.io/badge/Docker-2496ED.svg?style=flat&logo=Docker&logoColor=white" alt="Docker">
	<img src="https://img.shields.io/badge/Python-3776AB.svg?style=flat&logo=Python&logoColor=white" alt="Python">
	<img src="https://img.shields.io/badge/GitHub%20Actions-2088FF.svg?style=flat&logo=GitHub-Actions&logoColor=white" alt="GitHub%20Actions">
	<br>
	<img src="https://img.shields.io/badge/Poetry-60A5FA.svg?style=flat&logo=Poetry&logoColor=white" alt="Poetry">
	<img src="https://img.shields.io/badge/AIOHTTP-2C5BB4.svg?style=flat&logo=AIOHTTP&logoColor=white" alt="AIOHTTP">
	<img src="https://img.shields.io/badge/Material%20for%20MkDocs-526CFE.svg?style=flat&logo=Material-for-MkDocs&logoColor=white" alt="Material%20for%20MkDocs">
	<img src="https://img.shields.io/badge/OpenAI-412991.svg?style=flat&logo=OpenAI&logoColor=white" alt="OpenAI">
	<img src="https://img.shields.io/badge/Google%20Gemini-8E75B2.svg?style=flat&logo=Google-Gemini&logoColor=white" alt="Google%20Gemini">
	<img src="https://img.shields.io/badge/Pydantic-E92063.svg?style=flat&logo=Pydantic&logoColor=white" alt="Pydantic">
</p>
<br>

<details><summary>Table of Contents</summary>

- [📍 Overview](#overview)
- [👾 Features](#features)
- [📁 Project Structure](#project-structure)
  - [📂 Project Index](#project-index)
- [🚀 Getting Started](#getting-started)
  - [📋 Prerequisites](#prerequisites)
  - [⚙️ Installation](#installation)
  - [🤖 Usage](#-usage)
  - [🧪 Tests](#-tests)
- [📌 Roadmap](#roadmap)
- [🔰 Contributing](#-contributing)
- [🎗 License](#license)
- [🙌 Acknowledgments](#acknowledgments)

</details>
<hr>

## 📍 Overview

README-AI is a cutting-edge open-source project designed to revolutionize the way software projects are documented. By harnessing the power of AI language models, README-AI automates the generation of comprehensive README files, empowering developers to create polished and informative documentation effortlessly. The project's core value proposition lies in streamlining the documentation process, saving time and effort while ensuring high-quality and consistent documentation across projects.

README-AI caters to a broad audience of developers, from beginners looking to enhance their project presentation to seasoned professionals seeking to boost productivity and maintain best practices. With its intuitive setup and seamless integration into existing workflows, README-AI is set to become an indispensable tool for anyone looking to elevate their project documentation to the next level.

---

## 👾 Features

|      | Feature         | Summary       |
| :--- | :---:           | :---          |
| ⚙️  | **Architecture**  | <ul><li>Flexible architecture leveraging various technologies like AIOHTTP, Pydantic, and more</li><li>Modular design promoting scalability and maintainability</li><li>Utilizes Anthropic and Google Generative AI for advanced features</li></ul> |
| 🔩 | **Code Quality**  | <ul><li>Extensive test coverage with pytest and pytest-asyncio</li><li>Static type checking with Mypy</li><li>Pre-commit hooks for enforcing code standards</li></ul> |
| 📄 | **Documentation** | <ul><li>Rich documentation in multiple formats including TOML, YAML, JSON, and Markdown</li><li>Utilizes MkDocs for generating beautiful and interactive documentation</li><li>Includes detailed installation commands using Poetry, Pip, and Conda</li></ul> |
| 🔌 | **Integrations**  | <ul><li>Integration with GitHub Actions for CI/CD workflows</li><li>Utilizes Docker for containerization</li><li>Includes shields.io icons for visual representation of integrations</li></ul> |
| 🧩 | **Modularity**    | <ul><li>Well-structured codebase with clear separation of concerns</li><li>Uses Pydantic for data validation and parsing</li><li>Promotes reusability and extensibility through modular components</li></ul> |
| 🧪 | **Testing**       | <ul><li>Comprehensive testing strategy with pytest and pytest-cov for coverage tracking</li><li>Async testing supported with pytest-asyncio</li><li>Randomized testing with pytest-randomly for robust test cases</li></ul> |
| ⚡️  | **Performance**   | <ul><li>Optimized performance using tenacity for retry strategies</li><li>Efficient handling of asynchronous requests with AIOHTTP</li><li>Utilizes pytest-xdist for parallel test execution</li></ul> |
| 🛡️ | **Security**      | <ul><li>Secure coding practices with GitPython for version control</li><li>Handles sensitive data securely with prompts.toml</li><li>Dependency scanning for vulnerabilities with PyUp Safety</li></ul> |
| 📦 | **Dependencies**  | <ul><li>Diverse set of dependencies including Python, Docker, MkDocs, Poetry, and more</li><li>Dependency management with Poetry and Conda for reproducible environments</li><li>Dependency visualization using dependency graphs</li></ul> |

---

## 📁 Project Structure

```sh
└── readme-ai/
    ├── .github
    │   ├── release-drafter.yml
    │   └── workflows
    ├── CHANGELOG.md
    ├── CODE_OF_CONDUCT.md
    ├── CONTRIBUTING.md
    ├── Dockerfile
    ├── LICENSE
    ├── Makefile
    ├── README.md
    ├── docs
    │   ├── css
    │   ├── docs
    │   ├── js
    │   └── overrides
    ├── examples
    │   ├── images
    │   └── markdown
    ├── mkdocs.yml
    ├── noxfile.py
    ├── poetry.lock
    ├── pyproject.toml
    ├── readmeai
    │   ├── __init__.py
    │   ├── __main__.py
    │   ├── _exceptions.py
    │   ├── cli
    │   ├── config
    │   ├── core
    │   ├── generators
    │   ├── models
    │   ├── parsers
    │   ├── templates
    │   ├── utils
    │   └── vcs
    ├── scripts
    │   ├── clean.sh
    │   ├── docker.sh
    │   ├── pypi.sh
    │   └── run_batch.sh
    ├── setup
    │   ├── environment.yaml
    │   ├── requirements.txt
    │   └── setup.sh
    └── tests
        ├── __init__.py
        ├── cli
        ├── config
        ├── conftest.py
        ├── core
        ├── generators
        ├── models
        ├── parsers
        ├── templates
        ├── test_exceptions.py
        ├── test_main.py
        ├── utils
        └── vcs
```

### 📂 Project Index

<details open>
	<summary><b><code>README-AI/</code></b></summary>
	<details> <!-- __root__ Submodule -->
		<summary><b>__root__</b></summary>
		<blockquote>
			<table>
			<tr>
				<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/mkdocs.yml'>mkdocs.yml</a></b></td>
				<td>- Configure README-AI MkDocs site settings for documentation, including site name, description, author, and repository details<br>- Define site structure, navigation, features, and styling with themes, fonts, and plugins for better user experience.</td>
			</tr>
			<tr>
				<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/Dockerfile'>Dockerfile</a></b></td>
				<td>- Facilitates the setup and configuration of a Python environment for the project using a slim Buster image<br>- Installs necessary dependencies, creates a dedicated user, and sets the entry point for the readmeai tool.</td>
			</tr>
			<tr>
				<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/Makefile'>Makefile</a></b></td>
				<td>- Facilitates project management and automation tasks, such as cleaning artifacts, creating Conda recipes, building Docker images, displaying git logs, and running tests<br>- Supports codebase maintenance with linting, formatting, and exporting dependencies<br>- Additionally, enables searching for specific words in the codebase and serving documentation.</td>
			</tr>
			<tr>
				<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/pyproject.toml'>pyproject.toml</a></b></td>
				<td>- Generates README files using large language model APIs, supporting AI documentation, badge and markdown generation<br>- The file defines project metadata, dependencies, scripts, and test configurations, contributing to the project's structure and functionality.</td>
			</tr>
			<tr>
				<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/noxfile.py'>noxfile.py</a></b></td>
				<td>- Configure Nox to run tests across multiple Python versions, ensuring the package is installed in the current session<br>- The code sets up testing against Python 3.9, 3.10, 3.11, and 3.12, installing necessary dependencies and running the test suite with coverage reports<br>- This file streamlines testing and package installation processes for the project.</td>
			</tr>
			</table>
		</blockquote>
	</details>
	<details> <!-- setup Submodule -->
		<summary><b>setup</b></summary>
		<blockquote>
			<table>
			<tr>
				<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/setup/setup.sh'>setup.sh</a></b></td>
				<td>- Facilitates environment setup by checking dependencies, creating a new conda environment if needed, and installing required packages<br>- Ensures Python compatibility and sets up the 'readmeai' environment for project execution<br>- Handles installation of missing tools like 'tree' and provides clear setup instructions for users.</td>
			</tr>
			<tr>
				<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/setup/requirements.txt'>requirements.txt</a></b></td>
				<td>Define project dependencies in `requirements.txt` to manage Python package versions.</td>
			</tr>
			<tr>
				<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/setup/environment.yaml'>environment.yaml</a></b></td>
				<td>Define project dependencies and environment configuration through the setup file, ensuring consistent package management and Python version compatibility across the codebase architecture.</td>
			</tr>
			</table>
		</blockquote>
	</details>
	<details> <!-- scripts Submodule -->
		<summary><b>scripts</b></summary>
		<blockquote>
			<table>
			<tr>
				<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/scripts/run_batch.sh'>run_batch.sh</a></b></td>
				<td>Generates markdown files with diverse badges, aligning styles, and images for various repositories using dynamic data arrays for customization.</td>
			</tr>
			<tr>
				<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/scripts/pypi.sh'>pypi.sh</a></b></td>
				<td>- Automates the deployment process to PyPI for the project, ensuring a seamless distribution of the package<br>- The script cleans, builds, and uploads the distribution files, streamlining the release workflow.</td>
			</tr>
			<tr>
				<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/scripts/clean.sh'>clean.sh</a></b></td>
				<td>- The `clean.sh` script file in the project architecture removes various artifacts like build, test, and Python file artifacts, enhancing project cleanliness<br>- It provides functions to clean different types of files and directories, ensuring a tidy codebase<br>- This script simplifies the process of removing unnecessary files and caches, maintaining a clean development environment.</td>
			</tr>
			<tr>
				<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/scripts/docker.sh'>docker.sh</a></b></td>
				<td>- Automates Docker image building, pushing, and multi-platform support<br>- Executes Docker buildx setup, image building, pushing, and multi-platform image building.</td>
			</tr>
			</table>
		</blockquote>
	</details>
	<details> <!-- .github Submodule -->
		<summary><b>.github</b></summary>
		<blockquote>
			<table>
			<tr>
				<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/.github/release-drafter.yml'>release-drafter.yml</a></b></td>
				<td>Define release versioning conventions and categorization labels for automated release drafting based on commit messages in the project.</td>
			</tr>
			</table>
			<details>
				<summary><b>workflows</b></summary>
				<blockquote>
					<table>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/.github/workflows/coverage.yml'>coverage.yml</a></b></td>
						<td>Automates code coverage reporting to Codecov for every push and pull request, ensuring visibility into test coverage metrics.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/.github/workflows/mkdocs.yml'>mkdocs.yml</a></b></td>
						<td>- Automates deployment of MkDocs to GitHub Pages upon push or pull request events<br>- Sets up Python environment, installs dependencies using Poetry, builds MkDocs site, and deploys to GitHub Pages<br>- Facilitates seamless publishing of project documentation.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/.github/workflows/release-pipeline.yml'>release-pipeline.yml</a></b></td>
						<td>- Automates deployment to PyPI and Docker Hub on main branch push or release creation<br>- Installs dependencies, builds and publishes to PyPI, and pushes Docker image to Docker Hub with multi-platform support.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/.github/workflows/release-drafter.yml'>release-drafter.yml</a></b></td>
						<td>- Automates release notes drafting based on PR merges to main branch, using Release Drafter GitHub Action<br>- Handles PR events for label updates and release creation with required permissions<br>- Supports customization via config file and environment variables.</td>
					</tr>
					</table>
				</blockquote>
			</details>
		</blockquote>
	</details>
	<details> <!-- readmeai Submodule -->
		<summary><b>readmeai</b></summary>
		<blockquote>
			<table>
			<tr>
				<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/_exceptions.py'>_exceptions.py</a></b></td>
				<td>- Define custom exceptions for the readme-ai package, including errors for README generation, CLI, file system operations, and unsupported LLM services<br>- The exceptions provide a structured way to handle and communicate errors within the project architecture.</td>
			</tr>
			<tr>
				<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/__main__.py'>__main__.py</a></b></td>
				<td>- Generates README files by processing a repository and extracting dependencies and raw files<br>- Updates configuration settings, retrieves API responses, and builds the README file using the provided configuration<br>- The process is handled asynchronously, ensuring efficient and accurate README generation.</td>
			</tr>
			</table>
			<details>
				<summary><b>parsers</b></summary>
				<blockquote>
					<table>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/parsers/properties.py'>properties.py</a></b></td>
						<td>Extracts configuration information from .properties files, including jdbc connection strings and other packages, to support parsing and handling of configuration data in the project architecture.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/parsers/factory.py'>factory.py</a></b></td>
						<td>- Abstract factory module that provides callable file parser methods for various project file types, including Python, C/C++, JavaScript/Node.js, Kotlin, Go, Java, Rust, Swift, and Docker<br>- Handles parsing of specific file formats to support diverse codebase architectures.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/parsers/docker.py'>docker.py</a></b></td>
						<td>- Parse Docker configuration files extracting package names and services<br>- The code defines parsers for Dockerfile and docker-compose.yaml, capturing dependencies and services respectively<br>- This functionality aids in analyzing and managing Docker configurations within the project architecture.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/parsers/npm.py'>npm.py</a></b></td>
						<td>- The code file `npm.py` provides parsers for npm-related dependency files within the project architecture<br>- It includes parsers for extracting dependencies from `package.json` and `yarn.lock` files<br>- These parsers facilitate the extraction of package names from the respective dependency files, contributing to the overall functionality of the project's dependency management system.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/parsers/cpp.py'>cpp.py</a></b></td>
						<td>- Parse C/C++ project dependency files for CMake, configure.ac, and Makefile using dedicated parsers<br>- Extract dependencies, libraries, and software details from respective file types to streamline project setup and management.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/parsers/gradle.py'>gradle.py</a></b></td>
						<td>- Parse Gradle and Gradle.kts dependency files to extract package names for the project's build configuration<br>- The code in the provided file helps identify and collect package names defined in these files, facilitating dependency management within the project structure.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/parsers/yarn.py'>yarn.py</a></b></td>
						<td>Extracts package names from a yarn.lock file to facilitate dependency management within the project architecture.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/parsers/swift.py'>swift.py</a></b></td>
						<td>Parse Swift Package.swift files to extract package names for dependencies, aiding in project dependency management.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/parsers/python.py'>python.py</a></b></td>
						<td>- The Python code file in `readmeai/parsers/python.py` provides parsers for various types of dependency files in the project, such as requirements.txt, TOML, and YAML files<br>- These parsers extract package names from the respective dependency files, catering to different build systems like Pipenv, Poetry, Flit, and environment.yml.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/parsers/go.py'>go.py</a></b></td>
						<td>Parse go.mod files to extract package names for dependency management in the project architecture.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/parsers/maven.py'>maven.py</a></b></td>
						<td>- Parse Maven pom.xml files to extract package names, checking for Spring dependencies<br>- If parsing error occurs, handle it gracefully.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/parsers/rust.py'>rust.py</a></b></td>
						<td>Parse Rust cargo.toml dependency files to extract package names.</td>
					</tr>
					</table>
				</blockquote>
			</details>
			<details>
				<summary><b>core</b></summary>
				<blockquote>
					<table>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/core/models.py'>models.py</a></b></td>
						<td>- Manages the lifecycle of the HTTP client, generates prompts, and processes responses for Large Language Model (LLM) API handlers<br>- Handles batch requests, including code summaries for each file in the project<br>- Controls the flow of requests and responses to interact with the LLM API effectively.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/core/preprocess.py'>preprocess.py</a></b></td>
						<td>Generates metadata by processing repository files, extracting dependencies, and mapping programming languages.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/core/parsers.py'>parsers.py</a></b></td>
						<td>- Defines an abstract base class for dependency file parsers in the codebase architecture<br>- It provides a standardized approach for parsing file content and handling parsing errors, ensuring consistency across different parser implementations.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/core/logger.py'>logger.py</a></b></td>
						<td>- Implementing a custom logger with color and emoji support, the code file enhances logging functionality for the readme-ai package<br>- It offers a structured approach to logging messages at different levels, aiding in better visibility and understanding of the application's runtime behavior.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/core/utils.py'>utils.py</a></b></td>
						<td>- Facilitates configuration of LLM API environments by setting specific variables based on the selected LLM service<br>- Handles scenarios where required API keys are missing, switches to offline mode if necessary, and logs environment settings<br>- Essential for ensuring proper setup and functionality of the LLM services within the project architecture.</td>
					</tr>
					</table>
				</blockquote>
			</details>
			<details>
				<summary><b>config</b></summary>
				<blockquote>
					<table>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/config/settings.py'>settings.py</a></b></td>
						<td>- Defines Pydantic models and settings for the readme-ai package, including API, file paths, Git repository, Markdown templates, and model configurations<br>- Parses and sets attributes for the Git repository, generates file URLs, and validates badge colors<br>- Loads configuration settings from TOML files for comprehensive customization.</td>
					</tr>
					</table>
					<details>
						<summary><b>settings</b></summary>
						<blockquote>
							<table>
							<tr>
								<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/config/settings/prompts.toml'>prompts.toml</a></b></td>
								<td>- **Facilitates**: Generate structured prompts for analyzing key technical aspects of the project.
- **Enables**: Describe project architecture, code quality, documentation, integrations, modularity, testing, performance, security, dependencies, and scalability in a concise format.
- **Aids**: Provide a quick overview of critical project details in a Markdown table for easy reference.</td>
							</tr>
							<tr>
								<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/config/settings/parsers.toml'>parsers.toml</a></b></td>
								<td>Parse and analyze project configuration and dependency files to facilitate the architecture of the entire codebase.</td>
							</tr>
							<tr>
								<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/config/settings/quickstart.toml'>quickstart.toml</a></b></td>
								<td>- The code file provided at `readmeai/config/settings/quickstart.toml` defines default configurations for tools, including installation, run, test instructions, shields, and website links<br>- This file plays a crucial role in setting up quickstart configurations for different tools within the project, ensuring consistency and ease of use across the codebase architecture.</td>
							</tr>
							<tr>
								<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/config/settings/languages.toml'>languages.toml</a></b></td>
								<td>Define programming language extensions and their corresponding names for better codebase organization and readability.</td>
							</tr>
							<tr>
								<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/config/settings/config.toml'>config.toml</a></b></td>
								<td>- The code file configures default settings, file resources, Git repository settings, language model API settings, Markdown templates, badges, and more for the project<br>- It centralizes key configurations and resources essential for the project's functionality and integrations.</td>
							</tr>
							<tr>
								<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/config/settings/markdown.toml'>markdown.toml</a></b></td>
								<td>Generates Markdown templates for constructing a README.md file by defining header, badges, skills, overview, features, directory structure, codebase summaries, quickstart, usage, project roadmap, contributing guidelines, license, acknowledgments, and contact sections.</td>
							</tr>
							<tr>
								<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/config/settings/ignore_list.toml'>ignore_list.toml</a></b></td>
								<td>Define exclusion criteria for preprocessing by specifying directories, file extensions, and names to be ignored, enhancing project cleanliness and efficiency.</td>
							</tr>
							<tr>
								<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/config/settings/commands.toml'>commands.toml</a></b></td>
								<td>- Defines programming language commands for installation, running, and testing across various languages<br>- Facilitates consistent setup and execution processes for different language environments within the project.</td>
							</tr>
							</table>
						</blockquote>
					</details>
				</blockquote>
			</details>
			<details>
				<summary><b>utils</b></summary>
				<blockquote>
					<table>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/utils/file_handler.py'>file_handler.py</a></b></td>
						<td>Enables reading and writing various file types seamlessly within the project, abstracting file I/O operations through a unified interface.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/utils/text_cleaner.py'>text_cleaner.py</a></b></td>
						<td>- Clean and format LLM API responses by post-processing the text<br>- Remove unnecessary characters, reformat Markdown tables, and ensure consistent text formatting for better readability and presentation<br>- The code enhances the user experience by improving the clarity and structure of the generated text output from the API.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/utils/file_resources.py'>file_resources.py</a></b></td>
						<td>- Enables retrieval of resource file paths within the package, prioritizing `importlib.resources` for modern environments and falling back to `pkg_resources` for compatibility<br>- Handles errors and returns the absolute path to the resource file.</td>
					</tr>
					</table>
				</blockquote>
			</details>
			<details>
				<summary><b>models</b></summary>
				<blockquote>
					<table>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/models/offline.py'>offline.py</a></b></td>
						<td>- Handles offline mode for the CLI when no LLM API service is available<br>- Inherits from BaseModelHandler and sets default values for offline operation<br>- Provides placeholder text in lieu of LLM API responses.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/models/gemini.py'>gemini.py</a></b></td>
						<td>- Implements Google Cloud's Gemini API handler for generating text responses<br>- Handles API requests, processes responses, and returns generated text<br>- Includes functionality for building payload, making API requests, and logging responses.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/models/tokens.py'>tokens.py</a></b></td>
						<td>- Implements tokenization and truncation functions for text handling, ensuring text length constraints are met based on specified token limits<br>- The code optimizes token count for input text, adjusting it as needed to adhere to defined token thresholds.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/models/dalle.py'>dalle.py</a></b></td>
						<td>- Generates and downloads images using OpenAI's DALL-E model, based on project configuration data<br>- Handles API sessions, formats prompt strings, and makes requests to generate images<br>- Provides functionality to download images from given URLs.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/models/factory.py'>factory.py</a></b></td>
						<td>- Selects appropriate LLM API service based on CLI input to return the corresponding handler<br>- The ModelRegistry class contains a mapping of CLI input options to handler classes, allowing for dynamic selection and instantiation of the desired API service handler.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/models/prompts.py'>prompts.py</a></b></td>
						<td>- Generates and formats prompts for the LLM API by retrieving templates and injecting context<br>- Handles additional prompt generation for features, overview, and slogan based on project settings and dependencies.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/models/openai.py'>openai.py</a></b></td>
						<td>- Implements an OpenAI API handler with Ollama support, setting up configuration for LLM handlers<br>- Builds payload for POST requests to OpenAI API and processes responses to return generated text<br>- Handles retries for request errors and logs generated text.</td>
					</tr>
					</table>
				</blockquote>
			</details>
			<details>
				<summary><b>cli</b></summary>
				<blockquote>
					<table>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/cli/options.py'>options.py</a></b></td>
						<td>- Defines command-line interface options for the readme-ai package, allowing users to customize README file generation<br>- Options include selecting a model backend, specifying image styles, setting badge configurations, and defining output file details<br>- Enables seamless integration with various Large Language Models (LLMs) and shields.io badges.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/cli/main.py'>main.py</a></b></td>
						<td>- Entrypoint function for the readme-ai CLI application, orchestrating the interaction between the CLI and the readme_agent function<br>- Handles command-line arguments to configure various aspects of the readme generation process, ensuring seamless execution of the CLI tool within the project architecture.</td>
					</tr>
					</table>
				</blockquote>
			</details>
			<details>
				<summary><b>vcs</b></summary>
				<blockquote>
					<table>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/vcs/ingestor.py'>ingestor.py</a></b></td>
						<td>- Implements functions for cloning, copying, and removing directories, as well as retrieving repositories<br>- Handles Git errors and exceptions gracefully, logging and raising appropriate errors<br>- Supports Windows and Unix systems for directory operations.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/vcs/metadata.py'>metadata.py</a></b></td>
						<td>- Retrieve metadata of a git repository from the host provider's API<br>- The code fetches GitHub repository details, including statistics, URLs, programming languages, and license information<br>- It converts raw repository data into a structured dataclass for easy access and processing within the project's architecture.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/vcs/url_builder.py'>url_builder.py</a></b></td>
						<td>- Implements Git repository URL validation, parsing, and API endpoint generation based on the provided URL<br>- Parses the URL to extract host, name, and full name attributes<br>- Validates the URL and creates a GitURL object<br>- Generates the REST API endpoint URL for the repository and file URLs.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/vcs/providers.py'>providers.py</a></b></td>
						<td>- Defines Git hosting services and provides functions to parse repository URLs and generate file URLs for various providers, including GitHub, GitLab, Bitbucket, and local repositories<br>- The code facilitates handling different Git hosts within the project's architecture, ensuring seamless integration with remote repositories.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/vcs/errors.py'>errors.py</a></b></td>
						<td>Define custom exceptions for handling Git repository validation errors in the utilities package, including errors for failed repository cloning, invalid repository URLs, and unsupported Git hosts.</td>
					</tr>
					</table>
				</blockquote>
			</details>
			<details>
				<summary><b>templates</b></summary>
				<blockquote>
					<table>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/templates/toc.py'>toc.py</a></b></td>
						<td>Generates Table of Contents for README.md based on chosen style and data structure, facilitating navigation and organization within the project documentation.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/templates/header.py'>header.py</a></b></td>
						<td>- Defines header styles and templates for README files, allowing customization and rendering based on user data<br>- The code file enables selection of different header styles and provides methods to render and retrieve header templates, enhancing the visual presentation of README files in the project architecture.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/templates/base_template.py'>base_template.py</a></b></td>
						<td>- Defines a base class for all templates in the project, ensuring a consistent structure for rendering templates with provided data<br>- Includes a method to sanitize input strings, protecting against XSS attacks.</td>
					</tr>
					</table>
				</blockquote>
			</details>
			<details>
				<summary><b>generators</b></summary>
				<blockquote>
					<table>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/generators/tree.py'>tree.py</a></b></td>
						<td>Generates a directory tree structure for a code repository by formatting and displaying the repository's file structure.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/generators/builder.py'>builder.py</a></b></td>
						<td>- Generates sections of the README file, including header, table of contents, code summaries, directory tree structure, quickstart guide, and contributing guidelines<br>- Integrates badges, icons, and relevant project data dynamically<br>- Manages dependencies, configurations, and Git repository information to streamline README generation process.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/generators/utils.py'>utils.py</a></b></td>
						<td>Provides utilities to remove emojis from markdown content, split a markdown document into sections based on level 2 headings, and update heading names by removing certain characters.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/generators/badges.py'>badges.py</a></b></td>
						<td>- Generates and formats SVG badges for the README file, using shields.io icons and skill icons from a specified repository<br>- Handles building default metadata badges and project dependency badges based on configuration settings<br>- The code file contributes to enhancing the visual presentation and information display in the README file.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/generators/tables.py'>tables.py</a></b></td>
						<td>- Generates Markdown tables for storing LLM text responses in README files, grouping code summaries by sub-directory<br>- Handles formatting and constructing tables, ensuring data integrity<br>- Supports conversion of code summaries into formatted lists and creation of tables for project sub-directories.</td>
					</tr>
					<tr>
						<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/generators/quickstart.py'>quickstart.py</a></b></td>
						<td>- Generates dynamic 'Quickstart' guides for README files by determining the top programming language in a repository and providing setup commands<br>- The code calculates language occurrences, identifies the top language, and fetches corresponding setup instructions<br>- This functionality enhances repository usability and onboarding experience for users.</td>
					</tr>
					</table>
					<details>
						<summary><b>svg</b></summary>
						<blockquote>
							<table>
							<tr>
								<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/generators/svg/skill_icons.json'>skill_icons.json</a></b></td>
								<td>- Generates a JSON file containing a list of skill icons and their corresponding base URL for a project that manages and displays skill icons<br>- The file is located in the specified path within the project structure and serves as a central repository for referencing skill icons and their associated URLs.</td>
							</tr>
							<tr>
								<td><b><a href='https://github.com/eli64s/readme-ai/blob/master/readmeai/generators/svg/shieldsio_icons.json'>shieldsio_icons.json</a></b></td>
								<td>- The code file `shieldsio_icons.json` in the `readmeai/generators/svg` directory serves the purpose of defining SVG icon URLs for various technologies and tools<br>- These shield icons are used to visually represent different elements within the project, such as environment variables and frameworks, enhancing the overall presentation and user experience of the codebase architecture.</td>
							</tr>
							</table>
						</blockquote>
					</details>
				</blockquote>
			</details>
		</blockquote>
	</details>
</details>

---

## 🚀 Getting Started

### 📋 Prerequisites

Before getting started with readme-ai, ensure your runtime environment meets the following requirements:

- **Programming Language:** Python
- **Package Manager:** Poetry, Pip, Conda
- **Container Runtime:** Docker


### 📦 Installation

Install readme-ai using one of the following methods:

**Build from source:**

1. Clone the readme-ai repository:
```sh
❯ git clone https://github.com/eli64s/readme-ai
```

2. Navigate to the project directory:
```sh
❯ cd readme-ai
```

3. Install the project dependencies:


**Using `poetry`** &nbsp; [<img align="center" src="https://img.shields.io/endpoint?url=https://python-poetry.org/badge/v0.json" />](https://python-poetry.org/)

```sh
❯ poetry install
```


**Using `pip`** &nbsp; [<img align="center" src="https://img.shields.io/badge/Pip-3776AB.svg?style={badge_style}&logo=pypi&logoColor=white" />](https://pypi.org/project/pip/)

```sh
❯ pip install -r setup/requirements.txt
```


**Using `conda`** &nbsp; [<img align="center" src="https://img.shields.io/badge/conda-342B029.svg?style={badge_style}&logo=anaconda&logoColor=white" />](https://docs.conda.io/)

```sh
❯ conda env create -f setup/environment.yaml
```


**Using `docker`** &nbsp; [<img align="center" src="https://img.shields.io/badge/Docker-2CA5E0.svg?style={badge_style}&logo=docker&logoColor=white" />](https://www.docker.com/)

```sh
❯ docker build -t eli64s/readme-ai .
```




### 🤖 Usage

Run readme-ai using the following command:

**Using `poetry`** &nbsp; [<img align="center" src="https://img.shields.io/endpoint?url=https://python-poetry.org/badge/v0.json" />](https://python-poetry.org/)

```sh
❯ poetry run python {entrypoint}
```


**Using `pip`** &nbsp; [<img align="center" src="https://img.shields.io/badge/Pip-3776AB.svg?style={badge_style}&logo=pypi&logoColor=white" />](https://pypi.org/project/pip/)

```sh
❯ python {entrypoint}
```


**Using `conda`** &nbsp; [<img align="center" src="https://img.shields.io/badge/conda-342B029.svg?style={badge_style}&logo=anaconda&logoColor=white" />](https://docs.conda.io/)

```sh
❯ conda activate {venv}
❯ python {entrypoint}
```


**Using `docker`** &nbsp; [<img align="center" src="https://img.shields.io/badge/Docker-2CA5E0.svg?style={badge_style}&logo=docker&logoColor=white" />](https://www.docker.com/)

```sh
❯ docker run -it {image_name}
```



### 🧪 Testing

Run the test suite using the following command:

**Using `poetry`** &nbsp; [<img align="center" src="https://img.shields.io/endpoint?url=https://python-poetry.org/badge/v0.json" />](https://python-poetry.org/)

```sh
❯ poetry run pytest
```


**Using `pip`** &nbsp; [<img align="center" src="https://img.shields.io/badge/Pip-3776AB.svg?style={badge_style}&logo=pypi&logoColor=white" />](https://pypi.org/project/pip/)

```sh
❯ pytest
```


**Using `conda`** &nbsp; [<img align="center" src="https://img.shields.io/badge/conda-342B029.svg?style={badge_style}&logo=anaconda&logoColor=white" />](https://docs.conda.io/)

```sh
❯ conda activate {venv}
❯ pytest
```



## 📌 Roadmap

- [X] **`Task 1`**: <strike>Implement feature one.</strike>
- [ ] **`Task 2`**: Implement feature two.
- [ ] **`Task 3`**: Implement feature three.

---

## 🔰 Contributing

Contributions are welcome! Here are several ways you can contribute:

- **[Report Issues](https://github.com/eli64s/readme-ai/issues)**: Submit bugs found or log feature requests for the `readme-ai` project.
- **[Submit Pull Requests](https://github.com/eli64s/readme-ai/blob/main/CONTRIBUTING.md)**: Review open PRs, and submit your own PRs.
- **[Join the Discussions](https://github.com/eli64s/readme-ai/discussions)**: Share your insights, provide feedback, or ask questions.

<details closed>
<summary>Contributing Guidelines</summary>

1. **Fork the Repository**: Start by forking the project repository to your github account.
2. **Clone Locally**: Clone the forked repository to your local machine using a git client.
   ```sh
   git clone https://github.com/eli64s/readme-ai
   ```
3. **Create a New Branch**: Always work on a new branch, giving it a descriptive name.
   ```sh
   git checkout -b new-feature-x
   ```
4. **Make Your Changes**: Develop and test your changes locally.
5. **Commit Your Changes**: Commit with a clear message describing your updates.
   ```sh
   git commit -m 'Implemented new feature x.'
   ```
6. **Push to github**: Push the changes to your forked repository.
   ```sh
   git push origin new-feature-x
   ```
7. **Submit a Pull Request**: Create a PR against the original project repository. Clearly describe the changes and their motivations.
8. **Review**: Once your PR is reviewed and approved, it will be merged into the main branch. Congratulations on your contribution!
</details>

<details closed>
<summary>Contributor Graph</summary>
<br>
<p align="left">
   <a href="https://github.com{/eli64s/readme-ai/}graphs/contributors">
      <img src="https://contrib.rocks/image?repo=eli64s/readme-ai">
   </a>
</p>
</details>

---

## 🎗 License

This project is protected under the [SELECT-A-LICENSE](https://choosealicense.com/licenses) License. For more details, refer to the [LICENSE](https://choosealicense.com/licenses/) file.

---

## 🙌 Acknowledgments

- List any resources, contributors, inspiration, etc. here.

---
