# <!-- -->
<div class="hero-section">
  <div class="hero-content">
    <div class="logo-container">
      <img src="https://raw.githubusercontent.com/eli64s/readme-ai/main/docs/docs/assets/svg/readme-ai-gradient.svg"
      alt="readme-ai">
    </div>
    <h2 class="tagline">
      Your AI-Powered Documentation Assistant
    </h2>
    <p class="description">
      Modern documentation generator combining advanced AI with robust data processing
    </p>
    <div class="cta-buttons">
      <a href="https://eli64s.github.io/readme-ai/usage/prerequisites/" class="button primary">
        Getting Started →
      </a>
      <a href="https://github.com/eli64s/readme-ai" class="button secondary">
        View on GitHub →
      </a>
    </div>
    <div class="badges">
      <a href="https://github.com/eli64s/readme-ai/actions">
        <img alt="GitHub Actions" src="https://img.shields.io/github/actions/workflow/status/eli64s/readme-ai/release-pipeline.yml?style=flat&logo=githubactions&logoColor=white&color=4169E1">
      </a>
      <a href="https://pypi.python.org/pypi/readmeai/">
        <img alt="PyPI Version" src="https://img.shields.io/pypi/v/readmeai?style=flat&logo=Python&logoColor=white&color=7934C5">
      </a>
      <a href="https://www.pepy.tech/projects/readmeai">
        <img alt="Downloads" src="https://img.shields.io/pepy/dt/readmeai?style=flat&logo=PyPI&logoColor=white&color=9400D3">
      </a>
      <a href="https://opensource.org/license/mit/">
        <img alt="License" src="https://img.shields.io/github/license/eli64s/readme-ai?style=flat&logo=opensourceinitiative&logoColor=white&color=8A2BE2">
      </a>
    </div>
  </div>
</div>
<div class="features-grid">
  <div class="feature-card">
    <div class="feature-icon">🚀</div>
    <h3>Automated Documentation</h3>
    <p>Generate comprehensive documentation from your codebase instantly</p>
  </div>
  <div class="feature-card">
    <div class="feature-icon">🎨</div>
    <h3>Highly Customizable</h3>
    <p>Choose from dozens of styling options, badges, and templates</p>
  </div>
  <div class="feature-card">
    <div class="feature-icon">🤖</div>
    <h3>Flexible Backends</h3>
    <p>Seamlessly integrate with <code>OpenAI</code>, <code>Anthropic</code>, <code>Google Gemini</code>, and <code>Ollama</code></p>
  </div>
  <div class="feature-card">
    <div class="feature-icon">🌐</div>
    <h3>Language Agnostic</h3>
    <p>Works with any programming language or framework</p>
  </div>
</div>
<div class="quick-start">
  <h2>Quick Start</h2>
  <div class="installation-steps">
    <div class="step">
      <h3>1. Install README-AI</h3>
      <code>pip install readmeai</code>
    </div>
    <div class="step">
      <h3>2. Generate Documentation</h3>
      <code>readmeai --repository https://github.com/user/project-name --output README-AI.md</code>
    </div>
  </div>
</div>

---
