---
title: Gallery
---

Explore various README examples from different programming languages and technologies. Each example showcases a README file from a different repository and project type.

| Technology | Example Output | Repository | Description |
|------------|---------------|------------|-------------|
| Readme-ai | [readme-ai.md][default] | [readme-ai][readme-ai] | Readme-ai project |
| Apache Flink | [readme-pyflink.md][modern-header] | [pyflink-poc][pyflink] | Pyflink project |
| Streamlit | [readme-streamlit.md][svg-banner] | [readme-ai-streamlit][streamlit] | Streamlit web app |
| Vercel & NPM | [readme-vercel.md][dalle-logo] | [github-readme-quotes][vercel] | Vercel deployment |
| Go & Docker | [readme-docker-go.md][for-the-badge] | [docker-gs-ping][docker-golang] | Dockerized Go app |
| FastAPI & Redis | [readme-fastapi-redis.md][fastapi-redis] | [async-ml-inference][fastapi] | Async ML inference service |
| Java | [readme-java.md][compact-header] | [Minimal-Todo][java] | Minimalist todo Java app |
| PostgreSQL & DuckDB | [readme-postgres.md][classic-header] | [Buenavista][postgres] | Postgres proxy server |
| Kotlin | [readme-kotlin.md][readme-kotlin] | [android-client][kotlin] | Android client app |
| Offline Mode | [offline-mode.md][offline-mode] | [litellm][litellm] | LLM API service |

Find additional README examples in the [examples directory](https://github.com/eli64s/readme-ai/tree/main/examples).

## Share Your README

To improve readme-ai and grow the community, we'd love to see the READMEs you created. If you have a README file that you'd like to share, please share it with us [here](https://github.com/eli64s/readme-ai/discussions/categories/show-and-tell). Cheers!

---

<!-- Example READMEs -->
[default]: https://github.com/eli64s/readme-ai/blob/main/examples/readme-ai.md "readme-python.md"
[ascii-header]: https://github.com/eli64s/readme-ai/blob/main/examples/headers/ascii.md "ascii.md"
[classic-header]: https://github.com/eli64s/readme-ai/blob/main/examples/headers/classic.md "readme-postgres.md"
[compact-header]: https://github.com/eli64s/readme-ai/blob/main/examples/headers/compact.md "readme-java.md"
[modern-header]: https://github.com/eli64s/readme-ai/blob/main/examples/headers/modern.md "readme-pyflink.md"
[svg-banner]: https://github.com/eli64s/readme-ai/blob/main/examples/banners/svg-banner.md "readme-streamlit.md"
[dalle-logo]: https://github.com/eli64s/readme-ai/blob/main/examples/logos/dalle.md "readme-vercel.md"
[readme-kotlin]: https://github.com/eli64s/readme-ai/blob/main/examples/readme-kotlin.md "readme-kotlin.md"
[for-the-badge]: https://github.com/eli64s/readme-ai/blob/main/examples/readme-docker-go.md "readme-docker-go.md"
[fastapi-redis]: https://github.com/eli64s/readme-ai/blob/main/examples/readme-fastapi-redis.md "readme-fastapi-redis.md"
[offline-mode]: https://github.com/eli64s/readme-ai/blob/main/examples/offline-mode/readme-litellm.md "readme-litellm.md"

<!-- Example Repositories -->
[readme-ai]: https://github.com/eli64s/readme-ai "readme-ai"
[pyflink]: https://github.com/eli64s/pyflink-poc "pyflink-poc"
[postgres]: https://github.com/jwills/buenavista "Buenavista"
[java]: https://github.com/avjinder/Minimal-Todo "minimal-todo"
[kotlin]: https://github.com/rumaan/file.io-Android-Client "android-client"
[docker-golang]: https://github.com/olliefr/docker-gs-ping "docker-gs-ping"
[vercel]: https://github.com/PiyushSuthar/github-readme-quotes "github-readme-quotes"
[streamlit]: https://github.com/eli64s/readme-ai-streamlit  "readme-ai-streamlit"
[fastapi]: https://github.com/FerrariDG/async-ml-inference "async-ml-inference"
[litellm]: https://github.com/BerriAI/litellm "offline-mode"
