---
title: "Headers"
---

# Headers

A header template style determines how your project's header section is structured and displayed in the README file. README-AI offers several pre-designed header styles to help brand your project and create a professional appearance.

## Header Style Options

!!! example

    <p>Use the `--header-style` option to select from the following markdown header templates:</p>

    === "CLASSIC"

		<p align="center">
		<img src="https://raw.githubusercontent.com/PKief/vscode-material-icon-theme/ec559a9f6bfd399b82bb44393651661b08aaf7ba/icons/folder-markdown-open.svg" width="20%" alt="README-AI-logo">
		</p>
		<p align="center">
			<h1 align="center">README-AI</h1>
		</p>
		<p align="center">
			<em>Where Documentation Meets Innovation!</em>
		</p>
		<p align="center">
			<img src="https://img.shields.io/github/license/eli64s/readme-ai?style=flat&logo=opensourceinitiative&logoColor=white&color=60A5FA" alt="license">
			<img src="https://img.shields.io/github/last-commit/eli64s/readme-ai?style=flat&logo=git&logoColor=white&color=60A5FA" alt="last-commit">
			<img src="https://img.shields.io/github/languages/top/eli64s/readme-ai?style=flat&color=60A5FA" alt="repo-top-language">
			<img src="https://img.shields.io/github/languages/count/eli64s/readme-ai?style=flat&color=60A5FA" alt="repo-language-count">
		</p>
		<p align="center">Built with the tools and technologies:</p>
		<p align="center">
			<img src="https://img.shields.io/badge/precommit-FAB040.svg?style=flat&logo=pre-commit&logoColor=black" alt="precommit">
			<img src="https://img.shields.io/badge/Ruff-FCC21B.svg?style=flat&logo=Ruff&logoColor=black" alt="Ruff">
			<img src="https://img.shields.io/badge/GNU%20Bash-4EAA25.svg?style=flat&logo=GNU-Bash&logoColor=white" alt="GNU%20Bash">
			<img src="https://img.shields.io/badge/Pytest-0A9EDC.svg?style=flat&logo=Pytest&logoColor=white" alt="Pytest">
			<img src="https://img.shields.io/badge/Docker-2496ED.svg?style=flat&logo=Docker&logoColor=white" alt="Docker">
			<img src="https://img.shields.io/badge/Python-3776AB.svg?style=flat&logo=Python&logoColor=white" alt="Python">
			<img src="https://img.shields.io/badge/GitHub%20Actions-2088FF.svg?style=flat&logo=GitHub-Actions&logoColor=white" alt="GitHub%20Actions">
			<br>
			<img src="https://img.shields.io/badge/Poetry-60A5FA.svg?style=flat&logo=Poetry&logoColor=white" alt="Poetry">
			<img src="https://img.shields.io/badge/AIOHTTP-2C5BB4.svg?style=flat&logo=AIOHTTP&logoColor=white" alt="AIOHTTP">
			<img src="https://img.shields.io/badge/Material%20for%20MkDocs-526CFE.svg?style=flat&logo=Material-for-MkDocs&logoColor=white" alt="Material%20for%20MkDocs">
			<img src="https://img.shields.io/badge/OpenAI-412991.svg?style=flat&logo=OpenAI&logoColor=white" alt="OpenAI">
			<img src="https://img.shields.io/badge/Google%20Gemini-8E75B2.svg?style=flat&logo=Google-Gemini&logoColor=white" alt="Google%20Gemini">
			<img src="https://img.shields.io/badge/Pydantic-E92063.svg?style=flat&logo=Pydantic&logoColor=white" alt="Pydantic">
		</p>
		<hr>

		<div class="feature-container">
		<h3>Features:</h3>
		<ul class="feature-list">
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Centered alignment</span>
			</div>
			</li>
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Logo above project name</span>
			</div>
			</li>
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Traditional README layout</span>
			</div>
			</li>
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Ideal for most projects</span>
			</div>
			</li>
		</ul>
		</div>

	=== "COMPACT"

		<div align="left">
			<img src="https://img.freepik.com/premium-vector/bunch-balloons-icon-vector-illustration_444196-2020.jpg?w=360" width="15%" align="left" style="margin-right: 15px"/>
			<div style="display: inline-block;">
				<h2 style="display: inline-block; vertical-align: middle; margin-top: 0;">README-AI-STREAMLIT</h2>
				<p>
			<em>Streamlining README creation with AI magic!</em>
		</p>
				<p>
			<img src="https://img.shields.io/github/license/eli64s/readme-ai-streamlit?style=flat-square&logo=opensourceinitiative&logoColor=white&color=5D3FD3" alt="license">
			<img src="https://img.shields.io/github/last-commit/eli64s/readme-ai-streamlit?style=flat-square&logo=git&logoColor=white&color=5D3FD3" alt="last-commit">
			<img src="https://img.shields.io/github/languages/top/eli64s/readme-ai-streamlit?style=flat-square&color=5D3FD3" alt="repo-top-language">
			<img src="https://img.shields.io/github/languages/count/eli64s/readme-ai-streamlit?style=flat-square&color=5D3FD3" alt="repo-language-count">
		</p>
				<p>Built with the tools and technologies:</p>
				<p>
			<img src="https://img.shields.io/badge/Streamlit-FF4B4B.svg?style=flat-square&logo=Streamlit&logoColor=white" alt="Streamlit">
			<img src="https://img.shields.io/badge/precommit-FAB040.svg?style=flat-square&logo=pre-commit&logoColor=black" alt="precommit">
			<img src="https://img.shields.io/badge/Ruff-FCC21B.svg?style=flat-square&logo=Ruff&logoColor=black" alt="Ruff">
			<img src="https://img.shields.io/badge/GNU%20Bash-4EAA25.svg?style=flat-square&logo=GNU-Bash&logoColor=white" alt="GNU%20Bash">
			<img src="https://img.shields.io/badge/Pytest-0A9EDC.svg?style=flat-square&logo=Pytest&logoColor=white" alt="Pytest">
			<img src="https://img.shields.io/badge/Python-3776AB.svg?style=flat-square&logo=Python&logoColor=white" alt="Python">
			<img src="https://img.shields.io/badge/Poetry-60A5FA.svg?style=flat-square&logo=Poetry&logoColor=white" alt="Poetry">
		</p>
			</div>
		</div>
		<br clear="left"/>
		<hr>

		<div class="feature-container">
		<h3>Features:</h3>
		<ul class="feature-list">
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Left-aligned layout</span>
			</div>
			</li>
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Logo and title on same line</span>
			</div>
			</li>
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Space-efficient design</span>
			</div>
			</li>
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Perfect for smaller README files</span>
			</div>
			</li>
		</ul>
		</div>

	=== "MODERN"

		<div align="left" style="position: relative;">
		<img src="https://flink.apache.org/img/logo/png/1000/flink_squirrel_1000.png" align="right" width="30%" style="margin: -20px 0 0 20px;">
		<h1>PYFLINK-POC</h1>
		<p align="left">
			<em>Streamlining data flow with PyFlink power!</em>
		</p>
		<p align="left">
			<img src="https://img.shields.io/github/license/eli64s/pyflink-poc?style=flat&logo=opensourceinitiative&logoColor=white&color=E30B5C" alt="license">
			<img src="https://img.shields.io/github/last-commit/eli64s/pyflink-poc?style=flat&logo=git&logoColor=white&color=E30B5C" alt="last-commit">
			<img src="https://img.shields.io/github/languages/top/eli64s/pyflink-poc?style=flat&color=E30B5C" alt="repo-top-language">
			<img src="https://img.shields.io/github/languages/count/eli64s/pyflink-poc?style=flat&color=E30B5C" alt="repo-language-count">
		</p>
		<p align="left">Built with the tools and technologies:</p>
		<p align="left">
			<img src="https://img.shields.io/badge/GNU%20Bash-4EAA25.svg?style=flat&logo=GNU-Bash&logoColor=white" alt="GNU%20Bash">
			<img src="https://img.shields.io/badge/Python-3776AB.svg?style=flat&logo=Python&logoColor=white" alt="Python">
			<img src="https://img.shields.io/badge/AIOHTTP-2C5BB4.svg?style=flat&logo=AIOHTTP&logoColor=white" alt="AIOHTTP">
			<img src="https://img.shields.io/badge/pandas-150458.svg?style=flat&logo=pandas&logoColor=white" alt="pandas">
			<img src="https://img.shields.io/badge/Apache%20Kafka-231F20.svg?style=flat&logo=Apache-Kafka&logoColor=white" alt="Apache%20Kafka">
			<img src="https://img.shields.io/badge/Apache%20Flink-E6526F.svg?style=flat&logo=Apache-Flink&logoColor=white" alt="Apache%20Flink">
		</p>
		</div>
		<br clear="right">
		<hr>

		<div class="feature-container">
		<h3>Features:</h3>
		<ul class="feature-list">
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Left-aligned text</span>
			</div>
			</li>
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Logo floated to the right</span>
			</div>
			</li>
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Contemporary asymmetric design</span>
			</div>
			</li>
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Great for documentation sites</span>
			</div>
			</li>
		</ul>
		</div>

	=== "SVG"

		<p align="center">
			<img src="data:image/svg+xml;base64,PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4KICAgIDxzdmcgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIiB2aWV3Qm94PSIwIDAgODAwIDIwMCI+CiAgICAgICAgPGRlZnM+CiAgICAgICAgICAgIDxsaW5lYXJHcmFkaWVudCBpZD0iYmctZ3JhZGllbnQiIHgxPSIwJSIgeTE9IjAlIiB4Mj0iMTAwJSIgeTI9IjEwMCUiPgogICAgICAgICAgICAgICAgPHN0b3Agb2Zmc2V0PSIwJSIgc3R5bGU9InN0b3AtY29sb3I6IzQxNThEMDtzdG9wLW9wYWNpdHk6MSIgLz4KICAgICAgICAgICAgICAgIDxzdG9wIG9mZnNldD0iNTAlIiBzdHlsZT0ic3RvcC1jb2xvcjojQzg1MEMwO3N0b3Atb3BhY2l0eToxIiAvPgogICAgICAgICAgICAgICAgPHN0b3Agb2Zmc2V0PSIxMDAlIiBzdHlsZT0ic3RvcC1jb2xvcjojRkZDQzcwO3N0b3Atb3BhY2l0eToxIiAvPgogICAgICAgICAgICA8L2xpbmVhckdyYWRpZW50PgogICAgICAgICAgICA8ZmlsdGVyIGlkPSJzaGFkb3ciPgogICAgICAgICAgICAgICAgPGZlRHJvcFNoYWRvdyBkeD0iMCIgZHk9IjQiIHN0ZERldmlhdGlvbj0iNCIgZmxvb2Qtb3BhY2l0eT0iMC4yNSIgLz4KICAgICAgICAgICAgPC9maWx0ZXI+CiAgICAgICAgPC9kZWZzPgogICAgICAgIDxyZWN0IHdpZHRoPSI4MDAiIGhlaWdodD0iMjAwIiBmaWxsPSJ1cmwoI2JnLWdyYWRpZW50KSIgcng9IjE1IiByeT0iMTUiLz4KICAgICAgICA8dGV4dCB4PSI0MDAiIHk9IjEwMCIgZm9udC1mYW1pbHk9IkFyaWFsLCBzYW5zLXNlcmlmIiBmb250LXNpemU9IjQ4IgogICAgICAgIGZvbnQtd2VpZ2h0PSJib2xkIiB0ZXh0LWFuY2hvcj0ibWlkZGxlIiBkb21pbmFudC1iYXNlbGluZT0ibWlkZGxlIgogICAgICAgIGZpbGw9IiNGRkZGRkYiIGZpbHRlcj0idXJsKCNzaGFkb3cpIj5SRUFETUUtQUk8L3RleHQ+CiAgICA8L3N2Zz4=" alt="readme-ai-banner" width="800">
		</p>
		<p align="center">
			<em><code>❯ REPLACE-ME</code></em>
		</p>
		<p align="center">
			<img src="https://img.shields.io/github/license/eli64s/readme-ai?style=flat-square&logo=opensourceinitiative&logoColor=white&color=2496ED" alt="license">
			<img src="https://img.shields.io/github/last-commit/eli64s/readme-ai?style=flat-square&logo=git&logoColor=white&color=2496ED" alt="last-commit">
			<img src="https://img.shields.io/github/languages/top/eli64s/readme-ai?style=flat-square&color=2496ED" alt="repo-top-language">
			<img src="https://img.shields.io/github/languages/count/eli64s/readme-ai?style=flat-square&color=2496ED" alt="repo-language-count">
		</p>
		<p align="center">Built with the tools and technologies:</p>
		<p align="center">
			<img src="https://img.shields.io/badge/Anthropic-191919.svg?style=flat-square&logo=Anthropic&logoColor=white" alt="Anthropic">
			<img src="https://img.shields.io/badge/precommit-FAB040.svg?style=flat-square&logo=pre-commit&logoColor=black" alt="precommit">
			<img src="https://img.shields.io/badge/Ruff-FCC21B.svg?style=flat-square&logo=Ruff&logoColor=black" alt="Ruff">
			<img src="https://img.shields.io/badge/GNU%20Bash-4EAA25.svg?style=flat-square&logo=GNU-Bash&logoColor=white" alt="GNU%20Bash">
			<img src="https://img.shields.io/badge/Pytest-0A9EDC.svg?style=flat-square&logo=Pytest&logoColor=white" alt="Pytest">
			<img src="https://img.shields.io/badge/Docker-2496ED.svg?style=flat-square&logo=Docker&logoColor=white" alt="Docker">
			<img src="https://img.shields.io/badge/Python-3776AB.svg?style=flat-square&logo=Python&logoColor=white" alt="Python">
			<br>
			<img src="https://img.shields.io/badge/GitHub%20Actions-2088FF.svg?style=flat-square&logo=GitHub-Actions&logoColor=white" alt="GitHub%20Actions">
			<img src="https://img.shields.io/badge/Poetry-60A5FA.svg?style=flat-square&logo=Poetry&logoColor=white" alt="Poetry">
			<img src="https://img.shields.io/badge/AIOHTTP-2C5BB4.svg?style=flat-square&logo=AIOHTTP&logoColor=white" alt="AIOHTTP">
			<img src="https://img.shields.io/badge/Material%20for%20MkDocs-526CFE.svg?style=flat-square&logo=Material-for-MkDocs&logoColor=white" alt="Material%20for%20MkDocs">
			<img src="https://img.shields.io/badge/OpenAI-412991.svg?style=flat-square&logo=OpenAI&logoColor=white" alt="OpenAI">
			<img src="https://img.shields.io/badge/Google%20Gemini-8E75B2.svg?style=flat-square&logo=Google-Gemini&logoColor=white" alt="Google%20Gemini">
			<img src="https://img.shields.io/badge/Pydantic-E92063.svg?style=flat-square&logo=Pydantic&logoColor=white" alt="Pydantic">
		</p>
		<br>
		<hr>

		<div class="feature-container">
		<h3>Features:</h3>
		<ul class="feature-list">
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Full-width SVG banner support</span>
			</div>
			</li>
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Centered alignment</span>
			</div>
			</li>
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Scalable vector graphics</span>
			</div>
			</li>
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Ideal for custom branding</span>
			</div>
			</li>
		</ul>
		</div>

	=== "ASCII"

		<div align="center">
		<pre>
		██████ ██████   ██   ████   ██   ██ ██████          ██   ██████
		██  ██ ██      ████  ██  ██ ███ ███ ██             ████    ██
		██████ ████   ██  ██ ██  ██ ██ █ ██ ████   ██████ ██  ██   ██
		██ ██  ██     ██████ ██  ██ ██   ██ ██            ██████   ██
		██  ██ ██████ ██  ██ ████   ██   ██ ██████        ██  ██ ██████
		</pre>
		</div>
		<p align="center">
			<em><code>❯ REPLACE-ME</code></em>
		</p>
		<p align="center">
			<img src="https://img.shields.io/github/license/eli64s/readme-ai?style=flat-square&logo=opensourceinitiative&logoColor=white&color=0bc5e2" alt="license">
			<img src="https://img.shields.io/github/last-commit/eli64s/readme-ai?style=flat-square&logo=git&logoColor=white&color=0bc5e2" alt="last-commit">
			<img src="https://img.shields.io/github/languages/top/eli64s/readme-ai?style=flat-square&color=0bc5e2" alt="repo-top-language">
			<img src="https://img.shields.io/github/languages/count/eli64s/readme-ai?style=flat-square&color=0bc5e2" alt="repo-language-count">
		</p>
		<p align="center">Built with the tools and technologies:</p>
		<p align="center">
			<img src="https://img.shields.io/badge/Anthropic-191919.svg?style=flat-square&logo=Anthropic&logoColor=white" alt="Anthropic">
			<img src="https://img.shields.io/badge/precommit-FAB040.svg?style=flat-square&logo=pre-commit&logoColor=black" alt="precommit">
			<img src="https://img.shields.io/badge/Ruff-FCC21B.svg?style=flat-square&logo=Ruff&logoColor=black" alt="Ruff">
			<img src="https://img.shields.io/badge/GNU%20Bash-4EAA25.svg?style=flat-square&logo=GNU-Bash&logoColor=white" alt="GNU%20Bash">
			<img src="https://img.shields.io/badge/Pytest-0A9EDC.svg?style=flat-square&logo=Pytest&logoColor=white" alt="Pytest">
			<img src="https://img.shields.io/badge/Docker-2496ED.svg?style=flat-square&logo=Docker&logoColor=white" alt="Docker">
			<img src="https://img.shields.io/badge/Python-3776AB.svg?style=flat-square&logo=Python&logoColor=white" alt="Python">
			<br>
			<img src="https://img.shields.io/badge/GitHub%20Actions-2088FF.svg?style=flat-square&logo=GitHub-Actions&logoColor=white" alt="GitHub%20Actions">
			<img src="https://img.shields.io/badge/Poetry-60A5FA.svg?style=flat-square&logo=Poetry&logoColor=white" alt="Poetry">
			<img src="https://img.shields.io/badge/AIOHTTP-2C5BB4.svg?style=flat-square&logo=AIOHTTP&logoColor=white" alt="AIOHTTP">
			<img src="https://img.shields.io/badge/Material%20for%20MkDocs-526CFE.svg?style=flat-square&logo=Material-for-MkDocs&logoColor=white" alt="Material%20for%20MkDocs">
			<img src="https://img.shields.io/badge/OpenAI-412991.svg?style=flat-square&logo=OpenAI&logoColor=white" alt="OpenAI">
			<img src="https://img.shields.io/badge/Google%20Gemini-8E75B2.svg?style=flat-square&logo=Google-Gemini&logoColor=white" alt="Google%20Gemini">
			<img src="https://img.shields.io/badge/Pydantic-E92063.svg?style=flat-square&logo=Pydantic&logoColor=white" alt="Pydantic">
		</p>
		<br>
		<hr>

		<div class="feature-container">
		<h3>Features:</h3>
		<ul class="feature-list">
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Text-based art logo</span>
			</div>
			</li>
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Minimal and retro style</span>
			</div>
			</li>
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">No image dependencies</span>
			</div>
			</li>
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Good for terminal-focused tools</span>
			</div>
			</li>
		</ul>
		</div>


	=== "ASCII_BOX"

		<div align="center">
		<pre>
		╔════════════════════════════════════════════════════════════════════╗
		║                                                                    ║
		║  ██████ ██████   ██   ████   ██   ██ ██████          ██   ██████   ║
		║  ██  ██ ██      ████  ██  ██ ███ ███ ██             ████    ██     ║
		║  ██████ ████   ██  ██ ██  ██ ██ █ ██ ████   ██████ ██  ██   ██     ║
		║  ██ ██  ██     ██████ ██  ██ ██   ██ ██            ██████   ██     ║
		║  ██  ██ ██████ ██  ██ ████   ██   ██ ██████        ██  ██ ██████   ║
		║                                                                    ║
		║                                                                    ║
		╚════════════════════════════════════════════════════════════════════╝
		</pre>
		</div>
		<p align="center">
			<em><code>❯ REPLACE-ME</code></em>
		</p>
		<p align="center">
			<img src="https://img.shields.io/github/license/eli64s/readme-ai?style=flat-square&logo=opensourceinitiative&logoColor=white&color=0bc5e2" alt="license">
			<img src="https://img.shields.io/github/last-commit/eli64s/readme-ai?style=flat-square&logo=git&logoColor=white&color=0bc5e2" alt="last-commit">
			<img src="https://img.shields.io/github/languages/top/eli64s/readme-ai?style=flat-square&color=0bc5e2" alt="repo-top-language">
			<img src="https://img.shields.io/github/languages/count/eli64s/readme-ai?style=flat-square&color=0bc5e2" alt="repo-language-count">
		</p>
		<p align="center">Built with the tools and technologies:</p>
		<p align="center">
			<img src="https://img.shields.io/badge/Anthropic-191919.svg?style=flat-square&logo=Anthropic&logoColor=white" alt="Anthropic">
			<img src="https://img.shields.io/badge/precommit-FAB040.svg?style=flat-square&logo=pre-commit&logoColor=black" alt="precommit">
			<img src="https://img.shields.io/badge/Ruff-FCC21B.svg?style=flat-square&logo=Ruff&logoColor=black" alt="Ruff">
			<img src="https://img.shields.io/badge/GNU%20Bash-4EAA25.svg?style=flat-square&logo=GNU-Bash&logoColor=white" alt="GNU%20Bash">
			<img src="https://img.shields.io/badge/Pytest-0A9EDC.svg?style=flat-square&logo=Pytest&logoColor=white" alt="Pytest">
			<img src="https://img.shields.io/badge/Docker-2496ED.svg?style=flat-square&logo=Docker&logoColor=white" alt="Docker">
			<img src="https://img.shields.io/badge/Python-3776AB.svg?style=flat-square&logo=Python&logoColor=white" alt="Python">
			<br>
			<img src="https://img.shields.io/badge/GitHub%20Actions-2088FF.svg?style=flat-square&logo=GitHub-Actions&logoColor=white" alt="GitHub%20Actions">
			<img src="https://img.shields.io/badge/Poetry-60A5FA.svg?style=flat-square&logo=Poetry&logoColor=white" alt="Poetry">
			<img src="https://img.shields.io/badge/AIOHTTP-2C5BB4.svg?style=flat-square&logo=AIOHTTP&logoColor=white" alt="AIOHTTP">
			<img src="https://img.shields.io/badge/Material%20for%20MkDocs-526CFE.svg?style=flat-square&logo=Material-for-MkDocs&logoColor=white" alt="Material%20for%20MkDocs">
			<img src="https://img.shields.io/badge/OpenAI-412991.svg?style=flat-square&logo=OpenAI&logoColor=white" alt="OpenAI">
			<img src="https://img.shields.io/badge/Google%20Gemini-8E75B2.svg?style=flat-square&logo=Google-Gemini&logoColor=white" alt="Google%20Gemini">
			<img src="https://img.shields.io/badge/Pydantic-E92063.svg?style=flat-square&logo=Pydantic&logoColor=white" alt="Pydantic">
		</p>
		<br>
		<hr>

		<div class="feature-container">
		<h3>Features:</h3>
		<ul class="feature-list">
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Text-based art logo</span>
			</div>
			</li>
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Minimal and retro style</span>
			</div>
			</li>
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">No image dependencies</span>
			</div>
			</li>
			<li>
			<div class="feature-item">
				<span class="feature-icon">•</span>
				<span class="feature-text">Good for terminal-focused tools</span>
			</div>
			</li>
		</ul>
		</div>

## How It Works

README-AI provides several ways to customize your header style:

1. **Default Styles**: Choose from pre-defined header layouts
2. **Alignment Options**: Set text and image alignment
3. **Custom Sizing**: Adjust logo and image dimensions
4. **Badge Integration**: Incorporates shield badges and tech stack icons

The selected style will determine how your project's name, logo, description, and badges are arranged in the header section.

## Examples

### Using Classic Style

```sh
readmeai --header-style classic --repository https://github.com/username/project
```

### Using Modern Style with Custom Alignment

```sh
readmeai --header-style modern --align left --repository https://github.com/username/project
```

### Combining with Other Options

```sh
readmeai --header-style compact \
         --badge-style flat \
         --image gradient \
         --repository https://github.com/username/project
```

## Tips for Using Header Styles

- **Classic**: Best for traditional open-source projects that need a professional look
- **Modern**: Great for documentation sites and projects with longer READMEs
- **Compact**: Ideal for smaller projects or when space is at a premium
- **SVG**: Perfect for projects that need custom branding or full-width banners
- **ASCII**: Good for terminal applications or when you want a retro feel

Consider these factors when choosing a header style:
- Your project's target audience
- The amount of content in your README
- Whether you have a custom logo or banner
- The overall aesthetic of your documentation
- How the style works with your chosen badge style

:warning: Some header styles may look different on different platforms or markdown renderers. It's a good idea to test how your chosen style looks on your target platform.

<!--
## Customizing Header Alignment

Additionally, you can customize the alignment of the header sections using the `--align` option. Supported alignments are `center`, `left`, or `right`.

### Example Command with Alignment:

```sh
readmeai --repository ./my_project --header-style classic --align left --output README.md
```

This command sets the header style to **Classic** but aligns all the sections (logo, title, badges) to the left instead of the default center alignment.

## Project Logo Customization

You can also customize the logo displayed in the header using the `--image` option. Options include providing a custom URL, generating a logo with an LLM, or using one of the predefined themes (`black`, `blue`, `cloud`, `gradient`, etc.).

### Example Command with Logo:

```sh
readmeai --repository ./my_project --header-style modern --image CUSTOM --output README.md
```

In this case, the header will use the **Modern** style, and you will be prompted to provide a custom logo URL or local file path.

## Emoji Support for Headers

If you want to add emojis to your header titles (e.g., "## 📍 Overview"), use the `--emojis` option:

```sh
readmeai --repository ./my_project --header-style modern --emojis --output README.md
```

This will prepend relevant emojis to each section header, enhancing the visual appeal of your README file.

---

## How to Customize the Header

To customize the header template, you can initialize the `HeaderTemplate` class and pass your preferred style (`classic`, `compact`, or `modern`). Here's an example:

```python
from readmeai.templates.header import HeaderTemplate, HeaderStyleOptions

# Initialize the template with the desired style
header_template = HeaderTemplate(style=HeaderStyleOptions.MODERN)

# Data to render in the header
data = {
    "align": "center",
    "image": "https://example.com/logo.png",
    "image_width": "100px",
    "repo_name": "My Awesome Project",
    "slogan": "Building the future, one commit at a time.",
    "shields_icons": "<shields.io badge here>",
    "badges_tech_stack": "<badge icons here>",
}

# Render the template with the provided data
header_content = header_template.render(data)

# Output the rendered content
print(header_content)
```

## Adding a New Header Style

If you wish to add your own custom header style, simply extend the `HeaderStyleOptions` enum and the `HEADER_TEMPLATES` dictionary with your own template string. Ensure that your template follows the same format placeholders (`{repo_name}`, `{image}`, etc.) as the existing templates.

```python
class HeaderStyleOptions(enum.Enum):
    CLASSIC = "classic"
    COMPACT = "compact"
    MODERN = "modern"
    CUSTOM = "custom"  # Add new custom style here

HeaderTemplate.HEADER_TEMPLATES[HeaderStyleOptions.CUSTOM] = """\
# Custom header template here
"""
```

By customizing and extending the header templates, you can fully control the look and feel of your README header to match your project’s branding and style.

---
-->
