# Contributing Guidelines

Thanks for your interest in contributing to readme-ai. Please review these guidelines to ensure a smooth process.

## Make Valuable Contributions

Strive to make **useful**, **creative**, and **high quality** contributions. This isn't meant to be a high bar, but more of a guiding principle and philosophy. Here's what we mean by these terms:

**Useful:** Solve common problems, use cases, bugs, or new features.

**Creative:** Innovative and helping us all grow and learn new things.

**High Quality:** Well-written, structured, and explained.

## Ways to Contribute

To improve and grow the project, we need your help! Here are some ways to get involved:

| Activity | Ideas |
| -------- | ----- |
| 👋 Discussions | Start a discussion by asking a question or making a suggestion. |
| 🐛 Open an Issue | Find unhandled exceptions and bugs in the codebase. |
| 📄 Documentation | Write documentation for the project. |
| 🧪 Testing | Write unit tests to increase code coverage. |
| 🧩 Feature Requests | Brainstorm new ideas such as a CLI option to select any language. |
| 🛠️ Code Contributions | Contribute to the codebase and submit a pull request. |
| 🔢 Code Readability | Find ways to make code more readable and easier to understand. |
| 🤔 Other | Anything else you can think of! |

These are just a few examples, and we welcome any other ideas you may have!

## Submitting Changes

1. Fork the repository and clone it locally.
2. Create a new branch with a descriptive name i.e <code>feature/new-feature-name</code> or <code>bugfix-issue-123</code>.
3. Make focused changes with clear commits.
4. Open a pull request document the changes you've made and why they're necessary.
5. Respond to code reviews from maintainers.

## Code Quality Expectations

- Clear, well-documented code
- Include tests for new code
- Follow project style standards
- Rebase onto latest main branch

## Attribution

Contributors to our project will be acknowledged in the project's README.md file.

## License

By contributing to our project, you agree to license your contributions under the project's open source license. The project's license can be found in the [LICENSE](https://github.com/eli64s/readme-ai/blob/main/LICENSE)

Thank you for your interest in contributing to readme-ai! We appreciate your help and look forward to working with you.

---
