﻿/*******************************************************************************
* Copyright (c) 2018 Elhay Rauper
* All rights reserved.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted (subject to the limitations in the disclaimer
* below) provided that the following conditions are met:
*
*     * Redistributions of source code must retain the above copyright notice,
*     this list of conditions and the following disclaimer.
*
*     * Redistributions in binary form must reproduce the above copyright
*     notice, this list of conditions and the following disclaimer in the
*     documentation and/or other materials provided with the distribution.
*
*     * Neither the name of the copyright holder nor the names of its
*     contributors may be used to endorse or promote products derived from this
*     software without specific prior written permission.
*
* NO EXPRESS OR IMPLIED LICENSES TO ANY PARTY'S PATENT RIGHTS ARE GRANTED BY
* THIS LICENSE. THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
* CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
* LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A
* PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDER OR
* CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
* EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
* PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
* BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER
* IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
* ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
* POSSIBILITY OF SUCH DAMAGE.
*******************************************************************************/

using System;


namespace Falcon.Graph
{
    class DataStream
    {
        public static double[] ExtractCsvFromLine(string line)
        {
            // find data opening character 
            int breakIndex = line.IndexOf(SeriesManager.DATA_OPEN_CHAR);
            if (breakIndex < 0)
                return null;

            string trimmedRow = line.Substring(breakIndex + 1);

            // find data closing character 
            breakIndex = trimmedRow.IndexOf(SeriesManager.DATA_CLOSE_CHAR);
            if (breakIndex < 0)
                return null;
            trimmedRow = trimmedRow.Substring(0, breakIndex);
            string[] dataArr = trimmedRow.Split(',');
            var csv = new double[dataArr.Length];
            for (int indx = 0; indx < dataArr.Length; indx++)
            {
                try
                {
                    csv[indx] = Convert.ToDouble(dataArr[indx]);
                }
                catch (FormatException exp)
                {
                    return null;
                }
            }
            return csv;
        }
    }
}
