<?php

namespace Elementor\Tests\Phpunit\Elementor\Modules\Checklist\Classes;

use Elementor\Modules\Checklist\Steps\Setup_Header;

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

class Test_Setup_Header_Step extends Step_Test_Base {
	public function test__various_cases() {
		$steps_manager = $this->checklist_module->get_steps_manager();
		$step = $steps_manager->get_step_by_id( Setup_Header::STEP_ID );

		$this->assertFalse( $step->is_marked_as_completed() );
		$this->assertFalse( $step->is_immutable_completed() );
		$this->assertFalse( $step->is_absolute_completed() );

		$step->mark_as_completed();
		$this->assertTrue( $step->is_marked_as_completed() );
		$this->assertFalse( $step->is_immutable_completed() );
		$this->assertFalse( $step->is_absolute_completed() );

		$step->unmark_as_completed();
		$this->assertFalse( $step->is_marked_as_completed() );
		$this->assertFalse( $step->is_immutable_completed() );
		$this->assertFalse( $step->is_absolute_completed() );


		$query = new \WP_Query();
		$query->posts = [1];
		$this->set_wordpress_adapter_mock( [ 'get_query' => $query ] );

		$step = new Setup_Header( $this->checklist_module, $this->wordpress_adapter );

		$step->maybe_immutably_mark_as_completed();
		$this->assertFalse( $step->is_marked_as_completed() );
		$this->assertFalse( $step->is_immutable_completed() );
		$this->assertTrue( $step->is_absolute_completed() );

		$query->posts = [];
		$this->set_wordpress_adapter_mock( [ 'get_query' => $query ] );
		$step = new Setup_Header( $this->checklist_module, $this->wordpress_adapter );
		$this->assertFalse( $step->is_marked_as_completed() );
		$this->assertFalse( $step->is_immutable_completed() );
		$this->assertFalse( $step->is_absolute_completed() );
	}

	public function setUp(): void {
		$query = new \WP_Query();
		$query->posts = [];

		$this->set_wordpress_adapter_mock( [ 'get_query' => $query ] );

		parent::setUp();
	}

	public function tearDown(): void {
		parent::tearDown(); // TODO: Change the autogenerated stub
	}
}
