import ComponentBase from './component-base';
import * as commands from './commands/';
import ForceMethodImplementation from '../utils/force-method-implementation';

export default class ComponentModalBase extends ComponentBase {
	registerAPI() {
		super.registerAPI();

		$e.shortcuts.register( 'esc', {
			scopes: [ this.getNamespace() ],
			callback: () => this.close(),
		} );
	}

	defaultCommands() {
		return this.importCommands( commands );
	}

	defaultRoutes() {
		return {
			'': () => { /* Nothing to do, it's already rendered. */ },
		};
	}

	open() {
		if ( ! this.layout ) {
			const layout = this.getModalLayout();
			this.layout = new layout( { component: this } );

			this.layout.getModal().on( 'hide', () => this.close() );
		}

		this.layout.showModal();

		return true;
	}

	close() {
		if ( ! super.close() ) {
			return false;
		}

		this.layout.getModal().hide();

		return true;
	}

	getModalLayout() {
		ForceMethodImplementation();
	}
}
