# Contribution Guidelines

<a href="https://elementor.com/?utm_source=github-repo&utm_medium=link&utm_campaign=contribution">![logo](https://user-images.githubusercontent.com/1778512/191041718-728d179e-07cb-4cb4-953a-6c294ee8c4db.png)</a>

**Welcome to the Elementor Contribution Guidelines**

Community contributions are always welcomed and help us remain the Number 1 WordPress Website Builder. Contributors can answer questions on all Elementor GitHub spaces or submit their contributions in the appropriate channels.

**Before submitting contributions, all participants should read and follow these Guidelines and our [Code of Conduct](https://elemn.to/gh-code-of-conduct).**

## How to use GitHub

We use GitHub **<ins>exclusively</ins>** for well-documented **Bug Reports**, **Feature Requests** and **Code Contributions (Pull Requests)**.
<br>Communication should always be in **English**.

### Need Help, Guidance, Assistance, or Support?

**Note that we are unable to offer any support through this repository.**

Please **DO NOT** open issues or discussions to request support.
<br>For those, use the appropriate channels.

**Find out how to [submit a Support Ticket here](https://elemn.to/support-ticket).**

Alternatively, you can visit one of these resources:

-   **Help Center** <br>Visit the [Elementor Help Center](https://elemn.to/gh-to-help-center) to find solutions to the most frequent problems, or read the documentation about Elementor's many features.
-   **Academy** <br>Grow your Web Creator skills and learn to make the most of Elementor in the [Elementor Academy](https://elemn.to/gh-to-academy).
-   **Global Community** <br>Join the [Elementor Global Community](https://elemn.to/community-on-fb) on Facebook. Where all kinds of users come together to help each other.
-   **Support Forum** <br>If you have more questions, visit the free [Support Forum](https://elemn.to/wp-support-forum) on our WordPress plugin page.
-   **Elementor Website** <br>For more information about features, FAQs, and documentation, check out our website at [Elementor Website Builder](https://elemn.to/gh-to-elementor).

**If you have an active [Elementor Pro](https://elemn.to/gh-to-elementor-pro) subscription, you are entitled to personal support. Please see your purchase email or visit your [Elementor Account page](https://elemn.to/my-elementor) for details.**

**As a gentle reminder, we may close support requests submitted to GitHub spaces without action.**

## How to report Security Issues

Security is paramount at Elementor. If you discover a security vulnerability, we want to hear about it right away, and we appreciate your help in disclosing it to us in a coordinated manner. For this reason, we run community-driven [Managed Security Bug Bounty programs](https://elemn.to/gh-to-bounty-programs).

We leverage the collective expertise of our community, offering round-the-clock crowdsourced vulnerability detection. These programs provide a comprehensive overview of features and endpoints considered 'in scope,' reward specifics where relevant, and our complete terms and conditions.

### Please do not report security issues on GitHub

Join our [Managed Security Bug Bounty programs](https://elemn.to/gh-to-bounty-programs) instead and help us maintain Elementor, a secure software, responsibly.

**To learn more about our security efforts and how to contact us for security inquiries, please visit our [Trust Center](https://elemn.to/gh-to-trust-center).**

## How to Report a Bug

If you found a bug in the source code and can reproduce it consistently after troubleshooting it, you can help us by [submitting a Bug Report](https://elemn.to/gh-new-bug-report).

### Before submitting your Bug Report, follow these best practices to help save time

-   **Search Before Posting** <br>Please [search for similar issues](https://elemn.to/gh-issues) (both open and closed) to prevent creating duplicates. <br>Use [GitHub Labels](https://elemn.to/gh-labels) to refine your search.
-   **Stay Up-to-date** <br>Ensure you are using the [most recent and stable versions](https://elemn.to/changelog) of Elementor (and Elementor Pro), as well as all installed plugins, themes, and WordPress.
-   **Troubleshoot your Issue** <br>Visit our [Help Center](https://elemn.to/gh-to-help-center) and use the search function to find [troubleshooting articles](https://elemn.to/help-troubleshooting) for the most common problems that can be solved quickly.
-   **Isolate the Problem and Validate your Issue** <br>Ensure your issue happens when only the **Elementor (and Elementor Pro)** plugins are active while also using the [Hello Elementor theme](https://elemn.to/wp-hello-elementor-theme). <br>Isolating the problem helps identify if Elementor causes the issue you're experiencing
-   **Write a Clear and Concise Title** <br>Summarize your title in a short sentence that can help identify your issue at a glance without needing to read the description.
-   **Provide a Detailed Description** <br>Please help us understand in detail what problems you are experiencing. <br>Give a detailed description of your problem, and provide examples, screenshots, screen recordings, and related links.
-   **Explain how we can Recreate your Issue** <br>Enumerate all the steps needed to reproduce the issue in detail so we can replicate it in our environment.
-   **Tell us what you were Expecting to Happen** <br>Describe the **Expected Behavior** to help identify the root of the issue.
-   **Share the Elementor System Info** <br>Be ready to share a full copy of the [Elementor System Info](https://elemn.to/help-system-info) report from your WordPress **`Dashboard`** > **`Elementor`** > **`System Info`** page (available at the bottom of the page). <br>**We won't accept issues without it. [Learn how to copy it here](https://elemn.to/help-system-info).**
-   **Write One Bug Report per Issue** <br>If you are experiencing more than one bug, submit only **<ins>ONE BUG PER ISSUE</ins>**.

**As a gentle reminder, we may close issues that do not comply with these guidelines without action.**

## How to Request a Feature

Do you have a brilliant idea, enhancement, or feature you would love to see in Elementor? We're all ears!

Suggest new ideas, features, or enhancements by [submitting a Feature Request](https://elemn.to/gh-new-feature-request).
<br>You can also support existing ideas by [voting for your favorite requests](https://elemn.to/gh-feature-requests).

### Before submitting a new Feature Request, follow these best practices to help save time

-   **Search Before Posting** <br>Before creating a new Feature Request, please [search for similar requests](https://elemn.to/gh-feature-requests) to prevent creating duplicates.
-   **Confirm Before Posting** <br>Please check the [Elementor Features page](https://elemn.to/features) before posting to avoid requesting an existing feature.
-   **Write a Clear and Concise Title** <br>Summarize your title in a short sentence that can help identify your request at a glance without needing to read the description.
-   **Provide a Detailed Description** <br>Elaborate on how you envision the feature. Include examples, use cases, and any other relevant details.
-   **Describe the Solution** <br>Describe how you'd like a solution to be implemented.
-   **Provide Alternatives** <br>Mention any alternative solutions or workarounds you've considered.
-   **Give Additional Context** <br>Add context to your suggestion by providing examples, screenshots, screen recordings, related links, and additional information that might help us understand your request better.
-   **Write One Request Per Thread** <br>If you have multiple requests, please submit only **<ins>ONE REQUEST PER THREAD</ins>**.

**As a gentle reminder, we may close requests that do not comply with these guidelines without action.**

## I want to Contribute

Community contributions are always welcome! We're glad to hear you are interested in helping shape the future of Elementor.

**There are many ways to contribute to Elementor**

### Translate

The Elementor User Interface was designed with a global audience in mind. It supports a wide range of languages and is also RTL compatible. Out of the box, we offer support for over 60 languages.

Want to make a difference? <br>We would appreciate your contribution by adding a new language or helping translate existing ones at [translate.wordpress.org](https://elemn.to/translate-repo). To assist you, we've built a short guide explaining [how to translate and localize the plugin](https://elemn.to/gh-to-help-localize-elementor).

### Community Support

Join others by answering questions on Elementor's GitHub spaces to help solve issues and engage in discussions. <br>Your insights and solutions can greatly assist others in navigating similar challenges.

### Submit Pull Requests

If you can submit fixes, improvements, or enhancements through pull requests, that's fantastic! We'd love your technical contributions. Please refer to our detailed [guide on submitting pull requests](#submitting-a-pr) below for more information.

#### Before Submitting a PR

-   **Search for Existing Issues** <br>Check if your issue has been reported already by searching through [existing Issues](https://elemn.to/gh-issues).
-   **Create a new Bug Report** <br>If you cannot find a similar issue, please [create a new Bug Report](https://elemn.to/gh-new-bug-report).
-   **Read our Documentation** <br>Visit the [Elementor Developers Center](https://elemn.to/gh-to-dev-center) and read the [Developers Documentation](https://elemn.to/gh-to-dev-docs) to learn how to extend Elementor.

#### Submitting a PR

-   **Fork the Repository** <br>Start by forking the Elementor repository on GitHub. Please ensure you're using the **`main`** branch.
-   **Create a new branch** <br>Create a new branch exclusive to the changes you're going to perform. This way, you can maintain separation between projects.
-   **Make your changes** <br>After you've forked the repository, you can start changing your copy of the code.
-   **Adhere to Coding Standards** <br>While making changes, ensure you stick to the [WordPress Coding Standards](https://elemn.to/wp-coding-standards). <br>If you've added new functions, actions, or filters, please document them properly following the [WordPress PHP Documentation Standards](https://elemn.to/wp-php-docs-standards).
-   **Commit with a Reference and Note** <br>When you commit your changes, reference your issue and include a note about your fix.
-   **Submit a Pull Request** <br>After pushing the changes to your fork, you're ready to submit a pull request to the main branch of the Elementor repository. Please follow our [Pull Request Template](https://elemn.to/gh-pr-template) when submitting your PR.

Our team will review your pull request and, if approved and everything is in order, merge it into the main branch. We are here to assist you in making sure your code aligns with the standards described above.

Your contributions, big or small, play a significant part in the continued development of Elementor. We can't wait to see what you have to share!

#### Additional Resources

-   [Elementor Developers Center](https://elemn.to/gh-to-dev-center)
-   [Elementor Developers Documentation](https://elemn.to/gh-to-dev-docs)
-   [GitHub Support and General Documentation](https://elemn.to/gh-support-center)
-   [GitHub Pull Request Documentation](https://elemn.to/gh-support-pull-requests)
