use mrusty::*;

use protocol::{WorldState, Entity};

const threshold : f64 = 0.1;

mrusty_class!(WorldState, "WorldState", {
    def!("time", |mruby, slf: (&WorldState)| {
        mruby.fixnum(slf.time as i32)
    });

    def!("entities", |mruby, slf: (&WorldState)| {
        let entities = slf.entities.iter()
            .map(|e| mruby.obj(e.clone()))
            .collect();

        mruby.array(entities)
    });
});

mrusty_class!(Entity, "Entity", {
    def!("id", |mruby, slf: (&Entity)| {
        mruby.fixnum(slf.id as i32)
    });

    def!("x", |mruby, slf: (&Entity)| {
        mruby.float(slf.x)
    });

    def!("y", |mruby, slf: (&Entity)| {
        mruby.float(slf.y)
    });

    def!("radius", |mruby, slf: (&Entity)| {
        mruby.float(slf.radius)
    });

    def!("creature?", |mruby, slf: (&Entity)| {
        mruby.bool(slf.entity_type == 0)
    });

    def!("resource?", |mruby, slf: (&Entity)| {
        mruby.bool(slf.entity_type == 1)
    });

    def!("spike?", |mruby, slf: (&Entity)| {
        mruby.bool(slf.entity_type == 2)
    });

    def!("distance", |mruby, slf: (&Entity), other: (&Entity)| {
        let dx = slf.x - other.x;
        let dy = slf.y - other.y;

        return mruby.float(dx * dx + dy * dy);
    });

    def!("<", |mruby, slf: (&Entity), other: (&Entity)| {
        return mruby.bool(other.radius - slf.radius > threshold);
    });

    def!(">", |mruby, slf: (&Entity), other: (&Entity)| {
        return mruby.bool(slf.radius - other.radius > threshold);
    });

});
