#pragma once
/*
    #version:1# (machine generated, don't edit!)

    Generated by sokol-shdc (https://github.com/floooh/sokol-tools)

    Cmdline:
        sokol-shdc --format sokol_impl --slang glsl410:glsl300es:hlsl4:metal_macos:metal_ios:wgsl -i shaders/sample-sdf.glsl -o shaders/sample-sdf.glsl.h

    Overview:
    =========
    Shader program: 'program':
        Get shader desc: sdf_program_shader_desc(sg_query_backend());
        Vertex Shader: vs
        Fragment Shader: fs
        Attributes:
            ATTR_program_coord => 0
    Bindings:
        Uniform block 'vs_uniforms':
            C struct: sdf_vs_uniforms_t
            Bind slot: UB_vs_uniforms => 0
        Uniform block 'fs_uniforms':
            C struct: sdf_fs_uniforms_t
            Bind slot: UB_fs_uniforms => 1
*/
#if !defined(SOKOL_GFX_INCLUDED)
#error "Please include sokol_gfx.h before sample-sdf.glsl.h"
#endif
#if !defined(SOKOL_SHDC_ALIGN)
#if defined(_MSC_VER)
#define SOKOL_SHDC_ALIGN(a) __declspec(align(a))
#else
#define SOKOL_SHDC_ALIGN(a) __attribute__((aligned(a)))
#endif
#endif
const sg_shader_desc* sdf_program_shader_desc(sg_backend backend);
#define ATTR_program_coord (0)
#define UB_vs_uniforms (0)
#define UB_fs_uniforms (1)
#pragma pack(push,1)
SOKOL_SHDC_ALIGN(16) typedef struct sdf_vs_uniforms_t {
    sgp_vec2 iResolution;
    uint8_t _pad_8[8];
} sdf_vs_uniforms_t;
#pragma pack(pop)
#pragma pack(push,1)
SOKOL_SHDC_ALIGN(16) typedef struct sdf_fs_uniforms_t {
    float iTime;
    uint8_t _pad_4[12];
} sdf_fs_uniforms_t;
#pragma pack(pop)
#if defined(SOKOL_SHDC_IMPL)
/*
    #version 410

    uniform vec4 vs_uniforms[1];
    layout(location = 0) in vec4 coord;
    layout(location = 1) out vec2 fragPos;
    layout(location = 0) out vec2 texUV;

    void main()
    {
        gl_Position = vec4(coord.xy, 0.0, 1.0);
        fragPos = vec2(coord.x * (vs_uniforms[0].x / vs_uniforms[0].y), coord.y);
        texUV = coord.zw;
    }

*/
static const uint8_t sdf_vs_source_glsl410[318] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x34,0x31,0x30,0x0a,0x0a,0x75,0x6e,
    0x69,0x66,0x6f,0x72,0x6d,0x20,0x76,0x65,0x63,0x34,0x20,0x76,0x73,0x5f,0x75,0x6e,
    0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,0x31,0x5d,0x3b,0x0a,0x6c,0x61,0x79,0x6f,0x75,
    0x74,0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x30,0x29,0x20,
    0x69,0x6e,0x20,0x76,0x65,0x63,0x34,0x20,0x63,0x6f,0x6f,0x72,0x64,0x3b,0x0a,0x6c,
    0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,
    0x20,0x31,0x29,0x20,0x6f,0x75,0x74,0x20,0x76,0x65,0x63,0x32,0x20,0x66,0x72,0x61,
    0x67,0x50,0x6f,0x73,0x3b,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,
    0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x30,0x29,0x20,0x6f,0x75,0x74,0x20,0x76,
    0x65,0x63,0x32,0x20,0x74,0x65,0x78,0x55,0x56,0x3b,0x0a,0x0a,0x76,0x6f,0x69,0x64,
    0x20,0x6d,0x61,0x69,0x6e,0x28,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x67,0x6c,
    0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x76,0x65,0x63,0x34,
    0x28,0x63,0x6f,0x6f,0x72,0x64,0x2e,0x78,0x79,0x2c,0x20,0x30,0x2e,0x30,0x2c,0x20,
    0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x72,0x61,0x67,0x50,0x6f,
    0x73,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x63,0x6f,0x6f,0x72,0x64,0x2e,0x78,
    0x20,0x2a,0x20,0x28,0x76,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,
    0x30,0x5d,0x2e,0x78,0x20,0x2f,0x20,0x76,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,
    0x6d,0x73,0x5b,0x30,0x5d,0x2e,0x79,0x29,0x2c,0x20,0x63,0x6f,0x6f,0x72,0x64,0x2e,
    0x79,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x74,0x65,0x78,0x55,0x56,0x20,0x3d,0x20,
    0x63,0x6f,0x6f,0x72,0x64,0x2e,0x7a,0x77,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #version 410

    uniform vec4 fs_uniforms[1];
    layout(location = 1) in vec2 fragPos;
    layout(location = 0) out vec4 fragColor;
    layout(location = 0) in vec2 texUV;

    vec3 background(vec2 uv)
    {
        vec2 _315 = abs(floor(uv));
        return vec3(0.38999998569488525390625) + (vec3(0.17000000178813934326171875) * mod(_315.x + _315.y, 2.0));
    }

    float length_n(inout vec2 p, float n)
    {
        p = pow(abs(p), vec2(n));
        return pow(p.x + p.y, 1.0 / n);
    }

    float sd_ellipsoid(vec2 p, vec2 r, float roundness)
    {
        vec2 param = p / r;
        float param_1 = roundness;
        float _103 = length_n(param, param_1);
        vec2 param_2 = p / (r * r);
        float param_3 = roundness;
        float _113 = length_n(param_2, param_3);
        return (_103 * (_103 - 1.0)) / _113;
    }

    vec3 blend(vec3 col, vec3 ocol, float d)
    {
        return mix(ocol, col, vec3(smoothstep(0.5, 0.0, d)));
    }

    float sd_line(vec2 p, vec2 a, vec2 b)
    {
        vec2 _240 = p - a;
        vec2 _244 = b - a;
        return length(_240 - (_244 * clamp(dot(_240, _244) / dot(_244, _244), 0.0, 1.0)));
    }

    vec2 rotate(vec2 p, float theta)
    {
        float _264 = cos(theta);
        float _267 = sin(theta);
        return vec2(fma(p.x, _264, -(p.y * _267)), fma(p.x, _267, p.y * _264));
    }

    float sd_vesica(inout vec2 p, float r, float d)
    {
        p = abs(p);
        float _132 = sqrt(fma(r, r, -(d * d)));
        float _145;
        if (((p.y - _132) * d) > (p.x * _132))
        {
            _145 = length(p - vec2(0.0, _132));
        }
        else
        {
            _145 = length(p - vec2(-d, 0.0)) - r;
        }
        return _145;
    }

    float smin(float a, float b, float k)
    {
        float _298 = max(k - abs(a - b), 0.0) / k;
        return fma(-((_298 * _298) * k), 0.25, min(a, b));
    }

    float sd_circle(vec2 p, float r)
    {
        return length(p) - r;
    }

    float sd_arc(inout vec2 p, float ta, float tb, float ra, float rb)
    {
        float _168 = cos(ta);
        float _170 = sin(ta);
        float _174 = cos(tb);
        float _176 = sin(tb);
        p *= mat2(vec2(_168, _170), vec2(-_170, _168));
        p.x = abs(p.x);
        float _209;
        if ((_176 * p.x) > (_174 * p.y))
        {
            _209 = dot(p, vec2(_174, _176));
        }
        else
        {
            _209 = length(p);
        }
        return sqrt(fma(ra * (-2.0), _209, fma(ra, ra, dot(p, p)))) - rb;
    }

    vec3 map(inout vec2 p)
    {
        p *= 100.0;
        p.y -= 30.0;
        vec2 _356 = vec2(abs(p.x), p.y);
        vec2 param = p * 0.300000011920928955078125;
        vec3 ocol = background(param);
        vec2 param_1 = p - vec2(0.0, -97.0);
        vec2 param_2 = vec2(55.0, 20.0);
        float param_3 = 2.0;
        float _374 = sd_ellipsoid(param_1, param_2, param_3);
        float d = _374;
        vec3 param_4 = vec3(0.61000001430511474609375, 0.85000002384185791015625, 0.939999997615814208984375);
        vec3 param_5 = ocol;
        float param_6 = _374;
        ocol = blend(param_4, param_5, param_6);
        vec2 q = _356;
        vec2 param_7 = _356;
        vec2 param_8 = vec2(55.0, 45.0);
        float param_9 = 2.400000095367431640625;
        d = sd_ellipsoid(param_7, param_8, param_9);
        vec2 _398 = q - vec2(45.0, -15.0);
        float _400 = _398.x;
        float _415 = sin(fs_uniforms[0].x);
        _398.y = fma((_400 * _400) * 0.0030000000260770320892333984375, _415, _398.y);
        q = _398;
        vec2 param_10 = _398;
        vec2 param_11 = vec2(0.0);
        vec2 param_12 = vec2(45.0, 0.0);
        d = min(d, sd_line(param_10, param_11, param_12) - 0.20000000298023223876953125);
        vec2 _922 = q;
        _922.y = fma((_922.x * _922.x) * 0.0030000000260770320892333984375, sin(fs_uniforms[0].x * 2.0), _922.y + 6.0);
        q = _922;
        vec2 param_13 = _922;
        vec2 param_14 = vec2(0.0);
        vec2 param_15 = vec2(45.0, 0.0);
        d = min(d, sd_line(param_13, param_14, param_15) - 0.20000000298023223876953125);
        vec2 _466 = _356 - vec2(32.0, 30.0);
        q = _466;
        vec2 param_16 = _466;
        float param_17 = fma(_415, 0.300000011920928955078125, 0.699999988079071044921875);
        vec2 _476 = rotate(param_16, param_17);
        q = _476;
        vec2 param_18 = _476;
        float param_19 = 30.0;
        float param_20 = 15.0;
        float _482 = sd_vesica(param_18, param_19, param_20);
        float _483 = d;
        float _485 = min(_483, _482);
        d = _485;
        vec3 param_21 = vec3(0.119999997317790985107421875);
        vec3 param_22 = ocol;
        float param_23 = _485;
        ocol = blend(param_21, param_22, param_23);
        q = _356;
        vec2 param_24 = _356 - vec2(0.0, -60.0);
        vec2 param_25 = vec2(27.0, 20.0);
        float param_26 = 2.0;
        d = sd_ellipsoid(param_24, param_25, param_26);
        vec2 param_27 = q - vec2(0.0, -70.0);
        vec2 param_28 = vec2(20.0, 16.0);
        float param_29 = 2.0;
        d = max(-sd_ellipsoid(param_27, param_28, param_29), d);
        vec2 _522 = _356 - vec2(6.0, -50.0);
        q = _522;
        vec2 param_30 = _522;
        float param_31 = fma(0.5, _415, 0.5) * (-0.100000001490116119384765625);
        vec2 _534 = rotate(param_30, param_31);
        _534.x = fma(-pow(max((-45.0) - _534.y, 0.0), 1.89999997615814208984375), 0.100000001490116119384765625, _534.x);
        q = _534;
        vec2 param_32 = _534;
        vec2 param_33 = vec2(0.0, -50.0);
        vec2 param_34 = vec2(0.0);
        float param_35 = d;
        float param_36 = sd_line(param_32, param_33, param_34) - 5.0;
        float param_37 = 1.0;
        d = smin(param_35, param_36, param_37);
        vec2 _564 = _356 - vec2(22.0, -60.0);
        q = _564;
        vec2 param_38 = _564;
        float param_39 = fma(0.5, cos(fs_uniforms[0].x), 0.5) * (-0.100000001490116119384765625);
        vec2 _575 = rotate(param_38, param_39);
        _575.x = fma(-pow(max((-29.0) - _575.y, 0.0), 1.89999997615814208984375), 0.100000001490116119384765625, _575.x);
        q = _575;
        vec2 param_40 = _575;
        vec2 param_41 = vec2(0.0, -35.0);
        vec2 param_42 = vec2(0.0);
        float param_43 = d;
        float param_44 = sd_line(param_40, param_41, param_42) - 5.0;
        float param_45 = 1.0;
        d = smin(param_43, param_44, param_45);
        vec2 _604 = p - vec2(-26.0, -60.0);
        q = _604;
        vec2 param_46 = _604;
        float param_47 = 2.19911479949951171875;
        vec2 _609 = rotate(param_46, param_47);
        float _611 = _609.y;
        _609.x = _609.x - fma(sin(fma(_611, 0.123000003397464752197265625, 3.0)), 4.0, sin(fma(_611, 0.100000001490116119384765625, fs_uniforms[0].x * 10.0)));
        q = _609;
        vec2 param_48 = _609;
        vec2 param_49 = vec2(0.0, -40.0);
        vec2 param_50 = vec2(0.0);
        float param_51 = d;
        float param_52 = fma(-5.0, smoothstep(-60.0, 0.0, q.y), sd_line(param_48, param_49, param_50));
        float param_53 = 1.0;
        float _650 = smin(param_51, param_52, param_53);
        d = _650;
        vec3 param_54 = vec3(0.119999997317790985107421875);
        vec3 param_55 = ocol;
        float param_56 = _650;
        ocol = blend(param_54, param_55, param_56);
        vec2 param_57 = q - vec2(-2.0, -4.0);
        float param_58 = 1.2999999523162841796875;
        float _665 = sd_circle(param_57, param_58);
        d = _665;
        vec2 param_59 = q - vec2(-2.0, -9.0);
        float param_60 = 1.2000000476837158203125;
        float _675 = min(_665, sd_circle(param_59, param_60));
        d = _675;
        vec2 param_61 = q - vec2(-2.0, -15.0);
        float param_62 = 1.10000002384185791015625;
        float _684 = min(_675, sd_circle(param_61, param_62));
        d = _684;
        vec2 param_63 = q - vec2(-2.0, -20.0);
        float param_64 = 1.0;
        float _693 = min(_684, sd_circle(param_63, param_64));
        d = _693;
        vec2 param_65 = q - vec2(-1.60000002384185791015625, -25.0);
        float param_66 = 0.89999997615814208984375;
        float _704 = min(_693, sd_circle(param_65, param_66));
        d = _704;
        vec2 param_67 = q - vec2(-1.2999999523162841796875, -29.0);
        float param_68 = 0.800000011920928955078125;
        float _714 = min(_704, sd_circle(param_67, param_68));
        d = _714;
        vec2 param_69 = q - vec2(-0.89999997615814208984375, -33.0);
        float param_70 = 0.699999988079071044921875;
        float _724 = min(_714, sd_circle(param_69, param_70));
        d = _724;
        vec2 param_71 = q - vec2(-0.800000011920928955078125, -37.0);
        float param_72 = 0.60000002384185791015625;
        float _735 = min(_724, sd_circle(param_71, param_72));
        d = _735;
        vec3 param_73 = vec3(0.61000001430511474609375, 0.85000002384185791015625, 0.939999997615814208984375);
        vec3 param_74 = ocol;
        float param_75 = _735;
        ocol = blend(param_73, param_74, param_75);
        vec2 _946 = _356;
        _946.y = p.y - (-11.0);
        q = _946;
        vec2 param_76 = _946 - vec2(0.0, -5.0);
        vec2 param_77 = vec2(40.0, 20.0);
        float param_78 = 2.900000095367431640625;
        d = sd_ellipsoid(param_76, param_77, param_78);
        vec2 param_79 = q - vec2(21.0, 0.0);
        float param_80 = 20.0;
        float param_81 = d;
        float param_82 = sd_circle(param_79, param_80);
        float param_83 = 5.0;
        float _770 = smin(param_81, param_82, param_83);
        d = _770;
        vec3 param_84 = vec3(0.980000019073486328125, 0.790000021457672119140625, 0.689999997615814208984375);
        vec3 param_85 = ocol;
        float param_86 = _770;
        ocol = blend(param_84, param_85, param_86);
        vec2 param_87 = q - vec2(0.0, fma(_415, 0.5, -12.0));
        float param_88 = 2.0;
        d = sd_circle(param_87, param_88);
        vec2 param_89 = q - vec2(0.0, -18.0);
        float param_90 = fma(_415, 0.300000011920928955078125, 3.1415927410125732421875);
        float param_91 = 0.300000011920928955078125;
        float param_92 = 4.0;
        float param_93 = 0.4000000059604644775390625;
        float _809 = sd_arc(param_89, param_90, param_91, param_92, param_93);
        float _810 = d;
        float _812 = min(_810, _809);
        d = _812;
        vec3 param_94 = vec3(0.670000016689300537109375, 0.36000001430511474609375, 0.319999992847442626953125);
        vec3 param_95 = ocol;
        float param_96 = _812;
        ocol = blend(param_94, param_95, param_96);
        vec2 _952 = _356;
        _952.y = (p.y - (-12.0)) / (1.0 - smoothstep(0.980000019073486328125, 1.0, sin(fs_uniforms[0].x * 3.0)));
        q = _952;
        vec2 param_97 = _952 - vec2(20.0, 0.0);
        vec2 param_98 = vec2(9.0, 12.0);
        float param_99 = 2.0;
        float _847 = sd_ellipsoid(param_97, param_98, param_99);
        d = _847;
        vec3 param_100 = vec3(1.0);
        vec3 param_101 = ocol;
        float param_102 = _847;
        ocol = blend(param_100, param_101, param_102);
        vec2 param_103 = q - vec2(19.5, 0.0);
        vec2 param_104 = vec2(5.0, 8.0);
        float param_105 = 2.0;
        float _864 = sd_ellipsoid(param_103, param_104, param_105);
        d = _864;
        vec3 param_106 = vec3(0.670000016689300537109375, 0.36000001430511474609375, 0.319999992847442626953125);
        vec3 param_107 = ocol;
        float param_108 = _864;
        ocol = blend(param_106, param_107, param_108);
        vec2 _873 = p - vec2(-2.0, 0.0);
        _873.x = abs(_873.x);
        q = _873;
        vec2 param_109 = _873 - vec2(19.5, -8.0);
        float param_110 = 1.2999999523162841796875;
        float _884 = sd_circle(param_109, param_110);
        d = _884;
        vec3 param_111 = vec3(1.0);
        vec3 param_112 = ocol;
        float param_113 = _884;
        vec3 _890 = blend(param_111, param_112, param_113);
        ocol = _890;
        return _890;
    }

    void main()
    {
        vec2 param = fragPos;
        vec3 _899 = map(param);
        fragColor = vec4(_899, 1.0);
    }

*/
static const uint8_t sdf_fs_source_glsl410[10978] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x34,0x31,0x30,0x0a,0x0a,0x75,0x6e,
    0x69,0x66,0x6f,0x72,0x6d,0x20,0x76,0x65,0x63,0x34,0x20,0x66,0x73,0x5f,0x75,0x6e,
    0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,0x31,0x5d,0x3b,0x0a,0x6c,0x61,0x79,0x6f,0x75,
    0x74,0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x31,0x29,0x20,
    0x69,0x6e,0x20,0x76,0x65,0x63,0x32,0x20,0x66,0x72,0x61,0x67,0x50,0x6f,0x73,0x3b,
    0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,
    0x20,0x3d,0x20,0x30,0x29,0x20,0x6f,0x75,0x74,0x20,0x76,0x65,0x63,0x34,0x20,0x66,
    0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,
    0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x30,0x29,0x20,0x69,
    0x6e,0x20,0x76,0x65,0x63,0x32,0x20,0x74,0x65,0x78,0x55,0x56,0x3b,0x0a,0x0a,0x76,
    0x65,0x63,0x33,0x20,0x62,0x61,0x63,0x6b,0x67,0x72,0x6f,0x75,0x6e,0x64,0x28,0x76,
    0x65,0x63,0x32,0x20,0x75,0x76,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,
    0x63,0x32,0x20,0x5f,0x33,0x31,0x35,0x20,0x3d,0x20,0x61,0x62,0x73,0x28,0x66,0x6c,
    0x6f,0x6f,0x72,0x28,0x75,0x76,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,
    0x74,0x75,0x72,0x6e,0x20,0x76,0x65,0x63,0x33,0x28,0x30,0x2e,0x33,0x38,0x39,0x39,
    0x39,0x39,0x39,0x38,0x35,0x36,0x39,0x34,0x38,0x38,0x35,0x32,0x35,0x33,0x39,0x30,
    0x36,0x32,0x35,0x29,0x20,0x2b,0x20,0x28,0x76,0x65,0x63,0x33,0x28,0x30,0x2e,0x31,
    0x37,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x37,0x38,0x38,0x31,0x33,0x39,0x33,0x34,
    0x33,0x32,0x36,0x31,0x37,0x31,0x38,0x37,0x35,0x29,0x20,0x2a,0x20,0x6d,0x6f,0x64,
    0x28,0x5f,0x33,0x31,0x35,0x2e,0x78,0x20,0x2b,0x20,0x5f,0x33,0x31,0x35,0x2e,0x79,
    0x2c,0x20,0x32,0x2e,0x30,0x29,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x5f,0x6e,0x28,0x69,0x6e,0x6f,0x75,0x74,
    0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x6e,
    0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x70,0x20,0x3d,0x20,0x70,0x6f,0x77,0x28,
    0x61,0x62,0x73,0x28,0x70,0x29,0x2c,0x20,0x76,0x65,0x63,0x32,0x28,0x6e,0x29,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x70,0x6f,0x77,
    0x28,0x70,0x2e,0x78,0x20,0x2b,0x20,0x70,0x2e,0x79,0x2c,0x20,0x31,0x2e,0x30,0x20,
    0x2f,0x20,0x6e,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x20,0x73,
    0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,0x64,0x28,0x76,0x65,0x63,0x32,
    0x20,0x70,0x2c,0x20,0x76,0x65,0x63,0x32,0x20,0x72,0x2c,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x72,0x6f,0x75,0x6e,0x64,0x6e,0x65,0x73,0x73,0x29,0x0a,0x7b,0x0a,0x20,
    0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x20,0x3d,0x20,
    0x70,0x20,0x2f,0x20,0x72,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x20,0x3d,0x20,0x72,0x6f,0x75,0x6e,0x64,
    0x6e,0x65,0x73,0x73,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x5f,0x31,0x30,0x33,0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x5f,0x6e,0x28,
    0x70,0x61,0x72,0x61,0x6d,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x32,0x20,0x3d,0x20,0x70,0x20,0x2f,0x20,0x28,0x72,0x20,0x2a,0x20,0x72,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x33,0x20,0x3d,0x20,0x72,0x6f,0x75,0x6e,0x64,0x6e,0x65,0x73,0x73,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,0x31,0x33,0x20,0x3d,
    0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x5f,0x6e,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x32,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x28,0x5f,0x31,0x30,0x33,0x20,0x2a,0x20,
    0x28,0x5f,0x31,0x30,0x33,0x20,0x2d,0x20,0x31,0x2e,0x30,0x29,0x29,0x20,0x2f,0x20,
    0x5f,0x31,0x31,0x33,0x3b,0x0a,0x7d,0x0a,0x0a,0x76,0x65,0x63,0x33,0x20,0x62,0x6c,
    0x65,0x6e,0x64,0x28,0x76,0x65,0x63,0x33,0x20,0x63,0x6f,0x6c,0x2c,0x20,0x76,0x65,
    0x63,0x33,0x20,0x6f,0x63,0x6f,0x6c,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x64,
    0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6d,
    0x69,0x78,0x28,0x6f,0x63,0x6f,0x6c,0x2c,0x20,0x63,0x6f,0x6c,0x2c,0x20,0x76,0x65,
    0x63,0x33,0x28,0x73,0x6d,0x6f,0x6f,0x74,0x68,0x73,0x74,0x65,0x70,0x28,0x30,0x2e,
    0x35,0x2c,0x20,0x30,0x2e,0x30,0x2c,0x20,0x64,0x29,0x29,0x29,0x3b,0x0a,0x7d,0x0a,
    0x0a,0x66,0x6c,0x6f,0x61,0x74,0x20,0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,0x28,0x76,
    0x65,0x63,0x32,0x20,0x70,0x2c,0x20,0x76,0x65,0x63,0x32,0x20,0x61,0x2c,0x20,0x76,
    0x65,0x63,0x32,0x20,0x62,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,
    0x32,0x20,0x5f,0x32,0x34,0x30,0x20,0x3d,0x20,0x70,0x20,0x2d,0x20,0x61,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x5f,0x32,0x34,0x34,0x20,0x3d,0x20,
    0x62,0x20,0x2d,0x20,0x61,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,
    0x6e,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x28,0x5f,0x32,0x34,0x30,0x20,0x2d,0x20,
    0x28,0x5f,0x32,0x34,0x34,0x20,0x2a,0x20,0x63,0x6c,0x61,0x6d,0x70,0x28,0x64,0x6f,
    0x74,0x28,0x5f,0x32,0x34,0x30,0x2c,0x20,0x5f,0x32,0x34,0x34,0x29,0x20,0x2f,0x20,
    0x64,0x6f,0x74,0x28,0x5f,0x32,0x34,0x34,0x2c,0x20,0x5f,0x32,0x34,0x34,0x29,0x2c,
    0x20,0x30,0x2e,0x30,0x2c,0x20,0x31,0x2e,0x30,0x29,0x29,0x29,0x3b,0x0a,0x7d,0x0a,
    0x0a,0x76,0x65,0x63,0x32,0x20,0x72,0x6f,0x74,0x61,0x74,0x65,0x28,0x76,0x65,0x63,
    0x32,0x20,0x70,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x74,0x68,0x65,0x74,0x61,
    0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x32,
    0x36,0x34,0x20,0x3d,0x20,0x63,0x6f,0x73,0x28,0x74,0x68,0x65,0x74,0x61,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x32,0x36,0x37,0x20,
    0x3d,0x20,0x73,0x69,0x6e,0x28,0x74,0x68,0x65,0x74,0x61,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x76,0x65,0x63,0x32,0x28,0x66,0x6d,
    0x61,0x28,0x70,0x2e,0x78,0x2c,0x20,0x5f,0x32,0x36,0x34,0x2c,0x20,0x2d,0x28,0x70,
    0x2e,0x79,0x20,0x2a,0x20,0x5f,0x32,0x36,0x37,0x29,0x29,0x2c,0x20,0x66,0x6d,0x61,
    0x28,0x70,0x2e,0x78,0x2c,0x20,0x5f,0x32,0x36,0x37,0x2c,0x20,0x70,0x2e,0x79,0x20,
    0x2a,0x20,0x5f,0x32,0x36,0x34,0x29,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x73,0x64,0x5f,0x76,0x65,0x73,0x69,0x63,0x61,0x28,0x69,0x6e,0x6f,
    0x75,0x74,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x72,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x64,0x29,0x0a,0x7b,0x0a,0x20,
    0x20,0x20,0x20,0x70,0x20,0x3d,0x20,0x61,0x62,0x73,0x28,0x70,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,0x33,0x32,0x20,0x3d,0x20,
    0x73,0x71,0x72,0x74,0x28,0x66,0x6d,0x61,0x28,0x72,0x2c,0x20,0x72,0x2c,0x20,0x2d,
    0x28,0x64,0x20,0x2a,0x20,0x64,0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,0x34,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,
    0x66,0x20,0x28,0x28,0x28,0x70,0x2e,0x79,0x20,0x2d,0x20,0x5f,0x31,0x33,0x32,0x29,
    0x20,0x2a,0x20,0x64,0x29,0x20,0x3e,0x20,0x28,0x70,0x2e,0x78,0x20,0x2a,0x20,0x5f,
    0x31,0x33,0x32,0x29,0x29,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x5f,0x31,0x34,0x35,0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,0x74,
    0x68,0x28,0x70,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x30,0x2e,0x30,0x2c,0x20,
    0x5f,0x31,0x33,0x32,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,
    0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x5f,0x31,0x34,0x35,0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,
    0x74,0x68,0x28,0x70,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x2d,0x64,0x2c,0x20,
    0x30,0x2e,0x30,0x29,0x29,0x20,0x2d,0x20,0x72,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,
    0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x5f,0x31,0x34,0x35,
    0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x20,0x73,0x6d,0x69,0x6e,0x28,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x61,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x62,
    0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x6b,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x32,0x39,0x38,0x20,0x3d,0x20,0x6d,0x61,
    0x78,0x28,0x6b,0x20,0x2d,0x20,0x61,0x62,0x73,0x28,0x61,0x20,0x2d,0x20,0x62,0x29,
    0x2c,0x20,0x30,0x2e,0x30,0x29,0x20,0x2f,0x20,0x6b,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x66,0x6d,0x61,0x28,0x2d,0x28,0x28,0x5f,0x32,
    0x39,0x38,0x20,0x2a,0x20,0x5f,0x32,0x39,0x38,0x29,0x20,0x2a,0x20,0x6b,0x29,0x2c,
    0x20,0x30,0x2e,0x32,0x35,0x2c,0x20,0x6d,0x69,0x6e,0x28,0x61,0x2c,0x20,0x62,0x29,
    0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x20,0x73,0x64,0x5f,0x63,
    0x69,0x72,0x63,0x6c,0x65,0x28,0x76,0x65,0x63,0x32,0x20,0x70,0x2c,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x72,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,
    0x75,0x72,0x6e,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x28,0x70,0x29,0x20,0x2d,0x20,
    0x72,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x20,0x73,0x64,0x5f,0x61,
    0x72,0x63,0x28,0x69,0x6e,0x6f,0x75,0x74,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x2c,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x74,0x61,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x74,0x62,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x72,0x61,0x2c,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x72,0x62,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,0x36,0x38,0x20,0x3d,0x20,0x63,0x6f,0x73,0x28,
    0x74,0x61,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,
    0x31,0x37,0x30,0x20,0x3d,0x20,0x73,0x69,0x6e,0x28,0x74,0x61,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,0x37,0x34,0x20,0x3d,0x20,
    0x63,0x6f,0x73,0x28,0x74,0x62,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x5f,0x31,0x37,0x36,0x20,0x3d,0x20,0x73,0x69,0x6e,0x28,0x74,0x62,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x70,0x20,0x2a,0x3d,0x20,0x6d,0x61,0x74,0x32,
    0x28,0x76,0x65,0x63,0x32,0x28,0x5f,0x31,0x36,0x38,0x2c,0x20,0x5f,0x31,0x37,0x30,
    0x29,0x2c,0x20,0x76,0x65,0x63,0x32,0x28,0x2d,0x5f,0x31,0x37,0x30,0x2c,0x20,0x5f,
    0x31,0x36,0x38,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x70,0x2e,0x78,0x20,0x3d,
    0x20,0x61,0x62,0x73,0x28,0x70,0x2e,0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x5f,0x32,0x30,0x39,0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,
    0x66,0x20,0x28,0x28,0x5f,0x31,0x37,0x36,0x20,0x2a,0x20,0x70,0x2e,0x78,0x29,0x20,
    0x3e,0x20,0x28,0x5f,0x31,0x37,0x34,0x20,0x2a,0x20,0x70,0x2e,0x79,0x29,0x29,0x0a,
    0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x32,
    0x30,0x39,0x20,0x3d,0x20,0x64,0x6f,0x74,0x28,0x70,0x2c,0x20,0x76,0x65,0x63,0x32,
    0x28,0x5f,0x31,0x37,0x34,0x2c,0x20,0x5f,0x31,0x37,0x36,0x29,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,0x20,0x20,
    0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x32,0x30,0x39,
    0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x28,0x70,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x73,
    0x71,0x72,0x74,0x28,0x66,0x6d,0x61,0x28,0x72,0x61,0x20,0x2a,0x20,0x28,0x2d,0x32,
    0x2e,0x30,0x29,0x2c,0x20,0x5f,0x32,0x30,0x39,0x2c,0x20,0x66,0x6d,0x61,0x28,0x72,
    0x61,0x2c,0x20,0x72,0x61,0x2c,0x20,0x64,0x6f,0x74,0x28,0x70,0x2c,0x20,0x70,0x29,
    0x29,0x29,0x29,0x20,0x2d,0x20,0x72,0x62,0x3b,0x0a,0x7d,0x0a,0x0a,0x76,0x65,0x63,
    0x33,0x20,0x6d,0x61,0x70,0x28,0x69,0x6e,0x6f,0x75,0x74,0x20,0x76,0x65,0x63,0x32,
    0x20,0x70,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x70,0x20,0x2a,0x3d,0x20,0x31,
    0x30,0x30,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x70,0x2e,0x79,0x20,0x2d,0x3d,
    0x20,0x33,0x30,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,
    0x5f,0x33,0x35,0x36,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x61,0x62,0x73,0x28,
    0x70,0x2e,0x78,0x29,0x2c,0x20,0x70,0x2e,0x79,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x20,0x3d,0x20,0x70,0x20,0x2a,
    0x20,0x30,0x2e,0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,
    0x32,0x38,0x39,0x35,0x35,0x30,0x37,0x38,0x31,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x76,0x65,0x63,0x33,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x61,0x63,
    0x6b,0x67,0x72,0x6f,0x75,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x20,0x3d,0x20,0x70,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x30,0x2e,0x30,0x2c,
    0x20,0x2d,0x39,0x37,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,
    0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,
    0x28,0x35,0x35,0x2e,0x30,0x2c,0x20,0x32,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x20,
    0x3d,0x20,0x32,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x5f,0x33,0x37,0x34,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,
    0x73,0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x2c,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x32,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x64,0x20,0x3d,0x20,0x5f,
    0x33,0x37,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x34,0x20,0x3d,0x20,0x76,0x65,0x63,0x33,0x28,0x30,0x2e,0x36,
    0x31,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x33,0x30,0x35,0x31,0x31,0x34,0x37,0x34,
    0x36,0x30,0x39,0x33,0x37,0x35,0x2c,0x20,0x30,0x2e,0x38,0x35,0x30,0x30,0x30,0x30,
    0x30,0x32,0x33,0x38,0x34,0x31,0x38,0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,0x32,
    0x35,0x2c,0x20,0x30,0x2e,0x39,0x33,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,0x31,
    0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,
    0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x20,0x3d,0x20,0x5f,0x33,0x37,
    0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,
    0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x35,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x71,0x20,0x3d,0x20,0x5f,0x33,0x35,
    0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x37,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x20,0x3d,0x20,0x76,
    0x65,0x63,0x32,0x28,0x35,0x35,0x2e,0x30,0x2c,0x20,0x34,0x35,0x2e,0x30,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x39,0x20,0x3d,0x20,0x32,0x2e,0x34,0x30,0x30,0x30,0x30,0x30,0x30,0x39,0x35,
    0x33,0x36,0x37,0x34,0x33,0x31,0x36,0x34,0x30,0x36,0x32,0x35,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,
    0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x2c,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x38,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x5f,0x33,0x39,0x38,0x20,0x3d,0x20,0x71,
    0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x34,0x35,0x2e,0x30,0x2c,0x20,0x2d,0x31,
    0x35,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x5f,0x34,0x30,0x30,0x20,0x3d,0x20,0x5f,0x33,0x39,0x38,0x2e,0x78,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,0x31,0x35,0x20,0x3d,0x20,
    0x73,0x69,0x6e,0x28,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,
    0x30,0x5d,0x2e,0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x33,0x39,0x38,0x2e,
    0x79,0x20,0x3d,0x20,0x66,0x6d,0x61,0x28,0x28,0x5f,0x34,0x30,0x30,0x20,0x2a,0x20,
    0x5f,0x34,0x30,0x30,0x29,0x20,0x2a,0x20,0x30,0x2e,0x30,0x30,0x33,0x30,0x30,0x30,
    0x30,0x30,0x30,0x30,0x32,0x36,0x30,0x37,0x37,0x30,0x33,0x32,0x30,0x38,0x39,0x32,
    0x33,0x33,0x33,0x39,0x38,0x34,0x33,0x37,0x35,0x2c,0x20,0x5f,0x34,0x31,0x35,0x2c,
    0x20,0x5f,0x33,0x39,0x38,0x2e,0x79,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,
    0x3d,0x20,0x5f,0x33,0x39,0x38,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x20,0x3d,0x20,0x5f,0x33,0x39,0x38,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x31,0x31,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x30,0x2e,0x30,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x31,0x32,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x34,0x35,0x2e,0x30,0x2c,0x20,
    0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x6d,0x69,
    0x6e,0x28,0x64,0x2c,0x20,0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x30,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x32,0x29,0x20,0x2d,0x20,0x30,0x2e,0x32,
    0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x39,0x38,0x30,0x32,0x33,0x32,0x32,0x33,
    0x38,0x37,0x36,0x39,0x35,0x33,0x31,0x32,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x76,0x65,0x63,0x32,0x20,0x5f,0x39,0x32,0x32,0x20,0x3d,0x20,0x71,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x5f,0x39,0x32,0x32,0x2e,0x79,0x20,0x3d,0x20,0x66,0x6d,0x61,0x28,
    0x28,0x5f,0x39,0x32,0x32,0x2e,0x78,0x20,0x2a,0x20,0x5f,0x39,0x32,0x32,0x2e,0x78,
    0x29,0x20,0x2a,0x20,0x30,0x2e,0x30,0x30,0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
    0x32,0x36,0x30,0x37,0x37,0x30,0x33,0x32,0x30,0x38,0x39,0x32,0x33,0x33,0x33,0x39,
    0x38,0x34,0x33,0x37,0x35,0x2c,0x20,0x73,0x69,0x6e,0x28,0x66,0x73,0x5f,0x75,0x6e,
    0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,0x30,0x5d,0x2e,0x78,0x20,0x2a,0x20,0x32,0x2e,
    0x30,0x29,0x2c,0x20,0x5f,0x39,0x32,0x32,0x2e,0x79,0x20,0x2b,0x20,0x36,0x2e,0x30,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x39,0x32,0x32,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x31,0x33,0x20,0x3d,0x20,0x5f,0x39,0x32,0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,
    0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x34,0x20,0x3d,0x20,0x76,
    0x65,0x63,0x32,0x28,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,
    0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x35,0x20,0x3d,0x20,0x76,0x65,
    0x63,0x32,0x28,0x34,0x35,0x2e,0x30,0x2c,0x20,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x64,0x2c,0x20,0x73,0x64,
    0x5f,0x6c,0x69,0x6e,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x33,0x2c,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x31,0x35,0x29,0x20,0x2d,0x20,0x30,0x2e,0x32,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
    0x32,0x39,0x38,0x30,0x32,0x33,0x32,0x32,0x33,0x38,0x37,0x36,0x39,0x35,0x33,0x31,
    0x32,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x5f,0x34,
    0x36,0x36,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,
    0x28,0x33,0x32,0x2e,0x30,0x2c,0x20,0x33,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x34,0x36,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x36,0x20,0x3d,0x20,
    0x5f,0x34,0x36,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x37,0x20,0x3d,0x20,0x66,0x6d,0x61,0x28,0x5f,
    0x34,0x31,0x35,0x2c,0x20,0x30,0x2e,0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,
    0x39,0x32,0x30,0x39,0x32,0x38,0x39,0x35,0x35,0x30,0x37,0x38,0x31,0x32,0x35,0x2c,
    0x20,0x30,0x2e,0x36,0x39,0x39,0x39,0x39,0x39,0x39,0x38,0x38,0x30,0x37,0x39,0x30,
    0x37,0x31,0x30,0x34,0x34,0x39,0x32,0x31,0x38,0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x5f,0x34,0x37,0x36,0x20,0x3d,0x20,0x72,0x6f,
    0x74,0x61,0x74,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x36,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x37,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,
    0x3d,0x20,0x5f,0x34,0x37,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x38,0x20,0x3d,0x20,0x5f,0x34,0x37,0x36,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x31,0x39,0x20,0x3d,0x20,0x33,0x30,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x30,0x20,
    0x3d,0x20,0x31,0x35,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x5f,0x34,0x38,0x32,0x20,0x3d,0x20,0x73,0x64,0x5f,0x76,0x65,0x73,0x69,
    0x63,0x61,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x38,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x39,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x30,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,0x38,0x33,
    0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x5f,0x34,0x38,0x35,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x5f,0x34,0x38,0x33,0x2c,
    0x20,0x5f,0x34,0x38,0x32,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,
    0x5f,0x34,0x38,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x33,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x32,0x31,0x20,0x3d,0x20,0x76,0x65,0x63,0x33,0x28,0x30,
    0x2e,0x31,0x31,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x33,0x31,0x37,0x37,0x39,0x30,
    0x39,0x38,0x35,0x31,0x30,0x37,0x34,0x32,0x31,0x38,0x37,0x35,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x32,
    0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x33,0x20,0x3d,0x20,0x5f,0x34,
    0x38,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,
    0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x31,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x32,0x32,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,
    0x33,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x32,0x34,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x20,0x2d,0x20,0x76,0x65,0x63,
    0x32,0x28,0x30,0x2e,0x30,0x2c,0x20,0x2d,0x36,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x35,
    0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x32,0x37,0x2e,0x30,0x2c,0x20,0x32,0x30,
    0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x32,0x36,0x20,0x3d,0x20,0x32,0x2e,0x30,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,
    0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x34,0x2c,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x32,0x35,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x36,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x32,0x37,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,
    0x30,0x2e,0x30,0x2c,0x20,0x2d,0x37,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x38,0x20,0x3d,
    0x20,0x76,0x65,0x63,0x32,0x28,0x32,0x30,0x2e,0x30,0x2c,0x20,0x31,0x36,0x2e,0x30,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x32,0x39,0x20,0x3d,0x20,0x32,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x64,0x20,0x3d,0x20,0x6d,0x61,0x78,0x28,0x2d,0x73,0x64,0x5f,0x65,0x6c,0x6c,
    0x69,0x70,0x73,0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x37,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x38,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x32,0x39,0x29,0x2c,0x20,0x64,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,
    0x63,0x32,0x20,0x5f,0x35,0x32,0x32,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x20,0x2d,
    0x20,0x76,0x65,0x63,0x32,0x28,0x36,0x2e,0x30,0x2c,0x20,0x2d,0x35,0x30,0x2e,0x30,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x35,0x32,0x32,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x33,0x30,0x20,0x3d,0x20,0x5f,0x35,0x32,0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x31,0x20,0x3d,0x20,
    0x66,0x6d,0x61,0x28,0x30,0x2e,0x35,0x2c,0x20,0x5f,0x34,0x31,0x35,0x2c,0x20,0x30,
    0x2e,0x35,0x29,0x20,0x2a,0x20,0x28,0x2d,0x30,0x2e,0x31,0x30,0x30,0x30,0x30,0x30,
    0x30,0x30,0x31,0x34,0x39,0x30,0x31,0x31,0x36,0x31,0x31,0x39,0x33,0x38,0x34,0x37,
    0x36,0x35,0x36,0x32,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,
    0x20,0x5f,0x35,0x33,0x34,0x20,0x3d,0x20,0x72,0x6f,0x74,0x61,0x74,0x65,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x33,0x30,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,
    0x31,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x35,0x33,0x34,0x2e,0x78,0x20,0x3d,
    0x20,0x66,0x6d,0x61,0x28,0x2d,0x70,0x6f,0x77,0x28,0x6d,0x61,0x78,0x28,0x28,0x2d,
    0x34,0x35,0x2e,0x30,0x29,0x20,0x2d,0x20,0x5f,0x35,0x33,0x34,0x2e,0x79,0x2c,0x20,
    0x30,0x2e,0x30,0x29,0x2c,0x20,0x31,0x2e,0x38,0x39,0x39,0x39,0x39,0x39,0x39,0x37,
    0x36,0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x29,
    0x2c,0x20,0x30,0x2e,0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x39,0x30,
    0x31,0x31,0x36,0x31,0x31,0x39,0x33,0x38,0x34,0x37,0x36,0x35,0x36,0x32,0x35,0x2c,
    0x20,0x5f,0x35,0x33,0x34,0x2e,0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,
    0x3d,0x20,0x5f,0x35,0x33,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x32,0x20,0x3d,0x20,0x5f,0x35,0x33,0x34,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x33,0x33,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x30,0x2e,0x30,0x2c,0x20,
    0x2d,0x35,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x34,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,
    0x28,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x35,0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,
    0x36,0x20,0x3d,0x20,0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,0x28,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x33,0x32,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x33,0x2c,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x34,0x29,0x20,0x2d,0x20,0x35,0x2e,0x30,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x33,0x37,0x20,0x3d,0x20,0x31,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,
    0x20,0x3d,0x20,0x73,0x6d,0x69,0x6e,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x35,
    0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x36,0x2c,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x33,0x37,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,
    0x5f,0x35,0x36,0x34,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x20,0x2d,0x20,0x76,0x65,
    0x63,0x32,0x28,0x32,0x32,0x2e,0x30,0x2c,0x20,0x2d,0x36,0x30,0x2e,0x30,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x35,0x36,0x34,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x38,
    0x20,0x3d,0x20,0x5f,0x35,0x36,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x39,0x20,0x3d,0x20,0x66,0x6d,
    0x61,0x28,0x30,0x2e,0x35,0x2c,0x20,0x63,0x6f,0x73,0x28,0x66,0x73,0x5f,0x75,0x6e,
    0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,0x30,0x5d,0x2e,0x78,0x29,0x2c,0x20,0x30,0x2e,
    0x35,0x29,0x20,0x2a,0x20,0x28,0x2d,0x30,0x2e,0x31,0x30,0x30,0x30,0x30,0x30,0x30,
    0x30,0x31,0x34,0x39,0x30,0x31,0x31,0x36,0x31,0x31,0x39,0x33,0x38,0x34,0x37,0x36,
    0x35,0x36,0x32,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,
    0x5f,0x35,0x37,0x35,0x20,0x3d,0x20,0x72,0x6f,0x74,0x61,0x74,0x65,0x28,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x33,0x38,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x39,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x35,0x37,0x35,0x2e,0x78,0x20,0x3d,0x20,
    0x66,0x6d,0x61,0x28,0x2d,0x70,0x6f,0x77,0x28,0x6d,0x61,0x78,0x28,0x28,0x2d,0x32,
    0x39,0x2e,0x30,0x29,0x20,0x2d,0x20,0x5f,0x35,0x37,0x35,0x2e,0x79,0x2c,0x20,0x30,
    0x2e,0x30,0x29,0x2c,0x20,0x31,0x2e,0x38,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,
    0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x29,0x2c,
    0x20,0x30,0x2e,0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x39,0x30,0x31,
    0x31,0x36,0x31,0x31,0x39,0x33,0x38,0x34,0x37,0x36,0x35,0x36,0x32,0x35,0x2c,0x20,
    0x5f,0x35,0x37,0x35,0x2e,0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,
    0x20,0x5f,0x35,0x37,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x30,0x20,0x3d,0x20,0x5f,0x35,0x37,0x35,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x34,0x31,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x30,0x2e,0x30,0x2c,0x20,0x2d,
    0x33,0x35,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x32,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,
    0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x33,0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x34,
    0x20,0x3d,0x20,0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x34,0x30,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x31,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x34,0x32,0x29,0x20,0x2d,0x20,0x35,0x2e,0x30,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x34,0x35,0x20,0x3d,0x20,0x31,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,
    0x3d,0x20,0x73,0x6d,0x69,0x6e,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x33,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x34,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x5f,
    0x36,0x30,0x34,0x20,0x3d,0x20,0x70,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x2d,
    0x32,0x36,0x2e,0x30,0x2c,0x20,0x2d,0x36,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x36,0x30,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x36,0x20,0x3d,0x20,
    0x5f,0x36,0x30,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x37,0x20,0x3d,0x20,0x32,0x2e,0x31,0x39,0x39,
    0x31,0x31,0x34,0x37,0x39,0x39,0x34,0x39,0x39,0x35,0x31,0x31,0x37,0x31,0x38,0x37,
    0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x5f,0x36,0x30,0x39,
    0x20,0x3d,0x20,0x72,0x6f,0x74,0x61,0x74,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x34,0x36,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x37,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x31,0x31,0x20,0x3d,0x20,
    0x5f,0x36,0x30,0x39,0x2e,0x79,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x36,0x30,0x39,
    0x2e,0x78,0x20,0x3d,0x20,0x5f,0x36,0x30,0x39,0x2e,0x78,0x20,0x2d,0x20,0x66,0x6d,
    0x61,0x28,0x73,0x69,0x6e,0x28,0x66,0x6d,0x61,0x28,0x5f,0x36,0x31,0x31,0x2c,0x20,
    0x30,0x2e,0x31,0x32,0x33,0x30,0x30,0x30,0x30,0x30,0x33,0x33,0x39,0x37,0x34,0x36,
    0x34,0x37,0x35,0x32,0x31,0x39,0x37,0x32,0x36,0x35,0x36,0x32,0x35,0x2c,0x20,0x33,
    0x2e,0x30,0x29,0x29,0x2c,0x20,0x34,0x2e,0x30,0x2c,0x20,0x73,0x69,0x6e,0x28,0x66,
    0x6d,0x61,0x28,0x5f,0x36,0x31,0x31,0x2c,0x20,0x30,0x2e,0x31,0x30,0x30,0x30,0x30,
    0x30,0x30,0x30,0x31,0x34,0x39,0x30,0x31,0x31,0x36,0x31,0x31,0x39,0x33,0x38,0x34,
    0x37,0x36,0x35,0x36,0x32,0x35,0x2c,0x20,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,
    0x72,0x6d,0x73,0x5b,0x30,0x5d,0x2e,0x78,0x20,0x2a,0x20,0x31,0x30,0x2e,0x30,0x29,
    0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x36,0x30,0x39,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x34,0x38,0x20,0x3d,0x20,0x5f,0x36,0x30,0x39,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x39,0x20,0x3d,0x20,
    0x76,0x65,0x63,0x32,0x28,0x30,0x2e,0x30,0x2c,0x20,0x2d,0x34,0x30,0x2e,0x30,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x35,0x30,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x30,0x2e,0x30,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x35,0x31,0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x32,0x20,0x3d,0x20,0x66,0x6d,
    0x61,0x28,0x2d,0x35,0x2e,0x30,0x2c,0x20,0x73,0x6d,0x6f,0x6f,0x74,0x68,0x73,0x74,
    0x65,0x70,0x28,0x2d,0x36,0x30,0x2e,0x30,0x2c,0x20,0x30,0x2e,0x30,0x2c,0x20,0x71,
    0x2e,0x79,0x29,0x2c,0x20,0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x34,0x38,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x39,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x30,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x33,0x20,
    0x3d,0x20,0x31,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x5f,0x36,0x35,0x30,0x20,0x3d,0x20,0x73,0x6d,0x69,0x6e,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x35,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x32,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x33,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x64,0x20,0x3d,0x20,0x5f,0x36,0x35,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,
    0x63,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x34,0x20,0x3d,0x20,0x76,0x65,
    0x63,0x33,0x28,0x30,0x2e,0x31,0x31,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x33,0x31,
    0x37,0x37,0x39,0x30,0x39,0x38,0x35,0x31,0x30,0x37,0x34,0x32,0x31,0x38,0x37,0x35,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x35,0x35,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x36,0x20,
    0x3d,0x20,0x5f,0x36,0x35,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,
    0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,
    0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x35,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x35,0x36,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x37,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,
    0x76,0x65,0x63,0x32,0x28,0x2d,0x32,0x2e,0x30,0x2c,0x20,0x2d,0x34,0x2e,0x30,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x35,0x38,0x20,0x3d,0x20,0x31,0x2e,0x32,0x39,0x39,0x39,0x39,0x39,0x39,
    0x35,0x32,0x33,0x31,0x36,0x32,0x38,0x34,0x31,0x37,0x39,0x36,0x38,0x37,0x35,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x36,0x35,0x20,
    0x3d,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x35,0x37,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x38,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x36,0x36,0x35,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x39,
    0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x2d,0x32,0x2e,0x30,
    0x2c,0x20,0x2d,0x39,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x30,0x20,0x3d,0x20,0x31,0x2e,
    0x32,0x30,0x30,0x30,0x30,0x30,0x30,0x34,0x37,0x36,0x38,0x33,0x37,0x31,0x35,0x38,
    0x32,0x30,0x33,0x31,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x5f,0x36,0x37,0x35,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x5f,0x36,0x36,
    0x35,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x35,0x39,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x30,0x29,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x36,0x37,0x35,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x36,0x31,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x2d,0x32,
    0x2e,0x30,0x2c,0x20,0x2d,0x31,0x35,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x32,0x20,0x3d,
    0x20,0x31,0x2e,0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x33,0x38,0x34,0x31,0x38,
    0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x38,0x34,0x20,0x3d,0x20,0x6d,0x69,0x6e,
    0x28,0x5f,0x36,0x37,0x35,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,
    0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x36,0x32,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,
    0x36,0x38,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x36,0x33,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x76,0x65,0x63,
    0x32,0x28,0x2d,0x32,0x2e,0x30,0x2c,0x20,0x2d,0x32,0x30,0x2e,0x30,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x36,0x34,0x20,0x3d,0x20,0x31,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x5f,0x36,0x39,0x33,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x5f,
    0x36,0x38,0x34,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x36,0x33,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,
    0x34,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x36,0x39,
    0x33,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x36,0x35,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,
    0x2d,0x31,0x2e,0x36,0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x33,0x38,0x34,0x31,0x38,
    0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,0x32,0x35,0x2c,0x20,0x2d,0x32,0x35,0x2e,
    0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x36,0x36,0x20,0x3d,0x20,0x30,0x2e,0x38,0x39,0x39,0x39,0x39,
    0x39,0x39,0x37,0x36,0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,
    0x37,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x37,
    0x30,0x34,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x5f,0x36,0x39,0x33,0x2c,0x20,0x73,
    0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,
    0x35,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x36,0x29,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x37,0x30,0x34,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x37,0x20,0x3d,
    0x20,0x71,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x2d,0x31,0x2e,0x32,0x39,0x39,
    0x39,0x39,0x39,0x39,0x35,0x32,0x33,0x31,0x36,0x32,0x38,0x34,0x31,0x37,0x39,0x36,
    0x38,0x37,0x35,0x2c,0x20,0x2d,0x32,0x39,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x38,0x20,
    0x3d,0x20,0x30,0x2e,0x38,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,
    0x39,0x32,0x38,0x39,0x35,0x35,0x30,0x37,0x38,0x31,0x32,0x35,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x37,0x31,0x34,0x20,0x3d,0x20,0x6d,
    0x69,0x6e,0x28,0x5f,0x37,0x30,0x34,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,
    0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x37,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x36,0x38,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,
    0x20,0x5f,0x37,0x31,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x39,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x76,
    0x65,0x63,0x32,0x28,0x2d,0x30,0x2e,0x38,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,
    0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x2c,0x20,
    0x2d,0x33,0x33,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x30,0x20,0x3d,0x20,0x30,0x2e,0x36,
    0x39,0x39,0x39,0x39,0x39,0x39,0x38,0x38,0x30,0x37,0x39,0x30,0x37,0x31,0x30,0x34,
    0x34,0x39,0x32,0x31,0x38,0x37,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x5f,0x37,0x32,0x34,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x5f,0x37,
    0x31,0x34,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x36,0x39,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x30,
    0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x37,0x32,0x34,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x37,0x31,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x2d,
    0x30,0x2e,0x38,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,
    0x38,0x39,0x35,0x35,0x30,0x37,0x38,0x31,0x32,0x35,0x2c,0x20,0x2d,0x33,0x37,0x2e,
    0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x37,0x32,0x20,0x3d,0x20,0x30,0x2e,0x36,0x30,0x30,0x30,0x30,
    0x30,0x30,0x32,0x33,0x38,0x34,0x31,0x38,0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,
    0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x37,
    0x33,0x35,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x5f,0x37,0x32,0x34,0x2c,0x20,0x73,
    0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,
    0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x32,0x29,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x37,0x33,0x35,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x33,0x20,0x3d,
    0x20,0x76,0x65,0x63,0x33,0x28,0x30,0x2e,0x36,0x31,0x30,0x30,0x30,0x30,0x30,0x31,
    0x34,0x33,0x30,0x35,0x31,0x31,0x34,0x37,0x34,0x36,0x30,0x39,0x33,0x37,0x35,0x2c,
    0x20,0x30,0x2e,0x38,0x35,0x30,0x30,0x30,0x30,0x30,0x32,0x33,0x38,0x34,0x31,0x38,
    0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,0x32,0x35,0x2c,0x20,0x30,0x2e,0x39,0x33,
    0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,
    0x39,0x38,0x34,0x33,0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,
    0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x34,0x20,0x3d,0x20,0x6f,0x63,0x6f,
    0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x37,0x35,0x20,0x3d,0x20,0x5f,0x37,0x33,0x35,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x37,0x33,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,
    0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x5f,0x39,0x34,0x36,0x20,0x3d,0x20,0x5f,0x33,
    0x35,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x39,0x34,0x36,0x2e,0x79,0x20,0x3d,
    0x20,0x70,0x2e,0x79,0x20,0x2d,0x20,0x28,0x2d,0x31,0x31,0x2e,0x30,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x39,0x34,0x36,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x36,0x20,
    0x3d,0x20,0x5f,0x39,0x34,0x36,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x30,0x2e,
    0x30,0x2c,0x20,0x2d,0x35,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,
    0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x37,0x20,0x3d,0x20,0x76,0x65,
    0x63,0x32,0x28,0x34,0x30,0x2e,0x30,0x2c,0x20,0x32,0x30,0x2e,0x30,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x37,0x38,0x20,0x3d,0x20,0x32,0x2e,0x39,0x30,0x30,0x30,0x30,0x30,0x30,0x39,0x35,
    0x33,0x36,0x37,0x34,0x33,0x31,0x36,0x34,0x30,0x36,0x32,0x35,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,
    0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x36,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x37,0x37,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x38,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x37,0x39,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x32,
    0x31,0x2e,0x30,0x2c,0x20,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x30,0x20,0x3d,0x20,
    0x32,0x30,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x31,0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x32,
    0x20,0x3d,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x37,0x39,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x30,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x38,0x33,0x20,0x3d,0x20,0x35,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x37,0x37,0x30,0x20,0x3d,0x20,0x73,0x6d,0x69,
    0x6e,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x38,0x32,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x33,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x37,0x37,0x30,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x34,
    0x20,0x3d,0x20,0x76,0x65,0x63,0x33,0x28,0x30,0x2e,0x39,0x38,0x30,0x30,0x30,0x30,
    0x30,0x31,0x39,0x30,0x37,0x33,0x34,0x38,0x36,0x33,0x32,0x38,0x31,0x32,0x35,0x2c,
    0x20,0x30,0x2e,0x37,0x39,0x30,0x30,0x30,0x30,0x30,0x32,0x31,0x34,0x35,0x37,0x36,
    0x37,0x32,0x31,0x31,0x39,0x31,0x34,0x30,0x36,0x32,0x35,0x2c,0x20,0x30,0x2e,0x36,
    0x38,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,0x31,0x35,0x38,0x31,0x34,0x32,0x30,
    0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,
    0x63,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x35,0x20,0x3d,0x20,0x6f,0x63,
    0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x38,0x36,0x20,0x3d,0x20,0x5f,0x37,0x37,0x30,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x38,0x35,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x36,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x37,
    0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x30,0x2e,0x30,0x2c,
    0x20,0x66,0x6d,0x61,0x28,0x5f,0x34,0x31,0x35,0x2c,0x20,0x30,0x2e,0x35,0x2c,0x20,
    0x2d,0x31,0x32,0x2e,0x30,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x38,0x20,0x3d,0x20,0x32,0x2e,
    0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x64,0x5f,0x63,0x69,
    0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x37,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x38,0x38,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,
    0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x39,0x20,0x3d,0x20,0x71,0x20,
    0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x30,0x2e,0x30,0x2c,0x20,0x2d,0x31,0x38,0x2e,
    0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x39,0x30,0x20,0x3d,0x20,0x66,0x6d,0x61,0x28,0x5f,0x34,0x31,
    0x35,0x2c,0x20,0x30,0x2e,0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,
    0x30,0x39,0x32,0x38,0x39,0x35,0x35,0x30,0x37,0x38,0x31,0x32,0x35,0x2c,0x20,0x33,
    0x2e,0x31,0x34,0x31,0x35,0x39,0x32,0x37,0x34,0x31,0x30,0x31,0x32,0x35,0x37,0x33,
    0x32,0x34,0x32,0x31,0x38,0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x31,0x20,0x3d,0x20,0x30,
    0x2e,0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,0x38,
    0x39,0x35,0x35,0x30,0x37,0x38,0x31,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x32,0x20,0x3d,0x20,
    0x34,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x39,0x33,0x20,0x3d,0x20,0x30,0x2e,0x34,0x30,0x30,0x30,
    0x30,0x30,0x30,0x30,0x35,0x39,0x36,0x30,0x34,0x36,0x34,0x34,0x37,0x37,0x35,0x33,
    0x39,0x30,0x36,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x5f,0x38,0x30,0x39,0x20,0x3d,0x20,0x73,0x64,0x5f,0x61,0x72,0x63,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x38,0x39,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,
    0x30,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x31,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x39,0x32,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x33,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x38,0x31,0x30,
    0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x5f,0x38,0x31,0x32,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x5f,0x38,0x31,0x30,0x2c,
    0x20,0x5f,0x38,0x30,0x39,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,
    0x5f,0x38,0x31,0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x33,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x39,0x34,0x20,0x3d,0x20,0x76,0x65,0x63,0x33,0x28,0x30,
    0x2e,0x36,0x37,0x30,0x30,0x30,0x30,0x30,0x31,0x36,0x36,0x38,0x39,0x33,0x30,0x30,
    0x35,0x33,0x37,0x31,0x30,0x39,0x33,0x37,0x35,0x2c,0x20,0x30,0x2e,0x33,0x36,0x30,
    0x30,0x30,0x30,0x30,0x31,0x34,0x33,0x30,0x35,0x31,0x31,0x34,0x37,0x34,0x36,0x30,
    0x39,0x33,0x37,0x35,0x2c,0x20,0x30,0x2e,0x33,0x31,0x39,0x39,0x39,0x39,0x39,0x39,
    0x32,0x38,0x34,0x37,0x34,0x34,0x32,0x36,0x32,0x36,0x39,0x35,0x33,0x31,0x32,0x35,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x39,0x35,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x36,0x20,
    0x3d,0x20,0x5f,0x38,0x31,0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,
    0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,
    0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x35,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x39,0x36,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,
    0x20,0x5f,0x39,0x35,0x32,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x5f,0x39,0x35,0x32,0x2e,0x79,0x20,0x3d,0x20,0x28,0x70,0x2e,0x79,0x20,
    0x2d,0x20,0x28,0x2d,0x31,0x32,0x2e,0x30,0x29,0x29,0x20,0x2f,0x20,0x28,0x31,0x2e,
    0x30,0x20,0x2d,0x20,0x73,0x6d,0x6f,0x6f,0x74,0x68,0x73,0x74,0x65,0x70,0x28,0x30,
    0x2e,0x39,0x38,0x30,0x30,0x30,0x30,0x30,0x31,0x39,0x30,0x37,0x33,0x34,0x38,0x36,
    0x33,0x32,0x38,0x31,0x32,0x35,0x2c,0x20,0x31,0x2e,0x30,0x2c,0x20,0x73,0x69,0x6e,
    0x28,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,0x30,0x5d,0x2e,
    0x78,0x20,0x2a,0x20,0x33,0x2e,0x30,0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x71,0x20,0x3d,0x20,0x5f,0x39,0x35,0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,
    0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x37,0x20,0x3d,0x20,0x5f,0x39,
    0x35,0x32,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x32,0x30,0x2e,0x30,0x2c,0x20,
    0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x39,0x38,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x39,
    0x2e,0x30,0x2c,0x20,0x31,0x32,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x39,0x20,0x3d,0x20,
    0x32,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,
    0x38,0x34,0x37,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,
    0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x37,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x39,0x38,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x39,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x38,0x34,0x37,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x30,0x30,0x20,0x3d,0x20,0x76,0x65,0x63,0x33,0x28,0x31,0x2e,0x30,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x30,0x31,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x32,0x20,0x3d,
    0x20,0x5f,0x38,0x34,0x37,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,
    0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,
    0x30,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x31,0x2c,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x31,0x30,0x32,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,
    0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x33,0x20,0x3d,0x20,0x71,
    0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x31,0x39,0x2e,0x35,0x2c,0x20,0x30,0x2e,
    0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x30,0x34,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x35,0x2e,
    0x30,0x2c,0x20,0x38,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x35,0x20,0x3d,0x20,0x32,
    0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x38,
    0x36,0x34,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,
    0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x33,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x30,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,
    0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x38,0x36,0x34,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x31,0x30,0x36,0x20,0x3d,0x20,0x76,0x65,0x63,0x33,0x28,0x30,0x2e,0x36,0x37,
    0x30,0x30,0x30,0x30,0x30,0x31,0x36,0x36,0x38,0x39,0x33,0x30,0x30,0x35,0x33,0x37,
    0x31,0x30,0x39,0x33,0x37,0x35,0x2c,0x20,0x30,0x2e,0x33,0x36,0x30,0x30,0x30,0x30,
    0x30,0x31,0x34,0x33,0x30,0x35,0x31,0x31,0x34,0x37,0x34,0x36,0x30,0x39,0x33,0x37,
    0x35,0x2c,0x20,0x30,0x2e,0x33,0x31,0x39,0x39,0x39,0x39,0x39,0x39,0x32,0x38,0x34,
    0x37,0x34,0x34,0x32,0x36,0x32,0x36,0x39,0x35,0x33,0x31,0x32,0x35,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x30,0x37,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x38,0x20,0x3d,
    0x20,0x5f,0x38,0x36,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,
    0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,
    0x36,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x37,0x2c,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x31,0x30,0x38,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,
    0x63,0x32,0x20,0x5f,0x38,0x37,0x33,0x20,0x3d,0x20,0x70,0x20,0x2d,0x20,0x76,0x65,
    0x63,0x32,0x28,0x2d,0x32,0x2e,0x30,0x2c,0x20,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x5f,0x38,0x37,0x33,0x2e,0x78,0x20,0x3d,0x20,0x61,0x62,0x73,0x28,
    0x5f,0x38,0x37,0x33,0x2e,0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,
    0x20,0x5f,0x38,0x37,0x33,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x39,0x20,0x3d,0x20,0x5f,0x38,0x37,0x33,
    0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x31,0x39,0x2e,0x35,0x2c,0x20,0x2d,0x38,
    0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x30,0x20,0x3d,0x20,0x31,0x2e,0x32,0x39,0x39,
    0x39,0x39,0x39,0x39,0x35,0x32,0x33,0x31,0x36,0x32,0x38,0x34,0x31,0x37,0x39,0x36,
    0x38,0x37,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,
    0x38,0x38,0x34,0x20,0x3d,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x39,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x31,0x31,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,
    0x38,0x38,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x31,0x31,0x31,0x20,0x3d,0x20,0x76,0x65,0x63,0x33,0x28,0x31,
    0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x31,0x31,0x32,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x31,0x31,0x33,0x20,0x3d,0x20,0x5f,0x38,0x38,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x76,0x65,0x63,0x33,0x20,0x5f,0x38,0x39,0x30,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,
    0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x31,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x31,0x32,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,
    0x33,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x5f,
    0x38,0x39,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,
    0x5f,0x38,0x39,0x30,0x3b,0x0a,0x7d,0x0a,0x0a,0x76,0x6f,0x69,0x64,0x20,0x6d,0x61,
    0x69,0x6e,0x28,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x20,0x3d,0x20,0x66,0x72,0x61,0x67,0x50,0x6f,0x73,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x33,0x20,0x5f,0x38,0x39,0x39,0x20,0x3d,
    0x20,0x6d,0x61,0x70,0x28,0x70,0x61,0x72,0x61,0x6d,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x76,0x65,0x63,
    0x34,0x28,0x5f,0x38,0x39,0x39,0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x7d,0x0a,
    0x0a,0x00,
};
/*
    #version 300 es

    uniform vec4 vs_uniforms[1];
    layout(location = 0) in vec4 coord;
    out vec2 fragPos;
    out vec2 texUV;

    void main()
    {
        gl_Position = vec4(coord.xy, 0.0, 1.0);
        fragPos = vec2(coord.x * (vs_uniforms[0].x / vs_uniforms[0].y), coord.y);
        texUV = coord.zw;
    }

*/
static const uint8_t sdf_vs_source_glsl300es[279] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x33,0x30,0x30,0x20,0x65,0x73,0x0a,
    0x0a,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x20,0x76,0x65,0x63,0x34,0x20,0x76,0x73,
    0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,0x31,0x5d,0x3b,0x0a,0x6c,0x61,
    0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,
    0x30,0x29,0x20,0x69,0x6e,0x20,0x76,0x65,0x63,0x34,0x20,0x63,0x6f,0x6f,0x72,0x64,
    0x3b,0x0a,0x6f,0x75,0x74,0x20,0x76,0x65,0x63,0x32,0x20,0x66,0x72,0x61,0x67,0x50,
    0x6f,0x73,0x3b,0x0a,0x6f,0x75,0x74,0x20,0x76,0x65,0x63,0x32,0x20,0x74,0x65,0x78,
    0x55,0x56,0x3b,0x0a,0x0a,0x76,0x6f,0x69,0x64,0x20,0x6d,0x61,0x69,0x6e,0x28,0x29,
    0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,
    0x6f,0x6e,0x20,0x3d,0x20,0x76,0x65,0x63,0x34,0x28,0x63,0x6f,0x6f,0x72,0x64,0x2e,
    0x78,0x79,0x2c,0x20,0x30,0x2e,0x30,0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x72,0x61,0x67,0x50,0x6f,0x73,0x20,0x3d,0x20,0x76,0x65,0x63,
    0x32,0x28,0x63,0x6f,0x6f,0x72,0x64,0x2e,0x78,0x20,0x2a,0x20,0x28,0x76,0x73,0x5f,
    0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,0x30,0x5d,0x2e,0x78,0x20,0x2f,0x20,
    0x76,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,0x30,0x5d,0x2e,0x79,
    0x29,0x2c,0x20,0x63,0x6f,0x6f,0x72,0x64,0x2e,0x79,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x74,0x65,0x78,0x55,0x56,0x20,0x3d,0x20,0x63,0x6f,0x6f,0x72,0x64,0x2e,0x7a,
    0x77,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #version 300 es
    precision mediump float;
    precision highp int;

    uniform highp vec4 fs_uniforms[1];
    in highp vec2 fragPos;
    layout(location = 0) out highp vec4 fragColor;
    in highp vec2 texUV;

    highp vec3 background(highp vec2 uv)
    {
        highp vec2 _315 = abs(floor(uv));
        return vec3(0.38999998569488525390625) + (vec3(0.17000000178813934326171875) * mod(_315.x + _315.y, 2.0));
    }

    highp float length_n(inout highp vec2 p, highp float n)
    {
        p = pow(abs(p), vec2(n));
        return pow(p.x + p.y, 1.0 / n);
    }

    highp float sd_ellipsoid(highp vec2 p, highp vec2 r, highp float roundness)
    {
        highp vec2 param = p / r;
        highp float param_1 = roundness;
        highp float _103 = length_n(param, param_1);
        highp vec2 param_2 = p / (r * r);
        highp float param_3 = roundness;
        highp float _113 = length_n(param_2, param_3);
        return (_103 * (_103 - 1.0)) / _113;
    }

    highp vec3 blend(highp vec3 col, highp vec3 ocol, highp float d)
    {
        return mix(ocol, col, vec3(smoothstep(0.5, 0.0, d)));
    }

    highp float sd_line(highp vec2 p, highp vec2 a, highp vec2 b)
    {
        highp vec2 _240 = p - a;
        highp vec2 _244 = b - a;
        return length(_240 - (_244 * clamp(dot(_240, _244) / dot(_244, _244), 0.0, 1.0)));
    }

    highp vec2 rotate(highp vec2 p, highp float theta)
    {
        highp float _264 = cos(theta);
        highp float _267 = sin(theta);
        return vec2(p.x * _264 + (-(p.y * _267)), p.x * _267 + (p.y * _264));
    }

    highp float sd_vesica(inout highp vec2 p, highp float r, highp float d)
    {
        p = abs(p);
        highp float _132 = sqrt(r * r + (-(d * d)));
        highp float _145;
        if (((p.y - _132) * d) > (p.x * _132))
        {
            _145 = length(p - vec2(0.0, _132));
        }
        else
        {
            _145 = length(p - vec2(-d, 0.0)) - r;
        }
        return _145;
    }

    highp float smin(highp float a, highp float b, highp float k)
    {
        highp float _298 = max(k - abs(a - b), 0.0) / k;
        return (-((_298 * _298) * k)) * 0.25 + min(a, b);
    }

    highp float sd_circle(highp vec2 p, highp float r)
    {
        return length(p) - r;
    }

    highp float sd_arc(inout highp vec2 p, highp float ta, highp float tb, highp float ra, highp float rb)
    {
        highp float _168 = cos(ta);
        highp float _170 = sin(ta);
        highp float _174 = cos(tb);
        highp float _176 = sin(tb);
        p *= mat2(vec2(_168, _170), vec2(-_170, _168));
        p.x = abs(p.x);
        highp float _209;
        if ((_176 * p.x) > (_174 * p.y))
        {
            _209 = dot(p, vec2(_174, _176));
        }
        else
        {
            _209 = length(p);
        }
        return sqrt((ra * (-2.0)) * _209 + (ra * ra + dot(p, p))) - rb;
    }

    highp vec3 map(inout highp vec2 p)
    {
        p *= 100.0;
        p.y -= 30.0;
        highp vec2 _356 = vec2(abs(p.x), p.y);
        highp vec2 param = p * 0.300000011920928955078125;
        highp vec3 ocol = background(param);
        highp vec2 param_1 = p - vec2(0.0, -97.0);
        highp vec2 param_2 = vec2(55.0, 20.0);
        highp float param_3 = 2.0;
        highp float _374 = sd_ellipsoid(param_1, param_2, param_3);
        highp float d = _374;
        highp vec3 param_4 = vec3(0.61000001430511474609375, 0.85000002384185791015625, 0.939999997615814208984375);
        highp vec3 param_5 = ocol;
        highp float param_6 = _374;
        ocol = blend(param_4, param_5, param_6);
        highp vec2 q = _356;
        highp vec2 param_7 = _356;
        highp vec2 param_8 = vec2(55.0, 45.0);
        highp float param_9 = 2.400000095367431640625;
        d = sd_ellipsoid(param_7, param_8, param_9);
        highp vec2 _398 = q - vec2(45.0, -15.0);
        highp float _400 = _398.x;
        highp float _415 = sin(fs_uniforms[0].x);
        _398.y = ((_400 * _400) * 0.0030000000260770320892333984375) * _415 + _398.y;
        q = _398;
        highp vec2 param_10 = _398;
        highp vec2 param_11 = vec2(0.0);
        highp vec2 param_12 = vec2(45.0, 0.0);
        d = min(d, sd_line(param_10, param_11, param_12) - 0.20000000298023223876953125);
        highp vec2 _922 = q;
        _922.y = ((_922.x * _922.x) * 0.0030000000260770320892333984375) * sin(fs_uniforms[0].x * 2.0) + (_922.y + 6.0);
        q = _922;
        highp vec2 param_13 = _922;
        highp vec2 param_14 = vec2(0.0);
        highp vec2 param_15 = vec2(45.0, 0.0);
        d = min(d, sd_line(param_13, param_14, param_15) - 0.20000000298023223876953125);
        highp vec2 _466 = _356 - vec2(32.0, 30.0);
        q = _466;
        highp vec2 param_16 = _466;
        highp float param_17 = _415 * 0.300000011920928955078125 + 0.699999988079071044921875;
        highp vec2 _476 = rotate(param_16, param_17);
        q = _476;
        highp vec2 param_18 = _476;
        highp float param_19 = 30.0;
        highp float param_20 = 15.0;
        highp float _482 = sd_vesica(param_18, param_19, param_20);
        highp float _483 = d;
        highp float _485 = min(_483, _482);
        d = _485;
        highp vec3 param_21 = vec3(0.119999997317790985107421875);
        highp vec3 param_22 = ocol;
        highp float param_23 = _485;
        ocol = blend(param_21, param_22, param_23);
        q = _356;
        highp vec2 param_24 = _356 - vec2(0.0, -60.0);
        highp vec2 param_25 = vec2(27.0, 20.0);
        highp float param_26 = 2.0;
        d = sd_ellipsoid(param_24, param_25, param_26);
        highp vec2 param_27 = q - vec2(0.0, -70.0);
        highp vec2 param_28 = vec2(20.0, 16.0);
        highp float param_29 = 2.0;
        d = max(-sd_ellipsoid(param_27, param_28, param_29), d);
        highp vec2 _522 = _356 - vec2(6.0, -50.0);
        q = _522;
        highp vec2 param_30 = _522;
        highp float param_31 = (0.5 * _415 + 0.5) * (-0.100000001490116119384765625);
        highp vec2 _534 = rotate(param_30, param_31);
        _534.x = (-pow(max((-45.0) - _534.y, 0.0), 1.89999997615814208984375)) * 0.100000001490116119384765625 + _534.x;
        q = _534;
        highp vec2 param_32 = _534;
        highp vec2 param_33 = vec2(0.0, -50.0);
        highp vec2 param_34 = vec2(0.0);
        highp float param_35 = d;
        highp float param_36 = sd_line(param_32, param_33, param_34) - 5.0;
        highp float param_37 = 1.0;
        d = smin(param_35, param_36, param_37);
        highp vec2 _564 = _356 - vec2(22.0, -60.0);
        q = _564;
        highp vec2 param_38 = _564;
        highp float param_39 = (0.5 * cos(fs_uniforms[0].x) + 0.5) * (-0.100000001490116119384765625);
        highp vec2 _575 = rotate(param_38, param_39);
        _575.x = (-pow(max((-29.0) - _575.y, 0.0), 1.89999997615814208984375)) * 0.100000001490116119384765625 + _575.x;
        q = _575;
        highp vec2 param_40 = _575;
        highp vec2 param_41 = vec2(0.0, -35.0);
        highp vec2 param_42 = vec2(0.0);
        highp float param_43 = d;
        highp float param_44 = sd_line(param_40, param_41, param_42) - 5.0;
        highp float param_45 = 1.0;
        d = smin(param_43, param_44, param_45);
        highp vec2 _604 = p - vec2(-26.0, -60.0);
        q = _604;
        highp vec2 param_46 = _604;
        highp float param_47 = 2.19911479949951171875;
        highp vec2 _609 = rotate(param_46, param_47);
        highp float _611 = _609.y;
        _609.x = _609.x - (sin(_611 * 0.123000003397464752197265625 + 3.0) * 4.0 + sin(_611 * 0.100000001490116119384765625 + (fs_uniforms[0].x * 10.0)));
        q = _609;
        highp vec2 param_48 = _609;
        highp vec2 param_49 = vec2(0.0, -40.0);
        highp vec2 param_50 = vec2(0.0);
        highp float param_51 = d;
        highp float param_52 = (-5.0) * smoothstep(-60.0, 0.0, q.y) + sd_line(param_48, param_49, param_50);
        highp float param_53 = 1.0;
        highp float _650 = smin(param_51, param_52, param_53);
        d = _650;
        highp vec3 param_54 = vec3(0.119999997317790985107421875);
        highp vec3 param_55 = ocol;
        highp float param_56 = _650;
        ocol = blend(param_54, param_55, param_56);
        highp vec2 param_57 = q - vec2(-2.0, -4.0);
        highp float param_58 = 1.2999999523162841796875;
        highp float _665 = sd_circle(param_57, param_58);
        d = _665;
        highp vec2 param_59 = q - vec2(-2.0, -9.0);
        highp float param_60 = 1.2000000476837158203125;
        highp float _675 = min(_665, sd_circle(param_59, param_60));
        d = _675;
        highp vec2 param_61 = q - vec2(-2.0, -15.0);
        highp float param_62 = 1.10000002384185791015625;
        highp float _684 = min(_675, sd_circle(param_61, param_62));
        d = _684;
        highp vec2 param_63 = q - vec2(-2.0, -20.0);
        highp float param_64 = 1.0;
        highp float _693 = min(_684, sd_circle(param_63, param_64));
        d = _693;
        highp vec2 param_65 = q - vec2(-1.60000002384185791015625, -25.0);
        highp float param_66 = 0.89999997615814208984375;
        highp float _704 = min(_693, sd_circle(param_65, param_66));
        d = _704;
        highp vec2 param_67 = q - vec2(-1.2999999523162841796875, -29.0);
        highp float param_68 = 0.800000011920928955078125;
        highp float _714 = min(_704, sd_circle(param_67, param_68));
        d = _714;
        highp vec2 param_69 = q - vec2(-0.89999997615814208984375, -33.0);
        highp float param_70 = 0.699999988079071044921875;
        highp float _724 = min(_714, sd_circle(param_69, param_70));
        d = _724;
        highp vec2 param_71 = q - vec2(-0.800000011920928955078125, -37.0);
        highp float param_72 = 0.60000002384185791015625;
        highp float _735 = min(_724, sd_circle(param_71, param_72));
        d = _735;
        highp vec3 param_73 = vec3(0.61000001430511474609375, 0.85000002384185791015625, 0.939999997615814208984375);
        highp vec3 param_74 = ocol;
        highp float param_75 = _735;
        ocol = blend(param_73, param_74, param_75);
        highp vec2 _946 = _356;
        _946.y = p.y - (-11.0);
        q = _946;
        highp vec2 param_76 = _946 - vec2(0.0, -5.0);
        highp vec2 param_77 = vec2(40.0, 20.0);
        highp float param_78 = 2.900000095367431640625;
        d = sd_ellipsoid(param_76, param_77, param_78);
        highp vec2 param_79 = q - vec2(21.0, 0.0);
        highp float param_80 = 20.0;
        highp float param_81 = d;
        highp float param_82 = sd_circle(param_79, param_80);
        highp float param_83 = 5.0;
        highp float _770 = smin(param_81, param_82, param_83);
        d = _770;
        highp vec3 param_84 = vec3(0.980000019073486328125, 0.790000021457672119140625, 0.689999997615814208984375);
        highp vec3 param_85 = ocol;
        highp float param_86 = _770;
        ocol = blend(param_84, param_85, param_86);
        highp vec2 param_87 = q - vec2(0.0, _415 * 0.5 + (-12.0));
        highp float param_88 = 2.0;
        d = sd_circle(param_87, param_88);
        highp vec2 param_89 = q - vec2(0.0, -18.0);
        highp float param_90 = _415 * 0.300000011920928955078125 + 3.1415927410125732421875;
        highp float param_91 = 0.300000011920928955078125;
        highp float param_92 = 4.0;
        highp float param_93 = 0.4000000059604644775390625;
        highp float _809 = sd_arc(param_89, param_90, param_91, param_92, param_93);
        highp float _810 = d;
        highp float _812 = min(_810, _809);
        d = _812;
        highp vec3 param_94 = vec3(0.670000016689300537109375, 0.36000001430511474609375, 0.319999992847442626953125);
        highp vec3 param_95 = ocol;
        highp float param_96 = _812;
        ocol = blend(param_94, param_95, param_96);
        highp vec2 _952 = _356;
        _952.y = (p.y - (-12.0)) / (1.0 - smoothstep(0.980000019073486328125, 1.0, sin(fs_uniforms[0].x * 3.0)));
        q = _952;
        highp vec2 param_97 = _952 - vec2(20.0, 0.0);
        highp vec2 param_98 = vec2(9.0, 12.0);
        highp float param_99 = 2.0;
        highp float _847 = sd_ellipsoid(param_97, param_98, param_99);
        d = _847;
        highp vec3 param_100 = vec3(1.0);
        highp vec3 param_101 = ocol;
        highp float param_102 = _847;
        ocol = blend(param_100, param_101, param_102);
        highp vec2 param_103 = q - vec2(19.5, 0.0);
        highp vec2 param_104 = vec2(5.0, 8.0);
        highp float param_105 = 2.0;
        highp float _864 = sd_ellipsoid(param_103, param_104, param_105);
        d = _864;
        highp vec3 param_106 = vec3(0.670000016689300537109375, 0.36000001430511474609375, 0.319999992847442626953125);
        highp vec3 param_107 = ocol;
        highp float param_108 = _864;
        ocol = blend(param_106, param_107, param_108);
        highp vec2 _873 = p - vec2(-2.0, 0.0);
        _873.x = abs(_873.x);
        q = _873;
        highp vec2 param_109 = _873 - vec2(19.5, -8.0);
        highp float param_110 = 1.2999999523162841796875;
        highp float _884 = sd_circle(param_109, param_110);
        d = _884;
        highp vec3 param_111 = vec3(1.0);
        highp vec3 param_112 = ocol;
        highp float param_113 = _884;
        highp vec3 _890 = blend(param_111, param_112, param_113);
        ocol = _890;
        return _890;
    }

    void main()
    {
        highp vec2 param = fragPos;
        highp vec3 _899 = map(param);
        fragColor = vec4(_899, 1.0);
    }

*/
static const uint8_t sdf_fs_source_glsl300es[12276] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x33,0x30,0x30,0x20,0x65,0x73,0x0a,
    0x70,0x72,0x65,0x63,0x69,0x73,0x69,0x6f,0x6e,0x20,0x6d,0x65,0x64,0x69,0x75,0x6d,
    0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x3b,0x0a,0x70,0x72,0x65,0x63,0x69,0x73,0x69,
    0x6f,0x6e,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x69,0x6e,0x74,0x3b,0x0a,0x0a,0x75,
    0x6e,0x69,0x66,0x6f,0x72,0x6d,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,
    0x34,0x20,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,0x31,0x5d,
    0x3b,0x0a,0x69,0x6e,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,
    0x66,0x72,0x61,0x67,0x50,0x6f,0x73,0x3b,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,
    0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x30,0x29,0x20,0x6f,0x75,
    0x74,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x34,0x20,0x66,0x72,0x61,
    0x67,0x43,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x69,0x6e,0x20,0x68,0x69,0x67,0x68,0x70,
    0x20,0x76,0x65,0x63,0x32,0x20,0x74,0x65,0x78,0x55,0x56,0x3b,0x0a,0x0a,0x68,0x69,
    0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x33,0x20,0x62,0x61,0x63,0x6b,0x67,0x72,0x6f,
    0x75,0x6e,0x64,0x28,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x75,
    0x76,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,
    0x65,0x63,0x32,0x20,0x5f,0x33,0x31,0x35,0x20,0x3d,0x20,0x61,0x62,0x73,0x28,0x66,
    0x6c,0x6f,0x6f,0x72,0x28,0x75,0x76,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,
    0x65,0x74,0x75,0x72,0x6e,0x20,0x76,0x65,0x63,0x33,0x28,0x30,0x2e,0x33,0x38,0x39,
    0x39,0x39,0x39,0x39,0x38,0x35,0x36,0x39,0x34,0x38,0x38,0x35,0x32,0x35,0x33,0x39,
    0x30,0x36,0x32,0x35,0x29,0x20,0x2b,0x20,0x28,0x76,0x65,0x63,0x33,0x28,0x30,0x2e,
    0x31,0x37,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x37,0x38,0x38,0x31,0x33,0x39,0x33,
    0x34,0x33,0x32,0x36,0x31,0x37,0x31,0x38,0x37,0x35,0x29,0x20,0x2a,0x20,0x6d,0x6f,
    0x64,0x28,0x5f,0x33,0x31,0x35,0x2e,0x78,0x20,0x2b,0x20,0x5f,0x33,0x31,0x35,0x2e,
    0x79,0x2c,0x20,0x32,0x2e,0x30,0x29,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x68,0x69,0x67,
    0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x5f,
    0x6e,0x28,0x69,0x6e,0x6f,0x75,0x74,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,
    0x63,0x32,0x20,0x70,0x2c,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x6e,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x70,0x20,0x3d,0x20,0x70,
    0x6f,0x77,0x28,0x61,0x62,0x73,0x28,0x70,0x29,0x2c,0x20,0x76,0x65,0x63,0x32,0x28,
    0x6e,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,
    0x70,0x6f,0x77,0x28,0x70,0x2e,0x78,0x20,0x2b,0x20,0x70,0x2e,0x79,0x2c,0x20,0x31,
    0x2e,0x30,0x20,0x2f,0x20,0x6e,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x68,0x69,0x67,0x68,
    0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,
    0x73,0x6f,0x69,0x64,0x28,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,
    0x70,0x2c,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x72,0x2c,
    0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x72,0x6f,0x75,
    0x6e,0x64,0x6e,0x65,0x73,0x73,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x20,0x3d,
    0x20,0x70,0x20,0x2f,0x20,0x72,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x20,
    0x3d,0x20,0x72,0x6f,0x75,0x6e,0x64,0x6e,0x65,0x73,0x73,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,0x30,
    0x33,0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x5f,0x6e,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x32,0x20,0x3d,0x20,0x70,0x20,0x2f,0x20,0x28,0x72,0x20,0x2a,0x20,
    0x72,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x20,0x3d,0x20,0x72,0x6f,
    0x75,0x6e,0x64,0x6e,0x65,0x73,0x73,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,
    0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,0x31,0x33,0x20,0x3d,0x20,
    0x6c,0x65,0x6e,0x67,0x74,0x68,0x5f,0x6e,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,
    0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x28,0x5f,0x31,0x30,0x33,0x20,0x2a,0x20,0x28,
    0x5f,0x31,0x30,0x33,0x20,0x2d,0x20,0x31,0x2e,0x30,0x29,0x29,0x20,0x2f,0x20,0x5f,
    0x31,0x31,0x33,0x3b,0x0a,0x7d,0x0a,0x0a,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,
    0x63,0x33,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x68,0x69,0x67,0x68,0x70,0x20,0x76,
    0x65,0x63,0x33,0x20,0x63,0x6f,0x6c,0x2c,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,
    0x65,0x63,0x33,0x20,0x6f,0x63,0x6f,0x6c,0x2c,0x20,0x68,0x69,0x67,0x68,0x70,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x64,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x72,
    0x65,0x74,0x75,0x72,0x6e,0x20,0x6d,0x69,0x78,0x28,0x6f,0x63,0x6f,0x6c,0x2c,0x20,
    0x63,0x6f,0x6c,0x2c,0x20,0x76,0x65,0x63,0x33,0x28,0x73,0x6d,0x6f,0x6f,0x74,0x68,
    0x73,0x74,0x65,0x70,0x28,0x30,0x2e,0x35,0x2c,0x20,0x30,0x2e,0x30,0x2c,0x20,0x64,
    0x29,0x29,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,0x28,0x68,0x69,0x67,0x68,
    0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x2c,0x20,0x68,0x69,0x67,0x68,0x70,0x20,
    0x76,0x65,0x63,0x32,0x20,0x61,0x2c,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,
    0x63,0x32,0x20,0x62,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x5f,0x32,0x34,0x30,0x20,0x3d,0x20,0x70,0x20,
    0x2d,0x20,0x61,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,
    0x65,0x63,0x32,0x20,0x5f,0x32,0x34,0x34,0x20,0x3d,0x20,0x62,0x20,0x2d,0x20,0x61,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6c,0x65,0x6e,
    0x67,0x74,0x68,0x28,0x5f,0x32,0x34,0x30,0x20,0x2d,0x20,0x28,0x5f,0x32,0x34,0x34,
    0x20,0x2a,0x20,0x63,0x6c,0x61,0x6d,0x70,0x28,0x64,0x6f,0x74,0x28,0x5f,0x32,0x34,
    0x30,0x2c,0x20,0x5f,0x32,0x34,0x34,0x29,0x20,0x2f,0x20,0x64,0x6f,0x74,0x28,0x5f,
    0x32,0x34,0x34,0x2c,0x20,0x5f,0x32,0x34,0x34,0x29,0x2c,0x20,0x30,0x2e,0x30,0x2c,
    0x20,0x31,0x2e,0x30,0x29,0x29,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x68,0x69,0x67,0x68,
    0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x72,0x6f,0x74,0x61,0x74,0x65,0x28,0x68,0x69,
    0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x2c,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x74,0x68,0x65,0x74,0x61,0x29,0x0a,0x7b,
    0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x5f,0x32,0x36,0x34,0x20,0x3d,0x20,0x63,0x6f,0x73,0x28,0x74,0x68,0x65,0x74,
    0x61,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x5f,0x32,0x36,0x37,0x20,0x3d,0x20,0x73,0x69,0x6e,0x28,0x74,
    0x68,0x65,0x74,0x61,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,
    0x6e,0x20,0x76,0x65,0x63,0x32,0x28,0x70,0x2e,0x78,0x20,0x2a,0x20,0x5f,0x32,0x36,
    0x34,0x20,0x2b,0x20,0x28,0x2d,0x28,0x70,0x2e,0x79,0x20,0x2a,0x20,0x5f,0x32,0x36,
    0x37,0x29,0x29,0x2c,0x20,0x70,0x2e,0x78,0x20,0x2a,0x20,0x5f,0x32,0x36,0x37,0x20,
    0x2b,0x20,0x28,0x70,0x2e,0x79,0x20,0x2a,0x20,0x5f,0x32,0x36,0x34,0x29,0x29,0x3b,
    0x0a,0x7d,0x0a,0x0a,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x73,0x64,0x5f,0x76,0x65,0x73,0x69,0x63,0x61,0x28,0x69,0x6e,0x6f,0x75,0x74,0x20,
    0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x2c,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x72,0x2c,0x20,0x68,0x69,0x67,
    0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x64,0x29,0x0a,0x7b,0x0a,0x20,0x20,
    0x20,0x20,0x70,0x20,0x3d,0x20,0x61,0x62,0x73,0x28,0x70,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,
    0x33,0x32,0x20,0x3d,0x20,0x73,0x71,0x72,0x74,0x28,0x72,0x20,0x2a,0x20,0x72,0x20,
    0x2b,0x20,0x28,0x2d,0x28,0x64,0x20,0x2a,0x20,0x64,0x29,0x29,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,
    0x31,0x34,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x28,0x28,0x70,
    0x2e,0x79,0x20,0x2d,0x20,0x5f,0x31,0x33,0x32,0x29,0x20,0x2a,0x20,0x64,0x29,0x20,
    0x3e,0x20,0x28,0x70,0x2e,0x78,0x20,0x2a,0x20,0x5f,0x31,0x33,0x32,0x29,0x29,0x0a,
    0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x31,
    0x34,0x35,0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x28,0x70,0x20,0x2d,0x20,
    0x76,0x65,0x63,0x32,0x28,0x30,0x2e,0x30,0x2c,0x20,0x5f,0x31,0x33,0x32,0x29,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,
    0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,
    0x31,0x34,0x35,0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x28,0x70,0x20,0x2d,
    0x20,0x76,0x65,0x63,0x32,0x28,0x2d,0x64,0x2c,0x20,0x30,0x2e,0x30,0x29,0x29,0x20,
    0x2d,0x20,0x72,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x72,
    0x65,0x74,0x75,0x72,0x6e,0x20,0x5f,0x31,0x34,0x35,0x3b,0x0a,0x7d,0x0a,0x0a,0x68,
    0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x73,0x6d,0x69,0x6e,0x28,
    0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x61,0x2c,0x20,0x68,
    0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x62,0x2c,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x6b,0x29,0x0a,0x7b,0x0a,0x20,
    0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,
    0x32,0x39,0x38,0x20,0x3d,0x20,0x6d,0x61,0x78,0x28,0x6b,0x20,0x2d,0x20,0x61,0x62,
    0x73,0x28,0x61,0x20,0x2d,0x20,0x62,0x29,0x2c,0x20,0x30,0x2e,0x30,0x29,0x20,0x2f,
    0x20,0x6b,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x28,
    0x2d,0x28,0x28,0x5f,0x32,0x39,0x38,0x20,0x2a,0x20,0x5f,0x32,0x39,0x38,0x29,0x20,
    0x2a,0x20,0x6b,0x29,0x29,0x20,0x2a,0x20,0x30,0x2e,0x32,0x35,0x20,0x2b,0x20,0x6d,
    0x69,0x6e,0x28,0x61,0x2c,0x20,0x62,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x68,0x69,0x67,
    0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,
    0x6c,0x65,0x28,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x2c,
    0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x72,0x29,0x0a,
    0x7b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6c,0x65,0x6e,
    0x67,0x74,0x68,0x28,0x70,0x29,0x20,0x2d,0x20,0x72,0x3b,0x0a,0x7d,0x0a,0x0a,0x68,
    0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x73,0x64,0x5f,0x61,0x72,
    0x63,0x28,0x69,0x6e,0x6f,0x75,0x74,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,
    0x63,0x32,0x20,0x70,0x2c,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x74,0x61,0x2c,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x74,0x62,0x2c,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x72,0x61,0x2c,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x72,0x62,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,0x36,0x38,0x20,0x3d,0x20,0x63,
    0x6f,0x73,0x28,0x74,0x61,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,0x37,0x30,0x20,0x3d,0x20,0x73,
    0x69,0x6e,0x28,0x74,0x61,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,0x37,0x34,0x20,0x3d,0x20,0x63,
    0x6f,0x73,0x28,0x74,0x62,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,0x37,0x36,0x20,0x3d,0x20,0x73,
    0x69,0x6e,0x28,0x74,0x62,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x70,0x20,0x2a,0x3d,
    0x20,0x6d,0x61,0x74,0x32,0x28,0x76,0x65,0x63,0x32,0x28,0x5f,0x31,0x36,0x38,0x2c,
    0x20,0x5f,0x31,0x37,0x30,0x29,0x2c,0x20,0x76,0x65,0x63,0x32,0x28,0x2d,0x5f,0x31,
    0x37,0x30,0x2c,0x20,0x5f,0x31,0x36,0x38,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x70,0x2e,0x78,0x20,0x3d,0x20,0x61,0x62,0x73,0x28,0x70,0x2e,0x78,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x5f,0x32,0x30,0x39,0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x28,0x5f,
    0x31,0x37,0x36,0x20,0x2a,0x20,0x70,0x2e,0x78,0x29,0x20,0x3e,0x20,0x28,0x5f,0x31,
    0x37,0x34,0x20,0x2a,0x20,0x70,0x2e,0x79,0x29,0x29,0x0a,0x20,0x20,0x20,0x20,0x7b,
    0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x32,0x30,0x39,0x20,0x3d,0x20,
    0x64,0x6f,0x74,0x28,0x70,0x2c,0x20,0x76,0x65,0x63,0x32,0x28,0x5f,0x31,0x37,0x34,
    0x2c,0x20,0x5f,0x31,0x37,0x36,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,
    0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x32,0x30,0x39,0x20,0x3d,0x20,0x6c,0x65,
    0x6e,0x67,0x74,0x68,0x28,0x70,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,
    0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x73,0x71,0x72,0x74,0x28,0x28,
    0x72,0x61,0x20,0x2a,0x20,0x28,0x2d,0x32,0x2e,0x30,0x29,0x29,0x20,0x2a,0x20,0x5f,
    0x32,0x30,0x39,0x20,0x2b,0x20,0x28,0x72,0x61,0x20,0x2a,0x20,0x72,0x61,0x20,0x2b,
    0x20,0x64,0x6f,0x74,0x28,0x70,0x2c,0x20,0x70,0x29,0x29,0x29,0x20,0x2d,0x20,0x72,
    0x62,0x3b,0x0a,0x7d,0x0a,0x0a,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x33,
    0x20,0x6d,0x61,0x70,0x28,0x69,0x6e,0x6f,0x75,0x74,0x20,0x68,0x69,0x67,0x68,0x70,
    0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x70,
    0x20,0x2a,0x3d,0x20,0x31,0x30,0x30,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x70,
    0x2e,0x79,0x20,0x2d,0x3d,0x20,0x33,0x30,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x5f,0x33,0x35,0x36,0x20,
    0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x61,0x62,0x73,0x28,0x70,0x2e,0x78,0x29,0x2c,
    0x20,0x70,0x2e,0x79,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,
    0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x20,0x3d,0x20,0x70,0x20,
    0x2a,0x20,0x30,0x2e,0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,
    0x39,0x32,0x38,0x39,0x35,0x35,0x30,0x37,0x38,0x31,0x32,0x35,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x33,0x20,0x6f,0x63,0x6f,
    0x6c,0x20,0x3d,0x20,0x62,0x61,0x63,0x6b,0x67,0x72,0x6f,0x75,0x6e,0x64,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,
    0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x20,0x3d,0x20,
    0x70,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x30,0x2e,0x30,0x2c,0x20,0x2d,0x39,
    0x37,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,
    0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x20,0x3d,0x20,0x76,
    0x65,0x63,0x32,0x28,0x35,0x35,0x2e,0x30,0x2c,0x20,0x32,0x30,0x2e,0x30,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x20,0x3d,0x20,0x32,0x2e,0x30,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x5f,0x33,0x37,0x34,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,
    0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x32,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x64,0x20,0x3d,0x20,0x5f,0x33,0x37,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,
    0x20,0x3d,0x20,0x76,0x65,0x63,0x33,0x28,0x30,0x2e,0x36,0x31,0x30,0x30,0x30,0x30,
    0x30,0x31,0x34,0x33,0x30,0x35,0x31,0x31,0x34,0x37,0x34,0x36,0x30,0x39,0x33,0x37,
    0x35,0x2c,0x20,0x30,0x2e,0x38,0x35,0x30,0x30,0x30,0x30,0x30,0x32,0x33,0x38,0x34,
    0x31,0x38,0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,0x32,0x35,0x2c,0x20,0x30,0x2e,
    0x39,0x33,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,0x31,0x35,0x38,0x31,0x34,0x32,
    0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,
    0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x35,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x36,0x20,0x3d,0x20,0x5f,0x33,0x37,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,
    0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x36,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,
    0x20,0x76,0x65,0x63,0x32,0x20,0x71,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x37,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x38,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x35,0x35,0x2e,
    0x30,0x2c,0x20,0x34,0x35,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x39,0x20,0x3d,0x20,0x32,0x2e,0x34,0x30,0x30,0x30,0x30,0x30,0x30,0x39,0x35,0x33,
    0x36,0x37,0x34,0x33,0x31,0x36,0x34,0x30,0x36,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x64,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,
    0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x38,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x5f,0x33,0x39,
    0x38,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x34,0x35,0x2e,
    0x30,0x2c,0x20,0x2d,0x31,0x35,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,
    0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,0x30,0x30,0x20,
    0x3d,0x20,0x5f,0x33,0x39,0x38,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,0x31,0x35,0x20,0x3d,
    0x20,0x73,0x69,0x6e,0x28,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,
    0x5b,0x30,0x5d,0x2e,0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x33,0x39,0x38,
    0x2e,0x79,0x20,0x3d,0x20,0x28,0x28,0x5f,0x34,0x30,0x30,0x20,0x2a,0x20,0x5f,0x34,
    0x30,0x30,0x29,0x20,0x2a,0x20,0x30,0x2e,0x30,0x30,0x33,0x30,0x30,0x30,0x30,0x30,
    0x30,0x30,0x32,0x36,0x30,0x37,0x37,0x30,0x33,0x32,0x30,0x38,0x39,0x32,0x33,0x33,
    0x33,0x39,0x38,0x34,0x33,0x37,0x35,0x29,0x20,0x2a,0x20,0x5f,0x34,0x31,0x35,0x20,
    0x2b,0x20,0x5f,0x33,0x39,0x38,0x2e,0x79,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,
    0x3d,0x20,0x5f,0x33,0x39,0x38,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x20,
    0x3d,0x20,0x5f,0x33,0x39,0x38,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x20,
    0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x31,0x32,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x34,0x35,0x2e,0x30,
    0x2c,0x20,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,
    0x6d,0x69,0x6e,0x28,0x64,0x2c,0x20,0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x32,0x29,0x20,0x2d,0x20,0x30,
    0x2e,0x32,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x39,0x38,0x30,0x32,0x33,0x32,
    0x32,0x33,0x38,0x37,0x36,0x39,0x35,0x33,0x31,0x32,0x35,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x5f,0x39,0x32,
    0x32,0x20,0x3d,0x20,0x71,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x39,0x32,0x32,0x2e,
    0x79,0x20,0x3d,0x20,0x28,0x28,0x5f,0x39,0x32,0x32,0x2e,0x78,0x20,0x2a,0x20,0x5f,
    0x39,0x32,0x32,0x2e,0x78,0x29,0x20,0x2a,0x20,0x30,0x2e,0x30,0x30,0x33,0x30,0x30,
    0x30,0x30,0x30,0x30,0x30,0x32,0x36,0x30,0x37,0x37,0x30,0x33,0x32,0x30,0x38,0x39,
    0x32,0x33,0x33,0x33,0x39,0x38,0x34,0x33,0x37,0x35,0x29,0x20,0x2a,0x20,0x73,0x69,
    0x6e,0x28,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,0x30,0x5d,
    0x2e,0x78,0x20,0x2a,0x20,0x32,0x2e,0x30,0x29,0x20,0x2b,0x20,0x28,0x5f,0x39,0x32,
    0x32,0x2e,0x79,0x20,0x2b,0x20,0x36,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x71,0x20,0x3d,0x20,0x5f,0x39,0x32,0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x33,0x20,0x3d,0x20,0x5f,0x39,0x32,0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x34,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x31,0x35,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x34,0x35,
    0x2e,0x30,0x2c,0x20,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,
    0x3d,0x20,0x6d,0x69,0x6e,0x28,0x64,0x2c,0x20,0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,
    0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x33,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x31,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x35,0x29,0x20,0x2d,
    0x20,0x30,0x2e,0x32,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x39,0x38,0x30,0x32,
    0x33,0x32,0x32,0x33,0x38,0x37,0x36,0x39,0x35,0x33,0x31,0x32,0x35,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x5f,
    0x34,0x36,0x36,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x20,0x2d,0x20,0x76,0x65,0x63,
    0x32,0x28,0x33,0x32,0x2e,0x30,0x2c,0x20,0x33,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x34,0x36,0x36,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x31,0x36,0x20,0x3d,0x20,0x5f,0x34,0x36,0x36,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x37,0x20,0x3d,0x20,0x5f,0x34,0x31,0x35,0x20,0x2a,0x20,0x30,
    0x2e,0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,0x38,
    0x39,0x35,0x35,0x30,0x37,0x38,0x31,0x32,0x35,0x20,0x2b,0x20,0x30,0x2e,0x36,0x39,
    0x39,0x39,0x39,0x39,0x39,0x38,0x38,0x30,0x37,0x39,0x30,0x37,0x31,0x30,0x34,0x34,
    0x39,0x32,0x31,0x38,0x37,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x5f,0x34,0x37,0x36,0x20,0x3d,0x20,0x72,0x6f,
    0x74,0x61,0x74,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x36,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x37,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,
    0x3d,0x20,0x5f,0x34,0x37,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x38,0x20,
    0x3d,0x20,0x5f,0x34,0x37,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x39,
    0x20,0x3d,0x20,0x33,0x30,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,
    0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,
    0x30,0x20,0x3d,0x20,0x31,0x35,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,0x38,0x32,0x20,0x3d,
    0x20,0x73,0x64,0x5f,0x76,0x65,0x73,0x69,0x63,0x61,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x31,0x38,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x39,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x32,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,0x38,0x33,0x20,0x3d,
    0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x5f,0x34,0x38,0x35,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x5f,
    0x34,0x38,0x33,0x2c,0x20,0x5f,0x34,0x38,0x32,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x64,0x20,0x3d,0x20,0x5f,0x34,0x38,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,
    0x31,0x20,0x3d,0x20,0x76,0x65,0x63,0x33,0x28,0x30,0x2e,0x31,0x31,0x39,0x39,0x39,
    0x39,0x39,0x39,0x37,0x33,0x31,0x37,0x37,0x39,0x30,0x39,0x38,0x35,0x31,0x30,0x37,
    0x34,0x32,0x31,0x38,0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,
    0x68,0x70,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x32,
    0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,
    0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,
    0x33,0x20,0x3d,0x20,0x5f,0x34,0x38,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,
    0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x32,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x32,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x32,0x33,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,
    0x3d,0x20,0x5f,0x33,0x35,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x34,0x20,
    0x3d,0x20,0x5f,0x33,0x35,0x36,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x30,0x2e,
    0x30,0x2c,0x20,0x2d,0x36,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,
    0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x32,0x35,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x32,0x37,0x2e,0x30,0x2c,0x20,
    0x32,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x36,0x20,
    0x3d,0x20,0x32,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x73,
    0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x32,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x35,0x2c,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x36,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,
    0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x32,0x37,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x30,0x2e,
    0x30,0x2c,0x20,0x2d,0x37,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,
    0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x32,0x38,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x32,0x30,0x2e,0x30,0x2c,0x20,
    0x31,0x36,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x39,0x20,
    0x3d,0x20,0x32,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x6d,
    0x61,0x78,0x28,0x2d,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,0x64,
    0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x37,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x32,0x38,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x39,0x29,0x2c,0x20,
    0x64,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,
    0x63,0x32,0x20,0x5f,0x35,0x32,0x32,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x20,0x2d,
    0x20,0x76,0x65,0x63,0x32,0x28,0x36,0x2e,0x30,0x2c,0x20,0x2d,0x35,0x30,0x2e,0x30,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x35,0x32,0x32,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x30,0x20,0x3d,0x20,0x5f,0x35,0x32,0x32,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x31,0x20,0x3d,0x20,0x28,0x30,0x2e,0x35,
    0x20,0x2a,0x20,0x5f,0x34,0x31,0x35,0x20,0x2b,0x20,0x30,0x2e,0x35,0x29,0x20,0x2a,
    0x20,0x28,0x2d,0x30,0x2e,0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x39,
    0x30,0x31,0x31,0x36,0x31,0x31,0x39,0x33,0x38,0x34,0x37,0x36,0x35,0x36,0x32,0x35,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,
    0x32,0x20,0x5f,0x35,0x33,0x34,0x20,0x3d,0x20,0x72,0x6f,0x74,0x61,0x74,0x65,0x28,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x30,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x33,0x31,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x35,0x33,0x34,0x2e,0x78,0x20,
    0x3d,0x20,0x28,0x2d,0x70,0x6f,0x77,0x28,0x6d,0x61,0x78,0x28,0x28,0x2d,0x34,0x35,
    0x2e,0x30,0x29,0x20,0x2d,0x20,0x5f,0x35,0x33,0x34,0x2e,0x79,0x2c,0x20,0x30,0x2e,
    0x30,0x29,0x2c,0x20,0x31,0x2e,0x38,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,0x31,
    0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x29,0x29,0x20,
    0x2a,0x20,0x30,0x2e,0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x39,0x30,
    0x31,0x31,0x36,0x31,0x31,0x39,0x33,0x38,0x34,0x37,0x36,0x35,0x36,0x32,0x35,0x20,
    0x2b,0x20,0x5f,0x35,0x33,0x34,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,
    0x3d,0x20,0x5f,0x35,0x33,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x32,0x20,
    0x3d,0x20,0x5f,0x35,0x33,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x33,0x20,
    0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x30,0x2e,0x30,0x2c,0x20,0x2d,0x35,0x30,0x2e,
    0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,
    0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x34,0x20,0x3d,0x20,0x76,0x65,
    0x63,0x32,0x28,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,
    0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,
    0x35,0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x36,0x20,
    0x3d,0x20,0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x33,0x32,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x33,0x2c,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x33,0x34,0x29,0x20,0x2d,0x20,0x35,0x2e,0x30,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x33,0x37,0x20,0x3d,0x20,0x31,0x2e,0x30,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x6d,0x69,0x6e,0x28,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x33,0x35,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x36,0x2c,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x37,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,
    0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x5f,0x35,0x36,0x34,0x20,0x3d,
    0x20,0x5f,0x33,0x35,0x36,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x32,0x32,0x2e,
    0x30,0x2c,0x20,0x2d,0x36,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,
    0x20,0x3d,0x20,0x5f,0x35,0x36,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,
    0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x38,
    0x20,0x3d,0x20,0x5f,0x35,0x36,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,
    0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,
    0x39,0x20,0x3d,0x20,0x28,0x30,0x2e,0x35,0x20,0x2a,0x20,0x63,0x6f,0x73,0x28,0x66,
    0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,0x30,0x5d,0x2e,0x78,0x29,
    0x20,0x2b,0x20,0x30,0x2e,0x35,0x29,0x20,0x2a,0x20,0x28,0x2d,0x30,0x2e,0x31,0x30,
    0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x39,0x30,0x31,0x31,0x36,0x31,0x31,0x39,
    0x33,0x38,0x34,0x37,0x36,0x35,0x36,0x32,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x5f,0x35,0x37,0x35,0x20,
    0x3d,0x20,0x72,0x6f,0x74,0x61,0x74,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,
    0x38,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x39,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x5f,0x35,0x37,0x35,0x2e,0x78,0x20,0x3d,0x20,0x28,0x2d,0x70,0x6f,0x77,
    0x28,0x6d,0x61,0x78,0x28,0x28,0x2d,0x32,0x39,0x2e,0x30,0x29,0x20,0x2d,0x20,0x5f,
    0x35,0x37,0x35,0x2e,0x79,0x2c,0x20,0x30,0x2e,0x30,0x29,0x2c,0x20,0x31,0x2e,0x38,
    0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,
    0x39,0x38,0x34,0x33,0x37,0x35,0x29,0x29,0x20,0x2a,0x20,0x30,0x2e,0x31,0x30,0x30,
    0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x39,0x30,0x31,0x31,0x36,0x31,0x31,0x39,0x33,
    0x38,0x34,0x37,0x36,0x35,0x36,0x32,0x35,0x20,0x2b,0x20,0x5f,0x35,0x37,0x35,0x2e,
    0x78,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x35,0x37,0x35,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x30,0x20,0x3d,0x20,0x5f,0x35,0x37,0x35,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x31,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,
    0x30,0x2e,0x30,0x2c,0x20,0x2d,0x33,0x35,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x34,0x32,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x30,0x2e,0x30,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x33,0x20,0x3d,0x20,0x64,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x34,0x20,0x3d,0x20,0x73,0x64,0x5f,0x6c,0x69,
    0x6e,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x30,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x34,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x32,0x29,
    0x20,0x2d,0x20,0x35,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x35,
    0x20,0x3d,0x20,0x31,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,
    0x73,0x6d,0x69,0x6e,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x33,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x34,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,
    0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,
    0x63,0x32,0x20,0x5f,0x36,0x30,0x34,0x20,0x3d,0x20,0x70,0x20,0x2d,0x20,0x76,0x65,
    0x63,0x32,0x28,0x2d,0x32,0x36,0x2e,0x30,0x2c,0x20,0x2d,0x36,0x30,0x2e,0x30,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x36,0x30,0x34,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x34,0x36,0x20,0x3d,0x20,0x5f,0x36,0x30,0x34,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x37,0x20,0x3d,0x20,0x32,0x2e,0x31,0x39,0x39,
    0x31,0x31,0x34,0x37,0x39,0x39,0x34,0x39,0x39,0x35,0x31,0x31,0x37,0x31,0x38,0x37,
    0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,
    0x32,0x20,0x5f,0x36,0x30,0x39,0x20,0x3d,0x20,0x72,0x6f,0x74,0x61,0x74,0x65,0x28,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x36,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x34,0x37,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x31,0x31,0x20,0x3d,0x20,0x5f,0x36,0x30,0x39,
    0x2e,0x79,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x36,0x30,0x39,0x2e,0x78,0x20,0x3d,
    0x20,0x5f,0x36,0x30,0x39,0x2e,0x78,0x20,0x2d,0x20,0x28,0x73,0x69,0x6e,0x28,0x5f,
    0x36,0x31,0x31,0x20,0x2a,0x20,0x30,0x2e,0x31,0x32,0x33,0x30,0x30,0x30,0x30,0x30,
    0x33,0x33,0x39,0x37,0x34,0x36,0x34,0x37,0x35,0x32,0x31,0x39,0x37,0x32,0x36,0x35,
    0x36,0x32,0x35,0x20,0x2b,0x20,0x33,0x2e,0x30,0x29,0x20,0x2a,0x20,0x34,0x2e,0x30,
    0x20,0x2b,0x20,0x73,0x69,0x6e,0x28,0x5f,0x36,0x31,0x31,0x20,0x2a,0x20,0x30,0x2e,
    0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x39,0x30,0x31,0x31,0x36,0x31,
    0x31,0x39,0x33,0x38,0x34,0x37,0x36,0x35,0x36,0x32,0x35,0x20,0x2b,0x20,0x28,0x66,
    0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,0x30,0x5d,0x2e,0x78,0x20,
    0x2a,0x20,0x31,0x30,0x2e,0x30,0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,
    0x20,0x3d,0x20,0x5f,0x36,0x30,0x39,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,
    0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x38,
    0x20,0x3d,0x20,0x5f,0x36,0x30,0x39,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,
    0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x39,
    0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x30,0x2e,0x30,0x2c,0x20,0x2d,0x34,0x30,
    0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,
    0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x30,0x20,0x3d,0x20,0x76,
    0x65,0x63,0x32,0x28,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x35,0x31,0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x32,
    0x20,0x3d,0x20,0x28,0x2d,0x35,0x2e,0x30,0x29,0x20,0x2a,0x20,0x73,0x6d,0x6f,0x6f,
    0x74,0x68,0x73,0x74,0x65,0x70,0x28,0x2d,0x36,0x30,0x2e,0x30,0x2c,0x20,0x30,0x2e,
    0x30,0x2c,0x20,0x71,0x2e,0x79,0x29,0x20,0x2b,0x20,0x73,0x64,0x5f,0x6c,0x69,0x6e,
    0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x38,0x2c,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x34,0x39,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x30,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x33,0x20,0x3d,0x20,0x31,0x2e,0x30,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x5f,0x36,0x35,0x30,0x20,0x3d,0x20,0x73,0x6d,0x69,0x6e,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x35,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x32,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x33,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x64,0x20,0x3d,0x20,0x5f,0x36,0x35,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,
    0x34,0x20,0x3d,0x20,0x76,0x65,0x63,0x33,0x28,0x30,0x2e,0x31,0x31,0x39,0x39,0x39,
    0x39,0x39,0x39,0x37,0x33,0x31,0x37,0x37,0x39,0x30,0x39,0x38,0x35,0x31,0x30,0x37,
    0x34,0x32,0x31,0x38,0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,
    0x68,0x70,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x35,
    0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,
    0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,
    0x36,0x20,0x3d,0x20,0x5f,0x36,0x35,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,
    0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x35,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x35,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x35,0x36,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,
    0x37,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x2d,0x32,0x2e,
    0x30,0x2c,0x20,0x2d,0x34,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x35,0x38,0x20,0x3d,0x20,0x31,0x2e,0x32,0x39,0x39,0x39,0x39,0x39,0x39,0x35,0x32,
    0x33,0x31,0x36,0x32,0x38,0x34,0x31,0x37,0x39,0x36,0x38,0x37,0x35,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,
    0x36,0x36,0x35,0x20,0x3d,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x37,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x35,0x38,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x36,0x36,
    0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,
    0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x39,0x20,0x3d,0x20,0x71,0x20,0x2d,
    0x20,0x76,0x65,0x63,0x32,0x28,0x2d,0x32,0x2e,0x30,0x2c,0x20,0x2d,0x39,0x2e,0x30,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x30,0x20,0x3d,0x20,0x31,0x2e,
    0x32,0x30,0x30,0x30,0x30,0x30,0x30,0x34,0x37,0x36,0x38,0x33,0x37,0x31,0x35,0x38,
    0x32,0x30,0x33,0x31,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x37,0x35,0x20,0x3d,0x20,0x6d,
    0x69,0x6e,0x28,0x5f,0x36,0x36,0x35,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,
    0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x39,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x36,0x30,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,
    0x20,0x5f,0x36,0x37,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,
    0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x31,0x20,0x3d,
    0x20,0x71,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x2d,0x32,0x2e,0x30,0x2c,0x20,
    0x2d,0x31,0x35,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x32,
    0x20,0x3d,0x20,0x31,0x2e,0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x33,0x38,0x34,
    0x31,0x38,0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,0x32,0x35,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,
    0x38,0x34,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x5f,0x36,0x37,0x35,0x2c,0x20,0x73,
    0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,
    0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x32,0x29,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x36,0x38,0x34,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x36,0x33,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,
    0x2d,0x32,0x2e,0x30,0x2c,0x20,0x2d,0x32,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x36,0x34,0x20,0x3d,0x20,0x31,0x2e,0x30,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,
    0x39,0x33,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x5f,0x36,0x38,0x34,0x2c,0x20,0x73,
    0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,
    0x33,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x34,0x29,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x36,0x39,0x33,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x36,0x35,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,
    0x2d,0x31,0x2e,0x36,0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x33,0x38,0x34,0x31,0x38,
    0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,0x32,0x35,0x2c,0x20,0x2d,0x32,0x35,0x2e,
    0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x36,0x20,0x3d,0x20,0x30,
    0x2e,0x38,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,0x31,0x35,0x38,0x31,0x34,0x32,
    0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x37,0x30,0x34,0x20,0x3d,
    0x20,0x6d,0x69,0x6e,0x28,0x5f,0x36,0x39,0x33,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,
    0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x35,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x36,0x36,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,
    0x20,0x3d,0x20,0x5f,0x37,0x30,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,
    0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x37,
    0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x2d,0x31,0x2e,0x32,
    0x39,0x39,0x39,0x39,0x39,0x39,0x35,0x32,0x33,0x31,0x36,0x32,0x38,0x34,0x31,0x37,
    0x39,0x36,0x38,0x37,0x35,0x2c,0x20,0x2d,0x32,0x39,0x2e,0x30,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x36,0x38,0x20,0x3d,0x20,0x30,0x2e,0x38,0x30,0x30,0x30,
    0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,0x38,0x39,0x35,0x35,0x30,0x37,
    0x38,0x31,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x37,0x31,0x34,0x20,0x3d,0x20,0x6d,0x69,0x6e,
    0x28,0x5f,0x37,0x30,0x34,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,
    0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x37,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x36,0x38,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,
    0x37,0x31,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,
    0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x39,0x20,0x3d,0x20,0x71,
    0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x2d,0x30,0x2e,0x38,0x39,0x39,0x39,0x39,
    0x39,0x39,0x37,0x36,0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,
    0x37,0x35,0x2c,0x20,0x2d,0x33,0x33,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x37,0x30,0x20,0x3d,0x20,0x30,0x2e,0x36,0x39,0x39,0x39,0x39,0x39,0x39,
    0x38,0x38,0x30,0x37,0x39,0x30,0x37,0x31,0x30,0x34,0x34,0x39,0x32,0x31,0x38,0x37,
    0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x5f,0x37,0x32,0x34,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x5f,0x37,
    0x31,0x34,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x36,0x39,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x30,
    0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x37,0x32,0x34,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x31,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,
    0x76,0x65,0x63,0x32,0x28,0x2d,0x30,0x2e,0x38,0x30,0x30,0x30,0x30,0x30,0x30,0x31,
    0x31,0x39,0x32,0x30,0x39,0x32,0x38,0x39,0x35,0x35,0x30,0x37,0x38,0x31,0x32,0x35,
    0x2c,0x20,0x2d,0x33,0x37,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x37,0x32,0x20,0x3d,0x20,0x30,0x2e,0x36,0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x33,
    0x38,0x34,0x31,0x38,0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,0x32,0x35,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x5f,0x37,0x33,0x35,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x5f,0x37,0x32,0x34,0x2c,
    0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x37,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x32,0x29,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x37,0x33,0x35,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x37,0x33,0x20,0x3d,0x20,0x76,0x65,0x63,0x33,0x28,0x30,0x2e,
    0x36,0x31,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x33,0x30,0x35,0x31,0x31,0x34,0x37,
    0x34,0x36,0x30,0x39,0x33,0x37,0x35,0x2c,0x20,0x30,0x2e,0x38,0x35,0x30,0x30,0x30,
    0x30,0x30,0x32,0x33,0x38,0x34,0x31,0x38,0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,
    0x32,0x35,0x2c,0x20,0x30,0x2e,0x39,0x33,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,
    0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x33,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x34,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x35,0x20,0x3d,0x20,0x5f,0x37,0x33,0x35,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,
    0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x33,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x37,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x35,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,
    0x20,0x5f,0x39,0x34,0x36,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x5f,0x39,0x34,0x36,0x2e,0x79,0x20,0x3d,0x20,0x70,0x2e,0x79,0x20,0x2d,
    0x20,0x28,0x2d,0x31,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,
    0x3d,0x20,0x5f,0x39,0x34,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x36,0x20,
    0x3d,0x20,0x5f,0x39,0x34,0x36,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x30,0x2e,
    0x30,0x2c,0x20,0x2d,0x35,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,
    0x37,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x34,0x30,0x2e,0x30,0x2c,0x20,0x32,
    0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x38,0x20,0x3d,
    0x20,0x32,0x2e,0x39,0x30,0x30,0x30,0x30,0x30,0x30,0x39,0x35,0x33,0x36,0x37,0x34,
    0x33,0x31,0x36,0x34,0x30,0x36,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,
    0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,0x64,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x37,0x36,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,
    0x37,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x38,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x37,0x39,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,
    0x28,0x32,0x31,0x2e,0x30,0x2c,0x20,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x38,0x30,0x20,0x3d,0x20,0x32,0x30,0x2e,0x30,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x38,0x31,0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x38,0x32,0x20,0x3d,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,
    0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x39,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x38,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x33,0x20,0x3d,
    0x20,0x35,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x37,0x37,0x30,0x20,0x3d,0x20,0x73,0x6d,0x69,
    0x6e,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x38,0x32,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x33,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x37,0x37,0x30,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x38,0x34,0x20,0x3d,0x20,0x76,0x65,0x63,0x33,0x28,0x30,0x2e,
    0x39,0x38,0x30,0x30,0x30,0x30,0x30,0x31,0x39,0x30,0x37,0x33,0x34,0x38,0x36,0x33,
    0x32,0x38,0x31,0x32,0x35,0x2c,0x20,0x30,0x2e,0x37,0x39,0x30,0x30,0x30,0x30,0x30,
    0x32,0x31,0x34,0x35,0x37,0x36,0x37,0x32,0x31,0x31,0x39,0x31,0x34,0x30,0x36,0x32,
    0x35,0x2c,0x20,0x30,0x2e,0x36,0x38,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,0x31,
    0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x33,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x38,0x35,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x36,0x20,0x3d,0x20,0x5f,0x37,0x37,0x30,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,
    0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x38,0x35,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x36,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x37,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x76,
    0x65,0x63,0x32,0x28,0x30,0x2e,0x30,0x2c,0x20,0x5f,0x34,0x31,0x35,0x20,0x2a,0x20,
    0x30,0x2e,0x35,0x20,0x2b,0x20,0x28,0x2d,0x31,0x32,0x2e,0x30,0x29,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x38,0x20,0x3d,0x20,0x32,0x2e,0x30,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,
    0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x37,0x2c,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x38,0x38,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,
    0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x39,0x20,0x3d,
    0x20,0x71,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x30,0x2e,0x30,0x2c,0x20,0x2d,
    0x31,0x38,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x30,0x20,
    0x3d,0x20,0x5f,0x34,0x31,0x35,0x20,0x2a,0x20,0x30,0x2e,0x33,0x30,0x30,0x30,0x30,
    0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,0x38,0x39,0x35,0x35,0x30,0x37,0x38,
    0x31,0x32,0x35,0x20,0x2b,0x20,0x33,0x2e,0x31,0x34,0x31,0x35,0x39,0x32,0x37,0x34,
    0x31,0x30,0x31,0x32,0x35,0x37,0x33,0x32,0x34,0x32,0x31,0x38,0x37,0x35,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x31,0x20,0x3d,0x20,0x30,0x2e,0x33,0x30,0x30,
    0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,0x38,0x39,0x35,0x35,0x30,
    0x37,0x38,0x31,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x32,0x20,
    0x3d,0x20,0x34,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x33,0x20,
    0x3d,0x20,0x30,0x2e,0x34,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x35,0x39,0x36,0x30,
    0x34,0x36,0x34,0x34,0x37,0x37,0x35,0x33,0x39,0x30,0x36,0x32,0x35,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,
    0x38,0x30,0x39,0x20,0x3d,0x20,0x73,0x64,0x5f,0x61,0x72,0x63,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x38,0x39,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x30,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x39,0x32,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x33,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x5f,0x38,0x31,0x30,0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x38,0x31,0x32,0x20,0x3d,
    0x20,0x6d,0x69,0x6e,0x28,0x5f,0x38,0x31,0x30,0x2c,0x20,0x5f,0x38,0x30,0x39,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x38,0x31,0x32,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x33,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x39,0x34,0x20,0x3d,0x20,0x76,0x65,0x63,0x33,0x28,0x30,
    0x2e,0x36,0x37,0x30,0x30,0x30,0x30,0x30,0x31,0x36,0x36,0x38,0x39,0x33,0x30,0x30,
    0x35,0x33,0x37,0x31,0x30,0x39,0x33,0x37,0x35,0x2c,0x20,0x30,0x2e,0x33,0x36,0x30,
    0x30,0x30,0x30,0x30,0x31,0x34,0x33,0x30,0x35,0x31,0x31,0x34,0x37,0x34,0x36,0x30,
    0x39,0x33,0x37,0x35,0x2c,0x20,0x30,0x2e,0x33,0x31,0x39,0x39,0x39,0x39,0x39,0x39,
    0x32,0x38,0x34,0x37,0x34,0x34,0x32,0x36,0x32,0x36,0x39,0x35,0x33,0x31,0x32,0x35,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,
    0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x35,0x20,0x3d,0x20,0x6f,0x63,0x6f,
    0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x36,0x20,0x3d,0x20,0x5f,0x38,
    0x31,0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,
    0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x34,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x39,0x35,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,
    0x36,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,
    0x63,0x32,0x20,0x5f,0x39,0x35,0x32,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x5f,0x39,0x35,0x32,0x2e,0x79,0x20,0x3d,0x20,0x28,0x70,0x2e,
    0x79,0x20,0x2d,0x20,0x28,0x2d,0x31,0x32,0x2e,0x30,0x29,0x29,0x20,0x2f,0x20,0x28,
    0x31,0x2e,0x30,0x20,0x2d,0x20,0x73,0x6d,0x6f,0x6f,0x74,0x68,0x73,0x74,0x65,0x70,
    0x28,0x30,0x2e,0x39,0x38,0x30,0x30,0x30,0x30,0x30,0x31,0x39,0x30,0x37,0x33,0x34,
    0x38,0x36,0x33,0x32,0x38,0x31,0x32,0x35,0x2c,0x20,0x31,0x2e,0x30,0x2c,0x20,0x73,
    0x69,0x6e,0x28,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,0x30,
    0x5d,0x2e,0x78,0x20,0x2a,0x20,0x33,0x2e,0x30,0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x39,0x35,0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x39,0x37,0x20,0x3d,0x20,0x5f,0x39,0x35,0x32,0x20,0x2d,0x20,0x76,0x65,0x63,
    0x32,0x28,0x32,0x30,0x2e,0x30,0x2c,0x20,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x39,0x38,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x28,0x39,0x2e,0x30,
    0x2c,0x20,0x31,0x32,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,
    0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,
    0x39,0x20,0x3d,0x20,0x32,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,
    0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x38,0x34,0x37,0x20,0x3d,0x20,
    0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,0x64,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x39,0x37,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x38,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x39,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x64,0x20,0x3d,0x20,0x5f,0x38,0x34,0x37,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x30,0x30,0x20,0x3d,0x20,0x76,0x65,0x63,0x33,0x28,0x31,0x2e,0x30,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x33,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x31,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x32,0x20,0x3d,0x20,0x5f,0x38,0x34,
    0x37,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,
    0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x30,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x31,0x30,0x32,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,
    0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x33,0x20,0x3d,
    0x20,0x71,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x31,0x39,0x2e,0x35,0x2c,0x20,
    0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,
    0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x34,0x20,0x3d,
    0x20,0x76,0x65,0x63,0x32,0x28,0x35,0x2e,0x30,0x2c,0x20,0x38,0x2e,0x30,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x35,0x20,0x3d,0x20,0x32,0x2e,0x30,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x5f,0x38,0x36,0x34,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,
    0x70,0x73,0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x33,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x31,0x30,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,
    0x5f,0x38,0x36,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,
    0x76,0x65,0x63,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x36,0x20,0x3d,
    0x20,0x76,0x65,0x63,0x33,0x28,0x30,0x2e,0x36,0x37,0x30,0x30,0x30,0x30,0x30,0x31,
    0x36,0x36,0x38,0x39,0x33,0x30,0x30,0x35,0x33,0x37,0x31,0x30,0x39,0x33,0x37,0x35,
    0x2c,0x20,0x30,0x2e,0x33,0x36,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x33,0x30,0x35,
    0x31,0x31,0x34,0x37,0x34,0x36,0x30,0x39,0x33,0x37,0x35,0x2c,0x20,0x30,0x2e,0x33,
    0x31,0x39,0x39,0x39,0x39,0x39,0x39,0x32,0x38,0x34,0x37,0x34,0x34,0x32,0x36,0x32,
    0x36,0x39,0x35,0x33,0x31,0x32,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x30,0x37,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,
    0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x31,0x30,0x38,0x20,0x3d,0x20,0x5f,0x38,0x36,0x34,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x31,0x30,0x36,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x30,0x37,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x38,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x5f,
    0x38,0x37,0x33,0x20,0x3d,0x20,0x70,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x2d,
    0x32,0x2e,0x30,0x2c,0x20,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,
    0x38,0x37,0x33,0x2e,0x78,0x20,0x3d,0x20,0x61,0x62,0x73,0x28,0x5f,0x38,0x37,0x33,
    0x2e,0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x38,0x37,
    0x33,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,
    0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x39,0x20,0x3d,0x20,0x5f,0x38,
    0x37,0x33,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x28,0x31,0x39,0x2e,0x35,0x2c,0x20,
    0x2d,0x38,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x30,
    0x20,0x3d,0x20,0x31,0x2e,0x32,0x39,0x39,0x39,0x39,0x39,0x39,0x35,0x32,0x33,0x31,
    0x36,0x32,0x38,0x34,0x31,0x37,0x39,0x36,0x38,0x37,0x35,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x38,0x38,
    0x34,0x20,0x3d,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x31,0x30,0x39,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x31,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x38,0x38,
    0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,
    0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x31,0x20,0x3d,0x20,0x76,0x65,
    0x63,0x33,0x28,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,0x67,
    0x68,0x70,0x20,0x76,0x65,0x63,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,
    0x32,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,0x69,
    0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x31,0x31,0x33,0x20,0x3d,0x20,0x5f,0x38,0x38,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x33,0x20,0x5f,0x38,0x39,0x30,0x20,
    0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,
    0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x32,0x2c,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x31,0x31,0x33,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,
    0x6f,0x6c,0x20,0x3d,0x20,0x5f,0x38,0x39,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,
    0x65,0x74,0x75,0x72,0x6e,0x20,0x5f,0x38,0x39,0x30,0x3b,0x0a,0x7d,0x0a,0x0a,0x76,
    0x6f,0x69,0x64,0x20,0x6d,0x61,0x69,0x6e,0x28,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x20,0x3d,0x20,0x66,0x72,0x61,0x67,0x50,0x6f,0x73,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x33,0x20,0x5f,0x38,0x39,0x39,
    0x20,0x3d,0x20,0x6d,0x61,0x70,0x28,0x70,0x61,0x72,0x61,0x6d,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x76,
    0x65,0x63,0x34,0x28,0x5f,0x38,0x39,0x39,0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,
    0x7d,0x0a,0x0a,0x00,
};
/*
    cbuffer vs_uniforms : register(b0)
    {
        float2 _36_iResolution : packoffset(c0);
    };


    static float4 gl_Position;
    static float4 coord;
    static float2 fragPos;
    static float2 texUV;

    struct SPIRV_Cross_Input
    {
        float4 coord : TEXCOORD0;
    };

    struct SPIRV_Cross_Output
    {
        float2 texUV : TEXCOORD0;
        float2 fragPos : TEXCOORD1;
        float4 gl_Position : SV_Position;
    };

    void vert_main()
    {
        gl_Position = float4(coord.xy, 0.0f, 1.0f);
        fragPos = float2(coord.x * (_36_iResolution.x / _36_iResolution.y), coord.y);
        texUV = coord.zw;
    }

    SPIRV_Cross_Output main(SPIRV_Cross_Input stage_input)
    {
        coord = stage_input.coord;
        vert_main();
        SPIRV_Cross_Output stage_output;
        stage_output.gl_Position = gl_Position;
        stage_output.fragPos = fragPos;
        stage_output.texUV = texUV;
        return stage_output;
    }
*/
static const uint8_t sdf_vs_source_hlsl4[829] = {
    0x63,0x62,0x75,0x66,0x66,0x65,0x72,0x20,0x76,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,
    0x72,0x6d,0x73,0x20,0x3a,0x20,0x72,0x65,0x67,0x69,0x73,0x74,0x65,0x72,0x28,0x62,
    0x30,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x5f,0x33,0x36,0x5f,0x69,0x52,0x65,0x73,0x6f,0x6c,0x75,0x74,0x69,0x6f,0x6e,0x20,
    0x3a,0x20,0x70,0x61,0x63,0x6b,0x6f,0x66,0x66,0x73,0x65,0x74,0x28,0x63,0x30,0x29,
    0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x34,0x20,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,
    0x3b,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,
    0x63,0x6f,0x6f,0x72,0x64,0x3b,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x66,0x72,0x61,0x67,0x50,0x6f,0x73,0x3b,0x0a,0x73,0x74,
    0x61,0x74,0x69,0x63,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x74,0x65,0x78,0x55,
    0x56,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x53,0x50,0x49,0x52,0x56,
    0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x49,0x6e,0x70,0x75,0x74,0x0a,0x7b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x63,0x6f,0x6f,0x72,0x64,0x20,
    0x3a,0x20,0x54,0x45,0x58,0x43,0x4f,0x4f,0x52,0x44,0x30,0x3b,0x0a,0x7d,0x3b,0x0a,
    0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,0x72,
    0x6f,0x73,0x73,0x5f,0x4f,0x75,0x74,0x70,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x74,0x65,0x78,0x55,0x56,0x20,0x3a,0x20,
    0x54,0x45,0x58,0x43,0x4f,0x4f,0x52,0x44,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x20,0x66,0x72,0x61,0x67,0x50,0x6f,0x73,0x20,0x3a,0x20,
    0x54,0x45,0x58,0x43,0x4f,0x4f,0x52,0x44,0x31,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x34,0x20,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,
    0x6e,0x20,0x3a,0x20,0x53,0x56,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x3b,
    0x0a,0x7d,0x3b,0x0a,0x0a,0x76,0x6f,0x69,0x64,0x20,0x76,0x65,0x72,0x74,0x5f,0x6d,
    0x61,0x69,0x6e,0x28,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x67,0x6c,0x5f,0x50,
    0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,
    0x28,0x63,0x6f,0x6f,0x72,0x64,0x2e,0x78,0x79,0x2c,0x20,0x30,0x2e,0x30,0x66,0x2c,
    0x20,0x31,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x72,0x61,0x67,
    0x50,0x6f,0x73,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x63,0x6f,0x6f,
    0x72,0x64,0x2e,0x78,0x20,0x2a,0x20,0x28,0x5f,0x33,0x36,0x5f,0x69,0x52,0x65,0x73,
    0x6f,0x6c,0x75,0x74,0x69,0x6f,0x6e,0x2e,0x78,0x20,0x2f,0x20,0x5f,0x33,0x36,0x5f,
    0x69,0x52,0x65,0x73,0x6f,0x6c,0x75,0x74,0x69,0x6f,0x6e,0x2e,0x79,0x29,0x2c,0x20,
    0x63,0x6f,0x6f,0x72,0x64,0x2e,0x79,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x74,0x65,
    0x78,0x55,0x56,0x20,0x3d,0x20,0x63,0x6f,0x6f,0x72,0x64,0x2e,0x7a,0x77,0x3b,0x0a,
    0x7d,0x0a,0x0a,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x4f,
    0x75,0x74,0x70,0x75,0x74,0x20,0x6d,0x61,0x69,0x6e,0x28,0x53,0x50,0x49,0x52,0x56,
    0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x49,0x6e,0x70,0x75,0x74,0x20,0x73,0x74,0x61,
    0x67,0x65,0x5f,0x69,0x6e,0x70,0x75,0x74,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,
    0x63,0x6f,0x6f,0x72,0x64,0x20,0x3d,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,
    0x70,0x75,0x74,0x2e,0x63,0x6f,0x6f,0x72,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,
    0x65,0x72,0x74,0x5f,0x6d,0x61,0x69,0x6e,0x28,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x53,0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x4f,0x75,0x74,0x70,
    0x75,0x74,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,0x74,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,
    0x74,0x2e,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,
    0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,0x74,0x2e,0x66,0x72,
    0x61,0x67,0x50,0x6f,0x73,0x20,0x3d,0x20,0x66,0x72,0x61,0x67,0x50,0x6f,0x73,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,
    0x74,0x2e,0x74,0x65,0x78,0x55,0x56,0x20,0x3d,0x20,0x74,0x65,0x78,0x55,0x56,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x73,0x74,0x61,0x67,
    0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x00,
};
/*
    cbuffer fs_uniforms : register(b0)
    {
        float _408_iTime : packoffset(c0);
    };


    static float2 fragPos;
    static float4 fragColor;
    static float2 texUV;

    struct SPIRV_Cross_Input
    {
        float2 texUV : TEXCOORD0;
        float2 fragPos : TEXCOORD1;
    };

    struct SPIRV_Cross_Output
    {
        float4 fragColor : SV_Target0;
    };

    float mod(float x, float y)
    {
        return x - y * floor(x / y);
    }

    float2 mod(float2 x, float2 y)
    {
        return x - y * floor(x / y);
    }

    float3 mod(float3 x, float3 y)
    {
        return x - y * floor(x / y);
    }

    float4 mod(float4 x, float4 y)
    {
        return x - y * floor(x / y);
    }

    float3 background(float2 uv)
    {
        float2 _315 = abs(floor(uv));
        return 0.38999998569488525390625f.xxx + (0.17000000178813934326171875f.xxx * mod(_315.x + _315.y, 2.0f));
    }

    float length_n(inout float2 p, float n)
    {
        p = pow(abs(p), n.xx);
        return pow(p.x + p.y, 1.0f / n);
    }

    float sd_ellipsoid(float2 p, float2 r, float roundness)
    {
        float2 param = p / r;
        float param_1 = roundness;
        float _103 = length_n(param, param_1);
        float2 param_2 = p / (r * r);
        float param_3 = roundness;
        float _113 = length_n(param_2, param_3);
        return (_103 * (_103 - 1.0f)) / _113;
    }

    float3 blend(float3 col, float3 ocol, float d)
    {
        return lerp(ocol, col, smoothstep(0.5f, 0.0f, d).xxx);
    }

    float sd_line(float2 p, float2 a, float2 b)
    {
        float2 _240 = p - a;
        float2 _244 = b - a;
        return length(_240 - (_244 * clamp(dot(_240, _244) / dot(_244, _244), 0.0f, 1.0f)));
    }

    float2 rotate(float2 p, float theta)
    {
        float _264 = cos(theta);
        float _267 = sin(theta);
        return float2(mad(p.x, _264, -(p.y * _267)), mad(p.x, _267, p.y * _264));
    }

    float sd_vesica(inout float2 p, float r, float d)
    {
        p = abs(p);
        float _132 = sqrt(mad(r, r, -(d * d)));
        float _145;
        if (((p.y - _132) * d) > (p.x * _132))
        {
            _145 = length(p - float2(0.0f, _132));
        }
        else
        {
            _145 = length(p - float2(-d, 0.0f)) - r;
        }
        return _145;
    }

    float smin(float a, float b, float k)
    {
        float _298 = max(k - abs(a - b), 0.0f) / k;
        return mad(-((_298 * _298) * k), 0.25f, min(a, b));
    }

    float sd_circle(float2 p, float r)
    {
        return length(p) - r;
    }

    float sd_arc(inout float2 p, float ta, float tb, float ra, float rb)
    {
        float _168 = cos(ta);
        float _170 = sin(ta);
        float _174 = cos(tb);
        float _176 = sin(tb);
        p = mul(float2x2(float2(_168, _170), float2(-_170, _168)), p);
        p.x = abs(p.x);
        float _209;
        if ((_176 * p.x) > (_174 * p.y))
        {
            _209 = dot(p, float2(_174, _176));
        }
        else
        {
            _209 = length(p);
        }
        return sqrt(mad(ra * (-2.0f), _209, mad(ra, ra, dot(p, p)))) - rb;
    }

    float3 map(inout float2 p)
    {
        p *= 100.0f;
        p.y -= 30.0f;
        float2 _356 = float2(abs(p.x), p.y);
        float2 param = p * 0.300000011920928955078125f;
        float3 ocol = background(param);
        float2 param_1 = p - float2(0.0f, -97.0f);
        float2 param_2 = float2(55.0f, 20.0f);
        float param_3 = 2.0f;
        float _374 = sd_ellipsoid(param_1, param_2, param_3);
        float d = _374;
        float3 param_4 = float3(0.61000001430511474609375f, 0.85000002384185791015625f, 0.939999997615814208984375f);
        float3 param_5 = ocol;
        float param_6 = _374;
        ocol = blend(param_4, param_5, param_6);
        float2 q = _356;
        float2 param_7 = _356;
        float2 param_8 = float2(55.0f, 45.0f);
        float param_9 = 2.400000095367431640625f;
        d = sd_ellipsoid(param_7, param_8, param_9);
        float2 _398 = q - float2(45.0f, -15.0f);
        float _400 = _398.x;
        float _415 = sin(_408_iTime);
        _398.y = mad((_400 * _400) * 0.0030000000260770320892333984375f, _415, _398.y);
        q = _398;
        float2 param_10 = _398;
        float2 param_11 = 0.0f.xx;
        float2 param_12 = float2(45.0f, 0.0f);
        d = min(d, sd_line(param_10, param_11, param_12) - 0.20000000298023223876953125f);
        float2 _922 = q;
        _922.y = mad((_922.x * _922.x) * 0.0030000000260770320892333984375f, sin(_408_iTime * 2.0f), _922.y + 6.0f);
        q = _922;
        float2 param_13 = _922;
        float2 param_14 = 0.0f.xx;
        float2 param_15 = float2(45.0f, 0.0f);
        d = min(d, sd_line(param_13, param_14, param_15) - 0.20000000298023223876953125f);
        float2 _466 = _356 - float2(32.0f, 30.0f);
        q = _466;
        float2 param_16 = _466;
        float param_17 = mad(_415, 0.300000011920928955078125f, 0.699999988079071044921875f);
        float2 _476 = rotate(param_16, param_17);
        q = _476;
        float2 param_18 = _476;
        float param_19 = 30.0f;
        float param_20 = 15.0f;
        float _482 = sd_vesica(param_18, param_19, param_20);
        float _483 = d;
        float _485 = min(_483, _482);
        d = _485;
        float3 param_21 = 0.119999997317790985107421875f.xxx;
        float3 param_22 = ocol;
        float param_23 = _485;
        ocol = blend(param_21, param_22, param_23);
        q = _356;
        float2 param_24 = _356 - float2(0.0f, -60.0f);
        float2 param_25 = float2(27.0f, 20.0f);
        float param_26 = 2.0f;
        d = sd_ellipsoid(param_24, param_25, param_26);
        float2 param_27 = q - float2(0.0f, -70.0f);
        float2 param_28 = float2(20.0f, 16.0f);
        float param_29 = 2.0f;
        d = max(-sd_ellipsoid(param_27, param_28, param_29), d);
        float2 _522 = _356 - float2(6.0f, -50.0f);
        q = _522;
        float2 param_30 = _522;
        float param_31 = mad(0.5f, _415, 0.5f) * (-0.100000001490116119384765625f);
        float2 _534 = rotate(param_30, param_31);
        _534.x = mad(-pow(max((-45.0f) - _534.y, 0.0f), 1.89999997615814208984375f), 0.100000001490116119384765625f, _534.x);
        q = _534;
        float2 param_32 = _534;
        float2 param_33 = float2(0.0f, -50.0f);
        float2 param_34 = 0.0f.xx;
        float param_35 = d;
        float param_36 = sd_line(param_32, param_33, param_34) - 5.0f;
        float param_37 = 1.0f;
        d = smin(param_35, param_36, param_37);
        float2 _564 = _356 - float2(22.0f, -60.0f);
        q = _564;
        float2 param_38 = _564;
        float param_39 = mad(0.5f, cos(_408_iTime), 0.5f) * (-0.100000001490116119384765625f);
        float2 _575 = rotate(param_38, param_39);
        _575.x = mad(-pow(max((-29.0f) - _575.y, 0.0f), 1.89999997615814208984375f), 0.100000001490116119384765625f, _575.x);
        q = _575;
        float2 param_40 = _575;
        float2 param_41 = float2(0.0f, -35.0f);
        float2 param_42 = 0.0f.xx;
        float param_43 = d;
        float param_44 = sd_line(param_40, param_41, param_42) - 5.0f;
        float param_45 = 1.0f;
        d = smin(param_43, param_44, param_45);
        float2 _604 = p - float2(-26.0f, -60.0f);
        q = _604;
        float2 param_46 = _604;
        float param_47 = 2.19911479949951171875f;
        float2 _609 = rotate(param_46, param_47);
        float _611 = _609.y;
        _609.x = _609.x - mad(sin(mad(_611, 0.123000003397464752197265625f, 3.0f)), 4.0f, sin(mad(_611, 0.100000001490116119384765625f, _408_iTime * 10.0f)));
        q = _609;
        float2 param_48 = _609;
        float2 param_49 = float2(0.0f, -40.0f);
        float2 param_50 = 0.0f.xx;
        float param_51 = d;
        float param_52 = mad(-5.0f, smoothstep(-60.0f, 0.0f, q.y), sd_line(param_48, param_49, param_50));
        float param_53 = 1.0f;
        float _650 = smin(param_51, param_52, param_53);
        d = _650;
        float3 param_54 = 0.119999997317790985107421875f.xxx;
        float3 param_55 = ocol;
        float param_56 = _650;
        ocol = blend(param_54, param_55, param_56);
        float2 param_57 = q - float2(-2.0f, -4.0f);
        float param_58 = 1.2999999523162841796875f;
        float _665 = sd_circle(param_57, param_58);
        d = _665;
        float2 param_59 = q - float2(-2.0f, -9.0f);
        float param_60 = 1.2000000476837158203125f;
        float _675 = min(_665, sd_circle(param_59, param_60));
        d = _675;
        float2 param_61 = q - float2(-2.0f, -15.0f);
        float param_62 = 1.10000002384185791015625f;
        float _684 = min(_675, sd_circle(param_61, param_62));
        d = _684;
        float2 param_63 = q - float2(-2.0f, -20.0f);
        float param_64 = 1.0f;
        float _693 = min(_684, sd_circle(param_63, param_64));
        d = _693;
        float2 param_65 = q - float2(-1.60000002384185791015625f, -25.0f);
        float param_66 = 0.89999997615814208984375f;
        float _704 = min(_693, sd_circle(param_65, param_66));
        d = _704;
        float2 param_67 = q - float2(-1.2999999523162841796875f, -29.0f);
        float param_68 = 0.800000011920928955078125f;
        float _714 = min(_704, sd_circle(param_67, param_68));
        d = _714;
        float2 param_69 = q - float2(-0.89999997615814208984375f, -33.0f);
        float param_70 = 0.699999988079071044921875f;
        float _724 = min(_714, sd_circle(param_69, param_70));
        d = _724;
        float2 param_71 = q - float2(-0.800000011920928955078125f, -37.0f);
        float param_72 = 0.60000002384185791015625f;
        float _735 = min(_724, sd_circle(param_71, param_72));
        d = _735;
        float3 param_73 = float3(0.61000001430511474609375f, 0.85000002384185791015625f, 0.939999997615814208984375f);
        float3 param_74 = ocol;
        float param_75 = _735;
        ocol = blend(param_73, param_74, param_75);
        float2 _946 = _356;
        _946.y = p.y - (-11.0f);
        q = _946;
        float2 param_76 = _946 - float2(0.0f, -5.0f);
        float2 param_77 = float2(40.0f, 20.0f);
        float param_78 = 2.900000095367431640625f;
        d = sd_ellipsoid(param_76, param_77, param_78);
        float2 param_79 = q - float2(21.0f, 0.0f);
        float param_80 = 20.0f;
        float param_81 = d;
        float param_82 = sd_circle(param_79, param_80);
        float param_83 = 5.0f;
        float _770 = smin(param_81, param_82, param_83);
        d = _770;
        float3 param_84 = float3(0.980000019073486328125f, 0.790000021457672119140625f, 0.689999997615814208984375f);
        float3 param_85 = ocol;
        float param_86 = _770;
        ocol = blend(param_84, param_85, param_86);
        float2 param_87 = q - float2(0.0f, mad(_415, 0.5f, -12.0f));
        float param_88 = 2.0f;
        d = sd_circle(param_87, param_88);
        float2 param_89 = q - float2(0.0f, -18.0f);
        float param_90 = mad(_415, 0.300000011920928955078125f, 3.1415927410125732421875f);
        float param_91 = 0.300000011920928955078125f;
        float param_92 = 4.0f;
        float param_93 = 0.4000000059604644775390625f;
        float _809 = sd_arc(param_89, param_90, param_91, param_92, param_93);
        float _810 = d;
        float _812 = min(_810, _809);
        d = _812;
        float3 param_94 = float3(0.670000016689300537109375f, 0.36000001430511474609375f, 0.319999992847442626953125f);
        float3 param_95 = ocol;
        float param_96 = _812;
        ocol = blend(param_94, param_95, param_96);
        float2 _952 = _356;
        _952.y = (p.y - (-12.0f)) / (1.0f - smoothstep(0.980000019073486328125f, 1.0f, sin(_408_iTime * 3.0f)));
        q = _952;
        float2 param_97 = _952 - float2(20.0f, 0.0f);
        float2 param_98 = float2(9.0f, 12.0f);
        float param_99 = 2.0f;
        float _847 = sd_ellipsoid(param_97, param_98, param_99);
        d = _847;
        float3 param_100 = 1.0f.xxx;
        float3 param_101 = ocol;
        float param_102 = _847;
        ocol = blend(param_100, param_101, param_102);
        float2 param_103 = q - float2(19.5f, 0.0f);
        float2 param_104 = float2(5.0f, 8.0f);
        float param_105 = 2.0f;
        float _864 = sd_ellipsoid(param_103, param_104, param_105);
        d = _864;
        float3 param_106 = float3(0.670000016689300537109375f, 0.36000001430511474609375f, 0.319999992847442626953125f);
        float3 param_107 = ocol;
        float param_108 = _864;
        ocol = blend(param_106, param_107, param_108);
        float2 _873 = p - float2(-2.0f, 0.0f);
        _873.x = abs(_873.x);
        q = _873;
        float2 param_109 = _873 - float2(19.5f, -8.0f);
        float param_110 = 1.2999999523162841796875f;
        float _884 = sd_circle(param_109, param_110);
        d = _884;
        float3 param_111 = 1.0f.xxx;
        float3 param_112 = ocol;
        float param_113 = _884;
        float3 _890 = blend(param_111, param_112, param_113);
        ocol = _890;
        return _890;
    }

    void frag_main()
    {
        float2 param = fragPos;
        float3 _899 = map(param);
        fragColor = float4(_899, 1.0f);
    }

    SPIRV_Cross_Output main(SPIRV_Cross_Input stage_input)
    {
        fragPos = stage_input.fragPos;
        texUV = stage_input.texUV;
        frag_main();
        SPIRV_Cross_Output stage_output;
        stage_output.fragColor = fragColor;
        return stage_output;
    }
*/
static const uint8_t sdf_fs_source_hlsl4[12097] = {
    0x63,0x62,0x75,0x66,0x66,0x65,0x72,0x20,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,
    0x72,0x6d,0x73,0x20,0x3a,0x20,0x72,0x65,0x67,0x69,0x73,0x74,0x65,0x72,0x28,0x62,
    0x30,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,
    0x34,0x30,0x38,0x5f,0x69,0x54,0x69,0x6d,0x65,0x20,0x3a,0x20,0x70,0x61,0x63,0x6b,
    0x6f,0x66,0x66,0x73,0x65,0x74,0x28,0x63,0x30,0x29,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,
    0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x66,
    0x72,0x61,0x67,0x50,0x6f,0x73,0x3b,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x34,0x20,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,0x72,0x3b,
    0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x74,
    0x65,0x78,0x55,0x56,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x53,0x50,
    0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x49,0x6e,0x70,0x75,0x74,0x0a,
    0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x74,0x65,0x78,
    0x55,0x56,0x20,0x3a,0x20,0x54,0x45,0x58,0x43,0x4f,0x4f,0x52,0x44,0x30,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x66,0x72,0x61,0x67,0x50,
    0x6f,0x73,0x20,0x3a,0x20,0x54,0x45,0x58,0x43,0x4f,0x4f,0x52,0x44,0x31,0x3b,0x0a,
    0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x53,0x50,0x49,0x52,0x56,
    0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x4f,0x75,0x74,0x70,0x75,0x74,0x0a,0x7b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x66,0x72,0x61,0x67,0x43,
    0x6f,0x6c,0x6f,0x72,0x20,0x3a,0x20,0x53,0x56,0x5f,0x54,0x61,0x72,0x67,0x65,0x74,
    0x30,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x20,0x6d,0x6f,0x64,
    0x28,0x66,0x6c,0x6f,0x61,0x74,0x20,0x78,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x79,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,
    0x78,0x20,0x2d,0x20,0x79,0x20,0x2a,0x20,0x66,0x6c,0x6f,0x6f,0x72,0x28,0x78,0x20,
    0x2f,0x20,0x79,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x6d,0x6f,0x64,0x28,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x78,0x2c,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x79,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,
    0x74,0x75,0x72,0x6e,0x20,0x78,0x20,0x2d,0x20,0x79,0x20,0x2a,0x20,0x66,0x6c,0x6f,
    0x6f,0x72,0x28,0x78,0x20,0x2f,0x20,0x79,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x6c,
    0x6f,0x61,0x74,0x33,0x20,0x6d,0x6f,0x64,0x28,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,
    0x78,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x79,0x29,0x0a,0x7b,0x0a,0x20,
    0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x78,0x20,0x2d,0x20,0x79,0x20,
    0x2a,0x20,0x66,0x6c,0x6f,0x6f,0x72,0x28,0x78,0x20,0x2f,0x20,0x79,0x29,0x3b,0x0a,
    0x7d,0x0a,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x6d,0x6f,0x64,0x28,0x66,0x6c,
    0x6f,0x61,0x74,0x34,0x20,0x78,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x79,
    0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x78,
    0x20,0x2d,0x20,0x79,0x20,0x2a,0x20,0x66,0x6c,0x6f,0x6f,0x72,0x28,0x78,0x20,0x2f,
    0x20,0x79,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x62,
    0x61,0x63,0x6b,0x67,0x72,0x6f,0x75,0x6e,0x64,0x28,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x75,0x76,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x20,0x5f,0x33,0x31,0x35,0x20,0x3d,0x20,0x61,0x62,0x73,0x28,0x66,0x6c,0x6f,
    0x6f,0x72,0x28,0x75,0x76,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,
    0x75,0x72,0x6e,0x20,0x30,0x2e,0x33,0x38,0x39,0x39,0x39,0x39,0x39,0x38,0x35,0x36,
    0x39,0x34,0x38,0x38,0x35,0x32,0x35,0x33,0x39,0x30,0x36,0x32,0x35,0x66,0x2e,0x78,
    0x78,0x78,0x20,0x2b,0x20,0x28,0x30,0x2e,0x31,0x37,0x30,0x30,0x30,0x30,0x30,0x30,
    0x31,0x37,0x38,0x38,0x31,0x33,0x39,0x33,0x34,0x33,0x32,0x36,0x31,0x37,0x31,0x38,
    0x37,0x35,0x66,0x2e,0x78,0x78,0x78,0x20,0x2a,0x20,0x6d,0x6f,0x64,0x28,0x5f,0x33,
    0x31,0x35,0x2e,0x78,0x20,0x2b,0x20,0x5f,0x33,0x31,0x35,0x2e,0x79,0x2c,0x20,0x32,
    0x2e,0x30,0x66,0x29,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x6c,0x65,0x6e,0x67,0x74,0x68,0x5f,0x6e,0x28,0x69,0x6e,0x6f,0x75,0x74,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x6e,
    0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x70,0x20,0x3d,0x20,0x70,0x6f,0x77,0x28,
    0x61,0x62,0x73,0x28,0x70,0x29,0x2c,0x20,0x6e,0x2e,0x78,0x78,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x70,0x6f,0x77,0x28,0x70,0x2e,
    0x78,0x20,0x2b,0x20,0x70,0x2e,0x79,0x2c,0x20,0x31,0x2e,0x30,0x66,0x20,0x2f,0x20,
    0x6e,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x20,0x73,0x64,0x5f,
    0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,0x64,0x28,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x70,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x72,0x2c,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x72,0x6f,0x75,0x6e,0x64,0x6e,0x65,0x73,0x73,0x29,0x0a,0x7b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x20,0x3d,0x20,0x70,0x20,0x2f,0x20,0x72,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x20,0x3d,0x20,0x72,
    0x6f,0x75,0x6e,0x64,0x6e,0x65,0x73,0x73,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x5f,0x31,0x30,0x33,0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,0x74,
    0x68,0x5f,0x6e,0x28,0x70,0x61,0x72,0x61,0x6d,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x31,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x20,0x3d,0x20,0x70,0x20,0x2f,0x20,0x28,0x72,
    0x20,0x2a,0x20,0x72,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x20,0x3d,0x20,0x72,0x6f,0x75,0x6e,0x64,
    0x6e,0x65,0x73,0x73,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x5f,0x31,0x31,0x33,0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x5f,0x6e,0x28,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x28,0x5f,
    0x31,0x30,0x33,0x20,0x2a,0x20,0x28,0x5f,0x31,0x30,0x33,0x20,0x2d,0x20,0x31,0x2e,
    0x30,0x66,0x29,0x29,0x20,0x2f,0x20,0x5f,0x31,0x31,0x33,0x3b,0x0a,0x7d,0x0a,0x0a,
    0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x66,0x6c,0x6f,
    0x61,0x74,0x33,0x20,0x63,0x6f,0x6c,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,
    0x6f,0x63,0x6f,0x6c,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x64,0x29,0x0a,0x7b,
    0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6c,0x65,0x72,0x70,
    0x28,0x6f,0x63,0x6f,0x6c,0x2c,0x20,0x63,0x6f,0x6c,0x2c,0x20,0x73,0x6d,0x6f,0x6f,
    0x74,0x68,0x73,0x74,0x65,0x70,0x28,0x30,0x2e,0x35,0x66,0x2c,0x20,0x30,0x2e,0x30,
    0x66,0x2c,0x20,0x64,0x29,0x2e,0x78,0x78,0x78,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,0x28,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x20,0x70,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x61,0x2c,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x62,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x32,0x34,0x30,0x20,0x3d,0x20,0x70,
    0x20,0x2d,0x20,0x61,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x5f,0x32,0x34,0x34,0x20,0x3d,0x20,0x62,0x20,0x2d,0x20,0x61,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,
    0x28,0x5f,0x32,0x34,0x30,0x20,0x2d,0x20,0x28,0x5f,0x32,0x34,0x34,0x20,0x2a,0x20,
    0x63,0x6c,0x61,0x6d,0x70,0x28,0x64,0x6f,0x74,0x28,0x5f,0x32,0x34,0x30,0x2c,0x20,
    0x5f,0x32,0x34,0x34,0x29,0x20,0x2f,0x20,0x64,0x6f,0x74,0x28,0x5f,0x32,0x34,0x34,
    0x2c,0x20,0x5f,0x32,0x34,0x34,0x29,0x2c,0x20,0x30,0x2e,0x30,0x66,0x2c,0x20,0x31,
    0x2e,0x30,0x66,0x29,0x29,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x20,0x72,0x6f,0x74,0x61,0x74,0x65,0x28,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x70,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x74,0x68,0x65,0x74,0x61,0x29,0x0a,
    0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x32,0x36,0x34,
    0x20,0x3d,0x20,0x63,0x6f,0x73,0x28,0x74,0x68,0x65,0x74,0x61,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x32,0x36,0x37,0x20,0x3d,0x20,
    0x73,0x69,0x6e,0x28,0x74,0x68,0x65,0x74,0x61,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x6d,0x61,
    0x64,0x28,0x70,0x2e,0x78,0x2c,0x20,0x5f,0x32,0x36,0x34,0x2c,0x20,0x2d,0x28,0x70,
    0x2e,0x79,0x20,0x2a,0x20,0x5f,0x32,0x36,0x37,0x29,0x29,0x2c,0x20,0x6d,0x61,0x64,
    0x28,0x70,0x2e,0x78,0x2c,0x20,0x5f,0x32,0x36,0x37,0x2c,0x20,0x70,0x2e,0x79,0x20,
    0x2a,0x20,0x5f,0x32,0x36,0x34,0x29,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x73,0x64,0x5f,0x76,0x65,0x73,0x69,0x63,0x61,0x28,0x69,0x6e,0x6f,
    0x75,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x2c,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x72,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x64,0x29,0x0a,0x7b,
    0x0a,0x20,0x20,0x20,0x20,0x70,0x20,0x3d,0x20,0x61,0x62,0x73,0x28,0x70,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,0x33,0x32,0x20,
    0x3d,0x20,0x73,0x71,0x72,0x74,0x28,0x6d,0x61,0x64,0x28,0x72,0x2c,0x20,0x72,0x2c,
    0x20,0x2d,0x28,0x64,0x20,0x2a,0x20,0x64,0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,0x34,0x35,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x69,0x66,0x20,0x28,0x28,0x28,0x70,0x2e,0x79,0x20,0x2d,0x20,0x5f,0x31,0x33,
    0x32,0x29,0x20,0x2a,0x20,0x64,0x29,0x20,0x3e,0x20,0x28,0x70,0x2e,0x78,0x20,0x2a,
    0x20,0x5f,0x31,0x33,0x32,0x29,0x29,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x31,0x34,0x35,0x20,0x3d,0x20,0x6c,0x65,0x6e,
    0x67,0x74,0x68,0x28,0x70,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,
    0x2e,0x30,0x66,0x2c,0x20,0x5f,0x31,0x33,0x32,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,0x20,0x20,0x20,0x20,
    0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x31,0x34,0x35,0x20,0x3d,
    0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x28,0x70,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x28,0x2d,0x64,0x2c,0x20,0x30,0x2e,0x30,0x66,0x29,0x29,0x20,0x2d,0x20,
    0x72,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,
    0x75,0x72,0x6e,0x20,0x5f,0x31,0x34,0x35,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x73,0x6d,0x69,0x6e,0x28,0x66,0x6c,0x6f,0x61,0x74,0x20,0x61,0x2c,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x62,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x6b,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,
    0x32,0x39,0x38,0x20,0x3d,0x20,0x6d,0x61,0x78,0x28,0x6b,0x20,0x2d,0x20,0x61,0x62,
    0x73,0x28,0x61,0x20,0x2d,0x20,0x62,0x29,0x2c,0x20,0x30,0x2e,0x30,0x66,0x29,0x20,
    0x2f,0x20,0x6b,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,
    0x6d,0x61,0x64,0x28,0x2d,0x28,0x28,0x5f,0x32,0x39,0x38,0x20,0x2a,0x20,0x5f,0x32,
    0x39,0x38,0x29,0x20,0x2a,0x20,0x6b,0x29,0x2c,0x20,0x30,0x2e,0x32,0x35,0x66,0x2c,
    0x20,0x6d,0x69,0x6e,0x28,0x61,0x2c,0x20,0x62,0x29,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x72,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,
    0x6c,0x65,0x6e,0x67,0x74,0x68,0x28,0x70,0x29,0x20,0x2d,0x20,0x72,0x3b,0x0a,0x7d,
    0x0a,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x20,0x73,0x64,0x5f,0x61,0x72,0x63,0x28,0x69,
    0x6e,0x6f,0x75,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x2c,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x74,0x61,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x74,
    0x62,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x72,0x61,0x2c,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x72,0x62,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x5f,0x31,0x36,0x38,0x20,0x3d,0x20,0x63,0x6f,0x73,0x28,0x74,0x61,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,0x37,
    0x30,0x20,0x3d,0x20,0x73,0x69,0x6e,0x28,0x74,0x61,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,0x37,0x34,0x20,0x3d,0x20,0x63,0x6f,
    0x73,0x28,0x74,0x62,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x5f,0x31,0x37,0x36,0x20,0x3d,0x20,0x73,0x69,0x6e,0x28,0x74,0x62,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x70,0x20,0x3d,0x20,0x6d,0x75,0x6c,0x28,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x78,0x32,0x28,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x5f,0x31,0x36,
    0x38,0x2c,0x20,0x5f,0x31,0x37,0x30,0x29,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x28,0x2d,0x5f,0x31,0x37,0x30,0x2c,0x20,0x5f,0x31,0x36,0x38,0x29,0x29,0x2c,0x20,
    0x70,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x70,0x2e,0x78,0x20,0x3d,0x20,0x61,0x62,
    0x73,0x28,0x70,0x2e,0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x5f,0x32,0x30,0x39,0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,
    0x28,0x5f,0x31,0x37,0x36,0x20,0x2a,0x20,0x70,0x2e,0x78,0x29,0x20,0x3e,0x20,0x28,
    0x5f,0x31,0x37,0x34,0x20,0x2a,0x20,0x70,0x2e,0x79,0x29,0x29,0x0a,0x20,0x20,0x20,
    0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x32,0x30,0x39,0x20,
    0x3d,0x20,0x64,0x6f,0x74,0x28,0x70,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,
    0x5f,0x31,0x37,0x34,0x2c,0x20,0x5f,0x31,0x37,0x36,0x29,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,0x20,0x20,0x20,
    0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x32,0x30,0x39,0x20,
    0x3d,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x28,0x70,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x73,0x71,
    0x72,0x74,0x28,0x6d,0x61,0x64,0x28,0x72,0x61,0x20,0x2a,0x20,0x28,0x2d,0x32,0x2e,
    0x30,0x66,0x29,0x2c,0x20,0x5f,0x32,0x30,0x39,0x2c,0x20,0x6d,0x61,0x64,0x28,0x72,
    0x61,0x2c,0x20,0x72,0x61,0x2c,0x20,0x64,0x6f,0x74,0x28,0x70,0x2c,0x20,0x70,0x29,
    0x29,0x29,0x29,0x20,0x2d,0x20,0x72,0x62,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x6c,0x6f,
    0x61,0x74,0x33,0x20,0x6d,0x61,0x70,0x28,0x69,0x6e,0x6f,0x75,0x74,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x70,0x20,
    0x2a,0x3d,0x20,0x31,0x30,0x30,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,0x20,0x20,0x70,
    0x2e,0x79,0x20,0x2d,0x3d,0x20,0x33,0x30,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x33,0x35,0x36,0x20,0x3d,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x28,0x61,0x62,0x73,0x28,0x70,0x2e,0x78,0x29,0x2c,0x20,
    0x70,0x2e,0x79,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x20,0x3d,0x20,0x70,0x20,0x2a,0x20,0x30,0x2e,0x33,
    0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,0x38,0x39,0x35,
    0x35,0x30,0x37,0x38,0x31,0x32,0x35,0x66,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x33,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x61,0x63,0x6b,
    0x67,0x72,0x6f,0x75,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x31,0x20,0x3d,0x20,0x70,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,
    0x2e,0x30,0x66,0x2c,0x20,0x2d,0x39,0x37,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,
    0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x35,0x35,0x2e,0x30,0x66,0x2c,
    0x20,0x32,0x30,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x20,0x3d,0x20,0x32,0x2e,0x30,
    0x66,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x33,0x37,
    0x34,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,0x64,
    0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x32,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x64,0x20,0x3d,0x20,0x5f,0x33,0x37,0x34,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x34,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x28,0x30,0x2e,0x36,
    0x31,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x33,0x30,0x35,0x31,0x31,0x34,0x37,0x34,
    0x36,0x30,0x39,0x33,0x37,0x35,0x66,0x2c,0x20,0x30,0x2e,0x38,0x35,0x30,0x30,0x30,
    0x30,0x30,0x32,0x33,0x38,0x34,0x31,0x38,0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,
    0x32,0x35,0x66,0x2c,0x20,0x30,0x2e,0x39,0x33,0x39,0x39,0x39,0x39,0x39,0x39,0x37,
    0x36,0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x66,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x35,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x20,
    0x3d,0x20,0x5f,0x33,0x37,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,
    0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,
    0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x36,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x71,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x20,0x3d,0x20,0x5f,
    0x33,0x35,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x28,0x35,0x35,0x2e,0x30,0x66,0x2c,0x20,0x34,0x35,0x2e,0x30,0x66,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x39,0x20,0x3d,0x20,0x32,0x2e,0x34,0x30,0x30,0x30,0x30,0x30,0x30,0x39,0x35,0x33,
    0x36,0x37,0x34,0x33,0x31,0x36,0x34,0x30,0x36,0x32,0x35,0x66,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,
    0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x2c,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x38,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x33,0x39,0x38,0x20,0x3d,
    0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x34,0x35,0x2e,0x30,
    0x66,0x2c,0x20,0x2d,0x31,0x35,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,0x30,0x30,0x20,0x3d,0x20,0x5f,0x33,0x39,
    0x38,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,
    0x34,0x31,0x35,0x20,0x3d,0x20,0x73,0x69,0x6e,0x28,0x5f,0x34,0x30,0x38,0x5f,0x69,
    0x54,0x69,0x6d,0x65,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x33,0x39,0x38,0x2e,
    0x79,0x20,0x3d,0x20,0x6d,0x61,0x64,0x28,0x28,0x5f,0x34,0x30,0x30,0x20,0x2a,0x20,
    0x5f,0x34,0x30,0x30,0x29,0x20,0x2a,0x20,0x30,0x2e,0x30,0x30,0x33,0x30,0x30,0x30,
    0x30,0x30,0x30,0x30,0x32,0x36,0x30,0x37,0x37,0x30,0x33,0x32,0x30,0x38,0x39,0x32,
    0x33,0x33,0x33,0x39,0x38,0x34,0x33,0x37,0x35,0x66,0x2c,0x20,0x5f,0x34,0x31,0x35,
    0x2c,0x20,0x5f,0x33,0x39,0x38,0x2e,0x79,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,
    0x20,0x3d,0x20,0x5f,0x33,0x39,0x38,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x20,0x3d,0x20,0x5f,
    0x33,0x39,0x38,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x20,0x3d,0x20,0x30,0x2e,0x30,0x66,0x2e,
    0x78,0x78,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x32,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x28,0x34,0x35,0x2e,0x30,0x66,0x2c,0x20,0x30,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x64,0x2c,0x20,0x73,0x64,
    0x5f,0x6c,0x69,0x6e,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x2c,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x31,0x32,0x29,0x20,0x2d,0x20,0x30,0x2e,0x32,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
    0x32,0x39,0x38,0x30,0x32,0x33,0x32,0x32,0x33,0x38,0x37,0x36,0x39,0x35,0x33,0x31,
    0x32,0x35,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x5f,0x39,0x32,0x32,0x20,0x3d,0x20,0x71,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,
    0x39,0x32,0x32,0x2e,0x79,0x20,0x3d,0x20,0x6d,0x61,0x64,0x28,0x28,0x5f,0x39,0x32,
    0x32,0x2e,0x78,0x20,0x2a,0x20,0x5f,0x39,0x32,0x32,0x2e,0x78,0x29,0x20,0x2a,0x20,
    0x30,0x2e,0x30,0x30,0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x36,0x30,0x37,
    0x37,0x30,0x33,0x32,0x30,0x38,0x39,0x32,0x33,0x33,0x33,0x39,0x38,0x34,0x33,0x37,
    0x35,0x66,0x2c,0x20,0x73,0x69,0x6e,0x28,0x5f,0x34,0x30,0x38,0x5f,0x69,0x54,0x69,
    0x6d,0x65,0x20,0x2a,0x20,0x32,0x2e,0x30,0x66,0x29,0x2c,0x20,0x5f,0x39,0x32,0x32,
    0x2e,0x79,0x20,0x2b,0x20,0x36,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x71,0x20,0x3d,0x20,0x5f,0x39,0x32,0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x33,0x20,0x3d,0x20,
    0x5f,0x39,0x32,0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x34,0x20,0x3d,0x20,0x30,0x2e,0x30,0x66,
    0x2e,0x78,0x78,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x35,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x28,0x34,0x35,0x2e,0x30,0x66,0x2c,0x20,0x30,0x2e,0x30,0x66,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x64,0x2c,0x20,0x73,
    0x64,0x5f,0x6c,0x69,0x6e,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x33,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x31,0x35,0x29,0x20,0x2d,0x20,0x30,0x2e,0x32,0x30,0x30,0x30,0x30,0x30,0x30,
    0x30,0x32,0x39,0x38,0x30,0x32,0x33,0x32,0x32,0x33,0x38,0x37,0x36,0x39,0x35,0x33,
    0x31,0x32,0x35,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x20,0x5f,0x34,0x36,0x36,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x20,0x2d,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x33,0x32,0x2e,0x30,0x66,0x2c,0x20,0x33,0x30,
    0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x34,
    0x36,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x36,0x20,0x3d,0x20,0x5f,0x34,0x36,0x36,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x31,0x37,0x20,0x3d,0x20,0x6d,0x61,0x64,0x28,0x5f,0x34,0x31,0x35,0x2c,0x20,0x30,
    0x2e,0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,0x38,
    0x39,0x35,0x35,0x30,0x37,0x38,0x31,0x32,0x35,0x66,0x2c,0x20,0x30,0x2e,0x36,0x39,
    0x39,0x39,0x39,0x39,0x39,0x38,0x38,0x30,0x37,0x39,0x30,0x37,0x31,0x30,0x34,0x34,
    0x39,0x32,0x31,0x38,0x37,0x35,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x5f,0x34,0x37,0x36,0x20,0x3d,0x20,0x72,0x6f,0x74,0x61,
    0x74,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x36,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x37,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,
    0x5f,0x34,0x37,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x38,0x20,0x3d,0x20,0x5f,0x34,0x37,0x36,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x31,0x39,0x20,0x3d,0x20,0x33,0x30,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x30,
    0x20,0x3d,0x20,0x31,0x35,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x5f,0x34,0x38,0x32,0x20,0x3d,0x20,0x73,0x64,0x5f,0x76,0x65,
    0x73,0x69,0x63,0x61,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x38,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x39,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,
    0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,
    0x38,0x33,0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x5f,0x34,0x38,0x35,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x5f,0x34,0x38,
    0x33,0x2c,0x20,0x5f,0x34,0x38,0x32,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,
    0x3d,0x20,0x5f,0x34,0x38,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x31,0x20,0x3d,0x20,0x30,0x2e,
    0x31,0x31,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x33,0x31,0x37,0x37,0x39,0x30,0x39,
    0x38,0x35,0x31,0x30,0x37,0x34,0x32,0x31,0x38,0x37,0x35,0x66,0x2e,0x78,0x78,0x78,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x32,0x32,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x33,
    0x20,0x3d,0x20,0x5f,0x34,0x38,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,
    0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x32,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x32,0x2c,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x32,0x33,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,
    0x20,0x5f,0x33,0x35,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x34,0x20,0x3d,0x20,0x5f,0x33,0x35,
    0x36,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,0x30,0x66,0x2c,
    0x20,0x2d,0x36,0x30,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x35,0x20,0x3d,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x32,0x37,0x2e,0x30,0x66,0x2c,0x20,0x32,0x30,
    0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x36,0x20,0x3d,0x20,0x32,0x2e,0x30,0x66,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,
    0x70,0x73,0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x34,0x2c,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x35,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x32,0x36,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x37,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,0x30,0x66,0x2c,0x20,0x2d,0x37,0x30,0x2e,
    0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x38,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x28,0x32,0x30,0x2e,0x30,0x66,0x2c,0x20,0x31,0x36,0x2e,0x30,0x66,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x32,0x39,0x20,0x3d,0x20,0x32,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x64,0x20,0x3d,0x20,0x6d,0x61,0x78,0x28,0x2d,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,
    0x70,0x73,0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x37,0x2c,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x38,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x32,0x39,0x29,0x2c,0x20,0x64,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x20,0x5f,0x35,0x32,0x32,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x20,
    0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x36,0x2e,0x30,0x66,0x2c,0x20,0x2d,
    0x35,0x30,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,
    0x5f,0x35,0x32,0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x30,0x20,0x3d,0x20,0x5f,0x35,0x32,0x32,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x33,0x31,0x20,0x3d,0x20,0x6d,0x61,0x64,0x28,0x30,0x2e,0x35,0x66,0x2c,
    0x20,0x5f,0x34,0x31,0x35,0x2c,0x20,0x30,0x2e,0x35,0x66,0x29,0x20,0x2a,0x20,0x28,
    0x2d,0x30,0x2e,0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x39,0x30,0x31,
    0x31,0x36,0x31,0x31,0x39,0x33,0x38,0x34,0x37,0x36,0x35,0x36,0x32,0x35,0x66,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x35,0x33,
    0x34,0x20,0x3d,0x20,0x72,0x6f,0x74,0x61,0x74,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x33,0x30,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x31,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x5f,0x35,0x33,0x34,0x2e,0x78,0x20,0x3d,0x20,0x6d,0x61,0x64,
    0x28,0x2d,0x70,0x6f,0x77,0x28,0x6d,0x61,0x78,0x28,0x28,0x2d,0x34,0x35,0x2e,0x30,
    0x66,0x29,0x20,0x2d,0x20,0x5f,0x35,0x33,0x34,0x2e,0x79,0x2c,0x20,0x30,0x2e,0x30,
    0x66,0x29,0x2c,0x20,0x31,0x2e,0x38,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,0x31,
    0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x66,0x29,0x2c,
    0x20,0x30,0x2e,0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x39,0x30,0x31,
    0x31,0x36,0x31,0x31,0x39,0x33,0x38,0x34,0x37,0x36,0x35,0x36,0x32,0x35,0x66,0x2c,
    0x20,0x5f,0x35,0x33,0x34,0x2e,0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,
    0x3d,0x20,0x5f,0x35,0x33,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x32,0x20,0x3d,0x20,0x5f,0x35,
    0x33,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x33,0x33,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x28,0x30,0x2e,0x30,0x66,0x2c,0x20,0x2d,0x35,0x30,0x2e,0x30,0x66,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x33,0x34,0x20,0x3d,0x20,0x30,0x2e,0x30,0x66,0x2e,0x78,0x78,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,
    0x35,0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x36,0x20,0x3d,0x20,0x73,0x64,0x5f,0x6c,
    0x69,0x6e,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x32,0x2c,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x33,0x33,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x34,
    0x29,0x20,0x2d,0x20,0x35,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x37,0x20,0x3d,0x20,0x31,
    0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x6d,0x69,
    0x6e,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x35,0x2c,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x33,0x36,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x37,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x35,0x36,0x34,
    0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x28,0x32,0x32,0x2e,0x30,0x66,0x2c,0x20,0x2d,0x36,0x30,0x2e,0x30,0x66,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x35,0x36,0x34,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x33,0x38,0x20,0x3d,0x20,0x5f,0x35,0x36,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x39,0x20,0x3d,0x20,
    0x6d,0x61,0x64,0x28,0x30,0x2e,0x35,0x66,0x2c,0x20,0x63,0x6f,0x73,0x28,0x5f,0x34,
    0x30,0x38,0x5f,0x69,0x54,0x69,0x6d,0x65,0x29,0x2c,0x20,0x30,0x2e,0x35,0x66,0x29,
    0x20,0x2a,0x20,0x28,0x2d,0x30,0x2e,0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x31,
    0x34,0x39,0x30,0x31,0x31,0x36,0x31,0x31,0x39,0x33,0x38,0x34,0x37,0x36,0x35,0x36,
    0x32,0x35,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x5f,0x35,0x37,0x35,0x20,0x3d,0x20,0x72,0x6f,0x74,0x61,0x74,0x65,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x33,0x38,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,
    0x39,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x35,0x37,0x35,0x2e,0x78,0x20,0x3d,
    0x20,0x6d,0x61,0x64,0x28,0x2d,0x70,0x6f,0x77,0x28,0x6d,0x61,0x78,0x28,0x28,0x2d,
    0x32,0x39,0x2e,0x30,0x66,0x29,0x20,0x2d,0x20,0x5f,0x35,0x37,0x35,0x2e,0x79,0x2c,
    0x20,0x30,0x2e,0x30,0x66,0x29,0x2c,0x20,0x31,0x2e,0x38,0x39,0x39,0x39,0x39,0x39,
    0x39,0x37,0x36,0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,0x37,
    0x35,0x66,0x29,0x2c,0x20,0x30,0x2e,0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x31,
    0x34,0x39,0x30,0x31,0x31,0x36,0x31,0x31,0x39,0x33,0x38,0x34,0x37,0x36,0x35,0x36,
    0x32,0x35,0x66,0x2c,0x20,0x5f,0x35,0x37,0x35,0x2e,0x78,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x35,0x37,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x30,0x20,
    0x3d,0x20,0x5f,0x35,0x37,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x31,0x20,0x3d,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,0x30,0x66,0x2c,0x20,0x2d,0x33,0x35,0x2e,0x30,
    0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x34,0x32,0x20,0x3d,0x20,0x30,0x2e,0x30,0x66,0x2e,0x78,
    0x78,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x34,0x33,0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x34,0x20,0x3d,0x20,
    0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x30,
    0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x34,0x32,0x29,0x20,0x2d,0x20,0x35,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x35,
    0x20,0x3d,0x20,0x31,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,
    0x20,0x73,0x6d,0x69,0x6e,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x33,0x2c,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x34,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x5f,0x36,0x30,0x34,0x20,0x3d,0x20,0x70,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x28,0x2d,0x32,0x36,0x2e,0x30,0x66,0x2c,0x20,0x2d,0x36,0x30,0x2e,0x30,0x66,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x36,0x30,0x34,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x34,0x36,0x20,0x3d,0x20,0x5f,0x36,0x30,0x34,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x37,0x20,
    0x3d,0x20,0x32,0x2e,0x31,0x39,0x39,0x31,0x31,0x34,0x37,0x39,0x39,0x34,0x39,0x39,
    0x35,0x31,0x31,0x37,0x31,0x38,0x37,0x35,0x66,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x36,0x30,0x39,0x20,0x3d,0x20,0x72,0x6f,0x74,
    0x61,0x74,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x36,0x2c,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x34,0x37,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x5f,0x36,0x31,0x31,0x20,0x3d,0x20,0x5f,0x36,0x30,0x39,0x2e,0x79,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x36,0x30,0x39,0x2e,0x78,0x20,0x3d,0x20,0x5f,
    0x36,0x30,0x39,0x2e,0x78,0x20,0x2d,0x20,0x6d,0x61,0x64,0x28,0x73,0x69,0x6e,0x28,
    0x6d,0x61,0x64,0x28,0x5f,0x36,0x31,0x31,0x2c,0x20,0x30,0x2e,0x31,0x32,0x33,0x30,
    0x30,0x30,0x30,0x30,0x33,0x33,0x39,0x37,0x34,0x36,0x34,0x37,0x35,0x32,0x31,0x39,
    0x37,0x32,0x36,0x35,0x36,0x32,0x35,0x66,0x2c,0x20,0x33,0x2e,0x30,0x66,0x29,0x29,
    0x2c,0x20,0x34,0x2e,0x30,0x66,0x2c,0x20,0x73,0x69,0x6e,0x28,0x6d,0x61,0x64,0x28,
    0x5f,0x36,0x31,0x31,0x2c,0x20,0x30,0x2e,0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
    0x31,0x34,0x39,0x30,0x31,0x31,0x36,0x31,0x31,0x39,0x33,0x38,0x34,0x37,0x36,0x35,
    0x36,0x32,0x35,0x66,0x2c,0x20,0x5f,0x34,0x30,0x38,0x5f,0x69,0x54,0x69,0x6d,0x65,
    0x20,0x2a,0x20,0x31,0x30,0x2e,0x30,0x66,0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x71,0x20,0x3d,0x20,0x5f,0x36,0x30,0x39,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x38,0x20,0x3d,
    0x20,0x5f,0x36,0x30,0x39,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x39,0x20,0x3d,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x28,0x30,0x2e,0x30,0x66,0x2c,0x20,0x2d,0x34,0x30,0x2e,0x30,0x66,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x35,0x30,0x20,0x3d,0x20,0x30,0x2e,0x30,0x66,0x2e,0x78,0x78,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x35,0x31,0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x32,0x20,0x3d,0x20,0x6d,
    0x61,0x64,0x28,0x2d,0x35,0x2e,0x30,0x66,0x2c,0x20,0x73,0x6d,0x6f,0x6f,0x74,0x68,
    0x73,0x74,0x65,0x70,0x28,0x2d,0x36,0x30,0x2e,0x30,0x66,0x2c,0x20,0x30,0x2e,0x30,
    0x66,0x2c,0x20,0x71,0x2e,0x79,0x29,0x2c,0x20,0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,
    0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x38,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x34,0x39,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x30,0x29,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x35,0x33,0x20,0x3d,0x20,0x31,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x35,0x30,0x20,0x3d,0x20,0x73,0x6d,0x69,
    0x6e,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x35,0x32,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x33,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x36,0x35,0x30,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x35,0x34,0x20,0x3d,0x20,0x30,0x2e,0x31,0x31,0x39,0x39,0x39,0x39,0x39,0x39,0x37,
    0x33,0x31,0x37,0x37,0x39,0x30,0x39,0x38,0x35,0x31,0x30,0x37,0x34,0x32,0x31,0x38,
    0x37,0x35,0x66,0x2e,0x78,0x78,0x78,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x35,0x20,0x3d,0x20,0x6f,
    0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x35,0x36,0x20,0x3d,0x20,0x5f,0x36,0x35,0x30,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,
    0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x35,0x35,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x36,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x35,0x37,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x28,0x2d,0x32,0x2e,0x30,0x66,0x2c,0x20,0x2d,0x34,0x2e,0x30,0x66,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x35,0x38,0x20,0x3d,0x20,0x31,0x2e,0x32,0x39,0x39,0x39,0x39,0x39,0x39,0x35,0x32,
    0x33,0x31,0x36,0x32,0x38,0x34,0x31,0x37,0x39,0x36,0x38,0x37,0x35,0x66,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x36,0x35,0x20,0x3d,
    0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x35,0x37,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x38,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x36,0x36,0x35,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,
    0x39,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x2d,
    0x32,0x2e,0x30,0x66,0x2c,0x20,0x2d,0x39,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x30,
    0x20,0x3d,0x20,0x31,0x2e,0x32,0x30,0x30,0x30,0x30,0x30,0x30,0x34,0x37,0x36,0x38,
    0x33,0x37,0x31,0x35,0x38,0x32,0x30,0x33,0x31,0x32,0x35,0x66,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x37,0x35,0x20,0x3d,0x20,0x6d,
    0x69,0x6e,0x28,0x5f,0x36,0x36,0x35,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,
    0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x39,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x36,0x30,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,
    0x20,0x5f,0x36,0x37,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x31,0x20,0x3d,0x20,0x71,0x20,0x2d,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x2d,0x32,0x2e,0x30,0x66,0x2c,0x20,0x2d,
    0x31,0x35,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x32,0x20,0x3d,0x20,0x31,0x2e,0x31,
    0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x33,0x38,0x34,0x31,0x38,0x35,0x37,0x39,0x31,
    0x30,0x31,0x35,0x36,0x32,0x35,0x66,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x5f,0x36,0x38,0x34,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x5f,0x36,
    0x37,0x35,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x36,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x32,
    0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x36,0x38,0x34,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x36,0x33,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x28,0x2d,0x32,0x2e,0x30,0x66,0x2c,0x20,0x2d,0x32,0x30,0x2e,0x30,0x66,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x36,0x34,0x20,0x3d,0x20,0x31,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x39,0x33,0x20,0x3d,0x20,0x6d,
    0x69,0x6e,0x28,0x5f,0x36,0x38,0x34,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,
    0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x33,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x36,0x34,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,
    0x20,0x5f,0x36,0x39,0x33,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x35,0x20,0x3d,0x20,0x71,0x20,0x2d,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x2d,0x31,0x2e,0x36,0x30,0x30,0x30,0x30,
    0x30,0x30,0x32,0x33,0x38,0x34,0x31,0x38,0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,
    0x32,0x35,0x66,0x2c,0x20,0x2d,0x32,0x35,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x36,
    0x20,0x3d,0x20,0x30,0x2e,0x38,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,0x31,0x35,
    0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x66,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x37,0x30,0x34,0x20,0x3d,0x20,
    0x6d,0x69,0x6e,0x28,0x5f,0x36,0x39,0x33,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,
    0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x35,0x2c,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x36,0x36,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,
    0x3d,0x20,0x5f,0x37,0x30,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x37,0x20,0x3d,0x20,0x71,0x20,
    0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x2d,0x31,0x2e,0x32,0x39,0x39,0x39,
    0x39,0x39,0x39,0x35,0x32,0x33,0x31,0x36,0x32,0x38,0x34,0x31,0x37,0x39,0x36,0x38,
    0x37,0x35,0x66,0x2c,0x20,0x2d,0x32,0x39,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x38,
    0x20,0x3d,0x20,0x30,0x2e,0x38,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,
    0x30,0x39,0x32,0x38,0x39,0x35,0x35,0x30,0x37,0x38,0x31,0x32,0x35,0x66,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x37,0x31,0x34,0x20,0x3d,
    0x20,0x6d,0x69,0x6e,0x28,0x5f,0x37,0x30,0x34,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,
    0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x37,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x36,0x38,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,
    0x20,0x3d,0x20,0x5f,0x37,0x31,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x39,0x20,0x3d,0x20,0x71,
    0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x2d,0x30,0x2e,0x38,0x39,0x39,
    0x39,0x39,0x39,0x39,0x37,0x36,0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,
    0x34,0x33,0x37,0x35,0x66,0x2c,0x20,0x2d,0x33,0x33,0x2e,0x30,0x66,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x37,0x30,0x20,0x3d,0x20,0x30,0x2e,0x36,0x39,0x39,0x39,0x39,0x39,0x39,0x38,0x38,
    0x30,0x37,0x39,0x30,0x37,0x31,0x30,0x34,0x34,0x39,0x32,0x31,0x38,0x37,0x35,0x66,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x37,0x32,0x34,
    0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x5f,0x37,0x31,0x34,0x2c,0x20,0x73,0x64,0x5f,
    0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x39,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x30,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x64,0x20,0x3d,0x20,0x5f,0x37,0x32,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x31,0x20,0x3d,
    0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x2d,0x30,0x2e,0x38,
    0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,0x38,0x39,0x35,
    0x35,0x30,0x37,0x38,0x31,0x32,0x35,0x66,0x2c,0x20,0x2d,0x33,0x37,0x2e,0x30,0x66,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x37,0x32,0x20,0x3d,0x20,0x30,0x2e,0x36,0x30,0x30,0x30,0x30,0x30,
    0x30,0x32,0x33,0x38,0x34,0x31,0x38,0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,0x32,
    0x35,0x66,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x37,
    0x33,0x35,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x5f,0x37,0x32,0x34,0x2c,0x20,0x73,
    0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,
    0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x32,0x29,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x37,0x33,0x35,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x33,
    0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x28,0x30,0x2e,0x36,0x31,0x30,0x30,
    0x30,0x30,0x30,0x31,0x34,0x33,0x30,0x35,0x31,0x31,0x34,0x37,0x34,0x36,0x30,0x39,
    0x33,0x37,0x35,0x66,0x2c,0x20,0x30,0x2e,0x38,0x35,0x30,0x30,0x30,0x30,0x30,0x32,
    0x33,0x38,0x34,0x31,0x38,0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,0x32,0x35,0x66,
    0x2c,0x20,0x30,0x2e,0x39,0x33,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,0x31,0x35,
    0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x66,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x37,0x34,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x35,0x20,0x3d,
    0x20,0x5f,0x37,0x33,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,
    0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x33,
    0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x20,0x5f,0x39,0x34,0x36,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x5f,0x39,0x34,0x36,0x2e,0x79,0x20,0x3d,0x20,0x70,0x2e,0x79,0x20,
    0x2d,0x20,0x28,0x2d,0x31,0x31,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x71,0x20,0x3d,0x20,0x5f,0x39,0x34,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x36,0x20,0x3d,0x20,
    0x5f,0x39,0x34,0x36,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,
    0x30,0x66,0x2c,0x20,0x2d,0x35,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x37,0x20,
    0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x34,0x30,0x2e,0x30,0x66,0x2c,0x20,
    0x32,0x30,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x38,0x20,0x3d,0x20,0x32,0x2e,0x39,
    0x30,0x30,0x30,0x30,0x30,0x30,0x39,0x35,0x33,0x36,0x37,0x34,0x33,0x31,0x36,0x34,
    0x30,0x36,0x32,0x35,0x66,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x73,
    0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x37,0x36,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x37,0x2c,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x38,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x39,0x20,0x3d,
    0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x32,0x31,0x2e,0x30,
    0x66,0x2c,0x20,0x30,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x30,0x20,0x3d,0x20,0x32,
    0x30,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x31,0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x32,
    0x20,0x3d,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x37,0x39,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x30,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x38,0x33,0x20,0x3d,0x20,0x35,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x37,0x37,0x30,0x20,0x3d,0x20,0x73,0x6d,
    0x69,0x6e,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x31,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x38,0x32,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x33,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x37,0x37,0x30,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x38,0x34,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x28,0x30,0x2e,0x39,
    0x38,0x30,0x30,0x30,0x30,0x30,0x31,0x39,0x30,0x37,0x33,0x34,0x38,0x36,0x33,0x32,
    0x38,0x31,0x32,0x35,0x66,0x2c,0x20,0x30,0x2e,0x37,0x39,0x30,0x30,0x30,0x30,0x30,
    0x32,0x31,0x34,0x35,0x37,0x36,0x37,0x32,0x31,0x31,0x39,0x31,0x34,0x30,0x36,0x32,
    0x35,0x66,0x2c,0x20,0x30,0x2e,0x36,0x38,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,
    0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x66,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x38,0x35,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x36,
    0x20,0x3d,0x20,0x5f,0x37,0x37,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,
    0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x38,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x35,0x2c,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x38,0x36,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x37,0x20,0x3d,0x20,0x71,
    0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,0x30,0x66,0x2c,0x20,
    0x6d,0x61,0x64,0x28,0x5f,0x34,0x31,0x35,0x2c,0x20,0x30,0x2e,0x35,0x66,0x2c,0x20,
    0x2d,0x31,0x32,0x2e,0x30,0x66,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x38,0x20,0x3d,0x20,0x32,
    0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x64,0x5f,
    0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x37,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x38,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x39,0x20,
    0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,0x30,
    0x66,0x2c,0x20,0x2d,0x31,0x38,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x30,0x20,0x3d,
    0x20,0x6d,0x61,0x64,0x28,0x5f,0x34,0x31,0x35,0x2c,0x20,0x30,0x2e,0x33,0x30,0x30,
    0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,0x38,0x39,0x35,0x35,0x30,
    0x37,0x38,0x31,0x32,0x35,0x66,0x2c,0x20,0x33,0x2e,0x31,0x34,0x31,0x35,0x39,0x32,
    0x37,0x34,0x31,0x30,0x31,0x32,0x35,0x37,0x33,0x32,0x34,0x32,0x31,0x38,0x37,0x35,
    0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x39,0x31,0x20,0x3d,0x20,0x30,0x2e,0x33,0x30,0x30,0x30,0x30,
    0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,0x38,0x39,0x35,0x35,0x30,0x37,0x38,
    0x31,0x32,0x35,0x66,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x32,0x20,0x3d,0x20,0x34,0x2e,0x30,0x66,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x39,0x33,0x20,0x3d,0x20,0x30,0x2e,0x34,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
    0x35,0x39,0x36,0x30,0x34,0x36,0x34,0x34,0x37,0x37,0x35,0x33,0x39,0x30,0x36,0x32,
    0x35,0x66,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x38,
    0x30,0x39,0x20,0x3d,0x20,0x73,0x64,0x5f,0x61,0x72,0x63,0x28,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x38,0x39,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x30,0x2c,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x39,0x32,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x33,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x38,0x31,0x30,0x20,0x3d,0x20,
    0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x38,0x31,
    0x32,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x5f,0x38,0x31,0x30,0x2c,0x20,0x5f,0x38,
    0x30,0x39,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x38,0x31,
    0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x39,0x34,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x28,
    0x30,0x2e,0x36,0x37,0x30,0x30,0x30,0x30,0x30,0x31,0x36,0x36,0x38,0x39,0x33,0x30,
    0x30,0x35,0x33,0x37,0x31,0x30,0x39,0x33,0x37,0x35,0x66,0x2c,0x20,0x30,0x2e,0x33,
    0x36,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x33,0x30,0x35,0x31,0x31,0x34,0x37,0x34,
    0x36,0x30,0x39,0x33,0x37,0x35,0x66,0x2c,0x20,0x30,0x2e,0x33,0x31,0x39,0x39,0x39,
    0x39,0x39,0x39,0x32,0x38,0x34,0x37,0x34,0x34,0x32,0x36,0x32,0x36,0x39,0x35,0x33,
    0x31,0x32,0x35,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x35,0x20,0x3d,0x20,0x6f,0x63,0x6f,
    0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x39,0x36,0x20,0x3d,0x20,0x5f,0x38,0x31,0x32,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x39,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,
    0x35,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x36,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x39,0x35,0x32,0x20,0x3d,0x20,
    0x5f,0x33,0x35,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x39,0x35,0x32,0x2e,0x79,
    0x20,0x3d,0x20,0x28,0x70,0x2e,0x79,0x20,0x2d,0x20,0x28,0x2d,0x31,0x32,0x2e,0x30,
    0x66,0x29,0x29,0x20,0x2f,0x20,0x28,0x31,0x2e,0x30,0x66,0x20,0x2d,0x20,0x73,0x6d,
    0x6f,0x6f,0x74,0x68,0x73,0x74,0x65,0x70,0x28,0x30,0x2e,0x39,0x38,0x30,0x30,0x30,
    0x30,0x30,0x31,0x39,0x30,0x37,0x33,0x34,0x38,0x36,0x33,0x32,0x38,0x31,0x32,0x35,
    0x66,0x2c,0x20,0x31,0x2e,0x30,0x66,0x2c,0x20,0x73,0x69,0x6e,0x28,0x5f,0x34,0x30,
    0x38,0x5f,0x69,0x54,0x69,0x6d,0x65,0x20,0x2a,0x20,0x33,0x2e,0x30,0x66,0x29,0x29,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x39,0x35,0x32,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x39,0x37,0x20,0x3d,0x20,0x5f,0x39,0x35,0x32,0x20,0x2d,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x28,0x32,0x30,0x2e,0x30,0x66,0x2c,0x20,0x30,0x2e,0x30,0x66,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x39,0x38,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,
    0x39,0x2e,0x30,0x66,0x2c,0x20,0x31,0x32,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x39,
    0x20,0x3d,0x20,0x32,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x5f,0x38,0x34,0x37,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,
    0x69,0x70,0x73,0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x37,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x38,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x39,0x39,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x38,
    0x34,0x37,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x30,0x20,0x3d,0x20,0x31,0x2e,0x30,0x66,0x2e,
    0x78,0x78,0x78,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x31,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x31,0x30,0x32,0x20,0x3d,0x20,0x5f,0x38,0x34,0x37,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x30,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x31,0x30,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x32,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x31,0x30,0x33,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x28,0x31,0x39,0x2e,0x35,0x66,0x2c,0x20,0x30,0x2e,0x30,0x66,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x31,0x30,0x34,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x35,
    0x2e,0x30,0x66,0x2c,0x20,0x38,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x35,0x20,
    0x3d,0x20,0x32,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x5f,0x38,0x36,0x34,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,
    0x70,0x73,0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x33,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x31,0x30,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,
    0x5f,0x38,0x36,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x36,0x20,0x3d,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x33,0x28,0x30,0x2e,0x36,0x37,0x30,0x30,0x30,0x30,0x30,0x31,0x36,0x36,
    0x38,0x39,0x33,0x30,0x30,0x35,0x33,0x37,0x31,0x30,0x39,0x33,0x37,0x35,0x66,0x2c,
    0x20,0x30,0x2e,0x33,0x36,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x33,0x30,0x35,0x31,
    0x31,0x34,0x37,0x34,0x36,0x30,0x39,0x33,0x37,0x35,0x66,0x2c,0x20,0x30,0x2e,0x33,
    0x31,0x39,0x39,0x39,0x39,0x39,0x39,0x32,0x38,0x34,0x37,0x34,0x34,0x32,0x36,0x32,
    0x36,0x39,0x35,0x33,0x31,0x32,0x35,0x66,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x37,0x20,
    0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x38,0x20,0x3d,0x20,0x5f,0x38,
    0x36,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,
    0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x36,0x2c,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x37,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x31,0x30,0x38,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x20,0x5f,0x38,0x37,0x33,0x20,0x3d,0x20,0x70,0x20,0x2d,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x28,0x2d,0x32,0x2e,0x30,0x66,0x2c,0x20,0x30,0x2e,0x30,0x66,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x38,0x37,0x33,0x2e,0x78,0x20,0x3d,0x20,0x61,
    0x62,0x73,0x28,0x5f,0x38,0x37,0x33,0x2e,0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x71,0x20,0x3d,0x20,0x5f,0x38,0x37,0x33,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x39,0x20,0x3d,
    0x20,0x5f,0x38,0x37,0x33,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x31,
    0x39,0x2e,0x35,0x66,0x2c,0x20,0x2d,0x38,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,
    0x30,0x20,0x3d,0x20,0x31,0x2e,0x32,0x39,0x39,0x39,0x39,0x39,0x39,0x35,0x32,0x33,
    0x31,0x36,0x32,0x38,0x34,0x31,0x37,0x39,0x36,0x38,0x37,0x35,0x66,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x38,0x38,0x34,0x20,0x3d,0x20,
    0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x31,0x30,0x39,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x30,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x38,0x38,0x34,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x31,0x31,0x31,0x20,0x3d,0x20,0x31,0x2e,0x30,0x66,0x2e,0x78,0x78,0x78,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x31,0x31,0x32,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x33,
    0x20,0x3d,0x20,0x5f,0x38,0x38,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x33,0x20,0x5f,0x38,0x39,0x30,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,
    0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x31,0x31,0x32,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x33,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x5f,0x38,
    0x39,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x5f,
    0x38,0x39,0x30,0x3b,0x0a,0x7d,0x0a,0x0a,0x76,0x6f,0x69,0x64,0x20,0x66,0x72,0x61,
    0x67,0x5f,0x6d,0x61,0x69,0x6e,0x28,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x20,0x3d,0x20,0x66,0x72,
    0x61,0x67,0x50,0x6f,0x73,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x33,0x20,0x5f,0x38,0x39,0x39,0x20,0x3d,0x20,0x6d,0x61,0x70,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,
    0x6f,0x72,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x28,0x5f,0x38,0x39,0x39,
    0x2c,0x20,0x31,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x53,0x50,0x49,0x52,
    0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x4f,0x75,0x74,0x70,0x75,0x74,0x20,0x6d,
    0x61,0x69,0x6e,0x28,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,
    0x49,0x6e,0x70,0x75,0x74,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,0x70,0x75,
    0x74,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x72,0x61,0x67,0x50,0x6f,0x73,
    0x20,0x3d,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,0x70,0x75,0x74,0x2e,0x66,
    0x72,0x61,0x67,0x50,0x6f,0x73,0x3b,0x0a,0x20,0x20,0x20,0x20,0x74,0x65,0x78,0x55,
    0x56,0x20,0x3d,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,0x70,0x75,0x74,0x2e,
    0x74,0x65,0x78,0x55,0x56,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x72,0x61,0x67,0x5f,
    0x6d,0x61,0x69,0x6e,0x28,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x53,0x50,0x49,0x52,
    0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x4f,0x75,0x74,0x70,0x75,0x74,0x20,0x73,
    0x74,0x61,0x67,0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,0x74,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,0x74,0x2e,0x66,0x72,
    0x61,0x67,0x43,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x66,0x72,0x61,0x67,0x43,0x6f,
    0x6c,0x6f,0x72,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,
    0x73,0x74,0x61,0x67,0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,0x74,0x3b,0x0a,0x7d,0x0a,
    0x00,
};
/*
    #include <metal_stdlib>
    #include <simd/simd.h>

    using namespace metal;

    struct vs_uniforms
    {
        float2 iResolution;
    };

    struct main0_out
    {
        float2 texUV [[user(locn0)]];
        float2 fragPos [[user(locn1)]];
        float4 gl_Position [[position]];
    };

    struct main0_in
    {
        float4 coord [[attribute(0)]];
    };

    vertex main0_out main0(main0_in in [[stage_in]], constant vs_uniforms& _36 [[buffer(0)]])
    {
        main0_out out = {};
        out.gl_Position = float4(in.coord.xy, 0.0, 1.0);
        out.fragPos = float2(in.coord.x * (_36.iResolution.x / _36.iResolution.y), in.coord.y);
        out.texUV = in.coord.zw;
        return out;
    }

*/
static const uint8_t sdf_vs_source_metal_macos[618] = {
    0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,
    0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,
    0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,
    0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,
    0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x76,
    0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x69,0x52,0x65,0x73,0x6f,0x6c,0x75,0x74,
    0x69,0x6f,0x6e,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,
    0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x74,0x65,0x78,0x55,0x56,0x20,0x5b,0x5b,0x75,
    0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x66,0x72,0x61,0x67,0x50,0x6f,0x73,
    0x20,0x5b,0x5b,0x75,0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x31,0x29,0x5d,0x5d,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x67,0x6c,0x5f,
    0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x5b,0x5b,0x70,0x6f,0x73,0x69,0x74,
    0x69,0x6f,0x6e,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,
    0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,0x6e,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x63,0x6f,0x6f,0x72,0x64,0x20,0x5b,0x5b,
    0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x28,0x30,0x29,0x5d,0x5d,0x3b,0x0a,
    0x7d,0x3b,0x0a,0x0a,0x76,0x65,0x72,0x74,0x65,0x78,0x20,0x6d,0x61,0x69,0x6e,0x30,
    0x5f,0x6f,0x75,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,0x69,0x6e,0x30,
    0x5f,0x69,0x6e,0x20,0x69,0x6e,0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,
    0x6e,0x5d,0x5d,0x2c,0x20,0x63,0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,0x20,0x76,0x73,
    0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x26,0x20,0x5f,0x33,0x36,0x20,0x5b,
    0x5b,0x62,0x75,0x66,0x66,0x65,0x72,0x28,0x30,0x29,0x5d,0x5d,0x29,0x0a,0x7b,0x0a,
    0x20,0x20,0x20,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6f,0x75,
    0x74,0x20,0x3d,0x20,0x7b,0x7d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,0x2e,
    0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x34,0x28,0x69,0x6e,0x2e,0x63,0x6f,0x6f,0x72,0x64,0x2e,0x78,0x79,
    0x2c,0x20,0x30,0x2e,0x30,0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x6f,0x75,0x74,0x2e,0x66,0x72,0x61,0x67,0x50,0x6f,0x73,0x20,0x3d,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x28,0x69,0x6e,0x2e,0x63,0x6f,0x6f,0x72,0x64,0x2e,0x78,
    0x20,0x2a,0x20,0x28,0x5f,0x33,0x36,0x2e,0x69,0x52,0x65,0x73,0x6f,0x6c,0x75,0x74,
    0x69,0x6f,0x6e,0x2e,0x78,0x20,0x2f,0x20,0x5f,0x33,0x36,0x2e,0x69,0x52,0x65,0x73,
    0x6f,0x6c,0x75,0x74,0x69,0x6f,0x6e,0x2e,0x79,0x29,0x2c,0x20,0x69,0x6e,0x2e,0x63,
    0x6f,0x6f,0x72,0x64,0x2e,0x79,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,
    0x2e,0x74,0x65,0x78,0x55,0x56,0x20,0x3d,0x20,0x69,0x6e,0x2e,0x63,0x6f,0x6f,0x72,
    0x64,0x2e,0x7a,0x77,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,
    0x20,0x6f,0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #pragma clang diagnostic ignored "-Wmissing-prototypes"

    #include <metal_stdlib>
    #include <simd/simd.h>

    using namespace metal;

    // Implementation of the GLSL mod() function, which is slightly different than Metal fmod()
    template<typename Tx, typename Ty>
    inline Tx mod(Tx x, Ty y)
    {
        return x - y * floor(x / y);
    }

    struct fs_uniforms
    {
        float iTime;
    };

    struct main0_out
    {
        float4 fragColor [[color(0)]];
    };

    struct main0_in
    {
        float2 fragPos [[user(locn1)]];
    };

    static inline __attribute__((always_inline))
    float3 background(thread const float2& uv)
    {
        float2 _315 = abs(floor(uv));
        return float3(0.38999998569488525390625) + (float3(0.17000000178813934326171875) * mod(_315.x + _315.y, 2.0));
    }

    static inline __attribute__((always_inline))
    float length_n(thread float2& p, thread const float& n)
    {
        p = pow(abs(p), float2(n));
        return pow(p.x + p.y, 1.0 / n);
    }

    static inline __attribute__((always_inline))
    float sd_ellipsoid(thread const float2& p, thread const float2& r, thread const float& roundness)
    {
        float2 param = p / r;
        float param_1 = roundness;
        float _103 = length_n(param, param_1);
        float2 param_2 = p / (r * r);
        float param_3 = roundness;
        float _113 = length_n(param_2, param_3);
        return (_103 * (_103 - 1.0)) / _113;
    }

    static inline __attribute__((always_inline))
    float3 blend(thread const float3& col, thread const float3& ocol, thread const float& d)
    {
        return mix(ocol, col, float3(smoothstep(0.5, 0.0, d)));
    }

    static inline __attribute__((always_inline))
    float sd_line(thread const float2& p, thread const float2& a, thread const float2& b)
    {
        float2 _240 = p - a;
        float2 _244 = b - a;
        return length(_240 - (_244 * fast::clamp(dot(_240, _244) / dot(_244, _244), 0.0, 1.0)));
    }

    static inline __attribute__((always_inline))
    float2 rotate(thread const float2& p, thread const float& theta)
    {
        float _264 = cos(theta);
        float _267 = sin(theta);
        return float2(fma(p.x, _264, -(p.y * _267)), fma(p.x, _267, p.y * _264));
    }

    static inline __attribute__((always_inline))
    float sd_vesica(thread float2& p, thread const float& r, thread const float& d)
    {
        p = abs(p);
        float _132 = sqrt(fma(r, r, -(d * d)));
        float _145;
        if (((p.y - _132) * d) > (p.x * _132))
        {
            _145 = length(p - float2(0.0, _132));
        }
        else
        {
            _145 = length(p - float2(-d, 0.0)) - r;
        }
        return _145;
    }

    static inline __attribute__((always_inline))
    float smin(thread const float& a, thread const float& b, thread const float& k)
    {
        float _298 = fast::max(k - abs(a - b), 0.0) / k;
        return fma(-((_298 * _298) * k), 0.25, fast::min(a, b));
    }

    static inline __attribute__((always_inline))
    float sd_circle(thread const float2& p, thread const float& r)
    {
        return length(p) - r;
    }

    static inline __attribute__((always_inline))
    float sd_arc(thread float2& p, thread const float& ta, thread const float& tb, thread const float& ra, thread const float& rb)
    {
        float _168 = cos(ta);
        float _170 = sin(ta);
        float _174 = cos(tb);
        float _176 = sin(tb);
        p *= float2x2(float2(_168, _170), float2(-_170, _168));
        p.x = abs(p.x);
        float _209;
        if ((_176 * p.x) > (_174 * p.y))
        {
            _209 = dot(p, float2(_174, _176));
        }
        else
        {
            _209 = length(p);
        }
        return sqrt(fma(ra * (-2.0), _209, fma(ra, ra, dot(p, p)))) - rb;
    }

    static inline __attribute__((always_inline))
    float3 map(thread float2& p, constant fs_uniforms& _408)
    {
        p *= 100.0;
        p.y -= 30.0;
        float2 _356 = float2(abs(p.x), p.y);
        float2 param = p * 0.300000011920928955078125;
        float3 ocol = background(param);
        float2 param_1 = p - float2(0.0, -97.0);
        float2 param_2 = float2(55.0, 20.0);
        float param_3 = 2.0;
        float _374 = sd_ellipsoid(param_1, param_2, param_3);
        float d = _374;
        float3 param_4 = float3(0.61000001430511474609375, 0.85000002384185791015625, 0.939999997615814208984375);
        float3 param_5 = ocol;
        float param_6 = _374;
        ocol = blend(param_4, param_5, param_6);
        float2 q = _356;
        float2 param_7 = _356;
        float2 param_8 = float2(55.0, 45.0);
        float param_9 = 2.400000095367431640625;
        d = sd_ellipsoid(param_7, param_8, param_9);
        float2 _398 = q - float2(45.0, -15.0);
        float _400 = _398.x;
        float _415 = sin(_408.iTime);
        _398.y = fma((_400 * _400) * 0.0030000000260770320892333984375, _415, _398.y);
        q = _398;
        float2 param_10 = _398;
        float2 param_11 = float2(0.0);
        float2 param_12 = float2(45.0, 0.0);
        d = fast::min(d, sd_line(param_10, param_11, param_12) - 0.20000000298023223876953125);
        float2 _922 = q;
        _922.y = fma((_922.x * _922.x) * 0.0030000000260770320892333984375, sin(_408.iTime * 2.0), _922.y + 6.0);
        q = _922;
        float2 param_13 = _922;
        float2 param_14 = float2(0.0);
        float2 param_15 = float2(45.0, 0.0);
        d = fast::min(d, sd_line(param_13, param_14, param_15) - 0.20000000298023223876953125);
        float2 _466 = _356 - float2(32.0, 30.0);
        q = _466;
        float2 param_16 = _466;
        float param_17 = fma(_415, 0.300000011920928955078125, 0.699999988079071044921875);
        float2 _476 = rotate(param_16, param_17);
        q = _476;
        float2 param_18 = _476;
        float param_19 = 30.0;
        float param_20 = 15.0;
        float _482 = sd_vesica(param_18, param_19, param_20);
        float _483 = d;
        float _485 = fast::min(_483, _482);
        d = _485;
        float3 param_21 = float3(0.119999997317790985107421875);
        float3 param_22 = ocol;
        float param_23 = _485;
        ocol = blend(param_21, param_22, param_23);
        q = _356;
        float2 param_24 = _356 - float2(0.0, -60.0);
        float2 param_25 = float2(27.0, 20.0);
        float param_26 = 2.0;
        d = sd_ellipsoid(param_24, param_25, param_26);
        float2 param_27 = q - float2(0.0, -70.0);
        float2 param_28 = float2(20.0, 16.0);
        float param_29 = 2.0;
        d = fast::max(-sd_ellipsoid(param_27, param_28, param_29), d);
        float2 _522 = _356 - float2(6.0, -50.0);
        q = _522;
        float2 param_30 = _522;
        float param_31 = fma(0.5, _415, 0.5) * (-0.100000001490116119384765625);
        float2 _534 = rotate(param_30, param_31);
        _534.x = fma(-pow(fast::max((-45.0) - _534.y, 0.0), 1.89999997615814208984375), 0.100000001490116119384765625, _534.x);
        q = _534;
        float2 param_32 = _534;
        float2 param_33 = float2(0.0, -50.0);
        float2 param_34 = float2(0.0);
        float param_35 = d;
        float param_36 = sd_line(param_32, param_33, param_34) - 5.0;
        float param_37 = 1.0;
        d = smin(param_35, param_36, param_37);
        float2 _564 = _356 - float2(22.0, -60.0);
        q = _564;
        float2 param_38 = _564;
        float param_39 = fma(0.5, cos(_408.iTime), 0.5) * (-0.100000001490116119384765625);
        float2 _575 = rotate(param_38, param_39);
        _575.x = fma(-pow(fast::max((-29.0) - _575.y, 0.0), 1.89999997615814208984375), 0.100000001490116119384765625, _575.x);
        q = _575;
        float2 param_40 = _575;
        float2 param_41 = float2(0.0, -35.0);
        float2 param_42 = float2(0.0);
        float param_43 = d;
        float param_44 = sd_line(param_40, param_41, param_42) - 5.0;
        float param_45 = 1.0;
        d = smin(param_43, param_44, param_45);
        float2 _604 = p - float2(-26.0, -60.0);
        q = _604;
        float2 param_46 = _604;
        float param_47 = 2.19911479949951171875;
        float2 _609 = rotate(param_46, param_47);
        float _611 = _609.y;
        _609.x = _609.x - fma(sin(fma(_611, 0.123000003397464752197265625, 3.0)), 4.0, sin(fma(_611, 0.100000001490116119384765625, _408.iTime * 10.0)));
        q = _609;
        float2 param_48 = _609;
        float2 param_49 = float2(0.0, -40.0);
        float2 param_50 = float2(0.0);
        float param_51 = d;
        float param_52 = fma(-5.0, smoothstep(-60.0, 0.0, q.y), sd_line(param_48, param_49, param_50));
        float param_53 = 1.0;
        float _650 = smin(param_51, param_52, param_53);
        d = _650;
        float3 param_54 = float3(0.119999997317790985107421875);
        float3 param_55 = ocol;
        float param_56 = _650;
        ocol = blend(param_54, param_55, param_56);
        float2 param_57 = q - float2(-2.0, -4.0);
        float param_58 = 1.2999999523162841796875;
        float _665 = sd_circle(param_57, param_58);
        d = _665;
        float2 param_59 = q - float2(-2.0, -9.0);
        float param_60 = 1.2000000476837158203125;
        float _675 = fast::min(_665, sd_circle(param_59, param_60));
        d = _675;
        float2 param_61 = q - float2(-2.0, -15.0);
        float param_62 = 1.10000002384185791015625;
        float _684 = fast::min(_675, sd_circle(param_61, param_62));
        d = _684;
        float2 param_63 = q - float2(-2.0, -20.0);
        float param_64 = 1.0;
        float _693 = fast::min(_684, sd_circle(param_63, param_64));
        d = _693;
        float2 param_65 = q - float2(-1.60000002384185791015625, -25.0);
        float param_66 = 0.89999997615814208984375;
        float _704 = fast::min(_693, sd_circle(param_65, param_66));
        d = _704;
        float2 param_67 = q - float2(-1.2999999523162841796875, -29.0);
        float param_68 = 0.800000011920928955078125;
        float _714 = fast::min(_704, sd_circle(param_67, param_68));
        d = _714;
        float2 param_69 = q - float2(-0.89999997615814208984375, -33.0);
        float param_70 = 0.699999988079071044921875;
        float _724 = fast::min(_714, sd_circle(param_69, param_70));
        d = _724;
        float2 param_71 = q - float2(-0.800000011920928955078125, -37.0);
        float param_72 = 0.60000002384185791015625;
        float _735 = fast::min(_724, sd_circle(param_71, param_72));
        d = _735;
        float3 param_73 = float3(0.61000001430511474609375, 0.85000002384185791015625, 0.939999997615814208984375);
        float3 param_74 = ocol;
        float param_75 = _735;
        ocol = blend(param_73, param_74, param_75);
        float2 _946 = _356;
        _946.y = p.y - (-11.0);
        q = _946;
        float2 param_76 = _946 - float2(0.0, -5.0);
        float2 param_77 = float2(40.0, 20.0);
        float param_78 = 2.900000095367431640625;
        d = sd_ellipsoid(param_76, param_77, param_78);
        float2 param_79 = q - float2(21.0, 0.0);
        float param_80 = 20.0;
        float param_81 = d;
        float param_82 = sd_circle(param_79, param_80);
        float param_83 = 5.0;
        float _770 = smin(param_81, param_82, param_83);
        d = _770;
        float3 param_84 = float3(0.980000019073486328125, 0.790000021457672119140625, 0.689999997615814208984375);
        float3 param_85 = ocol;
        float param_86 = _770;
        ocol = blend(param_84, param_85, param_86);
        float2 param_87 = q - float2(0.0, fma(_415, 0.5, -12.0));
        float param_88 = 2.0;
        d = sd_circle(param_87, param_88);
        float2 param_89 = q - float2(0.0, -18.0);
        float param_90 = fma(_415, 0.300000011920928955078125, 3.1415927410125732421875);
        float param_91 = 0.300000011920928955078125;
        float param_92 = 4.0;
        float param_93 = 0.4000000059604644775390625;
        float _809 = sd_arc(param_89, param_90, param_91, param_92, param_93);
        float _810 = d;
        float _812 = fast::min(_810, _809);
        d = _812;
        float3 param_94 = float3(0.670000016689300537109375, 0.36000001430511474609375, 0.319999992847442626953125);
        float3 param_95 = ocol;
        float param_96 = _812;
        ocol = blend(param_94, param_95, param_96);
        float2 _952 = _356;
        _952.y = (p.y - (-12.0)) / (1.0 - smoothstep(0.980000019073486328125, 1.0, sin(_408.iTime * 3.0)));
        q = _952;
        float2 param_97 = _952 - float2(20.0, 0.0);
        float2 param_98 = float2(9.0, 12.0);
        float param_99 = 2.0;
        float _847 = sd_ellipsoid(param_97, param_98, param_99);
        d = _847;
        float3 param_100 = float3(1.0);
        float3 param_101 = ocol;
        float param_102 = _847;
        ocol = blend(param_100, param_101, param_102);
        float2 param_103 = q - float2(19.5, 0.0);
        float2 param_104 = float2(5.0, 8.0);
        float param_105 = 2.0;
        float _864 = sd_ellipsoid(param_103, param_104, param_105);
        d = _864;
        float3 param_106 = float3(0.670000016689300537109375, 0.36000001430511474609375, 0.319999992847442626953125);
        float3 param_107 = ocol;
        float param_108 = _864;
        ocol = blend(param_106, param_107, param_108);
        float2 _873 = p - float2(-2.0, 0.0);
        _873.x = abs(_873.x);
        q = _873;
        float2 param_109 = _873 - float2(19.5, -8.0);
        float param_110 = 1.2999999523162841796875;
        float _884 = sd_circle(param_109, param_110);
        d = _884;
        float3 param_111 = float3(1.0);
        float3 param_112 = ocol;
        float param_113 = _884;
        float3 _890 = blend(param_111, param_112, param_113);
        ocol = _890;
        return _890;
    }

    fragment main0_out main0(main0_in in [[stage_in]], constant fs_uniforms& _408 [[buffer(0)]])
    {
        main0_out out = {};
        float2 param = in.fragPos;
        float3 _899 = map(param, _408);
        out.fragColor = float4(_899, 1.0);
        return out;
    }

*/
static const uint8_t sdf_fs_source_metal_macos[12712] = {
    0x23,0x70,0x72,0x61,0x67,0x6d,0x61,0x20,0x63,0x6c,0x61,0x6e,0x67,0x20,0x64,0x69,
    0x61,0x67,0x6e,0x6f,0x73,0x74,0x69,0x63,0x20,0x69,0x67,0x6e,0x6f,0x72,0x65,0x64,
    0x20,0x22,0x2d,0x57,0x6d,0x69,0x73,0x73,0x69,0x6e,0x67,0x2d,0x70,0x72,0x6f,0x74,
    0x6f,0x74,0x79,0x70,0x65,0x73,0x22,0x0a,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,
    0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,
    0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,
    0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,
    0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,
    0x0a,0x2f,0x2f,0x20,0x49,0x6d,0x70,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x61,0x74,0x69,
    0x6f,0x6e,0x20,0x6f,0x66,0x20,0x74,0x68,0x65,0x20,0x47,0x4c,0x53,0x4c,0x20,0x6d,
    0x6f,0x64,0x28,0x29,0x20,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x77,
    0x68,0x69,0x63,0x68,0x20,0x69,0x73,0x20,0x73,0x6c,0x69,0x67,0x68,0x74,0x6c,0x79,
    0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20,0x74,0x68,0x61,0x6e,0x20,
    0x4d,0x65,0x74,0x61,0x6c,0x20,0x66,0x6d,0x6f,0x64,0x28,0x29,0x0a,0x74,0x65,0x6d,
    0x70,0x6c,0x61,0x74,0x65,0x3c,0x74,0x79,0x70,0x65,0x6e,0x61,0x6d,0x65,0x20,0x54,
    0x78,0x2c,0x20,0x74,0x79,0x70,0x65,0x6e,0x61,0x6d,0x65,0x20,0x54,0x79,0x3e,0x0a,
    0x69,0x6e,0x6c,0x69,0x6e,0x65,0x20,0x54,0x78,0x20,0x6d,0x6f,0x64,0x28,0x54,0x78,
    0x20,0x78,0x2c,0x20,0x54,0x79,0x20,0x79,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,
    0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x78,0x20,0x2d,0x20,0x79,0x20,0x2a,0x20,0x66,
    0x6c,0x6f,0x6f,0x72,0x28,0x78,0x20,0x2f,0x20,0x79,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,
    0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,
    0x6d,0x73,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x69,
    0x54,0x69,0x6d,0x65,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,
    0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,
    0x72,0x20,0x5b,0x5b,0x63,0x6f,0x6c,0x6f,0x72,0x28,0x30,0x29,0x5d,0x5d,0x3b,0x0a,
    0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,
    0x5f,0x69,0x6e,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x66,0x72,0x61,0x67,0x50,0x6f,0x73,0x20,0x5b,0x5b,0x75,0x73,0x65,0x72,0x28,
    0x6c,0x6f,0x63,0x6e,0x31,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,
    0x61,0x74,0x69,0x63,0x20,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x20,0x5f,0x5f,0x61,0x74,
    0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x5f,0x5f,0x28,0x28,0x61,0x6c,0x77,0x61,0x79,
    0x73,0x5f,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x29,0x29,0x0a,0x66,0x6c,0x6f,0x61,0x74,
    0x33,0x20,0x62,0x61,0x63,0x6b,0x67,0x72,0x6f,0x75,0x6e,0x64,0x28,0x74,0x68,0x72,
    0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x26,0x20,0x75,0x76,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x20,0x5f,0x33,0x31,0x35,0x20,0x3d,0x20,0x61,0x62,0x73,0x28,0x66,0x6c,
    0x6f,0x6f,0x72,0x28,0x75,0x76,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,
    0x74,0x75,0x72,0x6e,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x28,0x30,0x2e,0x33,0x38,
    0x39,0x39,0x39,0x39,0x39,0x38,0x35,0x36,0x39,0x34,0x38,0x38,0x35,0x32,0x35,0x33,
    0x39,0x30,0x36,0x32,0x35,0x29,0x20,0x2b,0x20,0x28,0x66,0x6c,0x6f,0x61,0x74,0x33,
    0x28,0x30,0x2e,0x31,0x37,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x37,0x38,0x38,0x31,
    0x33,0x39,0x33,0x34,0x33,0x32,0x36,0x31,0x37,0x31,0x38,0x37,0x35,0x29,0x20,0x2a,
    0x20,0x6d,0x6f,0x64,0x28,0x5f,0x33,0x31,0x35,0x2e,0x78,0x20,0x2b,0x20,0x5f,0x33,
    0x31,0x35,0x2e,0x79,0x2c,0x20,0x32,0x2e,0x30,0x29,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,
    0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x20,0x5f,0x5f,
    0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x5f,0x5f,0x28,0x28,0x61,0x6c,0x77,
    0x61,0x79,0x73,0x5f,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x29,0x29,0x0a,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x5f,0x6e,0x28,0x74,0x68,0x72,0x65,
    0x61,0x64,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x26,0x20,0x70,0x2c,0x20,0x74,0x68,
    0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x26,0x20,0x6e,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x70,0x20,0x3d,0x20,0x70,
    0x6f,0x77,0x28,0x61,0x62,0x73,0x28,0x70,0x29,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x28,0x6e,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,
    0x6e,0x20,0x70,0x6f,0x77,0x28,0x70,0x2e,0x78,0x20,0x2b,0x20,0x70,0x2e,0x79,0x2c,
    0x20,0x31,0x2e,0x30,0x20,0x2f,0x20,0x6e,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x73,0x74,
    0x61,0x74,0x69,0x63,0x20,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x20,0x5f,0x5f,0x61,0x74,
    0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x5f,0x5f,0x28,0x28,0x61,0x6c,0x77,0x61,0x79,
    0x73,0x5f,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x29,0x29,0x0a,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,0x64,0x28,0x74,0x68,
    0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x26,0x20,0x70,0x2c,0x20,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,
    0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x26,0x20,0x72,0x2c,0x20,0x74,0x68,
    0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x26,0x20,0x72,0x6f,0x75,0x6e,0x64,0x6e,0x65,0x73,0x73,0x29,0x0a,0x7b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x20,
    0x3d,0x20,0x70,0x20,0x2f,0x20,0x72,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x20,0x3d,0x20,0x72,0x6f,0x75,
    0x6e,0x64,0x6e,0x65,0x73,0x73,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x5f,0x31,0x30,0x33,0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x5f,
    0x6e,0x28,0x70,0x61,0x72,0x61,0x6d,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x32,0x20,0x3d,0x20,0x70,0x20,0x2f,0x20,0x28,0x72,0x20,0x2a,
    0x20,0x72,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x33,0x20,0x3d,0x20,0x72,0x6f,0x75,0x6e,0x64,0x6e,0x65,
    0x73,0x73,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,
    0x31,0x33,0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x5f,0x6e,0x28,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x32,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x28,0x5f,0x31,0x30,
    0x33,0x20,0x2a,0x20,0x28,0x5f,0x31,0x30,0x33,0x20,0x2d,0x20,0x31,0x2e,0x30,0x29,
    0x29,0x20,0x2f,0x20,0x5f,0x31,0x31,0x33,0x3b,0x0a,0x7d,0x0a,0x0a,0x73,0x74,0x61,
    0x74,0x69,0x63,0x20,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x20,0x5f,0x5f,0x61,0x74,0x74,
    0x72,0x69,0x62,0x75,0x74,0x65,0x5f,0x5f,0x28,0x28,0x61,0x6c,0x77,0x61,0x79,0x73,
    0x5f,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x29,0x29,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x33,
    0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,
    0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x26,0x20,0x63,0x6f,0x6c,0x2c,
    0x20,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x33,0x26,0x20,0x6f,0x63,0x6f,0x6c,0x2c,0x20,0x74,0x68,0x72,0x65,
    0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x26,0x20,
    0x64,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,
    0x6d,0x69,0x78,0x28,0x6f,0x63,0x6f,0x6c,0x2c,0x20,0x63,0x6f,0x6c,0x2c,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x33,0x28,0x73,0x6d,0x6f,0x6f,0x74,0x68,0x73,0x74,0x65,0x70,
    0x28,0x30,0x2e,0x35,0x2c,0x20,0x30,0x2e,0x30,0x2c,0x20,0x64,0x29,0x29,0x29,0x3b,
    0x0a,0x7d,0x0a,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x69,0x6e,0x6c,0x69,0x6e,
    0x65,0x20,0x5f,0x5f,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x5f,0x5f,0x28,
    0x28,0x61,0x6c,0x77,0x61,0x79,0x73,0x5f,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x29,0x29,
    0x0a,0x66,0x6c,0x6f,0x61,0x74,0x20,0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,0x28,0x74,
    0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x26,0x20,0x70,0x2c,0x20,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,
    0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x26,0x20,0x61,0x2c,0x20,0x74,
    0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x26,0x20,0x62,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x20,0x5f,0x32,0x34,0x30,0x20,0x3d,0x20,0x70,0x20,0x2d,0x20,0x61,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x32,0x34,
    0x34,0x20,0x3d,0x20,0x62,0x20,0x2d,0x20,0x61,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,
    0x65,0x74,0x75,0x72,0x6e,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x28,0x5f,0x32,0x34,
    0x30,0x20,0x2d,0x20,0x28,0x5f,0x32,0x34,0x34,0x20,0x2a,0x20,0x66,0x61,0x73,0x74,
    0x3a,0x3a,0x63,0x6c,0x61,0x6d,0x70,0x28,0x64,0x6f,0x74,0x28,0x5f,0x32,0x34,0x30,
    0x2c,0x20,0x5f,0x32,0x34,0x34,0x29,0x20,0x2f,0x20,0x64,0x6f,0x74,0x28,0x5f,0x32,
    0x34,0x34,0x2c,0x20,0x5f,0x32,0x34,0x34,0x29,0x2c,0x20,0x30,0x2e,0x30,0x2c,0x20,
    0x31,0x2e,0x30,0x29,0x29,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x73,0x74,0x61,0x74,0x69,
    0x63,0x20,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x20,0x5f,0x5f,0x61,0x74,0x74,0x72,0x69,
    0x62,0x75,0x74,0x65,0x5f,0x5f,0x28,0x28,0x61,0x6c,0x77,0x61,0x79,0x73,0x5f,0x69,
    0x6e,0x6c,0x69,0x6e,0x65,0x29,0x29,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x72,
    0x6f,0x74,0x61,0x74,0x65,0x28,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,
    0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x26,0x20,0x70,0x2c,0x20,0x74,0x68,
    0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x26,0x20,0x74,0x68,0x65,0x74,0x61,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x5f,0x32,0x36,0x34,0x20,0x3d,0x20,0x63,0x6f,0x73,0x28,
    0x74,0x68,0x65,0x74,0x61,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x5f,0x32,0x36,0x37,0x20,0x3d,0x20,0x73,0x69,0x6e,0x28,0x74,0x68,0x65,
    0x74,0x61,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x66,0x6d,0x61,0x28,0x70,0x2e,0x78,0x2c,0x20,
    0x5f,0x32,0x36,0x34,0x2c,0x20,0x2d,0x28,0x70,0x2e,0x79,0x20,0x2a,0x20,0x5f,0x32,
    0x36,0x37,0x29,0x29,0x2c,0x20,0x66,0x6d,0x61,0x28,0x70,0x2e,0x78,0x2c,0x20,0x5f,
    0x32,0x36,0x37,0x2c,0x20,0x70,0x2e,0x79,0x20,0x2a,0x20,0x5f,0x32,0x36,0x34,0x29,
    0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x69,0x6e,0x6c,
    0x69,0x6e,0x65,0x20,0x5f,0x5f,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x5f,
    0x5f,0x28,0x28,0x61,0x6c,0x77,0x61,0x79,0x73,0x5f,0x69,0x6e,0x6c,0x69,0x6e,0x65,
    0x29,0x29,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x20,0x73,0x64,0x5f,0x76,0x65,0x73,0x69,
    0x63,0x61,0x28,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x26,0x20,0x70,0x2c,0x20,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,
    0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x26,0x20,0x72,0x2c,0x20,0x74,0x68,0x72,0x65,
    0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x26,0x20,
    0x64,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x70,0x20,0x3d,0x20,0x61,0x62,0x73,
    0x28,0x70,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,
    0x31,0x33,0x32,0x20,0x3d,0x20,0x73,0x71,0x72,0x74,0x28,0x66,0x6d,0x61,0x28,0x72,
    0x2c,0x20,0x72,0x2c,0x20,0x2d,0x28,0x64,0x20,0x2a,0x20,0x64,0x29,0x29,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,0x34,0x35,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x28,0x28,0x70,0x2e,0x79,0x20,0x2d,
    0x20,0x5f,0x31,0x33,0x32,0x29,0x20,0x2a,0x20,0x64,0x29,0x20,0x3e,0x20,0x28,0x70,
    0x2e,0x78,0x20,0x2a,0x20,0x5f,0x31,0x33,0x32,0x29,0x29,0x0a,0x20,0x20,0x20,0x20,
    0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x31,0x34,0x35,0x20,0x3d,
    0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x28,0x70,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x28,0x30,0x2e,0x30,0x2c,0x20,0x5f,0x31,0x33,0x32,0x29,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,0x20,
    0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x31,0x34,
    0x35,0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x28,0x70,0x20,0x2d,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x28,0x2d,0x64,0x2c,0x20,0x30,0x2e,0x30,0x29,0x29,0x20,
    0x2d,0x20,0x72,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x72,
    0x65,0x74,0x75,0x72,0x6e,0x20,0x5f,0x31,0x34,0x35,0x3b,0x0a,0x7d,0x0a,0x0a,0x73,
    0x74,0x61,0x74,0x69,0x63,0x20,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x20,0x5f,0x5f,0x61,
    0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x5f,0x5f,0x28,0x28,0x61,0x6c,0x77,0x61,
    0x79,0x73,0x5f,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x29,0x29,0x0a,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x73,0x6d,0x69,0x6e,0x28,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,
    0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x26,0x20,0x61,0x2c,0x20,0x74,0x68,
    0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x26,0x20,0x62,0x2c,0x20,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,
    0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x26,0x20,0x6b,0x29,0x0a,0x7b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x32,0x39,0x38,0x20,0x3d,0x20,0x66,
    0x61,0x73,0x74,0x3a,0x3a,0x6d,0x61,0x78,0x28,0x6b,0x20,0x2d,0x20,0x61,0x62,0x73,
    0x28,0x61,0x20,0x2d,0x20,0x62,0x29,0x2c,0x20,0x30,0x2e,0x30,0x29,0x20,0x2f,0x20,
    0x6b,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x66,0x6d,
    0x61,0x28,0x2d,0x28,0x28,0x5f,0x32,0x39,0x38,0x20,0x2a,0x20,0x5f,0x32,0x39,0x38,
    0x29,0x20,0x2a,0x20,0x6b,0x29,0x2c,0x20,0x30,0x2e,0x32,0x35,0x2c,0x20,0x66,0x61,
    0x73,0x74,0x3a,0x3a,0x6d,0x69,0x6e,0x28,0x61,0x2c,0x20,0x62,0x29,0x29,0x3b,0x0a,
    0x7d,0x0a,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x69,0x6e,0x6c,0x69,0x6e,0x65,
    0x20,0x5f,0x5f,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x5f,0x5f,0x28,0x28,
    0x61,0x6c,0x77,0x61,0x79,0x73,0x5f,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x29,0x29,0x0a,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,
    0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x26,0x20,0x70,0x2c,0x20,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,
    0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x26,0x20,0x72,0x29,0x0a,0x7b,
    0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6c,0x65,0x6e,0x67,
    0x74,0x68,0x28,0x70,0x29,0x20,0x2d,0x20,0x72,0x3b,0x0a,0x7d,0x0a,0x0a,0x73,0x74,
    0x61,0x74,0x69,0x63,0x20,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x20,0x5f,0x5f,0x61,0x74,
    0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x5f,0x5f,0x28,0x28,0x61,0x6c,0x77,0x61,0x79,
    0x73,0x5f,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x29,0x29,0x0a,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x73,0x64,0x5f,0x61,0x72,0x63,0x28,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x26,0x20,0x70,0x2c,0x20,0x74,0x68,0x72,0x65,0x61,0x64,
    0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x26,0x20,0x74,0x61,
    0x2c,0x20,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x26,0x20,0x74,0x62,0x2c,0x20,0x74,0x68,0x72,0x65,0x61,0x64,
    0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x26,0x20,0x72,0x61,
    0x2c,0x20,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x26,0x20,0x72,0x62,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,0x36,0x38,0x20,0x3d,0x20,0x63,0x6f,0x73,
    0x28,0x74,0x61,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x5f,0x31,0x37,0x30,0x20,0x3d,0x20,0x73,0x69,0x6e,0x28,0x74,0x61,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,0x37,0x34,0x20,0x3d,
    0x20,0x63,0x6f,0x73,0x28,0x74,0x62,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x5f,0x31,0x37,0x36,0x20,0x3d,0x20,0x73,0x69,0x6e,0x28,0x74,
    0x62,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x70,0x20,0x2a,0x3d,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x78,0x32,0x28,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x5f,0x31,0x36,
    0x38,0x2c,0x20,0x5f,0x31,0x37,0x30,0x29,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x28,0x2d,0x5f,0x31,0x37,0x30,0x2c,0x20,0x5f,0x31,0x36,0x38,0x29,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x70,0x2e,0x78,0x20,0x3d,0x20,0x61,0x62,0x73,0x28,0x70,0x2e,
    0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x32,
    0x30,0x39,0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x28,0x5f,0x31,0x37,
    0x36,0x20,0x2a,0x20,0x70,0x2e,0x78,0x29,0x20,0x3e,0x20,0x28,0x5f,0x31,0x37,0x34,
    0x20,0x2a,0x20,0x70,0x2e,0x79,0x29,0x29,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x32,0x30,0x39,0x20,0x3d,0x20,0x64,0x6f,
    0x74,0x28,0x70,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x5f,0x31,0x37,0x34,
    0x2c,0x20,0x5f,0x31,0x37,0x36,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,
    0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x32,0x30,0x39,0x20,0x3d,0x20,0x6c,0x65,
    0x6e,0x67,0x74,0x68,0x28,0x70,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,
    0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x73,0x71,0x72,0x74,0x28,0x66,
    0x6d,0x61,0x28,0x72,0x61,0x20,0x2a,0x20,0x28,0x2d,0x32,0x2e,0x30,0x29,0x2c,0x20,
    0x5f,0x32,0x30,0x39,0x2c,0x20,0x66,0x6d,0x61,0x28,0x72,0x61,0x2c,0x20,0x72,0x61,
    0x2c,0x20,0x64,0x6f,0x74,0x28,0x70,0x2c,0x20,0x70,0x29,0x29,0x29,0x29,0x20,0x2d,
    0x20,0x72,0x62,0x3b,0x0a,0x7d,0x0a,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x69,
    0x6e,0x6c,0x69,0x6e,0x65,0x20,0x5f,0x5f,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,
    0x65,0x5f,0x5f,0x28,0x28,0x61,0x6c,0x77,0x61,0x79,0x73,0x5f,0x69,0x6e,0x6c,0x69,
    0x6e,0x65,0x29,0x29,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x6d,0x61,0x70,0x28,
    0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x26,0x20,0x70,
    0x2c,0x20,0x63,0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,0x20,0x66,0x73,0x5f,0x75,0x6e,
    0x69,0x66,0x6f,0x72,0x6d,0x73,0x26,0x20,0x5f,0x34,0x30,0x38,0x29,0x0a,0x7b,0x0a,
    0x20,0x20,0x20,0x20,0x70,0x20,0x2a,0x3d,0x20,0x31,0x30,0x30,0x2e,0x30,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x70,0x2e,0x79,0x20,0x2d,0x3d,0x20,0x33,0x30,0x2e,0x30,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x33,0x35,0x36,
    0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x61,0x62,0x73,0x28,0x70,0x2e,
    0x78,0x29,0x2c,0x20,0x70,0x2e,0x79,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x20,0x3d,0x20,0x70,0x20,0x2a,
    0x20,0x30,0x2e,0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,
    0x32,0x38,0x39,0x35,0x35,0x30,0x37,0x38,0x31,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,
    0x61,0x63,0x6b,0x67,0x72,0x6f,0x75,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x20,0x3d,0x20,0x70,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x28,0x30,0x2e,0x30,0x2c,0x20,0x2d,0x39,0x37,0x2e,0x30,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x32,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x35,0x35,0x2e,0x30,0x2c,
    0x20,0x32,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x20,0x3d,0x20,0x32,0x2e,0x30,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x33,0x37,0x34,0x20,
    0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,0x64,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x64,0x20,0x3d,0x20,0x5f,0x33,0x37,0x34,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x34,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x28,0x30,0x2e,0x36,0x31,0x30,
    0x30,0x30,0x30,0x30,0x31,0x34,0x33,0x30,0x35,0x31,0x31,0x34,0x37,0x34,0x36,0x30,
    0x39,0x33,0x37,0x35,0x2c,0x20,0x30,0x2e,0x38,0x35,0x30,0x30,0x30,0x30,0x30,0x32,
    0x33,0x38,0x34,0x31,0x38,0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,0x32,0x35,0x2c,
    0x20,0x30,0x2e,0x39,0x33,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,0x31,0x35,0x38,
    0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,
    0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x20,0x3d,0x20,0x5f,0x33,0x37,
    0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,
    0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x35,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x71,0x20,0x3d,0x20,0x5f,
    0x33,0x35,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x38,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x35,0x35,0x2e,0x30,
    0x2c,0x20,0x34,0x35,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x20,0x3d,0x20,0x32,0x2e,0x34,
    0x30,0x30,0x30,0x30,0x30,0x30,0x39,0x35,0x33,0x36,0x37,0x34,0x33,0x31,0x36,0x34,
    0x30,0x36,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x64,
    0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x37,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x39,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x20,0x5f,0x33,0x39,0x38,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x28,0x34,0x35,0x2e,0x30,0x2c,0x20,0x2d,0x31,0x35,0x2e,0x30,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,0x30,0x30,
    0x20,0x3d,0x20,0x5f,0x33,0x39,0x38,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,0x31,0x35,0x20,0x3d,0x20,0x73,0x69,0x6e,0x28,
    0x5f,0x34,0x30,0x38,0x2e,0x69,0x54,0x69,0x6d,0x65,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x5f,0x33,0x39,0x38,0x2e,0x79,0x20,0x3d,0x20,0x66,0x6d,0x61,0x28,0x28,0x5f,
    0x34,0x30,0x30,0x20,0x2a,0x20,0x5f,0x34,0x30,0x30,0x29,0x20,0x2a,0x20,0x30,0x2e,
    0x30,0x30,0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x36,0x30,0x37,0x37,0x30,
    0x33,0x32,0x30,0x38,0x39,0x32,0x33,0x33,0x33,0x39,0x38,0x34,0x33,0x37,0x35,0x2c,
    0x20,0x5f,0x34,0x31,0x35,0x2c,0x20,0x5f,0x33,0x39,0x38,0x2e,0x79,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x33,0x39,0x38,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x30,0x20,0x3d,0x20,0x5f,0x33,0x39,0x38,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x20,0x3d,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x32,
    0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x34,0x35,0x2e,0x30,0x2c,0x20,
    0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x66,0x61,
    0x73,0x74,0x3a,0x3a,0x6d,0x69,0x6e,0x28,0x64,0x2c,0x20,0x73,0x64,0x5f,0x6c,0x69,
    0x6e,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x32,0x29,
    0x20,0x2d,0x20,0x30,0x2e,0x32,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x39,0x38,
    0x30,0x32,0x33,0x32,0x32,0x33,0x38,0x37,0x36,0x39,0x35,0x33,0x31,0x32,0x35,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x39,0x32,
    0x32,0x20,0x3d,0x20,0x71,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x39,0x32,0x32,0x2e,
    0x79,0x20,0x3d,0x20,0x66,0x6d,0x61,0x28,0x28,0x5f,0x39,0x32,0x32,0x2e,0x78,0x20,
    0x2a,0x20,0x5f,0x39,0x32,0x32,0x2e,0x78,0x29,0x20,0x2a,0x20,0x30,0x2e,0x30,0x30,
    0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x36,0x30,0x37,0x37,0x30,0x33,0x32,
    0x30,0x38,0x39,0x32,0x33,0x33,0x33,0x39,0x38,0x34,0x33,0x37,0x35,0x2c,0x20,0x73,
    0x69,0x6e,0x28,0x5f,0x34,0x30,0x38,0x2e,0x69,0x54,0x69,0x6d,0x65,0x20,0x2a,0x20,
    0x32,0x2e,0x30,0x29,0x2c,0x20,0x5f,0x39,0x32,0x32,0x2e,0x79,0x20,0x2b,0x20,0x36,
    0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x39,0x32,
    0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x31,0x33,0x20,0x3d,0x20,0x5f,0x39,0x32,0x32,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x31,0x34,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,0x30,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x35,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x34,
    0x35,0x2e,0x30,0x2c,0x20,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,
    0x20,0x3d,0x20,0x66,0x61,0x73,0x74,0x3a,0x3a,0x6d,0x69,0x6e,0x28,0x64,0x2c,0x20,
    0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x33,
    0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x31,0x35,0x29,0x20,0x2d,0x20,0x30,0x2e,0x32,0x30,0x30,0x30,0x30,0x30,
    0x30,0x30,0x32,0x39,0x38,0x30,0x32,0x33,0x32,0x32,0x33,0x38,0x37,0x36,0x39,0x35,
    0x33,0x31,0x32,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x20,0x5f,0x34,0x36,0x36,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x20,0x2d,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x33,0x32,0x2e,0x30,0x2c,0x20,0x33,0x30,0x2e,
    0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x34,0x36,0x36,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x36,0x20,0x3d,0x20,0x5f,0x34,0x36,0x36,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x37,
    0x20,0x3d,0x20,0x66,0x6d,0x61,0x28,0x5f,0x34,0x31,0x35,0x2c,0x20,0x30,0x2e,0x33,
    0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,0x38,0x39,0x35,
    0x35,0x30,0x37,0x38,0x31,0x32,0x35,0x2c,0x20,0x30,0x2e,0x36,0x39,0x39,0x39,0x39,
    0x39,0x39,0x38,0x38,0x30,0x37,0x39,0x30,0x37,0x31,0x30,0x34,0x34,0x39,0x32,0x31,
    0x38,0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x5f,0x34,0x37,0x36,0x20,0x3d,0x20,0x72,0x6f,0x74,0x61,0x74,0x65,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x36,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x37,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x34,0x37,0x36,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x38,0x20,0x3d,0x20,0x5f,0x34,0x37,0x36,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x39,
    0x20,0x3d,0x20,0x33,0x30,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x30,0x20,0x3d,0x20,0x31,0x35,
    0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,
    0x38,0x32,0x20,0x3d,0x20,0x73,0x64,0x5f,0x76,0x65,0x73,0x69,0x63,0x61,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x38,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x39,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x30,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,0x38,0x33,0x20,0x3d,0x20,0x64,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,0x38,0x35,
    0x20,0x3d,0x20,0x66,0x61,0x73,0x74,0x3a,0x3a,0x6d,0x69,0x6e,0x28,0x5f,0x34,0x38,
    0x33,0x2c,0x20,0x5f,0x34,0x38,0x32,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,
    0x3d,0x20,0x5f,0x34,0x38,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x31,0x20,0x3d,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x33,0x28,0x30,0x2e,0x31,0x31,0x39,0x39,0x39,0x39,0x39,0x39,0x37,
    0x33,0x31,0x37,0x37,0x39,0x30,0x39,0x38,0x35,0x31,0x30,0x37,0x34,0x32,0x31,0x38,
    0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x32,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x32,0x33,0x20,0x3d,0x20,0x5f,0x34,0x38,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x32,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x32,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x33,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x71,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x34,0x20,0x3d,0x20,
    0x5f,0x33,0x35,0x36,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,
    0x30,0x2c,0x20,0x2d,0x36,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x35,0x20,0x3d,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x32,0x37,0x2e,0x30,0x2c,0x20,0x32,0x30,
    0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x32,0x36,0x20,0x3d,0x20,0x32,0x2e,0x30,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,
    0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x34,0x2c,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x32,0x35,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x36,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x32,0x37,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x28,0x30,0x2e,0x30,0x2c,0x20,0x2d,0x37,0x30,0x2e,0x30,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x32,0x38,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x32,0x30,
    0x2e,0x30,0x2c,0x20,0x31,0x36,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x39,0x20,0x3d,0x20,
    0x32,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x66,0x61,0x73,
    0x74,0x3a,0x3a,0x6d,0x61,0x78,0x28,0x2d,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,
    0x73,0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x37,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x32,0x38,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,
    0x39,0x29,0x2c,0x20,0x64,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x20,0x5f,0x35,0x32,0x32,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x20,0x2d,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x36,0x2e,0x30,0x2c,0x20,0x2d,0x35,0x30,
    0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x35,0x32,
    0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x33,0x30,0x20,0x3d,0x20,0x5f,0x35,0x32,0x32,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,
    0x31,0x20,0x3d,0x20,0x66,0x6d,0x61,0x28,0x30,0x2e,0x35,0x2c,0x20,0x5f,0x34,0x31,
    0x35,0x2c,0x20,0x30,0x2e,0x35,0x29,0x20,0x2a,0x20,0x28,0x2d,0x30,0x2e,0x31,0x30,
    0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x39,0x30,0x31,0x31,0x36,0x31,0x31,0x39,
    0x33,0x38,0x34,0x37,0x36,0x35,0x36,0x32,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x35,0x33,0x34,0x20,0x3d,0x20,0x72,0x6f,
    0x74,0x61,0x74,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x30,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x33,0x31,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x35,
    0x33,0x34,0x2e,0x78,0x20,0x3d,0x20,0x66,0x6d,0x61,0x28,0x2d,0x70,0x6f,0x77,0x28,
    0x66,0x61,0x73,0x74,0x3a,0x3a,0x6d,0x61,0x78,0x28,0x28,0x2d,0x34,0x35,0x2e,0x30,
    0x29,0x20,0x2d,0x20,0x5f,0x35,0x33,0x34,0x2e,0x79,0x2c,0x20,0x30,0x2e,0x30,0x29,
    0x2c,0x20,0x31,0x2e,0x38,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,0x31,0x35,0x38,
    0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x29,0x2c,0x20,0x30,0x2e,
    0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x39,0x30,0x31,0x31,0x36,0x31,
    0x31,0x39,0x33,0x38,0x34,0x37,0x36,0x35,0x36,0x32,0x35,0x2c,0x20,0x5f,0x35,0x33,
    0x34,0x2e,0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x35,
    0x33,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x33,0x32,0x20,0x3d,0x20,0x5f,0x35,0x33,0x34,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x33,0x33,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,0x30,
    0x2c,0x20,0x2d,0x35,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x34,0x20,0x3d,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x35,0x20,
    0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x33,0x36,0x20,0x3d,0x20,0x73,0x64,0x5f,0x6c,0x69,0x6e,
    0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x32,0x2c,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x33,0x33,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x34,0x29,0x20,
    0x2d,0x20,0x35,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x37,0x20,0x3d,0x20,0x31,0x2e,0x30,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x6d,0x69,0x6e,0x28,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x33,0x35,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x36,
    0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x37,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x35,0x36,0x34,0x20,0x3d,0x20,0x5f,
    0x33,0x35,0x36,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x32,0x32,0x2e,
    0x30,0x2c,0x20,0x2d,0x36,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,
    0x20,0x3d,0x20,0x5f,0x35,0x36,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x38,0x20,0x3d,0x20,0x5f,
    0x35,0x36,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x33,0x39,0x20,0x3d,0x20,0x66,0x6d,0x61,0x28,0x30,0x2e,
    0x35,0x2c,0x20,0x63,0x6f,0x73,0x28,0x5f,0x34,0x30,0x38,0x2e,0x69,0x54,0x69,0x6d,
    0x65,0x29,0x2c,0x20,0x30,0x2e,0x35,0x29,0x20,0x2a,0x20,0x28,0x2d,0x30,0x2e,0x31,
    0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x39,0x30,0x31,0x31,0x36,0x31,0x31,
    0x39,0x33,0x38,0x34,0x37,0x36,0x35,0x36,0x32,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x35,0x37,0x35,0x20,0x3d,0x20,0x72,
    0x6f,0x74,0x61,0x74,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x38,0x2c,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x39,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,
    0x35,0x37,0x35,0x2e,0x78,0x20,0x3d,0x20,0x66,0x6d,0x61,0x28,0x2d,0x70,0x6f,0x77,
    0x28,0x66,0x61,0x73,0x74,0x3a,0x3a,0x6d,0x61,0x78,0x28,0x28,0x2d,0x32,0x39,0x2e,
    0x30,0x29,0x20,0x2d,0x20,0x5f,0x35,0x37,0x35,0x2e,0x79,0x2c,0x20,0x30,0x2e,0x30,
    0x29,0x2c,0x20,0x31,0x2e,0x38,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,0x31,0x35,
    0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x29,0x2c,0x20,0x30,
    0x2e,0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x39,0x30,0x31,0x31,0x36,
    0x31,0x31,0x39,0x33,0x38,0x34,0x37,0x36,0x35,0x36,0x32,0x35,0x2c,0x20,0x5f,0x35,
    0x37,0x35,0x2e,0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,
    0x35,0x37,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x30,0x20,0x3d,0x20,0x5f,0x35,0x37,0x35,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x34,0x31,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,
    0x30,0x2c,0x20,0x2d,0x33,0x35,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x32,0x20,0x3d,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x33,
    0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x34,0x20,0x3d,0x20,0x73,0x64,0x5f,0x6c,0x69,
    0x6e,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x30,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x34,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x32,0x29,
    0x20,0x2d,0x20,0x35,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x35,0x20,0x3d,0x20,0x31,0x2e,0x30,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x6d,0x69,0x6e,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x34,0x33,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,
    0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x35,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x36,0x30,0x34,0x20,0x3d,0x20,
    0x70,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x2d,0x32,0x36,0x2e,0x30,
    0x2c,0x20,0x2d,0x36,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,
    0x3d,0x20,0x5f,0x36,0x30,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x36,0x20,0x3d,0x20,0x5f,0x36,
    0x30,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x34,0x37,0x20,0x3d,0x20,0x32,0x2e,0x31,0x39,0x39,0x31,0x31,
    0x34,0x37,0x39,0x39,0x34,0x39,0x39,0x35,0x31,0x31,0x37,0x31,0x38,0x37,0x35,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x36,0x30,0x39,
    0x20,0x3d,0x20,0x72,0x6f,0x74,0x61,0x74,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x34,0x36,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x37,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x31,0x31,0x20,0x3d,0x20,
    0x5f,0x36,0x30,0x39,0x2e,0x79,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x36,0x30,0x39,
    0x2e,0x78,0x20,0x3d,0x20,0x5f,0x36,0x30,0x39,0x2e,0x78,0x20,0x2d,0x20,0x66,0x6d,
    0x61,0x28,0x73,0x69,0x6e,0x28,0x66,0x6d,0x61,0x28,0x5f,0x36,0x31,0x31,0x2c,0x20,
    0x30,0x2e,0x31,0x32,0x33,0x30,0x30,0x30,0x30,0x30,0x33,0x33,0x39,0x37,0x34,0x36,
    0x34,0x37,0x35,0x32,0x31,0x39,0x37,0x32,0x36,0x35,0x36,0x32,0x35,0x2c,0x20,0x33,
    0x2e,0x30,0x29,0x29,0x2c,0x20,0x34,0x2e,0x30,0x2c,0x20,0x73,0x69,0x6e,0x28,0x66,
    0x6d,0x61,0x28,0x5f,0x36,0x31,0x31,0x2c,0x20,0x30,0x2e,0x31,0x30,0x30,0x30,0x30,
    0x30,0x30,0x30,0x31,0x34,0x39,0x30,0x31,0x31,0x36,0x31,0x31,0x39,0x33,0x38,0x34,
    0x37,0x36,0x35,0x36,0x32,0x35,0x2c,0x20,0x5f,0x34,0x30,0x38,0x2e,0x69,0x54,0x69,
    0x6d,0x65,0x20,0x2a,0x20,0x31,0x30,0x2e,0x30,0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x36,0x30,0x39,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x38,0x20,
    0x3d,0x20,0x5f,0x36,0x30,0x39,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x39,0x20,0x3d,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,0x30,0x2c,0x20,0x2d,0x34,0x30,0x2e,0x30,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x35,0x30,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,
    0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x35,0x31,0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x32,0x20,
    0x3d,0x20,0x66,0x6d,0x61,0x28,0x2d,0x35,0x2e,0x30,0x2c,0x20,0x73,0x6d,0x6f,0x6f,
    0x74,0x68,0x73,0x74,0x65,0x70,0x28,0x2d,0x36,0x30,0x2e,0x30,0x2c,0x20,0x30,0x2e,
    0x30,0x2c,0x20,0x71,0x2e,0x79,0x29,0x2c,0x20,0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,
    0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x38,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x34,0x39,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x30,0x29,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x35,0x33,0x20,0x3d,0x20,0x31,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x35,0x30,0x20,0x3d,0x20,0x73,0x6d,0x69,0x6e,
    0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x35,0x32,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x33,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x36,0x35,0x30,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,
    0x34,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x28,0x30,0x2e,0x31,0x31,0x39,
    0x39,0x39,0x39,0x39,0x39,0x37,0x33,0x31,0x37,0x37,0x39,0x30,0x39,0x38,0x35,0x31,
    0x30,0x37,0x34,0x32,0x31,0x38,0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x35,0x20,0x3d,
    0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x36,0x20,0x3d,0x20,0x5f,0x36,0x35,0x30,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,
    0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x34,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x35,0x35,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x36,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x35,0x37,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x28,0x2d,0x32,0x2e,0x30,0x2c,0x20,0x2d,0x34,0x2e,0x30,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x35,0x38,0x20,0x3d,0x20,0x31,0x2e,0x32,0x39,0x39,0x39,0x39,0x39,0x39,0x35,0x32,
    0x33,0x31,0x36,0x32,0x38,0x34,0x31,0x37,0x39,0x36,0x38,0x37,0x35,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x36,0x35,0x20,0x3d,0x20,
    0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x35,0x37,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x38,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x36,0x36,0x35,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x39,
    0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x2d,0x32,
    0x2e,0x30,0x2c,0x20,0x2d,0x39,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x30,0x20,0x3d,0x20,
    0x31,0x2e,0x32,0x30,0x30,0x30,0x30,0x30,0x30,0x34,0x37,0x36,0x38,0x33,0x37,0x31,
    0x35,0x38,0x32,0x30,0x33,0x31,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x5f,0x36,0x37,0x35,0x20,0x3d,0x20,0x66,0x61,0x73,0x74,0x3a,
    0x3a,0x6d,0x69,0x6e,0x28,0x5f,0x36,0x36,0x35,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,
    0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x39,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x36,0x30,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,
    0x20,0x3d,0x20,0x5f,0x36,0x37,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x31,0x20,0x3d,0x20,0x71,
    0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x2d,0x32,0x2e,0x30,0x2c,0x20,
    0x2d,0x31,0x35,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x32,0x20,0x3d,0x20,0x31,0x2e,0x31,
    0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x33,0x38,0x34,0x31,0x38,0x35,0x37,0x39,0x31,
    0x30,0x31,0x35,0x36,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x5f,0x36,0x38,0x34,0x20,0x3d,0x20,0x66,0x61,0x73,0x74,0x3a,0x3a,0x6d,
    0x69,0x6e,0x28,0x5f,0x36,0x37,0x35,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,
    0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x31,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x36,0x32,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,
    0x20,0x5f,0x36,0x38,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x33,0x20,0x3d,0x20,0x71,0x20,0x2d,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x2d,0x32,0x2e,0x30,0x2c,0x20,0x2d,0x32,
    0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x34,0x20,0x3d,0x20,0x31,0x2e,0x30,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x39,0x33,0x20,0x3d,
    0x20,0x66,0x61,0x73,0x74,0x3a,0x3a,0x6d,0x69,0x6e,0x28,0x5f,0x36,0x38,0x34,0x2c,
    0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x36,0x33,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x34,0x29,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x36,0x39,0x33,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x36,0x35,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,
    0x2d,0x31,0x2e,0x36,0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x33,0x38,0x34,0x31,0x38,
    0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,0x32,0x35,0x2c,0x20,0x2d,0x32,0x35,0x2e,
    0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x36,0x36,0x20,0x3d,0x20,0x30,0x2e,0x38,0x39,0x39,0x39,0x39,
    0x39,0x39,0x37,0x36,0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,
    0x37,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x37,
    0x30,0x34,0x20,0x3d,0x20,0x66,0x61,0x73,0x74,0x3a,0x3a,0x6d,0x69,0x6e,0x28,0x5f,
    0x36,0x39,0x33,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x36,0x35,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,
    0x36,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x37,0x30,
    0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x36,0x37,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x28,0x2d,0x31,0x2e,0x32,0x39,0x39,0x39,0x39,0x39,0x39,0x35,0x32,
    0x33,0x31,0x36,0x32,0x38,0x34,0x31,0x37,0x39,0x36,0x38,0x37,0x35,0x2c,0x20,0x2d,
    0x32,0x39,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x38,0x20,0x3d,0x20,0x30,0x2e,0x38,0x30,
    0x30,0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,0x38,0x39,0x35,0x35,
    0x30,0x37,0x38,0x31,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x5f,0x37,0x31,0x34,0x20,0x3d,0x20,0x66,0x61,0x73,0x74,0x3a,0x3a,0x6d,
    0x69,0x6e,0x28,0x5f,0x37,0x30,0x34,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,
    0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x37,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x36,0x38,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,
    0x20,0x5f,0x37,0x31,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x39,0x20,0x3d,0x20,0x71,0x20,0x2d,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x2d,0x30,0x2e,0x38,0x39,0x39,0x39,0x39,
    0x39,0x39,0x37,0x36,0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,
    0x37,0x35,0x2c,0x20,0x2d,0x33,0x33,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x30,0x20,0x3d,
    0x20,0x30,0x2e,0x36,0x39,0x39,0x39,0x39,0x39,0x39,0x38,0x38,0x30,0x37,0x39,0x30,
    0x37,0x31,0x30,0x34,0x34,0x39,0x32,0x31,0x38,0x37,0x35,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x37,0x32,0x34,0x20,0x3d,0x20,0x66,0x61,
    0x73,0x74,0x3a,0x3a,0x6d,0x69,0x6e,0x28,0x5f,0x37,0x31,0x34,0x2c,0x20,0x73,0x64,
    0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x39,
    0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x30,0x29,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x37,0x32,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x31,0x20,
    0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x2d,0x30,0x2e,
    0x38,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,0x38,0x39,
    0x35,0x35,0x30,0x37,0x38,0x31,0x32,0x35,0x2c,0x20,0x2d,0x33,0x37,0x2e,0x30,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x37,0x32,0x20,0x3d,0x20,0x30,0x2e,0x36,0x30,0x30,0x30,0x30,0x30,0x30,
    0x32,0x33,0x38,0x34,0x31,0x38,0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,0x32,0x35,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x37,0x33,0x35,
    0x20,0x3d,0x20,0x66,0x61,0x73,0x74,0x3a,0x3a,0x6d,0x69,0x6e,0x28,0x5f,0x37,0x32,
    0x34,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x37,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x32,0x29,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x37,0x33,0x35,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x37,0x33,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x28,0x30,0x2e,
    0x36,0x31,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x33,0x30,0x35,0x31,0x31,0x34,0x37,
    0x34,0x36,0x30,0x39,0x33,0x37,0x35,0x2c,0x20,0x30,0x2e,0x38,0x35,0x30,0x30,0x30,
    0x30,0x30,0x32,0x33,0x38,0x34,0x31,0x38,0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,
    0x32,0x35,0x2c,0x20,0x30,0x2e,0x39,0x33,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,
    0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x37,0x34,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x35,0x20,
    0x3d,0x20,0x5f,0x37,0x33,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,
    0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,
    0x33,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x34,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x20,0x5f,0x39,0x34,0x36,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x5f,0x39,0x34,0x36,0x2e,0x79,0x20,0x3d,0x20,0x70,0x2e,0x79,
    0x20,0x2d,0x20,0x28,0x2d,0x31,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x71,0x20,0x3d,0x20,0x5f,0x39,0x34,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x36,0x20,0x3d,0x20,
    0x5f,0x39,0x34,0x36,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,
    0x30,0x2c,0x20,0x2d,0x35,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x37,0x20,0x3d,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x34,0x30,0x2e,0x30,0x2c,0x20,0x32,0x30,0x2e,
    0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x37,0x38,0x20,0x3d,0x20,0x32,0x2e,0x39,0x30,0x30,0x30,0x30,
    0x30,0x30,0x39,0x35,0x33,0x36,0x37,0x34,0x33,0x31,0x36,0x34,0x30,0x36,0x32,0x35,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,
    0x69,0x70,0x73,0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x36,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x37,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x37,0x38,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x39,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x32,0x31,0x2e,0x30,0x2c,0x20,0x30,0x2e,0x30,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x38,0x30,0x20,0x3d,0x20,0x32,0x30,0x2e,0x30,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x31,
    0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x32,0x20,0x3d,0x20,0x73,0x64,0x5f,0x63,0x69,
    0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x39,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x38,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x33,0x20,0x3d,0x20,0x35,
    0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x37,
    0x37,0x30,0x20,0x3d,0x20,0x73,0x6d,0x69,0x6e,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x38,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x32,0x2c,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x38,0x33,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,
    0x20,0x5f,0x37,0x37,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x34,0x20,0x3d,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x33,0x28,0x30,0x2e,0x39,0x38,0x30,0x30,0x30,0x30,0x30,0x31,0x39,0x30,
    0x37,0x33,0x34,0x38,0x36,0x33,0x32,0x38,0x31,0x32,0x35,0x2c,0x20,0x30,0x2e,0x37,
    0x39,0x30,0x30,0x30,0x30,0x30,0x32,0x31,0x34,0x35,0x37,0x36,0x37,0x32,0x31,0x31,
    0x39,0x31,0x34,0x30,0x36,0x32,0x35,0x2c,0x20,0x30,0x2e,0x36,0x38,0x39,0x39,0x39,
    0x39,0x39,0x39,0x37,0x36,0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,
    0x33,0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x35,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x38,0x36,0x20,0x3d,0x20,0x5f,0x37,0x37,0x30,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x38,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x35,
    0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x36,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x37,
    0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,
    0x30,0x2c,0x20,0x66,0x6d,0x61,0x28,0x5f,0x34,0x31,0x35,0x2c,0x20,0x30,0x2e,0x35,
    0x2c,0x20,0x2d,0x31,0x32,0x2e,0x30,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x38,0x20,0x3d,0x20,
    0x32,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x64,0x5f,
    0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x37,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x38,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x39,0x20,
    0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,0x30,
    0x2c,0x20,0x2d,0x31,0x38,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x30,0x20,0x3d,0x20,0x66,
    0x6d,0x61,0x28,0x5f,0x34,0x31,0x35,0x2c,0x20,0x30,0x2e,0x33,0x30,0x30,0x30,0x30,
    0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,0x38,0x39,0x35,0x35,0x30,0x37,0x38,
    0x31,0x32,0x35,0x2c,0x20,0x33,0x2e,0x31,0x34,0x31,0x35,0x39,0x32,0x37,0x34,0x31,
    0x30,0x31,0x32,0x35,0x37,0x33,0x32,0x34,0x32,0x31,0x38,0x37,0x35,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x39,0x31,0x20,0x3d,0x20,0x30,0x2e,0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,
    0x39,0x32,0x30,0x39,0x32,0x38,0x39,0x35,0x35,0x30,0x37,0x38,0x31,0x32,0x35,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x39,0x32,0x20,0x3d,0x20,0x34,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x33,0x20,0x3d,0x20,
    0x30,0x2e,0x34,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x35,0x39,0x36,0x30,0x34,0x36,
    0x34,0x34,0x37,0x37,0x35,0x33,0x39,0x30,0x36,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x38,0x30,0x39,0x20,0x3d,0x20,0x73,0x64,
    0x5f,0x61,0x72,0x63,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x39,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x39,0x30,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,
    0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x32,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x39,0x33,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x5f,0x38,0x31,0x30,0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x38,0x31,0x32,0x20,0x3d,0x20,0x66,0x61,0x73,
    0x74,0x3a,0x3a,0x6d,0x69,0x6e,0x28,0x5f,0x38,0x31,0x30,0x2c,0x20,0x5f,0x38,0x30,
    0x39,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x38,0x31,0x32,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x39,0x34,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x28,0x30,
    0x2e,0x36,0x37,0x30,0x30,0x30,0x30,0x30,0x31,0x36,0x36,0x38,0x39,0x33,0x30,0x30,
    0x35,0x33,0x37,0x31,0x30,0x39,0x33,0x37,0x35,0x2c,0x20,0x30,0x2e,0x33,0x36,0x30,
    0x30,0x30,0x30,0x30,0x31,0x34,0x33,0x30,0x35,0x31,0x31,0x34,0x37,0x34,0x36,0x30,
    0x39,0x33,0x37,0x35,0x2c,0x20,0x30,0x2e,0x33,0x31,0x39,0x39,0x39,0x39,0x39,0x39,
    0x32,0x38,0x34,0x37,0x34,0x34,0x32,0x36,0x32,0x36,0x39,0x35,0x33,0x31,0x32,0x35,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x39,0x35,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,
    0x36,0x20,0x3d,0x20,0x5f,0x38,0x31,0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,
    0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x39,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x35,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x39,0x36,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x5f,0x39,0x35,0x32,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x39,0x35,0x32,0x2e,0x79,0x20,0x3d,0x20,0x28,
    0x70,0x2e,0x79,0x20,0x2d,0x20,0x28,0x2d,0x31,0x32,0x2e,0x30,0x29,0x29,0x20,0x2f,
    0x20,0x28,0x31,0x2e,0x30,0x20,0x2d,0x20,0x73,0x6d,0x6f,0x6f,0x74,0x68,0x73,0x74,
    0x65,0x70,0x28,0x30,0x2e,0x39,0x38,0x30,0x30,0x30,0x30,0x30,0x31,0x39,0x30,0x37,
    0x33,0x34,0x38,0x36,0x33,0x32,0x38,0x31,0x32,0x35,0x2c,0x20,0x31,0x2e,0x30,0x2c,
    0x20,0x73,0x69,0x6e,0x28,0x5f,0x34,0x30,0x38,0x2e,0x69,0x54,0x69,0x6d,0x65,0x20,
    0x2a,0x20,0x33,0x2e,0x30,0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,
    0x3d,0x20,0x5f,0x39,0x35,0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x37,0x20,0x3d,0x20,0x5f,0x39,
    0x35,0x32,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x32,0x30,0x2e,0x30,
    0x2c,0x20,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x38,0x20,0x3d,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x28,0x39,0x2e,0x30,0x2c,0x20,0x31,0x32,0x2e,0x30,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x39,0x39,0x20,0x3d,0x20,0x32,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x5f,0x38,0x34,0x37,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,
    0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,
    0x37,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x38,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x39,0x39,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,
    0x5f,0x38,0x34,0x37,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x30,0x20,0x3d,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x33,0x28,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x31,0x20,0x3d,
    0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x32,0x20,0x3d,0x20,0x5f,0x38,0x34,
    0x37,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,
    0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x30,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x31,0x30,0x32,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x33,0x20,0x3d,0x20,0x71,0x20,0x2d,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x31,0x39,0x2e,0x35,0x2c,0x20,0x30,0x2e,
    0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x34,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x28,0x35,0x2e,0x30,0x2c,0x20,0x38,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x35,
    0x20,0x3d,0x20,0x32,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x5f,0x38,0x36,0x34,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,
    0x70,0x73,0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x33,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x31,0x30,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,
    0x5f,0x38,0x36,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x36,0x20,0x3d,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x33,0x28,0x30,0x2e,0x36,0x37,0x30,0x30,0x30,0x30,0x30,0x31,0x36,0x36,
    0x38,0x39,0x33,0x30,0x30,0x35,0x33,0x37,0x31,0x30,0x39,0x33,0x37,0x35,0x2c,0x20,
    0x30,0x2e,0x33,0x36,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x33,0x30,0x35,0x31,0x31,
    0x34,0x37,0x34,0x36,0x30,0x39,0x33,0x37,0x35,0x2c,0x20,0x30,0x2e,0x33,0x31,0x39,
    0x39,0x39,0x39,0x39,0x39,0x32,0x38,0x34,0x37,0x34,0x34,0x32,0x36,0x32,0x36,0x39,
    0x35,0x33,0x31,0x32,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x37,0x20,0x3d,0x20,0x6f,
    0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x38,0x20,0x3d,0x20,0x5f,0x38,0x36,0x34,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,
    0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x36,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x30,0x37,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,
    0x38,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,
    0x38,0x37,0x33,0x20,0x3d,0x20,0x70,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x28,0x2d,0x32,0x2e,0x30,0x2c,0x20,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x5f,0x38,0x37,0x33,0x2e,0x78,0x20,0x3d,0x20,0x61,0x62,0x73,0x28,0x5f,0x38,
    0x37,0x33,0x2e,0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,
    0x38,0x37,0x33,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x39,0x20,0x3d,0x20,0x5f,0x38,0x37,0x33,
    0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x31,0x39,0x2e,0x35,0x2c,0x20,
    0x2d,0x38,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x30,0x20,0x3d,0x20,0x31,0x2e,0x32,
    0x39,0x39,0x39,0x39,0x39,0x39,0x35,0x32,0x33,0x31,0x36,0x32,0x38,0x34,0x31,0x37,
    0x39,0x36,0x38,0x37,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x5f,0x38,0x38,0x34,0x20,0x3d,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,
    0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x39,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x31,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,
    0x20,0x5f,0x38,0x38,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x31,0x20,0x3d,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x33,0x28,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x32,0x20,
    0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x33,0x20,0x3d,0x20,0x5f,0x38,
    0x38,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x5f,
    0x38,0x39,0x30,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x31,0x31,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x32,
    0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x33,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x5f,0x38,0x39,0x30,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x5f,0x38,0x39,0x30,0x3b,0x0a,
    0x7d,0x0a,0x0a,0x66,0x72,0x61,0x67,0x6d,0x65,0x6e,0x74,0x20,0x6d,0x61,0x69,0x6e,
    0x30,0x5f,0x6f,0x75,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,0x69,0x6e,
    0x30,0x5f,0x69,0x6e,0x20,0x69,0x6e,0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,0x65,0x5f,
    0x69,0x6e,0x5d,0x5d,0x2c,0x20,0x63,0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,0x20,0x66,
    0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x26,0x20,0x5f,0x34,0x30,0x38,
    0x20,0x5b,0x5b,0x62,0x75,0x66,0x66,0x65,0x72,0x28,0x30,0x29,0x5d,0x5d,0x29,0x0a,
    0x7b,0x0a,0x20,0x20,0x20,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,
    0x6f,0x75,0x74,0x20,0x3d,0x20,0x7b,0x7d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x20,0x3d,0x20,0x69,0x6e,0x2e,
    0x66,0x72,0x61,0x67,0x50,0x6f,0x73,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x33,0x20,0x5f,0x38,0x39,0x39,0x20,0x3d,0x20,0x6d,0x61,0x70,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x2c,0x20,0x5f,0x34,0x30,0x38,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x6f,0x75,0x74,0x2e,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,0x72,0x20,0x3d,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x28,0x5f,0x38,0x39,0x39,0x2c,0x20,0x31,0x2e,
    0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6f,
    0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #include <metal_stdlib>
    #include <simd/simd.h>

    using namespace metal;

    struct vs_uniforms
    {
        float2 iResolution;
    };

    struct main0_out
    {
        float2 texUV [[user(locn0)]];
        float2 fragPos [[user(locn1)]];
        float4 gl_Position [[position]];
    };

    struct main0_in
    {
        float4 coord [[attribute(0)]];
    };

    vertex main0_out main0(main0_in in [[stage_in]], constant vs_uniforms& _36 [[buffer(0)]])
    {
        main0_out out = {};
        out.gl_Position = float4(in.coord.xy, 0.0, 1.0);
        out.fragPos = float2(in.coord.x * (_36.iResolution.x / _36.iResolution.y), in.coord.y);
        out.texUV = in.coord.zw;
        return out;
    }

*/
static const uint8_t sdf_vs_source_metal_ios[618] = {
    0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,
    0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,
    0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,
    0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,
    0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x76,
    0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x69,0x52,0x65,0x73,0x6f,0x6c,0x75,0x74,
    0x69,0x6f,0x6e,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,
    0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x74,0x65,0x78,0x55,0x56,0x20,0x5b,0x5b,0x75,
    0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x66,0x72,0x61,0x67,0x50,0x6f,0x73,
    0x20,0x5b,0x5b,0x75,0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x31,0x29,0x5d,0x5d,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x67,0x6c,0x5f,
    0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x5b,0x5b,0x70,0x6f,0x73,0x69,0x74,
    0x69,0x6f,0x6e,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,
    0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,0x6e,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x63,0x6f,0x6f,0x72,0x64,0x20,0x5b,0x5b,
    0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x28,0x30,0x29,0x5d,0x5d,0x3b,0x0a,
    0x7d,0x3b,0x0a,0x0a,0x76,0x65,0x72,0x74,0x65,0x78,0x20,0x6d,0x61,0x69,0x6e,0x30,
    0x5f,0x6f,0x75,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,0x69,0x6e,0x30,
    0x5f,0x69,0x6e,0x20,0x69,0x6e,0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,
    0x6e,0x5d,0x5d,0x2c,0x20,0x63,0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,0x20,0x76,0x73,
    0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x26,0x20,0x5f,0x33,0x36,0x20,0x5b,
    0x5b,0x62,0x75,0x66,0x66,0x65,0x72,0x28,0x30,0x29,0x5d,0x5d,0x29,0x0a,0x7b,0x0a,
    0x20,0x20,0x20,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6f,0x75,
    0x74,0x20,0x3d,0x20,0x7b,0x7d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,0x2e,
    0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x34,0x28,0x69,0x6e,0x2e,0x63,0x6f,0x6f,0x72,0x64,0x2e,0x78,0x79,
    0x2c,0x20,0x30,0x2e,0x30,0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x6f,0x75,0x74,0x2e,0x66,0x72,0x61,0x67,0x50,0x6f,0x73,0x20,0x3d,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x28,0x69,0x6e,0x2e,0x63,0x6f,0x6f,0x72,0x64,0x2e,0x78,
    0x20,0x2a,0x20,0x28,0x5f,0x33,0x36,0x2e,0x69,0x52,0x65,0x73,0x6f,0x6c,0x75,0x74,
    0x69,0x6f,0x6e,0x2e,0x78,0x20,0x2f,0x20,0x5f,0x33,0x36,0x2e,0x69,0x52,0x65,0x73,
    0x6f,0x6c,0x75,0x74,0x69,0x6f,0x6e,0x2e,0x79,0x29,0x2c,0x20,0x69,0x6e,0x2e,0x63,
    0x6f,0x6f,0x72,0x64,0x2e,0x79,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,
    0x2e,0x74,0x65,0x78,0x55,0x56,0x20,0x3d,0x20,0x69,0x6e,0x2e,0x63,0x6f,0x6f,0x72,
    0x64,0x2e,0x7a,0x77,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,
    0x20,0x6f,0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #pragma clang diagnostic ignored "-Wmissing-prototypes"

    #include <metal_stdlib>
    #include <simd/simd.h>

    using namespace metal;

    // Implementation of the GLSL mod() function, which is slightly different than Metal fmod()
    template<typename Tx, typename Ty>
    inline Tx mod(Tx x, Ty y)
    {
        return x - y * floor(x / y);
    }

    struct fs_uniforms
    {
        float iTime;
    };

    struct main0_out
    {
        float4 fragColor [[color(0)]];
    };

    struct main0_in
    {
        float2 fragPos [[user(locn1)]];
    };

    static inline __attribute__((always_inline))
    float3 background(thread const float2& uv)
    {
        float2 _315 = abs(floor(uv));
        return float3(0.38999998569488525390625) + (float3(0.17000000178813934326171875) * mod(_315.x + _315.y, 2.0));
    }

    static inline __attribute__((always_inline))
    float length_n(thread float2& p, thread const float& n)
    {
        p = pow(abs(p), float2(n));
        return pow(p.x + p.y, 1.0 / n);
    }

    static inline __attribute__((always_inline))
    float sd_ellipsoid(thread const float2& p, thread const float2& r, thread const float& roundness)
    {
        float2 param = p / r;
        float param_1 = roundness;
        float _103 = length_n(param, param_1);
        float2 param_2 = p / (r * r);
        float param_3 = roundness;
        float _113 = length_n(param_2, param_3);
        return (_103 * (_103 - 1.0)) / _113;
    }

    static inline __attribute__((always_inline))
    float3 blend(thread const float3& col, thread const float3& ocol, thread const float& d)
    {
        return mix(ocol, col, float3(smoothstep(0.5, 0.0, d)));
    }

    static inline __attribute__((always_inline))
    float sd_line(thread const float2& p, thread const float2& a, thread const float2& b)
    {
        float2 _240 = p - a;
        float2 _244 = b - a;
        return length(_240 - (_244 * fast::clamp(dot(_240, _244) / dot(_244, _244), 0.0, 1.0)));
    }

    static inline __attribute__((always_inline))
    float2 rotate(thread const float2& p, thread const float& theta)
    {
        float _264 = cos(theta);
        float _267 = sin(theta);
        return float2(fma(p.x, _264, -(p.y * _267)), fma(p.x, _267, p.y * _264));
    }

    static inline __attribute__((always_inline))
    float sd_vesica(thread float2& p, thread const float& r, thread const float& d)
    {
        p = abs(p);
        float _132 = sqrt(fma(r, r, -(d * d)));
        float _145;
        if (((p.y - _132) * d) > (p.x * _132))
        {
            _145 = length(p - float2(0.0, _132));
        }
        else
        {
            _145 = length(p - float2(-d, 0.0)) - r;
        }
        return _145;
    }

    static inline __attribute__((always_inline))
    float smin(thread const float& a, thread const float& b, thread const float& k)
    {
        float _298 = fast::max(k - abs(a - b), 0.0) / k;
        return fma(-((_298 * _298) * k), 0.25, fast::min(a, b));
    }

    static inline __attribute__((always_inline))
    float sd_circle(thread const float2& p, thread const float& r)
    {
        return length(p) - r;
    }

    static inline __attribute__((always_inline))
    float sd_arc(thread float2& p, thread const float& ta, thread const float& tb, thread const float& ra, thread const float& rb)
    {
        float _168 = cos(ta);
        float _170 = sin(ta);
        float _174 = cos(tb);
        float _176 = sin(tb);
        p *= float2x2(float2(_168, _170), float2(-_170, _168));
        p.x = abs(p.x);
        float _209;
        if ((_176 * p.x) > (_174 * p.y))
        {
            _209 = dot(p, float2(_174, _176));
        }
        else
        {
            _209 = length(p);
        }
        return sqrt(fma(ra * (-2.0), _209, fma(ra, ra, dot(p, p)))) - rb;
    }

    static inline __attribute__((always_inline))
    float3 map(thread float2& p, constant fs_uniforms& _408)
    {
        p *= 100.0;
        p.y -= 30.0;
        float2 _356 = float2(abs(p.x), p.y);
        float2 param = p * 0.300000011920928955078125;
        float3 ocol = background(param);
        float2 param_1 = p - float2(0.0, -97.0);
        float2 param_2 = float2(55.0, 20.0);
        float param_3 = 2.0;
        float _374 = sd_ellipsoid(param_1, param_2, param_3);
        float d = _374;
        float3 param_4 = float3(0.61000001430511474609375, 0.85000002384185791015625, 0.939999997615814208984375);
        float3 param_5 = ocol;
        float param_6 = _374;
        ocol = blend(param_4, param_5, param_6);
        float2 q = _356;
        float2 param_7 = _356;
        float2 param_8 = float2(55.0, 45.0);
        float param_9 = 2.400000095367431640625;
        d = sd_ellipsoid(param_7, param_8, param_9);
        float2 _398 = q - float2(45.0, -15.0);
        float _400 = _398.x;
        float _415 = sin(_408.iTime);
        _398.y = fma((_400 * _400) * 0.0030000000260770320892333984375, _415, _398.y);
        q = _398;
        float2 param_10 = _398;
        float2 param_11 = float2(0.0);
        float2 param_12 = float2(45.0, 0.0);
        d = fast::min(d, sd_line(param_10, param_11, param_12) - 0.20000000298023223876953125);
        float2 _922 = q;
        _922.y = fma((_922.x * _922.x) * 0.0030000000260770320892333984375, sin(_408.iTime * 2.0), _922.y + 6.0);
        q = _922;
        float2 param_13 = _922;
        float2 param_14 = float2(0.0);
        float2 param_15 = float2(45.0, 0.0);
        d = fast::min(d, sd_line(param_13, param_14, param_15) - 0.20000000298023223876953125);
        float2 _466 = _356 - float2(32.0, 30.0);
        q = _466;
        float2 param_16 = _466;
        float param_17 = fma(_415, 0.300000011920928955078125, 0.699999988079071044921875);
        float2 _476 = rotate(param_16, param_17);
        q = _476;
        float2 param_18 = _476;
        float param_19 = 30.0;
        float param_20 = 15.0;
        float _482 = sd_vesica(param_18, param_19, param_20);
        float _483 = d;
        float _485 = fast::min(_483, _482);
        d = _485;
        float3 param_21 = float3(0.119999997317790985107421875);
        float3 param_22 = ocol;
        float param_23 = _485;
        ocol = blend(param_21, param_22, param_23);
        q = _356;
        float2 param_24 = _356 - float2(0.0, -60.0);
        float2 param_25 = float2(27.0, 20.0);
        float param_26 = 2.0;
        d = sd_ellipsoid(param_24, param_25, param_26);
        float2 param_27 = q - float2(0.0, -70.0);
        float2 param_28 = float2(20.0, 16.0);
        float param_29 = 2.0;
        d = fast::max(-sd_ellipsoid(param_27, param_28, param_29), d);
        float2 _522 = _356 - float2(6.0, -50.0);
        q = _522;
        float2 param_30 = _522;
        float param_31 = fma(0.5, _415, 0.5) * (-0.100000001490116119384765625);
        float2 _534 = rotate(param_30, param_31);
        _534.x = fma(-pow(fast::max((-45.0) - _534.y, 0.0), 1.89999997615814208984375), 0.100000001490116119384765625, _534.x);
        q = _534;
        float2 param_32 = _534;
        float2 param_33 = float2(0.0, -50.0);
        float2 param_34 = float2(0.0);
        float param_35 = d;
        float param_36 = sd_line(param_32, param_33, param_34) - 5.0;
        float param_37 = 1.0;
        d = smin(param_35, param_36, param_37);
        float2 _564 = _356 - float2(22.0, -60.0);
        q = _564;
        float2 param_38 = _564;
        float param_39 = fma(0.5, cos(_408.iTime), 0.5) * (-0.100000001490116119384765625);
        float2 _575 = rotate(param_38, param_39);
        _575.x = fma(-pow(fast::max((-29.0) - _575.y, 0.0), 1.89999997615814208984375), 0.100000001490116119384765625, _575.x);
        q = _575;
        float2 param_40 = _575;
        float2 param_41 = float2(0.0, -35.0);
        float2 param_42 = float2(0.0);
        float param_43 = d;
        float param_44 = sd_line(param_40, param_41, param_42) - 5.0;
        float param_45 = 1.0;
        d = smin(param_43, param_44, param_45);
        float2 _604 = p - float2(-26.0, -60.0);
        q = _604;
        float2 param_46 = _604;
        float param_47 = 2.19911479949951171875;
        float2 _609 = rotate(param_46, param_47);
        float _611 = _609.y;
        _609.x = _609.x - fma(sin(fma(_611, 0.123000003397464752197265625, 3.0)), 4.0, sin(fma(_611, 0.100000001490116119384765625, _408.iTime * 10.0)));
        q = _609;
        float2 param_48 = _609;
        float2 param_49 = float2(0.0, -40.0);
        float2 param_50 = float2(0.0);
        float param_51 = d;
        float param_52 = fma(-5.0, smoothstep(-60.0, 0.0, q.y), sd_line(param_48, param_49, param_50));
        float param_53 = 1.0;
        float _650 = smin(param_51, param_52, param_53);
        d = _650;
        float3 param_54 = float3(0.119999997317790985107421875);
        float3 param_55 = ocol;
        float param_56 = _650;
        ocol = blend(param_54, param_55, param_56);
        float2 param_57 = q - float2(-2.0, -4.0);
        float param_58 = 1.2999999523162841796875;
        float _665 = sd_circle(param_57, param_58);
        d = _665;
        float2 param_59 = q - float2(-2.0, -9.0);
        float param_60 = 1.2000000476837158203125;
        float _675 = fast::min(_665, sd_circle(param_59, param_60));
        d = _675;
        float2 param_61 = q - float2(-2.0, -15.0);
        float param_62 = 1.10000002384185791015625;
        float _684 = fast::min(_675, sd_circle(param_61, param_62));
        d = _684;
        float2 param_63 = q - float2(-2.0, -20.0);
        float param_64 = 1.0;
        float _693 = fast::min(_684, sd_circle(param_63, param_64));
        d = _693;
        float2 param_65 = q - float2(-1.60000002384185791015625, -25.0);
        float param_66 = 0.89999997615814208984375;
        float _704 = fast::min(_693, sd_circle(param_65, param_66));
        d = _704;
        float2 param_67 = q - float2(-1.2999999523162841796875, -29.0);
        float param_68 = 0.800000011920928955078125;
        float _714 = fast::min(_704, sd_circle(param_67, param_68));
        d = _714;
        float2 param_69 = q - float2(-0.89999997615814208984375, -33.0);
        float param_70 = 0.699999988079071044921875;
        float _724 = fast::min(_714, sd_circle(param_69, param_70));
        d = _724;
        float2 param_71 = q - float2(-0.800000011920928955078125, -37.0);
        float param_72 = 0.60000002384185791015625;
        float _735 = fast::min(_724, sd_circle(param_71, param_72));
        d = _735;
        float3 param_73 = float3(0.61000001430511474609375, 0.85000002384185791015625, 0.939999997615814208984375);
        float3 param_74 = ocol;
        float param_75 = _735;
        ocol = blend(param_73, param_74, param_75);
        float2 _946 = _356;
        _946.y = p.y - (-11.0);
        q = _946;
        float2 param_76 = _946 - float2(0.0, -5.0);
        float2 param_77 = float2(40.0, 20.0);
        float param_78 = 2.900000095367431640625;
        d = sd_ellipsoid(param_76, param_77, param_78);
        float2 param_79 = q - float2(21.0, 0.0);
        float param_80 = 20.0;
        float param_81 = d;
        float param_82 = sd_circle(param_79, param_80);
        float param_83 = 5.0;
        float _770 = smin(param_81, param_82, param_83);
        d = _770;
        float3 param_84 = float3(0.980000019073486328125, 0.790000021457672119140625, 0.689999997615814208984375);
        float3 param_85 = ocol;
        float param_86 = _770;
        ocol = blend(param_84, param_85, param_86);
        float2 param_87 = q - float2(0.0, fma(_415, 0.5, -12.0));
        float param_88 = 2.0;
        d = sd_circle(param_87, param_88);
        float2 param_89 = q - float2(0.0, -18.0);
        float param_90 = fma(_415, 0.300000011920928955078125, 3.1415927410125732421875);
        float param_91 = 0.300000011920928955078125;
        float param_92 = 4.0;
        float param_93 = 0.4000000059604644775390625;
        float _809 = sd_arc(param_89, param_90, param_91, param_92, param_93);
        float _810 = d;
        float _812 = fast::min(_810, _809);
        d = _812;
        float3 param_94 = float3(0.670000016689300537109375, 0.36000001430511474609375, 0.319999992847442626953125);
        float3 param_95 = ocol;
        float param_96 = _812;
        ocol = blend(param_94, param_95, param_96);
        float2 _952 = _356;
        _952.y = (p.y - (-12.0)) / (1.0 - smoothstep(0.980000019073486328125, 1.0, sin(_408.iTime * 3.0)));
        q = _952;
        float2 param_97 = _952 - float2(20.0, 0.0);
        float2 param_98 = float2(9.0, 12.0);
        float param_99 = 2.0;
        float _847 = sd_ellipsoid(param_97, param_98, param_99);
        d = _847;
        float3 param_100 = float3(1.0);
        float3 param_101 = ocol;
        float param_102 = _847;
        ocol = blend(param_100, param_101, param_102);
        float2 param_103 = q - float2(19.5, 0.0);
        float2 param_104 = float2(5.0, 8.0);
        float param_105 = 2.0;
        float _864 = sd_ellipsoid(param_103, param_104, param_105);
        d = _864;
        float3 param_106 = float3(0.670000016689300537109375, 0.36000001430511474609375, 0.319999992847442626953125);
        float3 param_107 = ocol;
        float param_108 = _864;
        ocol = blend(param_106, param_107, param_108);
        float2 _873 = p - float2(-2.0, 0.0);
        _873.x = abs(_873.x);
        q = _873;
        float2 param_109 = _873 - float2(19.5, -8.0);
        float param_110 = 1.2999999523162841796875;
        float _884 = sd_circle(param_109, param_110);
        d = _884;
        float3 param_111 = float3(1.0);
        float3 param_112 = ocol;
        float param_113 = _884;
        float3 _890 = blend(param_111, param_112, param_113);
        ocol = _890;
        return _890;
    }

    fragment main0_out main0(main0_in in [[stage_in]], constant fs_uniforms& _408 [[buffer(0)]])
    {
        main0_out out = {};
        float2 param = in.fragPos;
        float3 _899 = map(param, _408);
        out.fragColor = float4(_899, 1.0);
        return out;
    }

*/
static const uint8_t sdf_fs_source_metal_ios[12712] = {
    0x23,0x70,0x72,0x61,0x67,0x6d,0x61,0x20,0x63,0x6c,0x61,0x6e,0x67,0x20,0x64,0x69,
    0x61,0x67,0x6e,0x6f,0x73,0x74,0x69,0x63,0x20,0x69,0x67,0x6e,0x6f,0x72,0x65,0x64,
    0x20,0x22,0x2d,0x57,0x6d,0x69,0x73,0x73,0x69,0x6e,0x67,0x2d,0x70,0x72,0x6f,0x74,
    0x6f,0x74,0x79,0x70,0x65,0x73,0x22,0x0a,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,
    0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,
    0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,
    0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,
    0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,
    0x0a,0x2f,0x2f,0x20,0x49,0x6d,0x70,0x6c,0x65,0x6d,0x65,0x6e,0x74,0x61,0x74,0x69,
    0x6f,0x6e,0x20,0x6f,0x66,0x20,0x74,0x68,0x65,0x20,0x47,0x4c,0x53,0x4c,0x20,0x6d,
    0x6f,0x64,0x28,0x29,0x20,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x77,
    0x68,0x69,0x63,0x68,0x20,0x69,0x73,0x20,0x73,0x6c,0x69,0x67,0x68,0x74,0x6c,0x79,
    0x20,0x64,0x69,0x66,0x66,0x65,0x72,0x65,0x6e,0x74,0x20,0x74,0x68,0x61,0x6e,0x20,
    0x4d,0x65,0x74,0x61,0x6c,0x20,0x66,0x6d,0x6f,0x64,0x28,0x29,0x0a,0x74,0x65,0x6d,
    0x70,0x6c,0x61,0x74,0x65,0x3c,0x74,0x79,0x70,0x65,0x6e,0x61,0x6d,0x65,0x20,0x54,
    0x78,0x2c,0x20,0x74,0x79,0x70,0x65,0x6e,0x61,0x6d,0x65,0x20,0x54,0x79,0x3e,0x0a,
    0x69,0x6e,0x6c,0x69,0x6e,0x65,0x20,0x54,0x78,0x20,0x6d,0x6f,0x64,0x28,0x54,0x78,
    0x20,0x78,0x2c,0x20,0x54,0x79,0x20,0x79,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,
    0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x78,0x20,0x2d,0x20,0x79,0x20,0x2a,0x20,0x66,
    0x6c,0x6f,0x6f,0x72,0x28,0x78,0x20,0x2f,0x20,0x79,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,
    0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,
    0x6d,0x73,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x69,
    0x54,0x69,0x6d,0x65,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,
    0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,
    0x72,0x20,0x5b,0x5b,0x63,0x6f,0x6c,0x6f,0x72,0x28,0x30,0x29,0x5d,0x5d,0x3b,0x0a,
    0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,
    0x5f,0x69,0x6e,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x66,0x72,0x61,0x67,0x50,0x6f,0x73,0x20,0x5b,0x5b,0x75,0x73,0x65,0x72,0x28,
    0x6c,0x6f,0x63,0x6e,0x31,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,
    0x61,0x74,0x69,0x63,0x20,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x20,0x5f,0x5f,0x61,0x74,
    0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x5f,0x5f,0x28,0x28,0x61,0x6c,0x77,0x61,0x79,
    0x73,0x5f,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x29,0x29,0x0a,0x66,0x6c,0x6f,0x61,0x74,
    0x33,0x20,0x62,0x61,0x63,0x6b,0x67,0x72,0x6f,0x75,0x6e,0x64,0x28,0x74,0x68,0x72,
    0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x26,0x20,0x75,0x76,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x20,0x5f,0x33,0x31,0x35,0x20,0x3d,0x20,0x61,0x62,0x73,0x28,0x66,0x6c,
    0x6f,0x6f,0x72,0x28,0x75,0x76,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,
    0x74,0x75,0x72,0x6e,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x28,0x30,0x2e,0x33,0x38,
    0x39,0x39,0x39,0x39,0x39,0x38,0x35,0x36,0x39,0x34,0x38,0x38,0x35,0x32,0x35,0x33,
    0x39,0x30,0x36,0x32,0x35,0x29,0x20,0x2b,0x20,0x28,0x66,0x6c,0x6f,0x61,0x74,0x33,
    0x28,0x30,0x2e,0x31,0x37,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x37,0x38,0x38,0x31,
    0x33,0x39,0x33,0x34,0x33,0x32,0x36,0x31,0x37,0x31,0x38,0x37,0x35,0x29,0x20,0x2a,
    0x20,0x6d,0x6f,0x64,0x28,0x5f,0x33,0x31,0x35,0x2e,0x78,0x20,0x2b,0x20,0x5f,0x33,
    0x31,0x35,0x2e,0x79,0x2c,0x20,0x32,0x2e,0x30,0x29,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,
    0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x20,0x5f,0x5f,
    0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x5f,0x5f,0x28,0x28,0x61,0x6c,0x77,
    0x61,0x79,0x73,0x5f,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x29,0x29,0x0a,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x5f,0x6e,0x28,0x74,0x68,0x72,0x65,
    0x61,0x64,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x26,0x20,0x70,0x2c,0x20,0x74,0x68,
    0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x26,0x20,0x6e,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x70,0x20,0x3d,0x20,0x70,
    0x6f,0x77,0x28,0x61,0x62,0x73,0x28,0x70,0x29,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x28,0x6e,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,
    0x6e,0x20,0x70,0x6f,0x77,0x28,0x70,0x2e,0x78,0x20,0x2b,0x20,0x70,0x2e,0x79,0x2c,
    0x20,0x31,0x2e,0x30,0x20,0x2f,0x20,0x6e,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x73,0x74,
    0x61,0x74,0x69,0x63,0x20,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x20,0x5f,0x5f,0x61,0x74,
    0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x5f,0x5f,0x28,0x28,0x61,0x6c,0x77,0x61,0x79,
    0x73,0x5f,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x29,0x29,0x0a,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,0x64,0x28,0x74,0x68,
    0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x26,0x20,0x70,0x2c,0x20,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,
    0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x26,0x20,0x72,0x2c,0x20,0x74,0x68,
    0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x26,0x20,0x72,0x6f,0x75,0x6e,0x64,0x6e,0x65,0x73,0x73,0x29,0x0a,0x7b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x20,
    0x3d,0x20,0x70,0x20,0x2f,0x20,0x72,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x20,0x3d,0x20,0x72,0x6f,0x75,
    0x6e,0x64,0x6e,0x65,0x73,0x73,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x5f,0x31,0x30,0x33,0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x5f,
    0x6e,0x28,0x70,0x61,0x72,0x61,0x6d,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x32,0x20,0x3d,0x20,0x70,0x20,0x2f,0x20,0x28,0x72,0x20,0x2a,
    0x20,0x72,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x33,0x20,0x3d,0x20,0x72,0x6f,0x75,0x6e,0x64,0x6e,0x65,
    0x73,0x73,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,
    0x31,0x33,0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x5f,0x6e,0x28,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x32,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x28,0x5f,0x31,0x30,
    0x33,0x20,0x2a,0x20,0x28,0x5f,0x31,0x30,0x33,0x20,0x2d,0x20,0x31,0x2e,0x30,0x29,
    0x29,0x20,0x2f,0x20,0x5f,0x31,0x31,0x33,0x3b,0x0a,0x7d,0x0a,0x0a,0x73,0x74,0x61,
    0x74,0x69,0x63,0x20,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x20,0x5f,0x5f,0x61,0x74,0x74,
    0x72,0x69,0x62,0x75,0x74,0x65,0x5f,0x5f,0x28,0x28,0x61,0x6c,0x77,0x61,0x79,0x73,
    0x5f,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x29,0x29,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x33,
    0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,
    0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x26,0x20,0x63,0x6f,0x6c,0x2c,
    0x20,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x33,0x26,0x20,0x6f,0x63,0x6f,0x6c,0x2c,0x20,0x74,0x68,0x72,0x65,
    0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x26,0x20,
    0x64,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,
    0x6d,0x69,0x78,0x28,0x6f,0x63,0x6f,0x6c,0x2c,0x20,0x63,0x6f,0x6c,0x2c,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x33,0x28,0x73,0x6d,0x6f,0x6f,0x74,0x68,0x73,0x74,0x65,0x70,
    0x28,0x30,0x2e,0x35,0x2c,0x20,0x30,0x2e,0x30,0x2c,0x20,0x64,0x29,0x29,0x29,0x3b,
    0x0a,0x7d,0x0a,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x69,0x6e,0x6c,0x69,0x6e,
    0x65,0x20,0x5f,0x5f,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x5f,0x5f,0x28,
    0x28,0x61,0x6c,0x77,0x61,0x79,0x73,0x5f,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x29,0x29,
    0x0a,0x66,0x6c,0x6f,0x61,0x74,0x20,0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,0x28,0x74,
    0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x26,0x20,0x70,0x2c,0x20,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,
    0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x26,0x20,0x61,0x2c,0x20,0x74,
    0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x26,0x20,0x62,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x20,0x5f,0x32,0x34,0x30,0x20,0x3d,0x20,0x70,0x20,0x2d,0x20,0x61,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x32,0x34,
    0x34,0x20,0x3d,0x20,0x62,0x20,0x2d,0x20,0x61,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,
    0x65,0x74,0x75,0x72,0x6e,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x28,0x5f,0x32,0x34,
    0x30,0x20,0x2d,0x20,0x28,0x5f,0x32,0x34,0x34,0x20,0x2a,0x20,0x66,0x61,0x73,0x74,
    0x3a,0x3a,0x63,0x6c,0x61,0x6d,0x70,0x28,0x64,0x6f,0x74,0x28,0x5f,0x32,0x34,0x30,
    0x2c,0x20,0x5f,0x32,0x34,0x34,0x29,0x20,0x2f,0x20,0x64,0x6f,0x74,0x28,0x5f,0x32,
    0x34,0x34,0x2c,0x20,0x5f,0x32,0x34,0x34,0x29,0x2c,0x20,0x30,0x2e,0x30,0x2c,0x20,
    0x31,0x2e,0x30,0x29,0x29,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x73,0x74,0x61,0x74,0x69,
    0x63,0x20,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x20,0x5f,0x5f,0x61,0x74,0x74,0x72,0x69,
    0x62,0x75,0x74,0x65,0x5f,0x5f,0x28,0x28,0x61,0x6c,0x77,0x61,0x79,0x73,0x5f,0x69,
    0x6e,0x6c,0x69,0x6e,0x65,0x29,0x29,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x72,
    0x6f,0x74,0x61,0x74,0x65,0x28,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,
    0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x26,0x20,0x70,0x2c,0x20,0x74,0x68,
    0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x26,0x20,0x74,0x68,0x65,0x74,0x61,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x5f,0x32,0x36,0x34,0x20,0x3d,0x20,0x63,0x6f,0x73,0x28,
    0x74,0x68,0x65,0x74,0x61,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x5f,0x32,0x36,0x37,0x20,0x3d,0x20,0x73,0x69,0x6e,0x28,0x74,0x68,0x65,
    0x74,0x61,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x66,0x6d,0x61,0x28,0x70,0x2e,0x78,0x2c,0x20,
    0x5f,0x32,0x36,0x34,0x2c,0x20,0x2d,0x28,0x70,0x2e,0x79,0x20,0x2a,0x20,0x5f,0x32,
    0x36,0x37,0x29,0x29,0x2c,0x20,0x66,0x6d,0x61,0x28,0x70,0x2e,0x78,0x2c,0x20,0x5f,
    0x32,0x36,0x37,0x2c,0x20,0x70,0x2e,0x79,0x20,0x2a,0x20,0x5f,0x32,0x36,0x34,0x29,
    0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x69,0x6e,0x6c,
    0x69,0x6e,0x65,0x20,0x5f,0x5f,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x5f,
    0x5f,0x28,0x28,0x61,0x6c,0x77,0x61,0x79,0x73,0x5f,0x69,0x6e,0x6c,0x69,0x6e,0x65,
    0x29,0x29,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x20,0x73,0x64,0x5f,0x76,0x65,0x73,0x69,
    0x63,0x61,0x28,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x26,0x20,0x70,0x2c,0x20,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,
    0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x26,0x20,0x72,0x2c,0x20,0x74,0x68,0x72,0x65,
    0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x26,0x20,
    0x64,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x70,0x20,0x3d,0x20,0x61,0x62,0x73,
    0x28,0x70,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,
    0x31,0x33,0x32,0x20,0x3d,0x20,0x73,0x71,0x72,0x74,0x28,0x66,0x6d,0x61,0x28,0x72,
    0x2c,0x20,0x72,0x2c,0x20,0x2d,0x28,0x64,0x20,0x2a,0x20,0x64,0x29,0x29,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,0x34,0x35,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x28,0x28,0x70,0x2e,0x79,0x20,0x2d,
    0x20,0x5f,0x31,0x33,0x32,0x29,0x20,0x2a,0x20,0x64,0x29,0x20,0x3e,0x20,0x28,0x70,
    0x2e,0x78,0x20,0x2a,0x20,0x5f,0x31,0x33,0x32,0x29,0x29,0x0a,0x20,0x20,0x20,0x20,
    0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x31,0x34,0x35,0x20,0x3d,
    0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x28,0x70,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x28,0x30,0x2e,0x30,0x2c,0x20,0x5f,0x31,0x33,0x32,0x29,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,0x20,
    0x20,0x20,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x31,0x34,
    0x35,0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x28,0x70,0x20,0x2d,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x28,0x2d,0x64,0x2c,0x20,0x30,0x2e,0x30,0x29,0x29,0x20,
    0x2d,0x20,0x72,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,0x20,0x20,0x20,0x72,
    0x65,0x74,0x75,0x72,0x6e,0x20,0x5f,0x31,0x34,0x35,0x3b,0x0a,0x7d,0x0a,0x0a,0x73,
    0x74,0x61,0x74,0x69,0x63,0x20,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x20,0x5f,0x5f,0x61,
    0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x5f,0x5f,0x28,0x28,0x61,0x6c,0x77,0x61,
    0x79,0x73,0x5f,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x29,0x29,0x0a,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x73,0x6d,0x69,0x6e,0x28,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,
    0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x26,0x20,0x61,0x2c,0x20,0x74,0x68,
    0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x26,0x20,0x62,0x2c,0x20,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,
    0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x26,0x20,0x6b,0x29,0x0a,0x7b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x32,0x39,0x38,0x20,0x3d,0x20,0x66,
    0x61,0x73,0x74,0x3a,0x3a,0x6d,0x61,0x78,0x28,0x6b,0x20,0x2d,0x20,0x61,0x62,0x73,
    0x28,0x61,0x20,0x2d,0x20,0x62,0x29,0x2c,0x20,0x30,0x2e,0x30,0x29,0x20,0x2f,0x20,
    0x6b,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x66,0x6d,
    0x61,0x28,0x2d,0x28,0x28,0x5f,0x32,0x39,0x38,0x20,0x2a,0x20,0x5f,0x32,0x39,0x38,
    0x29,0x20,0x2a,0x20,0x6b,0x29,0x2c,0x20,0x30,0x2e,0x32,0x35,0x2c,0x20,0x66,0x61,
    0x73,0x74,0x3a,0x3a,0x6d,0x69,0x6e,0x28,0x61,0x2c,0x20,0x62,0x29,0x29,0x3b,0x0a,
    0x7d,0x0a,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x69,0x6e,0x6c,0x69,0x6e,0x65,
    0x20,0x5f,0x5f,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x5f,0x5f,0x28,0x28,
    0x61,0x6c,0x77,0x61,0x79,0x73,0x5f,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x29,0x29,0x0a,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,
    0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x26,0x20,0x70,0x2c,0x20,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,
    0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x26,0x20,0x72,0x29,0x0a,0x7b,
    0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6c,0x65,0x6e,0x67,
    0x74,0x68,0x28,0x70,0x29,0x20,0x2d,0x20,0x72,0x3b,0x0a,0x7d,0x0a,0x0a,0x73,0x74,
    0x61,0x74,0x69,0x63,0x20,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x20,0x5f,0x5f,0x61,0x74,
    0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x5f,0x5f,0x28,0x28,0x61,0x6c,0x77,0x61,0x79,
    0x73,0x5f,0x69,0x6e,0x6c,0x69,0x6e,0x65,0x29,0x29,0x0a,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x73,0x64,0x5f,0x61,0x72,0x63,0x28,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x26,0x20,0x70,0x2c,0x20,0x74,0x68,0x72,0x65,0x61,0x64,
    0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x26,0x20,0x74,0x61,
    0x2c,0x20,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x26,0x20,0x74,0x62,0x2c,0x20,0x74,0x68,0x72,0x65,0x61,0x64,
    0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,0x61,0x74,0x26,0x20,0x72,0x61,
    0x2c,0x20,0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x26,0x20,0x72,0x62,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,0x36,0x38,0x20,0x3d,0x20,0x63,0x6f,0x73,
    0x28,0x74,0x61,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x5f,0x31,0x37,0x30,0x20,0x3d,0x20,0x73,0x69,0x6e,0x28,0x74,0x61,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x31,0x37,0x34,0x20,0x3d,
    0x20,0x63,0x6f,0x73,0x28,0x74,0x62,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x5f,0x31,0x37,0x36,0x20,0x3d,0x20,0x73,0x69,0x6e,0x28,0x74,
    0x62,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x70,0x20,0x2a,0x3d,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x78,0x32,0x28,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x5f,0x31,0x36,
    0x38,0x2c,0x20,0x5f,0x31,0x37,0x30,0x29,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x28,0x2d,0x5f,0x31,0x37,0x30,0x2c,0x20,0x5f,0x31,0x36,0x38,0x29,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x70,0x2e,0x78,0x20,0x3d,0x20,0x61,0x62,0x73,0x28,0x70,0x2e,
    0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x32,
    0x30,0x39,0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x66,0x20,0x28,0x28,0x5f,0x31,0x37,
    0x36,0x20,0x2a,0x20,0x70,0x2e,0x78,0x29,0x20,0x3e,0x20,0x28,0x5f,0x31,0x37,0x34,
    0x20,0x2a,0x20,0x70,0x2e,0x79,0x29,0x29,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x32,0x30,0x39,0x20,0x3d,0x20,0x64,0x6f,
    0x74,0x28,0x70,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x5f,0x31,0x37,0x34,
    0x2c,0x20,0x5f,0x31,0x37,0x36,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,
    0x20,0x20,0x20,0x20,0x65,0x6c,0x73,0x65,0x0a,0x20,0x20,0x20,0x20,0x7b,0x0a,0x20,
    0x20,0x20,0x20,0x20,0x20,0x20,0x20,0x5f,0x32,0x30,0x39,0x20,0x3d,0x20,0x6c,0x65,
    0x6e,0x67,0x74,0x68,0x28,0x70,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x7d,0x0a,0x20,
    0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x73,0x71,0x72,0x74,0x28,0x66,
    0x6d,0x61,0x28,0x72,0x61,0x20,0x2a,0x20,0x28,0x2d,0x32,0x2e,0x30,0x29,0x2c,0x20,
    0x5f,0x32,0x30,0x39,0x2c,0x20,0x66,0x6d,0x61,0x28,0x72,0x61,0x2c,0x20,0x72,0x61,
    0x2c,0x20,0x64,0x6f,0x74,0x28,0x70,0x2c,0x20,0x70,0x29,0x29,0x29,0x29,0x20,0x2d,
    0x20,0x72,0x62,0x3b,0x0a,0x7d,0x0a,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x69,
    0x6e,0x6c,0x69,0x6e,0x65,0x20,0x5f,0x5f,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,
    0x65,0x5f,0x5f,0x28,0x28,0x61,0x6c,0x77,0x61,0x79,0x73,0x5f,0x69,0x6e,0x6c,0x69,
    0x6e,0x65,0x29,0x29,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x6d,0x61,0x70,0x28,
    0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x26,0x20,0x70,
    0x2c,0x20,0x63,0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,0x20,0x66,0x73,0x5f,0x75,0x6e,
    0x69,0x66,0x6f,0x72,0x6d,0x73,0x26,0x20,0x5f,0x34,0x30,0x38,0x29,0x0a,0x7b,0x0a,
    0x20,0x20,0x20,0x20,0x70,0x20,0x2a,0x3d,0x20,0x31,0x30,0x30,0x2e,0x30,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x70,0x2e,0x79,0x20,0x2d,0x3d,0x20,0x33,0x30,0x2e,0x30,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x33,0x35,0x36,
    0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x61,0x62,0x73,0x28,0x70,0x2e,
    0x78,0x29,0x2c,0x20,0x70,0x2e,0x79,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x20,0x3d,0x20,0x70,0x20,0x2a,
    0x20,0x30,0x2e,0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,
    0x32,0x38,0x39,0x35,0x35,0x30,0x37,0x38,0x31,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,
    0x61,0x63,0x6b,0x67,0x72,0x6f,0x75,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x20,0x3d,0x20,0x70,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x28,0x30,0x2e,0x30,0x2c,0x20,0x2d,0x39,0x37,0x2e,0x30,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x32,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x35,0x35,0x2e,0x30,0x2c,
    0x20,0x32,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x20,0x3d,0x20,0x32,0x2e,0x30,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x33,0x37,0x34,0x20,
    0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,0x64,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x64,0x20,0x3d,0x20,0x5f,0x33,0x37,0x34,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x34,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x28,0x30,0x2e,0x36,0x31,0x30,
    0x30,0x30,0x30,0x30,0x31,0x34,0x33,0x30,0x35,0x31,0x31,0x34,0x37,0x34,0x36,0x30,
    0x39,0x33,0x37,0x35,0x2c,0x20,0x30,0x2e,0x38,0x35,0x30,0x30,0x30,0x30,0x30,0x32,
    0x33,0x38,0x34,0x31,0x38,0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,0x32,0x35,0x2c,
    0x20,0x30,0x2e,0x39,0x33,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,0x31,0x35,0x38,
    0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,
    0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x20,0x3d,0x20,0x5f,0x33,0x37,
    0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,
    0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x35,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x71,0x20,0x3d,0x20,0x5f,
    0x33,0x35,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x38,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x35,0x35,0x2e,0x30,
    0x2c,0x20,0x34,0x35,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x20,0x3d,0x20,0x32,0x2e,0x34,
    0x30,0x30,0x30,0x30,0x30,0x30,0x39,0x35,0x33,0x36,0x37,0x34,0x33,0x31,0x36,0x34,
    0x30,0x36,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x64,
    0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x37,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x39,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x20,0x5f,0x33,0x39,0x38,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x28,0x34,0x35,0x2e,0x30,0x2c,0x20,0x2d,0x31,0x35,0x2e,0x30,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,0x30,0x30,
    0x20,0x3d,0x20,0x5f,0x33,0x39,0x38,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,0x31,0x35,0x20,0x3d,0x20,0x73,0x69,0x6e,0x28,
    0x5f,0x34,0x30,0x38,0x2e,0x69,0x54,0x69,0x6d,0x65,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x5f,0x33,0x39,0x38,0x2e,0x79,0x20,0x3d,0x20,0x66,0x6d,0x61,0x28,0x28,0x5f,
    0x34,0x30,0x30,0x20,0x2a,0x20,0x5f,0x34,0x30,0x30,0x29,0x20,0x2a,0x20,0x30,0x2e,
    0x30,0x30,0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x36,0x30,0x37,0x37,0x30,
    0x33,0x32,0x30,0x38,0x39,0x32,0x33,0x33,0x33,0x39,0x38,0x34,0x33,0x37,0x35,0x2c,
    0x20,0x5f,0x34,0x31,0x35,0x2c,0x20,0x5f,0x33,0x39,0x38,0x2e,0x79,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x33,0x39,0x38,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x30,0x20,0x3d,0x20,0x5f,0x33,0x39,0x38,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x20,0x3d,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x32,
    0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x34,0x35,0x2e,0x30,0x2c,0x20,
    0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x66,0x61,
    0x73,0x74,0x3a,0x3a,0x6d,0x69,0x6e,0x28,0x64,0x2c,0x20,0x73,0x64,0x5f,0x6c,0x69,
    0x6e,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x32,0x29,
    0x20,0x2d,0x20,0x30,0x2e,0x32,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x39,0x38,
    0x30,0x32,0x33,0x32,0x32,0x33,0x38,0x37,0x36,0x39,0x35,0x33,0x31,0x32,0x35,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x39,0x32,
    0x32,0x20,0x3d,0x20,0x71,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x39,0x32,0x32,0x2e,
    0x79,0x20,0x3d,0x20,0x66,0x6d,0x61,0x28,0x28,0x5f,0x39,0x32,0x32,0x2e,0x78,0x20,
    0x2a,0x20,0x5f,0x39,0x32,0x32,0x2e,0x78,0x29,0x20,0x2a,0x20,0x30,0x2e,0x30,0x30,
    0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x36,0x30,0x37,0x37,0x30,0x33,0x32,
    0x30,0x38,0x39,0x32,0x33,0x33,0x33,0x39,0x38,0x34,0x33,0x37,0x35,0x2c,0x20,0x73,
    0x69,0x6e,0x28,0x5f,0x34,0x30,0x38,0x2e,0x69,0x54,0x69,0x6d,0x65,0x20,0x2a,0x20,
    0x32,0x2e,0x30,0x29,0x2c,0x20,0x5f,0x39,0x32,0x32,0x2e,0x79,0x20,0x2b,0x20,0x36,
    0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x39,0x32,
    0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x31,0x33,0x20,0x3d,0x20,0x5f,0x39,0x32,0x32,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x31,0x34,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,0x30,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x35,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x34,
    0x35,0x2e,0x30,0x2c,0x20,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,
    0x20,0x3d,0x20,0x66,0x61,0x73,0x74,0x3a,0x3a,0x6d,0x69,0x6e,0x28,0x64,0x2c,0x20,
    0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x33,
    0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x31,0x35,0x29,0x20,0x2d,0x20,0x30,0x2e,0x32,0x30,0x30,0x30,0x30,0x30,
    0x30,0x30,0x32,0x39,0x38,0x30,0x32,0x33,0x32,0x32,0x33,0x38,0x37,0x36,0x39,0x35,
    0x33,0x31,0x32,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x20,0x5f,0x34,0x36,0x36,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x20,0x2d,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x33,0x32,0x2e,0x30,0x2c,0x20,0x33,0x30,0x2e,
    0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x34,0x36,0x36,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x36,0x20,0x3d,0x20,0x5f,0x34,0x36,0x36,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x37,
    0x20,0x3d,0x20,0x66,0x6d,0x61,0x28,0x5f,0x34,0x31,0x35,0x2c,0x20,0x30,0x2e,0x33,
    0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,0x38,0x39,0x35,
    0x35,0x30,0x37,0x38,0x31,0x32,0x35,0x2c,0x20,0x30,0x2e,0x36,0x39,0x39,0x39,0x39,
    0x39,0x39,0x38,0x38,0x30,0x37,0x39,0x30,0x37,0x31,0x30,0x34,0x34,0x39,0x32,0x31,
    0x38,0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x5f,0x34,0x37,0x36,0x20,0x3d,0x20,0x72,0x6f,0x74,0x61,0x74,0x65,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x36,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x37,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x34,0x37,0x36,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x38,0x20,0x3d,0x20,0x5f,0x34,0x37,0x36,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x39,
    0x20,0x3d,0x20,0x33,0x30,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x30,0x20,0x3d,0x20,0x31,0x35,
    0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,
    0x38,0x32,0x20,0x3d,0x20,0x73,0x64,0x5f,0x76,0x65,0x73,0x69,0x63,0x61,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x38,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x39,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x30,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,0x38,0x33,0x20,0x3d,0x20,0x64,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,0x38,0x35,
    0x20,0x3d,0x20,0x66,0x61,0x73,0x74,0x3a,0x3a,0x6d,0x69,0x6e,0x28,0x5f,0x34,0x38,
    0x33,0x2c,0x20,0x5f,0x34,0x38,0x32,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,
    0x3d,0x20,0x5f,0x34,0x38,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x31,0x20,0x3d,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x33,0x28,0x30,0x2e,0x31,0x31,0x39,0x39,0x39,0x39,0x39,0x39,0x37,
    0x33,0x31,0x37,0x37,0x39,0x30,0x39,0x38,0x35,0x31,0x30,0x37,0x34,0x32,0x31,0x38,
    0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x32,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x32,0x33,0x20,0x3d,0x20,0x5f,0x34,0x38,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x32,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x32,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x33,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x71,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x34,0x20,0x3d,0x20,
    0x5f,0x33,0x35,0x36,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,
    0x30,0x2c,0x20,0x2d,0x36,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x35,0x20,0x3d,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x32,0x37,0x2e,0x30,0x2c,0x20,0x32,0x30,
    0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x32,0x36,0x20,0x3d,0x20,0x32,0x2e,0x30,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,
    0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x34,0x2c,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x32,0x35,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x36,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x32,0x37,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x28,0x30,0x2e,0x30,0x2c,0x20,0x2d,0x37,0x30,0x2e,0x30,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x32,0x38,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x32,0x30,
    0x2e,0x30,0x2c,0x20,0x31,0x36,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x39,0x20,0x3d,0x20,
    0x32,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x66,0x61,0x73,
    0x74,0x3a,0x3a,0x6d,0x61,0x78,0x28,0x2d,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,
    0x73,0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x37,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x32,0x38,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,
    0x39,0x29,0x2c,0x20,0x64,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x20,0x5f,0x35,0x32,0x32,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x20,0x2d,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x36,0x2e,0x30,0x2c,0x20,0x2d,0x35,0x30,
    0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x35,0x32,
    0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x33,0x30,0x20,0x3d,0x20,0x5f,0x35,0x32,0x32,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,
    0x31,0x20,0x3d,0x20,0x66,0x6d,0x61,0x28,0x30,0x2e,0x35,0x2c,0x20,0x5f,0x34,0x31,
    0x35,0x2c,0x20,0x30,0x2e,0x35,0x29,0x20,0x2a,0x20,0x28,0x2d,0x30,0x2e,0x31,0x30,
    0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x39,0x30,0x31,0x31,0x36,0x31,0x31,0x39,
    0x33,0x38,0x34,0x37,0x36,0x35,0x36,0x32,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x35,0x33,0x34,0x20,0x3d,0x20,0x72,0x6f,
    0x74,0x61,0x74,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x30,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x33,0x31,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x35,
    0x33,0x34,0x2e,0x78,0x20,0x3d,0x20,0x66,0x6d,0x61,0x28,0x2d,0x70,0x6f,0x77,0x28,
    0x66,0x61,0x73,0x74,0x3a,0x3a,0x6d,0x61,0x78,0x28,0x28,0x2d,0x34,0x35,0x2e,0x30,
    0x29,0x20,0x2d,0x20,0x5f,0x35,0x33,0x34,0x2e,0x79,0x2c,0x20,0x30,0x2e,0x30,0x29,
    0x2c,0x20,0x31,0x2e,0x38,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,0x31,0x35,0x38,
    0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x29,0x2c,0x20,0x30,0x2e,
    0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x39,0x30,0x31,0x31,0x36,0x31,
    0x31,0x39,0x33,0x38,0x34,0x37,0x36,0x35,0x36,0x32,0x35,0x2c,0x20,0x5f,0x35,0x33,
    0x34,0x2e,0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x35,
    0x33,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x33,0x32,0x20,0x3d,0x20,0x5f,0x35,0x33,0x34,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x33,0x33,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,0x30,
    0x2c,0x20,0x2d,0x35,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x34,0x20,0x3d,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x35,0x20,
    0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x33,0x36,0x20,0x3d,0x20,0x73,0x64,0x5f,0x6c,0x69,0x6e,
    0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x32,0x2c,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x33,0x33,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x34,0x29,0x20,
    0x2d,0x20,0x35,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x37,0x20,0x3d,0x20,0x31,0x2e,0x30,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x6d,0x69,0x6e,0x28,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x33,0x35,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x36,
    0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x37,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x35,0x36,0x34,0x20,0x3d,0x20,0x5f,
    0x33,0x35,0x36,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x32,0x32,0x2e,
    0x30,0x2c,0x20,0x2d,0x36,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,
    0x20,0x3d,0x20,0x5f,0x35,0x36,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x38,0x20,0x3d,0x20,0x5f,
    0x35,0x36,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x33,0x39,0x20,0x3d,0x20,0x66,0x6d,0x61,0x28,0x30,0x2e,
    0x35,0x2c,0x20,0x63,0x6f,0x73,0x28,0x5f,0x34,0x30,0x38,0x2e,0x69,0x54,0x69,0x6d,
    0x65,0x29,0x2c,0x20,0x30,0x2e,0x35,0x29,0x20,0x2a,0x20,0x28,0x2d,0x30,0x2e,0x31,
    0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x39,0x30,0x31,0x31,0x36,0x31,0x31,
    0x39,0x33,0x38,0x34,0x37,0x36,0x35,0x36,0x32,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x35,0x37,0x35,0x20,0x3d,0x20,0x72,
    0x6f,0x74,0x61,0x74,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x38,0x2c,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x39,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,
    0x35,0x37,0x35,0x2e,0x78,0x20,0x3d,0x20,0x66,0x6d,0x61,0x28,0x2d,0x70,0x6f,0x77,
    0x28,0x66,0x61,0x73,0x74,0x3a,0x3a,0x6d,0x61,0x78,0x28,0x28,0x2d,0x32,0x39,0x2e,
    0x30,0x29,0x20,0x2d,0x20,0x5f,0x35,0x37,0x35,0x2e,0x79,0x2c,0x20,0x30,0x2e,0x30,
    0x29,0x2c,0x20,0x31,0x2e,0x38,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,0x31,0x35,
    0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x29,0x2c,0x20,0x30,
    0x2e,0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x39,0x30,0x31,0x31,0x36,
    0x31,0x31,0x39,0x33,0x38,0x34,0x37,0x36,0x35,0x36,0x32,0x35,0x2c,0x20,0x5f,0x35,
    0x37,0x35,0x2e,0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,
    0x35,0x37,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x30,0x20,0x3d,0x20,0x5f,0x35,0x37,0x35,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x34,0x31,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,
    0x30,0x2c,0x20,0x2d,0x33,0x35,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x32,0x20,0x3d,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x33,
    0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x34,0x20,0x3d,0x20,0x73,0x64,0x5f,0x6c,0x69,
    0x6e,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x30,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x34,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x32,0x29,
    0x20,0x2d,0x20,0x35,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x35,0x20,0x3d,0x20,0x31,0x2e,0x30,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x6d,0x69,0x6e,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x34,0x33,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,
    0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x35,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x36,0x30,0x34,0x20,0x3d,0x20,
    0x70,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x2d,0x32,0x36,0x2e,0x30,
    0x2c,0x20,0x2d,0x36,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,
    0x3d,0x20,0x5f,0x36,0x30,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x36,0x20,0x3d,0x20,0x5f,0x36,
    0x30,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x34,0x37,0x20,0x3d,0x20,0x32,0x2e,0x31,0x39,0x39,0x31,0x31,
    0x34,0x37,0x39,0x39,0x34,0x39,0x39,0x35,0x31,0x31,0x37,0x31,0x38,0x37,0x35,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x36,0x30,0x39,
    0x20,0x3d,0x20,0x72,0x6f,0x74,0x61,0x74,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x34,0x36,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x37,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x31,0x31,0x20,0x3d,0x20,
    0x5f,0x36,0x30,0x39,0x2e,0x79,0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x36,0x30,0x39,
    0x2e,0x78,0x20,0x3d,0x20,0x5f,0x36,0x30,0x39,0x2e,0x78,0x20,0x2d,0x20,0x66,0x6d,
    0x61,0x28,0x73,0x69,0x6e,0x28,0x66,0x6d,0x61,0x28,0x5f,0x36,0x31,0x31,0x2c,0x20,
    0x30,0x2e,0x31,0x32,0x33,0x30,0x30,0x30,0x30,0x30,0x33,0x33,0x39,0x37,0x34,0x36,
    0x34,0x37,0x35,0x32,0x31,0x39,0x37,0x32,0x36,0x35,0x36,0x32,0x35,0x2c,0x20,0x33,
    0x2e,0x30,0x29,0x29,0x2c,0x20,0x34,0x2e,0x30,0x2c,0x20,0x73,0x69,0x6e,0x28,0x66,
    0x6d,0x61,0x28,0x5f,0x36,0x31,0x31,0x2c,0x20,0x30,0x2e,0x31,0x30,0x30,0x30,0x30,
    0x30,0x30,0x30,0x31,0x34,0x39,0x30,0x31,0x31,0x36,0x31,0x31,0x39,0x33,0x38,0x34,
    0x37,0x36,0x35,0x36,0x32,0x35,0x2c,0x20,0x5f,0x34,0x30,0x38,0x2e,0x69,0x54,0x69,
    0x6d,0x65,0x20,0x2a,0x20,0x31,0x30,0x2e,0x30,0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,0x36,0x30,0x39,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x38,0x20,
    0x3d,0x20,0x5f,0x36,0x30,0x39,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x39,0x20,0x3d,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,0x30,0x2c,0x20,0x2d,0x34,0x30,0x2e,0x30,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x35,0x30,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,
    0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x35,0x31,0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x32,0x20,
    0x3d,0x20,0x66,0x6d,0x61,0x28,0x2d,0x35,0x2e,0x30,0x2c,0x20,0x73,0x6d,0x6f,0x6f,
    0x74,0x68,0x73,0x74,0x65,0x70,0x28,0x2d,0x36,0x30,0x2e,0x30,0x2c,0x20,0x30,0x2e,
    0x30,0x2c,0x20,0x71,0x2e,0x79,0x29,0x2c,0x20,0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,
    0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x38,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x34,0x39,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x30,0x29,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x35,0x33,0x20,0x3d,0x20,0x31,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x35,0x30,0x20,0x3d,0x20,0x73,0x6d,0x69,0x6e,
    0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x35,0x32,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x33,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x36,0x35,0x30,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,
    0x34,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x28,0x30,0x2e,0x31,0x31,0x39,
    0x39,0x39,0x39,0x39,0x39,0x37,0x33,0x31,0x37,0x37,0x39,0x30,0x39,0x38,0x35,0x31,
    0x30,0x37,0x34,0x32,0x31,0x38,0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x35,0x20,0x3d,
    0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x36,0x20,0x3d,0x20,0x5f,0x36,0x35,0x30,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,
    0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x34,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x35,0x35,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x36,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x35,0x37,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x28,0x2d,0x32,0x2e,0x30,0x2c,0x20,0x2d,0x34,0x2e,0x30,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x35,0x38,0x20,0x3d,0x20,0x31,0x2e,0x32,0x39,0x39,0x39,0x39,0x39,0x39,0x35,0x32,
    0x33,0x31,0x36,0x32,0x38,0x34,0x31,0x37,0x39,0x36,0x38,0x37,0x35,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x36,0x35,0x20,0x3d,0x20,
    0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x35,0x37,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x38,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x36,0x36,0x35,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x39,
    0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x2d,0x32,
    0x2e,0x30,0x2c,0x20,0x2d,0x39,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x30,0x20,0x3d,0x20,
    0x31,0x2e,0x32,0x30,0x30,0x30,0x30,0x30,0x30,0x34,0x37,0x36,0x38,0x33,0x37,0x31,
    0x35,0x38,0x32,0x30,0x33,0x31,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x5f,0x36,0x37,0x35,0x20,0x3d,0x20,0x66,0x61,0x73,0x74,0x3a,
    0x3a,0x6d,0x69,0x6e,0x28,0x5f,0x36,0x36,0x35,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,
    0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x39,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x36,0x30,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,
    0x20,0x3d,0x20,0x5f,0x36,0x37,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x31,0x20,0x3d,0x20,0x71,
    0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x2d,0x32,0x2e,0x30,0x2c,0x20,
    0x2d,0x31,0x35,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x32,0x20,0x3d,0x20,0x31,0x2e,0x31,
    0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x33,0x38,0x34,0x31,0x38,0x35,0x37,0x39,0x31,
    0x30,0x31,0x35,0x36,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x5f,0x36,0x38,0x34,0x20,0x3d,0x20,0x66,0x61,0x73,0x74,0x3a,0x3a,0x6d,
    0x69,0x6e,0x28,0x5f,0x36,0x37,0x35,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,
    0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x31,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x36,0x32,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,
    0x20,0x5f,0x36,0x38,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x33,0x20,0x3d,0x20,0x71,0x20,0x2d,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x2d,0x32,0x2e,0x30,0x2c,0x20,0x2d,0x32,
    0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x34,0x20,0x3d,0x20,0x31,0x2e,0x30,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x36,0x39,0x33,0x20,0x3d,
    0x20,0x66,0x61,0x73,0x74,0x3a,0x3a,0x6d,0x69,0x6e,0x28,0x5f,0x36,0x38,0x34,0x2c,
    0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x36,0x33,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x34,0x29,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x36,0x39,0x33,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x36,0x35,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,
    0x2d,0x31,0x2e,0x36,0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x33,0x38,0x34,0x31,0x38,
    0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,0x32,0x35,0x2c,0x20,0x2d,0x32,0x35,0x2e,
    0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x36,0x36,0x20,0x3d,0x20,0x30,0x2e,0x38,0x39,0x39,0x39,0x39,
    0x39,0x39,0x37,0x36,0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,
    0x37,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x37,
    0x30,0x34,0x20,0x3d,0x20,0x66,0x61,0x73,0x74,0x3a,0x3a,0x6d,0x69,0x6e,0x28,0x5f,
    0x36,0x39,0x33,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x36,0x35,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,
    0x36,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x37,0x30,
    0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x36,0x37,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x28,0x2d,0x31,0x2e,0x32,0x39,0x39,0x39,0x39,0x39,0x39,0x35,0x32,
    0x33,0x31,0x36,0x32,0x38,0x34,0x31,0x37,0x39,0x36,0x38,0x37,0x35,0x2c,0x20,0x2d,
    0x32,0x39,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x38,0x20,0x3d,0x20,0x30,0x2e,0x38,0x30,
    0x30,0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,0x38,0x39,0x35,0x35,
    0x30,0x37,0x38,0x31,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x5f,0x37,0x31,0x34,0x20,0x3d,0x20,0x66,0x61,0x73,0x74,0x3a,0x3a,0x6d,
    0x69,0x6e,0x28,0x5f,0x37,0x30,0x34,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,
    0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x37,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x36,0x38,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,
    0x20,0x5f,0x37,0x31,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x39,0x20,0x3d,0x20,0x71,0x20,0x2d,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x2d,0x30,0x2e,0x38,0x39,0x39,0x39,0x39,
    0x39,0x39,0x37,0x36,0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,
    0x37,0x35,0x2c,0x20,0x2d,0x33,0x33,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x30,0x20,0x3d,
    0x20,0x30,0x2e,0x36,0x39,0x39,0x39,0x39,0x39,0x39,0x38,0x38,0x30,0x37,0x39,0x30,
    0x37,0x31,0x30,0x34,0x34,0x39,0x32,0x31,0x38,0x37,0x35,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x37,0x32,0x34,0x20,0x3d,0x20,0x66,0x61,
    0x73,0x74,0x3a,0x3a,0x6d,0x69,0x6e,0x28,0x5f,0x37,0x31,0x34,0x2c,0x20,0x73,0x64,
    0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x39,
    0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x30,0x29,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x37,0x32,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x31,0x20,
    0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x2d,0x30,0x2e,
    0x38,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,0x38,0x39,
    0x35,0x35,0x30,0x37,0x38,0x31,0x32,0x35,0x2c,0x20,0x2d,0x33,0x37,0x2e,0x30,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x37,0x32,0x20,0x3d,0x20,0x30,0x2e,0x36,0x30,0x30,0x30,0x30,0x30,0x30,
    0x32,0x33,0x38,0x34,0x31,0x38,0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,0x32,0x35,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x37,0x33,0x35,
    0x20,0x3d,0x20,0x66,0x61,0x73,0x74,0x3a,0x3a,0x6d,0x69,0x6e,0x28,0x5f,0x37,0x32,
    0x34,0x2c,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x37,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x32,0x29,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x37,0x33,0x35,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x37,0x33,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x28,0x30,0x2e,
    0x36,0x31,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x33,0x30,0x35,0x31,0x31,0x34,0x37,
    0x34,0x36,0x30,0x39,0x33,0x37,0x35,0x2c,0x20,0x30,0x2e,0x38,0x35,0x30,0x30,0x30,
    0x30,0x30,0x32,0x33,0x38,0x34,0x31,0x38,0x35,0x37,0x39,0x31,0x30,0x31,0x35,0x36,
    0x32,0x35,0x2c,0x20,0x30,0x2e,0x39,0x33,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,
    0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x33,0x37,0x35,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x37,0x34,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x35,0x20,
    0x3d,0x20,0x5f,0x37,0x33,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,
    0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,
    0x33,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x34,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x20,0x5f,0x39,0x34,0x36,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x5f,0x39,0x34,0x36,0x2e,0x79,0x20,0x3d,0x20,0x70,0x2e,0x79,
    0x20,0x2d,0x20,0x28,0x2d,0x31,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x71,0x20,0x3d,0x20,0x5f,0x39,0x34,0x36,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x36,0x20,0x3d,0x20,
    0x5f,0x39,0x34,0x36,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,
    0x30,0x2c,0x20,0x2d,0x35,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x37,0x20,0x3d,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x34,0x30,0x2e,0x30,0x2c,0x20,0x32,0x30,0x2e,
    0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x37,0x38,0x20,0x3d,0x20,0x32,0x2e,0x39,0x30,0x30,0x30,0x30,
    0x30,0x30,0x39,0x35,0x33,0x36,0x37,0x34,0x33,0x31,0x36,0x34,0x30,0x36,0x32,0x35,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,
    0x69,0x70,0x73,0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x36,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x37,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x37,0x38,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x39,0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x32,0x31,0x2e,0x30,0x2c,0x20,0x30,0x2e,0x30,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x38,0x30,0x20,0x3d,0x20,0x32,0x30,0x2e,0x30,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x31,
    0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x32,0x20,0x3d,0x20,0x73,0x64,0x5f,0x63,0x69,
    0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x39,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x38,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x33,0x20,0x3d,0x20,0x35,
    0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x37,
    0x37,0x30,0x20,0x3d,0x20,0x73,0x6d,0x69,0x6e,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x38,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x32,0x2c,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x38,0x33,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,
    0x20,0x5f,0x37,0x37,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x34,0x20,0x3d,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x33,0x28,0x30,0x2e,0x39,0x38,0x30,0x30,0x30,0x30,0x30,0x31,0x39,0x30,
    0x37,0x33,0x34,0x38,0x36,0x33,0x32,0x38,0x31,0x32,0x35,0x2c,0x20,0x30,0x2e,0x37,
    0x39,0x30,0x30,0x30,0x30,0x30,0x32,0x31,0x34,0x35,0x37,0x36,0x37,0x32,0x31,0x31,
    0x39,0x31,0x34,0x30,0x36,0x32,0x35,0x2c,0x20,0x30,0x2e,0x36,0x38,0x39,0x39,0x39,
    0x39,0x39,0x39,0x37,0x36,0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,
    0x33,0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x35,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x38,0x36,0x20,0x3d,0x20,0x5f,0x37,0x37,0x30,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x38,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x35,
    0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x36,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x37,
    0x20,0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,
    0x30,0x2c,0x20,0x66,0x6d,0x61,0x28,0x5f,0x34,0x31,0x35,0x2c,0x20,0x30,0x2e,0x35,
    0x2c,0x20,0x2d,0x31,0x32,0x2e,0x30,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x38,0x20,0x3d,0x20,
    0x32,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x73,0x64,0x5f,
    0x63,0x69,0x72,0x63,0x6c,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x37,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x38,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x39,0x20,
    0x3d,0x20,0x71,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x30,0x2e,0x30,
    0x2c,0x20,0x2d,0x31,0x38,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x30,0x20,0x3d,0x20,0x66,
    0x6d,0x61,0x28,0x5f,0x34,0x31,0x35,0x2c,0x20,0x30,0x2e,0x33,0x30,0x30,0x30,0x30,
    0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,0x38,0x39,0x35,0x35,0x30,0x37,0x38,
    0x31,0x32,0x35,0x2c,0x20,0x33,0x2e,0x31,0x34,0x31,0x35,0x39,0x32,0x37,0x34,0x31,
    0x30,0x31,0x32,0x35,0x37,0x33,0x32,0x34,0x32,0x31,0x38,0x37,0x35,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x39,0x31,0x20,0x3d,0x20,0x30,0x2e,0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,
    0x39,0x32,0x30,0x39,0x32,0x38,0x39,0x35,0x35,0x30,0x37,0x38,0x31,0x32,0x35,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x39,0x32,0x20,0x3d,0x20,0x34,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x33,0x20,0x3d,0x20,
    0x30,0x2e,0x34,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x35,0x39,0x36,0x30,0x34,0x36,
    0x34,0x34,0x37,0x37,0x35,0x33,0x39,0x30,0x36,0x32,0x35,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x38,0x30,0x39,0x20,0x3d,0x20,0x73,0x64,
    0x5f,0x61,0x72,0x63,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x39,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x39,0x30,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,
    0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x32,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x39,0x33,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x5f,0x38,0x31,0x30,0x20,0x3d,0x20,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x38,0x31,0x32,0x20,0x3d,0x20,0x66,0x61,0x73,
    0x74,0x3a,0x3a,0x6d,0x69,0x6e,0x28,0x5f,0x38,0x31,0x30,0x2c,0x20,0x5f,0x38,0x30,
    0x39,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,0x5f,0x38,0x31,0x32,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x39,0x34,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x28,0x30,
    0x2e,0x36,0x37,0x30,0x30,0x30,0x30,0x30,0x31,0x36,0x36,0x38,0x39,0x33,0x30,0x30,
    0x35,0x33,0x37,0x31,0x30,0x39,0x33,0x37,0x35,0x2c,0x20,0x30,0x2e,0x33,0x36,0x30,
    0x30,0x30,0x30,0x30,0x31,0x34,0x33,0x30,0x35,0x31,0x31,0x34,0x37,0x34,0x36,0x30,
    0x39,0x33,0x37,0x35,0x2c,0x20,0x30,0x2e,0x33,0x31,0x39,0x39,0x39,0x39,0x39,0x39,
    0x32,0x38,0x34,0x37,0x34,0x34,0x32,0x36,0x32,0x36,0x39,0x35,0x33,0x31,0x32,0x35,
    0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x39,0x35,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,
    0x36,0x20,0x3d,0x20,0x5f,0x38,0x31,0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,
    0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x39,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x35,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x39,0x36,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x5f,0x39,0x35,0x32,0x20,0x3d,0x20,0x5f,0x33,0x35,0x36,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x5f,0x39,0x35,0x32,0x2e,0x79,0x20,0x3d,0x20,0x28,
    0x70,0x2e,0x79,0x20,0x2d,0x20,0x28,0x2d,0x31,0x32,0x2e,0x30,0x29,0x29,0x20,0x2f,
    0x20,0x28,0x31,0x2e,0x30,0x20,0x2d,0x20,0x73,0x6d,0x6f,0x6f,0x74,0x68,0x73,0x74,
    0x65,0x70,0x28,0x30,0x2e,0x39,0x38,0x30,0x30,0x30,0x30,0x30,0x31,0x39,0x30,0x37,
    0x33,0x34,0x38,0x36,0x33,0x32,0x38,0x31,0x32,0x35,0x2c,0x20,0x31,0x2e,0x30,0x2c,
    0x20,0x73,0x69,0x6e,0x28,0x5f,0x34,0x30,0x38,0x2e,0x69,0x54,0x69,0x6d,0x65,0x20,
    0x2a,0x20,0x33,0x2e,0x30,0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,
    0x3d,0x20,0x5f,0x39,0x35,0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x37,0x20,0x3d,0x20,0x5f,0x39,
    0x35,0x32,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x32,0x30,0x2e,0x30,
    0x2c,0x20,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x38,0x20,0x3d,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x28,0x39,0x2e,0x30,0x2c,0x20,0x31,0x32,0x2e,0x30,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x39,0x39,0x20,0x3d,0x20,0x32,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x5f,0x38,0x34,0x37,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,
    0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,
    0x37,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x38,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x39,0x39,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,
    0x5f,0x38,0x34,0x37,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x30,0x20,0x3d,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x33,0x28,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x31,0x20,0x3d,
    0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x32,0x20,0x3d,0x20,0x5f,0x38,0x34,
    0x37,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,
    0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x30,0x2c,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x31,0x30,0x32,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x33,0x20,0x3d,0x20,0x71,0x20,0x2d,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x31,0x39,0x2e,0x35,0x2c,0x20,0x30,0x2e,
    0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x34,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x28,0x35,0x2e,0x30,0x2c,0x20,0x38,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x35,
    0x20,0x3d,0x20,0x32,0x2e,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x5f,0x38,0x36,0x34,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,
    0x70,0x73,0x6f,0x69,0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x33,0x2c,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x34,0x2c,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x31,0x30,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,0x20,
    0x5f,0x38,0x36,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x36,0x20,0x3d,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x33,0x28,0x30,0x2e,0x36,0x37,0x30,0x30,0x30,0x30,0x30,0x31,0x36,0x36,
    0x38,0x39,0x33,0x30,0x30,0x35,0x33,0x37,0x31,0x30,0x39,0x33,0x37,0x35,0x2c,0x20,
    0x30,0x2e,0x33,0x36,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x33,0x30,0x35,0x31,0x31,
    0x34,0x37,0x34,0x36,0x30,0x39,0x33,0x37,0x35,0x2c,0x20,0x30,0x2e,0x33,0x31,0x39,
    0x39,0x39,0x39,0x39,0x39,0x32,0x38,0x34,0x37,0x34,0x34,0x32,0x36,0x32,0x36,0x39,
    0x35,0x33,0x31,0x32,0x35,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x37,0x20,0x3d,0x20,0x6f,
    0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x38,0x20,0x3d,0x20,0x5f,0x38,0x36,0x34,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,
    0x64,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x36,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x30,0x37,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,
    0x38,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,
    0x38,0x37,0x33,0x20,0x3d,0x20,0x70,0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x28,0x2d,0x32,0x2e,0x30,0x2c,0x20,0x30,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x5f,0x38,0x37,0x33,0x2e,0x78,0x20,0x3d,0x20,0x61,0x62,0x73,0x28,0x5f,0x38,
    0x37,0x33,0x2e,0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x71,0x20,0x3d,0x20,0x5f,
    0x38,0x37,0x33,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x39,0x20,0x3d,0x20,0x5f,0x38,0x37,0x33,
    0x20,0x2d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x31,0x39,0x2e,0x35,0x2c,0x20,
    0x2d,0x38,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x30,0x20,0x3d,0x20,0x31,0x2e,0x32,
    0x39,0x39,0x39,0x39,0x39,0x39,0x35,0x32,0x33,0x31,0x36,0x32,0x38,0x34,0x31,0x37,
    0x39,0x36,0x38,0x37,0x35,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x20,0x5f,0x38,0x38,0x34,0x20,0x3d,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,
    0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x39,0x2c,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x31,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x64,0x20,0x3d,
    0x20,0x5f,0x38,0x38,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x31,0x20,0x3d,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x33,0x28,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x33,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x32,0x20,
    0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x33,0x20,0x3d,0x20,0x5f,0x38,
    0x38,0x34,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x20,0x5f,
    0x38,0x39,0x30,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x28,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x31,0x31,0x31,0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x32,
    0x2c,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x33,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x6f,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x5f,0x38,0x39,0x30,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x5f,0x38,0x39,0x30,0x3b,0x0a,
    0x7d,0x0a,0x0a,0x66,0x72,0x61,0x67,0x6d,0x65,0x6e,0x74,0x20,0x6d,0x61,0x69,0x6e,
    0x30,0x5f,0x6f,0x75,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,0x69,0x6e,
    0x30,0x5f,0x69,0x6e,0x20,0x69,0x6e,0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,0x65,0x5f,
    0x69,0x6e,0x5d,0x5d,0x2c,0x20,0x63,0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,0x20,0x66,
    0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x26,0x20,0x5f,0x34,0x30,0x38,
    0x20,0x5b,0x5b,0x62,0x75,0x66,0x66,0x65,0x72,0x28,0x30,0x29,0x5d,0x5d,0x29,0x0a,
    0x7b,0x0a,0x20,0x20,0x20,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,
    0x6f,0x75,0x74,0x20,0x3d,0x20,0x7b,0x7d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x20,0x3d,0x20,0x69,0x6e,0x2e,
    0x66,0x72,0x61,0x67,0x50,0x6f,0x73,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x33,0x20,0x5f,0x38,0x39,0x39,0x20,0x3d,0x20,0x6d,0x61,0x70,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x2c,0x20,0x5f,0x34,0x30,0x38,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x6f,0x75,0x74,0x2e,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,0x72,0x20,0x3d,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x28,0x5f,0x38,0x39,0x39,0x2c,0x20,0x31,0x2e,
    0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6f,
    0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    diagnostic(off, derivative_uniformity);

    struct vs_uniforms {
      /_ @offset(0) _/
      iResolution : vec2f,
    }

    var<private> coord : vec4f;

    var<private> fragPos : vec2f;

    @group(0) @binding(0) var<uniform> x_36 : vs_uniforms;

    var<private> texUV : vec2f;

    var<private> gl_Position : vec4f;

    fn main_1() {
      let x_19 : vec4f = coord;
      let x_20 : vec2f = vec2f(x_19.x, x_19.y);
      gl_Position = vec4f(x_20.x, x_20.y, 0.0f, 1.0f);
      let x_33 : f32 = coord.x;
      let x_39 : f32 = x_36.iResolution.x;
      let x_41 : f32 = x_36.iResolution.y;
      let x_45 : f32 = coord.y;
      fragPos = vec2f((x_33 * (x_39 / x_41)), x_45);
      let x_48 : vec4f = coord;
      texUV = vec2f(x_48.z, x_48.w);
      return;
    }

    struct main_out {
      @builtin(position)
      gl_Position : vec4f,
      @location(1)
      fragPos_1 : vec2f,
      @location(0)
      texUV_1 : vec2f,
    }

    @vertex
    fn main(@location(0) coord_param : vec4f) -> main_out {
      coord = coord_param;
      main_1();
      return main_out(gl_Position, fragPos, texUV);
    }

*/
static const uint8_t sdf_vs_source_wgsl[967] = {
    0x64,0x69,0x61,0x67,0x6e,0x6f,0x73,0x74,0x69,0x63,0x28,0x6f,0x66,0x66,0x2c,0x20,
    0x64,0x65,0x72,0x69,0x76,0x61,0x74,0x69,0x76,0x65,0x5f,0x75,0x6e,0x69,0x66,0x6f,
    0x72,0x6d,0x69,0x74,0x79,0x29,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,
    0x76,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x20,0x7b,0x0a,0x20,0x20,
    0x2f,0x2a,0x20,0x40,0x6f,0x66,0x66,0x73,0x65,0x74,0x28,0x30,0x29,0x20,0x2a,0x2f,
    0x0a,0x20,0x20,0x69,0x52,0x65,0x73,0x6f,0x6c,0x75,0x74,0x69,0x6f,0x6e,0x20,0x3a,
    0x20,0x76,0x65,0x63,0x32,0x66,0x2c,0x0a,0x7d,0x0a,0x0a,0x76,0x61,0x72,0x3c,0x70,
    0x72,0x69,0x76,0x61,0x74,0x65,0x3e,0x20,0x63,0x6f,0x6f,0x72,0x64,0x20,0x3a,0x20,
    0x76,0x65,0x63,0x34,0x66,0x3b,0x0a,0x0a,0x76,0x61,0x72,0x3c,0x70,0x72,0x69,0x76,
    0x61,0x74,0x65,0x3e,0x20,0x66,0x72,0x61,0x67,0x50,0x6f,0x73,0x20,0x3a,0x20,0x76,
    0x65,0x63,0x32,0x66,0x3b,0x0a,0x0a,0x40,0x67,0x72,0x6f,0x75,0x70,0x28,0x30,0x29,
    0x20,0x40,0x62,0x69,0x6e,0x64,0x69,0x6e,0x67,0x28,0x30,0x29,0x20,0x76,0x61,0x72,
    0x3c,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x3e,0x20,0x78,0x5f,0x33,0x36,0x20,0x3a,
    0x20,0x76,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x3b,0x0a,0x0a,0x76,
    0x61,0x72,0x3c,0x70,0x72,0x69,0x76,0x61,0x74,0x65,0x3e,0x20,0x74,0x65,0x78,0x55,
    0x56,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x0a,0x76,0x61,0x72,0x3c,
    0x70,0x72,0x69,0x76,0x61,0x74,0x65,0x3e,0x20,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,
    0x74,0x69,0x6f,0x6e,0x20,0x3a,0x20,0x76,0x65,0x63,0x34,0x66,0x3b,0x0a,0x0a,0x66,
    0x6e,0x20,0x6d,0x61,0x69,0x6e,0x5f,0x31,0x28,0x29,0x20,0x7b,0x0a,0x20,0x20,0x6c,
    0x65,0x74,0x20,0x78,0x5f,0x31,0x39,0x20,0x3a,0x20,0x76,0x65,0x63,0x34,0x66,0x20,
    0x3d,0x20,0x63,0x6f,0x6f,0x72,0x64,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,
    0x5f,0x32,0x30,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x76,0x65,
    0x63,0x32,0x66,0x28,0x78,0x5f,0x31,0x39,0x2e,0x78,0x2c,0x20,0x78,0x5f,0x31,0x39,
    0x2e,0x79,0x29,0x3b,0x0a,0x20,0x20,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,
    0x6f,0x6e,0x20,0x3d,0x20,0x76,0x65,0x63,0x34,0x66,0x28,0x78,0x5f,0x32,0x30,0x2e,
    0x78,0x2c,0x20,0x78,0x5f,0x32,0x30,0x2e,0x79,0x2c,0x20,0x30,0x2e,0x30,0x66,0x2c,
    0x20,0x31,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,
    0x33,0x33,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x63,0x6f,0x6f,0x72,0x64,
    0x2e,0x78,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x33,0x39,0x20,0x3a,
    0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x78,0x5f,0x33,0x36,0x2e,0x69,0x52,0x65,0x73,
    0x6f,0x6c,0x75,0x74,0x69,0x6f,0x6e,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,
    0x20,0x78,0x5f,0x34,0x31,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x78,0x5f,
    0x33,0x36,0x2e,0x69,0x52,0x65,0x73,0x6f,0x6c,0x75,0x74,0x69,0x6f,0x6e,0x2e,0x79,
    0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x35,0x20,0x3a,0x20,0x66,
    0x33,0x32,0x20,0x3d,0x20,0x63,0x6f,0x6f,0x72,0x64,0x2e,0x79,0x3b,0x0a,0x20,0x20,
    0x66,0x72,0x61,0x67,0x50,0x6f,0x73,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,
    0x28,0x78,0x5f,0x33,0x33,0x20,0x2a,0x20,0x28,0x78,0x5f,0x33,0x39,0x20,0x2f,0x20,
    0x78,0x5f,0x34,0x31,0x29,0x29,0x2c,0x20,0x78,0x5f,0x34,0x35,0x29,0x3b,0x0a,0x20,
    0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x38,0x20,0x3a,0x20,0x76,0x65,0x63,0x34,
    0x66,0x20,0x3d,0x20,0x63,0x6f,0x6f,0x72,0x64,0x3b,0x0a,0x20,0x20,0x74,0x65,0x78,
    0x55,0x56,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x78,0x5f,0x34,0x38,0x2e,
    0x7a,0x2c,0x20,0x78,0x5f,0x34,0x38,0x2e,0x77,0x29,0x3b,0x0a,0x20,0x20,0x72,0x65,
    0x74,0x75,0x72,0x6e,0x3b,0x0a,0x7d,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,
    0x6d,0x61,0x69,0x6e,0x5f,0x6f,0x75,0x74,0x20,0x7b,0x0a,0x20,0x20,0x40,0x62,0x75,
    0x69,0x6c,0x74,0x69,0x6e,0x28,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x29,0x0a,
    0x20,0x20,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3a,0x20,
    0x76,0x65,0x63,0x34,0x66,0x2c,0x0a,0x20,0x20,0x40,0x6c,0x6f,0x63,0x61,0x74,0x69,
    0x6f,0x6e,0x28,0x31,0x29,0x0a,0x20,0x20,0x66,0x72,0x61,0x67,0x50,0x6f,0x73,0x5f,
    0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x2c,0x0a,0x20,0x20,0x40,0x6c,0x6f,
    0x63,0x61,0x74,0x69,0x6f,0x6e,0x28,0x30,0x29,0x0a,0x20,0x20,0x74,0x65,0x78,0x55,
    0x56,0x5f,0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x2c,0x0a,0x7d,0x0a,0x0a,
    0x40,0x76,0x65,0x72,0x74,0x65,0x78,0x0a,0x66,0x6e,0x20,0x6d,0x61,0x69,0x6e,0x28,
    0x40,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x28,0x30,0x29,0x20,0x63,0x6f,0x6f,
    0x72,0x64,0x5f,0x70,0x61,0x72,0x61,0x6d,0x20,0x3a,0x20,0x76,0x65,0x63,0x34,0x66,
    0x29,0x20,0x2d,0x3e,0x20,0x6d,0x61,0x69,0x6e,0x5f,0x6f,0x75,0x74,0x20,0x7b,0x0a,
    0x20,0x20,0x63,0x6f,0x6f,0x72,0x64,0x20,0x3d,0x20,0x63,0x6f,0x6f,0x72,0x64,0x5f,
    0x70,0x61,0x72,0x61,0x6d,0x3b,0x0a,0x20,0x20,0x6d,0x61,0x69,0x6e,0x5f,0x31,0x28,
    0x29,0x3b,0x0a,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6d,0x61,0x69,0x6e,
    0x5f,0x6f,0x75,0x74,0x28,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,
    0x2c,0x20,0x66,0x72,0x61,0x67,0x50,0x6f,0x73,0x2c,0x20,0x74,0x65,0x78,0x55,0x56,
    0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    diagnostic(off, derivative_uniformity);

    struct fs_uniforms {
      /_ @offset(0) _/
      iTime : f32,
    }

    @group(0) @binding(8) var<uniform> x_408 : fs_uniforms;

    var<private> fragPos : vec2f;

    var<private> fragColor : vec4f;

    var<private> texUV : vec2f;

    fn background_vf2_(uv : ptr<function, vec2f>) -> vec3f {
      var q : vec2f;
      var col_1 : vec3f;
      let x_313 : vec2f = *(uv);
      q = abs(floor(x_313));
      col_1 = vec3f(0.38999998569488525391f, 0.38999998569488525391f, 0.38999998569488525391f);
      let x_322 : f32 = q.x;
      let x_324 : f32 = q.y;
      let x_328 : vec3f = col_1;
      col_1 = (x_328 + (vec3f(0.17000000178813934326f, 0.17000000178813934326f, 0.17000000178813934326f) * ((x_322 + x_324) - (2.0f * floor(((x_322 + x_324) / 2.0f))))));
      let x_330 : vec3f = col_1;
      return x_330;
    }

    fn length_n_vf2_f1_(p_1 : ptr<function, vec2f>, n : ptr<function, f32>) -> f32 {
      let x_77 : vec2f = *(p_1);
      let x_79 : f32 = *(n);
      *(p_1) = pow(abs(x_77), vec2f(x_79, x_79));
      let x_85 : f32 = (*(p_1)).x;
      let x_88 : f32 = (*(p_1)).y;
      let x_91 : f32 = *(n);
      return pow((x_85 + x_88), (1.0f / x_91));
    }

    fn sd_ellipsoid_vf2_vf2_f1_(p_2 : ptr<function, vec2f>, r_1 : ptr<function, vec2f>, roundness : ptr<function, f32>) -> f32 {
      var k1 : f32;
      var param : vec2f;
      var param_1 : f32;
      var k2 : f32;
      var param_2 : vec2f;
      var param_3 : f32;
      let x_97 : vec2f = *(p_2);
      let x_98 : vec2f = *(r_1);
      param = (x_97 / x_98);
      let x_102 : f32 = *(roundness);
      param_1 = x_102;
      let x_103 : f32 = length_n_vf2_f1_(&(param), &(param_1));
      k1 = x_103;
      let x_105 : vec2f = *(p_2);
      let x_106 : vec2f = *(r_1);
      let x_107 : vec2f = *(r_1);
      param_2 = (x_105 / (x_106 * x_107));
      let x_112 : f32 = *(roundness);
      param_3 = x_112;
      let x_113 : f32 = length_n_vf2_f1_(&(param_2), &(param_3));
      k2 = x_113;
      let x_114 : f32 = k1;
      let x_115 : f32 = k1;
      let x_118 : f32 = k2;
      return ((x_114 * (x_115 - 1.0f)) / x_118);
    }

    fn blend_vf3_vf3_f1_(col : ptr<function, vec3f>, ocol : ptr<function, vec3f>, d_1 : ptr<function, f32>) -> vec3f {
      let x_333 : vec3f = *(ocol);
      let x_334 : vec3f = *(col);
      let x_336 : f32 = *(d_1);
      let x_337 : f32 = smoothstep(0.5f, 0.0f, x_336);
      return mix(x_333, x_334, vec3f(x_337, x_337, x_337));
    }

    fn sd_line_vf2_vf2_vf2_(p_5 : ptr<function, vec2f>, a : ptr<function, vec2f>, b : ptr<function, vec2f>) -> f32 {
      var pa : vec2f;
      var ba : vec2f;
      var h : f32;
      let x_238 : vec2f = *(p_5);
      let x_239 : vec2f = *(a);
      pa = (x_238 - x_239);
      let x_242 : vec2f = *(b);
      let x_243 : vec2f = *(a);
      ba = (x_242 - x_243);
      let x_246 : vec2f = pa;
      let x_247 : vec2f = ba;
      let x_249 : vec2f = ba;
      let x_250 : vec2f = ba;
      h = clamp((dot(x_246, x_247) / dot(x_249, x_250)), 0.0f, 1.0f);
      let x_254 : vec2f = pa;
      let x_255 : vec2f = ba;
      let x_256 : f32 = h;
      return length((x_254 - (x_255 * x_256)));
    }

    fn rotate_vf2_f1_(p_6 : ptr<function, vec2f>, theta : ptr<function, f32>) -> vec2f {
      var cost : f32;
      var sint : f32;
      let x_263 : f32 = *(theta);
      cost = cos(x_263);
      let x_266 : f32 = *(theta);
      sint = sin(x_266);
      let x_269 : f32 = (*(p_6)).x;
      let x_270 : f32 = cost;
      let x_273 : f32 = (*(p_6)).y;
      let x_274 : f32 = sint;
      let x_278 : f32 = (*(p_6)).x;
      let x_279 : f32 = sint;
      let x_282 : f32 = (*(p_6)).y;
      let x_283 : f32 = cost;
      return vec2f(((x_269 * x_270) - (x_273 * x_274)), ((x_278 * x_279) + (x_282 * x_283)));
    }

    fn sd_vesica_vf2_f1_f1_(p_3 : ptr<function, vec2f>, r_2 : ptr<function, f32>, d : ptr<function, f32>) -> f32 {
      var b_2 : f32;
      var x_145 : f32;
      let x_122 : vec2f = *(p_3);
      *(p_3) = abs(x_122);
      let x_125 : f32 = *(r_2);
      let x_126 : f32 = *(r_2);
      let x_128 : f32 = *(d);
      let x_129 : f32 = *(d);
      b_2 = sqrt(((x_125 * x_126) - (x_128 * x_129)));
      let x_134 : f32 = (*(p_3)).y;
      let x_135 : f32 = b_2;
      let x_137 : f32 = *(d);
      let x_140 : f32 = (*(p_3)).x;
      let x_141 : f32 = b_2;
      if ((((x_134 - x_135) * x_137) > (x_140 * x_141))) {
        let x_148 : vec2f = *(p_3);
        let x_150 : f32 = b_2;
        x_145 = length((x_148 - vec2f(0.0f, x_150)));
      } else {
        let x_155 : vec2f = *(p_3);
        let x_156 : f32 = *(d);
        let x_161 : f32 = *(r_2);
        x_145 = (length((x_155 - vec2f(-(x_156), 0.0f))) - x_161);
      }
      let x_163 : f32 = x_145;
      return x_163;
    }

    fn smin_f1_f1_f1_(a_1 : ptr<function, f32>, b_1 : ptr<function, f32>, k : ptr<function, f32>) -> f32 {
      var h_1 : f32;
      let x_290 : f32 = *(k);
      let x_291 : f32 = *(a_1);
      let x_292 : f32 = *(b_1);
      let x_297 : f32 = *(k);
      h_1 = (max((x_290 - abs((x_291 - x_292))), 0.0f) / x_297);
      let x_299 : f32 = *(a_1);
      let x_300 : f32 = *(b_1);
      let x_302 : f32 = h_1;
      let x_303 : f32 = h_1;
      let x_305 : f32 = *(k);
      return (min(x_299, x_300) - (((x_302 * x_303) * x_305) * 0.25f));
    }

    fn sd_circle_vf2_f1_(p : ptr<function, vec2f>, r : ptr<function, f32>) -> f32 {
      let x_71 : vec2f = *(p);
      let x_73 : f32 = *(r);
      return (length(x_71) - x_73);
    }

    fn sd_arc_vf2_f1_f1_f1_f1_(p_4 : ptr<function, vec2f>, ta : ptr<function, f32>, tb : ptr<function, f32>, ra : ptr<function, f32>, rb : ptr<function, f32>) -> f32 {
      var sca : vec2f;
      var scb : vec2f;
      var k_1 : f32;
      var x_209 : f32;
      let x_167 : f32 = *(ta);
      let x_169 : f32 = *(ta);
      sca = vec2f(cos(x_167), sin(x_169));
      let x_173 : f32 = *(tb);
      let x_175 : f32 = *(tb);
      scb = vec2f(cos(x_173), sin(x_175));
      let x_179 : f32 = sca.x;
      let x_181 : f32 = sca.y;
      let x_183 : f32 = sca.y;
      let x_186 : f32 = sca.x;
      let x_191 : vec2f = *(p_4);
      *(p_4) = (x_191 * mat2x2f(vec2f(x_179, x_181), vec2f(-(x_183), x_186)));
      let x_194 : f32 = (*(p_4)).x;
      (*(p_4)).x = abs(x_194);
      let x_199 : f32 = scb.y;
      let x_201 : f32 = (*(p_4)).x;
      let x_204 : f32 = scb.x;
      let x_206 : f32 = (*(p_4)).y;
      if (((x_199 * x_201) > (x_204 * x_206))) {
        let x_212 : vec2f = *(p_4);
        let x_213 : vec2f = scb;
        x_209 = dot(x_212, x_213);
      } else {
        let x_216 : vec2f = *(p_4);
        x_209 = length(x_216);
      }
      let x_218 : f32 = x_209;
      k_1 = x_218;
      let x_219 : vec2f = *(p_4);
      let x_220 : vec2f = *(p_4);
      let x_222 : f32 = *(ra);
      let x_223 : f32 = *(ra);
      let x_227 : f32 = *(ra);
      let x_229 : f32 = k_1;
      let x_233 : f32 = *(rb);
      return (sqrt(((dot(x_219, x_220) + (x_222 * x_223)) - ((2.0f * x_227) * x_229))) - x_233);
    }

    const x_378 = vec3f(0.61000001430511474609f, 0.85000002384185791016f, 0.93999999761581420898f);

    const x_422 = vec2f(0.0f, 0.0f);

    const x_423 = vec2f(45.0f, 0.0f);

    const x_487 = vec3f(0.11999999731779098511f, 0.11999999731779098511f, 0.11999999731779098511f);

    const x_816 = vec3f(0.67000001668930053711f, 0.36000001430511474609f, 0.31999999284744262695f);

    const x_848 = vec3f(1.0f, 1.0f, 1.0f);

    fn map_vf2_(p_7 : ptr<function, vec2f>) -> vec3f {
      var sp : vec2f;
      var ocol_1 : vec3f;
      var param_4 : vec2f;
      var d_2 : f32;
      var param_5 : vec2f;
      var param_6 : vec2f;
      var param_7 : f32;
      var param_8 : vec3f;
      var param_9 : vec3f;
      var param_10 : f32;
      var q_1 : vec2f;
      var param_11 : vec2f;
      var param_12 : vec2f;
      var param_13 : f32;
      var d2 : f32;
      var param_14 : vec2f;
      var param_15 : vec2f;
      var param_16 : vec2f;
      var param_17 : vec2f;
      var param_18 : vec2f;
      var param_19 : vec2f;
      var param_20 : vec2f;
      var param_21 : f32;
      var param_22 : vec2f;
      var param_23 : f32;
      var param_24 : f32;
      var param_25 : vec3f;
      var param_26 : vec3f;
      var param_27 : f32;
      var param_28 : vec2f;
      var param_29 : vec2f;
      var param_30 : f32;
      var param_31 : vec2f;
      var param_32 : vec2f;
      var param_33 : f32;
      var param_34 : vec2f;
      var param_35 : f32;
      var param_36 : vec2f;
      var param_37 : vec2f;
      var param_38 : vec2f;
      var param_39 : f32;
      var param_40 : f32;
      var param_41 : f32;
      var param_42 : vec2f;
      var param_43 : f32;
      var param_44 : vec2f;
      var param_45 : vec2f;
      var param_46 : vec2f;
      var param_47 : f32;
      var param_48 : f32;
      var param_49 : f32;
      var param_50 : vec2f;
      var param_51 : f32;
      var param_52 : vec2f;
      var param_53 : vec2f;
      var param_54 : vec2f;
      var param_55 : f32;
      var param_56 : f32;
      var param_57 : f32;
      var param_58 : vec3f;
      var param_59 : vec3f;
      var param_60 : f32;
      var param_61 : vec2f;
      var param_62 : f32;
      var param_63 : vec2f;
      var param_64 : f32;
      var param_65 : vec2f;
      var param_66 : f32;
      var param_67 : vec2f;
      var param_68 : f32;
      var param_69 : vec2f;
      var param_70 : f32;
      var param_71 : vec2f;
      var param_72 : f32;
      var param_73 : vec2f;
      var param_74 : f32;
      var param_75 : vec2f;
      var param_76 : f32;
      var param_77 : vec3f;
      var param_78 : vec3f;
      var param_79 : f32;
      var param_80 : vec2f;
      var param_81 : vec2f;
      var param_82 : f32;
      var param_83 : vec2f;
      var param_84 : f32;
      var param_85 : f32;
      var param_86 : f32;
      var param_87 : f32;
      var param_88 : vec3f;
      var param_89 : vec3f;
      var param_90 : f32;
      var param_91 : vec2f;
      var param_92 : f32;
      var param_93 : vec2f;
      var param_94 : f32;
      var param_95 : f32;
      var param_96 : f32;
      var param_97 : f32;
      var param_98 : vec3f;
      var param_99 : vec3f;
      var param_100 : f32;
      var param_101 : vec2f;
      var param_102 : vec2f;
      var param_103 : f32;
      var param_104 : vec3f;
      var param_105 : vec3f;
      var param_106 : f32;
      var param_107 : vec2f;
      var param_108 : vec2f;
      var param_109 : f32;
      var param_110 : vec3f;
      var param_111 : vec3f;
      var param_112 : f32;
      var param_113 : vec2f;
      var param_114 : f32;
      var param_115 : vec3f;
      var param_116 : vec3f;
      var param_117 : f32;
      let x_343 : vec2f = *(p_7);
      *(p_7) = (x_343 * 100.0f);
      let x_347 : f32 = (*(p_7)).y;
      (*(p_7)).y = (x_347 - 30.0f);
      let x_352 : f32 = (*(p_7)).x;
      let x_355 : f32 = (*(p_7)).y;
      sp = vec2f(abs(x_352), x_355);
      let x_358 : vec2f = *(p_7);
      param_4 = (x_358 * 0.30000001192092895508f);
      let x_362 : vec3f = background_vf2_(&(param_4));
      ocol_1 = x_362;
      let x_364 : vec2f = *(p_7);
      param_5 = (x_364 - vec2f(0.0f, -97.0f));
      param_6 = vec2f(55.0f, 20.0f);
      param_7 = 2.0f;
      let x_374 : f32 = sd_ellipsoid_vf2_vf2_f1_(&(param_5), &(param_6), &(param_7));
      d_2 = x_374;
      param_8 = x_378;
      let x_381 : vec3f = ocol_1;
      param_9 = x_381;
      let x_383 : f32 = d_2;
      param_10 = x_383;
      let x_384 : vec3f = blend_vf3_vf3_f1_(&(param_8), &(param_9), &(param_10));
      ocol_1 = x_384;
      let x_386 : vec2f = sp;
      q_1 = x_386;
      let x_391 : vec2f = q_1;
      param_11 = x_391;
      param_12 = vec2f(55.0f, 45.0f);
      param_13 = 2.40000009536743164062f;
      let x_394 : f32 = sd_ellipsoid_vf2_vf2_f1_(&(param_11), &(param_12), &(param_13));
      d_2 = x_394;
      let x_397 : vec2f = q_1;
      q_1 = (x_397 - vec2f(45.0f, -15.0f));
      let x_400 : f32 = q_1.x;
      let x_402 : f32 = q_1.x;
      let x_413 : f32 = x_408.iTime;
      let x_418 : f32 = q_1.y;
      q_1.y = (x_418 + (((x_400 * x_402) * 0.00300000002607703209f) * sin((x_413 * 1.0f))));
      let x_425 : vec2f = q_1;
      param_14 = x_425;
      param_15 = x_422;
      param_16 = x_423;
      let x_428 : f32 = sd_line_vf2_vf2_vf2_(&(param_14), &(param_15), &(param_16));
      d2 = (x_428 - 0.20000000298023223877f);
      let x_431 : f32 = d_2;
      let x_432 : f32 = d2;
      d_2 = min(x_431, x_432);
      let x_436 : f32 = q_1.y;
      q_1.y = (x_436 + 6.0f);
      let x_440 : f32 = q_1.x;
      let x_442 : f32 = q_1.x;
      let x_446 : f32 = x_408.iTime;
      let x_451 : f32 = q_1.y;
      q_1.y = (x_451 + (((x_440 * x_442) * 0.00300000002607703209f) * sin((x_446 * 2.0f))));
      let x_455 : vec2f = q_1;
      param_17 = x_455;
      param_18 = x_422;
      param_19 = x_423;
      let x_458 : f32 = sd_line_vf2_vf2_vf2_(&(param_17), &(param_18), &(param_19));
      d2 = (x_458 - 0.20000000298023223877f);
      let x_460 : f32 = d_2;
      let x_461 : f32 = d2;
      d_2 = min(x_460, x_461);
      let x_463 : vec2f = sp;
      q_1 = (x_463 - vec2f(32.0f, 30.0f));
      let x_469 : f32 = x_408.iTime;
      let x_474 : vec2f = q_1;
      param_20 = x_474;
      param_21 = (0.69999998807907104492f + (sin(x_469) * 0.30000001192092895508f));
      let x_476 : vec2f = rotate_vf2_f1_(&(param_20), &(param_21));
      q_1 = x_476;
      let x_479 : vec2f = q_1;
      param_22 = x_479;
      param_23 = 30.0f;
      param_24 = 15.0f;
      let x_482 : f32 = sd_vesica_vf2_f1_f1_(&(param_22), &(param_23), &(param_24));
      d2 = x_482;
      let x_483 : f32 = d_2;
      let x_484 : f32 = d2;
      d_2 = min(x_483, x_484);
      param_25 = x_487;
      let x_490 : vec3f = ocol_1;
      param_26 = x_490;
      let x_492 : f32 = d_2;
      param_27 = x_492;
      let x_493 : vec3f = blend_vf3_vf3_f1_(&(param_25), &(param_26), &(param_27));
      ocol_1 = x_493;
      let x_494 : vec2f = sp;
      q_1 = x_494;
      let x_495 : vec2f = q_1;
      param_28 = (x_495 - vec2f(0.0f, -60.0f));
      param_29 = vec2f(27.0f, 20.0f);
      param_30 = 2.0f;
      let x_504 : f32 = sd_ellipsoid_vf2_vf2_f1_(&(param_28), &(param_29), &(param_30));
      d_2 = x_504;
      let x_505 : vec2f = q_1;
      param_31 = (x_505 - vec2f(0.0f, -70.0f));
      param_32 = vec2f(20.0f, 16.0f);
      param_33 = 2.0f;
      let x_514 : f32 = sd_ellipsoid_vf2_vf2_f1_(&(param_31), &(param_32), &(param_33));
      d2 = x_514;
      let x_515 : f32 = d2;
      let x_517 : f32 = d_2;
      d_2 = max(-(x_515), x_517);
      let x_519 : vec2f = sp;
      q_1 = (x_519 - vec2f(6.0f, -50.0f));
      let x_524 : f32 = x_408.iTime;
      let x_532 : vec2f = q_1;
      param_34 = x_532;
      param_35 = (-((0.5f + (0.5f * sin(x_524)))) * 0.10000000149011611938f);
      let x_534 : vec2f = rotate_vf2_f1_(&(param_34), &(param_35));
      q_1 = x_534;
      let x_537 : f32 = q_1.y;
      let x_544 : f32 = q_1.x;
      q_1.x = (x_544 - (pow(max((-45.0f - x_537), 0.0f), 1.89999997615814208984f) * 0.10000000149011611938f));
      let x_549 : vec2f = q_1;
      param_36 = x_549;
      param_37 = vec2f(0.0f, -50.0f);
      param_38 = x_422;
      let x_552 : f32 = sd_line_vf2_vf2_vf2_(&(param_36), &(param_37), &(param_38));
      d2 = (x_552 - 5.0f);
      let x_556 : f32 = d_2;
      param_39 = x_556;
      let x_558 : f32 = d2;
      param_40 = x_558;
      param_41 = 1.0f;
      let x_560 : f32 = smin_f1_f1_f1_(&(param_39), &(param_40), &(param_41));
      d_2 = x_560;
      let x_561 : vec2f = sp;
      q_1 = (x_561 - vec2f(22.0f, -60.0f));
      let x_566 : f32 = x_408.iTime;
      let x_573 : vec2f = q_1;
      param_42 = x_573;
      param_43 = (-((0.5f + (0.5f * cos(x_566)))) * 0.10000000149011611938f);
      let x_575 : vec2f = rotate_vf2_f1_(&(param_42), &(param_43));
      q_1 = x_575;
      let x_578 : f32 = q_1.y;
      let x_584 : f32 = q_1.x;
      q_1.x = (x_584 - (pow(max((-29.0f - x_578), 0.0f), 1.89999997615814208984f) * 0.10000000149011611938f));
      let x_590 : vec2f = q_1;
      param_44 = x_590;
      param_45 = vec2f(0.0f, -35.0f);
      param_46 = x_422;
      let x_593 : f32 = sd_line_vf2_vf2_vf2_(&(param_44), &(param_45), &(param_46));
      d2 = (x_593 - 5.0f);
      let x_596 : f32 = d_2;
      param_47 = x_596;
      let x_598 : f32 = d2;
      param_48 = x_598;
      param_49 = 1.0f;
      let x_600 : f32 = smin_f1_f1_f1_(&(param_47), &(param_48), &(param_49));
      d_2 = x_600;
      let x_601 : vec2f = *(p_7);
      q_1 = (x_601 - vec2f(-26.0f, -60.0f));
      let x_607 : vec2f = q_1;
      param_50 = x_607;
      param_51 = 2.19911479949951171875f;
      let x_609 : vec2f = rotate_vf2_f1_(&(param_50), &(param_51));
      q_1 = x_609;
      let x_611 : f32 = q_1.y;
      let x_620 : f32 = q_1.y;
      let x_623 : f32 = x_408.iTime;
      let x_630 : f32 = q_1.x;
      q_1.x = (x_630 - ((sin(((x_611 * 0.1230000033974647522f) + 3.0f)) * 4.0f) + sin(((x_620 * 0.10000000149011611938f) + (x_623 * 10.0f)))));
      let x_636 : vec2f = q_1;
      param_52 = x_636;
      param_53 = vec2f(0.0f, -40.0f);
      param_54 = x_422;
      let x_639 : f32 = sd_line_vf2_vf2_vf2_(&(param_52), &(param_53), &(param_54));
      let x_641 : f32 = q_1.y;
      d2 = (x_639 - (5.0f * smoothstep(-60.0f, 0.0f, x_641)));
      let x_646 : f32 = d_2;
      param_55 = x_646;
      let x_648 : f32 = d2;
      param_56 = x_648;
      param_57 = 1.0f;
      let x_650 : f32 = smin_f1_f1_f1_(&(param_55), &(param_56), &(param_57));
      d_2 = x_650;
      param_58 = x_487;
      let x_653 : vec3f = ocol_1;
      param_59 = x_653;
      let x_655 : f32 = d_2;
      param_60 = x_655;
      let x_656 : vec3f = blend_vf3_vf3_f1_(&(param_58), &(param_59), &(param_60));
      ocol_1 = x_656;
      let x_657 : vec2f = q_1;
      param_61 = (x_657 - vec2f(-2.0f, -4.0f));
      param_62 = 1.29999995231628417969f;
      let x_665 : f32 = sd_circle_vf2_f1_(&(param_61), &(param_62));
      d_2 = x_665;
      let x_666 : f32 = d_2;
      let x_667 : vec2f = q_1;
      param_63 = (x_667 - vec2f(-2.0f, -9.0f));
      param_64 = 1.20000004768371582031f;
      let x_674 : f32 = sd_circle_vf2_f1_(&(param_63), &(param_64));
      d_2 = min(x_666, x_674);
      let x_676 : f32 = d_2;
      let x_677 : vec2f = q_1;
      param_65 = (x_677 - vec2f(-2.0f, -15.0f));
      param_66 = 1.10000002384185791016f;
      let x_683 : f32 = sd_circle_vf2_f1_(&(param_65), &(param_66));
      d_2 = min(x_676, x_683);
      let x_685 : f32 = d_2;
      let x_686 : vec2f = q_1;
      param_67 = (x_686 - vec2f(-2.0f, -20.0f));
      param_68 = 1.0f;
      let x_692 : f32 = sd_circle_vf2_f1_(&(param_67), &(param_68));
      d_2 = min(x_685, x_692);
      let x_694 : f32 = d_2;
      let x_695 : vec2f = q_1;
      param_69 = (x_695 - vec2f(-1.60000002384185791016f, -25.0f));
      param_70 = 0.89999997615814208984f;
      let x_703 : f32 = sd_circle_vf2_f1_(&(param_69), &(param_70));
      d_2 = min(x_694, x_703);
      let x_705 : f32 = d_2;
      let x_706 : vec2f = q_1;
      param_71 = (x_706 - vec2f(-1.29999995231628417969f, -29.0f));
      param_72 = 0.80000001192092895508f;
      let x_713 : f32 = sd_circle_vf2_f1_(&(param_71), &(param_72));
      d_2 = min(x_705, x_713);
      let x_715 : f32 = d_2;
      let x_716 : vec2f = q_1;
      param_73 = (x_716 - vec2f(-0.89999997615814208984f, -33.0f));
      param_74 = 0.69999998807907104492f;
      let x_723 : f32 = sd_circle_vf2_f1_(&(param_73), &(param_74));
      d_2 = min(x_715, x_723);
      let x_725 : f32 = d_2;
      let x_726 : vec2f = q_1;
      param_75 = (x_726 - vec2f(-0.80000001192092895508f, -37.0f));
      param_76 = 0.60000002384185791016f;
      let x_734 : f32 = sd_circle_vf2_f1_(&(param_75), &(param_76));
      d_2 = min(x_725, x_734);
      param_77 = x_378;
      let x_738 : vec3f = ocol_1;
      param_78 = x_738;
      let x_740 : f32 = d_2;
      param_79 = x_740;
      let x_741 : vec3f = blend_vf3_vf3_f1_(&(param_77), &(param_78), &(param_79));
      ocol_1 = x_741;
      let x_742 : vec2f = sp;
      q_1 = x_742;
      let x_745 : f32 = q_1.y;
      q_1.y = (x_745 - -11.0f);
      let x_748 : vec2f = q_1;
      param_80 = (x_748 - vec2f(0.0f, -5.0f));
      param_81 = vec2f(40.0f, 20.0f);
      param_82 = 2.90000009536743164062f;
      let x_758 : f32 = sd_ellipsoid_vf2_vf2_f1_(&(param_80), &(param_81), &(param_82));
      d_2 = x_758;
      let x_759 : vec2f = q_1;
      param_83 = (x_759 - vec2f(21.0f, 0.0f));
      param_84 = 20.0f;
      let x_765 : f32 = sd_circle_vf2_f1_(&(param_83), &(param_84));
      let x_767 : f32 = d_2;
      param_85 = x_767;
      param_86 = x_765;
      param_87 = 5.0f;
      let x_770 : f32 = smin_f1_f1_f1_(&(param_85), &(param_86), &(param_87));
      d_2 = x_770;
      param_88 = vec3f(0.98000001907348632812f, 0.79000002145767211914f, 0.68999999761581420898f);
      let x_777 : vec3f = ocol_1;
      param_89 = x_777;
      let x_779 : f32 = d_2;
      param_90 = x_779;
      let x_780 : vec3f = blend_vf3_vf3_f1_(&(param_88), &(param_89), &(param_90));
      ocol_1 = x_780;
      let x_781 : vec2f = q_1;
      let x_784 : f32 = x_408.iTime;
      param_91 = (x_781 - vec2f(0.0f, (-12.0f + (sin(x_784) * 0.5f))));
      param_92 = 2.0f;
      let x_792 : f32 = sd_circle_vf2_f1_(&(param_91), &(param_92));
      d_2 = x_792;
      let x_793 : vec2f = q_1;
      let x_799 : f32 = x_408.iTime;
      param_93 = (x_793 - vec2f(0.0f, -18.0f));
      param_94 = (3.14159274101257324219f + (sin(x_799) * 0.30000001192092895508f));
      param_95 = 0.30000001192092895508f;
      param_96 = 4.0f;
      param_97 = 0.40000000596046447754f;
      let x_809 : f32 = sd_arc_vf2_f1_f1_f1_f1_(&(param_93), &(param_94), &(param_95), &(param_96), &(param_97));
      d2 = x_809;
      let x_810 : f32 = d_2;
      let x_811 : f32 = d2;
      d_2 = min(x_810, x_811);
      param_98 = x_816;
      let x_819 : vec3f = ocol_1;
      param_99 = x_819;
      let x_821 : f32 = d_2;
      param_100 = x_821;
      let x_822 : vec3f = blend_vf3_vf3_f1_(&(param_98), &(param_99), &(param_100));
      ocol_1 = x_822;
      let x_823 : vec2f = sp;
      q_1 = x_823;
      let x_825 : f32 = q_1.y;
      q_1.y = (x_825 - -12.0f);
      let x_829 : f32 = x_408.iTime;
      let x_835 : f32 = q_1.y;
      q_1.y = (x_835 / (1.0f - smoothstep(0.98000001907348632812f, 1.0f, sin((x_829 * 3.0f)))));
      let x_838 : vec2f = q_1;
      param_101 = (x_838 - vec2f(20.0f, 0.0f));
      param_102 = vec2f(9.0f, 12.0f);
      param_103 = 2.0f;
      let x_847 : f32 = sd_ellipsoid_vf2_vf2_f1_(&(param_101), &(param_102), &(param_103));
      d_2 = x_847;
      param_104 = x_848;
      let x_851 : vec3f = ocol_1;
      param_105 = x_851;
      let x_853 : f32 = d_2;
      param_106 = x_853;
      let x_854 : vec3f = blend_vf3_vf3_f1_(&(param_104), &(param_105), &(param_106));
      ocol_1 = x_854;
      let x_855 : vec2f = q_1;
      param_107 = (x_855 - vec2f(19.5f, 0.0f));
      param_108 = vec2f(5.0f, 8.0f);
      param_109 = 2.0f;
      let x_864 : f32 = sd_ellipsoid_vf2_vf2_f1_(&(param_107), &(param_108), &(param_109));
      d_2 = x_864;
      param_110 = x_816;
      let x_867 : vec3f = ocol_1;
      param_111 = x_867;
      let x_869 : f32 = d_2;
      param_112 = x_869;
      let x_870 : vec3f = blend_vf3_vf3_f1_(&(param_110), &(param_111), &(param_112));
      ocol_1 = x_870;
      let x_871 : vec2f = *(p_7);
      q_1 = (x_871 - vec2f(-2.0f, 0.0f));
      let x_875 : f32 = q_1.x;
      q_1.x = abs(x_875);
      let x_878 : vec2f = q_1;
      param_113 = (x_878 - vec2f(19.5f, -8.0f));
      param_114 = 1.29999995231628417969f;
      let x_884 : f32 = sd_circle_vf2_f1_(&(param_113), &(param_114));
      d_2 = x_884;
      param_115 = x_848;
      let x_887 : vec3f = ocol_1;
      param_116 = x_887;
      let x_889 : f32 = d_2;
      param_117 = x_889;
      let x_890 : vec3f = blend_vf3_vf3_f1_(&(param_115), &(param_116), &(param_117));
      ocol_1 = x_890;
      let x_891 : vec3f = ocol_1;
      return x_891;
    }

    fn main_1() {
      var col_2 : vec3f;
      var param_118 : vec2f;
      let x_898 : vec2f = fragPos;
      param_118 = x_898;
      let x_899 : vec3f = map_vf2_(&(param_118));
      col_2 = x_899;
      let x_903 : vec3f = col_2;
      fragColor = vec4f(x_903.x, x_903.y, x_903.z, 1.0f);
      return;
    }

    struct main_out {
      @location(0)
      fragColor_1 : vec4f,
    }

    @fragment
    fn main(@location(1) fragPos_param : vec2f, @location(0) texUV_param : vec2f) -> main_out {
      fragPos = fragPos_param;
      texUV = texUV_param;
      main_1();
      return main_out(fragColor);
    }

*/
static const uint8_t sdf_fs_source_wgsl[22057] = {
    0x64,0x69,0x61,0x67,0x6e,0x6f,0x73,0x74,0x69,0x63,0x28,0x6f,0x66,0x66,0x2c,0x20,
    0x64,0x65,0x72,0x69,0x76,0x61,0x74,0x69,0x76,0x65,0x5f,0x75,0x6e,0x69,0x66,0x6f,
    0x72,0x6d,0x69,0x74,0x79,0x29,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,
    0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x20,0x7b,0x0a,0x20,0x20,
    0x2f,0x2a,0x20,0x40,0x6f,0x66,0x66,0x73,0x65,0x74,0x28,0x30,0x29,0x20,0x2a,0x2f,
    0x0a,0x20,0x20,0x69,0x54,0x69,0x6d,0x65,0x20,0x3a,0x20,0x66,0x33,0x32,0x2c,0x0a,
    0x7d,0x0a,0x0a,0x40,0x67,0x72,0x6f,0x75,0x70,0x28,0x30,0x29,0x20,0x40,0x62,0x69,
    0x6e,0x64,0x69,0x6e,0x67,0x28,0x38,0x29,0x20,0x76,0x61,0x72,0x3c,0x75,0x6e,0x69,
    0x66,0x6f,0x72,0x6d,0x3e,0x20,0x78,0x5f,0x34,0x30,0x38,0x20,0x3a,0x20,0x66,0x73,
    0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x3b,0x0a,0x0a,0x76,0x61,0x72,0x3c,
    0x70,0x72,0x69,0x76,0x61,0x74,0x65,0x3e,0x20,0x66,0x72,0x61,0x67,0x50,0x6f,0x73,
    0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x0a,0x76,0x61,0x72,0x3c,0x70,
    0x72,0x69,0x76,0x61,0x74,0x65,0x3e,0x20,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,
    0x72,0x20,0x3a,0x20,0x76,0x65,0x63,0x34,0x66,0x3b,0x0a,0x0a,0x76,0x61,0x72,0x3c,
    0x70,0x72,0x69,0x76,0x61,0x74,0x65,0x3e,0x20,0x74,0x65,0x78,0x55,0x56,0x20,0x3a,
    0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x0a,0x66,0x6e,0x20,0x62,0x61,0x63,0x6b,
    0x67,0x72,0x6f,0x75,0x6e,0x64,0x5f,0x76,0x66,0x32,0x5f,0x28,0x75,0x76,0x20,0x3a,
    0x20,0x70,0x74,0x72,0x3c,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x76,
    0x65,0x63,0x32,0x66,0x3e,0x29,0x20,0x2d,0x3e,0x20,0x76,0x65,0x63,0x33,0x66,0x20,
    0x7b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x71,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,
    0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x63,0x6f,0x6c,0x5f,0x31,0x20,0x3a,
    0x20,0x76,0x65,0x63,0x33,0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,
    0x33,0x31,0x33,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x2a,0x28,
    0x75,0x76,0x29,0x3b,0x0a,0x20,0x20,0x71,0x20,0x3d,0x20,0x61,0x62,0x73,0x28,0x66,
    0x6c,0x6f,0x6f,0x72,0x28,0x78,0x5f,0x33,0x31,0x33,0x29,0x29,0x3b,0x0a,0x20,0x20,
    0x63,0x6f,0x6c,0x5f,0x31,0x20,0x3d,0x20,0x76,0x65,0x63,0x33,0x66,0x28,0x30,0x2e,
    0x33,0x38,0x39,0x39,0x39,0x39,0x39,0x38,0x35,0x36,0x39,0x34,0x38,0x38,0x35,0x32,
    0x35,0x33,0x39,0x31,0x66,0x2c,0x20,0x30,0x2e,0x33,0x38,0x39,0x39,0x39,0x39,0x39,
    0x38,0x35,0x36,0x39,0x34,0x38,0x38,0x35,0x32,0x35,0x33,0x39,0x31,0x66,0x2c,0x20,
    0x30,0x2e,0x33,0x38,0x39,0x39,0x39,0x39,0x39,0x38,0x35,0x36,0x39,0x34,0x38,0x38,
    0x35,0x32,0x35,0x33,0x39,0x31,0x66,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x33,0x32,0x32,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x71,0x2e,
    0x78,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x33,0x32,0x34,0x20,0x3a,
    0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x71,0x2e,0x79,0x3b,0x0a,0x20,0x20,0x6c,0x65,
    0x74,0x20,0x78,0x5f,0x33,0x32,0x38,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x20,
    0x3d,0x20,0x63,0x6f,0x6c,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x63,0x6f,0x6c,0x5f,0x31,
    0x20,0x3d,0x20,0x28,0x78,0x5f,0x33,0x32,0x38,0x20,0x2b,0x20,0x28,0x76,0x65,0x63,
    0x33,0x66,0x28,0x30,0x2e,0x31,0x37,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x37,0x38,
    0x38,0x31,0x33,0x39,0x33,0x34,0x33,0x32,0x36,0x66,0x2c,0x20,0x30,0x2e,0x31,0x37,
    0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x37,0x38,0x38,0x31,0x33,0x39,0x33,0x34,0x33,
    0x32,0x36,0x66,0x2c,0x20,0x30,0x2e,0x31,0x37,0x30,0x30,0x30,0x30,0x30,0x30,0x31,
    0x37,0x38,0x38,0x31,0x33,0x39,0x33,0x34,0x33,0x32,0x36,0x66,0x29,0x20,0x2a,0x20,
    0x28,0x28,0x78,0x5f,0x33,0x32,0x32,0x20,0x2b,0x20,0x78,0x5f,0x33,0x32,0x34,0x29,
    0x20,0x2d,0x20,0x28,0x32,0x2e,0x30,0x66,0x20,0x2a,0x20,0x66,0x6c,0x6f,0x6f,0x72,
    0x28,0x28,0x28,0x78,0x5f,0x33,0x32,0x32,0x20,0x2b,0x20,0x78,0x5f,0x33,0x32,0x34,
    0x29,0x20,0x2f,0x20,0x32,0x2e,0x30,0x66,0x29,0x29,0x29,0x29,0x29,0x29,0x3b,0x0a,
    0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x33,0x33,0x30,0x20,0x3a,0x20,0x76,0x65,
    0x63,0x33,0x66,0x20,0x3d,0x20,0x63,0x6f,0x6c,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x72,
    0x65,0x74,0x75,0x72,0x6e,0x20,0x78,0x5f,0x33,0x33,0x30,0x3b,0x0a,0x7d,0x0a,0x0a,
    0x66,0x6e,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x5f,0x6e,0x5f,0x76,0x66,0x32,0x5f,
    0x66,0x31,0x5f,0x28,0x70,0x5f,0x31,0x20,0x3a,0x20,0x70,0x74,0x72,0x3c,0x66,0x75,
    0x6e,0x63,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x76,0x65,0x63,0x32,0x66,0x3e,0x2c,0x20,
    0x6e,0x20,0x3a,0x20,0x70,0x74,0x72,0x3c,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,
    0x2c,0x20,0x66,0x33,0x32,0x3e,0x29,0x20,0x2d,0x3e,0x20,0x66,0x33,0x32,0x20,0x7b,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x37,0x37,0x20,0x3a,0x20,0x76,0x65,
    0x63,0x32,0x66,0x20,0x3d,0x20,0x2a,0x28,0x70,0x5f,0x31,0x29,0x3b,0x0a,0x20,0x20,
    0x6c,0x65,0x74,0x20,0x78,0x5f,0x37,0x39,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,
    0x20,0x2a,0x28,0x6e,0x29,0x3b,0x0a,0x20,0x20,0x2a,0x28,0x70,0x5f,0x31,0x29,0x20,
    0x3d,0x20,0x70,0x6f,0x77,0x28,0x61,0x62,0x73,0x28,0x78,0x5f,0x37,0x37,0x29,0x2c,
    0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x78,0x5f,0x37,0x39,0x2c,0x20,0x78,0x5f,0x37,
    0x39,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x35,0x20,
    0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x28,0x2a,0x28,0x70,0x5f,0x31,0x29,0x29,
    0x2e,0x78,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x38,0x20,0x3a,
    0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x28,0x2a,0x28,0x70,0x5f,0x31,0x29,0x29,0x2e,
    0x79,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x39,0x31,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x20,0x3d,0x20,0x2a,0x28,0x6e,0x29,0x3b,0x0a,0x20,0x20,0x72,0x65,
    0x74,0x75,0x72,0x6e,0x20,0x70,0x6f,0x77,0x28,0x28,0x78,0x5f,0x38,0x35,0x20,0x2b,
    0x20,0x78,0x5f,0x38,0x38,0x29,0x2c,0x20,0x28,0x31,0x2e,0x30,0x66,0x20,0x2f,0x20,
    0x78,0x5f,0x39,0x31,0x29,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x6e,0x20,0x73,0x64,
    0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,0x64,0x5f,0x76,0x66,0x32,0x5f,0x76,
    0x66,0x32,0x5f,0x66,0x31,0x5f,0x28,0x70,0x5f,0x32,0x20,0x3a,0x20,0x70,0x74,0x72,
    0x3c,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x76,0x65,0x63,0x32,0x66,
    0x3e,0x2c,0x20,0x72,0x5f,0x31,0x20,0x3a,0x20,0x70,0x74,0x72,0x3c,0x66,0x75,0x6e,
    0x63,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x76,0x65,0x63,0x32,0x66,0x3e,0x2c,0x20,0x72,
    0x6f,0x75,0x6e,0x64,0x6e,0x65,0x73,0x73,0x20,0x3a,0x20,0x70,0x74,0x72,0x3c,0x66,
    0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x66,0x33,0x32,0x3e,0x29,0x20,0x2d,
    0x3e,0x20,0x66,0x33,0x32,0x20,0x7b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x6b,0x31,
    0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,
    0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x20,0x3a,0x20,0x66,0x33,0x32,
    0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x6b,0x32,0x20,0x3a,0x20,0x66,0x33,0x32,
    0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x20,
    0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x33,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,
    0x6c,0x65,0x74,0x20,0x78,0x5f,0x39,0x37,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,
    0x20,0x3d,0x20,0x2a,0x28,0x70,0x5f,0x32,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,
    0x20,0x78,0x5f,0x39,0x38,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,
    0x2a,0x28,0x72,0x5f,0x31,0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x20,
    0x3d,0x20,0x28,0x78,0x5f,0x39,0x37,0x20,0x2f,0x20,0x78,0x5f,0x39,0x38,0x29,0x3b,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x30,0x32,0x20,0x3a,0x20,0x66,
    0x33,0x32,0x20,0x3d,0x20,0x2a,0x28,0x72,0x6f,0x75,0x6e,0x64,0x6e,0x65,0x73,0x73,
    0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x20,0x3d,0x20,0x78,
    0x5f,0x31,0x30,0x32,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x30,
    0x33,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,
    0x5f,0x6e,0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x29,0x29,
    0x3b,0x0a,0x20,0x20,0x6b,0x31,0x20,0x3d,0x20,0x78,0x5f,0x31,0x30,0x33,0x3b,0x0a,
    0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x30,0x35,0x20,0x3a,0x20,0x76,0x65,
    0x63,0x32,0x66,0x20,0x3d,0x20,0x2a,0x28,0x70,0x5f,0x32,0x29,0x3b,0x0a,0x20,0x20,
    0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x30,0x36,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,
    0x66,0x20,0x3d,0x20,0x2a,0x28,0x72,0x5f,0x31,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,
    0x74,0x20,0x78,0x5f,0x31,0x30,0x37,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,
    0x3d,0x20,0x2a,0x28,0x72,0x5f,0x31,0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x32,0x20,0x3d,0x20,0x28,0x78,0x5f,0x31,0x30,0x35,0x20,0x2f,0x20,0x28,
    0x78,0x5f,0x31,0x30,0x36,0x20,0x2a,0x20,0x78,0x5f,0x31,0x30,0x37,0x29,0x29,0x3b,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x31,0x32,0x20,0x3a,0x20,0x66,
    0x33,0x32,0x20,0x3d,0x20,0x2a,0x28,0x72,0x6f,0x75,0x6e,0x64,0x6e,0x65,0x73,0x73,
    0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x20,0x3d,0x20,0x78,
    0x5f,0x31,0x31,0x32,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x31,
    0x33,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,
    0x5f,0x6e,0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x32,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,
    0x29,0x29,0x3b,0x0a,0x20,0x20,0x6b,0x32,0x20,0x3d,0x20,0x78,0x5f,0x31,0x31,0x33,
    0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x31,0x34,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x20,0x3d,0x20,0x6b,0x31,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x31,0x31,0x35,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x6b,0x31,
    0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x31,0x38,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x20,0x3d,0x20,0x6b,0x32,0x3b,0x0a,0x20,0x20,0x72,0x65,0x74,0x75,
    0x72,0x6e,0x20,0x28,0x28,0x78,0x5f,0x31,0x31,0x34,0x20,0x2a,0x20,0x28,0x78,0x5f,
    0x31,0x31,0x35,0x20,0x2d,0x20,0x31,0x2e,0x30,0x66,0x29,0x29,0x20,0x2f,0x20,0x78,
    0x5f,0x31,0x31,0x38,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x6e,0x20,0x62,0x6c,0x65,
    0x6e,0x64,0x5f,0x76,0x66,0x33,0x5f,0x76,0x66,0x33,0x5f,0x66,0x31,0x5f,0x28,0x63,
    0x6f,0x6c,0x20,0x3a,0x20,0x70,0x74,0x72,0x3c,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,
    0x6e,0x2c,0x20,0x76,0x65,0x63,0x33,0x66,0x3e,0x2c,0x20,0x6f,0x63,0x6f,0x6c,0x20,
    0x3a,0x20,0x70,0x74,0x72,0x3c,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x2c,0x20,
    0x76,0x65,0x63,0x33,0x66,0x3e,0x2c,0x20,0x64,0x5f,0x31,0x20,0x3a,0x20,0x70,0x74,
    0x72,0x3c,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x66,0x33,0x32,0x3e,
    0x29,0x20,0x2d,0x3e,0x20,0x76,0x65,0x63,0x33,0x66,0x20,0x7b,0x0a,0x20,0x20,0x6c,
    0x65,0x74,0x20,0x78,0x5f,0x33,0x33,0x33,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,
    0x20,0x3d,0x20,0x2a,0x28,0x6f,0x63,0x6f,0x6c,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,
    0x74,0x20,0x78,0x5f,0x33,0x33,0x34,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x20,
    0x3d,0x20,0x2a,0x28,0x63,0x6f,0x6c,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x33,0x33,0x36,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x2a,0x28,
    0x64,0x5f,0x31,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x33,0x33,
    0x37,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x6d,0x6f,0x6f,0x74,0x68,
    0x73,0x74,0x65,0x70,0x28,0x30,0x2e,0x35,0x66,0x2c,0x20,0x30,0x2e,0x30,0x66,0x2c,
    0x20,0x78,0x5f,0x33,0x33,0x36,0x29,0x3b,0x0a,0x20,0x20,0x72,0x65,0x74,0x75,0x72,
    0x6e,0x20,0x6d,0x69,0x78,0x28,0x78,0x5f,0x33,0x33,0x33,0x2c,0x20,0x78,0x5f,0x33,
    0x33,0x34,0x2c,0x20,0x76,0x65,0x63,0x33,0x66,0x28,0x78,0x5f,0x33,0x33,0x37,0x2c,
    0x20,0x78,0x5f,0x33,0x33,0x37,0x2c,0x20,0x78,0x5f,0x33,0x33,0x37,0x29,0x29,0x3b,
    0x0a,0x7d,0x0a,0x0a,0x66,0x6e,0x20,0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,0x5f,0x76,
    0x66,0x32,0x5f,0x76,0x66,0x32,0x5f,0x76,0x66,0x32,0x5f,0x28,0x70,0x5f,0x35,0x20,
    0x3a,0x20,0x70,0x74,0x72,0x3c,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x2c,0x20,
    0x76,0x65,0x63,0x32,0x66,0x3e,0x2c,0x20,0x61,0x20,0x3a,0x20,0x70,0x74,0x72,0x3c,
    0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x76,0x65,0x63,0x32,0x66,0x3e,
    0x2c,0x20,0x62,0x20,0x3a,0x20,0x70,0x74,0x72,0x3c,0x66,0x75,0x6e,0x63,0x74,0x69,
    0x6f,0x6e,0x2c,0x20,0x76,0x65,0x63,0x32,0x66,0x3e,0x29,0x20,0x2d,0x3e,0x20,0x66,
    0x33,0x32,0x20,0x7b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x20,0x3a,0x20,
    0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x62,0x61,0x20,
    0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x68,
    0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,
    0x32,0x33,0x38,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x2a,0x28,
    0x70,0x5f,0x35,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,0x33,
    0x39,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x2a,0x28,0x61,0x29,
    0x3b,0x0a,0x20,0x20,0x70,0x61,0x20,0x3d,0x20,0x28,0x78,0x5f,0x32,0x33,0x38,0x20,
    0x2d,0x20,0x78,0x5f,0x32,0x33,0x39,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x32,0x34,0x32,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,
    0x2a,0x28,0x62,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,0x34,
    0x33,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x2a,0x28,0x61,0x29,
    0x3b,0x0a,0x20,0x20,0x62,0x61,0x20,0x3d,0x20,0x28,0x78,0x5f,0x32,0x34,0x32,0x20,
    0x2d,0x20,0x78,0x5f,0x32,0x34,0x33,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x32,0x34,0x36,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,
    0x70,0x61,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,0x34,0x37,0x20,
    0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x62,0x61,0x3b,0x0a,0x20,0x20,
    0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,0x34,0x39,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,
    0x66,0x20,0x3d,0x20,0x62,0x61,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,
    0x32,0x35,0x30,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x62,0x61,
    0x3b,0x0a,0x20,0x20,0x68,0x20,0x3d,0x20,0x63,0x6c,0x61,0x6d,0x70,0x28,0x28,0x64,
    0x6f,0x74,0x28,0x78,0x5f,0x32,0x34,0x36,0x2c,0x20,0x78,0x5f,0x32,0x34,0x37,0x29,
    0x20,0x2f,0x20,0x64,0x6f,0x74,0x28,0x78,0x5f,0x32,0x34,0x39,0x2c,0x20,0x78,0x5f,
    0x32,0x35,0x30,0x29,0x29,0x2c,0x20,0x30,0x2e,0x30,0x66,0x2c,0x20,0x31,0x2e,0x30,
    0x66,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,0x35,0x34,0x20,
    0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x70,0x61,0x3b,0x0a,0x20,0x20,
    0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,0x35,0x35,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,
    0x66,0x20,0x3d,0x20,0x62,0x61,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,
    0x32,0x35,0x36,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x68,0x3b,0x0a,0x20,
    0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x28,0x28,
    0x78,0x5f,0x32,0x35,0x34,0x20,0x2d,0x20,0x28,0x78,0x5f,0x32,0x35,0x35,0x20,0x2a,
    0x20,0x78,0x5f,0x32,0x35,0x36,0x29,0x29,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x6e,
    0x20,0x72,0x6f,0x74,0x61,0x74,0x65,0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,0x28,
    0x70,0x5f,0x36,0x20,0x3a,0x20,0x70,0x74,0x72,0x3c,0x66,0x75,0x6e,0x63,0x74,0x69,
    0x6f,0x6e,0x2c,0x20,0x76,0x65,0x63,0x32,0x66,0x3e,0x2c,0x20,0x74,0x68,0x65,0x74,
    0x61,0x20,0x3a,0x20,0x70,0x74,0x72,0x3c,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,
    0x2c,0x20,0x66,0x33,0x32,0x3e,0x29,0x20,0x2d,0x3e,0x20,0x76,0x65,0x63,0x32,0x66,
    0x20,0x7b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x63,0x6f,0x73,0x74,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x73,0x69,0x6e,0x74,0x20,
    0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,
    0x36,0x33,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x2a,0x28,0x74,0x68,0x65,
    0x74,0x61,0x29,0x3b,0x0a,0x20,0x20,0x63,0x6f,0x73,0x74,0x20,0x3d,0x20,0x63,0x6f,
    0x73,0x28,0x78,0x5f,0x32,0x36,0x33,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x32,0x36,0x36,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x2a,0x28,
    0x74,0x68,0x65,0x74,0x61,0x29,0x3b,0x0a,0x20,0x20,0x73,0x69,0x6e,0x74,0x20,0x3d,
    0x20,0x73,0x69,0x6e,0x28,0x78,0x5f,0x32,0x36,0x36,0x29,0x3b,0x0a,0x20,0x20,0x6c,
    0x65,0x74,0x20,0x78,0x5f,0x32,0x36,0x39,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,
    0x20,0x28,0x2a,0x28,0x70,0x5f,0x36,0x29,0x29,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x6c,
    0x65,0x74,0x20,0x78,0x5f,0x32,0x37,0x30,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,
    0x20,0x63,0x6f,0x73,0x74,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,
    0x37,0x33,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x28,0x2a,0x28,0x70,0x5f,
    0x36,0x29,0x29,0x2e,0x79,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,
    0x37,0x34,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x69,0x6e,0x74,0x3b,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,0x37,0x38,0x20,0x3a,0x20,0x66,
    0x33,0x32,0x20,0x3d,0x20,0x28,0x2a,0x28,0x70,0x5f,0x36,0x29,0x29,0x2e,0x78,0x3b,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,0x37,0x39,0x20,0x3a,0x20,0x66,
    0x33,0x32,0x20,0x3d,0x20,0x73,0x69,0x6e,0x74,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,
    0x20,0x78,0x5f,0x32,0x38,0x32,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x28,
    0x2a,0x28,0x70,0x5f,0x36,0x29,0x29,0x2e,0x79,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,
    0x20,0x78,0x5f,0x32,0x38,0x33,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x63,
    0x6f,0x73,0x74,0x3b,0x0a,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x76,0x65,
    0x63,0x32,0x66,0x28,0x28,0x28,0x78,0x5f,0x32,0x36,0x39,0x20,0x2a,0x20,0x78,0x5f,
    0x32,0x37,0x30,0x29,0x20,0x2d,0x20,0x28,0x78,0x5f,0x32,0x37,0x33,0x20,0x2a,0x20,
    0x78,0x5f,0x32,0x37,0x34,0x29,0x29,0x2c,0x20,0x28,0x28,0x78,0x5f,0x32,0x37,0x38,
    0x20,0x2a,0x20,0x78,0x5f,0x32,0x37,0x39,0x29,0x20,0x2b,0x20,0x28,0x78,0x5f,0x32,
    0x38,0x32,0x20,0x2a,0x20,0x78,0x5f,0x32,0x38,0x33,0x29,0x29,0x29,0x3b,0x0a,0x7d,
    0x0a,0x0a,0x66,0x6e,0x20,0x73,0x64,0x5f,0x76,0x65,0x73,0x69,0x63,0x61,0x5f,0x76,
    0x66,0x32,0x5f,0x66,0x31,0x5f,0x66,0x31,0x5f,0x28,0x70,0x5f,0x33,0x20,0x3a,0x20,
    0x70,0x74,0x72,0x3c,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x76,0x65,
    0x63,0x32,0x66,0x3e,0x2c,0x20,0x72,0x5f,0x32,0x20,0x3a,0x20,0x70,0x74,0x72,0x3c,
    0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x66,0x33,0x32,0x3e,0x2c,0x20,
    0x64,0x20,0x3a,0x20,0x70,0x74,0x72,0x3c,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,
    0x2c,0x20,0x66,0x33,0x32,0x3e,0x29,0x20,0x2d,0x3e,0x20,0x66,0x33,0x32,0x20,0x7b,
    0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x62,0x5f,0x32,0x20,0x3a,0x20,0x66,0x33,0x32,
    0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x78,0x5f,0x31,0x34,0x35,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x32,0x32,
    0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x2a,0x28,0x70,0x5f,0x33,
    0x29,0x3b,0x0a,0x20,0x20,0x2a,0x28,0x70,0x5f,0x33,0x29,0x20,0x3d,0x20,0x61,0x62,
    0x73,0x28,0x78,0x5f,0x31,0x32,0x32,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x31,0x32,0x35,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x2a,0x28,
    0x72,0x5f,0x32,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x32,
    0x36,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x2a,0x28,0x72,0x5f,0x32,0x29,
    0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x32,0x38,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x20,0x3d,0x20,0x2a,0x28,0x64,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,
    0x74,0x20,0x78,0x5f,0x31,0x32,0x39,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,
    0x2a,0x28,0x64,0x29,0x3b,0x0a,0x20,0x20,0x62,0x5f,0x32,0x20,0x3d,0x20,0x73,0x71,
    0x72,0x74,0x28,0x28,0x28,0x78,0x5f,0x31,0x32,0x35,0x20,0x2a,0x20,0x78,0x5f,0x31,
    0x32,0x36,0x29,0x20,0x2d,0x20,0x28,0x78,0x5f,0x31,0x32,0x38,0x20,0x2a,0x20,0x78,
    0x5f,0x31,0x32,0x39,0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,
    0x5f,0x31,0x33,0x34,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x28,0x2a,0x28,
    0x70,0x5f,0x33,0x29,0x29,0x2e,0x79,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,
    0x5f,0x31,0x33,0x35,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x62,0x5f,0x32,
    0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x33,0x37,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x20,0x3d,0x20,0x2a,0x28,0x64,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,
    0x74,0x20,0x78,0x5f,0x31,0x34,0x30,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,
    0x28,0x2a,0x28,0x70,0x5f,0x33,0x29,0x29,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x6c,0x65,
    0x74,0x20,0x78,0x5f,0x31,0x34,0x31,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,
    0x62,0x5f,0x32,0x3b,0x0a,0x20,0x20,0x69,0x66,0x20,0x28,0x28,0x28,0x28,0x78,0x5f,
    0x31,0x33,0x34,0x20,0x2d,0x20,0x78,0x5f,0x31,0x33,0x35,0x29,0x20,0x2a,0x20,0x78,
    0x5f,0x31,0x33,0x37,0x29,0x20,0x3e,0x20,0x28,0x78,0x5f,0x31,0x34,0x30,0x20,0x2a,
    0x20,0x78,0x5f,0x31,0x34,0x31,0x29,0x29,0x29,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,
    0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x34,0x38,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,
    0x66,0x20,0x3d,0x20,0x2a,0x28,0x70,0x5f,0x33,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x35,0x30,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,
    0x3d,0x20,0x62,0x5f,0x32,0x3b,0x0a,0x20,0x20,0x20,0x20,0x78,0x5f,0x31,0x34,0x35,
    0x20,0x3d,0x20,0x6c,0x65,0x6e,0x67,0x74,0x68,0x28,0x28,0x78,0x5f,0x31,0x34,0x38,
    0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x30,0x2e,0x30,0x66,0x2c,0x20,0x78,
    0x5f,0x31,0x35,0x30,0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,0x7d,0x20,0x65,0x6c,0x73,
    0x65,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x35,
    0x35,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x2a,0x28,0x70,0x5f,
    0x33,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x35,
    0x36,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x2a,0x28,0x64,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x36,0x31,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x20,0x3d,0x20,0x2a,0x28,0x72,0x5f,0x32,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x78,0x5f,0x31,0x34,0x35,0x20,0x3d,0x20,0x28,0x6c,0x65,0x6e,0x67,0x74,
    0x68,0x28,0x28,0x78,0x5f,0x31,0x35,0x35,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x66,
    0x28,0x2d,0x28,0x78,0x5f,0x31,0x35,0x36,0x29,0x2c,0x20,0x30,0x2e,0x30,0x66,0x29,
    0x29,0x29,0x20,0x2d,0x20,0x78,0x5f,0x31,0x36,0x31,0x29,0x3b,0x0a,0x20,0x20,0x7d,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x36,0x33,0x20,0x3a,0x20,0x66,
    0x33,0x32,0x20,0x3d,0x20,0x78,0x5f,0x31,0x34,0x35,0x3b,0x0a,0x20,0x20,0x72,0x65,
    0x74,0x75,0x72,0x6e,0x20,0x78,0x5f,0x31,0x36,0x33,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,
    0x6e,0x20,0x73,0x6d,0x69,0x6e,0x5f,0x66,0x31,0x5f,0x66,0x31,0x5f,0x66,0x31,0x5f,
    0x28,0x61,0x5f,0x31,0x20,0x3a,0x20,0x70,0x74,0x72,0x3c,0x66,0x75,0x6e,0x63,0x74,
    0x69,0x6f,0x6e,0x2c,0x20,0x66,0x33,0x32,0x3e,0x2c,0x20,0x62,0x5f,0x31,0x20,0x3a,
    0x20,0x70,0x74,0x72,0x3c,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x66,
    0x33,0x32,0x3e,0x2c,0x20,0x6b,0x20,0x3a,0x20,0x70,0x74,0x72,0x3c,0x66,0x75,0x6e,
    0x63,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x66,0x33,0x32,0x3e,0x29,0x20,0x2d,0x3e,0x20,
    0x66,0x33,0x32,0x20,0x7b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x68,0x5f,0x31,0x20,
    0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,
    0x39,0x30,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x2a,0x28,0x6b,0x29,0x3b,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,0x39,0x31,0x20,0x3a,0x20,0x66,
    0x33,0x32,0x20,0x3d,0x20,0x2a,0x28,0x61,0x5f,0x31,0x29,0x3b,0x0a,0x20,0x20,0x6c,
    0x65,0x74,0x20,0x78,0x5f,0x32,0x39,0x32,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,
    0x20,0x2a,0x28,0x62,0x5f,0x31,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,
    0x5f,0x32,0x39,0x37,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x2a,0x28,0x6b,
    0x29,0x3b,0x0a,0x20,0x20,0x68,0x5f,0x31,0x20,0x3d,0x20,0x28,0x6d,0x61,0x78,0x28,
    0x28,0x78,0x5f,0x32,0x39,0x30,0x20,0x2d,0x20,0x61,0x62,0x73,0x28,0x28,0x78,0x5f,
    0x32,0x39,0x31,0x20,0x2d,0x20,0x78,0x5f,0x32,0x39,0x32,0x29,0x29,0x29,0x2c,0x20,
    0x30,0x2e,0x30,0x66,0x29,0x20,0x2f,0x20,0x78,0x5f,0x32,0x39,0x37,0x29,0x3b,0x0a,
    0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,0x39,0x39,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x20,0x3d,0x20,0x2a,0x28,0x61,0x5f,0x31,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,
    0x74,0x20,0x78,0x5f,0x33,0x30,0x30,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,
    0x2a,0x28,0x62,0x5f,0x31,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,
    0x33,0x30,0x32,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x68,0x5f,0x31,0x3b,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x33,0x30,0x33,0x20,0x3a,0x20,0x66,
    0x33,0x32,0x20,0x3d,0x20,0x68,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x33,0x30,0x35,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x2a,0x28,
    0x6b,0x29,0x3b,0x0a,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x28,0x6d,0x69,
    0x6e,0x28,0x78,0x5f,0x32,0x39,0x39,0x2c,0x20,0x78,0x5f,0x33,0x30,0x30,0x29,0x20,
    0x2d,0x20,0x28,0x28,0x28,0x78,0x5f,0x33,0x30,0x32,0x20,0x2a,0x20,0x78,0x5f,0x33,
    0x30,0x33,0x29,0x20,0x2a,0x20,0x78,0x5f,0x33,0x30,0x35,0x29,0x20,0x2a,0x20,0x30,
    0x2e,0x32,0x35,0x66,0x29,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x6e,0x20,0x73,0x64,
    0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,0x28,
    0x70,0x20,0x3a,0x20,0x70,0x74,0x72,0x3c,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,
    0x2c,0x20,0x76,0x65,0x63,0x32,0x66,0x3e,0x2c,0x20,0x72,0x20,0x3a,0x20,0x70,0x74,
    0x72,0x3c,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x66,0x33,0x32,0x3e,
    0x29,0x20,0x2d,0x3e,0x20,0x66,0x33,0x32,0x20,0x7b,0x0a,0x20,0x20,0x6c,0x65,0x74,
    0x20,0x78,0x5f,0x37,0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,
    0x2a,0x28,0x70,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x37,0x33,
    0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x2a,0x28,0x72,0x29,0x3b,0x0a,0x20,
    0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x28,0x6c,0x65,0x6e,0x67,0x74,0x68,0x28,
    0x78,0x5f,0x37,0x31,0x29,0x20,0x2d,0x20,0x78,0x5f,0x37,0x33,0x29,0x3b,0x0a,0x7d,
    0x0a,0x0a,0x66,0x6e,0x20,0x73,0x64,0x5f,0x61,0x72,0x63,0x5f,0x76,0x66,0x32,0x5f,
    0x66,0x31,0x5f,0x66,0x31,0x5f,0x66,0x31,0x5f,0x66,0x31,0x5f,0x28,0x70,0x5f,0x34,
    0x20,0x3a,0x20,0x70,0x74,0x72,0x3c,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x2c,
    0x20,0x76,0x65,0x63,0x32,0x66,0x3e,0x2c,0x20,0x74,0x61,0x20,0x3a,0x20,0x70,0x74,
    0x72,0x3c,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x66,0x33,0x32,0x3e,
    0x2c,0x20,0x74,0x62,0x20,0x3a,0x20,0x70,0x74,0x72,0x3c,0x66,0x75,0x6e,0x63,0x74,
    0x69,0x6f,0x6e,0x2c,0x20,0x66,0x33,0x32,0x3e,0x2c,0x20,0x72,0x61,0x20,0x3a,0x20,
    0x70,0x74,0x72,0x3c,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x66,0x33,
    0x32,0x3e,0x2c,0x20,0x72,0x62,0x20,0x3a,0x20,0x70,0x74,0x72,0x3c,0x66,0x75,0x6e,
    0x63,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x66,0x33,0x32,0x3e,0x29,0x20,0x2d,0x3e,0x20,
    0x66,0x33,0x32,0x20,0x7b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x73,0x63,0x61,0x20,
    0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x73,
    0x63,0x62,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,
    0x72,0x20,0x6b,0x5f,0x31,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,
    0x61,0x72,0x20,0x78,0x5f,0x32,0x30,0x39,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,
    0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x36,0x37,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x20,0x3d,0x20,0x2a,0x28,0x74,0x61,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,
    0x20,0x78,0x5f,0x31,0x36,0x39,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x2a,
    0x28,0x74,0x61,0x29,0x3b,0x0a,0x20,0x20,0x73,0x63,0x61,0x20,0x3d,0x20,0x76,0x65,
    0x63,0x32,0x66,0x28,0x63,0x6f,0x73,0x28,0x78,0x5f,0x31,0x36,0x37,0x29,0x2c,0x20,
    0x73,0x69,0x6e,0x28,0x78,0x5f,0x31,0x36,0x39,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6c,
    0x65,0x74,0x20,0x78,0x5f,0x31,0x37,0x33,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,
    0x20,0x2a,0x28,0x74,0x62,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,
    0x31,0x37,0x35,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x2a,0x28,0x74,0x62,
    0x29,0x3b,0x0a,0x20,0x20,0x73,0x63,0x62,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x66,
    0x28,0x63,0x6f,0x73,0x28,0x78,0x5f,0x31,0x37,0x33,0x29,0x2c,0x20,0x73,0x69,0x6e,
    0x28,0x78,0x5f,0x31,0x37,0x35,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x31,0x37,0x39,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x63,
    0x61,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x38,0x31,
    0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x63,0x61,0x2e,0x79,0x3b,0x0a,
    0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x38,0x33,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x20,0x3d,0x20,0x73,0x63,0x61,0x2e,0x79,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,
    0x20,0x78,0x5f,0x31,0x38,0x36,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,
    0x63,0x61,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x39,
    0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x2a,0x28,0x70,0x5f,
    0x34,0x29,0x3b,0x0a,0x20,0x20,0x2a,0x28,0x70,0x5f,0x34,0x29,0x20,0x3d,0x20,0x28,
    0x78,0x5f,0x31,0x39,0x31,0x20,0x2a,0x20,0x6d,0x61,0x74,0x32,0x78,0x32,0x66,0x28,
    0x76,0x65,0x63,0x32,0x66,0x28,0x78,0x5f,0x31,0x37,0x39,0x2c,0x20,0x78,0x5f,0x31,
    0x38,0x31,0x29,0x2c,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x2d,0x28,0x78,0x5f,0x31,
    0x38,0x33,0x29,0x2c,0x20,0x78,0x5f,0x31,0x38,0x36,0x29,0x29,0x29,0x3b,0x0a,0x20,
    0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x39,0x34,0x20,0x3a,0x20,0x66,0x33,0x32,
    0x20,0x3d,0x20,0x28,0x2a,0x28,0x70,0x5f,0x34,0x29,0x29,0x2e,0x78,0x3b,0x0a,0x20,
    0x20,0x28,0x2a,0x28,0x70,0x5f,0x34,0x29,0x29,0x2e,0x78,0x20,0x3d,0x20,0x61,0x62,
    0x73,0x28,0x78,0x5f,0x31,0x39,0x34,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x31,0x39,0x39,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x63,
    0x62,0x2e,0x79,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,0x30,0x31,
    0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x28,0x2a,0x28,0x70,0x5f,0x34,0x29,
    0x29,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,0x30,0x34,
    0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x63,0x62,0x2e,0x78,0x3b,0x0a,
    0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,0x30,0x36,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x20,0x3d,0x20,0x28,0x2a,0x28,0x70,0x5f,0x34,0x29,0x29,0x2e,0x79,0x3b,0x0a,
    0x20,0x20,0x69,0x66,0x20,0x28,0x28,0x28,0x78,0x5f,0x31,0x39,0x39,0x20,0x2a,0x20,
    0x78,0x5f,0x32,0x30,0x31,0x29,0x20,0x3e,0x20,0x28,0x78,0x5f,0x32,0x30,0x34,0x20,
    0x2a,0x20,0x78,0x5f,0x32,0x30,0x36,0x29,0x29,0x29,0x20,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,0x31,0x32,0x20,0x3a,0x20,0x76,0x65,0x63,
    0x32,0x66,0x20,0x3d,0x20,0x2a,0x28,0x70,0x5f,0x34,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,0x31,0x33,0x20,0x3a,0x20,0x76,0x65,0x63,
    0x32,0x66,0x20,0x3d,0x20,0x73,0x63,0x62,0x3b,0x0a,0x20,0x20,0x20,0x20,0x78,0x5f,
    0x32,0x30,0x39,0x20,0x3d,0x20,0x64,0x6f,0x74,0x28,0x78,0x5f,0x32,0x31,0x32,0x2c,
    0x20,0x78,0x5f,0x32,0x31,0x33,0x29,0x3b,0x0a,0x20,0x20,0x7d,0x20,0x65,0x6c,0x73,
    0x65,0x20,0x7b,0x0a,0x20,0x20,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,0x31,
    0x36,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x2a,0x28,0x70,0x5f,
    0x34,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x78,0x5f,0x32,0x30,0x39,0x20,0x3d,0x20,
    0x6c,0x65,0x6e,0x67,0x74,0x68,0x28,0x78,0x5f,0x32,0x31,0x36,0x29,0x3b,0x0a,0x20,
    0x20,0x7d,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,0x31,0x38,0x20,0x3a,
    0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x78,0x5f,0x32,0x30,0x39,0x3b,0x0a,0x20,0x20,
    0x6b,0x5f,0x31,0x20,0x3d,0x20,0x78,0x5f,0x32,0x31,0x38,0x3b,0x0a,0x20,0x20,0x6c,
    0x65,0x74,0x20,0x78,0x5f,0x32,0x31,0x39,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,
    0x20,0x3d,0x20,0x2a,0x28,0x70,0x5f,0x34,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,
    0x20,0x78,0x5f,0x32,0x32,0x30,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,
    0x20,0x2a,0x28,0x70,0x5f,0x34,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,
    0x5f,0x32,0x32,0x32,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x2a,0x28,0x72,
    0x61,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,0x32,0x33,0x20,
    0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x2a,0x28,0x72,0x61,0x29,0x3b,0x0a,0x20,
    0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,0x32,0x37,0x20,0x3a,0x20,0x66,0x33,0x32,
    0x20,0x3d,0x20,0x2a,0x28,0x72,0x61,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x32,0x32,0x39,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x6b,0x5f,
    0x31,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,0x33,0x33,0x20,0x3a,
    0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x2a,0x28,0x72,0x62,0x29,0x3b,0x0a,0x20,0x20,
    0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x28,0x73,0x71,0x72,0x74,0x28,0x28,0x28,0x64,
    0x6f,0x74,0x28,0x78,0x5f,0x32,0x31,0x39,0x2c,0x20,0x78,0x5f,0x32,0x32,0x30,0x29,
    0x20,0x2b,0x20,0x28,0x78,0x5f,0x32,0x32,0x32,0x20,0x2a,0x20,0x78,0x5f,0x32,0x32,
    0x33,0x29,0x29,0x20,0x2d,0x20,0x28,0x28,0x32,0x2e,0x30,0x66,0x20,0x2a,0x20,0x78,
    0x5f,0x32,0x32,0x37,0x29,0x20,0x2a,0x20,0x78,0x5f,0x32,0x32,0x39,0x29,0x29,0x29,
    0x20,0x2d,0x20,0x78,0x5f,0x32,0x33,0x33,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x63,0x6f,
    0x6e,0x73,0x74,0x20,0x78,0x5f,0x33,0x37,0x38,0x20,0x3d,0x20,0x76,0x65,0x63,0x33,
    0x66,0x28,0x30,0x2e,0x36,0x31,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x33,0x30,0x35,
    0x31,0x31,0x34,0x37,0x34,0x36,0x30,0x39,0x66,0x2c,0x20,0x30,0x2e,0x38,0x35,0x30,
    0x30,0x30,0x30,0x30,0x32,0x33,0x38,0x34,0x31,0x38,0x35,0x37,0x39,0x31,0x30,0x31,
    0x36,0x66,0x2c,0x20,0x30,0x2e,0x39,0x33,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,
    0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x66,0x29,0x3b,0x0a,0x0a,0x63,
    0x6f,0x6e,0x73,0x74,0x20,0x78,0x5f,0x34,0x32,0x32,0x20,0x3d,0x20,0x76,0x65,0x63,
    0x32,0x66,0x28,0x30,0x2e,0x30,0x66,0x2c,0x20,0x30,0x2e,0x30,0x66,0x29,0x3b,0x0a,
    0x0a,0x63,0x6f,0x6e,0x73,0x74,0x20,0x78,0x5f,0x34,0x32,0x33,0x20,0x3d,0x20,0x76,
    0x65,0x63,0x32,0x66,0x28,0x34,0x35,0x2e,0x30,0x66,0x2c,0x20,0x30,0x2e,0x30,0x66,
    0x29,0x3b,0x0a,0x0a,0x63,0x6f,0x6e,0x73,0x74,0x20,0x78,0x5f,0x34,0x38,0x37,0x20,
    0x3d,0x20,0x76,0x65,0x63,0x33,0x66,0x28,0x30,0x2e,0x31,0x31,0x39,0x39,0x39,0x39,
    0x39,0x39,0x37,0x33,0x31,0x37,0x37,0x39,0x30,0x39,0x38,0x35,0x31,0x31,0x66,0x2c,
    0x20,0x30,0x2e,0x31,0x31,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x33,0x31,0x37,0x37,
    0x39,0x30,0x39,0x38,0x35,0x31,0x31,0x66,0x2c,0x20,0x30,0x2e,0x31,0x31,0x39,0x39,
    0x39,0x39,0x39,0x39,0x37,0x33,0x31,0x37,0x37,0x39,0x30,0x39,0x38,0x35,0x31,0x31,
    0x66,0x29,0x3b,0x0a,0x0a,0x63,0x6f,0x6e,0x73,0x74,0x20,0x78,0x5f,0x38,0x31,0x36,
    0x20,0x3d,0x20,0x76,0x65,0x63,0x33,0x66,0x28,0x30,0x2e,0x36,0x37,0x30,0x30,0x30,
    0x30,0x30,0x31,0x36,0x36,0x38,0x39,0x33,0x30,0x30,0x35,0x33,0x37,0x31,0x31,0x66,
    0x2c,0x20,0x30,0x2e,0x33,0x36,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x33,0x30,0x35,
    0x31,0x31,0x34,0x37,0x34,0x36,0x30,0x39,0x66,0x2c,0x20,0x30,0x2e,0x33,0x31,0x39,
    0x39,0x39,0x39,0x39,0x39,0x32,0x38,0x34,0x37,0x34,0x34,0x32,0x36,0x32,0x36,0x39,
    0x35,0x66,0x29,0x3b,0x0a,0x0a,0x63,0x6f,0x6e,0x73,0x74,0x20,0x78,0x5f,0x38,0x34,
    0x38,0x20,0x3d,0x20,0x76,0x65,0x63,0x33,0x66,0x28,0x31,0x2e,0x30,0x66,0x2c,0x20,
    0x31,0x2e,0x30,0x66,0x2c,0x20,0x31,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x0a,0x66,0x6e,
    0x20,0x6d,0x61,0x70,0x5f,0x76,0x66,0x32,0x5f,0x28,0x70,0x5f,0x37,0x20,0x3a,0x20,
    0x70,0x74,0x72,0x3c,0x66,0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x76,0x65,
    0x63,0x32,0x66,0x3e,0x29,0x20,0x2d,0x3e,0x20,0x76,0x65,0x63,0x33,0x66,0x20,0x7b,
    0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x73,0x70,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,
    0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x6f,0x63,0x6f,0x6c,0x5f,0x31,0x20,
    0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x34,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,
    0x20,0x20,0x76,0x61,0x72,0x20,0x64,0x5f,0x32,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,
    0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x20,0x3a,
    0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x36,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,
    0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x20,0x3a,0x20,0x66,
    0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x38,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,
    0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,
    0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x71,0x5f,
    0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,
    0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x32,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x33,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,
    0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x64,0x32,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,
    0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x34,0x20,
    0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x35,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,
    0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x36,0x20,
    0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x37,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,
    0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x38,0x20,
    0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x39,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,
    0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x30,0x20,
    0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x32,0x31,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,
    0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x32,0x20,0x3a,0x20,
    0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x32,0x33,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,
    0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x34,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,
    0x35,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x36,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,
    0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,
    0x37,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x32,0x38,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,
    0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x39,0x20,
    0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x33,0x30,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,
    0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x31,0x20,0x3a,0x20,
    0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x33,0x32,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,
    0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x33,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x33,0x34,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,
    0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x35,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,
    0x36,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x37,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,
    0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,
    0x38,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x39,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,
    0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x30,0x20,
    0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x34,0x31,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,
    0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x32,0x20,0x3a,0x20,0x76,0x65,
    0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x34,0x33,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x34,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,
    0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,
    0x35,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x36,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,
    0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,
    0x37,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x34,0x38,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,
    0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x39,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x35,0x30,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,
    0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x31,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,
    0x32,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x33,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,
    0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,
    0x34,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x35,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,
    0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x36,0x20,
    0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x35,0x37,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,
    0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x38,0x20,0x3a,0x20,0x76,0x65,
    0x63,0x33,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x35,0x39,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x3b,0x0a,0x20,0x20,0x76,
    0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x30,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,
    0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x32,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,
    0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x33,0x20,
    0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x36,0x34,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,
    0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x35,0x20,0x3a,0x20,
    0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x36,0x36,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,
    0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x37,0x20,0x3a,0x20,0x76,0x65,
    0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x36,0x38,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x39,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,
    0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,
    0x30,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x37,0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,
    0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x32,0x20,
    0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x37,0x33,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,
    0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x34,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x37,0x35,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,
    0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x36,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,
    0x37,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x38,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,
    0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,
    0x39,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x38,0x30,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,
    0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x31,0x20,
    0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x38,0x32,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,
    0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x33,0x20,0x3a,0x20,
    0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x38,0x34,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,
    0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x35,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,
    0x36,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x38,0x37,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,
    0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x38,0x20,0x3a,0x20,
    0x76,0x65,0x63,0x33,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x38,0x39,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x3b,0x0a,0x20,
    0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x30,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x39,0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,
    0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x32,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,
    0x33,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x34,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,
    0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x35,0x20,
    0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x39,0x36,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,
    0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x37,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,
    0x38,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x39,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,
    0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x30,0x30,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,
    0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x30,0x32,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,
    0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x33,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x30,0x34,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,
    0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x35,0x20,0x3a,0x20,0x76,0x65,
    0x63,0x33,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x31,0x30,0x36,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,
    0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x37,0x20,0x3a,0x20,0x76,0x65,
    0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x31,0x30,0x38,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,
    0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x39,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x31,0x31,0x30,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x3b,0x0a,0x20,0x20,
    0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x31,0x20,0x3a,0x20,
    0x76,0x65,0x63,0x33,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x31,0x32,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,
    0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x33,0x20,0x3a,0x20,
    0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x31,0x34,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,
    0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x35,0x20,0x3a,0x20,
    0x76,0x65,0x63,0x33,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x31,0x36,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x3b,0x0a,
    0x20,0x20,0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x37,0x20,
    0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x33,
    0x34,0x33,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x2a,0x28,0x70,
    0x5f,0x37,0x29,0x3b,0x0a,0x20,0x20,0x2a,0x28,0x70,0x5f,0x37,0x29,0x20,0x3d,0x20,
    0x28,0x78,0x5f,0x33,0x34,0x33,0x20,0x2a,0x20,0x31,0x30,0x30,0x2e,0x30,0x66,0x29,
    0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x33,0x34,0x37,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x20,0x3d,0x20,0x28,0x2a,0x28,0x70,0x5f,0x37,0x29,0x29,0x2e,0x79,
    0x3b,0x0a,0x20,0x20,0x28,0x2a,0x28,0x70,0x5f,0x37,0x29,0x29,0x2e,0x79,0x20,0x3d,
    0x20,0x28,0x78,0x5f,0x33,0x34,0x37,0x20,0x2d,0x20,0x33,0x30,0x2e,0x30,0x66,0x29,
    0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x33,0x35,0x32,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x20,0x3d,0x20,0x28,0x2a,0x28,0x70,0x5f,0x37,0x29,0x29,0x2e,0x78,
    0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x33,0x35,0x35,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x20,0x3d,0x20,0x28,0x2a,0x28,0x70,0x5f,0x37,0x29,0x29,0x2e,0x79,
    0x3b,0x0a,0x20,0x20,0x73,0x70,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x61,
    0x62,0x73,0x28,0x78,0x5f,0x33,0x35,0x32,0x29,0x2c,0x20,0x78,0x5f,0x33,0x35,0x35,
    0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x33,0x35,0x38,0x20,0x3a,
    0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x2a,0x28,0x70,0x5f,0x37,0x29,0x3b,
    0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x20,0x3d,0x20,0x28,0x78,0x5f,
    0x33,0x35,0x38,0x20,0x2a,0x20,0x30,0x2e,0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x31,
    0x31,0x39,0x32,0x30,0x39,0x32,0x38,0x39,0x35,0x35,0x30,0x38,0x66,0x29,0x3b,0x0a,
    0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x33,0x36,0x32,0x20,0x3a,0x20,0x76,0x65,
    0x63,0x33,0x66,0x20,0x3d,0x20,0x62,0x61,0x63,0x6b,0x67,0x72,0x6f,0x75,0x6e,0x64,
    0x5f,0x76,0x66,0x32,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x29,
    0x29,0x3b,0x0a,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x5f,0x31,0x20,0x3d,0x20,0x78,0x5f,
    0x33,0x36,0x32,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x33,0x36,0x34,
    0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x2a,0x28,0x70,0x5f,0x37,
    0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x20,0x3d,0x20,0x28,
    0x78,0x5f,0x33,0x36,0x34,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x30,0x2e,
    0x30,0x66,0x2c,0x20,0x2d,0x39,0x37,0x2e,0x30,0x66,0x29,0x29,0x3b,0x0a,0x20,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,
    0x35,0x35,0x2e,0x30,0x66,0x2c,0x20,0x32,0x30,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x20,0x3d,0x20,0x32,0x2e,0x30,0x66,0x3b,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x33,0x37,0x34,0x20,0x3a,0x20,0x66,
    0x33,0x32,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,
    0x64,0x5f,0x76,0x66,0x32,0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x36,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x29,
    0x29,0x3b,0x0a,0x20,0x20,0x64,0x5f,0x32,0x20,0x3d,0x20,0x78,0x5f,0x33,0x37,0x34,
    0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x20,0x3d,0x20,0x78,0x5f,
    0x33,0x37,0x38,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x33,0x38,0x31,
    0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x5f,
    0x31,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x20,0x3d,0x20,0x78,
    0x5f,0x33,0x38,0x31,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x33,0x38,
    0x33,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x64,0x5f,0x32,0x3b,0x0a,0x20,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x20,0x3d,0x20,0x78,0x5f,0x33,0x38,
    0x33,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x33,0x38,0x34,0x20,0x3a,
    0x20,0x76,0x65,0x63,0x33,0x66,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x76,
    0x66,0x33,0x5f,0x76,0x66,0x33,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x38,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,
    0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x29,0x29,0x3b,
    0x0a,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x5f,0x31,0x20,0x3d,0x20,0x78,0x5f,0x33,0x38,
    0x34,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x33,0x38,0x36,0x20,0x3a,
    0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x73,0x70,0x3b,0x0a,0x20,0x20,0x71,
    0x5f,0x31,0x20,0x3d,0x20,0x78,0x5f,0x33,0x38,0x36,0x3b,0x0a,0x20,0x20,0x6c,0x65,
    0x74,0x20,0x78,0x5f,0x33,0x39,0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,
    0x3d,0x20,0x71,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x31,0x20,0x3d,0x20,0x78,0x5f,0x33,0x39,0x31,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x32,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x35,0x35,
    0x2e,0x30,0x66,0x2c,0x20,0x34,0x35,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x33,0x20,0x3d,0x20,0x32,0x2e,0x34,0x30,0x30,0x30,
    0x30,0x30,0x30,0x39,0x35,0x33,0x36,0x37,0x34,0x33,0x31,0x36,0x34,0x30,0x36,0x32,
    0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x33,0x39,0x34,0x20,0x3a,
    0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,
    0x6f,0x69,0x64,0x5f,0x76,0x66,0x32,0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,0x28,
    0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x29,0x2c,0x20,0x26,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x32,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x31,0x33,0x29,0x29,0x3b,0x0a,0x20,0x20,0x64,0x5f,0x32,0x20,0x3d,0x20,
    0x78,0x5f,0x33,0x39,0x34,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x33,
    0x39,0x37,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x71,0x5f,0x31,
    0x3b,0x0a,0x20,0x20,0x71,0x5f,0x31,0x20,0x3d,0x20,0x28,0x78,0x5f,0x33,0x39,0x37,
    0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x34,0x35,0x2e,0x30,0x66,0x2c,0x20,
    0x2d,0x31,0x35,0x2e,0x30,0x66,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x34,0x30,0x30,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x71,0x5f,
    0x31,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x30,0x32,
    0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x71,0x5f,0x31,0x2e,0x78,0x3b,0x0a,
    0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x31,0x33,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x20,0x3d,0x20,0x78,0x5f,0x34,0x30,0x38,0x2e,0x69,0x54,0x69,0x6d,0x65,0x3b,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x31,0x38,0x20,0x3a,0x20,0x66,
    0x33,0x32,0x20,0x3d,0x20,0x71,0x5f,0x31,0x2e,0x79,0x3b,0x0a,0x20,0x20,0x71,0x5f,
    0x31,0x2e,0x79,0x20,0x3d,0x20,0x28,0x78,0x5f,0x34,0x31,0x38,0x20,0x2b,0x20,0x28,
    0x28,0x28,0x78,0x5f,0x34,0x30,0x30,0x20,0x2a,0x20,0x78,0x5f,0x34,0x30,0x32,0x29,
    0x20,0x2a,0x20,0x30,0x2e,0x30,0x30,0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x32,
    0x36,0x30,0x37,0x37,0x30,0x33,0x32,0x30,0x39,0x66,0x29,0x20,0x2a,0x20,0x73,0x69,
    0x6e,0x28,0x28,0x78,0x5f,0x34,0x31,0x33,0x20,0x2a,0x20,0x31,0x2e,0x30,0x66,0x29,
    0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x32,0x35,
    0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x71,0x5f,0x31,0x3b,0x0a,
    0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x34,0x20,0x3d,0x20,0x78,0x5f,0x34,
    0x32,0x35,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x35,0x20,0x3d,
    0x20,0x78,0x5f,0x34,0x32,0x32,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x31,0x36,0x20,0x3d,0x20,0x78,0x5f,0x34,0x32,0x33,0x3b,0x0a,0x20,0x20,0x6c,0x65,
    0x74,0x20,0x78,0x5f,0x34,0x32,0x38,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,
    0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,0x5f,0x76,0x66,0x32,0x5f,0x76,0x66,0x32,0x5f,
    0x76,0x66,0x32,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x34,0x29,
    0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x35,0x29,0x2c,0x20,0x26,
    0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x36,0x29,0x29,0x3b,0x0a,0x20,0x20,0x64,
    0x32,0x20,0x3d,0x20,0x28,0x78,0x5f,0x34,0x32,0x38,0x20,0x2d,0x20,0x30,0x2e,0x32,
    0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x39,0x38,0x30,0x32,0x33,0x32,0x32,0x33,
    0x38,0x37,0x37,0x66,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,
    0x33,0x31,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x64,0x5f,0x32,0x3b,0x0a,
    0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x33,0x32,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x20,0x3d,0x20,0x64,0x32,0x3b,0x0a,0x20,0x20,0x64,0x5f,0x32,0x20,0x3d,0x20,
    0x6d,0x69,0x6e,0x28,0x78,0x5f,0x34,0x33,0x31,0x2c,0x20,0x78,0x5f,0x34,0x33,0x32,
    0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x33,0x36,0x20,0x3a,
    0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x71,0x5f,0x31,0x2e,0x79,0x3b,0x0a,0x20,0x20,
    0x71,0x5f,0x31,0x2e,0x79,0x20,0x3d,0x20,0x28,0x78,0x5f,0x34,0x33,0x36,0x20,0x2b,
    0x20,0x36,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,
    0x34,0x34,0x30,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x71,0x5f,0x31,0x2e,
    0x78,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x34,0x32,0x20,0x3a,
    0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x71,0x5f,0x31,0x2e,0x78,0x3b,0x0a,0x20,0x20,
    0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x34,0x36,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,
    0x3d,0x20,0x78,0x5f,0x34,0x30,0x38,0x2e,0x69,0x54,0x69,0x6d,0x65,0x3b,0x0a,0x20,
    0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x35,0x31,0x20,0x3a,0x20,0x66,0x33,0x32,
    0x20,0x3d,0x20,0x71,0x5f,0x31,0x2e,0x79,0x3b,0x0a,0x20,0x20,0x71,0x5f,0x31,0x2e,
    0x79,0x20,0x3d,0x20,0x28,0x78,0x5f,0x34,0x35,0x31,0x20,0x2b,0x20,0x28,0x28,0x28,
    0x78,0x5f,0x34,0x34,0x30,0x20,0x2a,0x20,0x78,0x5f,0x34,0x34,0x32,0x29,0x20,0x2a,
    0x20,0x30,0x2e,0x30,0x30,0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x36,0x30,
    0x37,0x37,0x30,0x33,0x32,0x30,0x39,0x66,0x29,0x20,0x2a,0x20,0x73,0x69,0x6e,0x28,
    0x28,0x78,0x5f,0x34,0x34,0x36,0x20,0x2a,0x20,0x32,0x2e,0x30,0x66,0x29,0x29,0x29,
    0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x35,0x35,0x20,0x3a,
    0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x71,0x5f,0x31,0x3b,0x0a,0x20,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x37,0x20,0x3d,0x20,0x78,0x5f,0x34,0x35,0x35,
    0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x38,0x20,0x3d,0x20,0x78,
    0x5f,0x34,0x32,0x32,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x39,
    0x20,0x3d,0x20,0x78,0x5f,0x34,0x32,0x33,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x34,0x35,0x38,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x64,
    0x5f,0x6c,0x69,0x6e,0x65,0x5f,0x76,0x66,0x32,0x5f,0x76,0x66,0x32,0x5f,0x76,0x66,
    0x32,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x37,0x29,0x2c,0x20,
    0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x38,0x29,0x2c,0x20,0x26,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x39,0x29,0x29,0x3b,0x0a,0x20,0x20,0x64,0x32,0x20,
    0x3d,0x20,0x28,0x78,0x5f,0x34,0x35,0x38,0x20,0x2d,0x20,0x30,0x2e,0x32,0x30,0x30,
    0x30,0x30,0x30,0x30,0x30,0x32,0x39,0x38,0x30,0x32,0x33,0x32,0x32,0x33,0x38,0x37,
    0x37,0x66,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x36,0x30,
    0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x64,0x5f,0x32,0x3b,0x0a,0x20,0x20,
    0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x36,0x31,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,
    0x3d,0x20,0x64,0x32,0x3b,0x0a,0x20,0x20,0x64,0x5f,0x32,0x20,0x3d,0x20,0x6d,0x69,
    0x6e,0x28,0x78,0x5f,0x34,0x36,0x30,0x2c,0x20,0x78,0x5f,0x34,0x36,0x31,0x29,0x3b,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x36,0x33,0x20,0x3a,0x20,0x76,
    0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x73,0x70,0x3b,0x0a,0x20,0x20,0x71,0x5f,0x31,
    0x20,0x3d,0x20,0x28,0x78,0x5f,0x34,0x36,0x33,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,
    0x66,0x28,0x33,0x32,0x2e,0x30,0x66,0x2c,0x20,0x33,0x30,0x2e,0x30,0x66,0x29,0x29,
    0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x36,0x39,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x20,0x3d,0x20,0x78,0x5f,0x34,0x30,0x38,0x2e,0x69,0x54,0x69,0x6d,
    0x65,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x37,0x34,0x20,0x3a,
    0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x71,0x5f,0x31,0x3b,0x0a,0x20,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x30,0x20,0x3d,0x20,0x78,0x5f,0x34,0x37,0x34,
    0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x31,0x20,0x3d,0x20,0x28,
    0x30,0x2e,0x36,0x39,0x39,0x39,0x39,0x39,0x39,0x38,0x38,0x30,0x37,0x39,0x30,0x37,
    0x31,0x30,0x34,0x34,0x39,0x32,0x66,0x20,0x2b,0x20,0x28,0x73,0x69,0x6e,0x28,0x78,
    0x5f,0x34,0x36,0x39,0x29,0x20,0x2a,0x20,0x30,0x2e,0x33,0x30,0x30,0x30,0x30,0x30,
    0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,0x38,0x39,0x35,0x35,0x30,0x38,0x66,0x29,
    0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x37,0x36,0x20,0x3a,
    0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x72,0x6f,0x74,0x61,0x74,0x65,0x5f,
    0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x32,0x30,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x31,0x29,
    0x29,0x3b,0x0a,0x20,0x20,0x71,0x5f,0x31,0x20,0x3d,0x20,0x78,0x5f,0x34,0x37,0x36,
    0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x37,0x39,0x20,0x3a,0x20,
    0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x71,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x32,0x32,0x20,0x3d,0x20,0x78,0x5f,0x34,0x37,0x39,0x3b,
    0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x33,0x20,0x3d,0x20,0x33,0x30,
    0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x34,0x20,
    0x3d,0x20,0x31,0x35,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,
    0x5f,0x34,0x38,0x32,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x64,0x5f,
    0x76,0x65,0x73,0x69,0x63,0x61,0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,0x66,0x31,
    0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x32,0x29,0x2c,0x20,0x26,
    0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x33,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x32,0x34,0x29,0x29,0x3b,0x0a,0x20,0x20,0x64,0x32,0x20,0x3d,
    0x20,0x78,0x5f,0x34,0x38,0x32,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,
    0x34,0x38,0x33,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x64,0x5f,0x32,0x3b,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x38,0x34,0x20,0x3a,0x20,0x66,
    0x33,0x32,0x20,0x3d,0x20,0x64,0x32,0x3b,0x0a,0x20,0x20,0x64,0x5f,0x32,0x20,0x3d,
    0x20,0x6d,0x69,0x6e,0x28,0x78,0x5f,0x34,0x38,0x33,0x2c,0x20,0x78,0x5f,0x34,0x38,
    0x34,0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x35,0x20,0x3d,
    0x20,0x78,0x5f,0x34,0x38,0x37,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,
    0x34,0x39,0x30,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x20,0x3d,0x20,0x6f,0x63,
    0x6f,0x6c,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x36,
    0x20,0x3d,0x20,0x78,0x5f,0x34,0x39,0x30,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x34,0x39,0x32,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x64,0x5f,
    0x32,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x37,0x20,0x3d,0x20,
    0x78,0x5f,0x34,0x39,0x32,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,
    0x39,0x33,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x20,0x3d,0x20,0x62,0x6c,0x65,
    0x6e,0x64,0x5f,0x76,0x66,0x33,0x5f,0x76,0x66,0x33,0x5f,0x66,0x31,0x5f,0x28,0x26,
    0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x32,0x35,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x32,0x36,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x32,0x37,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x5f,0x31,0x20,
    0x3d,0x20,0x78,0x5f,0x34,0x39,0x33,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,
    0x5f,0x34,0x39,0x34,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x73,
    0x70,0x3b,0x0a,0x20,0x20,0x71,0x5f,0x31,0x20,0x3d,0x20,0x78,0x5f,0x34,0x39,0x34,
    0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x39,0x35,0x20,0x3a,0x20,
    0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x71,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x32,0x38,0x20,0x3d,0x20,0x28,0x78,0x5f,0x34,0x39,0x35,
    0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x30,0x2e,0x30,0x66,0x2c,0x20,0x2d,
    0x36,0x30,0x2e,0x30,0x66,0x29,0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x32,0x39,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x32,0x37,0x2e,0x30,
    0x66,0x2c,0x20,0x32,0x30,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x33,0x30,0x20,0x3d,0x20,0x32,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,
    0x6c,0x65,0x74,0x20,0x78,0x5f,0x35,0x30,0x34,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,
    0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,0x64,0x5f,0x76,
    0x66,0x32,0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x32,0x38,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x32,0x39,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x30,0x29,
    0x29,0x3b,0x0a,0x20,0x20,0x64,0x5f,0x32,0x20,0x3d,0x20,0x78,0x5f,0x35,0x30,0x34,
    0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x35,0x30,0x35,0x20,0x3a,0x20,
    0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x71,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x33,0x31,0x20,0x3d,0x20,0x28,0x78,0x5f,0x35,0x30,0x35,
    0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x30,0x2e,0x30,0x66,0x2c,0x20,0x2d,
    0x37,0x30,0x2e,0x30,0x66,0x29,0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x33,0x32,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x32,0x30,0x2e,0x30,
    0x66,0x2c,0x20,0x31,0x36,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x33,0x33,0x20,0x3d,0x20,0x32,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,
    0x6c,0x65,0x74,0x20,0x78,0x5f,0x35,0x31,0x34,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,
    0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,0x64,0x5f,0x76,
    0x66,0x32,0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x33,0x31,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x33,0x32,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x33,0x29,
    0x29,0x3b,0x0a,0x20,0x20,0x64,0x32,0x20,0x3d,0x20,0x78,0x5f,0x35,0x31,0x34,0x3b,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x35,0x31,0x35,0x20,0x3a,0x20,0x66,
    0x33,0x32,0x20,0x3d,0x20,0x64,0x32,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,
    0x5f,0x35,0x31,0x37,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x64,0x5f,0x32,
    0x3b,0x0a,0x20,0x20,0x64,0x5f,0x32,0x20,0x3d,0x20,0x6d,0x61,0x78,0x28,0x2d,0x28,
    0x78,0x5f,0x35,0x31,0x35,0x29,0x2c,0x20,0x78,0x5f,0x35,0x31,0x37,0x29,0x3b,0x0a,
    0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x35,0x31,0x39,0x20,0x3a,0x20,0x76,0x65,
    0x63,0x32,0x66,0x20,0x3d,0x20,0x73,0x70,0x3b,0x0a,0x20,0x20,0x71,0x5f,0x31,0x20,
    0x3d,0x20,0x28,0x78,0x5f,0x35,0x31,0x39,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x66,
    0x28,0x36,0x2e,0x30,0x66,0x2c,0x20,0x2d,0x35,0x30,0x2e,0x30,0x66,0x29,0x29,0x3b,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x35,0x32,0x34,0x20,0x3a,0x20,0x66,
    0x33,0x32,0x20,0x3d,0x20,0x78,0x5f,0x34,0x30,0x38,0x2e,0x69,0x54,0x69,0x6d,0x65,
    0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x35,0x33,0x32,0x20,0x3a,0x20,
    0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x71,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x33,0x34,0x20,0x3d,0x20,0x78,0x5f,0x35,0x33,0x32,0x3b,
    0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x35,0x20,0x3d,0x20,0x28,0x2d,
    0x28,0x28,0x30,0x2e,0x35,0x66,0x20,0x2b,0x20,0x28,0x30,0x2e,0x35,0x66,0x20,0x2a,
    0x20,0x73,0x69,0x6e,0x28,0x78,0x5f,0x35,0x32,0x34,0x29,0x29,0x29,0x29,0x20,0x2a,
    0x20,0x30,0x2e,0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x39,0x30,0x31,
    0x31,0x36,0x31,0x31,0x39,0x33,0x38,0x66,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,
    0x20,0x78,0x5f,0x35,0x33,0x34,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,
    0x20,0x72,0x6f,0x74,0x61,0x74,0x65,0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,0x28,
    0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x34,0x29,0x2c,0x20,0x26,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x33,0x35,0x29,0x29,0x3b,0x0a,0x20,0x20,0x71,0x5f,0x31,
    0x20,0x3d,0x20,0x78,0x5f,0x35,0x33,0x34,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x35,0x33,0x37,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x71,0x5f,
    0x31,0x2e,0x79,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x35,0x34,0x34,
    0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x71,0x5f,0x31,0x2e,0x78,0x3b,0x0a,
    0x20,0x20,0x71,0x5f,0x31,0x2e,0x78,0x20,0x3d,0x20,0x28,0x78,0x5f,0x35,0x34,0x34,
    0x20,0x2d,0x20,0x28,0x70,0x6f,0x77,0x28,0x6d,0x61,0x78,0x28,0x28,0x2d,0x34,0x35,
    0x2e,0x30,0x66,0x20,0x2d,0x20,0x78,0x5f,0x35,0x33,0x37,0x29,0x2c,0x20,0x30,0x2e,
    0x30,0x66,0x29,0x2c,0x20,0x31,0x2e,0x38,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,
    0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x66,0x29,0x20,0x2a,0x20,
    0x30,0x2e,0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x39,0x30,0x31,0x31,
    0x36,0x31,0x31,0x39,0x33,0x38,0x66,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,
    0x20,0x78,0x5f,0x35,0x34,0x39,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,
    0x20,0x71,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x36,
    0x20,0x3d,0x20,0x78,0x5f,0x35,0x34,0x39,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x33,0x37,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x30,0x2e,0x30,
    0x66,0x2c,0x20,0x2d,0x35,0x30,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x33,0x38,0x20,0x3d,0x20,0x78,0x5f,0x34,0x32,0x32,0x3b,0x0a,
    0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x35,0x35,0x32,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x20,0x3d,0x20,0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,0x5f,0x76,0x66,0x32,0x5f,
    0x76,0x66,0x32,0x5f,0x76,0x66,0x32,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x33,0x36,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x37,
    0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x38,0x29,0x29,0x3b,
    0x0a,0x20,0x20,0x64,0x32,0x20,0x3d,0x20,0x28,0x78,0x5f,0x35,0x35,0x32,0x20,0x2d,
    0x20,0x35,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,
    0x35,0x35,0x36,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x64,0x5f,0x32,0x3b,
    0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,0x39,0x20,0x3d,0x20,0x78,0x5f,
    0x35,0x35,0x36,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x35,0x35,0x38,
    0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x64,0x32,0x3b,0x0a,0x20,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x34,0x30,0x20,0x3d,0x20,0x78,0x5f,0x35,0x35,0x38,0x3b,
    0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x31,0x20,0x3d,0x20,0x31,0x2e,
    0x30,0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x35,0x36,0x30,0x20,
    0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x6d,0x69,0x6e,0x5f,0x66,0x31,0x5f,
    0x66,0x31,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x33,
    0x39,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x30,0x29,0x2c,
    0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x31,0x29,0x29,0x3b,0x0a,0x20,
    0x20,0x64,0x5f,0x32,0x20,0x3d,0x20,0x78,0x5f,0x35,0x36,0x30,0x3b,0x0a,0x20,0x20,
    0x6c,0x65,0x74,0x20,0x78,0x5f,0x35,0x36,0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,
    0x66,0x20,0x3d,0x20,0x73,0x70,0x3b,0x0a,0x20,0x20,0x71,0x5f,0x31,0x20,0x3d,0x20,
    0x28,0x78,0x5f,0x35,0x36,0x31,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x32,
    0x32,0x2e,0x30,0x66,0x2c,0x20,0x2d,0x36,0x30,0x2e,0x30,0x66,0x29,0x29,0x3b,0x0a,
    0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x35,0x36,0x36,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x20,0x3d,0x20,0x78,0x5f,0x34,0x30,0x38,0x2e,0x69,0x54,0x69,0x6d,0x65,0x3b,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x35,0x37,0x33,0x20,0x3a,0x20,0x76,
    0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x71,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x34,0x32,0x20,0x3d,0x20,0x78,0x5f,0x35,0x37,0x33,0x3b,0x0a,
    0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x33,0x20,0x3d,0x20,0x28,0x2d,0x28,
    0x28,0x30,0x2e,0x35,0x66,0x20,0x2b,0x20,0x28,0x30,0x2e,0x35,0x66,0x20,0x2a,0x20,
    0x63,0x6f,0x73,0x28,0x78,0x5f,0x35,0x36,0x36,0x29,0x29,0x29,0x29,0x20,0x2a,0x20,
    0x30,0x2e,0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x39,0x30,0x31,0x31,
    0x36,0x31,0x31,0x39,0x33,0x38,0x66,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x35,0x37,0x35,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,
    0x72,0x6f,0x74,0x61,0x74,0x65,0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,0x28,0x26,
    0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x32,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x34,0x33,0x29,0x29,0x3b,0x0a,0x20,0x20,0x71,0x5f,0x31,0x20,
    0x3d,0x20,0x78,0x5f,0x35,0x37,0x35,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,
    0x5f,0x35,0x37,0x38,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x71,0x5f,0x31,
    0x2e,0x79,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x35,0x38,0x34,0x20,
    0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x71,0x5f,0x31,0x2e,0x78,0x3b,0x0a,0x20,
    0x20,0x71,0x5f,0x31,0x2e,0x78,0x20,0x3d,0x20,0x28,0x78,0x5f,0x35,0x38,0x34,0x20,
    0x2d,0x20,0x28,0x70,0x6f,0x77,0x28,0x6d,0x61,0x78,0x28,0x28,0x2d,0x32,0x39,0x2e,
    0x30,0x66,0x20,0x2d,0x20,0x78,0x5f,0x35,0x37,0x38,0x29,0x2c,0x20,0x30,0x2e,0x30,
    0x66,0x29,0x2c,0x20,0x31,0x2e,0x38,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,0x31,
    0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,0x38,0x34,0x66,0x29,0x20,0x2a,0x20,0x30,
    0x2e,0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x34,0x39,0x30,0x31,0x31,0x36,
    0x31,0x31,0x39,0x33,0x38,0x66,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x35,0x39,0x30,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,
    0x71,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x34,0x20,
    0x3d,0x20,0x78,0x5f,0x35,0x39,0x30,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x34,0x35,0x20,0x3d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x30,0x2e,0x30,0x66,
    0x2c,0x20,0x2d,0x33,0x35,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x34,0x36,0x20,0x3d,0x20,0x78,0x5f,0x34,0x32,0x32,0x3b,0x0a,0x20,
    0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x35,0x39,0x33,0x20,0x3a,0x20,0x66,0x33,0x32,
    0x20,0x3d,0x20,0x73,0x64,0x5f,0x6c,0x69,0x6e,0x65,0x5f,0x76,0x66,0x32,0x5f,0x76,
    0x66,0x32,0x5f,0x76,0x66,0x32,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x34,0x34,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x35,0x29,
    0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x36,0x29,0x29,0x3b,0x0a,
    0x20,0x20,0x64,0x32,0x20,0x3d,0x20,0x28,0x78,0x5f,0x35,0x39,0x33,0x20,0x2d,0x20,
    0x35,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x35,
    0x39,0x36,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x64,0x5f,0x32,0x3b,0x0a,
    0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x37,0x20,0x3d,0x20,0x78,0x5f,0x35,
    0x39,0x36,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x35,0x39,0x38,0x20,
    0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x64,0x32,0x3b,0x0a,0x20,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x34,0x38,0x20,0x3d,0x20,0x78,0x5f,0x35,0x39,0x38,0x3b,0x0a,
    0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x39,0x20,0x3d,0x20,0x31,0x2e,0x30,
    0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x36,0x30,0x30,0x20,0x3a,
    0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x6d,0x69,0x6e,0x5f,0x66,0x31,0x5f,0x66,
    0x31,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x37,
    0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x38,0x29,0x2c,0x20,
    0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x34,0x39,0x29,0x29,0x3b,0x0a,0x20,0x20,
    0x64,0x5f,0x32,0x20,0x3d,0x20,0x78,0x5f,0x36,0x30,0x30,0x3b,0x0a,0x20,0x20,0x6c,
    0x65,0x74,0x20,0x78,0x5f,0x36,0x30,0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,
    0x20,0x3d,0x20,0x2a,0x28,0x70,0x5f,0x37,0x29,0x3b,0x0a,0x20,0x20,0x71,0x5f,0x31,
    0x20,0x3d,0x20,0x28,0x78,0x5f,0x36,0x30,0x31,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,
    0x66,0x28,0x2d,0x32,0x36,0x2e,0x30,0x66,0x2c,0x20,0x2d,0x36,0x30,0x2e,0x30,0x66,
    0x29,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x36,0x30,0x37,0x20,
    0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x71,0x5f,0x31,0x3b,0x0a,0x20,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x30,0x20,0x3d,0x20,0x78,0x5f,0x36,0x30,
    0x37,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x31,0x20,0x3d,0x20,
    0x32,0x2e,0x31,0x39,0x39,0x31,0x31,0x34,0x37,0x39,0x39,0x34,0x39,0x39,0x35,0x31,
    0x31,0x37,0x31,0x38,0x37,0x35,0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,
    0x5f,0x36,0x30,0x39,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x72,
    0x6f,0x74,0x61,0x74,0x65,0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x30,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x35,0x31,0x29,0x29,0x3b,0x0a,0x20,0x20,0x71,0x5f,0x31,0x20,0x3d,
    0x20,0x78,0x5f,0x36,0x30,0x39,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,
    0x36,0x31,0x31,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x71,0x5f,0x31,0x2e,
    0x79,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x36,0x32,0x30,0x20,0x3a,
    0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x71,0x5f,0x31,0x2e,0x79,0x3b,0x0a,0x20,0x20,
    0x6c,0x65,0x74,0x20,0x78,0x5f,0x36,0x32,0x33,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,
    0x3d,0x20,0x78,0x5f,0x34,0x30,0x38,0x2e,0x69,0x54,0x69,0x6d,0x65,0x3b,0x0a,0x20,
    0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x36,0x33,0x30,0x20,0x3a,0x20,0x66,0x33,0x32,
    0x20,0x3d,0x20,0x71,0x5f,0x31,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x71,0x5f,0x31,0x2e,
    0x78,0x20,0x3d,0x20,0x28,0x78,0x5f,0x36,0x33,0x30,0x20,0x2d,0x20,0x28,0x28,0x73,
    0x69,0x6e,0x28,0x28,0x28,0x78,0x5f,0x36,0x31,0x31,0x20,0x2a,0x20,0x30,0x2e,0x31,
    0x32,0x33,0x30,0x30,0x30,0x30,0x30,0x33,0x33,0x39,0x37,0x34,0x36,0x34,0x37,0x35,
    0x32,0x32,0x66,0x29,0x20,0x2b,0x20,0x33,0x2e,0x30,0x66,0x29,0x29,0x20,0x2a,0x20,
    0x34,0x2e,0x30,0x66,0x29,0x20,0x2b,0x20,0x73,0x69,0x6e,0x28,0x28,0x28,0x78,0x5f,
    0x36,0x32,0x30,0x20,0x2a,0x20,0x30,0x2e,0x31,0x30,0x30,0x30,0x30,0x30,0x30,0x30,
    0x31,0x34,0x39,0x30,0x31,0x31,0x36,0x31,0x31,0x39,0x33,0x38,0x66,0x29,0x20,0x2b,
    0x20,0x28,0x78,0x5f,0x36,0x32,0x33,0x20,0x2a,0x20,0x31,0x30,0x2e,0x30,0x66,0x29,
    0x29,0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x36,0x33,
    0x36,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x71,0x5f,0x31,0x3b,
    0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x32,0x20,0x3d,0x20,0x78,0x5f,
    0x36,0x33,0x36,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x33,0x20,
    0x3d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x30,0x2e,0x30,0x66,0x2c,0x20,0x2d,0x34,
    0x30,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,
    0x34,0x20,0x3d,0x20,0x78,0x5f,0x34,0x32,0x32,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,
    0x20,0x78,0x5f,0x36,0x33,0x39,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,
    0x64,0x5f,0x6c,0x69,0x6e,0x65,0x5f,0x76,0x66,0x32,0x5f,0x76,0x66,0x32,0x5f,0x76,
    0x66,0x32,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x32,0x29,0x2c,
    0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x33,0x29,0x2c,0x20,0x26,0x28,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x34,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,
    0x74,0x20,0x78,0x5f,0x36,0x34,0x31,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,
    0x71,0x5f,0x31,0x2e,0x79,0x3b,0x0a,0x20,0x20,0x64,0x32,0x20,0x3d,0x20,0x28,0x78,
    0x5f,0x36,0x33,0x39,0x20,0x2d,0x20,0x28,0x35,0x2e,0x30,0x66,0x20,0x2a,0x20,0x73,
    0x6d,0x6f,0x6f,0x74,0x68,0x73,0x74,0x65,0x70,0x28,0x2d,0x36,0x30,0x2e,0x30,0x66,
    0x2c,0x20,0x30,0x2e,0x30,0x66,0x2c,0x20,0x78,0x5f,0x36,0x34,0x31,0x29,0x29,0x29,
    0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x36,0x34,0x36,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x20,0x3d,0x20,0x64,0x5f,0x32,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x35,0x35,0x20,0x3d,0x20,0x78,0x5f,0x36,0x34,0x36,0x3b,0x0a,0x20,
    0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x36,0x34,0x38,0x20,0x3a,0x20,0x66,0x33,0x32,
    0x20,0x3d,0x20,0x64,0x32,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,
    0x36,0x20,0x3d,0x20,0x78,0x5f,0x36,0x34,0x38,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x35,0x37,0x20,0x3d,0x20,0x31,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,
    0x6c,0x65,0x74,0x20,0x78,0x5f,0x36,0x35,0x30,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,
    0x3d,0x20,0x73,0x6d,0x69,0x6e,0x5f,0x66,0x31,0x5f,0x66,0x31,0x5f,0x66,0x31,0x5f,
    0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x35,0x29,0x2c,0x20,0x26,0x28,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x36,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x35,0x37,0x29,0x29,0x3b,0x0a,0x20,0x20,0x64,0x5f,0x32,0x20,0x3d,
    0x20,0x78,0x5f,0x36,0x35,0x30,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x35,0x38,0x20,0x3d,0x20,0x78,0x5f,0x34,0x38,0x37,0x3b,0x0a,0x20,0x20,0x6c,0x65,
    0x74,0x20,0x78,0x5f,0x36,0x35,0x33,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x20,
    0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x35,0x39,0x20,0x3d,0x20,0x78,0x5f,0x36,0x35,0x33,0x3b,0x0a,0x20,0x20,
    0x6c,0x65,0x74,0x20,0x78,0x5f,0x36,0x35,0x35,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,
    0x3d,0x20,0x64,0x5f,0x32,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,
    0x30,0x20,0x3d,0x20,0x78,0x5f,0x36,0x35,0x35,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,
    0x20,0x78,0x5f,0x36,0x35,0x36,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x20,0x3d,
    0x20,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x76,0x66,0x33,0x5f,0x76,0x66,0x33,0x5f,0x66,
    0x31,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x38,0x29,0x2c,0x20,
    0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x35,0x39,0x29,0x2c,0x20,0x26,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x36,0x30,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6f,0x63,0x6f,
    0x6c,0x5f,0x31,0x20,0x3d,0x20,0x78,0x5f,0x36,0x35,0x36,0x3b,0x0a,0x20,0x20,0x6c,
    0x65,0x74,0x20,0x78,0x5f,0x36,0x35,0x37,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,
    0x20,0x3d,0x20,0x71,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x36,0x31,0x20,0x3d,0x20,0x28,0x78,0x5f,0x36,0x35,0x37,0x20,0x2d,0x20,0x76,0x65,
    0x63,0x32,0x66,0x28,0x2d,0x32,0x2e,0x30,0x66,0x2c,0x20,0x2d,0x34,0x2e,0x30,0x66,
    0x29,0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x32,0x20,0x3d,
    0x20,0x31,0x2e,0x32,0x39,0x39,0x39,0x39,0x39,0x39,0x35,0x32,0x33,0x31,0x36,0x32,
    0x38,0x34,0x31,0x37,0x39,0x36,0x39,0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x36,0x36,0x35,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x64,
    0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,0x28,
    0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x31,0x29,0x2c,0x20,0x26,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x36,0x32,0x29,0x29,0x3b,0x0a,0x20,0x20,0x64,0x5f,0x32,
    0x20,0x3d,0x20,0x78,0x5f,0x36,0x36,0x35,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x36,0x36,0x36,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x64,0x5f,
    0x32,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x36,0x36,0x37,0x20,0x3a,
    0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x71,0x5f,0x31,0x3b,0x0a,0x20,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x33,0x20,0x3d,0x20,0x28,0x78,0x5f,0x36,0x36,
    0x37,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x2d,0x32,0x2e,0x30,0x66,0x2c,
    0x20,0x2d,0x39,0x2e,0x30,0x66,0x29,0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x36,0x34,0x20,0x3d,0x20,0x31,0x2e,0x32,0x30,0x30,0x30,0x30,0x30,0x30,
    0x34,0x37,0x36,0x38,0x33,0x37,0x31,0x35,0x38,0x32,0x30,0x33,0x31,0x66,0x3b,0x0a,
    0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x36,0x37,0x34,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x20,0x3d,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x5f,0x76,0x66,
    0x32,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x33,
    0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x34,0x29,0x29,0x3b,
    0x0a,0x20,0x20,0x64,0x5f,0x32,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x78,0x5f,0x36,
    0x36,0x36,0x2c,0x20,0x78,0x5f,0x36,0x37,0x34,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,
    0x74,0x20,0x78,0x5f,0x36,0x37,0x36,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,
    0x64,0x5f,0x32,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x36,0x37,0x37,
    0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x71,0x5f,0x31,0x3b,0x0a,
    0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x35,0x20,0x3d,0x20,0x28,0x78,0x5f,
    0x36,0x37,0x37,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x2d,0x32,0x2e,0x30,
    0x66,0x2c,0x20,0x2d,0x31,0x35,0x2e,0x30,0x66,0x29,0x29,0x3b,0x0a,0x20,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x36,0x36,0x20,0x3d,0x20,0x31,0x2e,0x31,0x30,0x30,0x30,
    0x30,0x30,0x30,0x32,0x33,0x38,0x34,0x31,0x38,0x35,0x37,0x39,0x31,0x30,0x31,0x36,
    0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x36,0x38,0x33,0x20,0x3a,
    0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,
    0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x36,0x35,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x36,
    0x29,0x29,0x3b,0x0a,0x20,0x20,0x64,0x5f,0x32,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,
    0x78,0x5f,0x36,0x37,0x36,0x2c,0x20,0x78,0x5f,0x36,0x38,0x33,0x29,0x3b,0x0a,0x20,
    0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x36,0x38,0x35,0x20,0x3a,0x20,0x66,0x33,0x32,
    0x20,0x3d,0x20,0x64,0x5f,0x32,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,
    0x36,0x38,0x36,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x71,0x5f,
    0x31,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x37,0x20,0x3d,0x20,
    0x28,0x78,0x5f,0x36,0x38,0x36,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x2d,
    0x32,0x2e,0x30,0x66,0x2c,0x20,0x2d,0x32,0x30,0x2e,0x30,0x66,0x29,0x29,0x3b,0x0a,
    0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x38,0x20,0x3d,0x20,0x31,0x2e,0x30,
    0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x36,0x39,0x32,0x20,0x3a,
    0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,
    0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x36,0x37,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x38,
    0x29,0x29,0x3b,0x0a,0x20,0x20,0x64,0x5f,0x32,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,
    0x78,0x5f,0x36,0x38,0x35,0x2c,0x20,0x78,0x5f,0x36,0x39,0x32,0x29,0x3b,0x0a,0x20,
    0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x36,0x39,0x34,0x20,0x3a,0x20,0x66,0x33,0x32,
    0x20,0x3d,0x20,0x64,0x5f,0x32,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,
    0x36,0x39,0x35,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x71,0x5f,
    0x31,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x39,0x20,0x3d,0x20,
    0x28,0x78,0x5f,0x36,0x39,0x35,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x2d,
    0x31,0x2e,0x36,0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x33,0x38,0x34,0x31,0x38,0x35,
    0x37,0x39,0x31,0x30,0x31,0x36,0x66,0x2c,0x20,0x2d,0x32,0x35,0x2e,0x30,0x66,0x29,
    0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x30,0x20,0x3d,0x20,
    0x30,0x2e,0x38,0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,0x31,0x35,0x38,0x31,0x34,
    0x32,0x30,0x38,0x39,0x38,0x34,0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,
    0x5f,0x37,0x30,0x33,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x64,0x5f,
    0x63,0x69,0x72,0x63,0x6c,0x65,0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,0x28,0x26,
    0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x36,0x39,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x37,0x30,0x29,0x29,0x3b,0x0a,0x20,0x20,0x64,0x5f,0x32,0x20,
    0x3d,0x20,0x6d,0x69,0x6e,0x28,0x78,0x5f,0x36,0x39,0x34,0x2c,0x20,0x78,0x5f,0x37,
    0x30,0x33,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x37,0x30,0x35,
    0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x64,0x5f,0x32,0x3b,0x0a,0x20,0x20,
    0x6c,0x65,0x74,0x20,0x78,0x5f,0x37,0x30,0x36,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,
    0x66,0x20,0x3d,0x20,0x71,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x37,0x31,0x20,0x3d,0x20,0x28,0x78,0x5f,0x37,0x30,0x36,0x20,0x2d,0x20,0x76,
    0x65,0x63,0x32,0x66,0x28,0x2d,0x31,0x2e,0x32,0x39,0x39,0x39,0x39,0x39,0x39,0x35,
    0x32,0x33,0x31,0x36,0x32,0x38,0x34,0x31,0x37,0x39,0x36,0x39,0x66,0x2c,0x20,0x2d,
    0x32,0x39,0x2e,0x30,0x66,0x29,0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x37,0x32,0x20,0x3d,0x20,0x30,0x2e,0x38,0x30,0x30,0x30,0x30,0x30,0x30,0x31,
    0x31,0x39,0x32,0x30,0x39,0x32,0x38,0x39,0x35,0x35,0x30,0x38,0x66,0x3b,0x0a,0x20,
    0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x37,0x31,0x33,0x20,0x3a,0x20,0x66,0x33,0x32,
    0x20,0x3d,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x5f,0x76,0x66,0x32,
    0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x31,0x29,
    0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x32,0x29,0x29,0x3b,0x0a,
    0x20,0x20,0x64,0x5f,0x32,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x78,0x5f,0x37,0x30,
    0x35,0x2c,0x20,0x78,0x5f,0x37,0x31,0x33,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,
    0x20,0x78,0x5f,0x37,0x31,0x35,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x64,
    0x5f,0x32,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x37,0x31,0x36,0x20,
    0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x71,0x5f,0x31,0x3b,0x0a,0x20,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x33,0x20,0x3d,0x20,0x28,0x78,0x5f,0x37,
    0x31,0x36,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x2d,0x30,0x2e,0x38,0x39,
    0x39,0x39,0x39,0x39,0x39,0x37,0x36,0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,0x39,
    0x38,0x34,0x66,0x2c,0x20,0x2d,0x33,0x33,0x2e,0x30,0x66,0x29,0x29,0x3b,0x0a,0x20,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x34,0x20,0x3d,0x20,0x30,0x2e,0x36,0x39,
    0x39,0x39,0x39,0x39,0x39,0x38,0x38,0x30,0x37,0x39,0x30,0x37,0x31,0x30,0x34,0x34,
    0x39,0x32,0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x37,0x32,0x33,
    0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x64,0x5f,0x63,0x69,0x72,0x63,
    0x6c,0x65,0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x37,0x33,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x37,0x34,0x29,0x29,0x3b,0x0a,0x20,0x20,0x64,0x5f,0x32,0x20,0x3d,0x20,0x6d,0x69,
    0x6e,0x28,0x78,0x5f,0x37,0x31,0x35,0x2c,0x20,0x78,0x5f,0x37,0x32,0x33,0x29,0x3b,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x37,0x32,0x35,0x20,0x3a,0x20,0x66,
    0x33,0x32,0x20,0x3d,0x20,0x64,0x5f,0x32,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x37,0x32,0x36,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,
    0x71,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x35,0x20,
    0x3d,0x20,0x28,0x78,0x5f,0x37,0x32,0x36,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x66,
    0x28,0x2d,0x30,0x2e,0x38,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,
    0x39,0x32,0x38,0x39,0x35,0x35,0x30,0x38,0x66,0x2c,0x20,0x2d,0x33,0x37,0x2e,0x30,
    0x66,0x29,0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x36,0x20,
    0x3d,0x20,0x30,0x2e,0x36,0x30,0x30,0x30,0x30,0x30,0x30,0x32,0x33,0x38,0x34,0x31,
    0x38,0x35,0x37,0x39,0x31,0x30,0x31,0x36,0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,
    0x20,0x78,0x5f,0x37,0x33,0x34,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,
    0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,
    0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x35,0x29,0x2c,0x20,0x26,0x28,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x36,0x29,0x29,0x3b,0x0a,0x20,0x20,0x64,0x5f,
    0x32,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x78,0x5f,0x37,0x32,0x35,0x2c,0x20,0x78,
    0x5f,0x37,0x33,0x34,0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,
    0x37,0x20,0x3d,0x20,0x78,0x5f,0x33,0x37,0x38,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,
    0x20,0x78,0x5f,0x37,0x33,0x38,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x20,0x3d,
    0x20,0x6f,0x63,0x6f,0x6c,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x37,0x38,0x20,0x3d,0x20,0x78,0x5f,0x37,0x33,0x38,0x3b,0x0a,0x20,0x20,0x6c,
    0x65,0x74,0x20,0x78,0x5f,0x37,0x34,0x30,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,
    0x20,0x64,0x5f,0x32,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x39,
    0x20,0x3d,0x20,0x78,0x5f,0x37,0x34,0x30,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x37,0x34,0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x20,0x3d,0x20,
    0x62,0x6c,0x65,0x6e,0x64,0x5f,0x76,0x66,0x33,0x5f,0x76,0x66,0x33,0x5f,0x66,0x31,
    0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x37,0x29,0x2c,0x20,0x26,
    0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x37,0x38,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x37,0x39,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6f,0x63,0x6f,0x6c,
    0x5f,0x31,0x20,0x3d,0x20,0x78,0x5f,0x37,0x34,0x31,0x3b,0x0a,0x20,0x20,0x6c,0x65,
    0x74,0x20,0x78,0x5f,0x37,0x34,0x32,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,
    0x3d,0x20,0x73,0x70,0x3b,0x0a,0x20,0x20,0x71,0x5f,0x31,0x20,0x3d,0x20,0x78,0x5f,
    0x37,0x34,0x32,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x37,0x34,0x35,
    0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x71,0x5f,0x31,0x2e,0x79,0x3b,0x0a,
    0x20,0x20,0x71,0x5f,0x31,0x2e,0x79,0x20,0x3d,0x20,0x28,0x78,0x5f,0x37,0x34,0x35,
    0x20,0x2d,0x20,0x2d,0x31,0x31,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,
    0x74,0x20,0x78,0x5f,0x37,0x34,0x38,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,
    0x3d,0x20,0x71,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,
    0x30,0x20,0x3d,0x20,0x28,0x78,0x5f,0x37,0x34,0x38,0x20,0x2d,0x20,0x76,0x65,0x63,
    0x32,0x66,0x28,0x30,0x2e,0x30,0x66,0x2c,0x20,0x2d,0x35,0x2e,0x30,0x66,0x29,0x29,
    0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x31,0x20,0x3d,0x20,0x76,
    0x65,0x63,0x32,0x66,0x28,0x34,0x30,0x2e,0x30,0x66,0x2c,0x20,0x32,0x30,0x2e,0x30,
    0x66,0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x32,0x20,0x3d,
    0x20,0x32,0x2e,0x39,0x30,0x30,0x30,0x30,0x30,0x30,0x39,0x35,0x33,0x36,0x37,0x34,
    0x33,0x31,0x36,0x34,0x30,0x36,0x32,0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x37,0x35,0x38,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x64,
    0x5f,0x65,0x6c,0x6c,0x69,0x70,0x73,0x6f,0x69,0x64,0x5f,0x76,0x66,0x32,0x5f,0x76,
    0x66,0x32,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,
    0x30,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x31,0x29,0x2c,
    0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x32,0x29,0x29,0x3b,0x0a,0x20,
    0x20,0x64,0x5f,0x32,0x20,0x3d,0x20,0x78,0x5f,0x37,0x35,0x38,0x3b,0x0a,0x20,0x20,
    0x6c,0x65,0x74,0x20,0x78,0x5f,0x37,0x35,0x39,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,
    0x66,0x20,0x3d,0x20,0x71,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x38,0x33,0x20,0x3d,0x20,0x28,0x78,0x5f,0x37,0x35,0x39,0x20,0x2d,0x20,0x76,
    0x65,0x63,0x32,0x66,0x28,0x32,0x31,0x2e,0x30,0x66,0x2c,0x20,0x30,0x2e,0x30,0x66,
    0x29,0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x34,0x20,0x3d,
    0x20,0x32,0x30,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,
    0x37,0x36,0x35,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x64,0x5f,0x63,
    0x69,0x72,0x63,0x6c,0x65,0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x33,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x38,0x34,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,
    0x5f,0x37,0x36,0x37,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x64,0x5f,0x32,
    0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x35,0x20,0x3d,0x20,0x78,
    0x5f,0x37,0x36,0x37,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x36,
    0x20,0x3d,0x20,0x78,0x5f,0x37,0x36,0x35,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x38,0x37,0x20,0x3d,0x20,0x35,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,0x6c,
    0x65,0x74,0x20,0x78,0x5f,0x37,0x37,0x30,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,
    0x20,0x73,0x6d,0x69,0x6e,0x5f,0x66,0x31,0x5f,0x66,0x31,0x5f,0x66,0x31,0x5f,0x28,
    0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x35,0x29,0x2c,0x20,0x26,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x38,0x36,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x38,0x37,0x29,0x29,0x3b,0x0a,0x20,0x20,0x64,0x5f,0x32,0x20,0x3d,0x20,
    0x78,0x5f,0x37,0x37,0x30,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,
    0x38,0x20,0x3d,0x20,0x76,0x65,0x63,0x33,0x66,0x28,0x30,0x2e,0x39,0x38,0x30,0x30,
    0x30,0x30,0x30,0x31,0x39,0x30,0x37,0x33,0x34,0x38,0x36,0x33,0x32,0x38,0x31,0x32,
    0x66,0x2c,0x20,0x30,0x2e,0x37,0x39,0x30,0x30,0x30,0x30,0x30,0x32,0x31,0x34,0x35,
    0x37,0x36,0x37,0x32,0x31,0x31,0x39,0x31,0x34,0x66,0x2c,0x20,0x30,0x2e,0x36,0x38,
    0x39,0x39,0x39,0x39,0x39,0x39,0x37,0x36,0x31,0x35,0x38,0x31,0x34,0x32,0x30,0x38,
    0x39,0x38,0x66,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x37,0x37,
    0x37,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,
    0x5f,0x31,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x38,0x39,0x20,0x3d,
    0x20,0x78,0x5f,0x37,0x37,0x37,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,
    0x37,0x37,0x39,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x64,0x5f,0x32,0x3b,
    0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x30,0x20,0x3d,0x20,0x78,0x5f,
    0x37,0x37,0x39,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x37,0x38,0x30,
    0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,
    0x5f,0x76,0x66,0x33,0x5f,0x76,0x66,0x33,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x38,0x38,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x38,0x39,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,
    0x30,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x5f,0x31,0x20,0x3d,0x20,
    0x78,0x5f,0x37,0x38,0x30,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x37,
    0x38,0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x71,0x5f,0x31,
    0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x37,0x38,0x34,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x20,0x3d,0x20,0x78,0x5f,0x34,0x30,0x38,0x2e,0x69,0x54,0x69,0x6d,
    0x65,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x31,0x20,0x3d,0x20,
    0x28,0x78,0x5f,0x37,0x38,0x31,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x30,
    0x2e,0x30,0x66,0x2c,0x20,0x28,0x2d,0x31,0x32,0x2e,0x30,0x66,0x20,0x2b,0x20,0x28,
    0x73,0x69,0x6e,0x28,0x78,0x5f,0x37,0x38,0x34,0x29,0x20,0x2a,0x20,0x30,0x2e,0x35,
    0x66,0x29,0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,
    0x32,0x20,0x3d,0x20,0x32,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x37,0x39,0x32,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x64,
    0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,0x28,
    0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x31,0x29,0x2c,0x20,0x26,0x28,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x39,0x32,0x29,0x29,0x3b,0x0a,0x20,0x20,0x64,0x5f,0x32,
    0x20,0x3d,0x20,0x78,0x5f,0x37,0x39,0x32,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x37,0x39,0x33,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,
    0x71,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x37,0x39,0x39,
    0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x78,0x5f,0x34,0x30,0x38,0x2e,0x69,
    0x54,0x69,0x6d,0x65,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x33,
    0x20,0x3d,0x20,0x28,0x78,0x5f,0x37,0x39,0x33,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,
    0x66,0x28,0x30,0x2e,0x30,0x66,0x2c,0x20,0x2d,0x31,0x38,0x2e,0x30,0x66,0x29,0x29,
    0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x34,0x20,0x3d,0x20,0x28,
    0x33,0x2e,0x31,0x34,0x31,0x35,0x39,0x32,0x37,0x34,0x31,0x30,0x31,0x32,0x35,0x37,
    0x33,0x32,0x34,0x32,0x31,0x39,0x66,0x20,0x2b,0x20,0x28,0x73,0x69,0x6e,0x28,0x78,
    0x5f,0x37,0x39,0x39,0x29,0x20,0x2a,0x20,0x30,0x2e,0x33,0x30,0x30,0x30,0x30,0x30,
    0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,0x38,0x39,0x35,0x35,0x30,0x38,0x66,0x29,
    0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x35,0x20,0x3d,0x20,
    0x30,0x2e,0x33,0x30,0x30,0x30,0x30,0x30,0x30,0x31,0x31,0x39,0x32,0x30,0x39,0x32,
    0x38,0x39,0x35,0x35,0x30,0x38,0x66,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x39,0x36,0x20,0x3d,0x20,0x34,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x39,0x37,0x20,0x3d,0x20,0x30,0x2e,0x34,0x30,0x30,0x30,0x30,
    0x30,0x30,0x30,0x35,0x39,0x36,0x30,0x34,0x36,0x34,0x34,0x37,0x37,0x35,0x34,0x66,
    0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x30,0x39,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x64,0x5f,0x61,0x72,0x63,0x5f,0x76,0x66,0x32,
    0x5f,0x66,0x31,0x5f,0x66,0x31,0x5f,0x66,0x31,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x33,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x39,0x34,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x39,0x35,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x36,0x29,
    0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x37,0x29,0x29,0x3b,0x0a,
    0x20,0x20,0x64,0x32,0x20,0x3d,0x20,0x78,0x5f,0x38,0x30,0x39,0x3b,0x0a,0x20,0x20,
    0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x31,0x30,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,
    0x3d,0x20,0x64,0x5f,0x32,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,
    0x31,0x31,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x64,0x32,0x3b,0x0a,0x20,
    0x20,0x64,0x5f,0x32,0x20,0x3d,0x20,0x6d,0x69,0x6e,0x28,0x78,0x5f,0x38,0x31,0x30,
    0x2c,0x20,0x78,0x5f,0x38,0x31,0x31,0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x39,0x38,0x20,0x3d,0x20,0x78,0x5f,0x38,0x31,0x36,0x3b,0x0a,0x20,0x20,
    0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x31,0x39,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,
    0x66,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x39,0x39,0x20,0x3d,0x20,0x78,0x5f,0x38,0x31,0x39,0x3b,0x0a,
    0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x32,0x31,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x20,0x3d,0x20,0x64,0x5f,0x32,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x31,0x30,0x30,0x20,0x3d,0x20,0x78,0x5f,0x38,0x32,0x31,0x3b,0x0a,0x20,0x20,
    0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x32,0x32,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,
    0x66,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x76,0x66,0x33,0x5f,0x76,0x66,
    0x33,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x38,
    0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x39,0x39,0x29,0x2c,0x20,
    0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x30,0x29,0x29,0x3b,0x0a,0x20,
    0x20,0x6f,0x63,0x6f,0x6c,0x5f,0x31,0x20,0x3d,0x20,0x78,0x5f,0x38,0x32,0x32,0x3b,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x32,0x33,0x20,0x3a,0x20,0x76,
    0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x73,0x70,0x3b,0x0a,0x20,0x20,0x71,0x5f,0x31,
    0x20,0x3d,0x20,0x78,0x5f,0x38,0x32,0x33,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x38,0x32,0x35,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x71,0x5f,
    0x31,0x2e,0x79,0x3b,0x0a,0x20,0x20,0x71,0x5f,0x31,0x2e,0x79,0x20,0x3d,0x20,0x28,
    0x78,0x5f,0x38,0x32,0x35,0x20,0x2d,0x20,0x2d,0x31,0x32,0x2e,0x30,0x66,0x29,0x3b,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x32,0x39,0x20,0x3a,0x20,0x66,
    0x33,0x32,0x20,0x3d,0x20,0x78,0x5f,0x34,0x30,0x38,0x2e,0x69,0x54,0x69,0x6d,0x65,
    0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x33,0x35,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x20,0x3d,0x20,0x71,0x5f,0x31,0x2e,0x79,0x3b,0x0a,0x20,0x20,0x71,
    0x5f,0x31,0x2e,0x79,0x20,0x3d,0x20,0x28,0x78,0x5f,0x38,0x33,0x35,0x20,0x2f,0x20,
    0x28,0x31,0x2e,0x30,0x66,0x20,0x2d,0x20,0x73,0x6d,0x6f,0x6f,0x74,0x68,0x73,0x74,
    0x65,0x70,0x28,0x30,0x2e,0x39,0x38,0x30,0x30,0x30,0x30,0x30,0x31,0x39,0x30,0x37,
    0x33,0x34,0x38,0x36,0x33,0x32,0x38,0x31,0x32,0x66,0x2c,0x20,0x31,0x2e,0x30,0x66,
    0x2c,0x20,0x73,0x69,0x6e,0x28,0x28,0x78,0x5f,0x38,0x32,0x39,0x20,0x2a,0x20,0x33,
    0x2e,0x30,0x66,0x29,0x29,0x29,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x38,0x33,0x38,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,
    0x71,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x31,
    0x20,0x3d,0x20,0x28,0x78,0x5f,0x38,0x33,0x38,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,
    0x66,0x28,0x32,0x30,0x2e,0x30,0x66,0x2c,0x20,0x30,0x2e,0x30,0x66,0x29,0x29,0x3b,
    0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x32,0x20,0x3d,0x20,0x76,
    0x65,0x63,0x32,0x66,0x28,0x39,0x2e,0x30,0x66,0x2c,0x20,0x31,0x32,0x2e,0x30,0x66,
    0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x33,0x20,0x3d,
    0x20,0x32,0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,
    0x34,0x37,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,
    0x6c,0x69,0x70,0x73,0x6f,0x69,0x64,0x5f,0x76,0x66,0x32,0x5f,0x76,0x66,0x32,0x5f,
    0x66,0x31,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x31,0x29,
    0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x32,0x29,0x2c,0x20,
    0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x33,0x29,0x29,0x3b,0x0a,0x20,
    0x20,0x64,0x5f,0x32,0x20,0x3d,0x20,0x78,0x5f,0x38,0x34,0x37,0x3b,0x0a,0x20,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x34,0x20,0x3d,0x20,0x78,0x5f,0x38,0x34,
    0x38,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x35,0x31,0x20,0x3a,
    0x20,0x76,0x65,0x63,0x33,0x66,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x5f,0x31,0x3b,
    0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x35,0x20,0x3d,0x20,0x78,
    0x5f,0x38,0x35,0x31,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x35,
    0x33,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x64,0x5f,0x32,0x3b,0x0a,0x20,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x36,0x20,0x3d,0x20,0x78,0x5f,0x38,
    0x35,0x33,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x35,0x34,0x20,
    0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x5f,
    0x76,0x66,0x33,0x5f,0x76,0x66,0x33,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x31,0x30,0x34,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x31,0x30,0x35,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x31,0x30,0x36,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x5f,0x31,0x20,
    0x3d,0x20,0x78,0x5f,0x38,0x35,0x34,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,
    0x5f,0x38,0x35,0x35,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x71,
    0x5f,0x31,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x37,0x20,
    0x3d,0x20,0x28,0x78,0x5f,0x38,0x35,0x35,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x66,
    0x28,0x31,0x39,0x2e,0x35,0x66,0x2c,0x20,0x30,0x2e,0x30,0x66,0x29,0x29,0x3b,0x0a,
    0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x38,0x20,0x3d,0x20,0x76,0x65,
    0x63,0x32,0x66,0x28,0x35,0x2e,0x30,0x66,0x2c,0x20,0x38,0x2e,0x30,0x66,0x29,0x3b,
    0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x39,0x20,0x3d,0x20,0x32,
    0x2e,0x30,0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x36,0x34,
    0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,0x64,0x5f,0x65,0x6c,0x6c,0x69,
    0x70,0x73,0x6f,0x69,0x64,0x5f,0x76,0x66,0x32,0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,
    0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x37,0x29,0x2c,0x20,
    0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x38,0x29,0x2c,0x20,0x26,0x28,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x30,0x39,0x29,0x29,0x3b,0x0a,0x20,0x20,0x64,
    0x5f,0x32,0x20,0x3d,0x20,0x78,0x5f,0x38,0x36,0x34,0x3b,0x0a,0x20,0x20,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x31,0x31,0x30,0x20,0x3d,0x20,0x78,0x5f,0x38,0x31,0x36,0x3b,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x36,0x37,0x20,0x3a,0x20,0x76,
    0x65,0x63,0x33,0x66,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x5f,0x31,0x3b,0x0a,0x20,
    0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x31,0x20,0x3d,0x20,0x78,0x5f,0x38,
    0x36,0x37,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x36,0x39,0x20,
    0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x64,0x5f,0x32,0x3b,0x0a,0x20,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x32,0x20,0x3d,0x20,0x78,0x5f,0x38,0x36,0x39,
    0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x37,0x30,0x20,0x3a,0x20,
    0x76,0x65,0x63,0x33,0x66,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x76,0x66,
    0x33,0x5f,0x76,0x66,0x33,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,
    0x6d,0x5f,0x31,0x31,0x30,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x31,0x31,0x31,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,
    0x32,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x5f,0x31,0x20,0x3d,0x20,
    0x78,0x5f,0x38,0x37,0x30,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,
    0x37,0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x2a,0x28,0x70,
    0x5f,0x37,0x29,0x3b,0x0a,0x20,0x20,0x71,0x5f,0x31,0x20,0x3d,0x20,0x28,0x78,0x5f,
    0x38,0x37,0x31,0x20,0x2d,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x2d,0x32,0x2e,0x30,
    0x66,0x2c,0x20,0x30,0x2e,0x30,0x66,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,
    0x20,0x78,0x5f,0x38,0x37,0x35,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x71,
    0x5f,0x31,0x2e,0x78,0x3b,0x0a,0x20,0x20,0x71,0x5f,0x31,0x2e,0x78,0x20,0x3d,0x20,
    0x61,0x62,0x73,0x28,0x78,0x5f,0x38,0x37,0x35,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,
    0x74,0x20,0x78,0x5f,0x38,0x37,0x38,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,
    0x3d,0x20,0x71,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x31,0x33,0x20,0x3d,0x20,0x28,0x78,0x5f,0x38,0x37,0x38,0x20,0x2d,0x20,0x76,0x65,
    0x63,0x32,0x66,0x28,0x31,0x39,0x2e,0x35,0x66,0x2c,0x20,0x2d,0x38,0x2e,0x30,0x66,
    0x29,0x29,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x34,0x20,
    0x3d,0x20,0x31,0x2e,0x32,0x39,0x39,0x39,0x39,0x39,0x39,0x35,0x32,0x33,0x31,0x36,
    0x32,0x38,0x34,0x31,0x37,0x39,0x36,0x39,0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,
    0x20,0x78,0x5f,0x38,0x38,0x34,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x73,
    0x64,0x5f,0x63,0x69,0x72,0x63,0x6c,0x65,0x5f,0x76,0x66,0x32,0x5f,0x66,0x31,0x5f,
    0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x33,0x29,0x2c,0x20,0x26,
    0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x34,0x29,0x29,0x3b,0x0a,0x20,0x20,
    0x64,0x5f,0x32,0x20,0x3d,0x20,0x78,0x5f,0x38,0x38,0x34,0x3b,0x0a,0x20,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x35,0x20,0x3d,0x20,0x78,0x5f,0x38,0x34,0x38,
    0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x38,0x37,0x20,0x3a,0x20,
    0x76,0x65,0x63,0x33,0x66,0x20,0x3d,0x20,0x6f,0x63,0x6f,0x6c,0x5f,0x31,0x3b,0x0a,
    0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x36,0x20,0x3d,0x20,0x78,0x5f,
    0x38,0x38,0x37,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x38,0x39,
    0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x64,0x5f,0x32,0x3b,0x0a,0x20,0x20,
    0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x37,0x20,0x3d,0x20,0x78,0x5f,0x38,0x38,
    0x39,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x39,0x30,0x20,0x3a,
    0x20,0x76,0x65,0x63,0x33,0x66,0x20,0x3d,0x20,0x62,0x6c,0x65,0x6e,0x64,0x5f,0x76,
    0x66,0x33,0x5f,0x76,0x66,0x33,0x5f,0x66,0x31,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,
    0x61,0x6d,0x5f,0x31,0x31,0x35,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x31,0x31,0x36,0x29,0x2c,0x20,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x31,0x37,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6f,0x63,0x6f,0x6c,0x5f,0x31,0x20,0x3d,
    0x20,0x78,0x5f,0x38,0x39,0x30,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,
    0x38,0x39,0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x20,0x3d,0x20,0x6f,0x63,
    0x6f,0x6c,0x5f,0x31,0x3b,0x0a,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x78,
    0x5f,0x38,0x39,0x31,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x6e,0x20,0x6d,0x61,0x69,0x6e,
    0x5f,0x31,0x28,0x29,0x20,0x7b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x63,0x6f,0x6c,
    0x5f,0x32,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,
    0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x38,0x20,0x3a,0x20,0x76,0x65,
    0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x39,0x38,
    0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x66,0x72,0x61,0x67,0x50,
    0x6f,0x73,0x3b,0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x31,0x38,0x20,
    0x3d,0x20,0x78,0x5f,0x38,0x39,0x38,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,
    0x5f,0x38,0x39,0x39,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x20,0x3d,0x20,0x6d,
    0x61,0x70,0x5f,0x76,0x66,0x32,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,
    0x31,0x31,0x38,0x29,0x29,0x3b,0x0a,0x20,0x20,0x63,0x6f,0x6c,0x5f,0x32,0x20,0x3d,
    0x20,0x78,0x5f,0x38,0x39,0x39,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,
    0x39,0x30,0x33,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x20,0x3d,0x20,0x63,0x6f,
    0x6c,0x5f,0x32,0x3b,0x0a,0x20,0x20,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,0x72,
    0x20,0x3d,0x20,0x76,0x65,0x63,0x34,0x66,0x28,0x78,0x5f,0x39,0x30,0x33,0x2e,0x78,
    0x2c,0x20,0x78,0x5f,0x39,0x30,0x33,0x2e,0x79,0x2c,0x20,0x78,0x5f,0x39,0x30,0x33,
    0x2e,0x7a,0x2c,0x20,0x31,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x72,0x65,0x74,
    0x75,0x72,0x6e,0x3b,0x0a,0x7d,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,
    0x61,0x69,0x6e,0x5f,0x6f,0x75,0x74,0x20,0x7b,0x0a,0x20,0x20,0x40,0x6c,0x6f,0x63,
    0x61,0x74,0x69,0x6f,0x6e,0x28,0x30,0x29,0x0a,0x20,0x20,0x66,0x72,0x61,0x67,0x43,
    0x6f,0x6c,0x6f,0x72,0x5f,0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x34,0x66,0x2c,0x0a,
    0x7d,0x0a,0x0a,0x40,0x66,0x72,0x61,0x67,0x6d,0x65,0x6e,0x74,0x0a,0x66,0x6e,0x20,
    0x6d,0x61,0x69,0x6e,0x28,0x40,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x28,0x31,
    0x29,0x20,0x66,0x72,0x61,0x67,0x50,0x6f,0x73,0x5f,0x70,0x61,0x72,0x61,0x6d,0x20,
    0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x2c,0x20,0x40,0x6c,0x6f,0x63,0x61,0x74,0x69,
    0x6f,0x6e,0x28,0x30,0x29,0x20,0x74,0x65,0x78,0x55,0x56,0x5f,0x70,0x61,0x72,0x61,
    0x6d,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x29,0x20,0x2d,0x3e,0x20,0x6d,0x61,
    0x69,0x6e,0x5f,0x6f,0x75,0x74,0x20,0x7b,0x0a,0x20,0x20,0x66,0x72,0x61,0x67,0x50,
    0x6f,0x73,0x20,0x3d,0x20,0x66,0x72,0x61,0x67,0x50,0x6f,0x73,0x5f,0x70,0x61,0x72,
    0x61,0x6d,0x3b,0x0a,0x20,0x20,0x74,0x65,0x78,0x55,0x56,0x20,0x3d,0x20,0x74,0x65,
    0x78,0x55,0x56,0x5f,0x70,0x61,0x72,0x61,0x6d,0x3b,0x0a,0x20,0x20,0x6d,0x61,0x69,
    0x6e,0x5f,0x31,0x28,0x29,0x3b,0x0a,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,
    0x6d,0x61,0x69,0x6e,0x5f,0x6f,0x75,0x74,0x28,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,
    0x6f,0x72,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
const sg_shader_desc* sdf_program_shader_desc(sg_backend backend) {
    if (backend == SG_BACKEND_GLCORE) {
        static sg_shader_desc desc;
        static bool valid;
        if (!valid) {
            valid = true;
            desc.vertex_func.source = (const char*)sdf_vs_source_glsl410;
            desc.vertex_func.entry = "main";
            desc.fragment_func.source = (const char*)sdf_fs_source_glsl410;
            desc.fragment_func.entry = "main";
            desc.attrs[0].glsl_name = "coord";
            desc.uniform_blocks[0].stage = SG_SHADERSTAGE_VERTEX;
            desc.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
            desc.uniform_blocks[0].size = 16;
            desc.uniform_blocks[0].glsl_uniforms[0].type = SG_UNIFORMTYPE_FLOAT4;
            desc.uniform_blocks[0].glsl_uniforms[0].array_count = 1;
            desc.uniform_blocks[0].glsl_uniforms[0].glsl_name = "vs_uniforms";
            desc.uniform_blocks[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.uniform_blocks[1].layout = SG_UNIFORMLAYOUT_STD140;
            desc.uniform_blocks[1].size = 16;
            desc.uniform_blocks[1].glsl_uniforms[0].type = SG_UNIFORMTYPE_FLOAT4;
            desc.uniform_blocks[1].glsl_uniforms[0].array_count = 1;
            desc.uniform_blocks[1].glsl_uniforms[0].glsl_name = "fs_uniforms";
            desc.label = "sdf_program_shader";
        }
        return &desc;
    }
    if (backend == SG_BACKEND_GLES3) {
        static sg_shader_desc desc;
        static bool valid;
        if (!valid) {
            valid = true;
            desc.vertex_func.source = (const char*)sdf_vs_source_glsl300es;
            desc.vertex_func.entry = "main";
            desc.fragment_func.source = (const char*)sdf_fs_source_glsl300es;
            desc.fragment_func.entry = "main";
            desc.attrs[0].glsl_name = "coord";
            desc.uniform_blocks[0].stage = SG_SHADERSTAGE_VERTEX;
            desc.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
            desc.uniform_blocks[0].size = 16;
            desc.uniform_blocks[0].glsl_uniforms[0].type = SG_UNIFORMTYPE_FLOAT4;
            desc.uniform_blocks[0].glsl_uniforms[0].array_count = 1;
            desc.uniform_blocks[0].glsl_uniforms[0].glsl_name = "vs_uniforms";
            desc.uniform_blocks[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.uniform_blocks[1].layout = SG_UNIFORMLAYOUT_STD140;
            desc.uniform_blocks[1].size = 16;
            desc.uniform_blocks[1].glsl_uniforms[0].type = SG_UNIFORMTYPE_FLOAT4;
            desc.uniform_blocks[1].glsl_uniforms[0].array_count = 1;
            desc.uniform_blocks[1].glsl_uniforms[0].glsl_name = "fs_uniforms";
            desc.label = "sdf_program_shader";
        }
        return &desc;
    }
    if (backend == SG_BACKEND_D3D11) {
        static sg_shader_desc desc;
        static bool valid;
        if (!valid) {
            valid = true;
            desc.vertex_func.source = (const char*)sdf_vs_source_hlsl4;
            desc.vertex_func.d3d11_target = "vs_4_0";
            desc.vertex_func.entry = "main";
            desc.fragment_func.source = (const char*)sdf_fs_source_hlsl4;
            desc.fragment_func.d3d11_target = "ps_4_0";
            desc.fragment_func.entry = "main";
            desc.attrs[0].hlsl_sem_name = "TEXCOORD";
            desc.attrs[0].hlsl_sem_index = 0;
            desc.uniform_blocks[0].stage = SG_SHADERSTAGE_VERTEX;
            desc.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
            desc.uniform_blocks[0].size = 16;
            desc.uniform_blocks[0].hlsl_register_b_n = 0;
            desc.uniform_blocks[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.uniform_blocks[1].layout = SG_UNIFORMLAYOUT_STD140;
            desc.uniform_blocks[1].size = 16;
            desc.uniform_blocks[1].hlsl_register_b_n = 0;
            desc.label = "sdf_program_shader";
        }
        return &desc;
    }
    if (backend == SG_BACKEND_METAL_MACOS) {
        static sg_shader_desc desc;
        static bool valid;
        if (!valid) {
            valid = true;
            desc.vertex_func.source = (const char*)sdf_vs_source_metal_macos;
            desc.vertex_func.entry = "main0";
            desc.fragment_func.source = (const char*)sdf_fs_source_metal_macos;
            desc.fragment_func.entry = "main0";
            desc.uniform_blocks[0].stage = SG_SHADERSTAGE_VERTEX;
            desc.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
            desc.uniform_blocks[0].size = 16;
            desc.uniform_blocks[0].msl_buffer_n = 0;
            desc.uniform_blocks[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.uniform_blocks[1].layout = SG_UNIFORMLAYOUT_STD140;
            desc.uniform_blocks[1].size = 16;
            desc.uniform_blocks[1].msl_buffer_n = 0;
            desc.label = "sdf_program_shader";
        }
        return &desc;
    }
    if (backend == SG_BACKEND_METAL_IOS) {
        static sg_shader_desc desc;
        static bool valid;
        if (!valid) {
            valid = true;
            desc.vertex_func.source = (const char*)sdf_vs_source_metal_ios;
            desc.vertex_func.entry = "main0";
            desc.fragment_func.source = (const char*)sdf_fs_source_metal_ios;
            desc.fragment_func.entry = "main0";
            desc.uniform_blocks[0].stage = SG_SHADERSTAGE_VERTEX;
            desc.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
            desc.uniform_blocks[0].size = 16;
            desc.uniform_blocks[0].msl_buffer_n = 0;
            desc.uniform_blocks[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.uniform_blocks[1].layout = SG_UNIFORMLAYOUT_STD140;
            desc.uniform_blocks[1].size = 16;
            desc.uniform_blocks[1].msl_buffer_n = 0;
            desc.label = "sdf_program_shader";
        }
        return &desc;
    }
    if (backend == SG_BACKEND_WGPU) {
        static sg_shader_desc desc;
        static bool valid;
        if (!valid) {
            valid = true;
            desc.vertex_func.source = (const char*)sdf_vs_source_wgsl;
            desc.vertex_func.entry = "main";
            desc.fragment_func.source = (const char*)sdf_fs_source_wgsl;
            desc.fragment_func.entry = "main";
            desc.uniform_blocks[0].stage = SG_SHADERSTAGE_VERTEX;
            desc.uniform_blocks[0].layout = SG_UNIFORMLAYOUT_STD140;
            desc.uniform_blocks[0].size = 16;
            desc.uniform_blocks[0].wgsl_group0_binding_n = 0;
            desc.uniform_blocks[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.uniform_blocks[1].layout = SG_UNIFORMLAYOUT_STD140;
            desc.uniform_blocks[1].size = 16;
            desc.uniform_blocks[1].wgsl_group0_binding_n = 8;
            desc.label = "sdf_program_shader";
        }
        return &desc;
    }
    return 0;
}
#endif // SOKOL_SHDC_IMPL