#pragma once
/*
    #version:1# (machine generated, don't edit!)

    Generated by sokol-shdc (https://github.com/floooh/sokol-tools)

    Cmdline:
        sokol-shdc --format sokol_impl --slang glsl410:glsl300es:hlsl4:metal_macos:metal_ios:wgsl -i shaders/sample-effect.glsl -o shaders/sample-effect.glsl.h

    Overview:
    =========
    Shader program: 'program':
        Get shader desc: effect_program_shader_desc(sg_query_backend());
        Vertex Shader: vs
        Fragment Shader: fs
        Attributes:
            ATTR_program_coord => 0
            ATTR_program_color => 1
    Bindings:
        Uniform block 'fs_uniforms':
            C struct: effect_fs_uniforms_t
            Bind slot: UB_fs_uniforms => 1
        Image 'iTexChannel1':
            Image type: SG_IMAGETYPE_2D
            Sample type: SG_IMAGESAMPLETYPE_FLOAT
            Multisampled: false
            Bind slot: IMG_iTexChannel1 => 1
        Image 'iTexChannel0':
            Image type: SG_IMAGETYPE_2D
            Sample type: SG_IMAGESAMPLETYPE_FLOAT
            Multisampled: false
            Bind slot: IMG_iTexChannel0 => 0
        Sampler 'iSmpChannel1':
            Type: SG_SAMPLERTYPE_FILTERING
            Bind slot: SMP_iSmpChannel1 => 1
        Sampler 'iSmpChannel0':
            Type: SG_SAMPLERTYPE_FILTERING
            Bind slot: SMP_iSmpChannel0 => 0
*/
#if !defined(SOKOL_GFX_INCLUDED)
#error "Please include sokol_gfx.h before sample-effect.glsl.h"
#endif
#if !defined(SOKOL_SHDC_ALIGN)
#if defined(_MSC_VER)
#define SOKOL_SHDC_ALIGN(a) __declspec(align(a))
#else
#define SOKOL_SHDC_ALIGN(a) __attribute__((aligned(a)))
#endif
#endif
const sg_shader_desc* effect_program_shader_desc(sg_backend backend);
#define ATTR_program_coord (0)
#define ATTR_program_color (1)
#define UB_fs_uniforms (1)
#define IMG_iTexChannel1 (1)
#define IMG_iTexChannel0 (0)
#define SMP_iSmpChannel1 (1)
#define SMP_iSmpChannel0 (0)
#pragma pack(push,1)
SOKOL_SHDC_ALIGN(16) typedef struct effect_fs_uniforms_t {
    sgp_vec2 iVelocity;
    float iPressure;
    float iTime;
    float iWarpiness;
    float iRatio;
    float iZoom;
    float iLevel;
} effect_fs_uniforms_t;
#pragma pack(pop)
#if defined(SOKOL_SHDC_IMPL)
/*
    #version 410

    layout(location = 0) in vec4 coord;
    layout(location = 0) out vec2 texUV;
    layout(location = 1) out vec4 iColor;
    layout(location = 1) in vec4 color;

    void main()
    {
        gl_Position = vec4(coord.xy, 0.0, 1.0);
        texUV = coord.zw;
        iColor = color;
    }

*/
static const uint8_t effect_vs_source_glsl410[266] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x34,0x31,0x30,0x0a,0x0a,0x6c,0x61,
    0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,
    0x30,0x29,0x20,0x69,0x6e,0x20,0x76,0x65,0x63,0x34,0x20,0x63,0x6f,0x6f,0x72,0x64,
    0x3b,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,
    0x6e,0x20,0x3d,0x20,0x30,0x29,0x20,0x6f,0x75,0x74,0x20,0x76,0x65,0x63,0x32,0x20,
    0x74,0x65,0x78,0x55,0x56,0x3b,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,
    0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x31,0x29,0x20,0x6f,0x75,0x74,0x20,
    0x76,0x65,0x63,0x34,0x20,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x6c,0x61,0x79,
    0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x31,
    0x29,0x20,0x69,0x6e,0x20,0x76,0x65,0x63,0x34,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x3b,
    0x0a,0x0a,0x76,0x6f,0x69,0x64,0x20,0x6d,0x61,0x69,0x6e,0x28,0x29,0x0a,0x7b,0x0a,
    0x20,0x20,0x20,0x20,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,
    0x3d,0x20,0x76,0x65,0x63,0x34,0x28,0x63,0x6f,0x6f,0x72,0x64,0x2e,0x78,0x79,0x2c,
    0x20,0x30,0x2e,0x30,0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x74,0x65,0x78,0x55,0x56,0x20,0x3d,0x20,0x63,0x6f,0x6f,0x72,0x64,0x2e,0x7a,0x77,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x63,
    0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #version 410

    uniform vec4 fs_uniforms[2];
    uniform sampler2D iTexChannel0_iSmpChannel0;
    uniform sampler2D iTexChannel1_iSmpChannel1;

    layout(location = 0) in vec2 texUV;
    layout(location = 1) in vec4 iColor;
    layout(location = 0) out vec4 fragColor;

    float _noise(vec2 p)
    {
        return texture(iTexChannel1_iSmpChannel1, p).x;
    }

    void main()
    {
        vec2 _60 = (texUV * vec2(fs_uniforms[1].y, 1.0)) * fs_uniforms[1].z;
        vec2 param = _60 - (fs_uniforms[0].xy * fs_uniforms[0].w);
        vec2 param_1 = _60 + vec2(_noise(param) * fs_uniforms[1].x);
        fragColor = vec4(mix(texture(iTexChannel0_iSmpChannel0, texUV).xyz, vec3(_noise(param_1)) * iColor.xyz, vec3(fs_uniforms[0].z)), 1.0);
    }

*/
static const uint8_t effect_fs_source_glsl410[685] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x34,0x31,0x30,0x0a,0x0a,0x75,0x6e,
    0x69,0x66,0x6f,0x72,0x6d,0x20,0x76,0x65,0x63,0x34,0x20,0x66,0x73,0x5f,0x75,0x6e,
    0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,0x32,0x5d,0x3b,0x0a,0x75,0x6e,0x69,0x66,0x6f,
    0x72,0x6d,0x20,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x32,0x44,0x20,0x69,0x54,0x65,
    0x78,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x30,0x5f,0x69,0x53,0x6d,0x70,0x43,0x68,
    0x61,0x6e,0x6e,0x65,0x6c,0x30,0x3b,0x0a,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x20,
    0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x32,0x44,0x20,0x69,0x54,0x65,0x78,0x43,0x68,
    0x61,0x6e,0x6e,0x65,0x6c,0x31,0x5f,0x69,0x53,0x6d,0x70,0x43,0x68,0x61,0x6e,0x6e,
    0x65,0x6c,0x31,0x3b,0x0a,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,
    0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x30,0x29,0x20,0x69,0x6e,0x20,0x76,0x65,
    0x63,0x32,0x20,0x74,0x65,0x78,0x55,0x56,0x3b,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,
    0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x31,0x29,0x20,0x69,
    0x6e,0x20,0x76,0x65,0x63,0x34,0x20,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x6c,
    0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,
    0x20,0x30,0x29,0x20,0x6f,0x75,0x74,0x20,0x76,0x65,0x63,0x34,0x20,0x66,0x72,0x61,
    0x67,0x43,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,
    0x6e,0x6f,0x69,0x73,0x65,0x28,0x76,0x65,0x63,0x32,0x20,0x70,0x29,0x0a,0x7b,0x0a,
    0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x74,0x65,0x78,0x74,0x75,
    0x72,0x65,0x28,0x69,0x54,0x65,0x78,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x31,0x5f,
    0x69,0x53,0x6d,0x70,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x31,0x2c,0x20,0x70,0x29,
    0x2e,0x78,0x3b,0x0a,0x7d,0x0a,0x0a,0x76,0x6f,0x69,0x64,0x20,0x6d,0x61,0x69,0x6e,
    0x28,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x5f,0x36,
    0x30,0x20,0x3d,0x20,0x28,0x74,0x65,0x78,0x55,0x56,0x20,0x2a,0x20,0x76,0x65,0x63,
    0x32,0x28,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,0x31,0x5d,
    0x2e,0x79,0x2c,0x20,0x31,0x2e,0x30,0x29,0x29,0x20,0x2a,0x20,0x66,0x73,0x5f,0x75,
    0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,0x31,0x5d,0x2e,0x7a,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x20,0x3d,0x20,0x5f,
    0x36,0x30,0x20,0x2d,0x20,0x28,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,
    0x73,0x5b,0x30,0x5d,0x2e,0x78,0x79,0x20,0x2a,0x20,0x66,0x73,0x5f,0x75,0x6e,0x69,
    0x66,0x6f,0x72,0x6d,0x73,0x5b,0x30,0x5d,0x2e,0x77,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x20,0x3d,0x20,
    0x5f,0x36,0x30,0x20,0x2b,0x20,0x76,0x65,0x63,0x32,0x28,0x5f,0x6e,0x6f,0x69,0x73,
    0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x29,0x20,0x2a,0x20,0x66,0x73,0x5f,0x75,0x6e,
    0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,0x31,0x5d,0x2e,0x78,0x29,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x76,0x65,
    0x63,0x34,0x28,0x6d,0x69,0x78,0x28,0x74,0x65,0x78,0x74,0x75,0x72,0x65,0x28,0x69,
    0x54,0x65,0x78,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x30,0x5f,0x69,0x53,0x6d,0x70,
    0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x30,0x2c,0x20,0x74,0x65,0x78,0x55,0x56,0x29,
    0x2e,0x78,0x79,0x7a,0x2c,0x20,0x76,0x65,0x63,0x33,0x28,0x5f,0x6e,0x6f,0x69,0x73,
    0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x29,0x29,0x20,0x2a,0x20,0x69,0x43,
    0x6f,0x6c,0x6f,0x72,0x2e,0x78,0x79,0x7a,0x2c,0x20,0x76,0x65,0x63,0x33,0x28,0x66,
    0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,0x30,0x5d,0x2e,0x7a,0x29,
    0x29,0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    #version 300 es

    layout(location = 0) in vec4 coord;
    out vec2 texUV;
    out vec4 iColor;
    layout(location = 1) in vec4 color;

    void main()
    {
        gl_Position = vec4(coord.xy, 0.0, 1.0);
        texUV = coord.zw;
        iColor = color;
    }

*/
static const uint8_t effect_vs_source_glsl300es[227] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x33,0x30,0x30,0x20,0x65,0x73,0x0a,
    0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,
    0x20,0x3d,0x20,0x30,0x29,0x20,0x69,0x6e,0x20,0x76,0x65,0x63,0x34,0x20,0x63,0x6f,
    0x6f,0x72,0x64,0x3b,0x0a,0x6f,0x75,0x74,0x20,0x76,0x65,0x63,0x32,0x20,0x74,0x65,
    0x78,0x55,0x56,0x3b,0x0a,0x6f,0x75,0x74,0x20,0x76,0x65,0x63,0x34,0x20,0x69,0x43,
    0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,
    0x61,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x31,0x29,0x20,0x69,0x6e,0x20,0x76,0x65,
    0x63,0x34,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x0a,0x76,0x6f,0x69,0x64,0x20,
    0x6d,0x61,0x69,0x6e,0x28,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x67,0x6c,0x5f,
    0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x76,0x65,0x63,0x34,0x28,
    0x63,0x6f,0x6f,0x72,0x64,0x2e,0x78,0x79,0x2c,0x20,0x30,0x2e,0x30,0x2c,0x20,0x31,
    0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x74,0x65,0x78,0x55,0x56,0x20,0x3d,
    0x20,0x63,0x6f,0x6f,0x72,0x64,0x2e,0x7a,0x77,0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,
    0x43,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x7d,
    0x0a,0x0a,0x00,
};
/*
    #version 300 es
    precision mediump float;
    precision highp int;

    uniform highp vec4 fs_uniforms[2];
    uniform highp sampler2D iTexChannel0_iSmpChannel0;
    uniform highp sampler2D iTexChannel1_iSmpChannel1;

    in highp vec2 texUV;
    in highp vec4 iColor;
    layout(location = 0) out highp vec4 fragColor;

    highp float _noise(highp vec2 p)
    {
        return texture(iTexChannel1_iSmpChannel1, p).x;
    }

    void main()
    {
        highp vec2 _60 = (texUV * vec2(fs_uniforms[1].y, 1.0)) * fs_uniforms[1].z;
        highp vec2 param = _60 - (fs_uniforms[0].xy * fs_uniforms[0].w);
        highp vec2 param_1 = _60 + vec2(_noise(param) * fs_uniforms[1].x);
        fragColor = vec4(mix(texture(iTexChannel0_iSmpChannel0, texUV).xyz, vec3(_noise(param_1)) * iColor.xyz, vec3(fs_uniforms[0].z)), 1.0);
    }

*/
static const uint8_t effect_fs_source_glsl300es[758] = {
    0x23,0x76,0x65,0x72,0x73,0x69,0x6f,0x6e,0x20,0x33,0x30,0x30,0x20,0x65,0x73,0x0a,
    0x70,0x72,0x65,0x63,0x69,0x73,0x69,0x6f,0x6e,0x20,0x6d,0x65,0x64,0x69,0x75,0x6d,
    0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x3b,0x0a,0x70,0x72,0x65,0x63,0x69,0x73,0x69,
    0x6f,0x6e,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x69,0x6e,0x74,0x3b,0x0a,0x0a,0x75,
    0x6e,0x69,0x66,0x6f,0x72,0x6d,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,
    0x34,0x20,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,0x32,0x5d,
    0x3b,0x0a,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x20,0x68,0x69,0x67,0x68,0x70,0x20,
    0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x32,0x44,0x20,0x69,0x54,0x65,0x78,0x43,0x68,
    0x61,0x6e,0x6e,0x65,0x6c,0x30,0x5f,0x69,0x53,0x6d,0x70,0x43,0x68,0x61,0x6e,0x6e,
    0x65,0x6c,0x30,0x3b,0x0a,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x20,0x68,0x69,0x67,
    0x68,0x70,0x20,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x32,0x44,0x20,0x69,0x54,0x65,
    0x78,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x31,0x5f,0x69,0x53,0x6d,0x70,0x43,0x68,
    0x61,0x6e,0x6e,0x65,0x6c,0x31,0x3b,0x0a,0x0a,0x69,0x6e,0x20,0x68,0x69,0x67,0x68,
    0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x74,0x65,0x78,0x55,0x56,0x3b,0x0a,0x69,0x6e,
    0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x34,0x20,0x69,0x43,0x6f,0x6c,
    0x6f,0x72,0x3b,0x0a,0x6c,0x61,0x79,0x6f,0x75,0x74,0x28,0x6c,0x6f,0x63,0x61,0x74,
    0x69,0x6f,0x6e,0x20,0x3d,0x20,0x30,0x29,0x20,0x6f,0x75,0x74,0x20,0x68,0x69,0x67,
    0x68,0x70,0x20,0x76,0x65,0x63,0x34,0x20,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,
    0x72,0x3b,0x0a,0x0a,0x68,0x69,0x67,0x68,0x70,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,
    0x5f,0x6e,0x6f,0x69,0x73,0x65,0x28,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,
    0x32,0x20,0x70,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,
    0x6e,0x20,0x74,0x65,0x78,0x74,0x75,0x72,0x65,0x28,0x69,0x54,0x65,0x78,0x43,0x68,
    0x61,0x6e,0x6e,0x65,0x6c,0x31,0x5f,0x69,0x53,0x6d,0x70,0x43,0x68,0x61,0x6e,0x6e,
    0x65,0x6c,0x31,0x2c,0x20,0x70,0x29,0x2e,0x78,0x3b,0x0a,0x7d,0x0a,0x0a,0x76,0x6f,
    0x69,0x64,0x20,0x6d,0x61,0x69,0x6e,0x28,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,
    0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x5f,0x36,0x30,0x20,0x3d,
    0x20,0x28,0x74,0x65,0x78,0x55,0x56,0x20,0x2a,0x20,0x76,0x65,0x63,0x32,0x28,0x66,
    0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,0x31,0x5d,0x2e,0x79,0x2c,
    0x20,0x31,0x2e,0x30,0x29,0x29,0x20,0x2a,0x20,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,
    0x6f,0x72,0x6d,0x73,0x5b,0x31,0x5d,0x2e,0x7a,0x3b,0x0a,0x20,0x20,0x20,0x20,0x68,
    0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x20,
    0x3d,0x20,0x5f,0x36,0x30,0x20,0x2d,0x20,0x28,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,
    0x6f,0x72,0x6d,0x73,0x5b,0x30,0x5d,0x2e,0x78,0x79,0x20,0x2a,0x20,0x66,0x73,0x5f,
    0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,0x30,0x5d,0x2e,0x77,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x68,0x69,0x67,0x68,0x70,0x20,0x76,0x65,0x63,0x32,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x5f,0x31,0x20,0x3d,0x20,0x5f,0x36,0x30,0x20,0x2b,0x20,0x76,
    0x65,0x63,0x32,0x28,0x5f,0x6e,0x6f,0x69,0x73,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x29,0x20,0x2a,0x20,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x5b,
    0x31,0x5d,0x2e,0x78,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x72,0x61,0x67,0x43,
    0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x76,0x65,0x63,0x34,0x28,0x6d,0x69,0x78,0x28,
    0x74,0x65,0x78,0x74,0x75,0x72,0x65,0x28,0x69,0x54,0x65,0x78,0x43,0x68,0x61,0x6e,
    0x6e,0x65,0x6c,0x30,0x5f,0x69,0x53,0x6d,0x70,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,
    0x30,0x2c,0x20,0x74,0x65,0x78,0x55,0x56,0x29,0x2e,0x78,0x79,0x7a,0x2c,0x20,0x76,
    0x65,0x63,0x33,0x28,0x5f,0x6e,0x6f,0x69,0x73,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,
    0x5f,0x31,0x29,0x29,0x20,0x2a,0x20,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x2e,0x78,0x79,
    0x7a,0x2c,0x20,0x76,0x65,0x63,0x33,0x28,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,
    0x72,0x6d,0x73,0x5b,0x30,0x5d,0x2e,0x7a,0x29,0x29,0x2c,0x20,0x31,0x2e,0x30,0x29,
    0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    static float4 gl_Position;
    static float4 coord;
    static float2 texUV;
    static float4 iColor;
    static float4 color;

    struct SPIRV_Cross_Input
    {
        float4 coord : TEXCOORD0;
        float4 color : TEXCOORD1;
    };

    struct SPIRV_Cross_Output
    {
        float2 texUV : TEXCOORD0;
        float4 iColor : TEXCOORD1;
        float4 gl_Position : SV_Position;
    };

    void vert_main()
    {
        gl_Position = float4(coord.xy, 0.0f, 1.0f);
        texUV = coord.zw;
        iColor = color;
    }

    SPIRV_Cross_Output main(SPIRV_Cross_Input stage_input)
    {
        coord = stage_input.coord;
        color = stage_input.color;
        vert_main();
        SPIRV_Cross_Output stage_output;
        stage_output.gl_Position = gl_Position;
        stage_output.texUV = texUV;
        stage_output.iColor = iColor;
        return stage_output;
    }
*/
static const uint8_t effect_vs_source_hlsl4[758] = {
    0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x67,0x6c,
    0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x3b,0x0a,0x73,0x74,0x61,0x74,0x69,
    0x63,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x63,0x6f,0x6f,0x72,0x64,0x3b,0x0a,
    0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x74,0x65,
    0x78,0x55,0x56,0x3b,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x34,0x20,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x73,0x74,0x61,0x74,0x69,
    0x63,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,
    0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,0x72,
    0x6f,0x73,0x73,0x5f,0x49,0x6e,0x70,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x63,0x6f,0x6f,0x72,0x64,0x20,0x3a,0x20,0x54,
    0x45,0x58,0x43,0x4f,0x4f,0x52,0x44,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x34,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3a,0x20,0x54,0x45,0x58,
    0x43,0x4f,0x4f,0x52,0x44,0x31,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,
    0x63,0x74,0x20,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x4f,
    0x75,0x74,0x70,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x32,0x20,0x74,0x65,0x78,0x55,0x56,0x20,0x3a,0x20,0x54,0x45,0x58,0x43,0x4f,
    0x4f,0x52,0x44,0x30,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,
    0x20,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x20,0x3a,0x20,0x54,0x45,0x58,0x43,0x4f,0x4f,
    0x52,0x44,0x31,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,
    0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3a,0x20,0x53,0x56,
    0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x76,
    0x6f,0x69,0x64,0x20,0x76,0x65,0x72,0x74,0x5f,0x6d,0x61,0x69,0x6e,0x28,0x29,0x0a,
    0x7b,0x0a,0x20,0x20,0x20,0x20,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,
    0x6e,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x28,0x63,0x6f,0x6f,0x72,0x64,
    0x2e,0x78,0x79,0x2c,0x20,0x30,0x2e,0x30,0x66,0x2c,0x20,0x31,0x2e,0x30,0x66,0x29,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x74,0x65,0x78,0x55,0x56,0x20,0x3d,0x20,0x63,0x6f,
    0x6f,0x72,0x64,0x2e,0x7a,0x77,0x3b,0x0a,0x20,0x20,0x20,0x20,0x69,0x43,0x6f,0x6c,
    0x6f,0x72,0x20,0x3d,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x7d,0x0a,0x0a,0x53,
    0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x4f,0x75,0x74,0x70,0x75,
    0x74,0x20,0x6d,0x61,0x69,0x6e,0x28,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,
    0x73,0x73,0x5f,0x49,0x6e,0x70,0x75,0x74,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,
    0x6e,0x70,0x75,0x74,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x63,0x6f,0x6f,0x72,
    0x64,0x20,0x3d,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,0x70,0x75,0x74,0x2e,
    0x63,0x6f,0x6f,0x72,0x64,0x3b,0x0a,0x20,0x20,0x20,0x20,0x63,0x6f,0x6c,0x6f,0x72,
    0x20,0x3d,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,0x70,0x75,0x74,0x2e,0x63,
    0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x20,0x20,0x20,0x20,0x76,0x65,0x72,0x74,0x5f,0x6d,
    0x61,0x69,0x6e,0x28,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x53,0x50,0x49,0x52,0x56,
    0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x4f,0x75,0x74,0x70,0x75,0x74,0x20,0x73,0x74,
    0x61,0x67,0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,0x74,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x73,0x74,0x61,0x67,0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,0x74,0x2e,0x67,0x6c,0x5f,
    0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x67,0x6c,0x5f,0x50,0x6f,
    0x73,0x69,0x74,0x69,0x6f,0x6e,0x3b,0x0a,0x20,0x20,0x20,0x20,0x73,0x74,0x61,0x67,
    0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,0x74,0x2e,0x74,0x65,0x78,0x55,0x56,0x20,0x3d,
    0x20,0x74,0x65,0x78,0x55,0x56,0x3b,0x0a,0x20,0x20,0x20,0x20,0x73,0x74,0x61,0x67,
    0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,0x74,0x2e,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x20,
    0x3d,0x20,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x20,0x20,0x20,0x20,0x72,0x65,
    0x74,0x75,0x72,0x6e,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x6f,0x75,0x74,0x70,0x75,
    0x74,0x3b,0x0a,0x7d,0x0a,0x00,
};
/*
    cbuffer fs_uniforms : register(b0)
    {
        float2 _48_iVelocity : packoffset(c0);
        float _48_iPressure : packoffset(c0.z);
        float _48_iTime : packoffset(c0.w);
        float _48_iWarpiness : packoffset(c1);
        float _48_iRatio : packoffset(c1.y);
        float _48_iZoom : packoffset(c1.z);
        float _48_iLevel : packoffset(c1.w);
    };

    Texture2D<float4> iTexChannel1 : register(t0);
    SamplerState iSmpChannel1 : register(s0);
    Texture2D<float4> iTexChannel0 : register(t1);
    SamplerState iSmpChannel0 : register(s1);

    static float2 texUV;
    static float4 iColor;
    static float4 fragColor;

    struct SPIRV_Cross_Input
    {
        float2 texUV : TEXCOORD0;
        float4 iColor : TEXCOORD1;
    };

    struct SPIRV_Cross_Output
    {
        float4 fragColor : SV_Target0;
    };

    float _noise(float2 p)
    {
        return iTexChannel1.Sample(iSmpChannel1, p).x;
    }

    void frag_main()
    {
        float2 _60 = (texUV * float2(_48_iRatio, 1.0f)) * _48_iZoom;
        float2 param = _60 - (_48_iVelocity * _48_iTime);
        float2 param_1 = _60 + (_noise(param) * _48_iWarpiness).xx;
        fragColor = float4(lerp(iTexChannel0.Sample(iSmpChannel0, texUV).xyz, _noise(param_1).xxx * iColor.xyz, _48_iPressure.xxx), 1.0f);
    }

    SPIRV_Cross_Output main(SPIRV_Cross_Input stage_input)
    {
        texUV = stage_input.texUV;
        iColor = stage_input.iColor;
        frag_main();
        SPIRV_Cross_Output stage_output;
        stage_output.fragColor = fragColor;
        return stage_output;
    }
*/
static const uint8_t effect_fs_source_hlsl4[1402] = {
    0x63,0x62,0x75,0x66,0x66,0x65,0x72,0x20,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,
    0x72,0x6d,0x73,0x20,0x3a,0x20,0x72,0x65,0x67,0x69,0x73,0x74,0x65,0x72,0x28,0x62,
    0x30,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,
    0x5f,0x34,0x38,0x5f,0x69,0x56,0x65,0x6c,0x6f,0x63,0x69,0x74,0x79,0x20,0x3a,0x20,
    0x70,0x61,0x63,0x6b,0x6f,0x66,0x66,0x73,0x65,0x74,0x28,0x63,0x30,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,0x38,0x5f,0x69,0x50,
    0x72,0x65,0x73,0x73,0x75,0x72,0x65,0x20,0x3a,0x20,0x70,0x61,0x63,0x6b,0x6f,0x66,
    0x66,0x73,0x65,0x74,0x28,0x63,0x30,0x2e,0x7a,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,0x38,0x5f,0x69,0x54,0x69,0x6d,0x65,0x20,
    0x3a,0x20,0x70,0x61,0x63,0x6b,0x6f,0x66,0x66,0x73,0x65,0x74,0x28,0x63,0x30,0x2e,
    0x77,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,
    0x38,0x5f,0x69,0x57,0x61,0x72,0x70,0x69,0x6e,0x65,0x73,0x73,0x20,0x3a,0x20,0x70,
    0x61,0x63,0x6b,0x6f,0x66,0x66,0x73,0x65,0x74,0x28,0x63,0x31,0x29,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,0x38,0x5f,0x69,0x52,0x61,
    0x74,0x69,0x6f,0x20,0x3a,0x20,0x70,0x61,0x63,0x6b,0x6f,0x66,0x66,0x73,0x65,0x74,
    0x28,0x63,0x31,0x2e,0x79,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x5f,0x34,0x38,0x5f,0x69,0x5a,0x6f,0x6f,0x6d,0x20,0x3a,0x20,0x70,0x61,
    0x63,0x6b,0x6f,0x66,0x66,0x73,0x65,0x74,0x28,0x63,0x31,0x2e,0x7a,0x29,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x34,0x38,0x5f,0x69,0x4c,
    0x65,0x76,0x65,0x6c,0x20,0x3a,0x20,0x70,0x61,0x63,0x6b,0x6f,0x66,0x66,0x73,0x65,
    0x74,0x28,0x63,0x31,0x2e,0x77,0x29,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x54,0x65,0x78,
    0x74,0x75,0x72,0x65,0x32,0x44,0x3c,0x66,0x6c,0x6f,0x61,0x74,0x34,0x3e,0x20,0x69,
    0x54,0x65,0x78,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x31,0x20,0x3a,0x20,0x72,0x65,
    0x67,0x69,0x73,0x74,0x65,0x72,0x28,0x74,0x30,0x29,0x3b,0x0a,0x53,0x61,0x6d,0x70,
    0x6c,0x65,0x72,0x53,0x74,0x61,0x74,0x65,0x20,0x69,0x53,0x6d,0x70,0x43,0x68,0x61,
    0x6e,0x6e,0x65,0x6c,0x31,0x20,0x3a,0x20,0x72,0x65,0x67,0x69,0x73,0x74,0x65,0x72,
    0x28,0x73,0x30,0x29,0x3b,0x0a,0x54,0x65,0x78,0x74,0x75,0x72,0x65,0x32,0x44,0x3c,
    0x66,0x6c,0x6f,0x61,0x74,0x34,0x3e,0x20,0x69,0x54,0x65,0x78,0x43,0x68,0x61,0x6e,
    0x6e,0x65,0x6c,0x30,0x20,0x3a,0x20,0x72,0x65,0x67,0x69,0x73,0x74,0x65,0x72,0x28,
    0x74,0x31,0x29,0x3b,0x0a,0x53,0x61,0x6d,0x70,0x6c,0x65,0x72,0x53,0x74,0x61,0x74,
    0x65,0x20,0x69,0x53,0x6d,0x70,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x30,0x20,0x3a,
    0x20,0x72,0x65,0x67,0x69,0x73,0x74,0x65,0x72,0x28,0x73,0x31,0x29,0x3b,0x0a,0x0a,
    0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x74,0x65,
    0x78,0x55,0x56,0x3b,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x34,0x20,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x73,0x74,0x61,0x74,0x69,
    0x63,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,
    0x6f,0x72,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x53,0x50,0x49,0x52,
    0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x49,0x6e,0x70,0x75,0x74,0x0a,0x7b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x74,0x65,0x78,0x55,0x56,
    0x20,0x3a,0x20,0x54,0x45,0x58,0x43,0x4f,0x4f,0x52,0x44,0x30,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x20,
    0x3a,0x20,0x54,0x45,0x58,0x43,0x4f,0x4f,0x52,0x44,0x31,0x3b,0x0a,0x7d,0x3b,0x0a,
    0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,0x72,
    0x6f,0x73,0x73,0x5f,0x4f,0x75,0x74,0x70,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,
    0x72,0x20,0x3a,0x20,0x53,0x56,0x5f,0x54,0x61,0x72,0x67,0x65,0x74,0x30,0x3b,0x0a,
    0x7d,0x3b,0x0a,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x6e,0x6f,0x69,0x73,0x65,
    0x28,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x69,0x54,0x65,0x78,0x43,0x68,0x61,0x6e,
    0x6e,0x65,0x6c,0x31,0x2e,0x53,0x61,0x6d,0x70,0x6c,0x65,0x28,0x69,0x53,0x6d,0x70,
    0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x31,0x2c,0x20,0x70,0x29,0x2e,0x78,0x3b,0x0a,
    0x7d,0x0a,0x0a,0x76,0x6f,0x69,0x64,0x20,0x66,0x72,0x61,0x67,0x5f,0x6d,0x61,0x69,
    0x6e,0x28,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x5f,0x36,0x30,0x20,0x3d,0x20,0x28,0x74,0x65,0x78,0x55,0x56,0x20,0x2a,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x5f,0x34,0x38,0x5f,0x69,0x52,0x61,0x74,0x69,
    0x6f,0x2c,0x20,0x31,0x2e,0x30,0x66,0x29,0x29,0x20,0x2a,0x20,0x5f,0x34,0x38,0x5f,
    0x69,0x5a,0x6f,0x6f,0x6d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,
    0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x20,0x3d,0x20,0x5f,0x36,0x30,0x20,0x2d,0x20,
    0x28,0x5f,0x34,0x38,0x5f,0x69,0x56,0x65,0x6c,0x6f,0x63,0x69,0x74,0x79,0x20,0x2a,
    0x20,0x5f,0x34,0x38,0x5f,0x69,0x54,0x69,0x6d,0x65,0x29,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x20,
    0x3d,0x20,0x5f,0x36,0x30,0x20,0x2b,0x20,0x28,0x5f,0x6e,0x6f,0x69,0x73,0x65,0x28,
    0x70,0x61,0x72,0x61,0x6d,0x29,0x20,0x2a,0x20,0x5f,0x34,0x38,0x5f,0x69,0x57,0x61,
    0x72,0x70,0x69,0x6e,0x65,0x73,0x73,0x29,0x2e,0x78,0x78,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x34,0x28,0x6c,0x65,0x72,0x70,0x28,0x69,0x54,0x65,0x78,0x43,0x68,0x61,
    0x6e,0x6e,0x65,0x6c,0x30,0x2e,0x53,0x61,0x6d,0x70,0x6c,0x65,0x28,0x69,0x53,0x6d,
    0x70,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x30,0x2c,0x20,0x74,0x65,0x78,0x55,0x56,
    0x29,0x2e,0x78,0x79,0x7a,0x2c,0x20,0x5f,0x6e,0x6f,0x69,0x73,0x65,0x28,0x70,0x61,
    0x72,0x61,0x6d,0x5f,0x31,0x29,0x2e,0x78,0x78,0x78,0x20,0x2a,0x20,0x69,0x43,0x6f,
    0x6c,0x6f,0x72,0x2e,0x78,0x79,0x7a,0x2c,0x20,0x5f,0x34,0x38,0x5f,0x69,0x50,0x72,
    0x65,0x73,0x73,0x75,0x72,0x65,0x2e,0x78,0x78,0x78,0x29,0x2c,0x20,0x31,0x2e,0x30,
    0x66,0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,
    0x73,0x73,0x5f,0x4f,0x75,0x74,0x70,0x75,0x74,0x20,0x6d,0x61,0x69,0x6e,0x28,0x53,
    0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,0x5f,0x49,0x6e,0x70,0x75,0x74,
    0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x69,0x6e,0x70,0x75,0x74,0x29,0x0a,0x7b,0x0a,
    0x20,0x20,0x20,0x20,0x74,0x65,0x78,0x55,0x56,0x20,0x3d,0x20,0x73,0x74,0x61,0x67,
    0x65,0x5f,0x69,0x6e,0x70,0x75,0x74,0x2e,0x74,0x65,0x78,0x55,0x56,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x73,0x74,0x61,0x67,
    0x65,0x5f,0x69,0x6e,0x70,0x75,0x74,0x2e,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x72,0x61,0x67,0x5f,0x6d,0x61,0x69,0x6e,0x28,0x29,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x53,0x50,0x49,0x52,0x56,0x5f,0x43,0x72,0x6f,0x73,0x73,
    0x5f,0x4f,0x75,0x74,0x70,0x75,0x74,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x6f,0x75,
    0x74,0x70,0x75,0x74,0x3b,0x0a,0x20,0x20,0x20,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,
    0x6f,0x75,0x74,0x70,0x75,0x74,0x2e,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,0x72,
    0x20,0x3d,0x20,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x73,0x74,0x61,0x67,0x65,0x5f,0x6f,
    0x75,0x74,0x70,0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x00,
};
/*
    #include <metal_stdlib>
    #include <simd/simd.h>

    using namespace metal;

    struct main0_out
    {
        float2 texUV [[user(locn0)]];
        float4 iColor [[user(locn1)]];
        float4 gl_Position [[position]];
    };

    struct main0_in
    {
        float4 coord [[attribute(0)]];
        float4 color [[attribute(1)]];
    };

    vertex main0_out main0(main0_in in [[stage_in]])
    {
        main0_out out = {};
        out.gl_Position = float4(in.coord.xy, 0.0, 1.0);
        out.texUV = in.coord.zw;
        out.iColor = in.color;
        return out;
    }

*/
static const uint8_t effect_vs_source_metal_macos[497] = {
    0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,
    0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,
    0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,
    0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,
    0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,
    0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x20,0x74,0x65,0x78,0x55,0x56,0x20,0x5b,0x5b,0x75,0x73,
    0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x20,0x5b,
    0x5b,0x75,0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x31,0x29,0x5d,0x5d,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x67,0x6c,0x5f,0x50,0x6f,
    0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x5b,0x5b,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,
    0x6e,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,
    0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,0x6e,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x34,0x20,0x63,0x6f,0x6f,0x72,0x64,0x20,0x5b,0x5b,0x61,0x74,
    0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x28,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x5b,
    0x5b,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x28,0x31,0x29,0x5d,0x5d,0x3b,
    0x0a,0x7d,0x3b,0x0a,0x0a,0x76,0x65,0x72,0x74,0x65,0x78,0x20,0x6d,0x61,0x69,0x6e,
    0x30,0x5f,0x6f,0x75,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,0x69,0x6e,
    0x30,0x5f,0x69,0x6e,0x20,0x69,0x6e,0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,0x65,0x5f,
    0x69,0x6e,0x5d,0x5d,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x6d,0x61,0x69,0x6e,
    0x30,0x5f,0x6f,0x75,0x74,0x20,0x6f,0x75,0x74,0x20,0x3d,0x20,0x7b,0x7d,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x6f,0x75,0x74,0x2e,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,
    0x69,0x6f,0x6e,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x28,0x69,0x6e,0x2e,
    0x63,0x6f,0x6f,0x72,0x64,0x2e,0x78,0x79,0x2c,0x20,0x30,0x2e,0x30,0x2c,0x20,0x31,
    0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,0x2e,0x74,0x65,0x78,
    0x55,0x56,0x20,0x3d,0x20,0x69,0x6e,0x2e,0x63,0x6f,0x6f,0x72,0x64,0x2e,0x7a,0x77,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,0x2e,0x69,0x43,0x6f,0x6c,0x6f,0x72,
    0x20,0x3d,0x20,0x69,0x6e,0x2e,0x63,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6f,0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,
    0x00,
};
/*
    #pragma clang diagnostic ignored "-Wmissing-prototypes"

    #include <metal_stdlib>
    #include <simd/simd.h>

    using namespace metal;

    struct fs_uniforms
    {
        float2 iVelocity;
        float iPressure;
        float iTime;
        float iWarpiness;
        float iRatio;
        float iZoom;
        float iLevel;
    };

    struct main0_out
    {
        float4 fragColor [[color(0)]];
    };

    struct main0_in
    {
        float2 texUV [[user(locn0)]];
        float4 iColor [[user(locn1)]];
    };

    static inline __attribute__((always_inline))
    float _noise(thread const float2& p, texture2d<float> iTexChannel1, sampler iSmpChannel1)
    {
        return iTexChannel1.sample(iSmpChannel1, p).x;
    }

    fragment main0_out main0(main0_in in [[stage_in]], constant fs_uniforms& _48 [[buffer(0)]], texture2d<float> iTexChannel1 [[texture(0)]], texture2d<float> iTexChannel0 [[texture(1)]], sampler iSmpChannel1 [[sampler(0)]], sampler iSmpChannel0 [[sampler(1)]])
    {
        main0_out out = {};
        float2 _60 = (in.texUV * float2(_48.iRatio, 1.0)) * _48.iZoom;
        float2 param = _60 - (_48.iVelocity * _48.iTime);
        float2 param_1 = _60 + float2(_noise(param, iTexChannel1, iSmpChannel1) * _48.iWarpiness);
        out.fragColor = float4(mix(iTexChannel0.sample(iSmpChannel0, in.texUV).xyz, float3(_noise(param_1, iTexChannel1, iSmpChannel1)) * in.iColor.xyz, float3(_48.iPressure)), 1.0);
        return out;
    }

*/
static const uint8_t effect_fs_source_metal_macos[1328] = {
    0x23,0x70,0x72,0x61,0x67,0x6d,0x61,0x20,0x63,0x6c,0x61,0x6e,0x67,0x20,0x64,0x69,
    0x61,0x67,0x6e,0x6f,0x73,0x74,0x69,0x63,0x20,0x69,0x67,0x6e,0x6f,0x72,0x65,0x64,
    0x20,0x22,0x2d,0x57,0x6d,0x69,0x73,0x73,0x69,0x6e,0x67,0x2d,0x70,0x72,0x6f,0x74,
    0x6f,0x74,0x79,0x70,0x65,0x73,0x22,0x0a,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,
    0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,
    0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,
    0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,
    0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,
    0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,
    0x72,0x6d,0x73,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x69,0x56,0x65,0x6c,0x6f,0x63,0x69,0x74,0x79,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x69,0x50,0x72,0x65,0x73,0x73,0x75,0x72,0x65,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x69,0x54,0x69,0x6d,0x65,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x69,0x57,0x61,0x72,
    0x70,0x69,0x6e,0x65,0x73,0x73,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x69,0x52,0x61,0x74,0x69,0x6f,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x69,0x5a,0x6f,0x6f,0x6d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x69,0x4c,0x65,0x76,0x65,0x6c,0x3b,0x0a,0x7d,0x3b,0x0a,
    0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,
    0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x66,
    0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,0x72,0x20,0x5b,0x5b,0x63,0x6f,0x6c,0x6f,0x72,
    0x28,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,
    0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,0x6e,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x74,0x65,0x78,0x55,0x56,0x20,0x5b,0x5b,
    0x75,0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x69,0x43,0x6f,0x6c,0x6f,0x72,
    0x20,0x5b,0x5b,0x75,0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x31,0x29,0x5d,0x5d,
    0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x69,0x6e,0x6c,
    0x69,0x6e,0x65,0x20,0x5f,0x5f,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x5f,
    0x5f,0x28,0x28,0x61,0x6c,0x77,0x61,0x79,0x73,0x5f,0x69,0x6e,0x6c,0x69,0x6e,0x65,
    0x29,0x29,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x6e,0x6f,0x69,0x73,0x65,0x28,
    0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x26,0x20,0x70,0x2c,0x20,0x74,0x65,0x78,0x74,0x75,0x72,0x65,0x32,
    0x64,0x3c,0x66,0x6c,0x6f,0x61,0x74,0x3e,0x20,0x69,0x54,0x65,0x78,0x43,0x68,0x61,
    0x6e,0x6e,0x65,0x6c,0x31,0x2c,0x20,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x20,0x69,
    0x53,0x6d,0x70,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x31,0x29,0x0a,0x7b,0x0a,0x20,
    0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x69,0x54,0x65,0x78,0x43,0x68,
    0x61,0x6e,0x6e,0x65,0x6c,0x31,0x2e,0x73,0x61,0x6d,0x70,0x6c,0x65,0x28,0x69,0x53,
    0x6d,0x70,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x31,0x2c,0x20,0x70,0x29,0x2e,0x78,
    0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x72,0x61,0x67,0x6d,0x65,0x6e,0x74,0x20,0x6d,0x61,
    0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,
    0x69,0x6e,0x30,0x5f,0x69,0x6e,0x20,0x69,0x6e,0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,
    0x65,0x5f,0x69,0x6e,0x5d,0x5d,0x2c,0x20,0x63,0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,
    0x20,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x26,0x20,0x5f,0x34,
    0x38,0x20,0x5b,0x5b,0x62,0x75,0x66,0x66,0x65,0x72,0x28,0x30,0x29,0x5d,0x5d,0x2c,
    0x20,0x74,0x65,0x78,0x74,0x75,0x72,0x65,0x32,0x64,0x3c,0x66,0x6c,0x6f,0x61,0x74,
    0x3e,0x20,0x69,0x54,0x65,0x78,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x31,0x20,0x5b,
    0x5b,0x74,0x65,0x78,0x74,0x75,0x72,0x65,0x28,0x30,0x29,0x5d,0x5d,0x2c,0x20,0x74,
    0x65,0x78,0x74,0x75,0x72,0x65,0x32,0x64,0x3c,0x66,0x6c,0x6f,0x61,0x74,0x3e,0x20,
    0x69,0x54,0x65,0x78,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x30,0x20,0x5b,0x5b,0x74,
    0x65,0x78,0x74,0x75,0x72,0x65,0x28,0x31,0x29,0x5d,0x5d,0x2c,0x20,0x73,0x61,0x6d,
    0x70,0x6c,0x65,0x72,0x20,0x69,0x53,0x6d,0x70,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,
    0x31,0x20,0x5b,0x5b,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x28,0x30,0x29,0x5d,0x5d,
    0x2c,0x20,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x20,0x69,0x53,0x6d,0x70,0x43,0x68,
    0x61,0x6e,0x6e,0x65,0x6c,0x30,0x20,0x5b,0x5b,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,
    0x28,0x31,0x29,0x5d,0x5d,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x6d,0x61,0x69,
    0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6f,0x75,0x74,0x20,0x3d,0x20,0x7b,0x7d,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x36,0x30,0x20,
    0x3d,0x20,0x28,0x69,0x6e,0x2e,0x74,0x65,0x78,0x55,0x56,0x20,0x2a,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x28,0x5f,0x34,0x38,0x2e,0x69,0x52,0x61,0x74,0x69,0x6f,0x2c,
    0x20,0x31,0x2e,0x30,0x29,0x29,0x20,0x2a,0x20,0x5f,0x34,0x38,0x2e,0x69,0x5a,0x6f,
    0x6f,0x6d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x20,0x3d,0x20,0x5f,0x36,0x30,0x20,0x2d,0x20,0x28,0x5f,0x34,
    0x38,0x2e,0x69,0x56,0x65,0x6c,0x6f,0x63,0x69,0x74,0x79,0x20,0x2a,0x20,0x5f,0x34,
    0x38,0x2e,0x69,0x54,0x69,0x6d,0x65,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x20,0x3d,0x20,0x5f,
    0x36,0x30,0x20,0x2b,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x5f,0x6e,0x6f,0x69,
    0x73,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x2c,0x20,0x69,0x54,0x65,0x78,0x43,0x68,
    0x61,0x6e,0x6e,0x65,0x6c,0x31,0x2c,0x20,0x69,0x53,0x6d,0x70,0x43,0x68,0x61,0x6e,
    0x6e,0x65,0x6c,0x31,0x29,0x20,0x2a,0x20,0x5f,0x34,0x38,0x2e,0x69,0x57,0x61,0x72,
    0x70,0x69,0x6e,0x65,0x73,0x73,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,
    0x2e,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x34,0x28,0x6d,0x69,0x78,0x28,0x69,0x54,0x65,0x78,0x43,0x68,0x61,0x6e,
    0x6e,0x65,0x6c,0x30,0x2e,0x73,0x61,0x6d,0x70,0x6c,0x65,0x28,0x69,0x53,0x6d,0x70,
    0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x30,0x2c,0x20,0x69,0x6e,0x2e,0x74,0x65,0x78,
    0x55,0x56,0x29,0x2e,0x78,0x79,0x7a,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x28,
    0x5f,0x6e,0x6f,0x69,0x73,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x2c,0x20,
    0x69,0x54,0x65,0x78,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x31,0x2c,0x20,0x69,0x53,
    0x6d,0x70,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x31,0x29,0x29,0x20,0x2a,0x20,0x69,
    0x6e,0x2e,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x2e,0x78,0x79,0x7a,0x2c,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x33,0x28,0x5f,0x34,0x38,0x2e,0x69,0x50,0x72,0x65,0x73,0x73,0x75,
    0x72,0x65,0x29,0x29,0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6f,0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,

};
/*
    #include <metal_stdlib>
    #include <simd/simd.h>

    using namespace metal;

    struct main0_out
    {
        float2 texUV [[user(locn0)]];
        float4 iColor [[user(locn1)]];
        float4 gl_Position [[position]];
    };

    struct main0_in
    {
        float4 coord [[attribute(0)]];
        float4 color [[attribute(1)]];
    };

    vertex main0_out main0(main0_in in [[stage_in]])
    {
        main0_out out = {};
        out.gl_Position = float4(in.coord.xy, 0.0, 1.0);
        out.texUV = in.coord.zw;
        out.iColor = in.color;
        return out;
    }

*/
static const uint8_t effect_vs_source_metal_ios[497] = {
    0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,
    0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,
    0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,
    0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,
    0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,
    0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x32,0x20,0x74,0x65,0x78,0x55,0x56,0x20,0x5b,0x5b,0x75,0x73,
    0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x20,0x5b,
    0x5b,0x75,0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x31,0x29,0x5d,0x5d,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x67,0x6c,0x5f,0x50,0x6f,
    0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x5b,0x5b,0x70,0x6f,0x73,0x69,0x74,0x69,0x6f,
    0x6e,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,
    0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,0x6e,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x34,0x20,0x63,0x6f,0x6f,0x72,0x64,0x20,0x5b,0x5b,0x61,0x74,
    0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x28,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x20,0x20,
    0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x5b,
    0x5b,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x28,0x31,0x29,0x5d,0x5d,0x3b,
    0x0a,0x7d,0x3b,0x0a,0x0a,0x76,0x65,0x72,0x74,0x65,0x78,0x20,0x6d,0x61,0x69,0x6e,
    0x30,0x5f,0x6f,0x75,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,0x69,0x6e,
    0x30,0x5f,0x69,0x6e,0x20,0x69,0x6e,0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,0x65,0x5f,
    0x69,0x6e,0x5d,0x5d,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x6d,0x61,0x69,0x6e,
    0x30,0x5f,0x6f,0x75,0x74,0x20,0x6f,0x75,0x74,0x20,0x3d,0x20,0x7b,0x7d,0x3b,0x0a,
    0x20,0x20,0x20,0x20,0x6f,0x75,0x74,0x2e,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,
    0x69,0x6f,0x6e,0x20,0x3d,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x28,0x69,0x6e,0x2e,
    0x63,0x6f,0x6f,0x72,0x64,0x2e,0x78,0x79,0x2c,0x20,0x30,0x2e,0x30,0x2c,0x20,0x31,
    0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,0x2e,0x74,0x65,0x78,
    0x55,0x56,0x20,0x3d,0x20,0x69,0x6e,0x2e,0x63,0x6f,0x6f,0x72,0x64,0x2e,0x7a,0x77,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,0x2e,0x69,0x43,0x6f,0x6c,0x6f,0x72,
    0x20,0x3d,0x20,0x69,0x6e,0x2e,0x63,0x6f,0x6c,0x6f,0x72,0x3b,0x0a,0x20,0x20,0x20,
    0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6f,0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,
    0x00,
};
/*
    #pragma clang diagnostic ignored "-Wmissing-prototypes"

    #include <metal_stdlib>
    #include <simd/simd.h>

    using namespace metal;

    struct fs_uniforms
    {
        float2 iVelocity;
        float iPressure;
        float iTime;
        float iWarpiness;
        float iRatio;
        float iZoom;
        float iLevel;
    };

    struct main0_out
    {
        float4 fragColor [[color(0)]];
    };

    struct main0_in
    {
        float2 texUV [[user(locn0)]];
        float4 iColor [[user(locn1)]];
    };

    static inline __attribute__((always_inline))
    float _noise(thread const float2& p, texture2d<float> iTexChannel1, sampler iSmpChannel1)
    {
        return iTexChannel1.sample(iSmpChannel1, p).x;
    }

    fragment main0_out main0(main0_in in [[stage_in]], constant fs_uniforms& _48 [[buffer(0)]], texture2d<float> iTexChannel1 [[texture(0)]], texture2d<float> iTexChannel0 [[texture(1)]], sampler iSmpChannel1 [[sampler(0)]], sampler iSmpChannel0 [[sampler(1)]])
    {
        main0_out out = {};
        float2 _60 = (in.texUV * float2(_48.iRatio, 1.0)) * _48.iZoom;
        float2 param = _60 - (_48.iVelocity * _48.iTime);
        float2 param_1 = _60 + float2(_noise(param, iTexChannel1, iSmpChannel1) * _48.iWarpiness);
        out.fragColor = float4(mix(iTexChannel0.sample(iSmpChannel0, in.texUV).xyz, float3(_noise(param_1, iTexChannel1, iSmpChannel1)) * in.iColor.xyz, float3(_48.iPressure)), 1.0);
        return out;
    }

*/
static const uint8_t effect_fs_source_metal_ios[1328] = {
    0x23,0x70,0x72,0x61,0x67,0x6d,0x61,0x20,0x63,0x6c,0x61,0x6e,0x67,0x20,0x64,0x69,
    0x61,0x67,0x6e,0x6f,0x73,0x74,0x69,0x63,0x20,0x69,0x67,0x6e,0x6f,0x72,0x65,0x64,
    0x20,0x22,0x2d,0x57,0x6d,0x69,0x73,0x73,0x69,0x6e,0x67,0x2d,0x70,0x72,0x6f,0x74,
    0x6f,0x74,0x79,0x70,0x65,0x73,0x22,0x0a,0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,
    0x65,0x20,0x3c,0x6d,0x65,0x74,0x61,0x6c,0x5f,0x73,0x74,0x64,0x6c,0x69,0x62,0x3e,
    0x0a,0x23,0x69,0x6e,0x63,0x6c,0x75,0x64,0x65,0x20,0x3c,0x73,0x69,0x6d,0x64,0x2f,
    0x73,0x69,0x6d,0x64,0x2e,0x68,0x3e,0x0a,0x0a,0x75,0x73,0x69,0x6e,0x67,0x20,0x6e,
    0x61,0x6d,0x65,0x73,0x70,0x61,0x63,0x65,0x20,0x6d,0x65,0x74,0x61,0x6c,0x3b,0x0a,
    0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,
    0x72,0x6d,0x73,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,
    0x20,0x69,0x56,0x65,0x6c,0x6f,0x63,0x69,0x74,0x79,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x66,0x6c,0x6f,0x61,0x74,0x20,0x69,0x50,0x72,0x65,0x73,0x73,0x75,0x72,0x65,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x69,0x54,0x69,0x6d,0x65,
    0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x20,0x69,0x57,0x61,0x72,
    0x70,0x69,0x6e,0x65,0x73,0x73,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,
    0x74,0x20,0x69,0x52,0x61,0x74,0x69,0x6f,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x20,0x69,0x5a,0x6f,0x6f,0x6d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,
    0x6c,0x6f,0x61,0x74,0x20,0x69,0x4c,0x65,0x76,0x65,0x6c,0x3b,0x0a,0x7d,0x3b,0x0a,
    0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x6f,0x75,
    0x74,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x66,
    0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,0x72,0x20,0x5b,0x5b,0x63,0x6f,0x6c,0x6f,0x72,
    0x28,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,
    0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x5f,0x69,0x6e,0x0a,0x7b,0x0a,0x20,0x20,0x20,
    0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x74,0x65,0x78,0x55,0x56,0x20,0x5b,0x5b,
    0x75,0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x30,0x29,0x5d,0x5d,0x3b,0x0a,0x20,
    0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x34,0x20,0x69,0x43,0x6f,0x6c,0x6f,0x72,
    0x20,0x5b,0x5b,0x75,0x73,0x65,0x72,0x28,0x6c,0x6f,0x63,0x6e,0x31,0x29,0x5d,0x5d,
    0x3b,0x0a,0x7d,0x3b,0x0a,0x0a,0x73,0x74,0x61,0x74,0x69,0x63,0x20,0x69,0x6e,0x6c,
    0x69,0x6e,0x65,0x20,0x5f,0x5f,0x61,0x74,0x74,0x72,0x69,0x62,0x75,0x74,0x65,0x5f,
    0x5f,0x28,0x28,0x61,0x6c,0x77,0x61,0x79,0x73,0x5f,0x69,0x6e,0x6c,0x69,0x6e,0x65,
    0x29,0x29,0x0a,0x66,0x6c,0x6f,0x61,0x74,0x20,0x5f,0x6e,0x6f,0x69,0x73,0x65,0x28,
    0x74,0x68,0x72,0x65,0x61,0x64,0x20,0x63,0x6f,0x6e,0x73,0x74,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x32,0x26,0x20,0x70,0x2c,0x20,0x74,0x65,0x78,0x74,0x75,0x72,0x65,0x32,
    0x64,0x3c,0x66,0x6c,0x6f,0x61,0x74,0x3e,0x20,0x69,0x54,0x65,0x78,0x43,0x68,0x61,
    0x6e,0x6e,0x65,0x6c,0x31,0x2c,0x20,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x20,0x69,
    0x53,0x6d,0x70,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x31,0x29,0x0a,0x7b,0x0a,0x20,
    0x20,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x69,0x54,0x65,0x78,0x43,0x68,
    0x61,0x6e,0x6e,0x65,0x6c,0x31,0x2e,0x73,0x61,0x6d,0x70,0x6c,0x65,0x28,0x69,0x53,
    0x6d,0x70,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x31,0x2c,0x20,0x70,0x29,0x2e,0x78,
    0x3b,0x0a,0x7d,0x0a,0x0a,0x66,0x72,0x61,0x67,0x6d,0x65,0x6e,0x74,0x20,0x6d,0x61,
    0x69,0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6d,0x61,0x69,0x6e,0x30,0x28,0x6d,0x61,
    0x69,0x6e,0x30,0x5f,0x69,0x6e,0x20,0x69,0x6e,0x20,0x5b,0x5b,0x73,0x74,0x61,0x67,
    0x65,0x5f,0x69,0x6e,0x5d,0x5d,0x2c,0x20,0x63,0x6f,0x6e,0x73,0x74,0x61,0x6e,0x74,
    0x20,0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x26,0x20,0x5f,0x34,
    0x38,0x20,0x5b,0x5b,0x62,0x75,0x66,0x66,0x65,0x72,0x28,0x30,0x29,0x5d,0x5d,0x2c,
    0x20,0x74,0x65,0x78,0x74,0x75,0x72,0x65,0x32,0x64,0x3c,0x66,0x6c,0x6f,0x61,0x74,
    0x3e,0x20,0x69,0x54,0x65,0x78,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x31,0x20,0x5b,
    0x5b,0x74,0x65,0x78,0x74,0x75,0x72,0x65,0x28,0x30,0x29,0x5d,0x5d,0x2c,0x20,0x74,
    0x65,0x78,0x74,0x75,0x72,0x65,0x32,0x64,0x3c,0x66,0x6c,0x6f,0x61,0x74,0x3e,0x20,
    0x69,0x54,0x65,0x78,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x30,0x20,0x5b,0x5b,0x74,
    0x65,0x78,0x74,0x75,0x72,0x65,0x28,0x31,0x29,0x5d,0x5d,0x2c,0x20,0x73,0x61,0x6d,
    0x70,0x6c,0x65,0x72,0x20,0x69,0x53,0x6d,0x70,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,
    0x31,0x20,0x5b,0x5b,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x28,0x30,0x29,0x5d,0x5d,
    0x2c,0x20,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,0x20,0x69,0x53,0x6d,0x70,0x43,0x68,
    0x61,0x6e,0x6e,0x65,0x6c,0x30,0x20,0x5b,0x5b,0x73,0x61,0x6d,0x70,0x6c,0x65,0x72,
    0x28,0x31,0x29,0x5d,0x5d,0x29,0x0a,0x7b,0x0a,0x20,0x20,0x20,0x20,0x6d,0x61,0x69,
    0x6e,0x30,0x5f,0x6f,0x75,0x74,0x20,0x6f,0x75,0x74,0x20,0x3d,0x20,0x7b,0x7d,0x3b,
    0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x5f,0x36,0x30,0x20,
    0x3d,0x20,0x28,0x69,0x6e,0x2e,0x74,0x65,0x78,0x55,0x56,0x20,0x2a,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x28,0x5f,0x34,0x38,0x2e,0x69,0x52,0x61,0x74,0x69,0x6f,0x2c,
    0x20,0x31,0x2e,0x30,0x29,0x29,0x20,0x2a,0x20,0x5f,0x34,0x38,0x2e,0x69,0x5a,0x6f,
    0x6f,0x6d,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x20,0x3d,0x20,0x5f,0x36,0x30,0x20,0x2d,0x20,0x28,0x5f,0x34,
    0x38,0x2e,0x69,0x56,0x65,0x6c,0x6f,0x63,0x69,0x74,0x79,0x20,0x2a,0x20,0x5f,0x34,
    0x38,0x2e,0x69,0x54,0x69,0x6d,0x65,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x32,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x20,0x3d,0x20,0x5f,
    0x36,0x30,0x20,0x2b,0x20,0x66,0x6c,0x6f,0x61,0x74,0x32,0x28,0x5f,0x6e,0x6f,0x69,
    0x73,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x2c,0x20,0x69,0x54,0x65,0x78,0x43,0x68,
    0x61,0x6e,0x6e,0x65,0x6c,0x31,0x2c,0x20,0x69,0x53,0x6d,0x70,0x43,0x68,0x61,0x6e,
    0x6e,0x65,0x6c,0x31,0x29,0x20,0x2a,0x20,0x5f,0x34,0x38,0x2e,0x69,0x57,0x61,0x72,
    0x70,0x69,0x6e,0x65,0x73,0x73,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,0x6f,0x75,0x74,
    0x2e,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x66,0x6c,0x6f,
    0x61,0x74,0x34,0x28,0x6d,0x69,0x78,0x28,0x69,0x54,0x65,0x78,0x43,0x68,0x61,0x6e,
    0x6e,0x65,0x6c,0x30,0x2e,0x73,0x61,0x6d,0x70,0x6c,0x65,0x28,0x69,0x53,0x6d,0x70,
    0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x30,0x2c,0x20,0x69,0x6e,0x2e,0x74,0x65,0x78,
    0x55,0x56,0x29,0x2e,0x78,0x79,0x7a,0x2c,0x20,0x66,0x6c,0x6f,0x61,0x74,0x33,0x28,
    0x5f,0x6e,0x6f,0x69,0x73,0x65,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x2c,0x20,
    0x69,0x54,0x65,0x78,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x31,0x2c,0x20,0x69,0x53,
    0x6d,0x70,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x31,0x29,0x29,0x20,0x2a,0x20,0x69,
    0x6e,0x2e,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x2e,0x78,0x79,0x7a,0x2c,0x20,0x66,0x6c,
    0x6f,0x61,0x74,0x33,0x28,0x5f,0x34,0x38,0x2e,0x69,0x50,0x72,0x65,0x73,0x73,0x75,
    0x72,0x65,0x29,0x29,0x2c,0x20,0x31,0x2e,0x30,0x29,0x3b,0x0a,0x20,0x20,0x20,0x20,
    0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6f,0x75,0x74,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,

};
/*
    diagnostic(off, derivative_uniformity);

    var<private> coord : vec4f;

    var<private> texUV : vec2f;

    var<private> iColor : vec4f;

    var<private> color : vec4f;

    var<private> gl_Position : vec4f;

    fn main_1() {
      let x_19 : vec4f = coord;
      let x_20 : vec2f = vec2f(x_19.x, x_19.y);
      gl_Position = vec4f(x_20.x, x_20.y, 0.0f, 1.0f);
      let x_30 : vec4f = coord;
      texUV = vec2f(x_30.z, x_30.w);
      let x_34 : vec4f = color;
      iColor = x_34;
      return;
    }

    struct main_out {
      @builtin(position)
      gl_Position : vec4f,
      @location(0)
      texUV_1 : vec2f,
      @location(1)
      iColor_1 : vec4f,
    }

    @vertex
    fn main(@location(0) coord_param : vec4f, @location(1) color_param : vec4f) -> main_out {
      coord = coord_param;
      color = color_param;
      main_1();
      return main_out(gl_Position, texUV, iColor);
    }

*/
static const uint8_t effect_vs_source_wgsl[790] = {
    0x64,0x69,0x61,0x67,0x6e,0x6f,0x73,0x74,0x69,0x63,0x28,0x6f,0x66,0x66,0x2c,0x20,
    0x64,0x65,0x72,0x69,0x76,0x61,0x74,0x69,0x76,0x65,0x5f,0x75,0x6e,0x69,0x66,0x6f,
    0x72,0x6d,0x69,0x74,0x79,0x29,0x3b,0x0a,0x0a,0x76,0x61,0x72,0x3c,0x70,0x72,0x69,
    0x76,0x61,0x74,0x65,0x3e,0x20,0x63,0x6f,0x6f,0x72,0x64,0x20,0x3a,0x20,0x76,0x65,
    0x63,0x34,0x66,0x3b,0x0a,0x0a,0x76,0x61,0x72,0x3c,0x70,0x72,0x69,0x76,0x61,0x74,
    0x65,0x3e,0x20,0x74,0x65,0x78,0x55,0x56,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,
    0x3b,0x0a,0x0a,0x76,0x61,0x72,0x3c,0x70,0x72,0x69,0x76,0x61,0x74,0x65,0x3e,0x20,
    0x69,0x43,0x6f,0x6c,0x6f,0x72,0x20,0x3a,0x20,0x76,0x65,0x63,0x34,0x66,0x3b,0x0a,
    0x0a,0x76,0x61,0x72,0x3c,0x70,0x72,0x69,0x76,0x61,0x74,0x65,0x3e,0x20,0x63,0x6f,
    0x6c,0x6f,0x72,0x20,0x3a,0x20,0x76,0x65,0x63,0x34,0x66,0x3b,0x0a,0x0a,0x76,0x61,
    0x72,0x3c,0x70,0x72,0x69,0x76,0x61,0x74,0x65,0x3e,0x20,0x67,0x6c,0x5f,0x50,0x6f,
    0x73,0x69,0x74,0x69,0x6f,0x6e,0x20,0x3a,0x20,0x76,0x65,0x63,0x34,0x66,0x3b,0x0a,
    0x0a,0x66,0x6e,0x20,0x6d,0x61,0x69,0x6e,0x5f,0x31,0x28,0x29,0x20,0x7b,0x0a,0x20,
    0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x31,0x39,0x20,0x3a,0x20,0x76,0x65,0x63,0x34,
    0x66,0x20,0x3d,0x20,0x63,0x6f,0x6f,0x72,0x64,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,
    0x20,0x78,0x5f,0x32,0x30,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,
    0x76,0x65,0x63,0x32,0x66,0x28,0x78,0x5f,0x31,0x39,0x2e,0x78,0x2c,0x20,0x78,0x5f,
    0x31,0x39,0x2e,0x79,0x29,0x3b,0x0a,0x20,0x20,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,
    0x74,0x69,0x6f,0x6e,0x20,0x3d,0x20,0x76,0x65,0x63,0x34,0x66,0x28,0x78,0x5f,0x32,
    0x30,0x2e,0x78,0x2c,0x20,0x78,0x5f,0x32,0x30,0x2e,0x79,0x2c,0x20,0x30,0x2e,0x30,
    0x66,0x2c,0x20,0x31,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x33,0x30,0x20,0x3a,0x20,0x76,0x65,0x63,0x34,0x66,0x20,0x3d,0x20,0x63,
    0x6f,0x6f,0x72,0x64,0x3b,0x0a,0x20,0x20,0x74,0x65,0x78,0x55,0x56,0x20,0x3d,0x20,
    0x76,0x65,0x63,0x32,0x66,0x28,0x78,0x5f,0x33,0x30,0x2e,0x7a,0x2c,0x20,0x78,0x5f,
    0x33,0x30,0x2e,0x77,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x33,
    0x34,0x20,0x3a,0x20,0x76,0x65,0x63,0x34,0x66,0x20,0x3d,0x20,0x63,0x6f,0x6c,0x6f,
    0x72,0x3b,0x0a,0x20,0x20,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x78,0x5f,
    0x33,0x34,0x3b,0x0a,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x3b,0x0a,0x7d,0x0a,
    0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,0x6d,0x61,0x69,0x6e,0x5f,0x6f,0x75,0x74,
    0x20,0x7b,0x0a,0x20,0x20,0x40,0x62,0x75,0x69,0x6c,0x74,0x69,0x6e,0x28,0x70,0x6f,
    0x73,0x69,0x74,0x69,0x6f,0x6e,0x29,0x0a,0x20,0x20,0x67,0x6c,0x5f,0x50,0x6f,0x73,
    0x69,0x74,0x69,0x6f,0x6e,0x20,0x3a,0x20,0x76,0x65,0x63,0x34,0x66,0x2c,0x0a,0x20,
    0x20,0x40,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x28,0x30,0x29,0x0a,0x20,0x20,
    0x74,0x65,0x78,0x55,0x56,0x5f,0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x2c,
    0x0a,0x20,0x20,0x40,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x28,0x31,0x29,0x0a,
    0x20,0x20,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x5f,0x31,0x20,0x3a,0x20,0x76,0x65,0x63,
    0x34,0x66,0x2c,0x0a,0x7d,0x0a,0x0a,0x40,0x76,0x65,0x72,0x74,0x65,0x78,0x0a,0x66,
    0x6e,0x20,0x6d,0x61,0x69,0x6e,0x28,0x40,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,
    0x28,0x30,0x29,0x20,0x63,0x6f,0x6f,0x72,0x64,0x5f,0x70,0x61,0x72,0x61,0x6d,0x20,
    0x3a,0x20,0x76,0x65,0x63,0x34,0x66,0x2c,0x20,0x40,0x6c,0x6f,0x63,0x61,0x74,0x69,
    0x6f,0x6e,0x28,0x31,0x29,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x5f,0x70,0x61,0x72,0x61,
    0x6d,0x20,0x3a,0x20,0x76,0x65,0x63,0x34,0x66,0x29,0x20,0x2d,0x3e,0x20,0x6d,0x61,
    0x69,0x6e,0x5f,0x6f,0x75,0x74,0x20,0x7b,0x0a,0x20,0x20,0x63,0x6f,0x6f,0x72,0x64,
    0x20,0x3d,0x20,0x63,0x6f,0x6f,0x72,0x64,0x5f,0x70,0x61,0x72,0x61,0x6d,0x3b,0x0a,
    0x20,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x63,0x6f,0x6c,0x6f,0x72,0x5f,
    0x70,0x61,0x72,0x61,0x6d,0x3b,0x0a,0x20,0x20,0x6d,0x61,0x69,0x6e,0x5f,0x31,0x28,
    0x29,0x3b,0x0a,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6d,0x61,0x69,0x6e,
    0x5f,0x6f,0x75,0x74,0x28,0x67,0x6c,0x5f,0x50,0x6f,0x73,0x69,0x74,0x69,0x6f,0x6e,
    0x2c,0x20,0x74,0x65,0x78,0x55,0x56,0x2c,0x20,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x29,
    0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
/*
    diagnostic(off, derivative_uniformity);

    struct fs_uniforms {
      /_ @offset(0) _/
      iVelocity : vec2f,
      /_ @offset(8) _/
      iPressure : f32,
      /_ @offset(12) _/
      iTime : f32,
      /_ @offset(16) _/
      iWarpiness : f32,
      /_ @offset(20) _/
      iRatio : f32,
      /_ @offset(24) _/
      iZoom : f32,
      /_ @offset(28) _/
      iLevel : f32,
    }

    @group(1) @binding(64) var iTexChannel1 : texture_2d<f32>;

    @group(1) @binding(80) var iSmpChannel1 : sampler;

    @group(1) @binding(65) var iTexChannel0 : texture_2d<f32>;

    @group(1) @binding(81) var iSmpChannel0 : sampler;

    var<private> texUV : vec2f;

    @group(0) @binding(8) var<uniform> x_48 : fs_uniforms;

    var<private> iColor : vec4f;

    var<private> fragColor : vec4f;

    fn noise_vf2_(p : ptr<function, vec2f>) -> f32 {
      let x_23 : vec2f = *(p);
      let x_25 : vec4f = textureSample(iTexChannel1, iSmpChannel1, x_23);
      return x_25.x;
    }

    fn main_1() {
      var tex_col : vec3f;
      var fog_uv : vec2f;
      var f : f32;
      var param : vec2f;
      var param_1 : vec2f;
      var col : vec3f;
      let x_41 : vec2f = texUV;
      let x_42 : vec4f = textureSample(iTexChannel0, iSmpChannel0, x_41);
      tex_col = vec3f(x_42.x, x_42.y, x_42.z);
      let x_45 : vec2f = texUV;
      let x_53 : f32 = x_48.iRatio;
      let x_59 : f32 = x_48.iZoom;
      fog_uv = ((x_45 * vec2f(x_53, 1.0f)) * x_59);
      let x_63 : vec2f = fog_uv;
      let x_67 : vec2f = x_48.iVelocity;
      let x_70 : f32 = x_48.iTime;
      param = (x_63 - (x_67 * x_70));
      let x_74 : f32 = noise_vf2_(&(param));
      f = x_74;
      let x_75 : vec2f = fog_uv;
      let x_76 : f32 = f;
      let x_79 : f32 = x_48.iWarpiness;
      let x_80 : f32 = (x_76 * x_79);
      param_1 = (x_75 + vec2f(x_80, x_80));
      let x_84 : f32 = noise_vf2_(&(param_1));
      f = x_84;
      let x_86 : vec3f = tex_col;
      let x_87 : f32 = f;
      let x_91 : vec4f = iColor;
      let x_96 : f32 = x_48.iPressure;
      col = mix(x_86, (vec3f(x_87, x_87, x_87) * vec3f(x_91.x, x_91.y, x_91.z)), vec3f(x_96, x_96, x_96));
      let x_101 : vec3f = col;
      fragColor = vec4f(x_101.x, x_101.y, x_101.z, 1.0f);
      return;
    }

    struct main_out {
      @location(0)
      fragColor_1 : vec4f,
    }

    @fragment
    fn main(@location(0) texUV_param : vec2f, @location(1) iColor_param : vec4f) -> main_out {
      texUV = texUV_param;
      iColor = iColor_param;
      main_1();
      return main_out(fragColor);
    }

*/
static const uint8_t effect_fs_source_wgsl[2247] = {
    0x64,0x69,0x61,0x67,0x6e,0x6f,0x73,0x74,0x69,0x63,0x28,0x6f,0x66,0x66,0x2c,0x20,
    0x64,0x65,0x72,0x69,0x76,0x61,0x74,0x69,0x76,0x65,0x5f,0x75,0x6e,0x69,0x66,0x6f,
    0x72,0x6d,0x69,0x74,0x79,0x29,0x3b,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,
    0x66,0x73,0x5f,0x75,0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x20,0x7b,0x0a,0x20,0x20,
    0x2f,0x2a,0x20,0x40,0x6f,0x66,0x66,0x73,0x65,0x74,0x28,0x30,0x29,0x20,0x2a,0x2f,
    0x0a,0x20,0x20,0x69,0x56,0x65,0x6c,0x6f,0x63,0x69,0x74,0x79,0x20,0x3a,0x20,0x76,
    0x65,0x63,0x32,0x66,0x2c,0x0a,0x20,0x20,0x2f,0x2a,0x20,0x40,0x6f,0x66,0x66,0x73,
    0x65,0x74,0x28,0x38,0x29,0x20,0x2a,0x2f,0x0a,0x20,0x20,0x69,0x50,0x72,0x65,0x73,
    0x73,0x75,0x72,0x65,0x20,0x3a,0x20,0x66,0x33,0x32,0x2c,0x0a,0x20,0x20,0x2f,0x2a,
    0x20,0x40,0x6f,0x66,0x66,0x73,0x65,0x74,0x28,0x31,0x32,0x29,0x20,0x2a,0x2f,0x0a,
    0x20,0x20,0x69,0x54,0x69,0x6d,0x65,0x20,0x3a,0x20,0x66,0x33,0x32,0x2c,0x0a,0x20,
    0x20,0x2f,0x2a,0x20,0x40,0x6f,0x66,0x66,0x73,0x65,0x74,0x28,0x31,0x36,0x29,0x20,
    0x2a,0x2f,0x0a,0x20,0x20,0x69,0x57,0x61,0x72,0x70,0x69,0x6e,0x65,0x73,0x73,0x20,
    0x3a,0x20,0x66,0x33,0x32,0x2c,0x0a,0x20,0x20,0x2f,0x2a,0x20,0x40,0x6f,0x66,0x66,
    0x73,0x65,0x74,0x28,0x32,0x30,0x29,0x20,0x2a,0x2f,0x0a,0x20,0x20,0x69,0x52,0x61,
    0x74,0x69,0x6f,0x20,0x3a,0x20,0x66,0x33,0x32,0x2c,0x0a,0x20,0x20,0x2f,0x2a,0x20,
    0x40,0x6f,0x66,0x66,0x73,0x65,0x74,0x28,0x32,0x34,0x29,0x20,0x2a,0x2f,0x0a,0x20,
    0x20,0x69,0x5a,0x6f,0x6f,0x6d,0x20,0x3a,0x20,0x66,0x33,0x32,0x2c,0x0a,0x20,0x20,
    0x2f,0x2a,0x20,0x40,0x6f,0x66,0x66,0x73,0x65,0x74,0x28,0x32,0x38,0x29,0x20,0x2a,
    0x2f,0x0a,0x20,0x20,0x69,0x4c,0x65,0x76,0x65,0x6c,0x20,0x3a,0x20,0x66,0x33,0x32,
    0x2c,0x0a,0x7d,0x0a,0x0a,0x40,0x67,0x72,0x6f,0x75,0x70,0x28,0x31,0x29,0x20,0x40,
    0x62,0x69,0x6e,0x64,0x69,0x6e,0x67,0x28,0x36,0x34,0x29,0x20,0x76,0x61,0x72,0x20,
    0x69,0x54,0x65,0x78,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x31,0x20,0x3a,0x20,0x74,
    0x65,0x78,0x74,0x75,0x72,0x65,0x5f,0x32,0x64,0x3c,0x66,0x33,0x32,0x3e,0x3b,0x0a,
    0x0a,0x40,0x67,0x72,0x6f,0x75,0x70,0x28,0x31,0x29,0x20,0x40,0x62,0x69,0x6e,0x64,
    0x69,0x6e,0x67,0x28,0x38,0x30,0x29,0x20,0x76,0x61,0x72,0x20,0x69,0x53,0x6d,0x70,
    0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x31,0x20,0x3a,0x20,0x73,0x61,0x6d,0x70,0x6c,
    0x65,0x72,0x3b,0x0a,0x0a,0x40,0x67,0x72,0x6f,0x75,0x70,0x28,0x31,0x29,0x20,0x40,
    0x62,0x69,0x6e,0x64,0x69,0x6e,0x67,0x28,0x36,0x35,0x29,0x20,0x76,0x61,0x72,0x20,
    0x69,0x54,0x65,0x78,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x30,0x20,0x3a,0x20,0x74,
    0x65,0x78,0x74,0x75,0x72,0x65,0x5f,0x32,0x64,0x3c,0x66,0x33,0x32,0x3e,0x3b,0x0a,
    0x0a,0x40,0x67,0x72,0x6f,0x75,0x70,0x28,0x31,0x29,0x20,0x40,0x62,0x69,0x6e,0x64,
    0x69,0x6e,0x67,0x28,0x38,0x31,0x29,0x20,0x76,0x61,0x72,0x20,0x69,0x53,0x6d,0x70,
    0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,0x30,0x20,0x3a,0x20,0x73,0x61,0x6d,0x70,0x6c,
    0x65,0x72,0x3b,0x0a,0x0a,0x76,0x61,0x72,0x3c,0x70,0x72,0x69,0x76,0x61,0x74,0x65,
    0x3e,0x20,0x74,0x65,0x78,0x55,0x56,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,
    0x0a,0x0a,0x40,0x67,0x72,0x6f,0x75,0x70,0x28,0x30,0x29,0x20,0x40,0x62,0x69,0x6e,
    0x64,0x69,0x6e,0x67,0x28,0x38,0x29,0x20,0x76,0x61,0x72,0x3c,0x75,0x6e,0x69,0x66,
    0x6f,0x72,0x6d,0x3e,0x20,0x78,0x5f,0x34,0x38,0x20,0x3a,0x20,0x66,0x73,0x5f,0x75,
    0x6e,0x69,0x66,0x6f,0x72,0x6d,0x73,0x3b,0x0a,0x0a,0x76,0x61,0x72,0x3c,0x70,0x72,
    0x69,0x76,0x61,0x74,0x65,0x3e,0x20,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x20,0x3a,0x20,
    0x76,0x65,0x63,0x34,0x66,0x3b,0x0a,0x0a,0x76,0x61,0x72,0x3c,0x70,0x72,0x69,0x76,
    0x61,0x74,0x65,0x3e,0x20,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,0x72,0x20,0x3a,
    0x20,0x76,0x65,0x63,0x34,0x66,0x3b,0x0a,0x0a,0x66,0x6e,0x20,0x6e,0x6f,0x69,0x73,
    0x65,0x5f,0x76,0x66,0x32,0x5f,0x28,0x70,0x20,0x3a,0x20,0x70,0x74,0x72,0x3c,0x66,
    0x75,0x6e,0x63,0x74,0x69,0x6f,0x6e,0x2c,0x20,0x76,0x65,0x63,0x32,0x66,0x3e,0x29,
    0x20,0x2d,0x3e,0x20,0x66,0x33,0x32,0x20,0x7b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,
    0x78,0x5f,0x32,0x33,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x2a,
    0x28,0x70,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x32,0x35,0x20,
    0x3a,0x20,0x76,0x65,0x63,0x34,0x66,0x20,0x3d,0x20,0x74,0x65,0x78,0x74,0x75,0x72,
    0x65,0x53,0x61,0x6d,0x70,0x6c,0x65,0x28,0x69,0x54,0x65,0x78,0x43,0x68,0x61,0x6e,
    0x6e,0x65,0x6c,0x31,0x2c,0x20,0x69,0x53,0x6d,0x70,0x43,0x68,0x61,0x6e,0x6e,0x65,
    0x6c,0x31,0x2c,0x20,0x78,0x5f,0x32,0x33,0x29,0x3b,0x0a,0x20,0x20,0x72,0x65,0x74,
    0x75,0x72,0x6e,0x20,0x78,0x5f,0x32,0x35,0x2e,0x78,0x3b,0x0a,0x7d,0x0a,0x0a,0x66,
    0x6e,0x20,0x6d,0x61,0x69,0x6e,0x5f,0x31,0x28,0x29,0x20,0x7b,0x0a,0x20,0x20,0x76,
    0x61,0x72,0x20,0x74,0x65,0x78,0x5f,0x63,0x6f,0x6c,0x20,0x3a,0x20,0x76,0x65,0x63,
    0x33,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x66,0x6f,0x67,0x5f,0x75,0x76,
    0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,
    0x66,0x20,0x3a,0x20,0x66,0x33,0x32,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x70,
    0x61,0x72,0x61,0x6d,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,
    0x76,0x61,0x72,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x20,0x3a,0x20,0x76,0x65,
    0x63,0x32,0x66,0x3b,0x0a,0x20,0x20,0x76,0x61,0x72,0x20,0x63,0x6f,0x6c,0x20,0x3a,
    0x20,0x76,0x65,0x63,0x33,0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,
    0x34,0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x74,0x65,0x78,
    0x55,0x56,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x32,0x20,0x3a,
    0x20,0x76,0x65,0x63,0x34,0x66,0x20,0x3d,0x20,0x74,0x65,0x78,0x74,0x75,0x72,0x65,
    0x53,0x61,0x6d,0x70,0x6c,0x65,0x28,0x69,0x54,0x65,0x78,0x43,0x68,0x61,0x6e,0x6e,
    0x65,0x6c,0x30,0x2c,0x20,0x69,0x53,0x6d,0x70,0x43,0x68,0x61,0x6e,0x6e,0x65,0x6c,
    0x30,0x2c,0x20,0x78,0x5f,0x34,0x31,0x29,0x3b,0x0a,0x20,0x20,0x74,0x65,0x78,0x5f,
    0x63,0x6f,0x6c,0x20,0x3d,0x20,0x76,0x65,0x63,0x33,0x66,0x28,0x78,0x5f,0x34,0x32,
    0x2e,0x78,0x2c,0x20,0x78,0x5f,0x34,0x32,0x2e,0x79,0x2c,0x20,0x78,0x5f,0x34,0x32,
    0x2e,0x7a,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x34,0x35,0x20,
    0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x74,0x65,0x78,0x55,0x56,0x3b,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x35,0x33,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x20,0x3d,0x20,0x78,0x5f,0x34,0x38,0x2e,0x69,0x52,0x61,0x74,0x69,0x6f,0x3b,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x35,0x39,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x20,0x3d,0x20,0x78,0x5f,0x34,0x38,0x2e,0x69,0x5a,0x6f,0x6f,0x6d,0x3b,0x0a,
    0x20,0x20,0x66,0x6f,0x67,0x5f,0x75,0x76,0x20,0x3d,0x20,0x28,0x28,0x78,0x5f,0x34,
    0x35,0x20,0x2a,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x78,0x5f,0x35,0x33,0x2c,0x20,
    0x31,0x2e,0x30,0x66,0x29,0x29,0x20,0x2a,0x20,0x78,0x5f,0x35,0x39,0x29,0x3b,0x0a,
    0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x36,0x33,0x20,0x3a,0x20,0x76,0x65,0x63,
    0x32,0x66,0x20,0x3d,0x20,0x66,0x6f,0x67,0x5f,0x75,0x76,0x3b,0x0a,0x20,0x20,0x6c,
    0x65,0x74,0x20,0x78,0x5f,0x36,0x37,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,
    0x3d,0x20,0x78,0x5f,0x34,0x38,0x2e,0x69,0x56,0x65,0x6c,0x6f,0x63,0x69,0x74,0x79,
    0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x37,0x30,0x20,0x3a,0x20,0x66,
    0x33,0x32,0x20,0x3d,0x20,0x78,0x5f,0x34,0x38,0x2e,0x69,0x54,0x69,0x6d,0x65,0x3b,
    0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x20,0x3d,0x20,0x28,0x78,0x5f,0x36,0x33,
    0x20,0x2d,0x20,0x28,0x78,0x5f,0x36,0x37,0x20,0x2a,0x20,0x78,0x5f,0x37,0x30,0x29,
    0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x37,0x34,0x20,0x3a,0x20,
    0x66,0x33,0x32,0x20,0x3d,0x20,0x6e,0x6f,0x69,0x73,0x65,0x5f,0x76,0x66,0x32,0x5f,
    0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x29,0x29,0x3b,0x0a,0x20,0x20,0x66,0x20,
    0x3d,0x20,0x78,0x5f,0x37,0x34,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,
    0x37,0x35,0x20,0x3a,0x20,0x76,0x65,0x63,0x32,0x66,0x20,0x3d,0x20,0x66,0x6f,0x67,
    0x5f,0x75,0x76,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x37,0x36,0x20,
    0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,
    0x20,0x78,0x5f,0x37,0x39,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x78,0x5f,
    0x34,0x38,0x2e,0x69,0x57,0x61,0x72,0x70,0x69,0x6e,0x65,0x73,0x73,0x3b,0x0a,0x20,
    0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x30,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,
    0x3d,0x20,0x28,0x78,0x5f,0x37,0x36,0x20,0x2a,0x20,0x78,0x5f,0x37,0x39,0x29,0x3b,
    0x0a,0x20,0x20,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,0x20,0x3d,0x20,0x28,0x78,0x5f,
    0x37,0x35,0x20,0x2b,0x20,0x76,0x65,0x63,0x32,0x66,0x28,0x78,0x5f,0x38,0x30,0x2c,
    0x20,0x78,0x5f,0x38,0x30,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,
    0x5f,0x38,0x34,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,0x20,0x6e,0x6f,0x69,0x73,
    0x65,0x5f,0x76,0x66,0x32,0x5f,0x28,0x26,0x28,0x70,0x61,0x72,0x61,0x6d,0x5f,0x31,
    0x29,0x29,0x3b,0x0a,0x20,0x20,0x66,0x20,0x3d,0x20,0x78,0x5f,0x38,0x34,0x3b,0x0a,
    0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x36,0x20,0x3a,0x20,0x76,0x65,0x63,
    0x33,0x66,0x20,0x3d,0x20,0x74,0x65,0x78,0x5f,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,
    0x6c,0x65,0x74,0x20,0x78,0x5f,0x38,0x37,0x20,0x3a,0x20,0x66,0x33,0x32,0x20,0x3d,
    0x20,0x66,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x39,0x31,0x20,0x3a,
    0x20,0x76,0x65,0x63,0x34,0x66,0x20,0x3d,0x20,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x3b,
    0x0a,0x20,0x20,0x6c,0x65,0x74,0x20,0x78,0x5f,0x39,0x36,0x20,0x3a,0x20,0x66,0x33,
    0x32,0x20,0x3d,0x20,0x78,0x5f,0x34,0x38,0x2e,0x69,0x50,0x72,0x65,0x73,0x73,0x75,
    0x72,0x65,0x3b,0x0a,0x20,0x20,0x63,0x6f,0x6c,0x20,0x3d,0x20,0x6d,0x69,0x78,0x28,
    0x78,0x5f,0x38,0x36,0x2c,0x20,0x28,0x76,0x65,0x63,0x33,0x66,0x28,0x78,0x5f,0x38,
    0x37,0x2c,0x20,0x78,0x5f,0x38,0x37,0x2c,0x20,0x78,0x5f,0x38,0x37,0x29,0x20,0x2a,
    0x20,0x76,0x65,0x63,0x33,0x66,0x28,0x78,0x5f,0x39,0x31,0x2e,0x78,0x2c,0x20,0x78,
    0x5f,0x39,0x31,0x2e,0x79,0x2c,0x20,0x78,0x5f,0x39,0x31,0x2e,0x7a,0x29,0x29,0x2c,
    0x20,0x76,0x65,0x63,0x33,0x66,0x28,0x78,0x5f,0x39,0x36,0x2c,0x20,0x78,0x5f,0x39,
    0x36,0x2c,0x20,0x78,0x5f,0x39,0x36,0x29,0x29,0x3b,0x0a,0x20,0x20,0x6c,0x65,0x74,
    0x20,0x78,0x5f,0x31,0x30,0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x33,0x66,0x20,0x3d,
    0x20,0x63,0x6f,0x6c,0x3b,0x0a,0x20,0x20,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,
    0x72,0x20,0x3d,0x20,0x76,0x65,0x63,0x34,0x66,0x28,0x78,0x5f,0x31,0x30,0x31,0x2e,
    0x78,0x2c,0x20,0x78,0x5f,0x31,0x30,0x31,0x2e,0x79,0x2c,0x20,0x78,0x5f,0x31,0x30,
    0x31,0x2e,0x7a,0x2c,0x20,0x31,0x2e,0x30,0x66,0x29,0x3b,0x0a,0x20,0x20,0x72,0x65,
    0x74,0x75,0x72,0x6e,0x3b,0x0a,0x7d,0x0a,0x0a,0x73,0x74,0x72,0x75,0x63,0x74,0x20,
    0x6d,0x61,0x69,0x6e,0x5f,0x6f,0x75,0x74,0x20,0x7b,0x0a,0x20,0x20,0x40,0x6c,0x6f,
    0x63,0x61,0x74,0x69,0x6f,0x6e,0x28,0x30,0x29,0x0a,0x20,0x20,0x66,0x72,0x61,0x67,
    0x43,0x6f,0x6c,0x6f,0x72,0x5f,0x31,0x20,0x3a,0x20,0x76,0x65,0x63,0x34,0x66,0x2c,
    0x0a,0x7d,0x0a,0x0a,0x40,0x66,0x72,0x61,0x67,0x6d,0x65,0x6e,0x74,0x0a,0x66,0x6e,
    0x20,0x6d,0x61,0x69,0x6e,0x28,0x40,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,0x6e,0x28,
    0x30,0x29,0x20,0x74,0x65,0x78,0x55,0x56,0x5f,0x70,0x61,0x72,0x61,0x6d,0x20,0x3a,
    0x20,0x76,0x65,0x63,0x32,0x66,0x2c,0x20,0x40,0x6c,0x6f,0x63,0x61,0x74,0x69,0x6f,
    0x6e,0x28,0x31,0x29,0x20,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x5f,0x70,0x61,0x72,0x61,
    0x6d,0x20,0x3a,0x20,0x76,0x65,0x63,0x34,0x66,0x29,0x20,0x2d,0x3e,0x20,0x6d,0x61,
    0x69,0x6e,0x5f,0x6f,0x75,0x74,0x20,0x7b,0x0a,0x20,0x20,0x74,0x65,0x78,0x55,0x56,
    0x20,0x3d,0x20,0x74,0x65,0x78,0x55,0x56,0x5f,0x70,0x61,0x72,0x61,0x6d,0x3b,0x0a,
    0x20,0x20,0x69,0x43,0x6f,0x6c,0x6f,0x72,0x20,0x3d,0x20,0x69,0x43,0x6f,0x6c,0x6f,
    0x72,0x5f,0x70,0x61,0x72,0x61,0x6d,0x3b,0x0a,0x20,0x20,0x6d,0x61,0x69,0x6e,0x5f,
    0x31,0x28,0x29,0x3b,0x0a,0x20,0x20,0x72,0x65,0x74,0x75,0x72,0x6e,0x20,0x6d,0x61,
    0x69,0x6e,0x5f,0x6f,0x75,0x74,0x28,0x66,0x72,0x61,0x67,0x43,0x6f,0x6c,0x6f,0x72,
    0x29,0x3b,0x0a,0x7d,0x0a,0x0a,0x00,
};
const sg_shader_desc* effect_program_shader_desc(sg_backend backend) {
    if (backend == SG_BACKEND_GLCORE) {
        static sg_shader_desc desc;
        static bool valid;
        if (!valid) {
            valid = true;
            desc.vertex_func.source = (const char*)effect_vs_source_glsl410;
            desc.vertex_func.entry = "main";
            desc.fragment_func.source = (const char*)effect_fs_source_glsl410;
            desc.fragment_func.entry = "main";
            desc.attrs[0].glsl_name = "coord";
            desc.attrs[1].glsl_name = "color";
            desc.uniform_blocks[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.uniform_blocks[1].layout = SG_UNIFORMLAYOUT_STD140;
            desc.uniform_blocks[1].size = 32;
            desc.uniform_blocks[1].glsl_uniforms[0].type = SG_UNIFORMTYPE_FLOAT4;
            desc.uniform_blocks[1].glsl_uniforms[0].array_count = 2;
            desc.uniform_blocks[1].glsl_uniforms[0].glsl_name = "fs_uniforms";
            desc.images[0].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.images[0].image_type = SG_IMAGETYPE_2D;
            desc.images[0].sample_type = SG_IMAGESAMPLETYPE_FLOAT;
            desc.images[0].multisampled = false;
            desc.images[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.images[1].image_type = SG_IMAGETYPE_2D;
            desc.images[1].sample_type = SG_IMAGESAMPLETYPE_FLOAT;
            desc.images[1].multisampled = false;
            desc.samplers[0].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.samplers[0].sampler_type = SG_SAMPLERTYPE_FILTERING;
            desc.samplers[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.samplers[1].sampler_type = SG_SAMPLERTYPE_FILTERING;
            desc.image_sampler_pairs[0].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.image_sampler_pairs[0].image_slot = 0;
            desc.image_sampler_pairs[0].sampler_slot = 0;
            desc.image_sampler_pairs[0].glsl_name = "iTexChannel0_iSmpChannel0";
            desc.image_sampler_pairs[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.image_sampler_pairs[1].image_slot = 1;
            desc.image_sampler_pairs[1].sampler_slot = 1;
            desc.image_sampler_pairs[1].glsl_name = "iTexChannel1_iSmpChannel1";
            desc.label = "effect_program_shader";
        }
        return &desc;
    }
    if (backend == SG_BACKEND_GLES3) {
        static sg_shader_desc desc;
        static bool valid;
        if (!valid) {
            valid = true;
            desc.vertex_func.source = (const char*)effect_vs_source_glsl300es;
            desc.vertex_func.entry = "main";
            desc.fragment_func.source = (const char*)effect_fs_source_glsl300es;
            desc.fragment_func.entry = "main";
            desc.attrs[0].glsl_name = "coord";
            desc.attrs[1].glsl_name = "color";
            desc.uniform_blocks[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.uniform_blocks[1].layout = SG_UNIFORMLAYOUT_STD140;
            desc.uniform_blocks[1].size = 32;
            desc.uniform_blocks[1].glsl_uniforms[0].type = SG_UNIFORMTYPE_FLOAT4;
            desc.uniform_blocks[1].glsl_uniforms[0].array_count = 2;
            desc.uniform_blocks[1].glsl_uniforms[0].glsl_name = "fs_uniforms";
            desc.images[0].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.images[0].image_type = SG_IMAGETYPE_2D;
            desc.images[0].sample_type = SG_IMAGESAMPLETYPE_FLOAT;
            desc.images[0].multisampled = false;
            desc.images[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.images[1].image_type = SG_IMAGETYPE_2D;
            desc.images[1].sample_type = SG_IMAGESAMPLETYPE_FLOAT;
            desc.images[1].multisampled = false;
            desc.samplers[0].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.samplers[0].sampler_type = SG_SAMPLERTYPE_FILTERING;
            desc.samplers[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.samplers[1].sampler_type = SG_SAMPLERTYPE_FILTERING;
            desc.image_sampler_pairs[0].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.image_sampler_pairs[0].image_slot = 0;
            desc.image_sampler_pairs[0].sampler_slot = 0;
            desc.image_sampler_pairs[0].glsl_name = "iTexChannel0_iSmpChannel0";
            desc.image_sampler_pairs[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.image_sampler_pairs[1].image_slot = 1;
            desc.image_sampler_pairs[1].sampler_slot = 1;
            desc.image_sampler_pairs[1].glsl_name = "iTexChannel1_iSmpChannel1";
            desc.label = "effect_program_shader";
        }
        return &desc;
    }
    if (backend == SG_BACKEND_D3D11) {
        static sg_shader_desc desc;
        static bool valid;
        if (!valid) {
            valid = true;
            desc.vertex_func.source = (const char*)effect_vs_source_hlsl4;
            desc.vertex_func.d3d11_target = "vs_4_0";
            desc.vertex_func.entry = "main";
            desc.fragment_func.source = (const char*)effect_fs_source_hlsl4;
            desc.fragment_func.d3d11_target = "ps_4_0";
            desc.fragment_func.entry = "main";
            desc.attrs[0].hlsl_sem_name = "TEXCOORD";
            desc.attrs[0].hlsl_sem_index = 0;
            desc.attrs[1].hlsl_sem_name = "TEXCOORD";
            desc.attrs[1].hlsl_sem_index = 1;
            desc.uniform_blocks[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.uniform_blocks[1].layout = SG_UNIFORMLAYOUT_STD140;
            desc.uniform_blocks[1].size = 32;
            desc.uniform_blocks[1].hlsl_register_b_n = 0;
            desc.images[0].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.images[0].image_type = SG_IMAGETYPE_2D;
            desc.images[0].sample_type = SG_IMAGESAMPLETYPE_FLOAT;
            desc.images[0].multisampled = false;
            desc.images[0].hlsl_register_t_n = 1;
            desc.images[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.images[1].image_type = SG_IMAGETYPE_2D;
            desc.images[1].sample_type = SG_IMAGESAMPLETYPE_FLOAT;
            desc.images[1].multisampled = false;
            desc.images[1].hlsl_register_t_n = 0;
            desc.samplers[0].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.samplers[0].sampler_type = SG_SAMPLERTYPE_FILTERING;
            desc.samplers[0].hlsl_register_s_n = 1;
            desc.samplers[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.samplers[1].sampler_type = SG_SAMPLERTYPE_FILTERING;
            desc.samplers[1].hlsl_register_s_n = 0;
            desc.image_sampler_pairs[0].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.image_sampler_pairs[0].image_slot = 0;
            desc.image_sampler_pairs[0].sampler_slot = 0;
            desc.image_sampler_pairs[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.image_sampler_pairs[1].image_slot = 1;
            desc.image_sampler_pairs[1].sampler_slot = 1;
            desc.label = "effect_program_shader";
        }
        return &desc;
    }
    if (backend == SG_BACKEND_METAL_MACOS) {
        static sg_shader_desc desc;
        static bool valid;
        if (!valid) {
            valid = true;
            desc.vertex_func.source = (const char*)effect_vs_source_metal_macos;
            desc.vertex_func.entry = "main0";
            desc.fragment_func.source = (const char*)effect_fs_source_metal_macos;
            desc.fragment_func.entry = "main0";
            desc.uniform_blocks[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.uniform_blocks[1].layout = SG_UNIFORMLAYOUT_STD140;
            desc.uniform_blocks[1].size = 32;
            desc.uniform_blocks[1].msl_buffer_n = 0;
            desc.images[0].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.images[0].image_type = SG_IMAGETYPE_2D;
            desc.images[0].sample_type = SG_IMAGESAMPLETYPE_FLOAT;
            desc.images[0].multisampled = false;
            desc.images[0].msl_texture_n = 1;
            desc.images[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.images[1].image_type = SG_IMAGETYPE_2D;
            desc.images[1].sample_type = SG_IMAGESAMPLETYPE_FLOAT;
            desc.images[1].multisampled = false;
            desc.images[1].msl_texture_n = 0;
            desc.samplers[0].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.samplers[0].sampler_type = SG_SAMPLERTYPE_FILTERING;
            desc.samplers[0].msl_sampler_n = 1;
            desc.samplers[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.samplers[1].sampler_type = SG_SAMPLERTYPE_FILTERING;
            desc.samplers[1].msl_sampler_n = 0;
            desc.image_sampler_pairs[0].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.image_sampler_pairs[0].image_slot = 0;
            desc.image_sampler_pairs[0].sampler_slot = 0;
            desc.image_sampler_pairs[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.image_sampler_pairs[1].image_slot = 1;
            desc.image_sampler_pairs[1].sampler_slot = 1;
            desc.label = "effect_program_shader";
        }
        return &desc;
    }
    if (backend == SG_BACKEND_METAL_IOS) {
        static sg_shader_desc desc;
        static bool valid;
        if (!valid) {
            valid = true;
            desc.vertex_func.source = (const char*)effect_vs_source_metal_ios;
            desc.vertex_func.entry = "main0";
            desc.fragment_func.source = (const char*)effect_fs_source_metal_ios;
            desc.fragment_func.entry = "main0";
            desc.uniform_blocks[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.uniform_blocks[1].layout = SG_UNIFORMLAYOUT_STD140;
            desc.uniform_blocks[1].size = 32;
            desc.uniform_blocks[1].msl_buffer_n = 0;
            desc.images[0].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.images[0].image_type = SG_IMAGETYPE_2D;
            desc.images[0].sample_type = SG_IMAGESAMPLETYPE_FLOAT;
            desc.images[0].multisampled = false;
            desc.images[0].msl_texture_n = 1;
            desc.images[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.images[1].image_type = SG_IMAGETYPE_2D;
            desc.images[1].sample_type = SG_IMAGESAMPLETYPE_FLOAT;
            desc.images[1].multisampled = false;
            desc.images[1].msl_texture_n = 0;
            desc.samplers[0].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.samplers[0].sampler_type = SG_SAMPLERTYPE_FILTERING;
            desc.samplers[0].msl_sampler_n = 1;
            desc.samplers[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.samplers[1].sampler_type = SG_SAMPLERTYPE_FILTERING;
            desc.samplers[1].msl_sampler_n = 0;
            desc.image_sampler_pairs[0].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.image_sampler_pairs[0].image_slot = 0;
            desc.image_sampler_pairs[0].sampler_slot = 0;
            desc.image_sampler_pairs[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.image_sampler_pairs[1].image_slot = 1;
            desc.image_sampler_pairs[1].sampler_slot = 1;
            desc.label = "effect_program_shader";
        }
        return &desc;
    }
    if (backend == SG_BACKEND_WGPU) {
        static sg_shader_desc desc;
        static bool valid;
        if (!valid) {
            valid = true;
            desc.vertex_func.source = (const char*)effect_vs_source_wgsl;
            desc.vertex_func.entry = "main";
            desc.fragment_func.source = (const char*)effect_fs_source_wgsl;
            desc.fragment_func.entry = "main";
            desc.uniform_blocks[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.uniform_blocks[1].layout = SG_UNIFORMLAYOUT_STD140;
            desc.uniform_blocks[1].size = 32;
            desc.uniform_blocks[1].wgsl_group0_binding_n = 8;
            desc.images[0].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.images[0].image_type = SG_IMAGETYPE_2D;
            desc.images[0].sample_type = SG_IMAGESAMPLETYPE_FLOAT;
            desc.images[0].multisampled = false;
            desc.images[0].wgsl_group1_binding_n = 65;
            desc.images[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.images[1].image_type = SG_IMAGETYPE_2D;
            desc.images[1].sample_type = SG_IMAGESAMPLETYPE_FLOAT;
            desc.images[1].multisampled = false;
            desc.images[1].wgsl_group1_binding_n = 64;
            desc.samplers[0].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.samplers[0].sampler_type = SG_SAMPLERTYPE_FILTERING;
            desc.samplers[0].wgsl_group1_binding_n = 81;
            desc.samplers[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.samplers[1].sampler_type = SG_SAMPLERTYPE_FILTERING;
            desc.samplers[1].wgsl_group1_binding_n = 80;
            desc.image_sampler_pairs[0].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.image_sampler_pairs[0].image_slot = 0;
            desc.image_sampler_pairs[0].sampler_slot = 0;
            desc.image_sampler_pairs[1].stage = SG_SHADERSTAGE_FRAGMENT;
            desc.image_sampler_pairs[1].image_slot = 1;
            desc.image_sampler_pairs[1].sampler_slot = 1;
            desc.label = "effect_program_shader";
        }
        return &desc;
    }
    return 0;
}
#endif // SOKOL_SHDC_IMPL