## Contributing to Nelua

Hello contributors! Welcome to Nelua!

Do you enjoy Nelua and want to contribute? Nice! You can help with the following points:

- Documentation - Can you write or improve the documentation?
- Tutorials - Can you write a tutorial?
- Examples - Can you share something cool made with Nelua?
- Testing - Can you find bugs?
- Support - Can you help newcomers?

### Opening new Issues

To open new issue for Nelua (bug or enhancement), just try to follow these rules:

- If you need support, have questions, ideas to discuss you should use the [Nelua Discussions](https://github.com/edubart/nelua-lang/discussions) forum or the [Nelua Discord server](https://discord.gg/7aaGeG7) instead of opening a new issue.
- Make sure you test the issue on the latest master branch.
- Make sure the issue has not already been reported before by searching on GitHub under issues.
- Make sure you are not misusing Nelua.
- Be sure to include a title, a clear description, expected behavior, relevant information, and a code sample demonstrating the unexpected behavior.

### Sending a Pull Request

Nelua is open source,
but not very open to contributions in the form of pull requests,
if you would like something fixed or implemented in the core language
try first submitting a bug report or opening a discussion instead of doing a PR.
The authors prefer it this way, so that the ideal solution is always provided,
without unwanted consequences on the project, thus keeping the quality of the software.

If you insist doing a PR, typically for a small bug fix, then follow these guidelines:

- Make sure the PR description clearly describes the problem and solution. Include the relevant issue number if applicable.
- Don't send big pull requests (lots of changes), they are difficult to review. It's better to send small pull requests, one at a time.
- Use different pull requests for different issues, each pull request should only address one issue.
- When fixing a bug or adding a feature add tests related to your changes to assure the changes will always work as intended in the future and also to cover new lines added.
- Verify that changes don't break the tests.
- Don't change the code style, follow the same coding style rules as the code base.
- Pull requests just doing style changes are not welcome, a PR must address a real issue.
