# 安全政策

## 支持版本

我们目前的安全缺陷修正覆盖如下的内容：

| 版本 | 支持          |
| ------- | ------------------ |
| dev分支 | :white_check_mark: |
| 1.0.x   | :white_check_mark: |

## 汇报安全缺陷

### 汇报渠道

因为本服务器可能会部署在公网服务器上，所以请汇报安全缺陷的时候遵照如下的流程：

1. 如果安全缺陷仅存在于dev分支，可以直接在issue中进行汇报。
2. 如果安全缺陷存在于某一个已发布版本，请首先使用邮件汇报。联系作者 qingsongdu2002@qq.com 或管理者 hypergraphuniverse@outlook.com。

如果不愿意进行代码历史追踪，或难以定位安全缺陷产生的时刻，请一律按照2进行不公开汇报，以免漏洞被公开利用。

### 汇报方法

对于安全缺陷的汇报，请尽量附带以下的一些信息，以协助我们进行修复和讨论：

1. 安全缺陷的类型（各种类型的代码注入？逻辑漏洞？）
2. 安全缺陷的复现方法，最好是一个可行的进攻手段。
3. 安全缺陷的表现形式。在描述了2以后，请务必进行如下的对比描述：
   - 当前代码的表现（有缺陷的表现）
   - 安全的表现
4. 可能的修补建议。

### 响应政策

本项目为使用MIT证书发布开源无盈利项目，因此本代码从原则上对于代码的安全性没有保证和修复的义务。当然，我们会主动且尽全完善代码的安全性。在您汇报了安全缺陷之后，响应政策如下：

1. 我们会明确对你的邮件回复“我们已接收到安全缺陷汇报”的回执。若你的邮件未得到作者或管理员的收件回复，可能邮件并未送达邮箱，或作者/管理员当前较忙。在明确收到了表示的回执之前，请尝试联系不同的人。
2. 在收件回复的14日后，我们会回复下一份回执。其主要表示了我们的三种响应策略：
   - 接受：我们认可这个现象是安全缺陷。
   - 延迟：我们难以确定这是否为安全缺陷，或难以确定是否为我们能力范围内可以修复的安全缺陷。
   - 拒绝：我们认为这个内容不是安全缺陷，或认为这是一个广泛存在、难以利用的安全缺陷。
3. 在您已经汇报后，您很可能会被邀请作为改进讨论的参与方加入。
4. 安全缺陷修复以后，无论我们是否公开披露安全问题的细节，我们会再次联系您。

<del>（若上述流程没法跑完，看看是不是作者已经跑路了，或者是不是确实作者太忙了）</del>

 
