import { Sandbox } from 'e2b'

// 1. Start the playground sandbox
const sandbox = await Sandbox.create({
  // You can pass your own sandbox template id
  template: 'base',
  apiKey: process.env.E2B_API_KEY,
})

// 2. Save the LLM-generated code inside the playground
const llmGeneratedCode = 'print("This code was generated by LLM")'
await sandbox.filesystem.write('/main.py', llmGeneratedCode)

// 3. Start the execution of the JavaScript file we saved
const proc = await sandbox.process.start({
  // $HighlightLine
  cmd: 'python /main.py', // $HighlightLine
  // 4. Stream stdout, stderr
  onStdout: (data) => console.log(data.line), // $HighlightLine
  onStderr: (data) => console.log(data.line), // $HighlightLine
}) // $HighlightLine

// 4. Wait for the process to finish
await proc.wait()

// 5. Or you can access output after the process has finished
const output = proc.output

await sandbox.close()
