/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp.config;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import ru.dz.mqtt_udp.IPacket;
import ru.dz.mqtt_udp.IPacketMultiSource;
import ru.dz.mqtt_udp.MqttProtocolException;
import ru.dz.mqtt_udp.PacketSourceMultiServer;
import ru.dz.mqtt_udp.PublishPacket;
import ru.dz.mqtt_udp.SubscribePacket;
import ru.dz.mqtt_udp.TopicFilter;
import ru.dz.mqtt_udp.config.ConfigurableHost;
import ru.dz.mqtt_udp.config.ConfigurableParameter;
import ru.dz.mqtt_udp.io.IPacketAddress;
import ru.dz.mqtt_udp.util.LoopRunner;

public class Controller
implements Consumer<IPacket> {
    private static final String SYS_CONF_WILD = "$SYS/conf/#";
    private LoopRunner lr = new LoopRunner(""){

        @Override
        protected void step() throws IOException, MqttProtocolException {
            new SubscribePacket(Controller.SYS_CONF_WILD).send();
            this.sleep(30000L);
        }

        @Override
        protected void onStop() throws IOException, MqttProtocolException {
        }

        @Override
        protected void onStart() throws IOException, MqttProtocolException {
        }
    };
    private TopicFilter rf = new TopicFilter("$SYS/conf/#");
    private Consumer<ConfigurableHost> newHostListener;
    private Map<String, ConfigurableHost> hosts = new HashMap<String, ConfigurableHost>();
    private Consumer<ConfigurableParameter> newParameterListener;

    public Controller(IPacketMultiSource ms) {
        ms.addPacketSink(this);
        this.lr.requestStart();
    }

    public void requestStart() {
        this.lr.requestStart();
    }

    @Override
    public void accept(IPacket t) {
        String[] parts;
        if (!(t instanceof PublishPacket)) {
            return;
        }
        PublishPacket pp = (PublishPacket)t;
        String topic = pp.getTopic();
        String value = pp.getValueString();
        if (!this.rf.test(topic)) {
            return;
        }
        String suffix = topic.substring("$SYS/conf".length());
        if (suffix.charAt(0) == '/') {
            suffix = suffix.substring(1);
        }
        if ((parts = suffix.split("/")).length < 3) {
            System.out.println("suffix has < 3 parts");
        }
        String host = parts[0];
        String kind = parts[1];
        String name = parts[2];
        ConfigurableHost ch = this.addHost(host, pp.getFrom());
        ConfigurableParameter cp = new ConfigurableParameter(ch, kind, name, value);
        this.addParameter(cp);
    }

    private ConfigurableHost addHost(String host, IPacketAddress src) {
        boolean newone;
        ConfigurableHost ch = new ConfigurableHost(host, src);
        ConfigurableHost old = this.hosts.get(host);
        if (ch.isSameAs(old)) {
            return old;
        }
        this.hosts.put(host, ch);
        boolean bl = newone = old == null;
        if (newone) {
            System.out.println("new host " + ch);
            if (this.newHostListener != null) {
                this.newHostListener.accept(ch);
            }
        } else {
            System.out.println("update host " + old + " to " + ch);
        }
        return ch;
    }

    private void addParameter(ConfigurableParameter cp) {
        if (this.newParameterListener != null) {
            this.newParameterListener.accept(cp);
        }
    }

    public void setNewHostListener(Consumer<ConfigurableHost> sink) {
        this.newHostListener = sink;
    }

    public void setNewParameterListener(Consumer<ConfigurableParameter> sink) {
        this.newParameterListener = sink;
    }

    public static void main(String[] args) {
        PacketSourceMultiServer ms = new PacketSourceMultiServer();
        Controller rc = new Controller(ms);
        ms.requestStart();
        rc.requestStart();
    }
}

