/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp.config;

import java.io.IOException;
import ru.dz.mqtt_udp.PublishPacket;
import ru.dz.mqtt_udp.SubscribePacket;
import ru.dz.mqtt_udp.config.ConfigurableHost;
import ru.dz.mqtt_udp.util.ErrorType;
import ru.dz.mqtt_udp.util.GlobalErrorHandler;

public class ConfigurableParameter
implements Comparable<ConfigurableParameter> {
    private final ConfigurableHost host;
    private final String kind;
    private final String name;
    private String value;

    public ConfigurableParameter(ConfigurableHost host, String kind, String name, String value) {
        this.host = host;
        this.kind = kind;
        this.name = name;
        this.value = value;
    }

    public String toString() {
        return String.format("%s: %s '%s'='%s'", this.host, this.kind, this.name, this.value);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConfigurableParameter)) {
            return false;
        }
        ConfigurableParameter cp = (ConfigurableParameter)obj;
        return cp.host.equals(this.host) && cp.kind.equals(this.kind) && cp.name.equals(this.name);
    }

    public int hashCode() {
        return this.host.hashCode() + this.kind.hashCode() + this.name.hashCode();
    }

    @Override
    public int compareTo(ConfigurableParameter cp) {
        if (cp == null) {
            return 1;
        }
        int cmp = this.host.compareTo(cp.host);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.kind.compareTo(cp.kind);
        if (cmp != 0) {
            return cmp;
        }
        cmp = this.name.compareTo(cp.name);
        return cmp;
    }

    public ConfigurableHost getConfigurableHost() {
        return this.host;
    }

    public String getKind() {
        return this.kind;
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public void sendNewValue(String v) {
        this.value = v;
        String topic = this.makeTopicName();
        System.out.println("send " + topic + "=" + v);
        try {
            new PublishPacket(topic, this.value).send();
        }
        catch (IOException e) {
            GlobalErrorHandler.handleError(ErrorType.IO, e);
        }
    }

    public void requestAgain() {
        String topic = this.makeTopicName();
        System.out.println("request " + topic);
        try {
            new SubscribePacket(topic).send();
        }
        catch (IOException e) {
            GlobalErrorHandler.handleError(ErrorType.IO, e);
        }
    }

    public String makeTopicName() {
        String topic = String.format("%s/%s/%s/%s", "$SYS/conf", this.host.getMacAddressString(), this.kind, this.name);
        return topic;
    }
}

