/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp.config;

import ru.dz.mqtt_udp.io.IPacketAddress;

public class ConfigurableHost
implements Comparable<ConfigurableHost> {
    private String ident;
    private IPacketAddress src;

    public ConfigurableHost(String ident, IPacketAddress src) {
        this.ident = ident;
        this.src = src;
    }

    public int hashCode() {
        return this.ident.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConfigurableHost)) {
            return false;
        }
        ConfigurableHost b = (ConfigurableHost)obj;
        return b.ident.equals(this.ident);
    }

    @Override
    public int compareTo(ConfigurableHost b) {
        return this.ident.compareTo(b.ident);
    }

    public boolean isSameAs(ConfigurableHost ch) {
        if (ch == null) {
            return false;
        }
        if (!this.ident.equals(ch.ident)) {
            return false;
        }
        String ipa = this.src.getInetAddress().getHostAddress();
        String ipb = ch.src.getInetAddress().getHostAddress();
        return ipa.equals(ipb);
    }

    public String toString() {
        return String.format("%s@%s", this.ident, this.src.getInetAddress().getHostAddress());
    }

    public String getMacAddressString() {
        return this.ident;
    }

    public String getIpAddressString() {
        return this.src.getInetAddress().toString();
    }
}

