/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp;

import java.io.IOException;
import java.net.DatagramSocket;
import ru.dz.mqtt_udp.IPacket;
import ru.dz.mqtt_udp.MqttProtocolException;
import ru.dz.mqtt_udp.PingReqPacket;
import ru.dz.mqtt_udp.PingRespPacket;
import ru.dz.mqtt_udp.io.SingleSendSocket;
import ru.dz.mqtt_udp.util.GenericPacket;

public abstract class SubServer {
    private DatagramSocket ss = SingleSendSocket.get();
    private boolean muted = false;
    private volatile boolean run = false;

    public boolean isMuted() {
        return this.muted;
    }

    public void setMuted(boolean muted) {
        this.muted = muted;
    }

    public boolean isRunning() {
        return this.run;
    }

    public void requestStart() {
        if (this.isRunning()) {
            return;
        }
        this.start();
    }

    public void requestStop() {
        this.run = false;
    }

    protected void start() {
        Runnable target = this.makeLoopRunnable();
        Thread t = new Thread(target, "MQTT UDP Recv");
        t.start();
    }

    private void loop() throws IOException, MqttProtocolException {
        DatagramSocket s = GenericPacket.recvSocket();
        this.run = true;
        while (this.run) {
            IPacket p = GenericPacket.recv(s);
            if (!this.muted) {
                this.preprocessPacket(p);
            }
            this.processPacket(p);
        }
        s.close();
    }

    private Runnable makeLoopRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    SubServer.this.loop();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (MqttProtocolException e) {
                    e.printStackTrace();
                }
            }
        };
    }

    protected abstract void processPacket(IPacket var1) throws IOException;

    private void preprocessPacket(IPacket p) throws IOException {
        if (p instanceof PingReqPacket) {
            PingRespPacket presp = new PingRespPacket();
            presp.send(this.ss);
        }
    }
}

