/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt.viewer;

import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.TableCell;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import ru.dz.mqtt.viewer.TableButtonsState;
import ru.dz.mqtt.viewer.TopicTable;
import ru.dz.mqtt.viewer.TopicTableItem;
import ru.dz.mqtt_udp.util.image.ImageUtils;

public class TopicTableButtonCell
extends TableCell<TopicTableItem, TableButtonsState> {
    private HBox hb = new HBox();
    private ToggleButton hostButton;
    private TableButtonsState tableButtonsState = null;
    private final ImageView keysIcon = ImageUtils.getIcon("keys");
    private final ImageView keyIcon = ImageUtils.getIcon("key");

    TopicTableButtonCell(final TopicTable topicTable) {
        this.makeButton(ImageUtils.getIcon("options"), "Send to network", new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                topicTable.sendRecord(TopicTableButtonCell.this.getIndex(), TopicTableButtonCell.this.tableButtonsState.isLimitSendToHost());
            }
        });
        this.makeButton(ImageUtils.getIcon("order"), "Request from network", new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                topicTable.sendRequest(TopicTableButtonCell.this.getIndex(), TopicTableButtonCell.this.tableButtonsState.isLimitSendToHost());
            }
        });
        this.hostButton = this.makeToggleButton(this.keysIcon, "Send to one host only", new EventHandler<ActionEvent>(){

            public void handle(ActionEvent t) {
                TopicTableButtonCell.this.setLimitSendToHost();
            }
        });
    }

    protected void setLimitSendToHost() {
        if (this.tableButtonsState != null) {
            this.tableButtonsState.setLimitSendToHost(this.hostButton.isSelected());
            this.setKeysIcon();
        }
    }

    protected void getLimitSendToHost() {
        if (this.tableButtonsState != null) {
            this.hostButton.setSelected(this.tableButtonsState.isLimitSendToHost());
            this.setKeysIcon();
        }
    }

    public void setKeysIcon() {
        this.hostButton.setGraphic((Node)(this.hostButton.isSelected() ? this.keyIcon : this.keysIcon));
    }

    private void makeButton(ImageView icon, String toolTip, EventHandler<ActionEvent> handler) {
        Button cellButton = new Button();
        cellButton.setGraphic((Node)icon);
        cellButton.setTooltip(new Tooltip(toolTip));
        cellButton.setOnAction(handler);
        this.hb.getChildren().add((Object)cellButton);
    }

    private ToggleButton makeToggleButton(ImageView icon, String toolTip, EventHandler<ActionEvent> handler) {
        ToggleButton cellButton = new ToggleButton();
        cellButton.setGraphic((Node)icon);
        cellButton.setTooltip(new Tooltip(toolTip));
        cellButton.setOnAction(handler);
        this.hb.getChildren().add((Object)cellButton);
        return cellButton;
    }

    protected void updateItem(TableButtonsState t, boolean empty) {
        this.tableButtonsState = t;
        super.updateItem((Object)t, empty);
        if (empty) {
            this.setGraphic(null);
        } else {
            this.setGraphic((Node)this.hb);
            this.getLimitSendToHost();
        }
    }
}

