/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt.viewer;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import ru.dz.mqtt.viewer.RemoteConfigTab;
import ru.dz.mqtt_udp.IPacket;
import ru.dz.mqtt_udp.PacketSourceMultiServer;
import ru.dz.mqtt_udp.config.ConfigurableHost;
import ru.dz.mqtt_udp.config.ConfigurableParameter;
import ru.dz.mqtt_udp.config.Controller;
import ru.dz.mqtt_udp.util.image.ImageUtils;

public class RemoteConfigWindow {
    private Controller rc;
    private Stage rcWindow = new Stage();
    private boolean autoSend = false;
    private final Map<ConfigurableHost, RemoteConfigTab> tabs = new HashMap<ConfigurableHost, RemoteConfigTab>();
    private TabPane tabPane = new TabPane();
    private static final Image windowIcon = ImageUtils.getImage("surveys256.png");
    private static final ImageView lockedIcon = ImageUtils.getIcon32("locked");
    private static final ImageView unlockedIcon = ImageUtils.getIcon32("unlocked");
    private static final ImageView sendAllIcon = ImageUtils.getIcon32("options");

    public RemoteConfigWindow() {
        PacketSourceMultiServer ms = new PacketSourceMultiServer();
        this.rc = new Controller(ms);
        this.rc.setNewHostListener(ch -> this.createTab((ConfigurableHost)ch));
        this.rc.setNewParameterListener(cp -> this.addParameter((ConfigurableParameter)cp));
        ms.addPacketSink(pkt -> this.forAllTabs(tab -> tab.processPacket((IPacket)pkt)));
        this.openWindow();
        ms.requestStart();
        this.rc.requestStart();
        this.forAllTabs(tab -> tab.afterNetStart());
    }

    public void setVisible(boolean is) {
        if (is) {
            this.rcWindow.show();
        } else {
            this.rcWindow.hide();
        }
    }

    public boolean isVisible() {
        return this.rcWindow.isShowing();
    }

    private void openWindow() {
        VBox vbox = new VBox(new Node[]{this.makeToolBar(), this.tabPane});
        vbox.setFillWidth(true);
        VBox.setVgrow((Node)this.tabPane, (Priority)Priority.ALWAYS);
        Scene rcScene = new Scene((Parent)vbox, 800.0, 500.0);
        this.rcWindow.setTitle("Remote Config");
        this.rcWindow.setScene(rcScene);
        this.rcWindow.setMinWidth(500.0);
        this.rcWindow.getIcons().add((Object)windowIcon);
    }

    private HBox makeToolBar() {
        Button sendAllButton = new Button();
        sendAllButton.setTooltip(new Tooltip("Send all settings"));
        sendAllButton.setGraphic((Node)sendAllIcon);
        sendAllButton.setOnAction(e -> this.currentTab().ifPresent(t -> t.sendAll()));
        Button requestAllButton = new Button();
        requestAllButton.setTooltip(new Tooltip("Request all settings"));
        requestAllButton.setGraphic((Node)ImageUtils.getIcon32("order"));
        requestAllButton.setOnAction(e -> this.currentTab().ifPresent(t -> t.requestAll()));
        ToggleButton refreshListButton = new ToggleButton();
        refreshListButton.setTooltip(new Tooltip("Enable automatic value refresh"));
        refreshListButton.setGraphic((Node)unlockedIcon);
        refreshListButton.setOnAction(e -> {});
        refreshListButton.setDisable(true);
        ToggleButton refreshValueButton = new ToggleButton();
        refreshValueButton.setTooltip(new Tooltip("Enable automatic value send"));
        refreshValueButton.setGraphic((Node)ImageUtils.getIcon32("refresh"));
        refreshValueButton.setOnAction(e -> {
            boolean bl = this.autoSend = refreshValueButton.isSelected();
        });
        ToolBar leftTb = new ToolBar();
        leftTb.getItems().addAll((Object[])new Node[]{sendAllButton, requestAllButton});
        ToolBar rightTb = new ToolBar();
        rightTb.getItems().addAll((Object[])new Node[]{refreshListButton, refreshValueButton});
        Region spacer = new Region();
        spacer.getStyleClass().add((Object)"menu-bar");
        HBox.setHgrow((Node)spacer, (Priority)Priority.SOMETIMES);
        HBox hbox = new HBox(new Node[]{leftTb, spacer, rightTb});
        return hbox;
    }

    public Optional<RemoteConfigTab> currentTab() {
        Tab tab = (Tab)this.tabPane.getSelectionModel().getSelectedItem();
        if (tab instanceof RemoteConfigTab) {
            return Optional.ofNullable((RemoteConfigTab)tab);
        }
        return Optional.empty();
    }

    private void forAllTabs(Consumer<RemoteConfigTab> action) {
        this.tabPane.getTabs().forEach(t -> action.accept((RemoteConfigTab)((Object)t)));
    }

    private void createTab(ConfigurableHost ch) {
        RemoteConfigTab oldTab = this.tabs.get(ch);
        if (oldTab != null) {
            oldTab.updateFromHost(ch);
            return;
        }
        final RemoteConfigTab tab = new RemoteConfigTab(ch, this);
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                RemoteConfigWindow.this.tabPane.getTabs().add((Object)tab);
            }
        });
        this.tabs.put(ch, tab);
    }

    private void addParameter(ConfigurableParameter cp) {
        ConfigurableHost ch = cp.getConfigurableHost();
        RemoteConfigTab tab = this.tabs.get(ch);
        if (tab == null) {
            System.err.println("no tab");
            return;
        }
        tab.addParameter(cp);
    }

    public boolean isAutoSend() {
        return this.autoSend;
    }
}

