/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt.viewer;

import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.layout.VBox;
import ru.dz.mqtt.viewer.RemoteConfigControl;
import ru.dz.mqtt.viewer.RemoteConfigWindow;
import ru.dz.mqtt_udp.IPacket;
import ru.dz.mqtt_udp.config.ConfigurableHost;
import ru.dz.mqtt_udp.config.ConfigurableParameter;

public class RemoteConfigTab
extends Tab {
    private RemoteConfigWindow rcw;
    private ConfigurableHost ch;
    private Map<ConfigurableParameter, RemoteConfigControl> controls = new HashMap<ConfigurableParameter, RemoteConfigControl>();

    public RemoteConfigTab(ConfigurableHost ch, RemoteConfigWindow rcw) {
        this.ch = ch;
        this.rcw = rcw;
        this.setText(ch.getMacAddressString());
        this.setClosable(false);
        VBox vbox = new VBox(8.0);
        vbox.setStyle("-fx-padding: 10;-fx-border-style: solid inside;-fx-border-width: 2;-fx-border-insets: 5;-fx-border-color: lightgrey;");
        vbox.getChildren().add((Object)new Label(this.getTabDescription(ch)));
        this.setContent((Node)vbox);
    }

    public String getTabDescription(ConfigurableHost ch) {
        return "  MAC: " + ch.getMacAddressString() + "   IP: " + ch.getIpAddressString();
    }

    public void updateFromHost(ConfigurableHost newCh) {
    }

    public void addParameter(final ConfigurableParameter cp) {
        final VBox vbox = (VBox)this.getContent();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                RemoteConfigControl rcc = (RemoteConfigControl)((Object)RemoteConfigTab.this.controls.get(cp));
                if (rcc != null) {
                    rcc.updateParameter(cp);
                    return;
                }
                RemoteConfigControl newCc = new RemoteConfigControl(cp, RemoteConfigTab.this.rcw);
                vbox.getChildren().add((Object)newCc);
                RemoteConfigTab.this.controls.put(cp, newCc);
            }
        });
    }

    public void sendAll() {
        this.controls.values().forEach(c -> c.sendMe());
    }

    public void requestAll() {
        this.controls.values().forEach(c -> c.requestMe());
    }

    public void processPacket(IPacket pkt) {
        this.controls.values().forEach(c -> c.processPacket(pkt));
    }

    public void afterNetStart() {
        this.controls.values().forEach(c -> c.afterNetStart());
    }
}

