/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt.viewer;

import java.io.IOException;
import javafx.application.Platform;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import ru.dz.mqtt.viewer.RemoteConfigWindow;
import ru.dz.mqtt_udp.IPacket;
import ru.dz.mqtt_udp.PublishPacket;
import ru.dz.mqtt_udp.SubscribePacket;
import ru.dz.mqtt_udp.config.ConfigurableParameter;
import ru.dz.mqtt_udp.util.ErrorType;
import ru.dz.mqtt_udp.util.GlobalErrorHandler;
import ru.dz.mqtt_udp.util.image.ImageUtils;

public class RemoteConfigControl
extends HBox {
    private static final String REMOTE_VALUE_IS_THE_SAME = "Remote value is the same";
    private ConfigurableParameter cp;
    private TextField valueField = new TextField();
    private Button diffButton;
    private Label messageLabel = new Label("");
    private String remoteValue;
    private boolean remoteValueSame = true;
    private final ImageView remoteEquals = ImageUtils.getIcon("Folder-Accept");
    private final ImageView remoteDiffers = ImageUtils.getIcon("Folder-Warning");
    private String contentForTopic = null;

    public RemoteConfigControl(ConfigurableParameter cp, RemoteConfigWindow rcw) {
        super(20.0);
        this.cp = cp;
        this.remoteValue = cp.getValue();
        this.ifTopicRequestValue();
        Label kindLabel = new Label(String.valueOf(cp.getKind()) + ":");
        kindLabel.setPrefWidth(30.0);
        Label nameLabel = new Label(cp.getName());
        nameLabel.setPrefWidth(50.0);
        nameLabel.setStyle("-fx-font-weight: bold;");
        this.valueField.setText(cp.getValue());
        this.valueField.setOnAction(e -> {
            if (rcw.isAutoSend()) {
                cp.sendNewValue(this.valueField.getText());
            }
        });
        this.valueField.setOnKeyTyped(e -> Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                RemoteConfigControl.this.checkRemoteSame();
            }
        }));
        this.getChildren().add((Object)kindLabel);
        this.getChildren().add((Object)nameLabel);
        this.getChildren().add((Object)this.valueField);
        this.makeButton(ImageUtils.getIcon("options"), "Send to network", (EventHandler<ActionEvent>)((EventHandler)e -> cp.sendNewValue(this.valueField.getText())));
        this.makeButton(ImageUtils.getIcon("order"), "Request from network", (EventHandler<ActionEvent>)((EventHandler)e -> cp.requestAgain()));
        this.diffButton = this.makeButton(this.remoteEquals, REMOTE_VALUE_IS_THE_SAME, (EventHandler<ActionEvent>)((EventHandler)e -> this.updateLocalFromRemote()));
        this.diffButton.setDisable(true);
        this.messageLabel.setStyle("-fx-font-weight: bold;");
        this.getChildren().add((Object)this.messageLabel);
    }

    private void setRemoteValueDiffers() {
        this.diffButton.setGraphic((Node)this.remoteDiffers);
        this.diffButton.setDisable(false);
        this.diffButton.setTooltip(new Tooltip("Update FROM remote value"));
    }

    private void setRemoteValueEquals() {
        this.diffButton.setGraphic((Node)this.remoteEquals);
        this.diffButton.setDisable(true);
        this.diffButton.setTooltip(new Tooltip(REMOTE_VALUE_IS_THE_SAME));
    }

    private Button makeButton(ImageView icon, String toolTip, EventHandler<ActionEvent> handler) {
        Button cellButton = new Button();
        cellButton.setGraphic((Node)icon);
        cellButton.setTooltip(new Tooltip(toolTip));
        cellButton.setOnAction(handler);
        this.getChildren().add((Object)cellButton);
        return cellButton;
    }

    public void sendMe() {
        this.cp.sendNewValue(this.valueField.getText());
    }

    public void requestMe() {
        this.cp.requestAgain();
    }

    public void updateParameter(ConfigurableParameter newCp) {
        this.remoteValue = newCp.getValue();
        this.checkRemoteSame();
        this.ifTopicRequestValue();
    }

    public void checkRemoteSame() {
        this.remoteValueSame = this.remoteValue.equals(this.valueField.getText());
        if (this.remoteValueSame) {
            this.setRemoteValueEquals();
        } else {
            this.setRemoteValueDiffers();
        }
        this.updateMessage();
    }

    private void updateLocalFromRemote() {
        this.valueField.setText(this.remoteValue);
        this.checkRemoteSame();
    }

    private void updateMessage() {
        if (!this.remoteValueSame) {
            this.messageLabel.setText("Remote: '" + this.remoteValue + "'");
            return;
        }
        if (this.contentForTopic != null) {
            this.messageLabel.setText("Topic value: '" + this.contentForTopic + "'");
            return;
        }
        this.messageLabel.setText("");
    }

    public void processPacket(IPacket pkt) {
        if (!(pkt instanceof PublishPacket)) {
            return;
        }
        PublishPacket pp = (PublishPacket)pkt;
        if (this.cp.getKind().equals("topic") && pp.getTopic().equals(this.remoteValue)) {
            this.contentForTopic = pp.getValueString();
            System.out.println(String.format("pp.topic '%s' val '%s' ", pp.getTopic(), this.contentForTopic));
            Platform.runLater((Runnable)new Runnable(){

                @Override
                public void run() {
                    RemoteConfigControl.this.updateMessage();
                }
            });
        }
    }

    private void ifTopicRequestValue() {
        if (!this.cp.getKind().equals("topic")) {
            return;
        }
        try {
            if (this.remoteValue != null) {
                new SubscribePacket(this.remoteValue).send();
            }
        }
        catch (IOException e) {
            GlobalErrorHandler.handleError(ErrorType.IO, e);
        }
    }

    public void afterNetStart() {
        this.ifTopicRequestValue();
    }
}

