/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp.util.image;

import java.awt.image.BufferedImage;
import java.io.InputStream;
import javafx.embed.swing.SwingFXUtils;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;

public class ImageUtils {
    public static ImageView getIcon(String iName) {
        return ImageUtils.getIcon16(iName);
    }

    public static ImageView getIcon16(String iName) {
        return ImageUtils.getImageView(String.valueOf(iName) + "16.png");
    }

    public static ImageView getIcon32(String iName) {
        return ImageUtils.getImageView(String.valueOf(iName) + "32.png");
    }

    public static ImageView getImageView(String sourcePath) {
        Image newImage = ImageUtils.getImage(sourcePath);
        return new ImageView(newImage);
    }

    public static BufferedImage getSwingImage16(String iName) {
        return SwingFXUtils.fromFXImage((Image)ImageUtils.getImage16(iName), null);
    }

    public static Image getImage16(String iName) {
        return ImageUtils.getImage(String.valueOf(iName) + "16.png");
    }

    public static Image getImage32(String iName) {
        return ImageUtils.getImage(String.valueOf(iName) + "32.png");
    }

    public static Image getImage(String sourcePath) {
        Image img;
        InputStream input;
        block4: {
            input = null;
            try {
                Class<ImageUtils> c = ImageUtils.class;
                input = c.getResourceAsStream("../../../../../" + sourcePath);
                if (input == null) {
                    input = c.getResourceAsStream("/" + sourcePath);
                }
                if (input != null) break block4;
                System.err.println("Image not found: " + sourcePath);
            }
            catch (Throwable throwable) {
                ImageUtils.closeQuietly(input);
                throw throwable;
            }
            ImageUtils.closeQuietly(input);
            return null;
        }
        Image image = img = new Image(input);
        ImageUtils.closeQuietly(input);
        return image;
    }

    private static void closeQuietly(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

