/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp.config;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import ru.dz.mqtt_udp.IPacket;
import ru.dz.mqtt_udp.IPacketMultiSource;
import ru.dz.mqtt_udp.MqttProtocolException;
import ru.dz.mqtt_udp.PublishPacket;
import ru.dz.mqtt_udp.SubscribePacket;
import ru.dz.mqtt_udp.items.AbstractItem;
import ru.dz.mqtt_udp.items.TopicItem;
import ru.dz.mqtt_udp.util.LoopRunner;

public class Requester
implements Consumer<IPacket> {
    private static final int CHECK_LOOP_TIME = 60000;
    private static final int REQUEST_STEP_TIME = 1000;
    private long checkLoopTime = 60000L;
    private Map<String, TopicItem> items = new HashMap<String, TopicItem>();
    private LoopRunner lr = new LoopRunner("MQTT UDP config.Requester"){

        @Override
        protected void onStart() throws IOException, MqttProtocolException {
        }

        @Override
        protected void step() throws IOException, MqttProtocolException {
            1.sleep(Requester.this.checkLoopTime);
            Requester.this.loop();
        }

        @Override
        protected void onStop() throws IOException, MqttProtocolException {
        }
    };

    public Requester(IPacketMultiSource ms) {
        ms.addPacketSink(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTopic(String topicName) throws IOException {
        Map<String, TopicItem> map = this.items;
        synchronized (map) {
            this.items.put(topicName, null);
            SubscribePacket sp = new SubscribePacket(topicName);
            sp.send();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getValue(String topic) {
        String v = null;
        Map<String, TopicItem> map = this.items;
        synchronized (map) {
            TopicItem ti = this.items.get(topic);
            if (ti != null) {
                v = ti.getValue();
            }
        }
        return v;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void accept(IPacket t) {
        if (!(t instanceof PublishPacket)) {
            return;
        }
        PublishPacket pp = (PublishPacket)t;
        Map<String, TopicItem> map = this.items;
        synchronized (map) {
            if (!this.items.containsKey(pp.getTopic())) {
                return;
            }
            TopicItem ai = (TopicItem)AbstractItem.fromPacket(pp);
            this.items.put(ai.getTopic(), ai);
        }
    }

    public void startBackgroundRequests() {
        this.lr.requestStart();
    }

    public void setCheckLoopTime(long checkLoopTime) {
        this.checkLoopTime = checkLoopTime;
    }

    public long getCheckLoopTime() {
        return this.checkLoopTime;
    }

    protected void loop() throws IOException {
        Set<String> empty = this.getAllEmpty();
        for (String topic : empty) {
            new SubscribePacket(topic).send();
            LoopRunner.sleep(1000L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getAllEmpty() {
        HashSet<String> empty = new HashSet<String>();
        Map<String, TopicItem> map = this.items;
        synchronized (map) {
            this.items.forEach((topic, item) -> {
                if (item == null) {
                    empty.add((String)topic);
                }
            });
        }
        return empty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDone() {
        Map<String, TopicItem> map = this.items;
        synchronized (map) {
            for (TopicItem item : this.items.values()) {
                if (item != null) continue;
                return false;
            }
        }
        return true;
    }

    public boolean waitForAll(long timeoutMsec) {
        if (timeoutMsec < 0L) {
            throw new IllegalArgumentException("timeoutMsec < 0");
        }
        long start = System.currentTimeMillis();
        while (!this.isDone()) {
            long now = System.currentTimeMillis();
            if (now - start > timeoutMsec) {
                return false;
            }
            try {
                Thread.sleep(timeoutMsec / 5L);
            }
            catch (InterruptedException interruptedException) {
            }
        }
        return true;
    }
}

