/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt.viewer;

import java.io.IOException;
import java.net.InetAddress;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TableCell;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.PropertyValueFactory;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.Stage;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import ru.dz.mqtt.viewer.TableButtonsState;
import ru.dz.mqtt.viewer.TopicTableButtonCell;
import ru.dz.mqtt.viewer.TopicTableItem;
import ru.dz.mqtt_udp.SubscribePacket;
import ru.dz.mqtt_udp.items.TopicItem;
import ru.dz.mqtt_udp.util.image.ImageUtils;

public class TopicTable {
    private Stage newWindow = new Stage();
    private ObservableList<TopicTableItem> localData;
    private TableView<TopicTableItem> table = new TableView();
    private boolean topicListUpdateEnabled = true;
    private boolean autoNetworkSendEnabled = false;
    private static final Image windowIcon = ImageUtils.getImage("content256.png");
    private static final ImageView lockedIcon = ImageUtils.getIcon32("locked");
    private static final ImageView unlockedIcon = ImageUtils.getIcon32("unlocked");
    private static final ImageView newTopicIcon = ImageUtils.getIcon32("tests");
    private final TextInputDialog ntd = new TextInputDialog();
    private final TextInputDialog std;

    public TopicTable(final ObservableList<TopicItem> data) {
        Stage stage = (Stage)this.ntd.getDialogPane().getScene().getWindow();
        stage.getIcons().add((Object)ImageUtils.getImage("tests256.png"));
        this.ntd.setTitle("Create new topic");
        this.ntd.setHeaderText("New topic name");
        this.std = new TextInputDialog();
        stage = (Stage)this.std.getDialogPane().getScene().getWindow();
        stage.getIcons().add((Object)ImageUtils.getImage("analysis256.png"));
        this.std.setTitle("Search for topic");
        this.std.setHeaderText("Topic to find");
        this.std.setGraphic((Node)ImageUtils.getIcon32("analysis"));
        this.table.setEditable(true);
        TableColumn buttonsCol = new TableColumn("");
        TableColumn topicCol = new TableColumn("Topic");
        TableColumn valueCol = new TableColumn();
        TableColumn hostCol = new TableColumn("Host");
        TableColumn timeCol = new TableColumn();
        Label timeLabel = new Label("Time");
        timeLabel.setTooltip(new Tooltip("Time of last update"));
        timeCol.setGraphic((Node)timeLabel);
        Label valueLabel = new Label("Value");
        valueLabel.setTooltip(new Tooltip("Dobleclick value to update"));
        valueCol.setGraphic((Node)valueLabel);
        buttonsCol.setMaxWidth(104.0);
        buttonsCol.setMinWidth(104.0);
        buttonsCol.setResizable(false);
        hostCol.setMinWidth(100.0);
        hostCol.setMaxWidth(100.0);
        hostCol.setResizable(false);
        timeCol.setMinWidth(100.0);
        timeCol.setMaxWidth(100.0);
        timeCol.setResizable(false);
        topicCol.setMinWidth(140.0);
        valueCol.setMinWidth(140.0);
        this.table.setColumnResizePolicy(TableView.CONSTRAINED_RESIZE_POLICY);
        topicCol.setEditable(false);
        buttonsCol.setEditable(false);
        hostCol.setEditable(false);
        timeCol.setEditable(false);
        valueCol.setEditable(true);
        valueCol.setCellFactory(TextFieldTableCell.forTableColumn());
        valueCol.setOnEditCommit((EventHandler)new EventHandler<TableColumn.CellEditEvent<TopicTableItem, String>>(){

            public void handle(TableColumn.CellEditEvent<TopicTableItem, String> t) {
                int row = t.getTablePosition().getRow();
                ObservableList items = t.getTableView().getItems();
                TopicTableItem item = (TopicTableItem)items.get(row);
                item.setValue((String)t.getNewValue());
                if (TopicTable.this.autoNetworkSendEnabled) {
                    TopicTable.this.sendRecord(row, item.getTableButtonsState().isLimitSendToHost());
                }
            }
        });
        buttonsCol.setCellFactory((Callback)new Callback<TableColumn<TopicTableItem, TableButtonsState>, TableCell<TopicTableItem, TableButtonsState>>(){

            public TableCell<TopicTableItem, TableButtonsState> call(TableColumn<TopicTableItem, TableButtonsState> p) {
                return new TopicTableButtonCell(TopicTable.this);
            }
        });
        buttonsCol.setCellValueFactory((Callback)new PropertyValueFactory("tableButtonsState"));
        topicCol.setCellValueFactory((Callback)new PropertyValueFactory("topic"));
        valueCol.setCellValueFactory((Callback)new PropertyValueFactory("value"));
        hostCol.setCellValueFactory((Callback)new PropertyValueFactory("from"));
        timeCol.setCellValueFactory((Callback)new PropertyValueFactory("time"));
        this.table.getColumns().addAll((Object[])new TableColumn[]{buttonsCol, topicCol, valueCol, hostCol, timeCol});
        this.localData = FXCollections.observableArrayList();
        this.table.setItems(this.localData);
        data.addListener((ListChangeListener)new ListChangeListener<TopicItem>(){

            public void onChanged(ListChangeListener.Change<? extends TopicItem> c) {
                if (TopicTable.this.topicListUpdateEnabled) {
                    TopicTable.this.updateLocalData((ObservableList<TopicItem>)data);
                }
            }
        });
        this.openWindow();
    }

    public void updateLocalData(ObservableList<TopicItem> data) {
        data.forEach(ti -> {
            TopicTableItem nti;
            AtomicReference<Boolean> have = new AtomicReference<Boolean>(false);
            ObservableList<TopicTableItem> observableList = this.localData;
            synchronized (observableList) {
                int i = 0;
                while (i < this.localData.size()) {
                    TopicTableItem lti = (TopicTableItem)this.localData.get(i);
                    if (lti.sameHostAndTopic((TopicItem)ti)) {
                        lti.assignFrom((TopicItem)ti);
                        have.set(true);
                        this.localData.set(i, (Object)lti);
                    }
                    ++i;
                }
            }
            if (!have.get().booleanValue() && (nti = new TopicTableItem((TopicItem)ti)).isPublish()) {
                this.localData.add((Object)nti);
            }
        });
    }

    private void openWindow() {
        VBox vbox = new VBox(new Node[]{this.makeToolBar(), this.table});
        vbox.setFillWidth(true);
        VBox.setVgrow(this.table, (Priority)Priority.ALWAYS);
        Scene secondScene = new Scene((Parent)vbox, 800.0, 500.0);
        this.newWindow.setTitle("Topic editor");
        this.newWindow.setScene(secondScene);
        this.newWindow.setMinWidth(500.0);
        this.newWindow.getIcons().add((Object)windowIcon);
    }

    public void setVisible(boolean is) {
        if (is) {
            this.newWindow.show();
        } else {
            this.newWindow.hide();
        }
    }

    public boolean isVisible() {
        return this.newWindow.isShowing();
    }

    private HBox makeToolBar() {
        Button newTopicButton = new Button();
        newTopicButton.setTooltip(new Tooltip("Add new topic to the list"));
        newTopicButton.setGraphic((Node)newTopicIcon);
        newTopicButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Optional result = TopicTable.this.newTopicDialog();
                result.ifPresent(newTopicName -> {
                    TopicTableItem nti = new TopicTableItem(48, (String)newTopicName);
                    TopicTable.this.localData.add((Object)nti);
                });
            }
        });
        Button searchButton = new Button();
        searchButton.setTooltip(new Tooltip("Search for topic"));
        searchButton.setGraphic((Node)ImageUtils.getIcon32("analysis"));
        searchButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Optional result = TopicTable.this.searchTopicDialog();
                if (result.isPresent()) {
                    TopicTable.this.search((String)result.get());
                }
            }
        });
        final ToggleButton refreshListButton = new ToggleButton();
        refreshListButton.setTooltip(new Tooltip("Enable automatic topic list refresh"));
        refreshListButton.setGraphic((Node)unlockedIcon);
        refreshListButton.setSelected(true);
        refreshListButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                TopicTable.this.topicListUpdateEnabled = refreshListButton.isSelected();
                refreshListButton.setGraphic((Node)(TopicTable.this.topicListUpdateEnabled ? unlockedIcon : lockedIcon));
            }
        });
        final ToggleButton refreshValueButton = new ToggleButton();
        refreshValueButton.setTooltip(new Tooltip("Enable automatic value send"));
        refreshValueButton.setGraphic((Node)ImageUtils.getIcon32("refresh"));
        refreshValueButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                TopicTable.this.autoNetworkSendEnabled = refreshValueButton.isSelected();
            }
        });
        ToolBar leftTb = new ToolBar();
        leftTb.getItems().addAll((Object[])new Node[]{newTopicButton, searchButton});
        ToolBar rightTb = new ToolBar();
        rightTb.getItems().addAll((Object[])new Node[]{refreshListButton, refreshValueButton});
        Region spacer = new Region();
        spacer.getStyleClass().add((Object)"menu-bar");
        HBox.setHgrow((Node)spacer, (Priority)Priority.SOMETIMES);
        HBox hbox = new HBox(new Node[]{leftTb, spacer, rightTb});
        return hbox;
    }

    private Optional<String> newTopicDialog() {
        this.ntd.setGraphic((Node)ImageUtils.getIcon32("tests"));
        return this.ntd.showAndWait();
    }

    private Optional<String> searchTopicDialog() {
        return this.std.showAndWait();
    }

    private void search(String findmeIn) {
        ObservableList cols = this.table.getColumns();
        TableColumn col = (TableColumn)cols.get(1);
        String findme = findmeIn.toLowerCase();
        TableView.TableViewSelectionModel sel = this.table.getSelectionModel();
        sel.setSelectionMode(SelectionMode.MULTIPLE);
        sel.clearSelection();
        int i = 0;
        while (i < this.localData.size()) {
            String cellValue = col.getCellData((Object)((TopicTableItem)this.localData.get(i))).toString().toLowerCase();
            if (cellValue.contains(findme)) {
                sel.select(i);
            }
            ++i;
        }
        this.table.setSelectionModel(sel);
    }

    public void sendRecord(int index, boolean limitSendToHost) {
        TopicTableItem it = (TopicTableItem)this.localData.get(index);
        try {
            if (limitSendToHost) {
                InetAddress addr = InetAddress.getByName(it.getFrom());
                it.sendTo(addr);
            } else {
                it.sendToAll();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void sendRequest(int index, boolean limitSendToHost) {
        TopicTableItem it = (TopicTableItem)this.localData.get(index);
        String topic = it.getTopic();
        SubscribePacket sp = new SubscribePacket(topic);
        try {
            if (limitSendToHost) {
                InetAddress addr = InetAddress.getByName(it.getFrom());
                sp.send(addr);
            } else {
                sp.send();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public ObjectProperty<EventHandler<WindowEvent>> onHiddenProperty() {
        return this.newWindow.onHiddenProperty();
    }
}

