/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt.viewer;

import java.util.HashMap;
import java.util.Map;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Tab;
import javafx.scene.layout.VBox;
import ru.dz.mqtt.viewer.RemoteConfigControl;
import ru.dz.mqtt.viewer.RemoteConfigWindow;
import ru.dz.mqtt_udp.IPacket;
import ru.dz.mqtt_udp.config.ConfigurableHost;
import ru.dz.mqtt_udp.config.ConfigurableParameter;

public class RemoteConfigTab
extends Tab {
    private RemoteConfigWindow rcw;
    private ConfigurableHost ch;
    private Label infoLabel = new Label();
    private Map<ConfigurableParameter, RemoteConfigControl> controls = new HashMap<ConfigurableParameter, RemoteConfigControl>();
    private String infoSoft;
    private String infoSoftVer;
    private String nodeLocation;
    private String infoUptime;
    private String nodeName;

    public RemoteConfigTab(ConfigurableHost ch, RemoteConfigWindow rcw) {
        this.ch = ch;
        this.rcw = rcw;
        this.setText(ch.getMacAddressString());
        this.setClosable(false);
        VBox vbox = new VBox(8.0);
        vbox.setStyle("-fx-padding: 10;-fx-border-style: solid inside;-fx-border-width: 2;-fx-border-insets: 5;-fx-border-color: lightgrey;");
        vbox.getChildren().add((Object)this.infoLabel);
        this.updateInfoLabel();
        this.setContent((Node)vbox);
    }

    public String getTabDescription() {
        StringBuilder sb = new StringBuilder("  Id: " + this.ch.getMacAddressString() + "   IP: " + this.ch.getIpAddressString());
        if (this.infoSoft != null) {
            sb.append("   " + this.infoSoft);
        }
        if (this.infoSoftVer != null) {
            sb.append(" v. " + this.infoSoftVer);
        }
        if (this.nodeName != null) {
            sb.append("  " + this.nodeName);
        }
        if (this.nodeLocation != null) {
            sb.append(" @ " + this.nodeLocation);
        }
        if (this.infoUptime != null) {
            sb.append("   up " + this.infoUptime);
        }
        return sb.toString();
    }

    private void updateInfoLabel() {
        this.infoLabel.setText(this.getTabDescription());
    }

    public void updateFromHost(ConfigurableHost newCh) {
    }

    public void addParameter(final ConfigurableParameter cp) {
        final VBox vbox = (VBox)this.getContent();
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (RemoteConfigTab.this.processSpecialParameter(cp)) {
                    return;
                }
                RemoteConfigControl rcc = (RemoteConfigControl)((Object)RemoteConfigTab.this.controls.get(cp));
                if (rcc != null) {
                    rcc.updateParameter(cp);
                    return;
                }
                RemoteConfigControl newCc = new RemoteConfigControl(cp, RemoteConfigTab.this.rcw);
                vbox.getChildren().add((Object)newCc);
                RemoteConfigTab.this.controls.put(cp, newCc);
            }
        });
    }

    private boolean processSpecialParameter(ConfigurableParameter cp) {
        block26: {
            String value;
            String name;
            block24: {
                name = cp.getName();
                value = cp.getValue();
                if (value.length() == 0) {
                    value = null;
                }
                if (!cp.getKind().equals("info")) break block24;
                switch (name) {
                    case "soft": {
                        this.infoSoft = value;
                        break;
                    }
                    case "ver": {
                        this.infoSoftVer = value;
                        break;
                    }
                    case "uptime": {
                        this.infoUptime = value;
                        break;
                    }
                    default: {
                        return false;
                    }
                }
                this.updateInfoLabel();
                return true;
            }
            if (!cp.getKind().equals("node")) break block26;
            switch (name) {
                case "name": {
                    if (value == null || value.length() <= 2) break;
                    this.nodeName = value;
                    this.setText(value);
                    break;
                }
                case "location": {
                    this.nodeLocation = value;
                    break;
                }
                default: {
                    return false;
                }
            }
            this.updateInfoLabel();
            return false;
        }
        return false;
    }

    public void sendAll() {
        this.controls.values().forEach(c -> c.sendMe());
    }

    public void requestAll() {
        this.controls.values().forEach(c -> c.requestMe());
    }

    public void processPacket(IPacket pkt) {
        this.controls.values().forEach(c -> c.processPacket(pkt));
    }

    public void afterNetStart() {
        this.controls.values().forEach(c -> c.afterNetStart());
    }
}

