/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt.viewer;

import java.io.File;
import java.io.IOException;
import java.net.SocketException;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.beans.property.ObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.event.EventHandler;
import javafx.geometry.Orientation;
import javafx.geometry.Rectangle2D;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Alert;
import javafx.scene.control.CheckMenuItem;
import javafx.scene.control.ListCell;
import javafx.scene.control.ListView;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuBar;
import javafx.scene.control.MenuItem;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.control.SeparatorMenuItem;
import javafx.scene.control.SplitPane;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToolBar;
import javafx.scene.control.Tooltip;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.input.KeyCombination;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.Region;
import javafx.scene.layout.VBox;
import javafx.stage.FileChooser;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.Window;
import javafx.stage.WindowEvent;
import javafx.util.Callback;
import ru.dz.mqtt.viewer.FileLogger;
import ru.dz.mqtt.viewer.HostItem;
import ru.dz.mqtt.viewer.MqttUdpDataSource;
import ru.dz.mqtt.viewer.PingSender;
import ru.dz.mqtt.viewer.RemoteConfigWindow;
import ru.dz.mqtt.viewer.TopicTable;
import ru.dz.mqtt_udp.items.AbstractItem;
import ru.dz.mqtt_udp.items.TopicItem;
import ru.dz.mqtt_udp.util.ErrorType;
import ru.dz.mqtt_udp.util.GlobalErrorHandler;
import ru.dz.mqtt_udp.util.MqttUdpRuntimeException;
import ru.dz.mqtt_udp.util.image.ImageUtils;

public class Main
extends Application {
    private static final int TOOLBAR_HEIGHT = 34;
    private FileLogger flog = new FileLogger();
    private FileChooser fch = new FileChooser();
    protected volatile boolean updateEnabled = true;
    protected volatile boolean displayPings = false;
    private ObservableList<TopicItem> listItems = FXCollections.observableArrayList();
    private TopicTable generalTopicTable = new TopicTable(this.listItems);
    private RemoteConfigWindow rcw;
    private SplitPane splitPane;
    private HBox hosts;
    private static final Image applicationIcon = ImageUtils.getImage("maintenance256.png");
    private static final Alert aboutAlert = new Alert(Alert.AlertType.INFORMATION);
    private static final int DEFAULT_WIDTH = 1000;
    private PingSender pingSender = new PingSender();
    private ListView<HostItem> hostListView = new ListView();
    private ObservableList<HostItem> hostItems = FXCollections.observableArrayList();
    private ListView<AbstractItem> logListView = new ListView();
    private ObservableList<AbstractItem> logItems = FXCollections.observableArrayList();
    private CheckMenuItem updateMenuItem = new CheckMenuItem("Update");
    private ToggleButton toolBarUpdateButton = new ToggleButton();
    private ToggleButton toolBarConfigButton = new ToggleButton();
    private ToggleButton toolBarSendButton = new ToggleButton();
    private static final ImageView runIcon = ImageUtils.getIcon("start");
    private static final ImageView stopIcon = ImageUtils.getIcon("pause");
    private ListView<TopicItem> topicListView = new ListView();
    private MqttUdpDataSource ds;

    public void start(Stage primaryStage) {
        try {
            primaryStage.getIcons().add((Object)applicationIcon);
            this.fch.setTitle("Event log file");
            this.fch.setInitialFileName("MQTT_UDP.log");
            Region spacer = new Region();
            spacer.getStyleClass().add((Object)"menu-bar");
            HBox.setHgrow((Node)spacer, (Priority)Priority.SOMETIMES);
            MenuBar leftMenu = this.makeLeftMenu();
            ToolBar toolBar = this.makeToolBar();
            MenuBar rightMenu = this.makeRightMenu();
            leftMenu.setPrefHeight(34.0);
            rightMenu.setPrefHeight(34.0);
            toolBar.setPrefHeight(34.0);
            this.toolBarUpdateButton.setPrefHeight(12.0);
            HBox menubars = new HBox(new Node[]{leftMenu, spacer, toolBar, rightMenu});
            HBox content = this.makeContent();
            content.setFillHeight(true);
            HBox log = this.makeLog();
            log.setFillHeight(true);
            this.hosts = this.makeHosts();
            this.hosts.setFillHeight(true);
            this.splitPane = new SplitPane(new Node[]{content, log, this.hosts});
            this.splitPane.setOrientation(Orientation.VERTICAL);
            this.splitPane.setDividerPositions(new double[]{0.5, 0.8f});
            SplitPane.setResizableWithParent((Node)content, (Boolean)true);
            SplitPane.setResizableWithParent((Node)log, (Boolean)true);
            SplitPane.setResizableWithParent((Node)this.hosts, (Boolean)true);
            VBox vbox = new VBox(new Node[]{menubars, this.splitPane});
            vbox.setFillWidth(true);
            Scene scene = new Scene((Parent)vbox);
            Rectangle2D screenSize = Screen.getPrimary().getVisualBounds();
            primaryStage.setScene(scene);
            primaryStage.setTitle("MQTT/UDP Traffic Viewer");
            primaryStage.setOnCloseRequest(e -> {
                Platform.exit();
                System.exit(0);
            });
            primaryStage.setHeight(screenSize.getHeight() - 100.0);
            primaryStage.show();
            aboutAlert.setTitle("About MQTT/UDP viewer");
            aboutAlert.setHeaderText(String.format("MQTT/UDP viewer version %d.%d", 0, 4));
            aboutAlert.setContentText("Network is broker!");
            aboutAlert.initOwner((Window)primaryStage);
            this.initNetwork();
            this.rcw = new RemoteConfigWindow();
            ObjectProperty<EventHandler<WindowEvent>> ohp = this.generalTopicTable.onHiddenProperty();
            ohp.addListener(e -> this.toolBarSendButton.setSelected(this.generalTopicTable.isVisible()));
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    private void addHostItem(HostItem item) {
        int nItems = this.hostItems.size();
        int j = 0;
        while (j < nItems) {
            HostItem ci = (HostItem)this.hostItems.get(j);
            if (ci.getHostName().equals(item.getHostName())) {
                this.hostItems.remove(j);
                this.hostItems.add(j, (Object)item);
                MultipleSelectionModel sm = this.hostListView.getSelectionModel();
                if (sm.isEmpty()) {
                    sm.select(j);
                }
                return;
            }
            ++j;
        }
        this.hostItems.add(0, (Object)item);
    }

    private HBox makeHosts() {
        this.hostListView.setItems(this.hostItems);
        this.hostListView.setPrefWidth(1000.0);
        HBox hbox = new HBox(new Node[]{this.hostListView});
        return hbox;
    }

    private void addLogItem(AbstractItem i) {
        this.logItems.add(0, (Object)i);
        if (this.logItems.size() > 400) {
            this.logItems.remove(this.logItems.size() - 1);
        }
    }

    private HBox makeLog() {
        this.logListView.setItems(this.logItems);
        this.logListView.setPrefWidth(1000.0);
        HBox hbox = new HBox(new Node[]{this.logListView});
        return hbox;
    }

    private HBox makeContent() {
        ListView<TopicItem> listv = this.makeListView();
        HBox hbox = new HBox(new Node[]{listv});
        hbox.setFillHeight(true);
        return hbox;
    }

    private MenuBar makeLeftMenu() {
        Menu fileMenu = new Menu("File");
        MenuItem logStart = new MenuItem("Start log");
        MenuItem logStop = new MenuItem("Stop log");
        MenuItem exitMenuItem = new MenuItem("Exit");
        fileMenu.getItems().addAll((Object[])new MenuItem[]{logStart, logStop, new SeparatorMenuItem(), exitMenuItem});
        Menu displayMenu = new Menu("Display");
        CheckMenuItem viewHostsMenuItem = new CheckMenuItem("Hosts view");
        CheckMenuItem showPingsMenuItem = new CheckMenuItem("Display Ping/Responce");
        displayMenu.getItems().addAll((Object[])new MenuItem[]{this.updateMenuItem, new SeparatorMenuItem(), viewHostsMenuItem, showPingsMenuItem});
        Menu sendMenu = new Menu("Send");
        CheckMenuItem replyMenuItem = new CheckMenuItem("Replies");
        replyMenuItem.setSelected(this.pingSender.isEnabled());
        replyMenuItem.setOnAction(a -> this.ds.setMuted(!replyMenuItem.isSelected()));
        CheckMenuItem pingMenuItem = new CheckMenuItem("Ping");
        pingMenuItem.setSelected(this.pingSender.isEnabled());
        pingMenuItem.setOnAction(a -> this.pingSender.setEnabled(pingMenuItem.isSelected()));
        sendMenu.getItems().addAll((Object[])new MenuItem[]{replyMenuItem, pingMenuItem});
        MenuBar mb = new MenuBar(new Menu[]{fileMenu, displayMenu, sendMenu});
        showPingsMenuItem.setOnAction(a -> {
            boolean bl = this.displayPings = showPingsMenuItem.isSelected();
        });
        showPingsMenuItem.setSelected(false);
        this.displayPings = false;
        viewHostsMenuItem.setSelected(true);
        viewHostsMenuItem.setOnAction(a -> {
            boolean on = viewHostsMenuItem.isSelected();
            this.hosts.setVisible(on);
            this.hosts.setFillHeight(on);
            this.splitPane.autosize();
        });
        this.updateMenuItem.setAccelerator(KeyCombination.keyCombination((String)"F5"));
        this.updateMenuItem.setSelected(true);
        this.updateMenuItem.setOnAction(a -> this.switchRunStop());
        exitMenuItem.setOnAction(a -> {
            Platform.exit();
            System.exit(0);
        });
        logStart.setGraphic((Node)ImageUtils.getIcon("Folder-Add"));
        logStart.setAccelerator(KeyCombination.keyCombination((String)"Ctrl+L"));
        logStart.setOnAction(a -> this.startLogging(logStart));
        logStop.setGraphic((Node)ImageUtils.getIcon("Folder-Delete"));
        logStop.setOnAction(a -> this.flog.stopLog());
        return mb;
    }

    public void startLogging(MenuItem logStart) {
        File fname = this.fch.showSaveDialog(logStart.getParentPopup().getScene().getWindow());
        if (fname != null) {
            try {
                this.flog.startLog(fname);
            }
            catch (IOException e) {
                GlobalErrorHandler.handleError(ErrorType.IO, e);
            }
        }
    }

    private MenuBar makeRightMenu() {
        Menu helpMenu = new Menu("Help");
        MenuItem help = new MenuItem("Help");
        MenuItem goSite = new MenuItem("Visit project on GitHub");
        MenuItem aboutMenuItem = new MenuItem("About");
        helpMenu.getItems().addAll((Object[])new MenuItem[]{help, goSite, new SeparatorMenuItem(), aboutMenuItem});
        help.setAccelerator(KeyCombination.keyCombination((String)"F1"));
        help.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Main.this.getHostServices().showDocument("https://github.com/dzavalishin/mqtt_udp/wiki/MQTT-UDP-Viewer-Help");
            }
        });
        goSite.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Main.this.getHostServices().showDocument("https://github.com/dzavalishin/mqtt_udp");
            }
        });
        aboutMenuItem.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Main.this.showAboutAlert();
            }
        });
        MenuBar mb = new MenuBar(new Menu[]{helpMenu});
        return mb;
    }

    private ToolBar makeToolBar() {
        this.toolBarUpdateButton.setTooltip(new Tooltip("Press F5 to stop/run"));
        this.toolBarUpdateButton.setGraphic((Node)runIcon);
        this.toolBarUpdateButton.setSelected(true);
        this.toolBarUpdateButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Main.this.switchRunStop();
            }
        });
        this.toolBarConfigButton.setTooltip(new Tooltip("Open remote device configuration interface"));
        this.toolBarConfigButton.setGraphic((Node)ImageUtils.getIcon("surveys"));
        this.toolBarConfigButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Main.this.rcw.setVisible(Main.this.toolBarConfigButton.isSelected());
            }
        });
        this.toolBarSendButton.setTooltip(new Tooltip("Open data send interface"));
        this.toolBarSendButton.setGraphic((Node)ImageUtils.getIcon("content"));
        this.toolBarSendButton.setOnAction((EventHandler)new EventHandler<ActionEvent>(){

            public void handle(ActionEvent event) {
                Main.this.generalTopicTable.setVisible(Main.this.toolBarSendButton.isSelected());
            }
        });
        ToolBar tb = new ToolBar();
        tb.getItems().addAll((Object[])new Node[]{this.toolBarSendButton, this.toolBarConfigButton, this.toolBarUpdateButton});
        return tb;
    }

    private void switchRunStop() {
        this.updateEnabled = !this.updateEnabled;
        this.updateMenuItem.setSelected(this.updateEnabled);
        this.toolBarUpdateButton.setSelected(this.updateEnabled);
        this.toolBarUpdateButton.setGraphic((Node)(this.updateEnabled ? runIcon : stopIcon));
    }

    private void showAboutAlert() {
        aboutAlert.showAndWait();
    }

    public static void main(String[] args) {
        Main.launch((String[])args);
    }

    private void setListItem(AbstractItem item) {
        if (!item.typeWithTopic()) {
            return;
        }
        if (!(item instanceof TopicItem)) {
            return;
        }
        TopicItem ti = (TopicItem)item;
        int nItems = this.listItems.size();
        int j = 0;
        while (j < nItems) {
            TopicItem ci = (TopicItem)this.listItems.get(j);
            if (ci.getTopic().equals(ti.getTopic())) {
                this.listItems.remove(j);
                this.listItems.add(j, (Object)ti);
                MultipleSelectionModel sm = this.topicListView.getSelectionModel();
                if (sm.isEmpty()) {
                    sm.select(j);
                }
                return;
            }
            ++j;
        }
        this.listItems.add(0, (Object)ti);
        MultipleSelectionModel sm = this.topicListView.getSelectionModel();
        if (sm.isEmpty()) {
            sm.select(0);
        }
    }

    private ListView<TopicItem> makeListView() {
        this.topicListView.setPrefWidth(1000.0);
        this.topicListView.setItems(this.listItems);
        this.topicListView.setCellFactory((Callback)new Callback<ListView<TopicItem>, ListCell<TopicItem>>(){

            public ListCell<TopicItem> call(ListView<TopicItem> arg0) {
                final Tooltip tooltip = new Tooltip();
                ListCell<TopicItem> cell = new ListCell<TopicItem>(){

                    public void updateItem(TopicItem item, boolean empty) {
                        super.updateItem((Object)item, empty);
                        if (item != null) {
                            this.setText(item.toString());
                            tooltip.setText("From " + item.getFrom());
                            this.setTooltip(tooltip);
                        }
                    }
                };
                return cell;
            }
        });
        return this.topicListView;
    }

    private void initNetwork() {
        try {
            this.ds = new MqttUdpDataSource();
        }
        catch (SocketException e) {
            throw new MqttUdpRuntimeException(e);
        }
        this.ds.setSink(ti -> Platform.runLater((Runnable)new Runnable((AbstractItem)ti){
            private final /* synthetic */ AbstractItem val$ti;
            {
                this.val$ti = abstractItem;
            }

            @Override
            public void run() {
                if (Main.this.updateEnabled) {
                    if (Main.this.displayPings || !this.val$ti.isPingOrResponce()) {
                        Main.this.setListItem(this.val$ti);
                        Main.this.addLogItem(this.val$ti);
                    }
                    Main.this.addHostItem(new HostItem(this.val$ti));
                    Main.this.flog.logItem(this.val$ti);
                }
            }
        }));
    }
}

