/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp.util;

import java.io.IOException;
import ru.dz.mqtt_udp.MqttProtocolException;
import ru.dz.mqtt_udp.util.ErrorType;
import ru.dz.mqtt_udp.util.GlobalErrorHandler;

public abstract class LoopRunner {
    private volatile boolean run = false;
    private final String threadName;

    public LoopRunner(String name) {
        this.threadName = name;
    }

    protected abstract void onStart() throws IOException, MqttProtocolException;

    protected abstract void step() throws IOException, MqttProtocolException;

    protected abstract void onStop() throws IOException, MqttProtocolException;

    public boolean isRunning() {
        return this.run;
    }

    public void requestStart() {
        if (this.isRunning()) {
            return;
        }
        this.start();
    }

    public void requestStop() {
        this.run = false;
    }

    protected void start() {
        Runnable target = this.makeLoopRunnable();
        Thread t = new Thread(target, this.threadName);
        t.start();
    }

    private void loop() throws IOException, MqttProtocolException {
        this.onStart();
        this.run = true;
        while (this.run) {
            this.step();
        }
        this.onStop();
    }

    private Runnable makeLoopRunnable() {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    LoopRunner.this.loop();
                }
                catch (IOException e) {
                    GlobalErrorHandler.handleError(ErrorType.IO, e);
                }
                catch (MqttProtocolException e) {
                    GlobalErrorHandler.handleError(ErrorType.Protocol, e);
                }
            }
        };
    }

    public static void sleep(long msec) {
        try {
            Thread.sleep(msec);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }
}

