/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp.util;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;
import java.util.Collection;
import java.util.Optional;
import ru.dz.mqtt_udp.Engine;
import ru.dz.mqtt_udp.IPacket;
import ru.dz.mqtt_udp.MqttProtocolException;
import ru.dz.mqtt_udp.io.IPacketAddress;
import ru.dz.mqtt_udp.io.IpAddress;
import ru.dz.mqtt_udp.io.SingleSendSocket;
import ru.dz.mqtt_udp.proto.TTR_PacketNumber;
import ru.dz.mqtt_udp.proto.TTR_ReplyTo;
import ru.dz.mqtt_udp.proto.TTR_Signature;
import ru.dz.mqtt_udp.proto.TaggedTailRecord;
import ru.dz.mqtt_udp.util.ErrorType;
import ru.dz.mqtt_udp.util.GlobalErrorHandler;

public abstract class GenericPacket
implements IPacket {
    private static final byte[] broadcast = new byte[]{-1, -1, -1, -1};
    protected byte flags = 0;
    protected IPacketAddress from;
    private Optional<Integer> replyToPacketNumber = Optional.empty();
    private Optional<Integer> packetNumber = Optional.empty();
    private boolean signed = false;

    protected GenericPacket(IPacketAddress from) {
        this.from = from;
    }

    protected GenericPacket() {
        this.from = null;
    }

    public static DatagramSocket recvSocket() throws SocketException {
        DatagramSocket s = new DatagramSocket(null);
        s.setReuseAddress(true);
        InetSocketAddress address = new InetSocketAddress(1883);
        s.bind(address);
        return s;
    }

    public void send() throws IOException {
        this.send(SingleSendSocket.get());
    }

    public void send(InetAddress addr) throws IOException {
        this.send(SingleSendSocket.get(), addr);
    }

    public void send(DatagramSocket sock) throws IOException {
        byte[] pkt = this.toBytes();
        InetAddress address = InetAddress.getByAddress(broadcast);
        DatagramPacket p = new DatagramPacket(pkt, pkt.length, address, 1883);
        Engine.throttle();
        sock.send(p);
    }

    public void send(DatagramSocket sock, InetAddress address) throws IOException {
        byte[] pkt = this.toBytes();
        DatagramPacket p = new DatagramPacket(pkt, pkt.length, address, 1883);
        sock.send(p);
    }

    public static IPacket recv(DatagramSocket s) throws IOException, MqttProtocolException {
        byte[] buf = new byte[2048];
        DatagramPacket p = new DatagramPacket(buf, buf.length);
        s.receive(p);
        int l = p.getLength();
        byte[] got = new byte[l];
        System.arraycopy(p.getData(), p.getOffset(), got, 0, l);
        return IPacket.fromBytes(got, new IpAddress(p.getSocketAddress()));
    }

    @Override
    public IPacketAddress getFrom() {
        return this.from;
    }

    public byte getFlags() {
        return this.flags;
    }

    public String toString() {
        return String.format("MQTT/UDP packet of unknown type from '%s', please redefine toString in %s", this.from, this.getClass().getName());
    }

    public IPacket applyTTRs(Collection<TaggedTailRecord> ttrs) {
        if (ttrs == null) {
            return this;
        }
        for (TaggedTailRecord ttr : ttrs) {
            this.applyTTR(ttr);
        }
        return this;
    }

    private void applyTTR(TaggedTailRecord ttr) {
        if (ttr instanceof TTR_Signature) {
            this.setSigned(true);
        } else if (ttr instanceof TTR_PacketNumber) {
            TTR_PacketNumber t = (TTR_PacketNumber)ttr;
            this.setPacketNumber(t.getValue());
        } else if (ttr instanceof TTR_ReplyTo) {
            TTR_ReplyTo r = (TTR_ReplyTo)ttr;
            this.setReplyToPacketNumber(r.getValue());
        } else {
            GlobalErrorHandler.handleError(ErrorType.Protocol, "Unknown TTR: " + ttr);
        }
    }

    public Optional<Integer> getReplyToPacketNumber() {
        return this.replyToPacketNumber;
    }

    public void setReplyToPacketNumber(int replyToPacketNumber) {
        this.replyToPacketNumber = Optional.ofNullable(replyToPacketNumber);
    }

    public Optional<Integer> getPacketNumber() {
        return this.packetNumber;
    }

    public void setPacketNumber(int packetNumber) {
        this.packetNumber = Optional.ofNullable(packetNumber);
    }

    @Override
    public boolean isSigned() {
        return this.signed;
    }

    private void setSigned(boolean signed) {
        this.signed = signed;
    }
}

