/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp.tray;

import java.awt.AWTException;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.HashSet;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import ru.dz.mqtt_udp.IPacket;
import ru.dz.mqtt_udp.PacketSourceMultiServer;
import ru.dz.mqtt_udp.PublishPacket;
import ru.dz.mqtt_udp.config.ConfigurableParameter;
import ru.dz.mqtt_udp.config.LocalConfigurableParameter;
import ru.dz.mqtt_udp.config.RemoteConfig;
import ru.dz.mqtt_udp.tray.Config;
import ru.dz.mqtt_udp.util.ErrorType;
import ru.dz.mqtt_udp.util.GlobalErrorHandler;
import ru.dz.mqtt_udp.util.image.ImageUtils;

public class Main {
    private static final String TRIGGER_TOPIC = "tray/message";
    private static TrayIcon tIcon;
    private static SystemTray tray;
    private String topic1Val = "?";
    private String topic2Val = "?";
    private String userMessage = "No data received";
    private static Config cfg;

    public static void main(String[] stringArray) {
        try {
            cfg = new Config();
        }
        catch (FileNotFoundException fileNotFoundException) {
            JOptionPane.showMessageDialog(null, "mqttudptray.ini not found");
            return;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(null, "io error");
            return;
        }
        Main main = new Main();
        main.run();
        PacketSourceMultiServer packetSourceMultiServer = new PacketSourceMultiServer();
        packetSourceMultiServer.addPacketSink(iPacket -> main.processPkt((IPacket)iPacket));
        HashSet<ConfigurableParameter> hashSet = new HashSet<ConfigurableParameter>();
        hashSet.add(new LocalConfigurableParameter("topic", "test1", "Trigger"));
        RemoteConfig remoteConfig = new RemoteConfig(packetSourceMultiServer, hashSet);
        packetSourceMultiServer.requestStart();
        remoteConfig.requestStart();
    }

    private void processPkt(IPacket iPacket) {
        if (!(iPacket instanceof PublishPacket)) {
            return;
        }
        PublishPacket publishPacket = (PublishPacket)iPacket;
        if (publishPacket.getTopic().equals(Main.cfg.topic1)) {
            this.topic1Val = publishPacket.getValueString();
        }
        if (publishPacket.getTopic().equals(Main.cfg.topic2)) {
            this.topic2Val = publishPacket.getValueString();
        }
        this.userMessage = Main.cfg.topic1Header + " " + this.topic1Val + "\n" + Main.cfg.topic2Header + " " + this.topic2Val;
        tIcon.setToolTip(this.userMessage);
        if (publishPacket.getTopic().equals(TRIGGER_TOPIC)) {
            SwingUtilities.invokeLater(() -> tIcon.displayMessage("Trigger", publishPacket.getValueString(), TrayIcon.MessageType.INFO));
        }
    }

    private void run() {
        BufferedImage bufferedImage = ImageUtils.getSwingImage16("examples");
        PopupMenu popupMenu = new PopupMenu();
        this.makeMenu(popupMenu);
        tIcon = new TrayIcon(bufferedImage, "", popupMenu);
        tIcon.setImageAutoSize(true);
        tIcon.addMouseListener(this.makeMouseListener());
        SystemTray systemTray = SystemTray.getSystemTray();
        try {
            systemTray.add(tIcon);
        }
        catch (AWTException aWTException) {
            aWTException.printStackTrace();
        }
    }

    private void makeMenu(PopupMenu popupMenu) {
        MenuItem menuItem;
        if (Main.cfg.controlTopic != null) {
            menuItem = new MenuItem("Light ON");
            popupMenu.add(menuItem);
            menuItem.addActionListener(actionEvent -> this.setItem(Main.cfg.controlTopic, "ON"));
            menuItem = new MenuItem("Light OFF");
            popupMenu.add(menuItem);
            menuItem.addActionListener(actionEvent -> this.setItem(Main.cfg.controlTopic, "OFF"));
        }
        popupMenu.addSeparator();
        menuItem = new MenuItem("Exit");
        popupMenu.add(menuItem);
        menuItem.addActionListener(actionEvent -> this.stopMe());
    }

    private void setItem(String string, String string2) {
        try {
            new PublishPacket(string, string2).send();
        }
        catch (IOException iOException) {
            GlobalErrorHandler.handleError(ErrorType.IO, iOException);
        }
    }

    private void stopMe() {
        tray.remove(tIcon);
        System.exit(0);
    }

    private MouseListener makeMouseListener() {
        MouseListener mouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                if ((mouseEvent.getModifiers() & 0x10) != 0) {
                    tIcon.displayMessage("Smart House", Main.this.userMessage, TrayIcon.MessageType.INFO);
                }
            }

            @Override
            public void mouseEntered(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseExited(MouseEvent mouseEvent) {
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
            }
        };
        return mouseListener;
    }

    static {
        tray = SystemTray.getSystemTray();
    }
}

