/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp.proto;

import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import ru.dz.mqtt_udp.proto.TTR_Invalid;
import ru.dz.mqtt_udp.proto.TTR_PacketNumber;
import ru.dz.mqtt_udp.proto.TTR_Signature;
import ru.dz.mqtt_udp.util.MqttUdpRuntimeException;

public abstract class TaggedTailRecord {
    protected final int rawLength;
    protected final byte tag;

    public int getRawLength() {
        return this.rawLength;
    }

    public byte getTag() {
        return this.tag;
    }

    protected TaggedTailRecord(byte tag, int rawLngth) {
        this.tag = tag;
        this.rawLength = rawLngth;
    }

    public static Collection<TaggedTailRecord> fromBytesAll(byte[] raw, AtomicReference<Integer> signaturePos) {
        ArrayList<TaggedTailRecord> out = new ArrayList<TaggedTailRecord>();
        int sig_pos = -1;
        int len = raw.length;
        int eaten = 0;
        while (len - eaten > 0) {
            int tailLen = len - eaten;
            byte[] tail = new byte[tailLen];
            System.arraycopy(raw, eaten, tail, 0, tailLen);
            TaggedTailRecord ttr = TaggedTailRecord.fromBytes(tail);
            out.add(ttr);
            if (ttr instanceof TTR_Signature) {
                sig_pos = eaten;
            }
            eaten += ttr.getRawLength();
        }
        signaturePos.set(sig_pos);
        return out;
    }

    public static TaggedTailRecord fromBytes(byte[] raw) {
        int rawLength = 1;
        byte tag = raw[0];
        int dlen = 0;
        int pos = 1;
        while (true) {
            ++rawLength;
            byte b = raw[pos++];
            dlen |= b & 0xFFFFFF7F;
            if ((b & 0x80) == 0) break;
            dlen <<= 7;
        }
        byte[] rec = new byte[dlen];
        System.arraycopy(raw, pos, rec, 0, dlen);
        return TaggedTailRecord.decodeRecord(tag, rec, rawLength += dlen);
    }

    private static TaggedTailRecord decodeRecord(byte tag, byte[] rec, int rawLength) {
        switch (tag) {
            case 110: {
                return new TTR_PacketNumber(tag, rec, rawLength);
            }
            case 115: {
                return new TTR_Signature(tag, rec, rawLength);
            }
        }
        return new TTR_Invalid(tag, rawLength);
    }

    public abstract byte[] toBytes();

    public static byte[] toBytes(byte tag, byte[] data) {
        int len = data.length;
        if (len > 127 || len < 0) {
            throw new MqttUdpRuntimeException(String.format("TTR too long for tag %X", tag));
        }
        byte[] out = new byte[len + 2];
        out[0] = tag;
        out[1] = (byte)(len & 0x7F);
        System.arraycopy(data, 0, out, 2, len);
        return out;
    }

    public static int htonl(int value) {
        if (ByteOrder.nativeOrder().equals(ByteOrder.BIG_ENDIAN)) {
            return value;
        }
        return Integer.reverseBytes(value);
    }
}

