/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp.proto;

import java.util.Arrays;
import ru.dz.mqtt_udp.hmac.HMAC;
import ru.dz.mqtt_udp.proto.TaggedTailRecord;

public class TTR_Signature
extends TaggedTailRecord {
    private static final byte myTag = 115;
    public static final int SIGLEN = 18;
    private byte[] sig;

    public TTR_Signature(byte tag, byte[] rec, int rawLength) {
        super(tag, rawLength);
        this.sig = rec;
    }

    public TTR_Signature(byte[] signature) {
        super((byte)115, -1);
        this.sig = signature;
    }

    public boolean check(byte[] data, String keyString) {
        byte[] our = HMAC.hmacDigestMD5(data, keyString);
        return Arrays.equals(this.sig, our);
    }

    @Override
    public byte[] toBytes() {
        return TTR_Signature.toBytes(this.tag, this.sig);
    }

    public byte[] getSignature() {
        return this.sig;
    }

    public String toString() {
        return "TTR Signature";
    }
}

