/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp.items;

import java.io.IOException;
import java.net.InetAddress;
import java.time.LocalTime;
import ru.dz.mqtt_udp.IPacket;
import ru.dz.mqtt_udp.PingReqPacket;
import ru.dz.mqtt_udp.PingRespPacket;
import ru.dz.mqtt_udp.PublishPacket;
import ru.dz.mqtt_udp.SubscribePacket;
import ru.dz.mqtt_udp.items.TopicItem;
import ru.dz.mqtt_udp.util.GenericPacket;
import ru.dz.mqtt_udp.util.MqttUdpRuntimeException;

public abstract class AbstractItem {
    protected int packetType = -1;
    private String from = "?";
    private String time = AbstractItem.getCurrentTime();
    private boolean signed = false;

    protected AbstractItem(int packetType) {
        this.packetType = packetType;
    }

    protected AbstractItem(AbstractItem src) {
        this.from = src.from;
        this.time = src.time;
        this.signed = src.signed;
    }

    protected void assertHasTopic() {
        assert (this.typeWithTopic());
    }

    protected void assertHasNoTopic() {
        assert (!this.typeWithTopic());
    }

    public boolean typeWithTopic() {
        return this.packetType == 48 || this.packetType == 64 || this.packetType == 128 || this.packetType == 144 || this.packetType == 160 || this.packetType == 176;
    }

    public boolean isPingOrResponce() {
        return this.packetType == 192 || this.packetType == 208;
    }

    public boolean isPublish() {
        return this.packetType == 48;
    }

    private static String getCurrentTime() {
        return LocalTime.now().toString();
    }

    public void setFrom(String from) {
        this.from = from;
    }

    public String getFrom() {
        return this.from;
    }

    public String getTime() {
        return this.time;
    }

    public boolean isSigned() {
        return this.signed;
    }

    protected void setSigned(boolean signed) {
        this.signed = signed;
    }

    public void assignFrom(AbstractItem src) {
        this.packetType = src.packetType;
        this.from = src.from;
        this.time = src.time;
        this.signed = src.signed;
    }

    public GenericPacket toPacket() {
        switch (this.packetType) {
            case 192: {
                return new PingReqPacket();
            }
            case 208: {
                return new PingRespPacket();
            }
        }
        throw new MqttUdpRuntimeException("Unknown pkt type 0x" + Integer.toHexString(this.packetType));
    }

    public static AbstractItem fromPacket(IPacket p) {
        if (p instanceof PublishPacket) {
            PublishPacket pp = (PublishPacket)p;
            TopicItem ti = new TopicItem(p.getType(), pp.getTopic(), pp.getValueString());
            ti.setFrom(pp.getFrom().toString());
            ti.setSigned(p.isSigned());
            return ti;
        }
        if (p instanceof SubscribePacket) {
            SubscribePacket sp = (SubscribePacket)p;
            TopicItem ti = new TopicItem(128, sp.getTopic());
            ti.setFrom(p.getFrom().toString());
            ti.setSigned(p.isSigned());
            return ti;
        }
        if (p instanceof PingReqPacket) {
            TopicItem ti = new TopicItem(192);
            ti.setFrom(p.getFrom().toString());
            ti.setSigned(p.isSigned());
            return ti;
        }
        if (p instanceof PingRespPacket) {
            TopicItem ti = new TopicItem(208);
            ti.setFrom(p.getFrom().toString());
            ti.setSigned(p.isSigned());
            return ti;
        }
        System.out.println(p);
        TopicItem ti = new TopicItem(0, "UnknownPacket", p.toString());
        ti.setFrom(p.getFrom().toString());
        ti.setSigned(p.isSigned());
        return ti;
    }

    public void sendToAll() throws IOException {
        GenericPacket pkt = this.toPacket();
        pkt.send();
    }

    public void sendTo(InetAddress addr) throws IOException {
        GenericPacket pkt = this.toPacket();
        pkt.send(addr);
    }
}

