/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import ru.dz.mqtt_udp.IPacket;
import ru.dz.mqtt_udp.io.IPacketAddress;
import ru.dz.mqtt_udp.util.NoEncodingRuntimeException;
import ru.dz.mqtt_udp.util.TopicPacket;

public class PublishPacket
extends TopicPacket {
    private byte[] value;

    public PublishPacket(byte[] raw, byte flags, IPacketAddress from) {
        super(from);
        this.flags = flags;
        int tlen = IPacket.decodeTopicLen(raw);
        this.topic = new String(raw, 2, tlen, Charset.forName("UTF-8"));
        int vlen = raw.length - tlen - 2;
        this.value = new byte[vlen];
        System.arraycopy(raw, tlen + 2, this.value, 0, vlen);
    }

    public byte[] getValueRaw() {
        return this.value;
    }

    public String getValueString() {
        return new String(this.value, Charset.forName("UTF-8"));
    }

    public PublishPacket(String topic, byte flags, byte[] value) {
        super(null);
        this.makeMe(topic, flags, value);
    }

    public PublishPacket(String topic, String value) {
        super(null);
        try {
            this.makeMe(topic, (byte)0, value.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new NoEncodingRuntimeException(e);
        }
    }

    public PublishPacket(String topic, byte flags, String value) {
        super(null);
        try {
            this.makeMe(topic, flags, value.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new NoEncodingRuntimeException(e);
        }
    }

    private void makeMe(String topic, byte flags, byte[] value) {
        this.topic = topic;
        this.flags = flags;
        this.value = value;
    }

    @Override
    public byte[] toBytes() {
        byte[] tbytes;
        try {
            tbytes = this.topic.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new NoEncodingRuntimeException(e);
        }
        int plen = tbytes.length + this.value.length + 2;
        byte[] pkt = new byte[plen];
        pkt[0] = (byte)(tbytes.length >> 8 & 0xFF | this.flags & 0xF);
        pkt[1] = (byte)(tbytes.length & 0xFF);
        System.arraycopy(tbytes, 0, pkt, 2, tbytes.length);
        System.arraycopy(this.value, 0, pkt, tbytes.length + 2, this.value.length);
        return IPacket.encodeTotalLength(pkt, 48, this.flags, null);
    }

    @Override
    public String toString() {
        return String.format("MQTT/UDP PUBLISH '%s'='%s'", this.getTopic(), this.getValueString());
    }

    @Override
    public byte getFlags() {
        return this.flags;
    }

    @Override
    public int getType() {
        return 48;
    }
}

