/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import ru.dz.mqtt_udp.IPacket;
import ru.dz.mqtt_udp.IPacketMultiSource;
import ru.dz.mqtt_udp.SubServer;
import ru.dz.mqtt_udp.items.AbstractItem;

public class PacketSourceMultiServer
extends SubServer
implements IPacketMultiSource {
    private List<Consumer<IPacket>> plist = new ArrayList<Consumer<IPacket>>();
    private List<Consumer<AbstractItem>> ilist = new ArrayList<Consumer<AbstractItem>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addPacketSink(Consumer<IPacket> sink) {
        List<Consumer<IPacket>> list = this.plist;
        synchronized (list) {
            this.plist.add(sink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePacketSink(Consumer<IPacket> sink) {
        List<Consumer<IPacket>> list = this.plist;
        synchronized (list) {
            this.plist.remove(sink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addItemSink(Consumer<AbstractItem> sink) {
        List<Consumer<AbstractItem>> list = this.ilist;
        synchronized (list) {
            this.ilist.add(sink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeItemSink(Consumer<AbstractItem> sink) {
        List<Consumer<AbstractItem>> list = this.ilist;
        synchronized (list) {
            this.ilist.remove(sink);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void processPacket(IPacket p) throws IOException {
        List<Consumer<Object>> list = this.ilist;
        synchronized (list) {
            if (this.ilist.size() > 0) {
                AbstractItem ai = AbstractItem.fromPacket(p);
                for (Consumer<AbstractItem> isink : this.ilist) {
                    isink.accept(ai);
                }
            }
        }
        list = this.plist;
        synchronized (list) {
            for (Consumer<IPacket> psink : this.plist) {
                psink.accept(p);
            }
        }
    }
}

