/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp.util;

import java.util.concurrent.atomic.AtomicLong;
import ru.dz.mqtt_udp.util.LoopRunner;

public class Throttle {
    private long last_send_time = 0L;
    private AtomicLong last_send_count = new AtomicLong(0L);
    private int max_seq_packets = 3;
    private int throttle = 100;

    private static long timeMsec() {
        return System.currentTimeMillis();
    }

    public void setThrottle(int msec) {
        this.throttle = msec;
    }

    public void throttle() {
        if (this.throttle == 0) {
            return;
        }
        long last_send_count_delta = this.last_send_count.incrementAndGet();
        if (last_send_count_delta < (long)this.max_seq_packets) {
            return;
        }
        this.last_send_count.addAndGet(this.max_seq_packets);
        long now = Throttle.timeMsec();
        long since_last_pkt = now - this.last_send_time;
        if (this.last_send_time == 0L) {
            this.last_send_time = now;
            return;
        }
        this.last_send_time = now;
        long towait = (long)(this.max_seq_packets * this.throttle) - since_last_pkt;
        if (towait <= 0L) {
            return;
        }
        LoopRunner.sleep(towait);
    }
}

