/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp.config;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import ru.dz.mqtt_udp.IPacket;
import ru.dz.mqtt_udp.IPacketMultiSource;
import ru.dz.mqtt_udp.PublishPacket;
import ru.dz.mqtt_udp.SubscribePacket;
import ru.dz.mqtt_udp.items.TopicItem;

public class Provider
implements Consumer<IPacket> {
    private Map<String, TopicItem> items = new HashMap<String, TopicItem>();

    public Provider(IPacketMultiSource ms) {
        ms.addPacketSink(this);
    }

    public void addTopic(String topicName, String topicValue) {
        this.items.put(topicName, new TopicItem(48, topicName, topicValue));
    }

    @Override
    public void accept(IPacket t) {
        if (!(t instanceof SubscribePacket)) {
            return;
        }
        SubscribePacket sp = (SubscribePacket)t;
        if (!this.items.containsKey(sp.getTopic())) {
            return;
        }
        TopicItem it = this.items.get(sp.getTopic());
        PublishPacket pp = new PublishPacket(it.getTopic(), it.getValue());
        try {
            pp.send();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

