/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp;

import java.io.IOException;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import ru.dz.mqtt_udp.PacketSourceMultiServer;
import ru.dz.mqtt_udp.config.Provider;
import ru.dz.mqtt_udp.config.Requester;

public class RequesterProviderTest {
    private static final String T1 = "test/java/t1";
    private static final String T1V = "test value 1";
    private static final String T2 = "test/java/t3";
    private static final String T2V = "test value 2";
    private static final String T3 = "test/java/t3";
    private static final String T3V = "test value 3";
    private static final String TO = "timeout/";
    private static PacketSourceMultiServer ms;
    private static Provider p;
    private static Requester r;

    @BeforeClass
    public static void setUpClass() throws Exception {
        ms = new PacketSourceMultiServer();
        p = new Provider(ms);
        r = new Requester(ms);
        ms.requestStart();
    }

    @Test(timeout=4000L)
    public void testExchange() throws IOException {
        p.addTopic(T1, T1V);
        p.addTopic("test/java/t3", T2V);
        p.addTopic("test/java/t3", T3V);
        r.addTopic(T1);
        r.addTopic("test/java/t3");
        r.addTopic("test/java/t3");
        Assert.assertTrue((boolean)r.waitForAll(1000L));
    }

    @Test
    public void testTimeout() throws IOException {
        r.setCheckLoopTime(1000L);
        r.startBackgroundRequests();
        r.addTopic("timeout/test/java/t1");
        r.addTopic("timeout/test/java/t3");
        r.addTopic("timeout/test/java/t3");
        p.addTopic("timeout/test/java/t1", T1V);
        p.addTopic("timeout/test/java/t3", T2V);
        p.addTopic("timeout/test/java/t3", T3V);
        Assert.assertTrue((boolean)r.waitForAll(4000L));
    }
}

