/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp.config_server;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import java.util.function.BiConsumer;
import ru.dz.mqtt_udp.PacketSourceMultiServer;
import ru.dz.mqtt_udp.config.Provider;

public class ConfigServerMain {
    private static String propertiesPath = "remote_config.items";

    public static void main(String[] stringArray) {
        PacketSourceMultiServer packetSourceMultiServer = new PacketSourceMultiServer();
        Provider provider = new Provider(packetSourceMultiServer);
        Properties properties = new Properties();
        try (FileInputStream fileInputStream = new FileInputStream(propertiesPath);){
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.err.println("File " + propertiesPath + " not found");
            return;
        }
        catch (IOException iOException) {
            System.err.println("File " + propertiesPath + " read IO Error: " + iOException);
            return;
        }
        properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(object, object2) -> {
            provider.addTopic((String)object, (String)object2);
            System.out.println("Serving " + object + " = " + object2);
        }));
        packetSourceMultiServer.requestStart();
    }
}

