/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp.config;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import ru.dz.mqtt_udp.io.IPacketAddress;
import ru.dz.mqtt_udp.util.ErrorType;
import ru.dz.mqtt_udp.util.GlobalErrorHandler;

public class ConfigurableHost
implements Comparable<ConfigurableHost> {
    private String ident;
    private IPacketAddress src;

    public ConfigurableHost(String ident, IPacketAddress src) {
        this.ident = ident;
        this.src = src;
    }

    public int hashCode() {
        return this.ident.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConfigurableHost)) {
            return false;
        }
        ConfigurableHost b = (ConfigurableHost)obj;
        return b.ident.equals(this.ident);
    }

    @Override
    public int compareTo(ConfigurableHost b) {
        return this.ident.compareTo(b.ident);
    }

    public boolean isSameAs(ConfigurableHost ch) {
        if (ch == null) {
            return false;
        }
        if (!this.ident.equals(ch.ident)) {
            return false;
        }
        String ipa = this.src.getInetAddress().getHostAddress();
        String ipb = ch.src.getInetAddress().getHostAddress();
        return ipa.equals(ipb);
    }

    public String toString() {
        return String.format("%s@%s", this.ident, this.src.getInetAddress().getHostAddress());
    }

    public String getMacAddressString() {
        return this.ident;
    }

    public String getIpAddressString() {
        return this.src.getInetAddress().toString();
    }

    public static String getMachineMacAddressString() {
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            byte[] mac = network.getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            int i = 0;
            while (i < mac.length) {
                sb.append(String.format("%02X", mac[i]));
                ++i;
            }
            System.out.println(sb.toString());
            return sb.toString();
        }
        catch (UnknownHostException e) {
            GlobalErrorHandler.handleError(ErrorType.IO, e);
        }
        catch (SocketException e) {
            GlobalErrorHandler.handleError(ErrorType.IO, e);
        }
        return null;
    }
}

