/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp.proto;

import ru.dz.mqtt_udp.proto.TaggedTailRecord;

public class TTR_AbstractInteger64
extends TaggedTailRecord {
    private long value;

    public TTR_AbstractInteger64(byte tag, byte[] rec, int rawLength) {
        super(tag, rawLength);
        long n = 0L;
        int i = 0;
        while (i < 8) {
            n |= (long)(rec[i] << 8 * (8 - i - 1));
            ++i;
        }
        this.value = n;
    }

    public TTR_AbstractInteger64(byte tag, long number) {
        super(tag, -1);
        this.value = number;
    }

    @Override
    public byte[] toBytes() {
        byte[] out = new byte[8];
        int i = 0;
        while (i < 8) {
            out[i] = (byte)(this.value >> 8 * (8 - i - 1));
            ++i;
        }
        return TTR_AbstractInteger64.toBytes(this.tag, out);
    }

    public long getValue() {
        return this.value;
    }
}

