/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import ru.dz.mqtt_udp.Engine;
import ru.dz.mqtt_udp.IPacket;
import ru.dz.mqtt_udp.IPacketMultiSource;
import ru.dz.mqtt_udp.MqttProtocolException;
import ru.dz.mqtt_udp.PacketSourceMultiServer;
import ru.dz.mqtt_udp.PublishPacket;
import ru.dz.mqtt_udp.SubscribePacket;
import ru.dz.mqtt_udp.TopicFilter;
import ru.dz.mqtt_udp.config.ConfigurableParameter;
import ru.dz.mqtt_udp.config.LocalConfigurableParameter;
import ru.dz.mqtt_udp.config.LocalReadOnlyParameter;
import ru.dz.mqtt_udp.util.ErrorType;
import ru.dz.mqtt_udp.util.GlobalErrorHandler;
import ru.dz.mqtt_udp.util.LoopRunner;

public class RemoteConfig
implements Consumer<IPacket> {
    private LoopRunner lr = new LoopRunner("Remote Config Controllable"){

        @Override
        protected void step() throws IOException, MqttProtocolException {
            1.sleep(30000L);
        }

        @Override
        protected void onStop() throws IOException, MqttProtocolException {
        }

        @Override
        protected void onStart() throws IOException, MqttProtocolException {
        }
    };
    private Collection<ConfigurableParameter> items;
    private static final String SYS_CONF_WILD = "$SYS/conf/#";
    private TopicFilter rf = new TopicFilter("$SYS/conf/#");
    private String fName;
    private Properties props = new Properties();

    public RemoteConfig(IPacketMultiSource ms, Collection<ConfigurableParameter> items) {
        this.items = items;
        ms.addPacketSink(this);
    }

    public void requestStart() {
        this.lr.requestStart();
    }

    @Override
    public void accept(IPacket p) {
        if (p instanceof SubscribePacket) {
            SubscribePacket sp = (SubscribePacket)p;
            if (this.rf.test(sp.getTopic())) {
                this.sendAllConfigurableTopics();
                return;
            }
            this.sendConfigurableTopic(sp.getTopic());
        }
        if (p instanceof PublishPacket) {
            PublishPacket pp = (PublishPacket)p;
            this.setLocalValue(pp);
        }
    }

    private void setLocalValue(PublishPacket pp) {
        this.items.forEach(item -> {
            if (item.topicIs(pp.getTopic())) {
                item.setValue(pp.getValueString());
            }
        });
    }

    private void sendConfigurableTopic(String topic) {
        this.items.forEach(item -> {
            if (item.topicIs(topic)) {
                item.sendCurrentValue();
            }
        });
    }

    private void sendAllConfigurableTopics() {
        this.items.forEach(item -> item.sendCurrentValue());
    }

    public void setPropertiesFileName(String fName) {
        this.fName = fName;
    }

    public void loadFromProperties() {
        FileInputStream inStream;
        try {
            inStream = new FileInputStream(new File(this.fName));
        }
        catch (FileNotFoundException e) {
            GlobalErrorHandler.handleError(ErrorType.IO, e);
            return;
        }
        try {
            try {
                this.props.load(inStream);
                this.props.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name, val) -> {
                    String[] names = name.toString().split("/");
                    this.items.forEach(item -> {
                        if (item.getKind().equals(names[0]) && item.getName().equals(names[1])) {
                            item.setValue(val.toString());
                        }
                    });
                }));
            }
            catch (IOException e) {
                GlobalErrorHandler.handleError(ErrorType.IO, e);
                try {
                    inStream.close();
                }
                catch (IOException e2) {
                    GlobalErrorHandler.handleError(ErrorType.IO, e2);
                }
            }
        }
        finally {
            try {
                inStream.close();
            }
            catch (IOException e) {
                GlobalErrorHandler.handleError(ErrorType.IO, e);
            }
        }
    }

    public void saveToProperties() {
        FileOutputStream out;
        this.items.forEach(item -> {
            if (!(item instanceof LocalReadOnlyParameter)) {
                String key = String.valueOf(item.getKind()) + "/" + item.getName();
                this.props.setProperty(key, item.getValue());
            }
        });
        try {
            out = new FileOutputStream(new File(this.fName));
        }
        catch (FileNotFoundException e) {
            GlobalErrorHandler.handleError(ErrorType.IO, e);
            return;
        }
        try {
            try {
                this.props.store(out, "MQTT/UDP remote config storage");
            }
            catch (IOException e) {
                GlobalErrorHandler.handleError(ErrorType.IO, e);
                try {
                    out.close();
                }
                catch (IOException e2) {
                    GlobalErrorHandler.handleError(ErrorType.IO, e2);
                }
            }
        }
        finally {
            try {
                out.close();
            }
            catch (IOException e) {
                GlobalErrorHandler.handleError(ErrorType.IO, e);
            }
        }
    }

    public static void main(String[] args) {
        HashSet<ConfigurableParameter> itemList = new HashSet<ConfigurableParameter>();
        itemList.add(new LocalReadOnlyParameter("info", "soft", "Tray Informer"));
        itemList.add(new LocalReadOnlyParameter("info", "ver", Engine.getVersionString()));
        itemList.add(new LocalReadOnlyParameter("info", "uptime", "?"));
        itemList.add(new LocalConfigurableParameter("node", "name", "Tray Informer"));
        itemList.add(new LocalConfigurableParameter("node", "location", "Desk PC"));
        itemList.add(new LocalConfigurableParameter("topic", "test1", "Trigger"));
        PacketSourceMultiServer ms = new PacketSourceMultiServer();
        RemoteConfig rc = new RemoteConfig(ms, itemList);
        ms.requestStart();
        rc.requestStart();
        rc.setPropertiesFileName("remoteconf.prop");
        rc.saveToProperties();
    }
}

