/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp;

import java.io.IOException;
import java.net.DatagramSocket;
import ru.dz.mqtt_udp.IPacket;
import ru.dz.mqtt_udp.MqttProtocolException;
import ru.dz.mqtt_udp.PingReqPacket;
import ru.dz.mqtt_udp.PingRespPacket;
import ru.dz.mqtt_udp.io.SingleSendSocket;
import ru.dz.mqtt_udp.util.GenericPacket;
import ru.dz.mqtt_udp.util.LoopRunner;

public abstract class SubServer
extends LoopRunner {
    private DatagramSocket ss = SingleSendSocket.get();
    private DatagramSocket s;
    private boolean muted = false;

    public SubServer() {
        super("MQTT UDP Recv");
    }

    @Override
    protected void onStart() throws IOException, MqttProtocolException {
        this.s = GenericPacket.recvSocket();
    }

    @Override
    protected void step() throws IOException, MqttProtocolException {
        IPacket p = GenericPacket.recv(this.s);
        if (!this.muted) {
            this.preprocessPacket(p);
        }
        this.processPacket(p);
    }

    @Override
    protected void onStop() throws IOException, MqttProtocolException {
        this.s.close();
    }

    public boolean isMuted() {
        return this.muted;
    }

    public void setMuted(boolean muted) {
        this.muted = muted;
    }

    protected abstract void processPacket(IPacket var1) throws IOException;

    private void preprocessPacket(IPacket p) throws IOException {
        if (p instanceof PingReqPacket) {
            PingRespPacket presp = new PingRespPacket();
            presp.send(this.ss);
        }
    }
}

