/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicReference;
import ru.dz.mqtt_udp.Engine;
import ru.dz.mqtt_udp.MqttProtocolException;
import ru.dz.mqtt_udp.PingReqPacket;
import ru.dz.mqtt_udp.PingRespPacket;
import ru.dz.mqtt_udp.PublishPacket;
import ru.dz.mqtt_udp.SubscribePacket;
import ru.dz.mqtt_udp.hmac.HMAC;
import ru.dz.mqtt_udp.io.IPacketAddress;
import ru.dz.mqtt_udp.proto.TTR_PacketNumber;
import ru.dz.mqtt_udp.proto.TTR_Signature;
import ru.dz.mqtt_udp.proto.TaggedTailRecord;
import ru.dz.mqtt_udp.util.ErrorType;
import ru.dz.mqtt_udp.util.GenericPacket;
import ru.dz.mqtt_udp.util.GlobalErrorHandler;

public interface IPacket {
    public static final String MQTT_CHARSET = "UTF-8";
    public static final String[] pTYpeNames = new String[]{"? NULL", "Connect", "ConnAck", "Publish", "PubAck", "PubRec", "PubRel", "PubComp", "Subscribe", "SubAck", "UnSubscribe", "UnSubAck", "PingReq", "PingResp", "Disconnect", "? 0xFF"};

    public byte[] toBytes();

    public IPacketAddress getFrom();

    public int getType();

    public static IPacket fromBytes(byte[] raw, IPacketAddress from) throws MqttProtocolException {
        GenericPacket p;
        int total_len = 0;
        int headerEnd = 1;
        while (true) {
            byte b = raw[headerEnd++];
            total_len |= b & 0xFFFFFF7F;
            if ((b & 0x80) == 0) break;
            total_len <<= 7;
        }
        int recvLen = raw.length - headerEnd;
        Collection<TaggedTailRecord> ttrs = null;
        if (recvLen < total_len) {
            throw new MqttProtocolException("packet decoded size (" + total_len + ") > packet length (" + recvLen + ")");
        }
        if (recvLen > total_len) {
            ttrs = IPacket.decodeTTRs(raw, total_len, headerEnd, recvLen);
        }
        byte[] sub = new byte[total_len];
        System.arraycopy(raw, headerEnd, sub, 0, total_len);
        int ptype = 0xF0 & raw[0];
        int flags = 0xF & raw[0];
        switch (ptype) {
            case 48: {
                p = new PublishPacket(sub, (byte)flags, from);
                break;
            }
            case 192: {
                p = new PingReqPacket(sub, (byte)flags, from);
                break;
            }
            case 208: {
                p = new PingRespPacket(sub, (byte)flags, from);
                break;
            }
            case 128: {
                p = new SubscribePacket(sub, (byte)flags, from);
                break;
            }
            default: {
                throw new MqttProtocolException("Unknown pkt type " + raw[0]);
            }
        }
        return p.applyTTRs(ttrs);
    }

    public static Collection<TaggedTailRecord> decodeTTRs(byte[] raw, int total_len, int headerEnd, int recvLen) throws MqttProtocolException {
        int tail_len = recvLen - total_len;
        byte[] ttrs_bytes = new byte[tail_len];
        System.arraycopy(raw, total_len + headerEnd, ttrs_bytes, 0, tail_len);
        AtomicReference<Integer> signaturePos = new AtomicReference<Integer>(-1);
        Collection<TaggedTailRecord> ttrs = TaggedTailRecord.fromBytesAll(ttrs_bytes, signaturePos);
        int sigPos = signaturePos.get();
        if (sigPos < 0 && Engine.isSignatureRequired()) {
            throw new MqttProtocolException("Unsigned packet");
        }
        if (sigPos >= 0) {
            sigPos += total_len;
            byte[] sig_check_bytes = new byte[sigPos += headerEnd];
            System.arraycopy(raw, 0, sig_check_bytes, 0, sigPos);
            for (TaggedTailRecord ttr : ttrs) {
                if (!(ttr instanceof TTR_Signature)) continue;
                TTR_Signature ts = (TTR_Signature)ttr;
                boolean sigCorrect = ts.check(sig_check_bytes, Engine.getSignatureKey());
                if (sigCorrect) break;
                throw new MqttProtocolException("Incorrect packet signature");
            }
        }
        return ttrs;
    }

    public static int decodeTopicLen(byte[] pkt) {
        int ret = 0;
        ret = pkt[0] << 8 | pkt[1];
        return ret &= 0xFFFF;
    }

    public static byte[] encodeTotalLength(byte[] pkt, int packetType, byte flags, AbstractCollection<TaggedTailRecord> ttr) {
        int data_len = pkt.length;
        byte[] buf = new byte[4];
        int bp = 1;
        buf[0] = (byte)(packetType & 0xF0 | flags & 0xF);
        do {
            byte b = (byte)(data_len % 128);
            if ((data_len /= 128) > 0) {
                b = (byte)(b | 0x80);
            }
            buf[bp++] = b;
        } while (data_len > 0);
        int tlen = pkt.length + bp;
        byte[] out = new byte[tlen];
        System.arraycopy(buf, 0, out, 0, bp);
        System.arraycopy(pkt, 0, out, bp, pkt.length);
        byte[] ttrbin = IPacket.encodeTTR(ttr, out);
        return ttrbin;
    }

    public static byte[] encodeTTR(AbstractCollection<TaggedTailRecord> ttrs, byte[] packetBeginning) {
        ArrayList<byte[]> outs = new ArrayList<byte[]>();
        boolean haveNumber = false;
        if (ttrs != null) {
            for (TaggedTailRecord r : ttrs) {
                if (r instanceof TTR_Signature) {
                    GlobalErrorHandler.handleError(ErrorType.Protocol, "Signature must be generated here");
                    continue;
                }
                if (r instanceof TTR_PacketNumber) {
                    haveNumber = true;
                }
                outs.add(r.toBytes());
            }
        }
        if (!haveNumber) {
            outs.add(new TTR_PacketNumber().toBytes());
        }
        int totalLen = packetBeginning.length;
        for (byte[] bb : outs) {
            totalLen += bb.length;
        }
        byte[] presig = new byte[totalLen + 18];
        System.arraycopy(packetBeginning, 0, presig, 0, packetBeginning.length);
        int pos = packetBeginning.length;
        for (byte[] bb : outs) {
            System.arraycopy(bb, 0, presig, pos, bb.length);
            pos += bb.length;
        }
        byte[] toSign = new byte[totalLen];
        System.arraycopy(presig, 0, toSign, 0, totalLen);
        byte[] signature = HMAC.hmacDigestMD5(toSign, Engine.getSignatureKey());
        TTR_Signature sig = new TTR_Signature(signature);
        byte[] sigBytes = sig.toBytes();
        System.arraycopy(sigBytes, 0, presig, pos, 18);
        return presig;
    }

    public static String getPacketTypeName(int packetType) {
        int pos = packetType >> 4;
        if (pos < 0 || pos > 15) {
            return "?";
        }
        return pTYpeNames[pos];
    }

    public boolean isSigned();
}

