/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp.items;

import ru.dz.mqtt_udp.IPacket;
import ru.dz.mqtt_udp.PublishPacket;
import ru.dz.mqtt_udp.items.AbstractItem;
import ru.dz.mqtt_udp.util.GenericPacket;

public class TopicItem
extends AbstractItem {
    private String topic;
    private String value;

    public TopicItem(int packetType) {
        super(packetType);
        this.assertHasNoTopic();
    }

    public TopicItem(int packetType, String topic) {
        super(packetType);
        this.topic = topic;
        this.value = "";
        this.assertHasTopic();
    }

    public TopicItem(int packetType, String topic, String value) {
        super(packetType);
        this.topic = topic;
        this.value = value;
        this.assertHasTopic();
    }

    public TopicItem(TopicItem src) {
        super(src);
        this.packetType = src.packetType;
        this.topic = src.topic;
        this.value = src.value;
    }

    public String toString() {
        if (this.packetType == 48) {
            return this.getTime() + ":  " + this.topic + "=" + this.value;
        }
        if (this.typeWithTopic()) {
            return this.getTime() + ":  " + IPacket.getPacketTypeName(this.packetType) + " \ttopic=" + this.topic;
        }
        return this.getTime() + ":  " + IPacket.getPacketTypeName(this.packetType);
    }

    public String getTopic() {
        return this.topic;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void assignFrom(TopicItem src) {
        this.topic = src.topic;
        this.value = src.value;
        super.assignFrom(src);
    }

    public boolean sameTopic(TopicItem t) {
        return this.getTopic().equals(t.getTopic());
    }

    public boolean sameHostAndTopic(TopicItem t) {
        return this.getTopic().equals(t.getTopic()) && this.getFrom().equals(t.getFrom());
    }

    @Override
    public GenericPacket toPacket() {
        switch (this.packetType) {
            case 48: {
                return new PublishPacket(this.topic, this.value);
            }
        }
        return super.toPacket();
    }
}

