/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp.tray;

import java.awt.AWTException;
import java.awt.MenuItem;
import java.awt.PopupMenu;
import java.awt.SystemTray;
import java.awt.TrayIcon;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JOptionPane;
import ru.dz.mqtt_udp.IPacket;
import ru.dz.mqtt_udp.PacketSourceServer;
import ru.dz.mqtt_udp.PublishPacket;
import ru.dz.mqtt_udp.tray.Config;
import ru.dz.mqtt_udp.util.image.ImageUtils;

public class Main {
    private static TrayIcon tIcon;
    private static SystemTray tray;
    private String topic1Val = "?";
    private String topic2Val = "?";
    private String userMessage = "No data received";
    private static Config cfg;

    static {
        tray = SystemTray.getSystemTray();
    }

    public static void main(String[] args) {
        try {
            cfg = new Config();
        }
        catch (FileNotFoundException e) {
            JOptionPane.showMessageDialog(null, "mqttudptray.ini not found");
            return;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, "io error");
            return;
        }
        Main m = new Main();
        m.run();
        PacketSourceServer ss = new PacketSourceServer();
        ss.setSink(pkt -> m.processPkt((IPacket)pkt));
    }

    private void processPkt(IPacket pkt) {
        if (!(pkt instanceof PublishPacket)) {
            return;
        }
        PublishPacket pp = (PublishPacket)pkt;
        if (pp.getTopic().equals(Main.cfg.topic1)) {
            this.topic1Val = pp.getValueString();
        }
        if (pp.getTopic().equals(Main.cfg.topic2)) {
            this.topic2Val = pp.getValueString();
        }
        this.userMessage = String.valueOf(Main.cfg.topic1Header) + " " + this.topic1Val + "\n" + Main.cfg.topic2Header + " " + this.topic2Val;
        tIcon.setToolTip(this.userMessage);
    }

    private void run() {
        BufferedImage image = ImageUtils.getSwingImage16("examples");
        PopupMenu trayMenu = new PopupMenu();
        this.makeMenu(trayMenu);
        tIcon = new TrayIcon(image, "", trayMenu);
        tIcon.setImageAutoSize(true);
        tIcon.addMouseListener(this.makeMouseListener());
        SystemTray tray = SystemTray.getSystemTray();
        try {
            tray.add(tIcon);
        }
        catch (AWTException e1) {
            e1.printStackTrace();
        }
    }

    private void makeMenu(PopupMenu trayMenu) {
        MenuItem mi;
        if (Main.cfg.controlTopic != null) {
            mi = new MenuItem("Light ON");
            trayMenu.add(mi);
            mi.addActionListener(e -> this.setItem(Main.cfg.controlTopic, "ON"));
            mi = new MenuItem("Light OFF");
            trayMenu.add(mi);
            mi.addActionListener(e -> this.setItem(Main.cfg.controlTopic, "OFF"));
        }
        trayMenu.addSeparator();
        mi = new MenuItem("Exit");
        trayMenu.add(mi);
        mi.addActionListener(e -> this.stopMe());
    }

    private void setItem(String topic, String val) {
        try {
            new PublishPacket(topic, val).send();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void stopMe() {
        tray.remove(tIcon);
        System.exit(0);
    }

    private MouseListener makeMouseListener() {
        MouseListener mouseListener = new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if ((e.getModifiers() & 0x10) != 0) {
                    tIcon.displayMessage("Smart House", Main.this.userMessage, TrayIcon.MessageType.INFO);
                }
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseReleased(MouseEvent e) {
            }
        };
        return mouseListener;
    }
}

