/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import ru.dz.mqtt_udp.IPacket;
import ru.dz.mqtt_udp.io.IPacketAddress;
import ru.dz.mqtt_udp.util.NoEncodingRuntimeException;
import ru.dz.mqtt_udp.util.TopicPacket;

public class SubscribePacket
extends TopicPacket {
    public SubscribePacket(byte[] raw, byte flags, IPacketAddress from) {
        super(from);
        this.flags = flags;
        int tlen = IPacket.decodeTopicLen(raw);
        this.topic = new String(raw, 2, tlen, Charset.forName("UTF-8"));
    }

    public SubscribePacket(String topic, byte flags) {
        super(null);
        this.makeMe(topic, flags);
    }

    public SubscribePacket(String topic) {
        super(null);
        this.makeMe(topic, (byte)0);
    }

    private void makeMe(String topic, byte flags) {
        this.topic = topic;
        this.flags = flags;
    }

    @Override
    public byte[] toBytes() {
        byte[] tbytes;
        try {
            tbytes = this.topic.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new NoEncodingRuntimeException(e);
        }
        int plen = tbytes.length + 2 + 1;
        byte[] pkt = new byte[plen];
        pkt[0] = (byte)(tbytes.length >> 8 & 0xFF | this.flags & 0xF);
        pkt[1] = (byte)(tbytes.length & 0xFF);
        System.arraycopy(tbytes, 0, pkt, 2, tbytes.length);
        pkt[tbytes.length + 2] = 0;
        return IPacket.encodeTotalLength(pkt, 128, this.flags);
    }

    @Override
    public String toString() {
        return String.format("MQTT/UDP SUBSCRIBE '%s'", this.getTopic());
    }

    @Override
    public int getType() {
        return 128;
    }
}

