/*
 * Decompiled with CFR 0.152.
 */
package ru.dz.mqtt_udp;

import ru.dz.mqtt_udp.MqttProtocolException;
import ru.dz.mqtt_udp.PingReqPacket;
import ru.dz.mqtt_udp.PingRespPacket;
import ru.dz.mqtt_udp.PublishPacket;
import ru.dz.mqtt_udp.SubscribePacket;
import ru.dz.mqtt_udp.io.IPacketAddress;

public interface IPacket {
    public static final String MQTT_CHARSET = "UTF-8";
    public static final String[] pTYpeNames = new String[]{"? NULL", "Connect", "ConnAck", "Publish", "PubAck", "PubRec", "PubRel", "PubComp", "Subscribe", "SubAck", "UnSubscribe", "UnSubAck", "PingReq", "PingResp", "Disconnect", "? 0xFF"};

    public byte[] toBytes();

    public IPacketAddress getFrom();

    public int getType();

    public static IPacket fromBytes(byte[] raw, IPacketAddress from) throws MqttProtocolException {
        int dlen = 0;
        int pos = 1;
        while (true) {
            byte b = raw[pos++];
            dlen |= b & 0xFFFFFF7F;
            if ((b & 0x80) == 0) break;
            dlen <<= 7;
        }
        int slen = raw.length - pos;
        if (slen > dlen) {
            slen = dlen;
        }
        if (slen < dlen) {
            throw new MqttProtocolException("packet decoded size (" + dlen + ") > packet length (" + slen + ")");
        }
        byte[] sub = new byte[slen];
        System.arraycopy(raw, pos, sub, 0, slen);
        int ptype = 0xF0 & raw[0];
        int flags = 0xF & raw[0];
        switch (ptype) {
            case 48: {
                return new PublishPacket(sub, (byte)flags, from);
            }
            case 192: {
                return new PingReqPacket(sub, (byte)flags, from);
            }
            case 208: {
                return new PingRespPacket(sub, (byte)flags, from);
            }
            case 128: {
                return new SubscribePacket(sub, (byte)flags, from);
            }
        }
        throw new MqttProtocolException("Unknown pkt type " + raw[0]);
    }

    public static int decodeTopicLen(byte[] pkt) {
        int ret = 0;
        ret = pkt[0] << 8 | pkt[1];
        return ret &= 0xFFFF;
    }

    public static byte[] encodeTotalLength(byte[] pkt, int packetType, byte flags) {
        int data_len = pkt.length;
        byte[] buf = new byte[4];
        int bp = 1;
        buf[0] = (byte)(packetType & 0xF0 | flags & 0xF);
        do {
            byte b = (byte)(data_len % 128);
            if ((data_len /= 128) > 0) {
                b = (byte)(b | 0x80);
            }
            buf[bp++] = b;
        } while (data_len > 0);
        int tlen = pkt.length + bp;
        byte[] out = new byte[tlen];
        System.arraycopy(buf, 0, out, 0, bp);
        System.arraycopy(pkt, 0, out, bp, pkt.length);
        return out;
    }

    public static String getPacketTypeName(int packetType) {
        int pos = packetType >> 4;
        if (pos < 0 || pos > 15) {
            return "?";
        }
        return pTYpeNames[pos];
    }
}

